package com.sdk;

import java.util.ArrayList;

import com.sdk.AlarmCallBack_PF;

import android.view.Surface;


public class NetDEVSDK {
	static {
		System.loadLibrary("Curl");
		System.loadLibrary("RSA");
		System.loadLibrary("MP4");
		System.loadLibrary("MP2");
		System.loadLibrary("mXML");
		System.loadLibrary("NDRtmp");
		System.loadLibrary("CloudSDK");
		System.loadLibrary("RM_Module");
		System.loadLibrary("dspvideomjpeg");
		System.loadLibrary("NDPlayer");
		System.loadLibrary("Discovery");
        System.loadLibrary("NetDEVSDK");
        System.loadLibrary("NetDEVSDK_JNI");
    }
   
	//private OnNotifyListener mNotifyListener;
 	public static long lpUserID;       	/* User ID*/
	public static int gdwWinIndex;       	/* User ID*/
	public static long lpDownloadID;      	/* Cloud ID*/
	public static String strDevName;
	public static int dwDeviceType = 0;         /* 0 is NVR/IPC, 1 is VMS */
 	public static NETDEV_FINDDATA_S []m_astVodFile = new NETDEV_FINDDATA_S[1000];
	public static NETDEMO_DEV_LOGININFO_S gastLoginDeviceInfo = new NETDEMO_DEV_LOGININFO_S();
 	
	/**
	 * @enum tagNETDEVAlarmTypeEn
	 * @brief  Alarm Type Enumeration definition
	 * @attention None
	 */
	public class NETDEV_ALARM_TYPE_E
	{
		public static final int NETDEV_ALARM_MOVE_DETECT                = 1;        /*   Motion detection alarm */
		public static final int NETDEV_ALARM_MOVE_DETECT_RECOVER        = 2;        /*   Motion detection alarm recover */
		public static final int NETDEV_ALARM_VIDEO_LOST                 = 3;        /*   Video loss alarm */
		public static final int NETDEV_ALARM_VIDEO_LOST_RECOVER         = 4;        /*   Video loss alarm recover */
		public static final int NETDEV_ALARM_VIDEO_TAMPER_DETECT        = 5;        /*   Tampering detection alarm */
		public static final int NETDEV_ALARM_VIDEO_TAMPER_RECOVER       = 6;        /*   Tampering detection alarm recover */
		public static final int NETDEV_ALARM_INPUT_SWITCH               = 7;        /*   boolean input alarm */
		public static final int NETDEV_ALARM_INPUT_SWITCH_RECOVER       = 8;        /*   Boolean input alarm recover */
		public static final int NETDEV_ALARM_TEMPERATURE_HIGH           = 9;        /*   High temperature alarm */
		public static final int NETDEV_ALARM_TEMPERATURE_LOW            = 10;       /*   Low temperature alarm */
		public static final int NETDEV_ALARM_TEMPERATURE_RECOVER        = 11;       /*   Temperature alarm recover */
		public static final int NETDEV_ALARM_AUDIO_DETECT               = 12;       /*   Audio detection alarm */
		public static final int NETDEV_ALARM_AUDIO_DETECT_RECOVER       = 13;       /*   Audio detection alarm recover */
		public static final int NETDEV_ALARM_SERVER_FAULT               = 18;       
		public static final int NETDEV_ALARM_SERVER_NORMAL              = 19;       

		public static final int NETDEV_ALARM_REPORT_DEV_ONLINE          = 201;       
		public static final int NETDEV_ALARM_REPORT_DEV_OFFLINE         = 202;       
		public static final int NETDEV_ALARM_REPORT_DEV_REBOOT          = 203;       /*   Device restart */
		public static final int NETDEV_ALARM_REPORT_DEV_SERVICE_REBOOT  = 204;       /*   Service restart */
		public static final int NETDEV_ALARM_REPORT_DEV_CHL_ONLINE      = 205;       /* :  */
		public static final int NETDEV_ALARM_REPORT_DEV_CHL_OFFLINE     = 206;       /* :  */
		public static final int NETDEV_ALARM_REPORT_DEV_DELETE_CHL      = 207;       /* :  */

		public static final int NETDEV_ALARM_NET_FAILED                 = 401;      /*  Network error */
		public static final int NETDEV_ALARM_NET_TIMEOUT                = 402;      /*  Network timeout */
		public static final int NETDEV_ALARM_SHAKE_FAILED               = 403;      /*  Interaction error */
		public static final int NETDEV_ALARM_STREAMNUM_FULL             = 404;      /*  Stream full */
		public static final int NETDEV_ALARM_STREAM_THIRDSTOP           = 405;      /*  Third party stream stopped */
		public static final int NETDEV_ALARM_FILE_END                   = 406;      /*  File ended */
		public static final int NETDEV_ALARM_RTMP_CONNECT_FAIL          = 407;      /* RTMP */
		public static final int NETDEV_ALARM_RTMP_INIT_FAIL             = 408;      /* RTMP*/
		public static final int NETDEV_ALARM_STREAM_DOWNLOAD_OVER       = 409;      

		public static final int NETDEV_ALARM_DISK_ERROR                         = 601;      /*   Disk error */
		public static final int NETDEV_ALARM_SYS_DISK_ERROR                     = 602;      /*   Disk error */
		public static final int NETDEV_ALARM_DISK_ONLINE                        = 603;      /*  Disk online */
		public static final int NETDEV_ALARM_SYS_DISK_ONLINE                    = 604;      /*  Disk online */
		public static final int NETDEV_ALARM_DISK_OFFLINE                       = 605;      
		public static final int NETDEV_ALARM_SYS_DISK_OFFLINE                   = 606;      
		public static final int NETDEV_ALARM_DISK_ABNORMAL                      = 607;      /*  Disk abnormal */
		public static final int NETDEV_ALARM_DISK_ABNORMAL_RECOVER              = 608;      /*  Disk abnormal recover */
		public static final int NETDEV_ALARM_DISK_STORAGE_WILL_FULL             = 609;      /*  Disk StorageGoingfull */
		public static final int NETDEV_ALARM_DISK_STORAGE_WILL_FULL_RECOVER     = 610;      /*  Disk StorageGoingfull recover */
		public static final int NETDEV_ALARM_DISK_STORAGE_IS_FULL               = 611;      /*  StorageIsfull */
		public static final int NETDEV_ALARM_SYS_DISK_STORAGE_IS_FULL           = 612;      /*  StorageIsfull */
		public static final int NETDEV_ALARM_DISK_STORAGE_IS_FULL_RECOVER       = 613;      /*  StorageIsfull recover */
		public static final int NETDEV_ALARM_DISK_RAID_DISABLED_RECOVER         = 614;      /*  RAIDDisabled recover */
		public static final int NETDEV_ALARM_DISK_RAID_DEGRADED                 = 615;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_SYS_DISK_RAID_DEGRADED             = 616;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_DISK_RAID_DISABLED                 = 617;      /*  RAIDDisabled */
		public static final int NETDEV_ALARM_SYS_DISK_RAID_DISABLED             = 618;      /*  RAIDDisabled */
		public static final int NETDEV_ALARM_DISK_RAID_DEGRADED_RECOVER         = 619;      /*  RAIDDegraded recover */
		public static final int NETDEV_ALARM_STOR_GO_FULL                       = 620;      
		public static final int NETDEV_ALARM_SYS_STOR_GO_FULL                   = 621;      
		public static final int NETDEV_ALARM_ARRAY_NORMAL                       = 622;      
		public static final int NETDEV_ALARM_SYS_ARRAY_NORMAL                   = 623;      
		public static final int NETDEV_ALARM_DISK_RAID_RECOVERED                = 624;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_STOR_ERR                           = 625;      /*   Storage error */
		public static final int NETDEV_ALARM_SYS_STOR_ERR                       = 626;      /*   Storage error */
		public static final int NETDEV_ALARM_STOR_ERR_RECOVER                   = 627;      /*   Storage error recover */
		public static final int NETDEV_ALARM_STOR_DISOBEY_PLAN                  = 628;      /*   Not stored as planned */
		public static final int NETDEV_ALARM_STOR_DISOBEY_PLAN_RECOVER          = 629;      /*   Not stored as planned recover */

		public static final int NETDEV_ALARM_BANDWITH_CHANGE                    = 801;      
		public static final int NETDEV_ALARM_VIDEOENCODER_CHANGE                = 802;      
		public static final int NETDEV_ALARM_IP_CONFLICT                        = 803;      /* IP IP conflict exception alarm*/
		public static final int NETDEV_ALARM_IP_CONFLICT_CLEARED                = 804;      /* IPIP conflict exception alarm recovery */
		public static final int NETDEV_ALARM_NET_OFF                            = 805;      
		public static final int NETDEV_ALARM_NET_RESUME_ON                      = 806;      

		public static final int NETDEV_ALARM_ILLEGAL_ACCESS                     = 1001;          /*   Illegal access */
		public static final int NETDEV_ALARM_SYS_ILLEGAL_ACCESS                 = 1002;          /*   Illegal access */
		public static final int NETDEV_ALARM_LINE_CROSS                         = 1003;          /*   Line cross */
		public static final int NETDEV_ALARM_OBJECTS_INSIDE                     = 1004;          /*   Objects inside */
		public static final int NETDEV_ALARM_FACE_RECOGNIZE                     = 1005;          /*   Face recognize */
		public static final int NETDEV_ALARM_IMAGE_BLURRY                       = 1006;          /*   Image blurry */
		public static final int NETDEV_ALARM_SCENE_CHANGE                       = 1007;          /*   Scene change */
		public static final int NETDEV_ALARM_SMART_TRACK                        = 1008;          /*   Smart track */
		public static final int NETDEV_ALARM_LOITERING_DETECTOR                 = 1009;          /*   Loitering Detector */
		public static final int NETDEV_ALARM_BANDWIDTH_CHANGE                   = 1010;          /*   Bandwidth change */
		public static final int NETDEV_ALARM_ALLTIME_FLAG_END                   = 1011;          /*   End marker of alarm without arming schedule */
		public static final int NETDEV_ALARM_MEDIA_CONFIG_CHANGE                = 1012;          /*  media configurationchanged */
		public static final int NETDEV_ALARM_REMAIN_ARTICLE                     = 1013;          /*  Remain article*/
		public static final int NETDEV_ALARM_PEOPLE_GATHER                      = 1014;          /*  People gather alarm*/
		public static final int NETDEV_ALARM_ENTER_AREA                         = 1015;          /*  Enter area*/
		public static final int NETDEV_ALARM_LEAVE_AREA                         = 1016;          /*  Leave area*/
		public static final int NETDEV_ALARM_ARTICLE_MOVE                       = 1017;          /*  Article move*/
		public static final int NETDEV_ALARM_SMART_FACE_MATCH_LIST                  = 1018;       
		public static final int NETDEV_ALARM_SMART_FACE_MATCH_LIST_RECOVER          = 1019;       
		public static final int NETDEV_ALARM_SMART_FACE_MISMATCH_LIST               = 1020;       
		public static final int NETDEV_ALARM_SMART_FACE_MISMATCH_LIST_RECOVER       = 1021;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST               = 1022;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST_RECOVER       = 1023;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST            = 1024;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST_RECOVER    = 1025;       
		public static final int NETDEV_ALARM_IMAGE_BLURRY_RECOVER               = 1026;         /*   Image blurry recover */
		public static final int NETDEV_ALARM_SMART_TRACK_RECOVER                = 1027;         /*   Smart track recover */
		public static final int NETDEV_ALARM_SMART_READ_ERROR_RATE              = 1028;         /* Error reding the underlying data */
		public static final int NETDEV_ALARM_SMART_SPIN_UP_TIME                 = 1029;         /*   Rotation time of spindle */
		public static final int NETDEV_ALARM_SMART_START_STOP_COUNT             = 1030;         /*  Rev. Stop counting*/
		public static final int NETDEV_ALARM_SMART_REALLOCATED_SECTOR_COUNT     = 1031;         /*   Remap sector count*/
		public static final int NETDEV_ALARM_SMART_SEEK_ERROR_RATE              = 1032;         /*  Trace error rate*/
		public static final int NETDEV_ALARM_SMART_POWER_ON_HOURS               = 1033;         
		public static final int NETDEV_ALARM_SMART_SPIN_RETRY_COUNT             = 1034;         
		public static final int NETDEV_ALARM_SMART_CALIBRATION_RETRY_COUNT      = 1035;         
		public static final int NETDEV_ALARM_SMART_POWER_CYCLE_COUNT            = 1036;         
		public static final int NETDEV_ALARM_SMART_POWEROFF_RETRACT_COUNT       = 1037;         
		public static final int NETDEV_ALARM_SMART_LOAD_CYCLE_COUNT             = 1038;         
		public static final int NETDEV_ALARM_SMART_TEMPERATURE_CELSIUS          = 1039;         
		public static final int NETDEV_ALARM_SMART_REALLOCATED_EVENT_COUNT      = 1040;         
		public static final int NETDEV_ALARM_SMART_CURRENT_PENDING_SECTOR       = 1041;         
		public static final int NETDEV_ALARM_SMART_OFFLINE_UNCORRECTABLE        = 1042;         
		public static final int NETDEV_ALARM_SMART_UDMA_CRC_ERROR_COUNT         = 1043;         
		public static final int NETDEV_ALARM_SMART_MULTI_ZONE_ERROR_RATE        = 1044;         
		public static final int NETDEV_ALARM_RESOLUTION_CHANGE                  = 1045;         
		public static final int NETDEV_ALARM_MANUAL                             = 1401;         
		public static final int NETDEV_ALARM_ALARMHOST_COMMON                   = 1402;         
		public static final int NETDEV_ALARM_DOORHOST_COMMON                    = 1403;         
		public static final int NETDEV_ALARM_FACE_NOT_MATCH                     = 1411;         
		public static final int NETDEV_ALARM_FACE_MATCH_SUCCEED                 = 1412;         

		public static final int NETDEV_ALARM_VEHICLE_BLACK_LIST                 = 1420;         


		/*  Cloud media view exception report 2793~2809 */
		public static final int NETDEV_ALARM_CLOUD_DOWNLOAD_FINISH              = 2793;         
		public static final int NETDEV_ALARM_CLOUD_PARSE_DOMAIN_FAIL            = 2794;         
		public static final int NETDEV_ALARM_CLOUD_CONNECT_FAIL                 = 2795;         
		public static final int NETDEV_ALARM_CLOUD_CONNECT_TIMEOUT              = 2796;         
		public static final int NETDEV_ALARM_CLOUD_DOWNLOAD_TIMEOUT             = 2797;         
		public static final int NETDEV_ALARM_CLOUD_DOWNLOAD_FAIL                = 2798;         
		public static final int NETDEV_ALARM_CLOUD_NETWORK_POOR                 = 2799;         
		public static final int NETDEV_ALARM_CLOUD_PLAY_FINISH                  = 2800;         
		public static final int NETDEV_ALARM_CLOUD_DISK_FULL                    = 2801;         
		public static final int NETDEV_ALARM_CLOUD_AUTH_FAIL                    = 2802;         
		public static final int NETDEV_ALARM_CLOUD_CURRENT_TIME                 = 2803;         
		public static final int NETDEV_ALARM_CLOUD_PRIOR_DISK_FULL              = 2804;         
		public static final int NETDEV_ALARM_CLOUD_NODE_NOT_EXIST               = 2805;         
		public static final int NETDEV_ALARM_CLOUD_NO_CACHE_PATH                = 2806;         
		public static final int NETDEV_ALARM_CLOUD_MSG_SEND_FAIL                = 2807;         
		public static final int NETDEV_ALARM_CLOUD_TASK_CANCELLED               = 2808;         
		public static final int NETDEV_ALARM_CLOUD_TASK_STREAM_CONTINUE         = 2809;         
		
		public static final int NETDEV_ALARM_INVALID                            = 0xFFFF;      /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVVodPlayStatus
	 * @brief Playback and download status Enumeration definition
	 * @attention None
	 */
	public class NETDEV_VOD_PLAY_STATUS_E{
		public static final int NETDEV_PLAY_STATUS_16_BACKWARD          = 0;            /*   Backward at 16x speed */
		public static final int NETDEV_PLAY_STATUS_8_BACKWARD           = 1;            /*   Backward at 8x speed */
		public static final int NETDEV_PLAY_STATUS_4_BACKWARD           = 2;            /*   Backward at 4x speed */
		public static final int NETDEV_PLAY_STATUS_2_BACKWARD           = 3;            /*   Backward at 2x speed */
		public static final int NETDEV_PLAY_STATUS_1_BACKWARD           = 4;            /*   Backward at normal speed */
		public static final int NETDEV_PLAY_STATUS_HALF_BACKWARD        = 5;            /*   Backward at 1/2 speed */
		public static final int NETDEV_PLAY_STATUS_QUARTER_BACKWARD     = 6;            /*   Backward at 1/4 speed */
		public static final int NETDEV_PLAY_STATUS_QUARTER_FORWARD      = 7;            /*   Play at 1/4 speed */
		public static final int NETDEV_PLAY_STATUS_HALF_FORWARD         = 8;            /*   Play at 1/2 speed */
		public static final int NETDEV_PLAY_STATUS_1_FORWARD            = 9;            /*   Forward at normal speed */
		public static final int NETDEV_PLAY_STATUS_2_FORWARD            = 10;           /*   Forward at 2x speed */
		public static final int NETDEV_PLAY_STATUS_4_FORWARD            = 11;           /*   Forward at 4x speed */
		public static final int NETDEV_PLAY_STATUS_8_FORWARD            = 12;           /*   Forward at 8x speed */
		public static final int NETDEV_PLAY_STATUS_16_FORWARD           = 13;           /*   Forward at 16x speed */
		public static final int NETDEV_PLAY_STATUS_2_FORWARD_IFRAME     = 14;           /* Forward at 2x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_4_FORWARD_IFRAME     = 15;           /*  Forward at 4x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_8_FORWARD_IFRAME     = 16;           /*  Forward at 8x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_16_FORWARD_IFRAME    = 17;           /*  Forward at 16x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_2_BACKWARD_IFRAME    = 18;           /*  Backward at 2x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_4_BACKWARD_IFRAME    = 19;           /*  Backward at 4x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_8_BACKWARD_IFRAME    = 20;           /*  Backward at 8x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_16_BACKWARD_IFRAME   = 21;           /* Backward at 16x speed(I frame) */
		public static final int NETDEV_PLAY_STATUS_INTELLIGENT_FORWARD  = 22;           /*  Intelligent forward */
		public static final int NETDEV_PLAY_STATUS_1_FRAME_FORWD        = 23;           /*   Forward at 1 frame speed */
		public static final int NETDEV_PLAY_STATUS_1_FRAME_BACK         = 24;           /*  Backward at 1 frame speed */

		public static final int NETDEV_PLAY_STATUS_40_FORWARD           = 25;           /*  Forward at 40x speed*/

		public static final int NETDEV_PLAY_STATUS_32_FORWARD_IFRAME    = 26;          /*  Forward at 32x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_32_BACKWARD_IFRAME   = 27;           /*  Backward at 32x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_64_FORWARD_IFRAME    = 28;           /*  Forward at 64x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_64_BACKWARD_IFRAME   = 29;           /*  Backward at 64x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_128_FORWARD_IFRAME   = 30;           /*  Forward at 128x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_128_BACKWARD_IFRAME  = 31;           /*  Backward at 128x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_256_FORWARD_IFRAME   = 32;           /* Forward at 256x speed(I frame)*/
		public static final int NETDEV_PLAY_STATUS_256_BACKWARD_IFRAME  = 33;           /* Backward at 256x speed(I frame)*/

		public static final int NETDEV_PLAY_STATUS_32_FORWARD           = 34;           /* Forward at 32x speed */
		public static final int NETDEV_PLAY_STATUS_32_BACKWARD          = 35;           /* Backward at 32x speed */
	}

 	/**
 	 * @enum tagNETDEVPlayControl
 	 * @brief Playback control commands Enumeration definition
 	 * @attention  None
 	 */
 	public class NETDEV_VOD_PLAY_CTRL_E{
 		public static final int NETDEV_PLAY_CTRL_PLAY           = 0;           	/* Play */
 		public static final int NETDEV_PLAY_CTRL_PAUSE          = 1;           	/* Pause */
 		public static final int NETDEV_PLAY_CTRL_RESUME         = 2;          	/* Resume */
 		public static final int NETDEV_PLAY_CTRL_GETPLAYTIME    = 3;           	/* Obtain playing time */
 		public static final int NETDEV_PLAY_CTRL_SETPLAYTIME    = 4;           	/* Configure playing time */
 		public static final int NETDEV_PLAY_CTRL_GETPLAYSPEED   = 5;          	/* Obtain playing speed */
 		public static final int NETDEV_PLAY_CTRL_SETPLAYSPEED   = 6;        	/* Configure playing speed */
 	}
 	
 	public class NETDEV_VOD_PTZ_CMD_E
 	{
 		public static final int NETDEV_PTZ_FOCUSNEAR_STOP       = 0x0201;       	/* Focus near stop */
 		public static final int NETDEV_PTZ_FOCUSNEAR            = 0x0202;       	/* Focus near */
 		public static final int NETDEV_PTZ_FOCUSFAR_STOP        = 0x0203;       	/* Focus far stop */
 		public static final int NETDEV_PTZ_FOCUSFAR             = 0x0204;       	/* Focus far */
 		public static final int NETDEV_PTZ_ZOOMTELE             = 0x0302;       	/* Zoom in */
 		public static final int NETDEV_PTZ_ZOOMWIDE             = 0x0304;       	/* Zoom out */
 		public static final int NETDEV_PTZ_TILTUP               = 0x0402;       	/* Tilt up */
 		public static final int NETDEV_PTZ_TILTDOWN             = 0x0404;       	/* ilt down */
 		public static final int NETDEV_PTZ_PANRIGHT             = 0x0502;       	/* Pan right */
 		public static final int NETDEV_PTZ_PANLEFT              = 0x0504;      		/* Pan left */
 		public static final int NETDEV_PTZ_LEFTUP               = 0x0702;       	/* Move up left */
 		public static final int NETDEV_PTZ_LEFTDOWN             = 0x0704;       	/* Move down left */
 		public static final int NETDEV_PTZ_RIGHTUP              = 0x0802;       	/* Move up right */
 		public static final int NETDEV_PTZ_RIGHTDOWN            = 0x0804;       	/* Move down right */
 		public static final int NETDEV_PTZ_ALLSTOP              = 0x0901;       	/* All-stop command word */
 	}

	public class NETDEV_TIME_ZONE_E
	{
		public static final int NETDEV_TIME_ZONE_W1200 = 0;              /* W12 */
		public static final int NETDEV_TIME_ZONE_W1100 = 1;              /* W11 */
		public static final int NETDEV_TIME_ZONE_W1000 = 2;              /* W10 */
		public static final int NETDEV_TIME_ZONE_W0900 = 3;              /* W9 */
		public static final int NETDEV_TIME_ZONE_W0800 = 4;              /* W8 */
		public static final int NETDEV_TIME_ZONE_W0700 = 5;              /* W7 */
		public static final int NETDEV_TIME_ZONE_W0600 = 6;              /* W6 */
		public static final int NETDEV_TIME_ZONE_W0500 = 7;              /* W5 */
		public static final int NETDEV_TIME_ZONE_W0430 = 8;              /* W4:30 */
		public static final int NETDEV_TIME_ZONE_W0400 = 9;              /* W4 */
		public static final int NETDEV_TIME_ZONE_W0330 = 10;             /* W3:30 */
		public static final int NETDEV_TIME_ZONE_W0300 = 11;             /* W3 */
		public static final int NETDEV_TIME_ZONE_W0200 = 12;             /* W2 */
		public static final int NETDEV_TIME_ZONE_W0100 = 13;             /* W1 */
		public static final int NETDEV_TIME_ZONE_0000  = 14;             /* W0 */
		public static final int NETDEV_TIME_ZONE_E0100 = 15;             /* E1 */
		public static final int NETDEV_TIME_ZONE_E0200 = 16;             /* E2 */
		public static final int NETDEV_TIME_ZONE_E0300 = 17;             /* E3 */
		public static final int NETDEV_TIME_ZONE_E0330 = 18;             /* E3:30 */
		public static final int NETDEV_TIME_ZONE_E0400 = 19;             /* E4 */
		public static final int NETDEV_TIME_ZONE_E0430 = 20;             /* E4:30 */
		public static final int NETDEV_TIME_ZONE_E0500 = 21;             /* E5 */
		public static final int NETDEV_TIME_ZONE_E0530 = 22;             /* E5:30 */
		public static final int NETDEV_TIME_ZONE_E0545 = 23;             /* E5:45 */
		public static final int NETDEV_TIME_ZONE_E0600 = 24;             /* E6 */
		public static final int NETDEV_TIME_ZONE_E0630 = 25;             /* E6:30 */
		public static final int NETDEV_TIME_ZONE_E0700 = 26;             /* E7 */
		public static final int NETDEV_TIME_ZONE_E0800 = 27;             /* E8 */
		public static final int NETDEV_TIME_ZONE_E0900 = 28;             /* E9 */
		public static final int NETDEV_TIME_ZONE_E0930 = 29;             /* E9:30 */
		public static final int NETDEV_TIME_ZONE_E1000 = 30;             /* E10 */
		public static final int NETDEV_TIME_ZONE_E1100 = 31;             /* E11 */
		public static final int NETDEV_TIME_ZONE_E1200 = 32;             /* E12 */
		public static final int NETDEV_TIME_ZONE_E1300 = 33;             /* E13 */
		public static final int NETDEV_TIME_ZONE_W0930 = 34;              /* W9:30 */
		public static final int NETDEV_TIME_ZONE_E0830 = 35;             /* E8:30 */
		public static final int NETDEV_TIME_ZONE_E0845 = 36;             /* E8:45 */
		public static final int NETDEV_TIME_ZONE_E1030 = 37;             /* E10:30 */
		public static final int NETDEV_TIME_ZONE_E1245 = 38;             /* E12:45 */
		public static final int NETDEV_TIME_ZONE_E1400 = 39;             /* E14 */

		public static final int NETDEV_TIME_ZONE_INVALID = 0xFF;         /* Invalid value */
	}
	
	/* Recording storage type */
	public class NETDEV_PLAN_STORE_TYPE_E
	{
		public static final int NETDEV_TYPE_STORE_TYPE_ALL                  = 0;            /* All */

		public static final int NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION     = 4;            /*   Motion detection */
		public static final int NETDEV_EVENT_STORE_TYPE_DIGITALINPUT        = 5;            /*   Digital input */
		public static final int NETDEV_EVENT_STORE_TYPE_VIDEOLOSS           = 7;            /*   Video loss */

		public static final int NETDEV_TYPE_STORE_TYPE_INVALID              = 0xFF;         /*  Invalid value */
	}

	public class NETDEV_CONFIG_COMMAND_E
	{
		public static final int NETDEV_GET_OSDCFG    = 140;		/* OSD,#NETDEV_VIDEO_OSD_CFG_S  Get OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
		public static final int NETDEV_SET_OSDCFG    = 141;		/* OSD,#NETDEV_VIDEO_OSD_CFG_S  Set OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
	}

	public class NETDEV_DST_OFFSET_TIME {
		public static final int NETDEV_DST_OFFSET_TIME_30MIN                 = 30;          /* 30  30Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_60MIN                 = 60;          /* 60  60Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_90MIN                 = 90;          /* 90  90Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_120MIN                = 120;         /* 120  120Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_INVALID               = 0xff;         /*  Invalid value */
	}


	public class NETDEV_DAY_IN_WEEK_E {
		public static final int NETDEV_WEEK_SUNDAY                  = 0;                  /*   Sunday */
		public static final int NETDEV_WEEK_MONDAY                  = 1;                  /*   Monday */
		public static final int NETDEV_WEEK_TUESDAY                 = 2;                  /*   Tuesday */
		public static final int NETDEV_WEEK_WEDNESDAY               = 3;                  /*   Wednesday */
		public static final int NETDEV_WEEK_THURSDAY                = 4;                  /*   Thursday */
		public static final int NETDEV_WEEK_FRIDAY                  = 5;                  /*   Friday */
		public static final int NETDEV_WEEK_SATURDAY                = 6;                  /*   Saturday */
		public static final int NETDEV_WEEK_INVALID               = 0xff;                 /*  Invalid value */
	}
 	static AlarmCallBack_PF pfAlarmCallBack;
 	static ExceptionCallBack_PF pfExceptionCallBack;
	static DecodeAudioCallBack_PF pfDecodeAudioCallBack = null;
	static AlarmMessCallBackV30  pfAlarmCallBackV30;
	static StructAlarmMessCallBack structAlarmMessDataCB;
	static NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF pfDecodeAudioDataCB;
	static PassengerFlowStatisticCallBack_PF pfPassengerFlowStatisticCallBack;

	/**
	* Callback function to receive alarm information
	* @param [IN] iUserID              	User login ID
	* @param [IN] iChannelID           	Channel number
	* @param [IN] iAlarmType          	Alarm type
	* @param [IN] tAlarmTime           	Alarm time
	* @param [IN] strName              	Alarm source name
	* @param [IN] iBufLen             	Length of structure for alarm information
	* @note*/
	/*public void alarmCallBack(long iUserID,int iChannelID, int iAlarmType, int tAlarmTime, String strName,int iBufLen) {
		pfAlarmCallBack.alarmCallBack(iUserID, iChannelID, iAlarmType, tAlarmTime, strName, iBufLen) ;
    }
 	
	public native int  NETDEV_SetAlarmCallBack(long iUserID, String strAlarmMessCallBack, int iUserData);
	public int  NETDEV_Android_SetAlarmCallBack(long iUserID, AlarmCallBack_PF strAlarmMessCallBack, int iUserData){
		pfAlarmCallBack = strAlarmMessCallBack;
		return NETDEV_SetAlarmCallBack(iUserID,"alarmCallBack",0);
	}*/

	public void alarmCallBack(long iUserID, int iAlarmSrcType, int iChannelID, int dwIndex, int iAlarmType, int tAlarmTime, String strName) {
		pfAlarmCallBack.alarmCallBack(iUserID, iAlarmSrcType, iChannelID, dwIndex, iAlarmType, tAlarmTime, strName) ;
	}

	public static native int  NETDEV_SetAlarmCallBackV2(long iUserID, String strAlarmMessCallBack, int iUserData);
	public static int  NETDEV_Android_SetAlarmCallBack(long iUserID, AlarmCallBack_PF strAlarmMessCallBack, long iUserData){
		pfAlarmCallBack = strAlarmMessCallBack;
		return NETDEV_SetAlarmCallBackV2(iUserID,"alarmCallBack",0);
	}

	public void alarmCallBackV30(long lpUserID, NETDEV_REPORT_INFO_S stReportInfo, long lpBuf, int dwBufLen, long lpUserData) {
		pfAlarmCallBackV30.AlarmMessCallBackV30(lpUserID, stReportInfo, lpBuf, dwBufLen, lpUserData) ;
	}

	public static native int  NETDEV_SetAlarmCallBack_V30(long iUserID, String strAlarmMessCallBackV30, long iUserData);

	public static int  NETDEV_Android_SetAlarmCallBack_V30(long iUserID, AlarmMessCallBackV30  strAlarmMessCallBackV30, long iUserData){
		pfAlarmCallBackV30 = strAlarmMessCallBackV30;
		return NETDEV_SetAlarmCallBack_V30(iUserID,"alarmCallBackV30",iUserData);
	}

	public void exceptionCallBack(long iUserID,int iExceptionType,long iExceptionHandle) {
		pfExceptionCallBack.exceptionCallBack(iUserID, iExceptionType, iExceptionHandle) ;
	}

	public static native int  NETDEV_SetExceptionCallBack(String strExceptionCallBack, long iUserData);
	public static int  NETDEV_Android_SetExceptionCallBack(ExceptionCallBack_PF strExceptionCallBack, long iUserData){
		pfExceptionCallBack = strExceptionCallBack;
		return NETDEV_SetExceptionCallBack("exceptionCallBack",0);
	}

	public static native boolean NETDEV_Discovery(String szBeginIP, String szEndIP);

	public static native boolean NETDEV_SetDiscoveryCallBack(NETDEV_DISCOVERY_CALLBACK_PF cbDiscoveryCallBack);

	public static native boolean NETDEV_ModifyDeviceAddr(NETDEV_DEV_ADDR_INFO_S stDevAddrInfo);
	
 	/**
 	* SDK initialization
 	* @return 1 means success, and any other value means failure.
 	* @note Thread not safe
 	*/
 	public  native int NETDEV_Init();
 	
 	/**
 	* DK uninitialization
 	* @return  1 means success, and any other value means failure.
 	* @note Thread not safe
 	*/
 	public static native int NETDEV_Cleanup();
 	
 	/**
 	*  User login
 	* @param [IN]  DevIP         IP Device IP
 	* @param [IN]  DevPort       Device server port
 	* @param [IN]  UserName      Username
 	* @param [IN]  Password      Password
 	* @param [OUT] oDeviceInfo   device information 
 	* @return  Returned user login ID. 0 indicates failure, and other values indicate the user ID.
 	* @note
 	*/
	public static native long NETDEV_Login(String DevIP, int DevPort, String Username, String Password,NETDEV_DEVICE_INFO_S oDeviceInfo);

	public static native String NETDEV_GetStreamUrl(long lpUserID, int dwChannelID, int dwStreamType);

	public static native long NETDEV_FastRealPlayByUrl(long lpUerID, String StreamUrl, NETDEV_PREVIEWINFO_S oPreviewInfo, int dwWinIndex);

	public static native String NETDEV_GetReplayUrl(long lpUserID, int dwChannelID, int dwStreamType);

	public static native long NETDEV_FastPlayBackByUrl(long lpUerID, String StreamUrl, NETDEV_PLAYBACKCOND_S pstPlayBackInfo, int dwWinIndex);

    public static native int NETDEV_CaptureNoPreview(long lpUerID,int dwChannelID, int dwStreamType,String pszFileName,int dwCaptureMode);
	/**
	*  User logout
	* @param [IN] lpUserID    User login ID
	* @return 1 means success, and any other value means failure.
	* @note
	*/
    public static native int NETDEV_Logout(long lpUerID);
    
    /**
    * Query channel capabilities
    * @param [IN]    lpUserID           User login ID
    * @param [INOUT] pdwChlCount        Number of channels
    * @return ArrayList    List of channel capabilities.
    * @note
    */
    public static native ArrayList<NETDEV_VIDEO_CHL_DETAIL_INFO_S> NETDEV_QueryVideoChlDetailList(long lpUserID, int dwChlCount);
    
    /**
    *   Get error code
    * @return Error codes
    */
    public static native int NETDEV_GetLastError();
    
    /**
    *  Modify image display ratio
    */
    public static native void NETDEV_SetRenderSurface(Surface view);
    
    /**
    * Start Live view
    * @param [IN]  lpUserID             User login ID
    * @param [IN]  oPreviewInfo       	see enumeration
    * @return  Returned user login ID. 0 indicates failure, and other values indicate the user ID.
    * @note
    */
    public  static native long NETDEV_RealPlay(long lpUerID,NETDEV_PREVIEWINFO_S oPreviewInfo, int dwWinIndex);
    
    /**
    *  Stop Live view
    * @param [IN]  lpPlayID     ID Preview ID
    * @return 1 means success, and any other value means failure.
    * @note  Stop the live view started by NETDEV_RealPlay
    */
    public  static native int NETDEV_StopRealPlay(long lpPlayID, int dwWinIndex);
    
    /**
    * Live view snapshot
    * @param [IN]  lpPlayID         Preview\playback handle
    * @param [IN]  pszFileName      File path to save images (including file name)
    * @param [IN]  dwCaptureMode    Image saving format, see #NETDEV_PICTURE_FORMAT_E
    * @return means success, and any other value means failure.
    * @note  File format suffix is not required in the file name
    */
    public static native int NETDEV_CapturePicture(long lpPlayID,String pszFileName,int dwCaptureMode);

	public static native int NETDEV_SaveRealData(long lpPlayID,String pszFileName,int dwFormat);
	public static native int NETDEV_StopSaveRealData(long lpPlayID);
	public static native int NETDEV_GetSystemTimeCfg(long lpUserID, NETDEV_TIME_CFG_S stDeviceTime);

	/***
	 * Set System Time
	 * @param [IN] lpUserID
	 * @param [OUT] stDeviceTime
	 * @return
	 */
	public static native int NETDEV_SetSystemTimeCfg(long lpUserID, NETDEV_TIME_CFG_S stDeviceTime);

    /**
     * PTZ control operation (preview required)
     * @param [IN]  lpPlayHandle         Live preview handle
     * @param [IN]  dwPTZCommand         PTZ control commands, see #NETDEV_PTZ_E
     * @param [IN]  dwSpeed              Speed of PTZ control, which is configured according to the speed control value of different decoders. Value ranges from 1 to 9.
     * @return TRUE means success, and any other value means failure.
     * @note
     */
     public static native int NETDEV_PTZControl(long lpPlayID, int dwPTZCommand, int dwSpeed);
     
    /**
    * Get PTZ preset List 
    * @param [IN]  lpUserID         	User login ID
    * @param [IN]  dwChannelID       	Channel ID
    * @param [OUT] dwPresetIDList       Preset ID list
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_GetPTZPresetList(long lpUserID, int dwChannelID, int[] dwPresetIDList);
      
    /**
    * PTZ preset operation (preview required)  
    * @param [IN]  lpPlayHandle         Live preview handle
    * @param [IN]  dwPTZPresetCmd 		Preset Control commond
    * @param [IN]  pszPresetName     	Preset name
    * @param [IN]  dwPresetID           Preset number (starting from 0). Up to 255 presets are supported.
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_PTZPreset(long lpPlayID, int  dwPTZPresetCmd, String  szPresetName, int dwPresetID);

    /**
    * PTZ preset operation (preview not required)
    * @param [IN]  lpUserID             User login ID
    * @param [IN]  dwChannelID          Channel number
    * @param [IN]  dwPTZPresetCmd       PTZ preset operation commands, see NETDEV_PTZ_PRESETCMD_E
    * @param [IN]  pszPresetName        Preset name
    * @param [IN]  dwPresetID           Preset number (starting from 0). Up to 255 presets are supported.
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_PTZPreset_Other(long lpUserID, int dwChannelID, int  dwPTZPresetCmd, String szPresetName, int dwPresetID);

	public static native NETDEV_PTZ_PRESET_S[] NETDEV_GetPTZPresetListEx(long lpUserID, int dwChannelID);
	public static native int NETDEV_PTZControl_Other(long lpUserID, int dwChannelID, int dwPTZCommand, int dwSpeed);


	public static native int[] NETDEV_QuickSearch(long lUserID, int dwChannelID, NETDEV_MONTH_INFO_S oMonthInfo, NETDEV_MONTH_STATUS_S oMonthStatus);
    
    /**
    * Query recording files according to file type and time
    * @param [IN]  lpUserID      	User login ID
    * @param [IN]  pstFindCond  	Search condition
    * @return Recording search service number. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_FindClose.
    * @note 
    */   
    public static native long NETDEV_FindFile(long lpUserID, NETDEV_FILECOND_S pstFindCond);
    
    /**
    * Obtain the information of found files one by one.
    * @param [IN]  lpFindHandle     File search handle
    * @param [OUT] pstFindData      Pointer to save file information
    * @return TRUE means success, and any other value means failure.
    * @note  A returned failure indicates the end of search.
    */
    public static native int NETDEV_FindNextFile(long lpFindHandle, NETDEV_FINDDATA_S pstFindData);

	public static native int NETDEV_SetPictureFluency(long lpUserID, int dwFluency);
    /**
    * Close file search and release resources
    * @param [IN] lpFindHandle  File search handle
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_FindClose(long lpFindHandle);
     
    /**
    * Play back recording by time. 
    * @param [IN] lpUserID          User login ID
    * @param [IN] pstPlayBackCond   Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native long NETDEV_PlayBackByTime(long lpUserID, NETDEV_PLAYBACKCOND_S pstPlayBackInfo, int dwWinIndex);
    
    /**
    * Stop playback service
    * @param [IN] lpPlayHandle   Playback handle
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_StopPlayBack(long lpPlayHandle, int dwWinIndex);
    
    /**
    * Control recording playback status.
    * @param [IN]  lpPlayHandle     Playback or download handle
    * @param [IN]  dwControlCode    Command for controlling recording playback status, see NETDEV_VOD_PLAY_CTRL_E
    * @param [INOUT]  lpBuffer     Pointer to input/output parameters. For playing speed, see NETDEV_VOD_PLAY_STATUS_E. The type of playing time: INT64.
    * @return TRUE means success, and any other value means failure.
    * @note When playing, pause or resume videos, set IpBuffer as NULL.
    */
    public static native int NETDEV_PlayBackControl(long lpPlayHandle, int dwControlCode, NETDEV_PLAYBACKCONTROL_S lpBuffer);
    
    /**
    * Download recordings by time
    * @param [IN]  lpUserID          	User login ID
    * @param [IN]  pstPlayBackCond   	Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
    * @param [IN]  *pszSaveFileName    	Downloaded file save path on PC, must be an absolute path (including file name)
    * @param [IN]  dwFormat         	Recording file saving format
    * @return Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
    * @note
    */
    public static native long NETDEV_DownloadFile(long lpUserID, NETDEV_PLAYBACKCOND_S lpBuffer, String szSaveFileName, int dwFormat);
    
    /**
    * Stop downloading recording files
    * @param [IN]  lpPlayHandle  Playback handle
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_StopDownloadFile(long lpPlayHandle);
    
    /**
    * Get device basic info
    * @param [IN]  lpUserID          	User login ID
    * @param [IN]  dwChannelID          Channel ID
    * @param [OUT]  stDevinfo           Device Info
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_GetDeviceInfo(long lpUserID, int dwChannelID, NETDEV_DEVICE_BASICINFO_S stDevinfo);
        
    public static native int initialize();
    public static native int rendererRender(int dwWinIndex);
    public static native int setRendererViewport(int w, int h);
    public static native int initializeRenderer(int dwWinIndex);
	public static native int Scale(float scaleRatio, float x, float y, int dwWinIndex);

	/**
	 * SDK initialization
	 * @return 1 means success, and any other value means failure.
	 * @note ID must be unique
	 */
	public static native int NETDEV_SetClientID(String strClientID);
	
	public void DecodeAudioDataCallBack(long lpVoiceComHandle, byte[] voiceData, int length, int u32WaveFormat) 
    {
    	pfDecodeAudioCallBack.DecodeAudioDataCallBack(lpVoiceComHandle, voiceData, length, u32WaveFormat);
    }
	
    /**
    * Start input voice server
    * @param [IN]  lpUserID                 User login ID
    * @param [IN]  dwChannelID              Channel ID
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native long NETDEV_StartInputVoiceSrv(long lpUserID,int dwChannelID);
	public static long NETDEV_Android_StartInputVoiceSrv(long lpUserID,int dwChannelID)
	{
		pfDecodeAudioCallBack = new DecodeAudioCallBack_PF();
		return NETDEV_StartInputVoiceSrv(lpUserID,dwChannelID);
	}
    
    /**
    * Stop input voice server
    * @param [IN]  lpVoiceComHandle         Two-way audio handle
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_StopInputVoiceSrv(long lpVoiceComHandle);
	public static int NETDEV_Android_StopInputVoiceSrv(long lpVoiceComHandle) {
		pfDecodeAudioCallBack.release();
		return NETDEV_StopInputVoiceSrv(lpVoiceComHandle);
	}
    
    /**
    * input voice Data
    * @param [IN]  lpVoiceComHandle         Two-way audio handle
    * @param [IN]  lpDataBuf         		Data buffer
    * @param [IN]  dwDataLen         		Data length
    * @param [IN]  pstVoiceParam         	Voice param
    * @return TRUE means success, and any other value means failure.
    * @note
    */
    public static native int NETDEV_InputVoiceData(long lpVoiceComHandle,byte[] lpDataBuf,int dwDataLen,NETDEV_AUDIO_SAMPLE_PARAM_S stVoiceParam);

	 /**
	 *    PTZ absolute move
	 * @param [IN]  lpUserID         User ID
	 * @param [IN]  dwChannelID      Channel ID
	 * @param [IN]  stPTZAbsoluteMove      PTZ absolute move info
	 * @return  1 means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_PTZAbsoluteMove(long lpUserID,int dwChannelID, NETDEV_PTZ_ABSOLUTE_MOVE_S stPTZAbsoluteMove);

	/**
	 *   Get PTZ Status
	 * @param [IN]  lpUserID         User ID
	 * @param [IN]  dwChannelID      Channel ID
	 * @param [IN]  stPTZStatus      PTZ status
	 * @return  1 means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_PTZGetStatus(long lpUserID,int dwChannelID, NETDEV_PTZ_STATUS_S stPTZStatus);

	public native int NETDEV_GetDevConfig(long iUserID, int iChannelID,
										  int iCommand, Object oOutBuffer, int iOutBufferSize,
										  int iBytesReturned);

	/*
	 *  Modify device configuration information
	 *
	 * @param [IN] iUserID ID User login ID
	 *
	 * @param [IN] iChannelID  Channel number
	 *
	 * @param [IN] iCommand ,#NETDEV_CONFIG_COMMAND_E Device
	 * configuration commands, see #NETDEV_CONFIG_COMMAND_E
	 *
	 * @param [IN] iInBuffer  Pointer to buffer of input data
	 *
	 * @param [IN] iInBufferSize () Length of input data buffer
	 * (byte)
	 *
	 * @return TRUE, TRUE means success, and any other value means
	 * failure.
	 *
	 * @note
	 */
	public native int NETDEV_SetDevConfig(long iUserID, int iChannelID,
										  int iCommand, Object oInBuffer, int iInBufferSizes);


	/**
	 * 
	 * @param [IN]  pstDevLoginInfo  
	 * @param [OUT] pstSELogInfo     
	 * @return ID。
	 * @note LAPI
	 * -
	 */
	public static native long NETDEV_Login_V30(NETDEV_DEVICE_LOGIN_INFO_S stDevLoginInfo, NETDEV_SELOG_INFO_S stSELogInfo);

	/**
	 *   Query channel info list
	 * @param [IN]    lpUserID            User login ID
	 * @param [INOUT] pdwChlCount         Number of channels
	 * @param [OUT]   pstVideoChlList     List of channel info list
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_QueryVideoChlDetailListEx(long iUserID, MutableInteger pdwChlCount, ArrayList<NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S> stVideoChlList);

	/**
	 * 
	 * @param [IN] lpUserID          ID
	 * @param [IN] pstFindCond       
	 * @return ,0NETDEV_FindNextOrgInfoNETDEV_FindCloseOrgInfo。
	 * @note
	 */
	public static native long NETDEV_FindOrgInfoList(long iUserID, NETDEV_ORG_FIND_COND_S stFindCond);

	/**
	 * 
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstOrgInfo                   
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public static native int NETDEV_FindNextOrgInfo(long iFindHandle, NETDEV_ORG_INFO_S stOrgInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_FindCloseOrgInfo(long iFindHandle);

	/**
	 * ID
	 * @param [IN] lpUserID          ID
	 * @param [IN] dwOrgID           ID
	 * @param [IN] dwChnType         #NETDEV_CHN_TYPE_E
	 * @return ,0NETDEV_FindNextOrgChnNETDEV_FindCloseOrgChn。
	 * @note
	 */
	public static native long NETDEV_FindOrgChnList(long iUserID, int dwOrgID, int dwChnType);

	/**
	 *   
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstOrgChnInfo                  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public static native int NETDEV_FindNextOrgChn(long iUserID, NETDEV_ORG_CHN_INFO_S stOrgChnInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_FindCloseOrgChn(long iFindHandle);

	/**
	 *    
	 * @param [IN] lpUserID              ID
	 * @param [IN] dwDevType              #NETDEV_DEVICE_MAIN_TYPE_E
	 * @return ,0NETDEV_FindNextOrgInfoNETDEV_FindCloseOrgInfo。
	 * @note
	 */
	public static native long NETDEV_FindDevList(long iUserID, int dwDevType);

	/**
	 *  
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstDevBasicInfo               
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public static native int NETDEV_FindNextDevInfo(long iUserID, NETDEV_DEV_BASIC_INFO_S stDevBasicInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_FindCloseDevInfo(long iFindHandle);

	/**
	 * ID 
	 * @param [IN] lpUserID          ID
	 * @param [IN] dwDevID           ID
	 * @param [IN] dwChnType         # NETDEV_CHN_TYPE_E
	 * @return ,0NETDEV_FindNextDevChnNETDEV_FindCloseDevChn。
	 * @note     1ID0.
	 */
	public static native long NETDEV_FindDevChnList(long iUserID, int dwDevID, int dwChnType);

	/**
	 *   
	 * @param [IN]  lpFindHandle         
	 * @param [OUT] lpOutBuffer          
	 * @param [IN] dwOutBufferSize       ()0
	 * @param [OUT] pdwBytesReturned     NUL
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public static native int NETDEV_FindNextDevChn(long iFindHandle, NETDEV_DEV_CHN_ENCODE_INFO_S stDevChnEncodeInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_FindCloseDevChn(long iFindHandle);
	
		public void myStructAlarmCallBack(long iUserID,NETDEV_STRUCT_ALARM_INFO_S stAlarmInfo,NETDEV_STRUCT_DATA_INFO_S stAlarmData, long lpUserData) {
		structAlarmMessDataCB.StructAlarmMessCallBack(iUserID, stAlarmInfo, stAlarmData, lpUserData) ;
	}

	/**
	* 
	* Register callback function and receive alarm information, etc.
	* @param [IN] lpUserID                  ID User login ID
	* @param [IN] cbFaceAlarmMessCallBack    Callback function
	* @param [IN] lpUserData                 User data
	* @return TRUE TRUE means success, and any other value means failure.
	* @note
	*/
	public static native int NETDEV_SetStructAlarmCallBack(long lpUserID, String strAlarmMessCallBack, long lUserData);

	public static int NETDEV_Android_SetStructAlarmCallBack(long iUserID, StructAlarmMessCallBack pstructAlarmMessDataCB, long iUserData) {
		structAlarmMessDataCB = pstructAlarmMessDataCB;
		return NETDEV_SetStructAlarmCallBack(iUserID, "myStructAlarmCallBack", iUserData);
	}

	/**
	* LAPI
	* @param [IN] lpUserID                                      
	* @param IN LPNETDEV_LAPI_SUB_INFO_S   pstSubInfo           
	* @param OUT LPNETDEV_SUBSCRIBE_SUCC_INFO_S pstSubSuccInfo  
	* @return TRUE,
	* @note Type
	*/
	public static native int NETDEV_SubscibeLapiAlarm(long lpUserID, NETDEV_LAPI_SUB_INFO_S stSubInfo, NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo);

	/**
	* LAPI
	* @param [IN] lpUserID               
	* @param [IN] UINT32 udwID           ID
	* @return TRUE,
	* @note
	*/
	public static native int NETDEV_UnSubLapiAlarm(long lpUserID, int udwID);

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] pstStatisticCond        
	 * @param [OUT] pudwSearchID           ID
	 * @return TRUE
	 */
	public static native int NETDEV_StartMultiTrafficStatistic(long lpUserID, NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S pstStatisticCond, MutableInteger pudwSearchID);
	
	/**
	 * 
	 * @param [IN]  lpUserID               ID
	 * @param [IN]  udwSearchID            ID
	 * @param [OUT] pudwProgress           
	 * @return TRUE
	 */
	public static native int NETDEV_GetTrafficStatisticProgress(long lpUserID, int udwSearchID, MutableInteger pudwProgress);

	/**
	 * 
	 * @param [IN] lpUserID                        ID
	 * @param [IN] udwSearchID                     ID
	 * @return TRUE
	 */
	public static native int NETDEV_StopTrafficStatistic(long lpUserID,int udwSearchID);

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] udwSearchID             ID
	 * @return (NETDEV_FindNextTrafficStatisticInfo, NETDEV_FindCloseTrafficStatisticInfo)NULL
	 */
	public static native long NETDEV_FindTrafficStatisticInfoList(long lpUserID, int udwSearchID);

	/**
	 * 
	 * @param [IN] lpFindHandle                
	 * @param [OUT] pstStatisticInfo           
	 * @return TRUE
	 */
	public static native int NETDEV_FindNextTrafficStatisticInfo(long lpFindHandle, NETDEV_TRAFFIC_STATISTICS_INFO_S pstStatisticInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle
	 * @return TRUE
	 */
	public static native int NETDEV_FindCloseTrafficStatisticInfo(long lpFindHandle);

	/**
	 *   Callback function for passenger flow statistic message
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstPassengerFlowData     Passenger flow data
	 * @param [IN] lpUserData                 User data
	 * @note  None
	 */
	public static native int NETDEV_SetPassengerFlowStatisticCallBack(long lpUserID, String strPassengerFlowStatisticCB,long iUserData );

	public void passengerFlowStatisticCB(long lpUserID, NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S stData, long iUserData) {
		pfPassengerFlowStatisticCallBack.PassengerFlowStatisticCallBack(lpUserID, stData, iUserData) ;
	}

	public static int  NETDEV_Android_SetPassengerFlowStatisticCB(long lpUserID, PassengerFlowStatisticCallBack_PF  strDecodeVideoCallBack,long iUserData){
		pfPassengerFlowStatisticCallBack = strDecodeVideoCallBack;
		return NETDEV_SetPassengerFlowStatisticCallBack(lpUserID,"passengerFlowStatisticCB",iUserData);
	}

	/**
	 *   Enable sound
	 * @param [IN]  lpPlayHandle    Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_OpenSound(long lpPlayHandle);
	
	/**
	 *  Mute
	 * @param [IN]  lpPlayHandle    Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public static native int NETDEV_CloseSound(long lpPlayHandle);

	public void myDecodeAudioDataCallBack(long lpPlayHandle,NETDEV_WAVE_DATA_S pstWaveData, long lpUserData) {
		pfDecodeAudioDataCB.NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF(lpPlayHandle, pstWaveData, lpUserData);
	}

	/**
	 * ： Callback function to register audio stream (decoded media stream data)
	 * @param [IN]  lpPlayHandle                 \ Preview\playback handle
	 * @param [IN]  cbPlayDecodeAudioCallBack     Data callback function
	 * @param [IN]  bContinue                     Whether to continue to playing operations.
	 * @param [IN]  lpUserData                    User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 * - ,NULL.
	 * - To shut the callback function, set the second parameter as NULL.
	 */
	public static native int NETDEV_SetPlayDecodeAudioCB(long lpUserID, String strPlayDecodeAudioCallBack, int bContinue, long lUserData);

	public static int NETDEV_Android_SetPlayDecodeAudioCB(long iUserID, NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF pPlayDecodeAudioCallBackCB, int bContinue, long iUserData) {
		pfDecodeAudioDataCB = pPlayDecodeAudioCallBackCB;
		if(pPlayDecodeAudioCallBackCB != null)
		{
			return NETDEV_SetPlayDecodeAudioCB(iUserID, "myDecodeAudioDataCallBack", bContinue, iUserData);
		}
		else
		{
			return NETDEV_SetPlayDecodeAudioCB(iUserID, "", bContinue, iUserData);
		}
	}

}

