package main.java.com.netdevsdk.demo.config.basic;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_BASICINFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DISCOVERY_DEVINFO_S;

/**
 * 
 * @introduction Device basic information
 * @description Support IPC/NVR/VMS
 */
public class DeviceBasicInfo {
	
    /**
     * 
     * @introduction Get device basic information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getDeviceBasicInformation() {
		NetDemo.ConfigBasicInformationTableModel.setRowCount(0);
		if(null == NetDemo.lpUserID) {
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0) {
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		NETDEV_DEVICE_BASICINFO_S  discoverydevinfo = new NETDEV_DEVICE_BASICINFO_S();
		discoverydevinfo.write();
		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DEVICECFG, discoverydevinfo.getPointer(), 13316, dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	 discoverydevinfo.read();
             Vector<String> BasicVector = new Vector<String>();
             BasicVector.add("1");
             BasicVector.add(Common.byteArrayToString(discoverydevinfo.szDevModel));
             BasicVector.add(Common.byteArrayToString(discoverydevinfo.szSerialNum));
             BasicVector.add(Common.byteArrayToString(discoverydevinfo.szMacAddress));
             BasicVector.add(Common.byteArrayToString(discoverydevinfo.szDeviceName));
             BasicVector.add(Common.byteArrayToString(discoverydevinfo.szFirmwareVersion));
             NetDemo.ConfigBasicInformationTableModel.insertRow(0,BasicVector);
             NetDemo.tableConfigBasicInformation.setModel(NetDemo.ConfigBasicInformationTableModel);
             NetDemo.tableConfigBasicInformation.getColumnModel().getColumn(0).setPreferredWidth(4);
             NetDemo.tableConfigBasicInformation.getColumnModel().getColumn(1).setPreferredWidth(140);
             NetDemo.tableConfigBasicInformation.getColumnModel().getColumn(2).setPreferredWidth(50);
             NetDemo.tableConfigBasicInformation.getColumnModel().getColumn(3).setPreferredWidth(80);
             NetDemo.tableConfigBasicInformation.getColumnModel().getColumn(5).setPreferredWidth(40);
        }
	}
}
