package main.java.com.netdevsdk.demo.config.image;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DAY_NIGHT_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_EXPOSURE_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IMAGE_EXPOSURE_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SHUTTER_TIME_RANGE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_WIDE_DYNAMIC_MODE_E;
/**
 * 
 * @introduction Image exposure
 * @description Support IPC
 */
public class ImageExposure {

    /**
     * 
     * @introduction Get Image exposure information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getImageExposureInfo() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. erroe code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_IMAGE_EXPOSURE_S stImageExposure = new NETDEV_IMAGE_EXPOSURE_S();
        stImageExposure.write();
        IntByReference dwBytesReturned = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGE_EXPOSURE, stImageExposure.getPointer(), stImageExposure.size(), dwBytesReturned );
        if(bRet != true) {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            stImageExposure.read();
            if(stImageExposure.stShutterInfo.udwIsEnableSlowShutter==0) {
                NetDemo.jCheckBoxIsEnableSlowSh.setSelected(false);
            }else if(stImageExposure.stShutterInfo.udwIsEnableSlowShutter==1) {
                NetDemo.jCheckBoxIsEnableSlowSh.setSelected(true);
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setEnabled(true);
            }
            
            switch (stImageExposure.udwMode) {
            case 0:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(0);
                break;
            case 1:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(1);
                NetDemo.jComboBoxMinShutter.setEnabled(true);
                NetDemo.jComboBoxMaxShutter.setEnabled(true);
                break;
            case 2:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(2);
                NetDemo.jComboBoxShutter.setEnabled(true);
                break;
            case 3:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(3);
                break;
            case 4:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(4);
                break;
            case 5:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(5);
                break;
            case 6:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(6);
                break;
            case 7:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(7);
                NetDemo.jComboBoxShutter.setEnabled(true);
                break;
            case 8:
                NetDemo.jComboBoxExposureMode.setSelectedIndex(8);
                NetDemo.jComboBoxShutter.setEnabled(true);
                break;
            default:
                break;
            }
            
            switch (stImageExposure.stShutterInfo.udwShutterTime) {
            case 0:
                NetDemo.jComboBoxShutter.setSelectedIndex(0);
                break;
            case 1:
                NetDemo.jComboBoxShutter.setSelectedIndex(1);
                break;
            case 2:
                NetDemo.jComboBoxShutter.setSelectedIndex(2);
                break;
            case 3:
                NetDemo.jComboBoxShutter.setSelectedIndex(3);
                break;
            case 4:
                NetDemo.jComboBoxShutter.setSelectedIndex(4);
                break;
            case 6:
                NetDemo.jComboBoxShutter.setSelectedIndex(5);
                break;
            case 8:
                NetDemo.jComboBoxShutter.setSelectedIndex(6);
                break;
            case 10:
                NetDemo.jComboBoxShutter.setSelectedIndex(7);
                break;
            case 12:
                NetDemo.jComboBoxShutter.setSelectedIndex(8);
                break;
            case 15:
                NetDemo.jComboBoxShutter.setSelectedIndex(9);
                break;
            case 20:
                NetDemo.jComboBoxShutter.setSelectedIndex(10);
                break;
            case 25:
                NetDemo.jComboBoxShutter.setSelectedIndex(11);
                break;
            case 30:
                NetDemo.jComboBoxShutter.setSelectedIndex(12);
                break;
            case 50:
                NetDemo.jComboBoxShutter.setSelectedIndex(13);
                break;
            case 60:
                NetDemo.jComboBoxShutter.setSelectedIndex(14);
                break;
            case 100:
                NetDemo.jComboBoxShutter.setSelectedIndex(15);
                break;
            case 120:
                NetDemo.jComboBoxShutter.setSelectedIndex(16);
                break;
            case 150:
                NetDemo.jComboBoxShutter.setSelectedIndex(17);
                break;
            case 180:
                NetDemo.jComboBoxShutter.setSelectedIndex(18);
                break;
            case 200:
                NetDemo.jComboBoxShutter.setSelectedIndex(19);
                break;
            case 250:
                NetDemo.jComboBoxShutter.setSelectedIndex(20);
                break;
            case 500:
                NetDemo.jComboBoxShutter.setSelectedIndex(21);
                break;
            case 1000:
                NetDemo.jComboBoxShutter.setSelectedIndex(22);
                break;
            case 2000:
                NetDemo.jComboBoxShutter.setSelectedIndex(23);
                break;
            case 4000:
                NetDemo.jComboBoxShutter.setSelectedIndex(24);
                break;
            case 8000:
                NetDemo.jComboBoxShutter.setSelectedIndex(25);
                break;
            case 50000:
                NetDemo.jComboBoxShutter.setSelectedIndex(26);
                break;
            case 100000:
                NetDemo.jComboBoxShutter.setSelectedIndex(27);
                break;
            default:
                break;
            }
            
            switch (stImageExposure.stShutterInfo.udwMinShutterTime) {
            case 1:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(0);
                break;
            case 2:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(1);
                break;
            case 3:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(2);
                break;
            case 4:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(3);
                break;
            case 6:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(4);
                break;
            case 8:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(5);
                break;
            case 10:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(6);
                break;
            case 12:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(7);
                break;
            case 15:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(8);
                break;
            case 20:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(9);
                break;
            case 25:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(10);
                break;
            case 30:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(1);
                break;
            case 50:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(12);
                break;
            case 60:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(13);
                break;
            case 100:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(14);
                break;
            case 120:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(15);
                break;
            case 150:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(16);
                break;
            case 180:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(17);
                break;
            case 200:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(18);
                break;
            case 250:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(19);
                break;
            case 500:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(20);
                break;
            case 1000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(21);
                break;
            case 2000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(22);
                break;
            case 4000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(23);
                break;
            case 8000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(24);
                break;
            case 50000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(25);
                break;
            case 100000:
                NetDemo.jComboBoxMinShutter.setSelectedIndex(26);
                break;
            default:
                break;
            }
            
            switch (stImageExposure.stShutterInfo.udwMaxShutterTime) {
            case 1:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(0);
                break;
            case 2:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(1);
                break;
            case 3:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(2);
                break;
            case 4:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(3);
                break;
            case 6:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(4);
                break;
            case 8:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(5);
                break;
            case 10:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(6);
                break;
            case 12:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(7);
                break;
            case 15:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(8);
                break;
            case 20:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(9);
                break;
            case 25:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(10);
                break;
            case 30:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(1);
                break;
            case 50:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(12);
                break;
            case 60:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(13);
                break;
            case 100:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(14);
                break;
            case 120:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(15);
                break;
            case 150:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(16);
                break;
            case 180:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(17);
                break;
            case 200:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(18);
                break;
            case 250:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(19);
                break;
            case 500:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(20);
                break;
            case 1000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(21);
                break;
            case 2000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(22);
                break;
            case 4000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(23);
                break;
            case 8000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(24);
                break;
            case 50000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(25);
                break;
            case 100000:
                NetDemo.jComboBoxMaxShutter.setSelectedIndex(26);
                break;
            default:
                break;
            }
                
            if(stImageExposure.stDayNightInfo.udwDayNightMode==0) {
                NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(true);
                NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(true);
                NetDemo.jComboBoxDayNightMode.setSelectedIndex(0);
            }else if(stImageExposure.stDayNightInfo.udwDayNightMode==1) {
                NetDemo.jComboBoxDayNightMode.setSelectedIndex(1);
                NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(false);
                NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(false);
            }else if(stImageExposure.stDayNightInfo.udwDayNightMode==2) {
                NetDemo.jComboBoxDayNightMode.setSelectedIndex(2);
                NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(false);
                NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(false);
            }else if(stImageExposure.stDayNightInfo.udwDayNightMode==3) {
                NetDemo.jComboBoxDayNightMode.setSelectedIndex(3);
                NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(false);
                NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(false);
            }
            
            if(stImageExposure.stWideDynamicInfo.udwWideDynamicMode==0) {
                NetDemo.jComboBoxExposureWDR.setSelectedIndex(0);
            }else if(stImageExposure.stWideDynamicInfo.udwWideDynamicMode==1) {
                NetDemo.jComboBoxExposureWDR.setSelectedIndex(1);
                if((stImageExposure.udwMode==0)||
                        (stImageExposure.udwMode==1)||
                        (stImageExposure.udwMode==2)||
                        (stImageExposure.udwMode==5)||
                        (stImageExposure.udwMode==6)||
                        (stImageExposure.udwMode==8)) {
                    NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(true);
                }else {
                    NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);
                }
                
            }else if(stImageExposure.stWideDynamicInfo.udwWideDynamicMode==2) {
                NetDemo.jComboBoxExposureWDR.setSelectedIndex(2);
            }
            
            NetDemo.textFieldConfigImageExposureGain.setText(String.valueOf(stImageExposure.stGainInfo.udwGain));
            NetDemo.jTextFieldConfigImageExposureSlowestShutter.setText(String.valueOf(stImageExposure.stShutterInfo.udwSlowestShutter));
            NetDemo.textFieldConfigImageExposureCompensation.setText(String.valueOf(stImageExposure.dwCompensationLevel));
            NetDemo.jTextFieldConfigImageExposureDayNightSence.setText(String.valueOf(stImageExposure.stDayNightInfo.udwDayNightSensitivity));
            NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setText(String.valueOf(stImageExposure.stDayNightInfo.udwDayNightTime));
            NetDemo.textFieldConfigImageExposureMinGain.setText(String.valueOf(stImageExposure.stGainInfo.udwMinGain));
            NetDemo.textFieldConfigImageExposureMaxGain.setText(String.valueOf(stImageExposure.stGainInfo.udwMaxGain));
            NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setText(String.valueOf(stImageExposure.stWideDynamicInfo.udwWideDynamicLevel));
        }
    }


    /**
     * 
     * @introduction Set Image exposure information
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setImageExposureInfo() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code,"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NETDEV_IMAGE_EXPOSURE_S stImageExposure = new NETDEV_IMAGE_EXPOSURE_S();

        stImageExposure.write();

        IntByReference dwBytesReturned = new IntByReference();

        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGE_EXPOSURE, stImageExposure.getPointer(), stImageExposure.size(), dwBytesReturned );
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
             stImageExposure.read();
             
             int IsEnableSlowShutter=0;
             if(NetDemo.jCheckBoxIsEnableSlowSh.isSelected()) {
                IsEnableSlowShutter=1;
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setEnabled(true);
             }else {
                IsEnableSlowShutter=0;
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setEnabled(false);
             }
             
             int ConfigImageExposureMode=0;   
             if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("AUTOMATIC")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_AUTOMATIC;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("CUSTOM")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_CUSTOM;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("SHUTTER")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_SHUTTER_PRIORITY;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("APERTURE")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_APERTURE_PRIORITY;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("GAIN")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_GAIN_PRIORITY;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-50")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_INDOOR_50_HZ;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-60")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_INDOOR_60_HZ;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("MANUAL")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_MANUAL_OPERATION;
             }else if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("LOWER")) {
                 ConfigImageExposureMode=NETDEV_EXPOSURE_MODE_E.NETDEV_EXPOSURE_MODE_LOWER_GHOSTING;
             }
            stImageExposure.udwMode = ConfigImageExposureMode;

            if(NetDemo.jComboBoxShutter.isEnabled()) {
                int ConfigImageExposureShutter=0;
                if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("AUTOMATIC")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_AUTOMATIC;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-2")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-3")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_3;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-4")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-6")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_6;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-8")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-10")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_10;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-12")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_12;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-15")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_15;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-20")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_20;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-25")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_25;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-30")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_30;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-50")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-60")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_60;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-100")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-120")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_120;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-150")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_150;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-180")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_180;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-200")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_200;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-250")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_250;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-500")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_500;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-1000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_1000;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-2000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2000;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-4000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4000;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-8000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8000;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-50000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50000;
                }else if(NetDemo.jComboBoxShutter.getItemAt(NetDemo.jComboBoxShutter.getSelectedIndex()).equals("TIME-1-100000")) {
                    ConfigImageExposureShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100000;
                }
                stImageExposure.stShutterInfo.udwShutterTime = ConfigImageExposureShutter;
            }
            
            String FieldConfigImageExposureGain= NetDemo.textFieldConfigImageExposureGain.getText();
             if(FieldConfigImageExposureGain==null||FieldConfigImageExposureGain.equals("")) {
                JOptionPane.showMessageDialog(null, "ExposureGain is null");
                return;
             }
             int ConfigImageExposureGain=0;
             
             try {
                ConfigImageExposureGain=Integer.parseInt(FieldConfigImageExposureGain);
             }catch(Exception e1) {
                JOptionPane.showMessageDialog(null, "ExposureGain transformation Exception");
                NetDemo.textFieldConfigImageExposureGain.setText(null);
                return;
             }
            
            if(ConfigImageExposureGain<1 || ConfigImageExposureGain>100) {
                JOptionPane.showMessageDialog(null, "ExposureGain should between 1 and 100 ");
                NetDemo.textFieldConfigImageExposureGain.setText(null);
                return;
            }
            stImageExposure.stGainInfo.udwGain = ConfigImageExposureGain;
            stImageExposure.stShutterInfo.udwIsEnableSlowShutter = IsEnableSlowShutter;

            String FieldConfigImageExposureSioweShutter= NetDemo.jTextFieldConfigImageExposureSlowestShutter.getText();
             if(FieldConfigImageExposureSioweShutter==null||FieldConfigImageExposureSioweShutter.equals("")) {
                JOptionPane.showMessageDialog(null, "The Slowest Shutter is null");
                return;
             }
             int ConfigImageExposureSioweShutter=0;
             
             try {
                 ConfigImageExposureSioweShutter=Integer.parseInt(FieldConfigImageExposureSioweShutter);
             }catch(Exception e1) {
                JOptionPane.showMessageDialog(null, "The Slowest Shutter transformation Exception");
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setText(null);
                return;
             }
            
            if(ConfigImageExposureSioweShutter<0) {
                JOptionPane.showMessageDialog(null, "The Slowest Shutter can not less than zero");
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setText(null);
                return;
            }
            
            stImageExposure.stShutterInfo.udwSlowestShutter =  ConfigImageExposureSioweShutter;
            

            String FieldConfigImageExposureCompensation= NetDemo.textFieldConfigImageExposureCompensation.getText();
             if(FieldConfigImageExposureSioweShutter==null||FieldConfigImageExposureCompensation.equals("")) {
                JOptionPane.showMessageDialog(null, "Compensation is null");
                return;
             }
             int ConfigImageExposureCompensation=0;
             
             try {
                ConfigImageExposureCompensation=Integer.parseInt(FieldConfigImageExposureCompensation);
             }catch(Exception e1) {
                JOptionPane.showMessageDialog(null, "Compensation transformation Exception");
                NetDemo.textFieldConfigImageExposureCompensation.setText(null);
                return;
             }
            
             if(ConfigImageExposureCompensation<-100) {
                JOptionPane.showMessageDialog(null, "Compensation can not less than negative hundred");
                NetDemo.textFieldConfigImageExposureCompensation.setText(null);
                return;
             }
             if(ConfigImageExposureCompensation>100) {
                JOptionPane.showMessageDialog(null, "Compensation can not more than one hundred");
                NetDemo.textFieldConfigImageExposureCompensation.setText(null);
                return;
              }
            
            stImageExposure.dwCompensationLevel = ConfigImageExposureCompensation;
            
            
            if(NetDemo.jTextFieldConfigImageExposureDayNightSence.isEnabled()) {
                String FieldConfigImageExposureDayNightSence= NetDemo.jTextFieldConfigImageExposureDayNightSence.getText();
                if(FieldConfigImageExposureDayNightSence==null||FieldConfigImageExposureDayNightSence.equals("")) {
                    JOptionPane.showMessageDialog(null, "NightSence is null");
                    return;
                }
                int ConfigImageExposureDayNightSence=0;
                
                try {
                    ConfigImageExposureDayNightSence=Integer.parseInt(FieldConfigImageExposureDayNightSence);
                }catch(Exception e1) {
                    JOptionPane.showMessageDialog(null, "NightSence transformation Exception");
                    NetDemo.jTextFieldConfigImageExposureDayNightSence.setText(null);
                    return;
                }
                
                if(ConfigImageExposureDayNightSence<0) {
                    JOptionPane.showMessageDialog(null, "NightSence can not less than zero");
                    NetDemo.jTextFieldConfigImageExposureDayNightSence.setText(null);
                    return;
                }
                
                if(ConfigImageExposureDayNightSence>9) {
                    JOptionPane.showMessageDialog(null, "NightSence can not more than nine");
                    NetDemo.jTextFieldConfigImageExposureDayNightSence.setText(null);
                    return;
                 }
                
                stImageExposure.stDayNightInfo.udwDayNightSensitivity = ConfigImageExposureDayNightSence;
            }
            
            int ConfigImageExposureDayNightMode=0;
            if(NetDemo.jComboBoxDayNightMode.getItemAt(NetDemo.jComboBoxDayNightMode.getSelectedIndex()).equals("AUTO")) {
                ConfigImageExposureDayNightMode=NETDEV_DAY_NIGHT_MODE_E.NETDEV_DNM_AUTO;
            }else if(NetDemo.jComboBoxDayNightMode.getItemAt(NetDemo.jComboBoxDayNightMode.getSelectedIndex()).equals("DAY")) {
                ConfigImageExposureDayNightMode=NETDEV_DAY_NIGHT_MODE_E.NETDEV_DNM_DAY_COLOR;
            }else if(NetDemo.jComboBoxDayNightMode.getItemAt(NetDemo.jComboBoxDayNightMode.getSelectedIndex()).equals("NIGHT")) {
                ConfigImageExposureDayNightMode=NETDEV_DAY_NIGHT_MODE_E.NETDEV_DNM_NIGHT_BAW;
            }else if(NetDemo.jComboBoxDayNightMode.getItemAt(NetDemo.jComboBoxDayNightMode.getSelectedIndex()).equals("COLOR")) {
                ConfigImageExposureDayNightMode=NETDEV_DAY_NIGHT_MODE_E.NETDEV_DNM_LINK_COLOR_TO_BLACK;
            }
            
            stImageExposure.stDayNightInfo.udwDayNightMode = ConfigImageExposureDayNightMode;
            
            
            if(NetDemo.jTextFieldConfigImageExposureDayNightSwitch.isEnabled()) {
                String FieldConfigImageExposureDayNightSwitch= NetDemo.jTextFieldConfigImageExposureDayNightSwitch.getText();
                if(FieldConfigImageExposureDayNightSwitch==null||FieldConfigImageExposureDayNightSwitch.equals("")) {
                    JOptionPane.showMessageDialog(null, "NightTime is null");
                    return;
                }
                int ConfigImageExposureDayNightSwitch=0;
                
                try {
                    ConfigImageExposureDayNightSwitch=Integer.parseInt(FieldConfigImageExposureDayNightSwitch);
                }catch(Exception e1) {
                    JOptionPane.showMessageDialog(null, "NightTime transformation Exception");
                    NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setText(null);
                    return;
                }
                
                if(ConfigImageExposureDayNightSwitch<3) {
                    JOptionPane.showMessageDialog(null, "NightTime can not less than three");
                    NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setText(null);
                    return;
                }
                if(ConfigImageExposureDayNightSwitch>120) {
                    JOptionPane.showMessageDialog(null, "NightTime can not more than one hundred and twenty");
                    NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setText(null);
                    return;
                }
                stImageExposure.stDayNightInfo.udwDayNightTime = ConfigImageExposureDayNightSwitch;
            }

            int ConfigImageExposureWDR=0;
            if(NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("CLOSE")) {
                ConfigImageExposureWDR=NETDEV_WIDE_DYNAMIC_MODE_E.NETDEV_WDM_CLOSED;
            }else if(NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("OPEN")) {
                ConfigImageExposureWDR=NETDEV_WIDE_DYNAMIC_MODE_E.NETDEV_WDM_OPEN;
            }else if(NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("AUTO")) {
                ConfigImageExposureWDR=NETDEV_WIDE_DYNAMIC_MODE_E.NETDEV_WDM_AUTO;
            }
            stImageExposure.stWideDynamicInfo.udwWideDynamicMode = ConfigImageExposureWDR;

            if(NetDemo.jComboBoxMinShutter.isEnabled()) {
                int ConfigImageExposureMinShutter=0;
                if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-2")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-3")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_3;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-4")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-6")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_6;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-8")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-10")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_10;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-12")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_12;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-15")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_15;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-20")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_20;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-25")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_25;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-30")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_30;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-50")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-60")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_60;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-100")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-120")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_120;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-150")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_150;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-180")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_180;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-200")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_200;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-250")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_250;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-500")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_500;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-1000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_1000;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-2000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2000;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-4000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4000;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-8000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8000;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-50000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50000;
                }else if(NetDemo.jComboBoxMinShutter.getItemAt(NetDemo.jComboBoxMinShutter.getSelectedIndex()).equals("TIME-1-100000")) {
                    ConfigImageExposureMinShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100000;
                }
                stImageExposure.stShutterInfo.udwMinShutterTime = ConfigImageExposureMinShutter;
            }
            
            if(NetDemo.jComboBoxMaxShutter.isEnabled()) {
                int ConfigImageExposureMaxShutter=0;
                if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-2")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-3")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_3;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-4")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-6")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_6;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-8")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-10")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_10;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-12")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_12;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-15")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_15;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-20")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_20;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-25")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_25;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-30")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_30;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-50")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-60")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_60;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-100")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-120")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_120;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-150")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_150;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-180")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_180;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-200")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_200;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-250")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_250;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-500")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_500;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-1000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_1000;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-2000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_2000;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-4000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_4000;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-8000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_8000;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-50000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_50000;
                }else if(NetDemo.jComboBoxMaxShutter.getItemAt(NetDemo.jComboBoxMaxShutter.getSelectedIndex()).equals("TIME-1-100000")) {
                    ConfigImageExposureMaxShutter=NETDEV_SHUTTER_TIME_RANGE_E.NETDEV_SHUTTER_TIME_1_100000;
                }
                
                stImageExposure.stShutterInfo.udwMaxShutterTime = ConfigImageExposureMaxShutter;
            }
            
            if(stImageExposure.stShutterInfo.udwMaxShutterTime>stImageExposure.stShutterInfo.udwMinShutterTime) {
                JOptionPane.showMessageDialog(null, "MaxShutterTime can not less than MinShutterTime");
                return;
            }
            String FieldConfigImageExposureMinGain= NetDemo.textFieldConfigImageExposureMinGain.getText();
             if(FieldConfigImageExposureMinGain==null||FieldConfigImageExposureMinGain.equals("")) {
                JOptionPane.showMessageDialog(null, "MinGain is null");
                return;
             }
             int ConfigImageExposureMinGain=0;
             
             try {
                ConfigImageExposureMinGain=Integer.parseInt(FieldConfigImageExposureMinGain);
             }catch(Exception e1) {
                JOptionPane.showMessageDialog(null, "MinGain transformation Exception");
                NetDemo.textFieldConfigImageExposureMinGain.setText(null);
                return;
             }
            
             if(ConfigImageExposureMinGain<0) {
                JOptionPane.showMessageDialog(null, "MinGain can not less than zero");
                NetDemo.textFieldConfigImageExposureMinGain.setText(null);
                return;
             }
            
            stImageExposure.stGainInfo.udwMinGain = ConfigImageExposureMinGain;
            
            
            String FieldConfigImageExposureMaxGain= NetDemo.textFieldConfigImageExposureMaxGain.getText();
             if(FieldConfigImageExposureMaxGain==null||FieldConfigImageExposureMaxGain.equals("")) {
                JOptionPane.showMessageDialog(null, "MaxGain is null");
                return;
             }
             int ConfigImageExposureMaxGain=0;
             
             try {
                ConfigImageExposureMaxGain=Integer.parseInt(FieldConfigImageExposureMaxGain);
             }catch(Exception e1) {
                JOptionPane.showMessageDialog(null, "MaxGain transformation Exception");
                NetDemo.textFieldConfigImageExposureMaxGain.setText(null);
                return;
             }
             if(ConfigImageExposureMaxGain<0 || ConfigImageExposureMaxGain>100) {
                JOptionPane.showMessageDialog(null, "MaxGain should between 0 and 100");
                NetDemo.textFieldConfigImageExposureMaxGain.setText(null);
                return;
             }
             if(ConfigImageExposureMinGain>ConfigImageExposureMaxGain) {
                 JOptionPane.showMessageDialog(null, "MaxGain can not less than one Min Gain");
                
                return;
             }
             
            stImageExposure.stGainInfo.udwMaxGain = ConfigImageExposureMaxGain;
            
            if(NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.isEnabled()) {
                String FieldConfigImageExposureWDRLevel=NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.getText();
                if(FieldConfigImageExposureWDRLevel==null||FieldConfigImageExposureWDRLevel.equals("")) {
                    JOptionPane.showMessageDialog(null, "DynamicLevel is null");
                    return;
                }
                int ConfigImageExposureWDRLevel=0;
                
                try {
                    ConfigImageExposureWDRLevel=Integer.parseInt(FieldConfigImageExposureWDRLevel);
                }catch(Exception e1) {
                    JOptionPane.showMessageDialog(null, "DynamicLevel transformation Exception");
                    NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setText(null);
                    return;
                }
                if(ConfigImageExposureWDRLevel<1) {
                    JOptionPane.showMessageDialog(null, "DynamicLevel should between 1 and 9");
                    NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setText(null);
                    return;
                }
                stImageExposure.stWideDynamicInfo.udwWideDynamicLevel = ConfigImageExposureWDRLevel;
            }
            
            stImageExposure.write();
            bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_IMAGE_EXPOSURE, stImageExposure.getPointer(), 1524);
             if(bRet != true)
             {
                 JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                 return;
             }
             else {
                 JOptionPane.showMessageDialog(null, "Set success");
             }
        }
    }

    /**
     * 
     * @introduction Change WDR
     * @description
     *
     */
    public static void changeWDR() {
        if(NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("OPEN")) {
            if((NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("AUTOMATIC"))||
                    (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("CUSTOM"))||
                    (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("SHUTTER"))||
                    (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-50"))||
                    (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-60"))||
                    (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("LOWER"))) {
                NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(true); 
            }else {
                NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);
            }
        }
        if((NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("AUTO"))||
                NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("CLOSE")) {
            NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false); 
        }
    }

    /**
     * 
     * @introduction Change image exposure mode
     * @description
     *
     */
    public static void changeImageExposureMode() {
        if((NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("SHUTTER"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("MANUAL"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("LOWER"))) {
            NetDemo.jComboBoxShutter.setEnabled(true);
            }else {
                NetDemo.jComboBoxShutter.setEnabled(false);
                }
        if(NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("CUSTOM")) {
            NetDemo.jComboBoxMinShutter.setEnabled(true);
            NetDemo.jComboBoxMaxShutter.setEnabled(true);
            }else {
                NetDemo.jComboBoxMinShutter.setEnabled(false);
                NetDemo.jComboBoxMaxShutter.setEnabled(false);
                }
        if((NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("AUTOMATIC"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("CUSTOM"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("SHUTTER"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-50"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("INDOOR-60"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("LOWER"))) {
            if(NetDemo.jComboBoxExposureWDR.getItemAt(NetDemo.jComboBoxExposureWDR.getSelectedIndex()).equals("OPEN")) {
                NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(true);
                }else {
                    NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);
                    }
            }
        if((NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("GAIN"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("MANUAL"))||
                (NetDemo.jComboBoxExposureMode.getItemAt(NetDemo.jComboBoxExposureMode.getSelectedIndex()).equals("APERTURE"))) {
            NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);
            }
        }
    
    /**
     * 
     * @introduction Change day and night mode
     * @description
     *
     */
    public static void changeDayNightMode() {
        if(NetDemo.jComboBoxDayNightMode.getItemAt(NetDemo.jComboBoxDayNightMode.getSelectedIndex()).equals("AUTO")) {
            NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(true);
            NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(true);
        }else {
            NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setEnabled(false);
            NetDemo.jTextFieldConfigImageExposureDayNightSence.setEnabled(false);
        }  
    }
}
