package main.java.com.netdevsdk.demo.config.motion;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_ALARM_INFO_S;

/**
 * 
 * @introduction Motion detection
 * @description
 */
public class MotionDectionInfo {
	
    /**
     * 
     * @introduction Get motion dection information
     * @description  Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getAlarmInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo = new NETDEV_MOTION_ALARM_INFO_S();
		IntByReference dwBytesReturned = new IntByReference();
		stMotionAlarmInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTIONALARM, stMotionAlarmInfo.getPointer(), stMotionAlarmInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	 stMotionAlarmInfo.read();
        	 NetDemo.textFieldConfigEquipmentMotionHistory.setText(String.valueOf(stMotionAlarmInfo.dwHistory)); 
        }
	}
	
	/**
	 * 
	 * @introduction Set motion detection information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setAlarmInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}

		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo = new NETDEV_MOTION_ALARM_INFO_S();
		stMotionAlarmInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_MOTIONALARM, stMotionAlarmInfo.getPointer(), 868, dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else {
        	 stMotionAlarmInfo.read();
				
				String FieldConfigEquipmentMotionHistory=NetDemo.textFieldConfigEquipmentMotionHistory.getText();
             if(FieldConfigEquipmentMotionHistory==null||FieldConfigEquipmentMotionHistory.equals("")) {
             	JOptionPane.showMessageDialog(null, "MotionHistory is null");
             	return;
             } 
             int ConfigEquipmentMotionHistory=0;
             try {
             	ConfigEquipmentMotionHistory=Integer.parseInt(FieldConfigEquipmentMotionHistory);
             }catch(Exception o) {
             	JOptionPane.showMessageDialog(null, "MotionHistory transformation Exception");
             	NetDemo.textFieldConfigEquipmentMotionHistory.setText(null);
             	return;
             }
             
              stMotionAlarmInfo.dwHistory = ConfigEquipmentMotionHistory;
              stMotionAlarmInfo.write();
              
              boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_MOTIONALARM, stMotionAlarmInfo.getPointer(), stMotionAlarmInfo.size() );
              if(bRet2 != true) {
                  JOptionPane.showMessageDialog(null, "Set data Failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                  System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                  return;
                  }else {
                      JOptionPane.showMessageDialog(null, "Set Success.");
                      }
              }
        }
	}
