package main.java.com.netdevsdk.demo.config.network;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_NETWORK_CARD_INFO_S;

/**
 * 
 * @introduction Network Card
 * @description Support IPC/NVR
 */
public class Card {
    
    /**
     * 
     * @introduction Get Network carrd information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getCardInfo() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS ) {
			JOptionPane.showMessageDialog(null, "Not support VMS");
			return;
		}

		NETDEV_NETWORK_CARD_INFO_S cardList = new NETDEV_NETWORK_CARD_INFO_S();
		cardList.udwNum=8;
		cardList.write();
		IntByReference dwBytesReturned = new IntByReference();
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORK_CARDS, cardList.getPointer(), cardList.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            cardList.read();	
            NetDemo.comboBoxCardListSzName.removeAllItems();
            List<Integer> CardNames=new ArrayList<>();	 
            for(int i =0; i< cardList.udwNum; i++) {
                CardNames.add(cardList.astNetworkInterfaceList[i].udwID);
                }
            List<Integer> newCardNames=CardNames;       
            for(int j=0;j<newCardNames.size();j++) {
                NetDemo.comboBoxCardListSzName.addItem(cardList.astNetworkInterfaceList[j].udwID);
                }
            for(int i=0;i<cardList.udwNum;i++) {
                if(NetDemo.comboBoxCardListSzName.getSelectedIndex()+1==cardList.astNetworkInterfaceList[i].udwID) {
                    if(cardList.udwWorkMode==0) {
                        NetDemo.jComboBoxNetWorkMode.setSelectedIndex(0);
                        NetDemo.comboBoxCardListSzName.setSelectedIndex(0);
                        }else if(cardList.udwWorkMode==1) {
                            NetDemo.jComboBoxNetWorkMode.setSelectedIndex(1);
                            NetDemo.comboBoxCardListSzName.setSelectedIndex(2);
                		}else if(cardList.udwWorkMode==2) {
                			NetDemo.jComboBoxNetWorkMode.setSelectedIndex(2);
                			NetDemo.comboBoxCardListSzName.setSelectedIndex(3);
                		}
                    
                    String NetWorkName=Common.byteArrayToString(cardList.astNetworkInterfaceList[i].szName);
           			String getNetWorkName=null;
           			try {
           			    if(NetWorkName.substring(0, 3).equals("eth")) {
           			        int NameIndex=Integer.parseInt(NetWorkName.substring(3, 4))+1;
           			        String getNameIndex=String.valueOf(NameIndex);
           			        getNetWorkName="网卡"+getNameIndex;
           			        }
           			    else if(NetWorkName.substring(0, 4).equals("bond")) {
           			        int NameIndex=Integer.parseInt(NetWorkName.substring(4, 5))+1;
           			        String getNameIndex=String.valueOf(NameIndex);
           			        getNetWorkName="网卡绑定"+getNameIndex;
           			        }
           			    }catch(Exception n) {}

           				NetDemo.textFieldNetWorkCardName.setText(getNetWorkName);
                		String getMode=null;
                		if(cardList.astNetworkInterfaceList[i].udwWorkMode==0) {
                			getMode="多址设定";
                		}
                		if(cardList.astNetworkInterfaceList[i].udwWorkMode==1) {
                			getMode="负载均衡";
                		}
                		if(cardList.astNetworkInterfaceList[i].udwWorkMode==2) {
                			getMode="网络容错";
                		}
                		
                		NetDemo.textFieldNetWorkCardMode.setText(getMode);
                		NetDemo.textListCardOneMtuLength.setText(String.valueOf(cardList.astNetworkInterfaceList[i].udwMTU));
                		NetDemo.textCardListOneMac.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].szMAC));
                		NetDemo.textIPv4Address.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress));
                		NetDemo.textCardListOneGateWay.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway));
                		NetDemo.textCardListOneNetMask.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask));
                		}
                }  
            } 
        }
	
	/**
	 * 
	 * @introduction Change Network config 
	 * @description 
	 *
	 */
	public static void changeCardListConfig() {
		if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS ) {
			JOptionPane.showMessageDialog(null, "Not support VMS");
			return;
		}
		
		NETDEV_NETWORK_CARD_INFO_S cardList = new NETDEV_NETWORK_CARD_INFO_S();
		cardList.udwNum=8;
		cardList.write();
		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORK_CARDS, cardList.getPointer(), cardList.size(), dwBytesReturned );
        if(bRet != true) {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        else {
            cardList.read();
            if((NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)) {
            	JOptionPane.showMessageDialog(null, "Not support VMS");
    			return;
			}
            else {
                for(int i=0;i<cardList.udwNum;i++) {
                    try {
               			if(NetDemo.comboBoxCardListSzName.getSelectedIndex()+1==cardList.astNetworkInterfaceList[i].udwID) {
               				String NetWorkName=Common.byteArrayToString(cardList.astNetworkInterfaceList[i].szName);
               				String getNetWorkName=null;
               				
               				try {
               					if(NetWorkName.substring(0, 3).equals("eth")) {
                   					int NameIndex=Integer.parseInt(NetWorkName.substring(3, 4))+1;
                   					String getNameIndex=String.valueOf(NameIndex);
                   					getNetWorkName="网卡"+getNameIndex;
                   				}
               				else if(NetWorkName.substring(0, 4).equals("bond")) {
                   					int NameIndex=Integer.parseInt(NetWorkName.substring(4, 5))+1;
                   					String getNameIndex=String.valueOf(NameIndex);
                   					getNetWorkName="网卡绑定"+getNameIndex;
                   				}
               				}catch(Exception n) {}
               				
               				NetDemo.textFieldNetWorkCardName.setText(getNetWorkName);
                    		String getMode=null;
                    		if(cardList.astNetworkInterfaceList[i].udwWorkMode==0) {
                    			getMode="多址设定";
                    		}
                    		if(cardList.astNetworkInterfaceList[i].udwWorkMode==1) {
                    			getMode="负载均衡";
                    		}
                    		if(cardList.astNetworkInterfaceList[i].udwWorkMode==2) {
                    			getMode="网络容错";
                    		}
                    		NetDemo.textFieldNetWorkCardMode.setText(getMode);
                    		NetDemo.textListCardOneMtuLength.setText(String.valueOf(cardList.astNetworkInterfaceList[i].udwMTU));
                    		NetDemo.textCardListOneMac.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].szMAC));
                    		NetDemo.textIPv4Address.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress));
                    		NetDemo.textCardListOneGateWay.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway));
                    		NetDemo.textCardListOneNetMask.setText(Common.byteArrayToString(cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask));
            }    
        }catch(Exception e) {}
                    }
                }
            }
        }
	
	/**
	 * 
	 * @introduction Set card information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setCardInfo() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
	    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS ) {
	        JOptionPane.showMessageDialog(null, "Not support VMS");
	        return;
	        }
	    NETDEV_NETWORK_CARD_INFO_S cardList = new NETDEV_NETWORK_CARD_INFO_S();
	    cardList.udwNum=8;
	    cardList.write();
	    IntByReference dwBytesReturned = new IntByReference();
	    boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORK_CARDS, cardList.getPointer(), cardList.size(), dwBytesReturned );
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            cardList.read();
            String getIpv4AddRess=NetDemo.textIPv4Address.getText();
            String getCardListOneGateWay=NetDemo.textCardListOneGateWay.getText();
            String  getCardListOneNetMask=NetDemo.textCardListOneNetMask.getText();
            String getCardOneMtuLength= NetDemo.textListCardOneMtuLength.getText();
                
            if(getIpv4AddRess==null||getIpv4AddRess.equals("")) {
                JOptionPane.showMessageDialog(null, "IP is null");
                return;
                }
                if(getCardListOneGateWay==null||getCardListOneGateWay.equals("")) {
                    JOptionPane.showMessageDialog(null, "GateWay is null");
                    return;
                }
                if(getCardListOneNetMask==null||getCardListOneNetMask.equals("")) {
                    JOptionPane.showMessageDialog(null, "NetMask is null");
                    return;
                }
                if(getCardOneMtuLength==null||getCardOneMtuLength.equals("")) {
                    JOptionPane.showMessageDialog(null, "Mtu is null");
                    return;
                }
                
                int getMtu=0;
                try {
                    getMtu=Integer.parseInt(getCardOneMtuLength);
                }catch(Exception m) {
                    JOptionPane.showMessageDialog(null, "Mtu is null or transformation Exception ");
                    return;
                }
                if(getMtu<0) {
                    JOptionPane.showMessageDialog(null, "Mtu can not less than zero ");
                    return;
                }
                               
                if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                                        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                    for(int i=0;i<cardList.udwNum;i++) {
                        if(cardList.astNetworkInterfaceList[i].udwID==NetDemo.comboBoxCardListSzName.getSelectedIndex()+1) {
                        if(Common.isIP(getIpv4AddRess)) {
                            cardList.astNetworkInterfaceList[i].stIPV4Infos.udwAddressNum=1;
                            try {                               
                                Common.stringToByteArray(getIpv4AddRess, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress);
                                Common.stringToByteArray(getCardListOneGateWay, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway);
                                Common.stringToByteArray(getCardListOneNetMask, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask);
                            }catch(Exception ee) {
                                return;
                            }
                            cardList.astNetworkInterfaceList[i].udwMTU=getMtu;
                            cardList.write();
                            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORK_CARDS, cardList.getPointer(), cardList.size() );
                            if(bRet2 != true)
                            {
                                JOptionPane.showMessageDialog(null, "set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                return;
                            }else {
                                JOptionPane.showMessageDialog(null, "set success");
                            }
                        }
                        else {
                            JOptionPane.showMessageDialog(null, "IP input is error");
                            return;
                            }
                        }
                   }
                }else {
                    if(NetDemo.jComboBoxNetWorkMode.getItemAt(NetDemo.jComboBoxNetWorkMode.getSelectedIndex()).equals("多址设定")) {
                        cardList.udwWorkMode=0;
                        for(int i=0;i<cardList.udwNum;i++) {
                            if(cardList.astNetworkInterfaceList[i].udwID==NetDemo.comboBoxCardListSzName.getSelectedIndex()+1) {
                            try {
                                String getSetCardName=NetDemo.textFieldNetWorkCardName.getText();
                                String getSetCardNameIndex=getSetCardName.substring(4, 5);
                                if(getSetCardName.substring(0, 4).equals("网卡绑定")) {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardNameIndex)-1;
                                    Common.stringToByteArray("bond"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }else {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardName.substring(2, 3))-1;
                                    Common.stringToByteArray("eth"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }
                            }catch(Exception mt) {}
                            if(Common.isIP(getIpv4AddRess)) {
                                cardList.astNetworkInterfaceList[i].stIPV4Infos.udwAddressNum=1;
                                try {                               
                                    Common.stringToByteArray(getIpv4AddRess, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress);
                                    Common.stringToByteArray(getCardListOneGateWay, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway);
                                    Common.stringToByteArray(getCardListOneNetMask, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask);
                                }catch(Exception e) {
                                    return;
                                }
                                cardList.astNetworkInterfaceList[i].udwMTU=getMtu;
                                cardList.write();
                                boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORK_CARDS, cardList.getPointer(), cardList.size() );
                                if(bRet2 != true)
                                {
                                    JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                    System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                    return;
                                }else {
                                    JOptionPane.showMessageDialog(null, "Set success");
                                }
                            }
                            else {
                                JOptionPane.showMessageDialog(null, "IP input is error");
                                return;
                                }
                            }
                            }
                        }else if(NetDemo.jComboBoxNetWorkMode.getItemAt(NetDemo.jComboBoxNetWorkMode.getSelectedIndex()).equals("负载均衡")) {
                        cardList.udwWorkMode=1;
                        for(int i=0;i<cardList.udwNum;i++) {
                            if(cardList.astNetworkInterfaceList[i].udwID==NetDemo.comboBoxCardListSzName.getSelectedIndex()+1) {
                            try {
                                String getSetCardName=NetDemo.textFieldNetWorkCardName.getText()+1;
                                String getSetCardNameIndex=getSetCardName.substring(4, 5);
                                if(getSetCardName.substring(0, 4).equals("网卡绑定")) {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardNameIndex)-1;
                                    
                                    Common.stringToByteArray("bond"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }else {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardName.substring(2, 3))-1;
                                    Common.stringToByteArray("eth"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }
                                cardList.astNetworkInterfaceList[i].udwWorkMode=1;
                            }catch(Exception mt) {}
                            
                            if(Common.isIP(getIpv4AddRess)) {
                                cardList.astNetworkInterfaceList[i].stIPV4Infos.udwAddressNum=1;
                                try {                               
                                    Common.stringToByteArray(getIpv4AddRess, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress);
                                    Common.stringToByteArray(getCardListOneGateWay, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway);
                                    Common.stringToByteArray(getCardListOneNetMask, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask);
                                }catch(Exception ee) {
                                    return;
                                }
                                cardList.astNetworkInterfaceList[i].udwMTU=getMtu;
                                cardList.write();
                                boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORK_CARDS, cardList.getPointer(), cardList.size() );
                                if(bRet2 != true)
                                {
                                    JOptionPane.showMessageDialog(null, "set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                    System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                    return;
                                }else {
                                    JOptionPane.showMessageDialog(null, "set success");
                                }
                            }
                            else {
                                JOptionPane.showMessageDialog(null, "IP input is error");
                                return;
                                
                            } 
                        }
                    }
                    }else if(NetDemo.jComboBoxNetWorkMode.getItemAt(NetDemo.jComboBoxNetWorkMode.getSelectedIndex()).equals("网络容错")) {           
                        cardList.udwWorkMode=2;
                        for(int i=0;i<cardList.udwNum;i++) {
                            if(cardList.astNetworkInterfaceList[i].udwID==NetDemo.comboBoxCardListSzName.getSelectedIndex()+1) {
                            try {
                                String getSetCardName=NetDemo.textFieldNetWorkCardName.getText();
                                String getSetCardNameIndex=getSetCardName.substring(4, 5);
                                if(getSetCardName.substring(0, 4).equals("网卡绑定")) {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardNameIndex)-1;
                                    
                                    Common.stringToByteArray("bond"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }else {
                                    int getNewSetCardNameIndex=Integer.parseInt(getSetCardName.substring(2, 3))-1;
                                    Common.stringToByteArray("eth"+getNewSetCardNameIndex, cardList.astNetworkInterfaceList[i].szName);
                                }
                            }
                            catch(Exception mt) {}
                            cardList.astNetworkInterfaceList[i].udwWorkMode=2;
                            if(Common.isIP(getIpv4AddRess)) {
                                cardList.astNetworkInterfaceList[i].stIPV4Infos.udwAddressNum=1;
                                try {                               
                                    Common.stringToByteArray(getIpv4AddRess, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szAddress);
                                    Common.stringToByteArray(getCardListOneGateWay, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szGateway);
                                    Common.stringToByteArray(getCardListOneNetMask, cardList.astNetworkInterfaceList[i].stIPV4Infos.astIPv4AddressInfo[0].szNetmask);
                                }catch(Exception ee) {
                                    return;
                                }
                                cardList.astNetworkInterfaceList[i].udwMTU=getMtu;
                                cardList.write();
                                boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORK_CARDS, cardList.getPointer(), cardList.size() );
                                if(bRet2 != true)
                                {
                                    JOptionPane.showMessageDialog(null, "set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                    System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                    return;
                                }else {
                                    JOptionPane.showMessageDialog(null, "Set success");
                                }
                            }
                            else {
                                JOptionPane.showMessageDialog(null, "IP input is error");
                                return;  
                            }
                            }
                            }
                        }
                    }  
                }
            }

	/**
	 * 
	 * @introduction Change network mode
	 * @description
	 *
	 */
	public static void changeNetWorkMode() {
        try {
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                return; 
            }
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                return;
            }
        }catch(Exception m) {}
    }
}
