package main.java.com.netdevsdk.demo.config.network;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_NETWORKCFG_S;

/**
 * 
 * @introduction DHCP
 * @description Support IPC/NVR
 */
public class DHCP {

    /**
     * 
     * @introduction Get DHCP
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getDHCP() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_NETWORKCFG_S stNetworkcfg = new NETDEV_NETWORKCFG_S();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORKCFG, stNetworkcfg.getPointer(), stNetworkcfg.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data error,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        	 stNetworkcfg.read();
        	 NetDemo.textFieldConfigNetWorkMTU.setText(String.valueOf(stNetworkcfg.dwMTU));
             if(stNetworkcfg.bIPv4DHCP == 1)
             {
            	 NetDemo.chckbxConfigNetWorkDHCPEnable.setSelected(true);
             }
             NetDemo.textFieldConfigNetWorkIPAddr.setText(Common.byteArrayToString(stNetworkcfg.szIpv4Address));
             NetDemo.textFieldConfigNetWorkSubMask.setText(Common.byteArrayToString(stNetworkcfg.szIPv4SubnetMask));
             NetDemo.textFieldConfigNetWorkGateway.setText(Common.byteArrayToString(stNetworkcfg.szIPv4GateWay));
	}

	/**
	 * 
	 * @introduction Set DHCP
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setDHCP() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_NETWORKCFG_S stNetworkcfg = new NETDEV_NETWORKCFG_S();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_NETWORKCFG, stNetworkcfg.getPointer(), stNetworkcfg.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            stNetworkcfg.read();
            if(NetDemo.chckbxConfigNetWorkDHCPEnable.isSelected() == true) {
                stNetworkcfg.bIPv4DHCP = 1;
                }else {
                    stNetworkcfg.bIPv4DHCP = 0;
                }
            
            if(NetDemo.textFieldConfigNetWorkIPAddr.getText()==null||NetDemo.textFieldConfigNetWorkIPAddr.getText().equals("")) {
                JOptionPane.showMessageDialog(null, "Please input ip");
                return;
            }   
            if(Common.isIP(NetDemo.textFieldConfigNetWorkIPAddr.getText())) {
                Common.stringToByteArray(NetDemo.textFieldConfigNetWorkIPAddr.getText(), stNetworkcfg.szIpv4Address);
            }else {
                JOptionPane.showMessageDialog(null, "Ip format is error");
                return;
            }
            
            if(NetDemo.textFieldConfigNetWorkSubMask.getText()==null||NetDemo.textFieldConfigNetWorkSubMask.getText().equals("")) {
                JOptionPane.showMessageDialog(null, "Please input Mask parameter");
                return;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigNetWorkSubMask.getText(), stNetworkcfg.szIPv4SubnetMask);            
            
            if(NetDemo.textFieldConfigNetWorkGateway.getText()==null||NetDemo.textFieldConfigNetWorkGateway.getText().equals("")) {
                JOptionPane.showMessageDialog(null, "Please input gateway parameter");
                return;
            }
            Common.stringToByteArray(NetDemo.textFieldConfigNetWorkGateway.getText(), stNetworkcfg.szIPv4GateWay);
            
            String  FieldConfigNetWorkMTU= NetDemo.textFieldConfigNetWorkMTU.getText();
            if( FieldConfigNetWorkMTU==null||FieldConfigNetWorkMTU.equals("")) {
                JOptionPane.showMessageDialog(null, "MTU is null");
                return;
            } 
            int getFieldConfigNetWorkMTU=0;
            try {
                getFieldConfigNetWorkMTU=Integer.parseInt(FieldConfigNetWorkMTU);
            }catch(NumberFormatException |InputMismatchException e2) {
                JOptionPane.showMessageDialog(null, "MTU is null or transformation Exception");
                NetDemo.textFieldConfigNetWorkMTU.setText(null);
                return;
            }
            
            if(getFieldConfigNetWorkMTU<576||getFieldConfigNetWorkMTU>1500) {
                JOptionPane.showMessageDialog(null, "MTU must between 576 and 1500");
                NetDemo.textFieldConfigNetWorkMTU.setText(null);
                return;
            }else {
                stNetworkcfg.dwMTU = getFieldConfigNetWorkMTU;
            }
              
            stNetworkcfg.write();
            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_NETWORKCFG, stNetworkcfg.getPointer(), stNetworkcfg.size());
            if(bRet2 != true)
            {
                JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
               System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
               JOptionPane.showMessageDialog(null, "Set suceess");
               NetDemo.jButtonGetConfigNetWorkNet.doClick();
            }
       }
   }
}
