package main.java.com.netdevsdk.demo.liveview.live;

import java.io.File;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;

/**
 * 
 * @introduction Live view snapshot
 * @description Support IPC/NVR/VMS
 */
public class Capture {
	
	/**
	 * 
	 * @introduction Live view snapshot
	 * @description Calling the interface of NETDEV_CapturePicture
	 *
	 */
	public static void CapturePicture() {
	       if(null == NetDemo.lpUserID) {
	            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	            }
	       String strSeparator = File.separator;
	       String strPicPath = System.getProperty("user.dir").replaceAll("%20"," ") +strSeparator+ "Pic" + strSeparator + Common.timeStamp() + "_D"+NetDemo.ChannelID;
	       if(null != NetDemo.lpPlayHandle){
	           boolean bRet = NetDemo.netdevsdk.NETDEV_CapturePicture(NetDemo.lpPlayHandle, strPicPath, 1);
	           if(bRet){
	               JOptionPane.showMessageDialog(null, "Success! The Path: " + strPicPath);
	               return;
	               }
	           }
	       if(null != NetDemo.lpUserID){
	            if(NetDemo.ChannelID == 0){
	                JOptionPane.showMessageDialog(null, "Please select the channel first.");
	                return;
	            }
	            boolean bRet = NetDemo.netdevsdk.NETDEV_CaptureNoPreview(NetDemo.lpUserID, NetDemo.ChannelID, 0, strPicPath, 1);
	            if(bRet){
	                JOptionPane.showMessageDialog(null, "Non-preview capture success! Path: " + strPicPath);
	            }else {
	                JOptionPane.showMessageDialog(null, "Make sure the device supports non-preview capture.");
	            }
	        }
	}
}
