package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * 
 * @introduction Open/Close Microphone
 * @description Support special device with voice intercom
 */
public class Microphone {
    
    /**
     * 
     * @introduction Open/Close Microphone
     * @description Calling the interface of NETDEV_OpenMic or NETDEV_CloseMic
     *
     */
    public static void changeMicrophoneState() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }  
        if(NetDemo.lpTalkHandle!=null) {
            if(NetDemo.state==0) {
                boolean bRet= NetDemo.netdevsdk.NETDEV_OpenMic(NetDemo.lpTalkHandle);
                if(bRet) {
                    NetDemo.state=1;    
                    NetDemo.jSliderLiveMicSound.setEnabled(true);
                    if(NetDemo.lpTalkHandle!=null) {
                        if(NetDemo.jLableLiveMicSound.getText().equals("0")) {
                            NetDemo.netdevsdk.NETDEV_CloseMic(NetDemo.lpTalkHandle);
                        } else {
                            NetDemo.netdevsdk.NETDEV_OpenMic(NetDemo.lpTalkHandle);
                        }
                    }
                }else {
                    JOptionPane.showMessageDialog(null, "Open Microphone Failed"+NetDemo.netdevsdk.NETDEV_GetLastError());
                    System.out.println("NETDEV_OpenMic failed" +NetDemo.netdevsdk.NETDEV_GetLastError());
                    NetDemo.jSliderLiveMicSound.setEnabled(false);
                    return;
                }
            }else if(NetDemo.state==1){
                boolean bRet= NetDemo.netdevsdk.NETDEV_CloseMic(NetDemo.lpTalkHandle);
                if(bRet) {
                    NetDemo.state=0;
                    NetDemo.jSliderLiveMicSound.setEnabled(false);
                    NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpTalkHandle,0);
                    NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpTalkHandle);    
                }else {
                    JOptionPane.showMessageDialog(null,"Close Microphone failed,error code" +NetDemo.netdevsdk.NETDEV_GetLastError());
                    System.out.println("NETDEV_CloseMic failed" +NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
            }
        }
    }
}
