package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PICTURE_FLUENCY_E;

/**
 * 
 * @introduction Picture fluency
 * @description Support IPC/NVR/VMS
 */
public class PictureFluency {

    /**
     * 
     * @introduction Change picture fluency
     * @description Calling the interface of NETDEV_SetPictureFluency 
     *
     */
	public static void changeFluency() {
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
		int  dwFluency=NetDemo.jComboBoxPictureFluency.getSelectedIndex();
		String dwFluencyString=NetDemo.jComboBoxPictureFluency.getItemAt(dwFluency);
		if(dwFluencyString==null) {
			return;
		}
        switch (dwFluencyString) {
        case "REAL":
            dwFluency=NETDEV_PICTURE_FLUENCY_E.NETDEV_PICTURE_REAL;
            break;
        case "FLUENCY":
            dwFluency=NETDEV_PICTURE_FLUENCY_E.NETDEV_PICTURE_FLUENCY;
            break;
        case "BALANCE":
            dwFluency=NETDEV_PICTURE_FLUENCY_E.NETDEV_PICTURE_BALANCE_NEW;
            break;
        default:
            break;
        }
        
		boolean rebt=NetDemo.netdevsdk.NETDEV_SetPictureFluency(NetDemo.lpPlayHandle,dwFluency);
		if(rebt) {
			JOptionPane.showMessageDialog(null, "Success");
		}else {
			System.out.println("NETDEV_SetPictureFluency, error code:" + NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
	}
}
