package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RENDER_SCALE_E;

/**
 * 
 * @introduction  Render scale
 * @description Support IPC/NVR/VMS
 */
public class RenderScale {
    /**
     * 
     * @introduction Change render scale
     * @description Calling the interface of NETDEV_SetRenderScale
     *
     */
	public static void changeRenderScale() {
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
		int  enRenderScale=NetDemo.jComboBoxRenderScale.getSelectedIndex();
		String enRenderScaleString=NetDemo.jComboBoxRenderScale.getItemAt(enRenderScale);
		if(enRenderScaleString==null) {
			return;
		}
		
		switch (enRenderScaleString) {
        case "FULL":
            enRenderScale=NETDEV_RENDER_SCALE_E.NETDEV_RENDER_SCALE_FULL;
            break;
        case "PROPORTION":
            enRenderScale=NETDEV_RENDER_SCALE_E.NETDEV_RENDER_SCALE_PROPORTION;
            break;
        default:
            break;
        }
			
		boolean bRet=NetDemo.netdevsdk.NETDEV_SetRenderScale(NetDemo.lpPlayHandle,enRenderScale);
		if(bRet) {
			System.out.println("Success");
		}else {
			System.out.println("NETDEV_SetRenderScale, error code:" + NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
	}
}
