package main.java.com.netdevsdk.demo.liveview.live;

import javax.swing.JOptionPane;
import main.java.com.netdevsdk.demo.NetDemo;

/**
 * 
 * @introduction Voice intercom
 * @description Support special device with voice intercom
 */
public class Talk {

    /**
     * 
     * @introduction Start voice intercom
     * @description Calling the interface of NETDEV_StartVoiceCom
     *
     */
	public static void startTalk() {	
	      if(null == NetDemo.lpUserID)
	        {
	            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
	            return;
	        }

		NetDemo.lpTalkHandle = NetDemo.netdevsdk.NETDEV_StartVoiceCom(NetDemo.lpUserID, NetDemo.ChannelID, NetDemo.fDecodeAudioDataCallBack,null);
		if(null == NetDemo.lpTalkHandle){
			JOptionPane.showMessageDialog(null, "Start Talk failed.Please check if the control device supports voice talk.");
		}
		else{
		    NetDemo.jButtonStartTalk.setEnabled(false);
		    NetDemo.jButtonStopTalk.setEnabled(true);
		    NetDemo.jButtonMic.setEnabled(true);
		    NetDemo.jSliderLiveMicSound.setEnabled(true);
			
			if(NetDemo.lpPlayHandle==null){
			    NetDemo.getMute2=1;
			    NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpTalkHandle,NetDemo.getMute2);
			    NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpTalkHandle);
			}else{
			    NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpTalkHandle,1);
			    NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpTalkHandle);
			    NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpPlayHandle,1);
			    NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpPlayHandle);
			}
			NetDemo.jSliderLiveSound.setEnabled(true);
						
			if(NetDemo.jLableLiveMicSound.getText().equals("0")) {
				if(NetDemo.lpTalkHandle!=null) {
				    NetDemo.netdevsdk.NETDEV_CloseMic(NetDemo.lpTalkHandle);
				}
			}else {
				if(NetDemo.lpTalkHandle!=null) {
				    NetDemo.netdevsdk.NETDEV_OpenMic(NetDemo.lpTalkHandle);
				}
			}
			NetDemo.jSliderLiveSound.setValue(120);
		}
	}

	/**
	 * 
	 * @introduction Stop voice intercom
	 * @description Call NETDEV_StopVoiceCom to stop voice intercom
	 *
	 */
	public static void stopTak() {
        if(null != NetDemo.lpTalkHandle){
            NetDemo.netdevsdk.NETDEV_StopVoiceCom(NetDemo.lpTalkHandle);
            NetDemo.lpTalkHandle = null;
            NetDemo.jButtonStartTalk.setEnabled(true);
            NetDemo.jButtonStopTalk.setEnabled(false);
            NetDemo.jSliderLiveMicSound.setEnabled(false);
        }
	}
}
