package main.java.com.netdevsdk.demo.playback.config;

import java.util.regex.Pattern;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VOD_PLAY_CTRL_E;

/**
 * 
 * @introduction Play local Record
 * @description Support IPC/NVR/VMS
 */
public class PlayBackPlayLocalFile {
	
    /**
     * 
     * @introduction Start play local file
     * @description Calling the interface of NETDEV_StartPlayMediaFile
     *
     */
	public static void startPlayLocalFile() {
        if(null != NetDemo.lpPlayHandle) {
            JOptionPane.showMessageDialog(null, "Please stop playing first.");
            return;
            }  
        
        if (null!=NetDemo.jTextFieldPlayLocalFile.getText()) {
	        String pszFilename=NetDemo.jTextFieldPlayLocalFile.getText();
	        JOptionPane.showMessageDialog(null, "Filename:"+pszFilename);
	        NetDemo.lpPlayHandle=NetDemo.netdevsdk.NETDEV_OpenMediaFile(pszFilename);
	        }
        
        if(NetDemo.lpPlayHandle==null) {
			NetDemo.jTextFieldPlayLocalFile.setText(null);
			JOptionPane.showMessageDialog(null, "File is not exist");
			return;
		}
		NetDemo.jButtonPlayLocalFile.setEnabled(false);
		NetDemo.jButtonStopLocalFile.setEnabled(true);
		IntByReference pdwTotalTime=new IntByReference();

		boolean bRet2= NetDemo.netdevsdk.NETDEV_GetMediaFileTime(NetDemo.lpPlayHandle, pdwTotalTime);
		if(bRet2) {
			JOptionPane.showMessageDialog(null, "File duration "+pdwTotalTime.getValue()+"s");
			Pointer lpPlayWnd=Native.getComponentPointer(NetDemo.panelPlayLabel);
			
			boolean bRet=NetDemo.netdevsdk.NETDEV_StartPlayMediaFile(NetDemo.lpPlayHandle,lpPlayWnd);
			if(bRet) {
				JOptionPane.showMessageDialog(null, "Play success ");
				NetDemo.netdevsdk.NETDEV_SetMuteStatus(NetDemo.lpPlayHandle,1);
				NetDemo.netdevsdk.NETDEV_OpenSound(NetDemo.lpPlayHandle);
			}else {
				JOptionPane.showMessageDialog(null, "Play media file failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
				System.out.println("NETDEV_StartPlayMediaFile failed"+NetDemo.netdevsdk.NETDEV_GetLastError());
			}
		}else {
			System.out.println("NETDEV_GetMediaFileTime failed"+NetDemo.netdevsdk.NETDEV_GetLastError());
			NetDemo.jButtonStopLocalFile.setEnabled(false);
			NetDemo.jButtonPlayLocalFile.setEnabled(false);
		}
	}
	
	/**
	 * 
	 * @introduction Stop play local file
	 * @description
	 *
	 */
	public static void stopPlayLocalFile() {
		boolean bRet= NetDemo.netdevsdk.NETDEV_StopPlayMediaFile(NetDemo.lpPlayHandle);
		if(bRet) {
			JOptionPane.showMessageDialog(null, "Stop success");
			NetDemo.lpPlayHandle = null;
			NetDemo.jButtonPlayLocalFile.setEnabled(true);
			NetDemo.jButtonStopLocalFile.setEnabled(false);
			NetDemo.panelPlayLabel.repaint();
		}else {
			JOptionPane.showMessageDialog(null, "Stop playing media file failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			System.out.println("NETDEV_StopPlayMediaFile failed"+NetDemo.netdevsdk.NETDEV_GetLastError());
		}
	}
	
	/**
	 * 
	 * @introduction Pause play the file
	 * @description
	 *
	 */
	public static void pausePlayLocalFile() {
		if(NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE == NetDemo.PlayBackControlCmd){
			boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_RESUME, null);
			if(bRet){
				NetDemo.PlayBackControlCmd = NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_RESUME;
				NetDemo.jButtonPlayLocalFilePause.setText("Pause");
			}
		}
		else{
			boolean bRet = NetDemo.netdevsdk.NETDEV_PlayBackControl(NetDemo.lpPlayHandle, NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE, null);
			if(bRet){
				NetDemo.PlayBackControlCmd = NETDEV_VOD_PLAY_CTRL_E.NETDEV_PLAY_CTRL_PAUSE;
				NetDemo.jButtonPlayLocalFilePause.setText("Resume");
			}
		}
	}
	
	/**
	 * 
	 * @introduction Open local Record file
	 * @description Choose local file to play
	 *
	 */
	public static void openFile() {
        String path=null;
        JFileChooser jfierchoose=new JFileChooser();
        jfierchoose.setDialogTitle("请选择上传的文件");
        jfierchoose.setApproveButtonText("确定");
        jfierchoose.setFileSelectionMode(JFileChooser.FILES_ONLY);
        
        if(JFileChooser.APPROVE_OPTION==jfierchoose.showOpenDialog(NetDemo.jPanelliveVoice)) {
            try {
                path=jfierchoose.getSelectedFile().getPath();
            }catch(Exception ee) {
                return;
            }
        }
        if(path==null||path.equals("")) {
            System.out.println("Empty path");
            return;
        }
        
        String name=null;
        try {
            name=path.substring(path.lastIndexOf("."));
        }catch(Exception m1) {
            JOptionPane.showMessageDialog(null, "File does not exist");
            return;
        }
        
        String newpath=null;
        try {
            newpath=path.substring(path.lastIndexOf("."));
        }catch(Exception m2) {
            JOptionPane.showMessageDialog(null, "File does not exist");
            return;
        }
          
        if(newpath==null||newpath.equals("")) {
            JOptionPane.showMessageDialog(null, "Empty path");
            return;
        }
        
        String reg = "(mp4|MP4|FLV|AVI|RM|RMVB|WMV|MPEG|flv|avi|rm|rmvb|wmv|mpeg|nAVI|asf|mov|3gp|DivX|XviD|ts)";
        Pattern p = Pattern.compile(reg);
        boolean bRet = p.matcher(newpath).find();
        if(bRet) {
            JOptionPane.showMessageDialog(null, "Choose file"+name+" success!");
            NetDemo.jTextFieldPlayLocalFile.setText(path);
        }
        else {
            JOptionPane.showMessageDialog(null, "Invalid file type");
        }
    
    }

}
