package main.java.com.netdevsdk.demo.playback.config;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_RECORD_STATUS_LIST_S;

/**
 * 
 * @introduction Get the list of recording status
 * @description Support NVR
 */
public class RecordStatus {
	
	/**
	 * 
	 * @introduction Get the list of recording status
	 * @description Calling the interface of NETDEV_GetDevConfig
	 *
	 */
	public static void  getRecordStatus() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		NetDemo.RecordStatusTableModel.setRowCount(0);
		NETDEV_RECORD_STATUS_LIST_S recordStatus=new NETDEV_RECORD_STATUS_LIST_S();
		recordStatus.write();
		IntByReference dwBytesReturned = new IntByReference();
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_RECORD_STATUS, recordStatus.getPointer(), recordStatus.size(), dwBytesReturned );
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	recordStatus.read();
        	for(int i=0;i<recordStatus.udwSize;i++) {
        		Vector<String> recordStatusList =new Vector<String>();
        		String type=null;
        		if(recordStatus.astRecordStatus[i].dwRecordType==0) {
        			type="Manual Recording";
        		}else if(recordStatus.astRecordStatus[i].dwRecordType==1) {
        			type="Event Recording";
        		}else if(recordStatus.astRecordStatus[i].dwRecordType==2) {
        			type="Transaction Recording";
        		}else if(recordStatus.astRecordStatus[i].dwRecordType==3) {
        			type="Timing Recording";
        		}else if(recordStatus.astRecordStatus[i].dwRecordType==4) {
        			type="Other";
        		}
        		String status=null;
        		if(recordStatus.astRecordStatus[i].dwRecordStatus==0) {
        			status="on video";
        		}else if(recordStatus.astRecordStatus[i].dwRecordStatus==1) {
        			status="Storage not started";
        		}else if(recordStatus.astRecordStatus[i].dwRecordStatus==2) {
        			status="No hard disk or broken";
        		}else if(recordStatus.astRecordStatus[i].dwRecordStatus==3) {
        			status="offline";
        		}
        		 recordStatusList.add(String.valueOf(recordStatus.astRecordStatus[i].dwChannelID));
        		 recordStatusList.add(type);
        		 recordStatusList.add(status);
        		 NetDemo.RecordStatusTableModel.insertRow(i, recordStatusList);
        	}
        	if(recordStatus.udwSize==0) {
        		NetDemo.RecordStatusTableModel.setRowCount(0);
        		JOptionPane.showMessageDialog(null, "No data");
        	}
        	NetDemo.tableRecordStatusList.setModel(NetDemo.RecordStatusTableModel);
        }
	}
}
