package main.java.com.netdevsdk.demo.user;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.Common.NETDEMO_DEVICE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CHN_PERMISSION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LIB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_CHL_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_RULE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_RESULT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOTION_DETECTION_AREA_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_DETAIL_INFO_S;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;

import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.awt.event.ActionEvent;


public class MaintenaceUserInfoWindow extends JDialog{
    
	private static final long serialVersionUID = 1L;
	NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S stGridInfo;
	private JTable UserTable;
	private Pointer lpUserId;
	private int ChannelID;
	JPanel UserInfoPanel = new JPanel();
	Vector User_HeaderNames;
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	
	public MaintenaceUserInfoWindow(Pointer lpUserID,int ChannelID, String userName) {
		this.lpUserId = lpUserID;
		this.ChannelID = ChannelID;
		this.setSize(1400,800);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("User information");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(UserInfoPanel, BorderLayout.CENTER);
		UserInfoPanel.setLayout(null);
		UserInfoPanel.setVisible(true);
		
		//判断登陆设备类型为IPC/NVR
		UserTable = new JTable();
		JScrollPane scrollPaneMaintenanceIPC = new JScrollPane(UserTable,
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPaneMaintenanceIPC.setBounds(33, 20, 1327, 503);
		UserInfoPanel.add(scrollPaneMaintenanceIPC, BorderLayout.CENTER);
		User_HeaderNames = new Vector();
		User_HeaderNames.add("Level");
		User_HeaderNames.add("UserName");
		User_HeaderNames.add("PassWord");
		User_HeaderNames.add("BasePermission");
		User_HeaderNames.add("ChannelID");
		User_HeaderNames.add("Permission");

		Vector data = this.getData(userName);
		TableModel tableModel = new DefaultTableModel(data,User_HeaderNames);
		UserTable.setModel(tableModel);	
    }

	public Vector getData(String userName) {
		 Vector data = new Vector();

		NETDEV_USER_DETAIL_INFO_S pstUserDetailInfo = new NETDEV_USER_DETAIL_INFO_S();
		for(int i = 0; i < NetDEVSDKLib.NETDEV_CHANNEL_MAX; i++)
		{
			pstUserDetailInfo.astChnPermission[i] = new NETDEV_CHN_PERMISSION_INFO_S();
		}
		Common.stringToByteArray(userName,pstUserDetailInfo.szUserName);
		pstUserDetailInfo.write();
		boolean bRet = netdevsdk.NETDEV_GetUserDetailInfo(lpUserId, pstUserDetailInfo);
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetUserDetailInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
            return null;
        }
        pstUserDetailInfo.read();

		int i=0;
		while(i<pstUserDetailInfo.udwNum || (pstUserDetailInfo.udwNum == 0 && i <= pstUserDetailInfo.udwNum)){
			
			Vector vtData = new Vector();
			vtData.add(pstUserDetailInfo.udwLevel);
			vtData.add(Common.byteArrayToString(pstUserDetailInfo.szUserName));
			vtData.add(Common.byteArrayToString(pstUserDetailInfo.szPassword));
			vtData.add(pstUserDetailInfo.udwBasePermission);
			vtData.add(pstUserDetailInfo.astChnPermission[i].dwChannelID);
			vtData.add(pstUserDetailInfo.astChnPermission[i].dwPermission);
			data.add(vtData);
			i++;
		}
	    return data;
	}
}
