package main.java.com.netdevsdk.demo.vca.accesscontrol;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LAPI_SUB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SUBSCRIBE_SUCC_INFO_S;

/**
 * @description To subscribe alarm and close subscribing alarm.
 * @introduction Only support VMS.
 */
public class DataReport {
    /**
     * @description To subscribe alarm.
     * @introduction Calling the interface of NETDEV_SubscibeLapiAlarm NETDEV_SetAlarmFGCallBack
     */
    public static void subscribeAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) 
        {
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetAlarmFGCallBack(NetDemo.lpUserID, NetDemo.pfAlarmMessFGCB, NetDemo.lpUserID);
               if(true != bRet)
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                   System.out.println("NETDEV_SetAlarmFGCallBack fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                   return;
               }
               NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
               NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
               stSubInfo.udwType = 1024;
               stSubInfo.udwLibIDNum=0xffff;
               boolean bRet2 = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
               if(true != bRet2)
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                   System.out.println("NETDEV_SubscibeLapiAlarm fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
               }
               else
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm success");
                   System.out.println("SubscribeLapiAlarm success");
                   NetDemo.dwAccessControlFGMointerID = stSubSuccInfo.udwID;    
               }   
        }
        else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) 
        {
            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetAlarmFGCallBack(NetDemo.lpUserID, NetDemo.pfAlarmMessFGCB, NetDemo.lpUserID);
               if(true != bRet2)
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                   System.out.println("NETDEV_SetAlarmFGCallBack fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                   return;
               }
               NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
               NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
       
               stSubInfo.udwType = 1024;
               stSubInfo.udwLibIDNum=0xffff;
               boolean bRet3 = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
               if(true != bRet3)
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                   System.out.println("NETDEV_SubscibeLapiAlarm fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
               }
               else
               {
                   JOptionPane.showMessageDialog(null, "SubscribeAlarm success");
                   System.out.println("SubscibeLapiAlarm success");
                   NetDemo.dwAccessControlFGMointerID = stSubSuccInfo.udwID;       
               } 
        }
        else 
        {
               JOptionPane.showMessageDialog(null, "Not support ");
               return;
        }
    }
    /**
     * @description To cancel subscribing alarm.
     * @introduction Calling the interface of NETDEV_UnSubLapiAlarm and NETDEV_SetAlarmFGCallBack.
     */
    public static void unsubscribeAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS){
            boolean flag = NetDemo.netdevsdk.NETDEV_SetAlarmFGCallBack(NetDemo.lpUserID, null, NetDemo.lpUserID);
            if(true != flag)
            {
                JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.println("NETDEV_SetAlarmFGCallBack fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwAccessControlFGMointerID);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.println("NETDEV_UnSubLapiAlarm failed:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "UnSubscribeAlarm success");
            }
            NetDemo.dwAccessControlFGMointerID = -1;
        }
        else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)
        {   
            boolean flag=NetDemo.netdevsdk.NETDEV_SetAlarmFGCallBack(NetDemo.lpUserID, null, NetDemo.lpUserID);
        if(true != flag)
        {
            JOptionPane.showMessageDialog(null, "SubscribeAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.println("NETDEV_SetAlarmFGCallBack fail:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwAccessControlFGMointerID);
        if(false == bRet){
            JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.println("NETDEV_UnSubLapiAlarm failed:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "UnSubscribeAlarm success");
        }
        NetDemo.dwAccessControlFGMointerID = -1;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Not support ");
            return;
        }
    }
    
}
