package main.java.com.netdevsdk.demo.vca.face;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_LIB_CAP_LIST_S;

import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JTextField;
import javax.swing.JLabel;

public class PersonLibCapacityWindow extends JDialog{
	
	private Pointer lpUserId;
	
	private JTable PersonLibTable;
	
	public static JButton btnGet;
	
	JPanel  PersonLibWindowPanel = new JPanel();
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	
	private DefaultTableModel PersonLibTableModel = new DefaultTableModel(
			new Object[][] {
	        },
	        new String[] {
		        "ID", "Capacity Number"
	        }
        );
	private JTextField textField;

	public PersonLibCapacityWindow(Pointer lpUserID) {
		this.lpUserId = lpUserID;
		this.setSize(700,400);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Person Lib");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(PersonLibWindowPanel, BorderLayout.CENTER);
        PersonLibWindowPanel.setLayout(null);
        
		
		JTextField textudwMaxPerpleMun = new JTextField();
		textudwMaxPerpleMun.setBounds(105, 43, 60, 21);
		PersonLibWindowPanel.add(textudwMaxPerpleMun);
		textudwMaxPerpleMun.setColumns(10);
		textudwMaxPerpleMun.setEditable(false);
		
		JTextField textudwFreePerpleNum = new JTextField();
		textudwFreePerpleNum.setBounds(283, 43, 60, 21);
		PersonLibWindowPanel.add(textudwFreePerpleNum);
		textudwFreePerpleNum.setColumns(10);
		textudwFreePerpleNum.setEditable(false);
		
		JTextField textudwMaxLibNum = new JTextField();
		textudwMaxLibNum.setBounds(444, 43, 60, 21);
		PersonLibWindowPanel.add(textudwMaxLibNum);
		textudwMaxLibNum.setColumns(10);
		textudwMaxLibNum.setEditable(false);
		
		
		JTextField textudwFreeLibNum = new JTextField();
		textudwFreeLibNum.setBounds(614, 43, 60, 21);
		PersonLibWindowPanel.add(textudwFreeLibNum);
		textudwFreeLibNum.setColumns(10);
		textudwFreeLibNum.setEditable(false);
        
        JTable PersonLibTable = new JTable();
        PersonLibTable.setBounds(30, 140, 400, 100);
		JScrollPane scrollPaneConfigPlanTable = new JScrollPane(PersonLibTable,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
	    		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPaneConfigPlanTable.setBounds(10, 87, 664, 153);
		PersonLibWindowPanel.add(scrollPaneConfigPlanTable);
		PersonLibTable.setModel(PersonLibTableModel);
		
		btnGet = new JButton("Get");
		
		JButton btnNewButton = new JButton("Refersh");
		
		btnNewButton.setBounds(154, 267, 93, 23);
		PersonLibWindowPanel.add(btnNewButton);
		
		btnNewButton.setVisible(false);
		btnGet.setVisible(false);
		
		btnGet.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(null == lpUserId){
					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
					return ;
				}
				PersonLibTableModel.setRowCount(0);
				NETDEV_PERSON_LIB_CAP_LIST_S list=new NETDEV_PERSON_LIB_CAP_LIST_S();
				list.udwNum=16;
				list.write();
				boolean get=netdevsdk.NETDEV_GetPersonLibCapacity(lpUserID, 20, list);
				if(get) {
					list.read();
					textudwMaxPerpleMun.setText(String.valueOf(list.udwMaxPerpleMun));
					textudwFreePerpleNum.setText(String.valueOf(list.udwFreePerpleNum));
					textudwMaxLibNum.setText(String.valueOf(list.udwMaxLibNum));
					textudwFreeLibNum.setText(String.valueOf(list.udwFreeLibNum));
					for(int i=0;i<list.udwNum;i++) {
						Vector data=new Vector();
						data.add(list.stLibCapInfoList[i].udwLibID);
						data.add(list.stLibCapInfoList[i].udwCapacity);
						PersonLibTableModel.insertRow(i,data);
					}
					PersonLibTable.setModel(PersonLibTableModel);
					btnNewButton.doClick();
				}else {
					System.out.printf("NETDEV_GetDevConfig failed:%d\n", netdevsdk.NETDEV_GetLastError());
					JOptionPane.showMessageDialog(null, "Get personLib capacity failed!");
		            return ;
				}
				
			}
		});
		btnGet.setBounds(34, 267, 93, 23);
		PersonLibWindowPanel.add(btnGet);
		
		JLabel lblMaxPerplemun = new JLabel("Max PeopleNum:");
		lblMaxPerplemun.setBounds(10, 46, 95, 15);
		PersonLibWindowPanel.add(lblMaxPerplemun);
		
		JLabel lblFreeperplenum = new JLabel("Free PeopleNum:");
		lblFreeperplenum.setBounds(187, 46, 98, 15);
		PersonLibWindowPanel.add(lblFreeperplenum);
		
		JLabel lbludwMaxLibNum = new JLabel("Max LibNum:");
		lbludwMaxLibNum.setBounds(370, 46, 80, 15);
		PersonLibWindowPanel.add(lbludwMaxLibNum);
		
		JLabel lblFreeLibnum = new JLabel("Free LibNum:");
		lblFreeLibnum.setBounds(536, 46, 80, 15);
		PersonLibWindowPanel.add(lblFreeLibnum);
		
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				
				List list=new ArrayList();
				
		        Vector v=null;
		        Vector get1=null;
				for(int s=0;s<PersonLibTableModel.getRowCount();s++) {
					get1=new Vector();
					get1.add(PersonLibTableModel.getValueAt(s, 0));
					get1.add(PersonLibTableModel.getValueAt(s, 1));
					list.add(get1);
				}
				List getcheckList=(List) list.stream().distinct().collect(Collectors.toList());
		        
				PersonLibTableModel.setRowCount(0);
				for(int u=0;u<getcheckList.size();u++) {
					
					Vector send=(Vector) getcheckList.get(u);
					
					PersonLibTableModel.insertRow(u,send);
				}
				PersonLibTable.setModel(PersonLibTableModel);
			}
		});
		

		btnGet.doClick();
		btnNewButton.doClick();


	}
}
