package main.java.com.netdevsdk.demo.vca.peoplecounting;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_OPERATE_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRAFFIC_STATISTICS_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TRAFFIC_STATISTICS_TYPE_E;

/**
 * @description NVR/VMS data report and find data records.
 * @introduction Support NVR/VMS. 
 */
public class NVRPeopleCounting {
    /**
     * @description To start NVR/VMS data report.
     * @introduction It is mainly realized by the CountThread.execute.
     */
    public static void startRealTime() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NetDemo.flag=true;
        NetDemo.CountThread.execute(NetDemo.t);
    }
    /**
     * @description To stop NVR/VMS data report
     * @introduction Calling the interface of NETDEV_StopTrafficStatistic.
     */
    public static void stopRealTime() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }   
        NetDemo.flag=false;
        int searchId=0;
        try {
            searchId = NetDemo.udwSearchID.getValue();
        }catch(Exception t) {
            return;
        }
        boolean rBet = NetDemo.netdevsdk.NETDEV_StopTrafficStatistic(NetDemo.lpUserID,searchId);
        if(rBet) 
        {
            JOptionPane.showMessageDialog(null, "Stop success");
            NetDemo.t.run();
            NetDemo.udwSearchID=null;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "StopTrafficStatistic failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_StopTrafficStatistic failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    }
    /**
     * @description To find  data records.
     * @introduction  Calling the interface of NETDEV_StartMultiTrafficStatistic,NETDEV_GetTrafficStatisticProgress,NETDEV_FindTrafficStatisticInfoList,NETDEV_FindCloseTrafficStatisticInfo.
     */
    public static void dataStatistics() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NetDemo.PeopleCountingVMSNVRStatistalTableModel.setRowCount(0);
        boolean bRet = false;
        NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S stStatisticCond = new NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S();
        stStatisticCond.stChannelIDs = new NETDEV_OPERATE_LIST_S();
        stStatisticCond.stChannelIDs.pstOperateInfo = new Memory(4);
        stStatisticCond.stChannelIDs.pstOperateInfo.setInt(0, NetDemo.ChannelID);
        stStatisticCond.stChannelIDs.dwSize = 1;
        stStatisticCond.udwFormType =  NetDemo.jComboBoxPeopleCountingVMSNVRStatisticalReportType.getSelectedIndex();
        stStatisticCond.udwStatisticsType = NETDEV_TRAFFIC_STATISTICS_TYPE_E.NETDEV_TRAFFIC_STATISTICS_TYPE_ALL;
        String getCountingVMSNVRStatisticsBeginTime =  NetDemo.CountingVMSNVRStatisticsBeginTime.getText();
        long get1=Common.date2TimeStamp(getCountingVMSNVRStatisticsBeginTime.toString(),  NetDemo.DateFormat);
        String getCountingVMSNVRStattisticsEndTime =  NetDemo.CountingVMSNVRStattisticsEndTime.getText();
        long get2=Common.date2TimeStamp(getCountingVMSNVRStattisticsEndTime.toString(),  NetDemo.DateFormat);
        if(get1>get2) 
        {
            JOptionPane.showMessageDialog(null, "Start time can not more than end time");
            return;
        }
        stStatisticCond.tBeginTime = get1;
        stStatisticCond.tEndTime = get2;
        IntByReference udwSearchID = new IntByReference();
        bRet =  NetDemo.netdevsdk.NETDEV_StartMultiTrafficStatistic( NetDemo.lpUserID, stStatisticCond, udwSearchID);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "StartMultiTrafficStatistic failed error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_StartMultiTrafficStatistic failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        int count=0;
        /*查询统计进度 Query statistics progress */
        while(true)
        {
            IntByReference dwProgress = new IntByReference();
            bRet =  NetDemo.netdevsdk.NETDEV_GetTrafficStatisticProgress( NetDemo.lpUserID, udwSearchID.getValue(), dwProgress);
            count++;
            if(count==100) 
            {
                JOptionPane.showMessageDialog(null, "Wait more than 100s,data is to large,please reinput time");
                return;
            }
            if(dwProgress.getValue() == 100)
            {
                break;
            }
            else
            {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
        Pointer lpStaticHandle = NetDemo.netdevsdk.NETDEV_FindTrafficStatisticInfoList(NetDemo.lpUserID, udwSearchID.getValue());
        if(lpStaticHandle != null)
        {
            while(true)
            {
                NETDEV_TRAFFIC_STATISTICS_INFO_S stStatisticInfo = new NETDEV_TRAFFIC_STATISTICS_INFO_S();
                bRet = NetDemo.netdevsdk.NETDEV_FindNextTrafficStatisticInfo(lpStaticHandle, stStatisticInfo);
                System.out.println("1");
                if(bRet != true)
                {
                    break;
                }
                else
                {
                    for(int i = 0; i < stStatisticInfo.udwSize; i++)
                    {
                        Vector<String> StatisticInfoVector = new Vector<String>();

                        StatisticInfoVector.add(String.valueOf(stStatisticInfo.dwChannelID));
                        StatisticInfoVector.add(String.valueOf(i));
                        StatisticInfoVector.add(String.valueOf(stStatisticInfo.audwEnterCount[i]));
                        StatisticInfoVector.add(String.valueOf(stStatisticInfo.audwExitCount[i]));
                        NetDemo.PeopleCountingVMSNVRStatistalTableModel.addRow(StatisticInfoVector);
                    }
                }
            }
            bRet =  NetDemo.netdevsdk.NETDEV_FindCloseTrafficStatisticInfo(lpStaticHandle);
            if(false == bRet)
            {
                System.out.printf("NETDEV_FindCloseTrafficStatisticInfo failed:%d\n",  NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
    
    }
}
