
#include "stdafx.h"
#include "NetDemo.h"
#include "CfgAttrCollect.h"


// CCfgAttrCollect 

IMPLEMENT_DYNAMIC(CCfgAttrCollect, CDialog)

CCfgAttrCollect::CCfgAttrCollect(CWnd* pParent /*=NULL*/)
    : CDialog(CCfgAttrCollect::IDD, pParent)
{
    memset(&m_stAttrCollectInfo, 0, sizeof(NETDEV_ATTR_COLLECT_INFO_S));

}

CCfgAttrCollect::~CCfgAttrCollect()
{
}

void CCfgAttrCollect::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_GENDER, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableGender);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_AGE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableAge);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_MARKFLAG, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableMaskFlag);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_UPPER_COLOR, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpperColor);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_LOWER_COLOR, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableLowerColor);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_UPPER_STYLE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpperClothingStyle);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_LOWER_STYLE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableLowerClothingStyle);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_UPPER_TEXTURE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpClothesTexture);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_BAG_INFO, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableBagInfo);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_BODY_ANGLE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableBodyAngle);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_SHOES, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableShoes);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_HAIR_STYLE, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableHairStyle);
    DDX_Check(pDX, IDC_CHECK_EDNABLE_DIRECTION, m_stAttrCollectInfo.stPedAttrInfo.bIsEnableDirection);

}


BEGIN_MESSAGE_MAP(CCfgAttrCollect, CDialog)
    ON_BN_CLICKED(IDC_SAVE_ATTRCOLLECT, &CCfgAttrCollect::OnBnClickedSaveAttrcollect)
    ON_BN_CLICKED(IDC_REFRESH_ATTRCOLLECT, &CCfgAttrCollect::OnBnClickedRefreshAttrcollect)
END_MESSAGE_MAP()

BOOL CCfgAttrCollect::OnInitDialog()
{
    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);


    return TRUE;
}

/* Get AttrCollect Config */
void CCfgAttrCollect::getAttrCollectCfg()
{
    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();

    NETDEV_ATTR_COLLECT_INFO_S stAttrCollectInfo;
    memset(&stAttrCollectInfo, 0, sizeof(stAttrCollectInfo));
    INT32 dwBytesReturned = 0;
    BOOL bRet = NETDEV_GetDevConfig(lpDevHandle, dwChannelID, NETDEV_GET_ATTR_COLLECT_INFO, &stAttrCollectInfo, sizeof(NETDEV_ATTR_COLLECT_INFO_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "Get Attr Collect info");
        return;
    }

    memcpy(&m_stAttrCollectInfo,&stAttrCollectInfo,sizeof(NETDEV_ATTR_COLLECT_INFO_S));

    LPNETDEV_ATTR_COLLECT_INFO_S pstAttrCollectInfo = gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo;
    memcpy(pstAttrCollectInfo ,&stAttrCollectInfo,sizeof(stAttrCollectInfo));
    NETDEMO_LOG_SUCC(NULL, "Get Attr Collect info");

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableGender == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_GENDER))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_GENDER))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableAge == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_AGE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_AGE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableMaskFlag == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_MARKFLAG))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_MARKFLAG))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpperColor == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_COLOR))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_COLOR))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableLowerColor == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_LOWER_COLOR))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_LOWER_COLOR))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpperClothingStyle == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_STYLE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_STYLE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableLowerClothingStyle == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_LOWER_STYLE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_LOWER_STYLE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableUpClothesTexture == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_TEXTURE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_UPPER_TEXTURE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableBagInfo == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_BAG_INFO))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_BAG_INFO))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableBodyAngle == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_BODY_ANGLE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_BODY_ANGLE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableShoes == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_SHOES))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_SHOES))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableHairStyle == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_HAIR_STYLE))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_HAIR_STYLE))->SetCheck(FALSE);
    }

    if(m_stAttrCollectInfo.stPedAttrInfo.bIsEnableDirection == TRUE)
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_DIRECTION))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_CHECK_EDNABLE_DIRECTION))->SetCheck(FALSE);
    }
    UpdateData(FALSE);

    return;
}

void CCfgAttrCollect::ReadGlobeToAttrCollect()
{
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();

    NETDEV_ATTR_COLLECT_INFO_S stAttrCollectInfo;
    if(NULL == gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo)
    {
        return;
    }
    LPNETDEV_ATTR_COLLECT_INFO_S pstAttrCollectInfo = gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo;
    if(NULL != pstAttrCollectInfo)
    {
        memcpy(&stAttrCollectInfo,pstAttrCollectInfo,sizeof(NETDEV_ATTR_COLLECT_INFO_S));
    }

    memcpy(&m_stAttrCollectInfo,&stAttrCollectInfo,sizeof(NETDEV_ATTR_COLLECT_INFO_S));

    UpdateData(FALSE);
}

/* Save AttrCollect Config */
void CCfgAttrCollect::OnBnClickedSaveAttrcollect()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();

    /* ѡ״ֵ̬· */
    NETDEV_ATTR_COLLECT_INFO_S stAttrCollectInfo;
    memset(&stAttrCollectInfo, 0, sizeof(NETDEV_ATTR_COLLECT_INFO_S));
    memcpy( &stAttrCollectInfo,&m_stAttrCollectInfo,sizeof(NETDEV_ATTR_COLLECT_INFO_S));

    BOOL bRet = NETDEV_SetDevConfig(lpDevHandle, dwChannelID, NETDEV_SET_ATTR_COLLECT_INFO, &stAttrCollectInfo, sizeof(NETDEV_ATTR_COLLECT_INFO_S));
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "Save Attr Collect Info");
        return;
    }
    LPNETDEV_ATTR_COLLECT_INFO_S pstAttrCollectInfo= gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo;
    if(NULL != pstAttrCollectInfo)
    {
         memcpy( pstAttrCollectInfo,&stAttrCollectInfo,sizeof(stAttrCollectInfo));
    }
    NETDEMO_LOG_SUCC(NULL, "Save Attr Collect Info");

    return;
}

/* Refresh */
void CCfgAttrCollect::OnBnClickedRefreshAttrcollect()
{
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();
    if(dwCurChlIndex <0 )
    {
        return;
    }
    if (NULL != gastDeviceInfo && NULL != gastDeviceInfo[dwCurDevIndex].pstChlInfo)
    {
        if(NULL == gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo)
        {
            gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo = new NETDEV_ATTR_COLLECT_INFO_S;
        }
        memset(gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstAttrCollectInfo ,0,sizeof(NETDEV_ATTR_COLLECT_INFO_S));

        /* Get AttrCollect config */ 
        getAttrCollectCfg();

    }

    UpdateData(FALSE);

    return;
}
