// DlgConfigureImage.cpp : 
//

#include "stdafx.h"
#include "NetDemo.h"
#include "CfgImage.h"


// CCfgImage 

IMPLEMENT_DYNAMIC(CCfgImage, CDialog)

CCfgImage::CCfgImage(CWnd* pParent /*=NULL*/)
    : CDialog(CCfgImage::IDD, pParent)
    , m_dwBrightness(128)
    , m_dwContrast(128)
    , m_dwSaturation(128)
    , m_dwSharpness(128)
    , m_udwExposureMode(0)
    , m_udwShutter(0)
    , m_udwGain(0)
    , m_udwMinIris(0)
    , m_udwMaxIris(0)
    , m_udwCompensation(0)
    , m_udwSence(0)
    , m_udwMode(0)
    , m_udwSwitch(0)
    , m_udwWDR(0)
    , m_udwWDRLevel(0)
    , m_udwMinShutter(0)
    , m_udwMaxShutter(0)
    , m_udwMinGain(0)
    , m_udwMaxGain(0)
{
    memset(&m_stImageExposure, 0, sizeof(m_stImageExposure));
}

CCfgImage::~CCfgImage()
{
}

void CCfgImage::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_BRIGHTNESS, m_dwBrightness);
    DDX_Text(pDX, IDC_EDIT_SHARPNESS, m_dwSharpness);
    DDX_Text(pDX, IDC_EDIT_CONTRAST, m_dwContrast);
    DDX_Text(pDX, IDC_EDIT_SATURATION, m_dwSaturation);

    DDX_Control(pDX, IDC_SLIDER_BRIGHTNESS, m_oSldBrightness);
    DDX_Control(pDX, IDC_SLIDER_CONTRAST, m_oSldContrast);
    DDX_Control(pDX, IDC_SLIDER_SATURATION, m_oSldSaturation);
    DDX_Control(pDX, IDC_SLIDER_SHARPNESS, m_oSldSharpness);
    DDX_Text(pDX, IDC_EDIT1, m_udwExposureMode);
    DDX_Text(pDX, IDC_EDIT2, m_udwShutter);
    DDX_Text(pDX, IDC_EDIT4, m_udwGain);
    DDX_Text(pDX, IDC_EDIT9, m_udwMinIris);
    DDX_Text(pDX, IDC_EDIT8, m_udwMaxIris);
    DDX_Text(pDX, IDC_EDIT6, m_udwCompensation);
    DDX_Text(pDX, IDC_EDIT5, m_udwSence);
    DDX_Text(pDX, IDC_EDIT7, m_udwMode);
    DDX_Text(pDX, IDC_EDIT10, m_udwSwitch);
    DDX_Text(pDX, IDC_EDIT11, m_udwWDR);
    DDX_Text(pDX, IDC_EDIT12, m_udwWDRLevel);
    DDX_Text(pDX, IDC_EDIT17, m_udwMinShutter);
    DDX_Text(pDX, IDC_EDIT16, m_udwMaxShutter);
    DDX_Text(pDX, IDC_EDIT14, m_udwMinGain);
    DDX_Text(pDX, IDC_EDIT15, m_udwMaxGain);
}


BEGIN_MESSAGE_MAP(CCfgImage, CDialog)
    ON_BN_CLICKED(IDC_SAVE_IMAGE_INFO, &CCfgImage::OnBnClickedSaveImageInfo)
    ON_BN_CLICKED(IDC_REFRESH_IMAGE_CFG, &CCfgImage::OnBnClickedRefresh)
    ON_WM_HSCROLL()
    ON_EN_CHANGE(IDC_EDIT_BRIGHTNESS, &CCfgImage::OnEnChangeEditBrightness)
    ON_EN_KILLFOCUS(IDC_EDIT_BRIGHTNESS, &CCfgImage::OnEnKillfocusEditBrightness)
    ON_EN_CHANGE(IDC_EDIT_SATURATION, &CCfgImage::OnEnChangeEditSaturation)
    ON_EN_KILLFOCUS(IDC_EDIT_SATURATION, &CCfgImage::OnEnKillfocusEditSaturation)
    ON_EN_CHANGE(IDC_EDIT_CONTRAST, &CCfgImage::OnEnChangeEditContrast)
    ON_EN_KILLFOCUS(IDC_EDIT_CONTRAST, &CCfgImage::OnEnKillfocusEditContrast)
    ON_EN_KILLFOCUS(IDC_EDIT_SHARPNESS, &CCfgImage::OnEnKillfocusEditSharpness)
    ON_EN_CHANGE(IDC_EDIT_SHARPNESS, &CCfgImage::OnEnChangeEditSharpness)
    ON_BN_CLICKED(IDC_BUTTON1, &CCfgImage::OnGetExposureInfo)
    ON_BN_CLICKED(IDC_BUTTON2, &CCfgImage::OnSetExposureInfo)
END_MESSAGE_MAP()


BOOL CCfgImage::OnInitDialog()
{
    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);

    m_oSldBrightness.SetRange(0, 255);
    m_oSldBrightness.SetTicFreq(1);
    m_oSldBrightness.SetPos(128);

    m_oSldContrast.SetRange(0, 255);
    m_oSldContrast.SetTicFreq(1);
    m_oSldContrast.SetPos(128);

    m_oSldSaturation.SetRange(0, 255);
    m_oSldSaturation.SetTicFreq(1);
    m_oSldSaturation.SetPos(128);

    m_oSldSharpness.SetRange(0, 255);
    m_oSldSharpness.SetTicFreq(1);
    m_oSldSharpness.SetPos(128);

    return TRUE;
}

void CCfgImage::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    char szTmp[16] = {0};
    if(IDC_SLIDER_BRIGHTNESS == pScrollBar->GetDlgCtrlID())
    {
        nPos = m_oSldBrightness.GetPos();
        sprintf_s(szTmp, sizeof(szTmp), "%d", nPos);
        GetDlgItem(IDC_EDIT_BRIGHTNESS)->SetWindowText(szTmp);
        m_dwBrightness = nPos;
    }

    if(IDC_SLIDER_CONTRAST == pScrollBar->GetDlgCtrlID())
    {
        nPos = m_oSldContrast.GetPos();
        sprintf_s(szTmp, sizeof(szTmp), "%d", nPos);
        GetDlgItem(IDC_EDIT_CONTRAST)->SetWindowText(szTmp);
        m_dwContrast = nPos;
    }

    if(IDC_SLIDER_SATURATION == pScrollBar->GetDlgCtrlID())
    {
        nPos = m_oSldSaturation.GetPos();
        sprintf_s(szTmp, sizeof(szTmp), "%d", nPos);
        GetDlgItem(IDC_EDIT_SATURATION)->SetWindowText(szTmp);
        m_dwSaturation = nPos;
    }

    if(IDC_SLIDER_SHARPNESS == pScrollBar->GetDlgCtrlID())
    {
        nPos = m_oSldSharpness.GetPos();
        sprintf_s(szTmp, sizeof(szTmp), "%d", nPos);
        GetDlgItem(IDC_EDIT_SHARPNESS)->SetWindowText(szTmp);
        m_dwSharpness = nPos;
    }

    CDialog::OnHScroll(nSBCode, nPos, pScrollBar);

    UpdateData(FALSE);
    return;
}

/* Get Image Config */
void CCfgImage::getImageCfg()
{
    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();

    INT32 dwBytesReturned = 0;
    NETDEV_IMAGE_SETTING_S stImageInfo = {0};

    BOOL bRet = NETDEV_GetDevConfig(lpDevHandle, dwChannelID, NETDEV_GET_IMAGECFG, &stImageInfo, sizeof(NETDEV_IMAGE_SETTING_S), &dwBytesReturned);
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "Get image info");
        return;
    }

    m_dwBrightness = stImageInfo.dwBrightness;
    m_dwContrast = stImageInfo.dwContrast;
    m_dwSaturation = stImageInfo.dwSaturation;
    m_dwSharpness = stImageInfo.dwSharpness;

    m_oSldBrightness.SetPos(m_dwBrightness);
    m_oSldSaturation.SetPos(m_dwSaturation);
    m_oSldSharpness.SetPos(m_dwSharpness);
    m_oSldContrast.SetPos(m_dwContrast);
    memcpy(gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo, &stImageInfo,sizeof(NETDEV_IMAGE_SETTING_S));

    NETDEMO_LOG_SUCC(NULL, "Get image info");

    UpdateData(FALSE);
    return;
}

void CCfgImage::OnBnClickedSaveImageInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();

    NETDEV_IMAGE_SETTING_S stImageInfo = {0};

    stImageInfo.dwContrast = m_dwContrast;
    stImageInfo.dwBrightness = m_dwBrightness;
    stImageInfo.dwSaturation = m_dwSaturation;
    stImageInfo.dwSharpness = m_dwSharpness;

    BOOL bRet = NETDEV_SetDevConfig(lpDevHandle, dwChannelID, NETDEV_SET_IMAGECFG, &stImageInfo, sizeof(NETDEV_IMAGE_SETTING_S));
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "Save image info");
        return;
    }
    if(NULL != gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo)
    {
        memcpy(gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo, &stImageInfo,sizeof(NETDEV_IMAGE_SETTING_S));
    }
    NETDEMO_LOG_SUCC(NULL, "Save image info");

    return;
}

void CCfgImage::ReadGlobeToImage()
{
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();
    
    NETDEV_IMAGE_SETTING_S stImageInfo;
    if(NULL != gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo)
    {
        memcpy(&stImageInfo,gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo,sizeof(NETDEV_IMAGE_SETTING_S));
    }
    m_dwBrightness = stImageInfo.dwBrightness;
    m_dwContrast = stImageInfo.dwContrast;
    m_dwSaturation = stImageInfo.dwSaturation;
    m_dwSharpness = stImageInfo.dwSharpness;

    m_oSldBrightness.SetPos(m_dwBrightness);
    m_oSldSaturation.SetPos(m_dwSaturation);
    m_oSldSharpness.SetPos(m_dwSharpness);
    m_oSldContrast.SetPos(m_dwContrast);
    UpdateData(FALSE);
}

void CCfgImage::OnBnClickedRefresh()
{
    INT32 dwCurDevIndex = ga_pMainDlg ->GetCurDeviceIndex();
    INT32 dwCurChlIndex = ga_pMainDlg->GetCurChlIndex();
    if(dwCurChlIndex <0 )
    {
        return;
    }
    if (NULL != gastDeviceInfo && NULL != gastDeviceInfo[dwCurDevIndex].pstChlInfo)
    {
        if(NULL == gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo)
        {
            gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo = new NETDEV_IMAGE_SETTING_S;
        }
        memset(gastDeviceInfo[dwCurDevIndex].pstChlInfo[dwCurChlIndex].pstImageInfo ,0,sizeof(NETDEV_IMAGE_SETTING_S));
        /* Get Image Config */
        getImageCfg();
    }

    UpdateData(FALSE);
    return;
}


void CCfgImage::OnEnChangeEditBrightness()
{
    UpdateData(TRUE);
    m_oSldBrightness.SetPos(m_dwBrightness);

    return;
}

void CCfgImage::OnEnKillfocusEditBrightness()
{
    UpdateData(TRUE);
    if (m_dwBrightness < 0)
    {
        m_dwBrightness = 0;
    }
    else if (m_dwBrightness > 255)
    {
        m_dwBrightness = 255;
    }

    char szTmp[16] = {0};
    sprintf_s(szTmp, sizeof(szTmp), "%d", m_dwBrightness);
    GetDlgItem(IDC_EDIT_BRIGHTNESS)->SetWindowText(szTmp);

    UpdateData(FALSE);
    return;
}

void CCfgImage::OnEnChangeEditSaturation()
{
    UpdateData(TRUE);
    m_oSldSaturation.SetPos(m_dwSaturation);

    return;
}

void CCfgImage::OnEnKillfocusEditSaturation()
{
    UpdateData(TRUE);
    if (m_dwSaturation < 0)
    {
        m_dwSaturation = 0;
    }
    else if (m_dwSaturation > 255)
    {
        m_dwSaturation = 255;
    }

    char szTmp[16] = {0};
    sprintf_s(szTmp, sizeof(szTmp), "%d", m_dwSaturation);
    GetDlgItem(IDC_EDIT_SATURATION)->SetWindowText(szTmp);

    UpdateData(FALSE);
    return;
}

void CCfgImage::OnEnChangeEditContrast()
{
    UpdateData(TRUE);
    m_oSldContrast.SetPos(m_dwContrast);

    return;
}

void CCfgImage::OnEnKillfocusEditContrast()
{
    UpdateData(TRUE);
    if (m_dwContrast < 0)
    {
        m_dwContrast = 0;
    }
    else if (m_dwContrast > 255)
    {
        m_dwContrast = 255;
    }

    char szTmp[16] = {0};
    sprintf_s(szTmp, sizeof(szTmp), "%d", m_dwContrast);
    GetDlgItem(IDC_EDIT_CONTRAST)->SetWindowText(szTmp);

    UpdateData(FALSE);
    return;
}

void CCfgImage::OnEnChangeEditSharpness()
{
    UpdateData(TRUE);
    m_oSldSharpness.SetPos(m_dwSharpness);

    return;
}


void CCfgImage::OnEnKillfocusEditSharpness()
{
    UpdateData(TRUE);
    if (m_dwSharpness < 0)
    {
        m_dwSharpness = 0;
    }
    else if (m_dwSharpness > 255)
    {
        m_dwSharpness = 255;
    }

    char szTmp[16] = {0};
    sprintf_s(szTmp, sizeof(szTmp), "%d", m_dwSharpness);
    GetDlgItem(IDC_EDIT_SHARPNESS)->SetWindowText(szTmp);

    UpdateData(FALSE);
    return;
}


void CCfgImage::OnGetExposureInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwChnType = NETDEV_GET_IMAGE_EXPOSURE;
    NETDEV_IMAGE_EXPOSURE_S stImageExposure = {0};
    INT32 dwBytesReturned = 0;
    memset(&m_stImageExposure, 0, sizeof(m_stImageExposure));
    BOOL iRet = NETDEV_GetDevConfig(lpDevHandle, dwChannelID, dwChnType, &stImageExposure, sizeof(stImageExposure), &dwBytesReturned);
    if(TRUE != iRet)
    {
        NETDEMO_LOG_ERROR(NULL, "get Image Advanced Exposure fail");
    }
    else
    {
        NETDEMO_LOG_SUCC(NULL,  "get Image Advanced Exposure success");
        memcpy(&m_stImageExposure, &stImageExposure, sizeof(stImageExposure));
    }

    m_udwExposureMode = stImageExposure.udwMode;
    m_udwShutter = stImageExposure.stShutterInfo.udwShutterTime;
    m_udwGain = stImageExposure.stGainInfo.udwGain;
    m_udwMinIris = stImageExposure.stShutterInfo.udwIsEnableSlowShutter;
    m_udwMaxIris =stImageExposure.stShutterInfo.udwSlowestShutter;
    m_udwCompensation = stImageExposure.dwCompensationLevel;
    m_udwMode = stImageExposure.stDayNightInfo.udwDayNightMode;
    m_udwSence = stImageExposure.stDayNightInfo.udwDayNightSensitivity;
    m_udwSwitch = stImageExposure.stDayNightInfo.udwDayNightTime;
    m_udwWDR = stImageExposure.stWideDynamicInfo.udwWideDynamicMode;
    m_udwWDRLevel = stImageExposure.stWideDynamicInfo.udwWideDynamicLevel;
    m_udwMinShutter = stImageExposure.stShutterInfo.udwMinShutterTime;
    m_udwMaxShutter = stImageExposure.stShutterInfo.udwMaxShutterTime;
    m_udwMinGain = stImageExposure.stGainInfo.udwMinGain;
    m_udwMaxGain = stImageExposure.stGainInfo.udwMaxGain;


    UpdateData(FALSE);
    return;
}

void CCfgImage::OnSetExposureInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    INT32 dwChnType = NETDEV_SET_IMAGE_EXPOSURE;

    m_stImageExposure.udwMode = m_udwExposureMode;
    m_stImageExposure.stShutterInfo.udwShutterTime = m_udwShutter;
    m_stImageExposure.stGainInfo.udwGain = m_udwGain;
    m_stImageExposure.stShutterInfo.udwIsEnableSlowShutter = m_udwMinIris;
    m_stImageExposure.stShutterInfo.udwSlowestShutter = m_udwMaxIris;
    m_stImageExposure.dwCompensationLevel = m_udwCompensation;
    m_stImageExposure.stDayNightInfo.udwDayNightMode = m_udwMode;
    m_stImageExposure.stDayNightInfo.udwDayNightSensitivity = m_udwSence;
    m_stImageExposure.stDayNightInfo.udwDayNightTime = m_udwSwitch ;
    m_stImageExposure.stWideDynamicInfo.udwWideDynamicMode = m_udwWDR ;
    m_stImageExposure.stWideDynamicInfo.udwWideDynamicLevel = m_udwWDRLevel;
    m_stImageExposure.stShutterInfo.udwMinShutterTime = m_udwMinShutter;
    m_stImageExposure.stShutterInfo.udwMaxShutterTime = m_udwMaxShutter;
    m_stImageExposure.stGainInfo.udwMinGain = m_udwMinGain;
    m_stImageExposure.stGainInfo.udwMaxGain = m_udwMaxGain;

    BOOL iRet = NETDEV_SetDevConfig(lpDevHandle, dwChannelID, dwChnType, &m_stImageExposure, sizeof(m_stImageExposure));
    if(TRUE != iRet)
    {
        NETDEMO_LOG_ERROR(NULL, "set Image Advanced Exposure fail");
    }
    else
    {
        NETDEMO_LOG_SUCC(NULL,  "set Image Advanced Exposure success");
    }

    UpdateData(FALSE);
    return;
}
