// FaceLibraryManagerment.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "LibraryManagerment.h"

#define COL_INDEX_NAME              1
#define COL_INDEX_GENDER			2
#define COL_INDEX_DATE_OF_BIRTH		3
#define COL_INDEX_NATIONALITY		4
#define COL_INDEX_PROVINCE			5
#define COL_INDEX_CITY				6
#define COL_INDEX_ID_TYPE			7
#define COL_INDEX_ID				8

#define COL_INDEX_PLATE_NUMBER		1
#define COL_INDEX_PLATE_COLOR		2
#define COL_INDEX_PLATE_TYPE		3
#define COL_INDEX_CAR_COLOR			4
#define COL_INDEX_STATUS			5

// CLibraryManagerment Ի

IMPLEMENT_DYNAMIC(CLibraryManagerment, CDialog)

CLibraryManagerment::CLibraryManagerment(CWnd* pParent /*=NULL*/)
	: CDialog(CLibraryManagerment::IDD, pParent)
{
	m_nType = 0;
}

CLibraryManagerment::~CLibraryManagerment()
{
}

void CLibraryManagerment::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_PERSON_INFO_LIST, m_oInfoList);
    DDX_Text(pDX, IDC_EDIT_PERSON_LIB_NAME, m_strLibName);
    DDX_Control(pDX, IDC_COM_PERSON_LIBLIST, m_oCBoxLibName);
}


BEGIN_MESSAGE_MAP(CLibraryManagerment, CDialog)
	ON_BN_CLICKED(IDC_BTN_ADD_PERSON_INFO, &CLibraryManagerment::OnBnClickedBtnAddPersonInfo)
    ON_BN_CLICKED(IDC_BTN_ADD_VEHICLE_INFO, &CLibraryManagerment::OnBnClickedBtnAddVehicleInfo)
    ON_BN_CLICKED(IDC_BTN_GET_PERSON_LIB_LIST, &CLibraryManagerment::OnBnClickedBtnGetPersonLibList)
    ON_BN_CLICKED(IDC_BTN_DEL_PERSON_LIB, &CLibraryManagerment::OnBnClickedBtnDelPersonLib)
    ON_BN_CLICKED(IDC_BTN_GET_PERSON_INFO, &CLibraryManagerment::OnBnClickedBtnGetPersonInfo)
    ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_PERSON_INFO_LIST, &CLibraryManagerment::OnLvnItemchangedListPersonInfoList)
    ON_BN_CLICKED(IDC_BTN_DELETE_PERSON_INFO, &CLibraryManagerment::OnBnClickedBtnDeletePersonInfo)
    ON_BN_CLICKED(IDC_BTN_MODEFY_PERSON_INFO, &CLibraryManagerment::OnBnClickedBtnModefyPersonInfo)
END_MESSAGE_MAP()


// CLibraryManagerment Ϣ
BOOL CLibraryManagerment::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rc(0, 0, 0, 0);
	GetParent()->GetClientRect(&rc);
	((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
	MoveWindow(&rc);

	m_oDlgPersonInfo.Create(IDD_DLG_PERSON_INFO,this);
	m_oDlgVehicleInfo.Create(IDD_DLG_VEHICLE_INFO,this);
	InitCtrl();
	return TRUE;
}

void CLibraryManagerment::InitCtrl()
{
	if (0 == m_nType)
	{
		GetDlgItem(IDC_STATIC_PERSON_LIB)->SetWindowText("Person Library");
		GetDlgItem(IDC_STATIC_PERSON_INFO)->SetWindowText("Person Info");

		m_oInfoList.InsertColumn(0, "", LVCFMT_LEFT, 0, -1); 

		CString str="Name";
		m_oInfoList.InsertColumn(COL_INDEX_NAME,str,LVCFMT_LEFT,100);

		str = "Gender";
		m_oInfoList.InsertColumn(COL_INDEX_GENDER, str, LVCFMT_LEFT, 100);

		str = "Date of Birth";
		m_oInfoList.InsertColumn(COL_INDEX_DATE_OF_BIRTH, str, LVCFMT_LEFT, 100);

		str = "Nationality";
		m_oInfoList.InsertColumn(COL_INDEX_NATIONALITY, str, LVCFMT_LEFT, 100);

		str = "Province";
		m_oInfoList.InsertColumn(COL_INDEX_PROVINCE, str, LVCFMT_LEFT, 100);

		str = "City";
		m_oInfoList.InsertColumn(COL_INDEX_CITY, str, LVCFMT_LEFT, 100);

		str = "ID Type";
		m_oInfoList.InsertColumn(COL_INDEX_ID_TYPE, str, LVCFMT_LEFT, 100);

		str = "ID";
		m_oInfoList.InsertColumn(COL_INDEX_ID, str, LVCFMT_LEFT, 100);

	}
	else
	{
		GetDlgItem(IDC_STATIC_PERSON_LIB)->SetWindowText("Vehicle Library");
		GetDlgItem(IDC_STATIC_PERSON_INFO)->SetWindowText("Vehicle Info");

		m_oInfoList.InsertColumn(0, "", LVCFMT_LEFT, 0, -1); 

		CString str="Plate Number";
		m_oInfoList.InsertColumn(COL_INDEX_PLATE_NUMBER,str,LVCFMT_LEFT,160);

		str = "Plate Color";
		m_oInfoList.InsertColumn(COL_INDEX_PLATE_COLOR, str, LVCFMT_LEFT, 160);

		str = "Plate Type";
		m_oInfoList.InsertColumn(COL_INDEX_PLATE_TYPE, str, LVCFMT_LEFT, 160);

		str = "Car Color";
		m_oInfoList.InsertColumn(COL_INDEX_CAR_COLOR, str, LVCFMT_LEFT, 160);

		str = "Status";
		m_oInfoList.InsertColumn(COL_INDEX_STATUS, str, LVCFMT_LEFT, 160);
	}

	m_oInfoList.SetExtendedStyle(m_oInfoList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

void CLibraryManagerment::SetType(INT32 nType)
{
	m_nType = nType;
}

VOID CLibraryManagerment::FindPersonLibInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    m_oLibInfoVector.clear();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }
    LPVOID lpPersonLibHandle = NETDEV_FindPersonLibList(lpHandle);
    if(NULL ==lpPersonLibHandle)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindPersonLibList");
        return;
    }
    else
    {
        while(TRUE)
        {
            NETDEV_LIB_INFO_S stPersonLibInfo = {0};
            bRet = NETDEV_FindNextPersonLibInfo(lpPersonLibHandle,  &stPersonLibInfo);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                m_oLibInfoVector.push_back(stPersonLibInfo);
            }
        }
        NETDEV_FindClosePersonLibList(lpPersonLibHandle);
    }

    INT32 dwLibNum = m_oLibInfoVector.size();
    m_oCBoxLibName.ResetContent();
    for(INT32 i = 0; i<dwLibNum; i++)
    {
        CHAR szTmp[NETDEV_LEN_64] = {0};
        UTF8ToMB(m_oLibInfoVector[i].szName, szTmp, sizeof(szTmp) - 1);
        m_oCBoxLibName.InsertString(i, szTmp);
    }
    m_oCBoxLibName.SetCurSel(0);
}

VOID CLibraryManagerment::FindVehicleLibInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    m_oLibInfoVector.clear();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }
    LPVOID lpVehicleLibHandle = NETDEV_FindVehicleLibList(lpHandle);
    if(NULL ==lpVehicleLibHandle)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindVehicleLibList");
        return;
    }
    else
    {
        while(TRUE)
        {
            NETDEV_LIB_INFO_S stVehicleLibInfo = {0};
            bRet = NETDEV_FindNextVehicleLibInfo(lpVehicleLibHandle,  &stVehicleLibInfo);
            if(TRUE != bRet)
            {
                break;
            }
            else
            {
                m_oLibInfoVector.push_back(stVehicleLibInfo);
            }
        }
        NETDEV_FindCloseVehicleLibList(lpVehicleLibHandle);
    }

    INT32 dwLibNum = m_oLibInfoVector.size();
    m_oCBoxLibName.ResetContent();
    for(INT32 i = 0; i<dwLibNum; i++)
    {
        CHAR szTmp[NETDEV_LEN_64] = {0};
        UTF8ToMB(m_oLibInfoVector[i].szName, szTmp, sizeof(szTmp) - 1);
        m_oCBoxLibName.InsertString(i, szTmp);
    }
    m_oCBoxLibName.SetCurSel(0);
}

VOID CLibraryManagerment::FindPersonInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    INT32 dwIndex = m_oCBoxLibName.GetCurSel();
    if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
    {
        return;
    }

    NETDEV_LIB_INFO_S stPersonLibInfo = m_oLibInfoVector[dwIndex];

    NETDEV_PERSON_QUERY_INFO_S stQueryInfo = {0};
    stQueryInfo.udwNum = 0;
    stQueryInfo.udwOffset =  0;
    stQueryInfo.udwLimit = 16;

    NETDEV_BATCH_OPERATE_BASIC_S stQueryResultInfo = {0};
	for(INT32 i=0; i<m_oPersomInfoVector.size(); i++)
	{
		if (NULL != m_oPersomInfoVector[i].stImageInfo[0].stFileInfo.pcData)
		{
			delete [] m_oPersomInfoVector[i].stImageInfo[0].stFileInfo.pcData;
			m_oPersomInfoVector[i].stImageInfo[0].stFileInfo.pcData = NULL;
		}
	}
    m_oPersomInfoVector.clear();

    while(TRUE)
    {
        LPVOID lpPersonFindHandle = NETDEV_FindPersonInfoList(lpHandle, stPersonLibInfo.udwID, &stQueryInfo, &stQueryResultInfo);
        if(lpPersonFindHandle == NULL || stQueryResultInfo.udwTotal == 0)
        {
            break;
        }
        else
        {
            stQueryInfo.udwOffset += stQueryInfo.udwLimit;
            while(TRUE)
            {
                NETDEV_PERSON_INFO_S stPersonInfo = {0};
                stPersonInfo.stImageInfo[0].stFileInfo.udwSize = 1048576;
                stPersonInfo.stImageInfo[0].stFileInfo.pcData = new CHAR[stPersonInfo.stImageInfo[0].stFileInfo.udwSize];

                bRet = NETDEV_FindNextPersonInfo(lpPersonFindHandle, &stPersonInfo);
                if(bRet != true)
                {
                    break;
                }
                else 
                {
                    m_oPersomInfoVector.push_back(stPersonInfo);
                }
            }
            if(stQueryInfo.udwOffset >= stQueryResultInfo.udwTotal) //MFC 
            {
                NETDEV_FindClosePersonInfoList(lpPersonFindHandle);
                break;
            }  
        }
        
    }

    m_oInfoList.DeleteAllItems();
    INT32 dwPersonNum = m_oPersomInfoVector.size();
    CHAR szBuf[64] = {0};
    for(INT32 i = 0; i < dwPersonNum; i++)
    {
        m_oInfoList.InsertItem(i, _T(""));

        /* Name */
        UTF8ToMB(m_oPersomInfoVector[i].szPersonName, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_NAME, szBuf);

        /* Gender */
        if(m_oPersomInfoVector[i].udwGender == NETDEV_GENDER_TYPE_MAN)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_GENDER, "man");
        }
        else if(m_oPersomInfoVector[i].udwGender == NETDEV_GENDER_TYPE_WOMAN)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_GENDER, "woman");
        }
        else
        {
            m_oInfoList.SetItemText(i, COL_INDEX_GENDER, "unknown");
        }

        /* Birthday */
        UTF8ToMB(m_oPersomInfoVector[i].szBirthday, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_DATE_OF_BIRTH, szBuf);

        /* nation */
        UTF8ToMB(m_oPersomInfoVector[i].stRegionInfo.szNation, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_NATIONALITY, szBuf);

        /* province */
        UTF8ToMB(m_oPersomInfoVector[i].stRegionInfo.szProvince, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_PROVINCE, szBuf);

        /* city */
        UTF8ToMB(m_oPersomInfoVector[i].stRegionInfo.szCity, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_CITY, szBuf);

        /* ID Type */
        if(m_oPersomInfoVector[i].stIdentificationInfo[0].udwType == NETDEV_CERTIFICATE_TYPE_ID)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_ID_TYPE, "ID");
        }
        else if(m_oPersomInfoVector[i].stIdentificationInfo[0].udwType == NETDEV_CERTIFICATE_TYPE_PASSPORT)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_ID_TYPE, "Passport");
        }
        else if(m_oPersomInfoVector[i].stIdentificationInfo[0].udwType == NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_ID_TYPE, "Driving license");
        }
        else
        {
            m_oInfoList.SetItemText(i, COL_INDEX_ID_TYPE, "other");	
        }

        /* ID */
        UTF8ToMB(m_oPersomInfoVector[i].stIdentificationInfo[0].szNumber, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_ID, szBuf);
    }
}

VOID CLibraryManagerment::FindVehicleInfo()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    INT32 dwIndex = m_oCBoxLibName.GetCurSel();
    if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
    {
        return;
    }

    NETDEV_LIB_INFO_S stVehicleLibInfo = m_oLibInfoVector[dwIndex];

    NETDEV_PERSON_QUERY_INFO_S stQueryInfo = {0};
    stQueryInfo.udwNum = 0;
    stQueryInfo.udwOffset =  0;
    stQueryInfo.udwLimit = 16;

    NETDEV_BATCH_OPERATE_BASIC_S stQueryResultInfo = {0};
    m_oVehicleInfoVector.clear();

    while(TRUE)
    {
        LPVOID lpVehicleFindHandle = NETDEV_FindVehicleMemberDetailList(lpHandle, stVehicleLibInfo.udwID, &stQueryInfo, &stQueryResultInfo);
        if(lpVehicleFindHandle == NULL || stQueryResultInfo.udwTotal == 0)
        {
            break;
        }
        else
        {
            stQueryInfo.udwOffset += stQueryInfo.udwLimit;
            while(TRUE)
            {
                NETDEV_VEHICLE_DETAIL_INFO_S stVehicleMemberInfo = {0};

                bRet = NETDEV_FindNextVehicleMemberDetail(lpVehicleFindHandle, &stVehicleMemberInfo);
                if(bRet != true)
                {
                    break;
                }
                else 
                {
                    m_oVehicleInfoVector.push_back(stVehicleMemberInfo);
                }
            }
            if(stQueryInfo.udwOffset >= stQueryResultInfo.udwTotal)
            {
                NETDEV_FindCloseVehicleMemberDetail(lpVehicleFindHandle);
                break;
            }  
        }
    }

    m_oInfoList.DeleteAllItems();
    INT32 dwVehicleNum = m_oVehicleInfoVector.size();
    CHAR szBuf[64] = {0};
    for(INT32 i = 0; i < dwVehicleNum; i++)
    {
        m_oInfoList.InsertItem(i, _T(""));

        /* Plate Number */
        UTF8ToMB(m_oVehicleInfoVector[i].stPlateAttr.szPlateNo, szBuf, sizeof(szBuf) - 1);
        m_oInfoList.SetItemText(i, COL_INDEX_PLATE_NUMBER, szBuf);

        /* Plate Color */
        std::string strPlateColor = "";
        EnumNETDEV_PLATE_COLOR_EConventToString(m_oVehicleInfoVector[i].stPlateAttr.udwColor, strPlateColor);
        m_oInfoList.SetItemText(i, COL_INDEX_PLATE_COLOR, strPlateColor.c_str());

        /* Plate Type */
        std::string strPlateType = "";
        EnumNETDEV_PLATE_TYPE_EConventToString(m_oVehicleInfoVector[i].stPlateAttr.udwType, strPlateType);
        m_oInfoList.SetItemText(i, COL_INDEX_PLATE_TYPE, strPlateType.c_str());

        /* Car Color */
        std::string strCarColor = "";
        EnumNETDEV_PLATE_COLOR_EConventToString(m_oVehicleInfoVector[i].stVehicleAttr.udwColor, strCarColor);
        m_oInfoList.SetItemText(i, COL_INDEX_CAR_COLOR, strCarColor.c_str());

        /* Status */
        if(m_oVehicleInfoVector[i].bIsMonitored == 1)
        {
            m_oInfoList.SetItemText(i, COL_INDEX_STATUS, "Enable");
        }
        else
        {
            m_oInfoList.SetItemText(i, COL_INDEX_STATUS, "Disable");
        }
    }
}

VOID CLibraryManagerment::EnumNETDEV_PLATE_COLOR_EConventToString(int dwEnum, std::string& strColor)
{
    switch (dwEnum) {
        case NETDEV_PLATE_COLOR_BLACK_E:
            strColor = "BLACK";
            break;
        case NETDEV_PLATE_COLOR_WHITE_E:
            strColor = "WHITE";
            break;
        case NETDEV_PLATE_COLOR_GRAY_E:
            strColor = "GRAY";
            break;
        case NETDEV_PLATE_COLOR_RED_E:
            strColor = "RED";
            break;
        case NETDEV_PLATE_COLOR_BLUE_E:
            strColor = "BLUE";
            break;
        case NETDEV_PLATE_COLOR_YELLOW_E:
            strColor = "YELLOW";
            break;
        case NETDEV_PLATE_COLOR_ORANGE_E:
            strColor = "ORANGE";
            break;
        case NETDEV_PLATE_COLOR_BROWN_E:
            strColor = "BROWN";
            break;
        case NETDEV_PLATE_COLOR_GREEN_E:
            strColor = "GREEN";
            break;
        case NETDEV_PLATE_COLOR_PURPLE_E:
            strColor = "PURPLE";
            break;
        case NETDEV_PLATE_COLOR_CYAN_E:
            strColor = "CYAN";
            break;
        case NETDEV_PLATE_COLOR_PINK_E:
            strColor = "PINK";
            break;
        case NETDEV_PLATE_COLOR_TRANSPARENT_E:
            strColor = "TRANSPARENT";
            break;
        case NETDEV_PLATE_COLOR_SILVERYWHITE_E:
            strColor = "SILVERYWHITE";
            break;
        case NETDEV_PLATE_COLOR_DARK_E:
            strColor = "DARK";
            break;
        case NETDEV_PLATE_COLOR_LIGHT_E:
            strColor = "LIGHT";
            break;
        case NETDEV_PLATE_COLOR_COLOURLESS:
            strColor = "COLOURLESS";
            break;
        case NETDEV_PLATE_COLOR_YELLOWGREEN:
            strColor = "YELLOWGREEN";
            break;
        case NETDEV_PLATE_COLOR_GRADUALGREEN:
            strColor = "GRADUALGREEN";
            break;
        case NETDEV_PLATE_COLOR_OTHER_E:
            strColor = "OTHER";
            break;
        default:
            strColor = "OTHER";
            break;
    }
}

VOID CLibraryManagerment::EnumNETDEV_PLATE_TYPE_EConventToString(int dwEnum, std::string& strColor)
{
    switch (dwEnum) {
    case NETDEV_PLATE_TYPE_BIG_CAR_E:
        strColor = "BIG_CAR";
        break;
    case NETDEV_PLATE_TYPE_MINI_CAR_E:
        strColor = "MINI_CAR";
        break;
    case NETDEV_PLATE_TYPE_EMBASSY_CAR_E:
        strColor = "EMBASSY_CAR";
        break;
    case NETDEV_PLATE_TYPE_CONSULATE_CAR_E:
        strColor = "CONSULATE_CAR";
        break;
    case NETDEV_PLATE_TYPE_OVERSEAS_CAR_E:
        strColor = "OVERSEAS_CAR";
        break;
    case NETDEV_PLATE_TYPE_FOREIGN_CAR_E:
        strColor = "FOREIGN_CAR";
        break;
    case NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E:
        strColor = "COMMON_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E:
        strColor = "HANDINESS_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E:
        strColor = "EMBASSY_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E:
        strColor = "CONSULATE_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E:
        strColor = "OVERSEAS_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E:
        strColor = "FOREIGN_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E:
        strColor = "LOW_SPEED_CAR";
        break;
    case NETDEV_PLATE_TYPE_TRACTOR_E:
        strColor = "TYPE_TRACTOR";
        break;
    case NETDEV_PLATE_TYPE_TRAILER_E:
        strColor = "TRAILER";
        break;
    case NETDEV_PLATE_TYPE_COACH_CAR_E:
        strColor = "COACH_CAR";
        break;
    case NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E:
        strColor = "COACH_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E:
        strColor = "TEMPORARY_ENTRY_CAR";
        break;
    case NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E:
        strColor = "TEMPORARY_ENTRY_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E:
        strColor = "TEMPORARY_DRIVING";
        break;
    case NETDEV_PLATE_TYPE_POLICE_CAR_E:
        strColor = "POLICE_CAR";
        break;
    case NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E:
        strColor = "POLICE_MOTORBIKE";
        break;
    case NETDEV_PLATE_TYPE_AGRICULTURAL_E:
        strColor = "AGRICULTURAL";
        break;
    case NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E:
        strColor = "HONGKONG_ENTRY_EXIT";
        break;
    case NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E:
        strColor = "MACAO_ENTRY_EXIT";
        break;
    case NETDEV_PLATE_TYPE_ARMED_POLICE_E:
        strColor = "ARMED_POLICE";
        break;
    case NETDEV_PLATE_TYPE_ARMY_E:
        strColor = "ARMY";
        break;

    default:
        strColor = "OTHER";
        break;
    }
}

void CLibraryManagerment::OnBnClickedBtnAddPersonInfo()
{
	// TODO: ڴӿؼ֪ͨ
	if (0 == m_nType)
	{
        INT32 dwIndex = m_oCBoxLibName.GetCurSel();
        if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
        {
            return;
        }

        m_oDlgPersonInfo.CleanCacheData();
        NETDEV_LIB_INFO_S stPersonLibInfo = m_oLibInfoVector[dwIndex];
        m_oDlgPersonInfo.SetPersonLibID(stPersonLibInfo.udwID);
        m_oDlgPersonInfo.SetType(0);
		m_oDlgPersonInfo.ShowWindow(SW_SHOW);
	}
	else
	{
        m_oDlgVehicleInfo.CleanCacheData();
        INT32 dwIndex = m_oCBoxLibName.GetCurSel();
        if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
        {
            return;
        }

        NETDEV_LIB_INFO_S stPersonLibInfo = m_oLibInfoVector[dwIndex];

        m_oDlgVehicleInfo.SetVehicleLibID(stPersonLibInfo.udwID);
        m_oDlgVehicleInfo.SetType(0);

        m_oDlgVehicleInfo.GetDlgItem(IDC_EDIT_VEHICLE_LICENSE)->EnableWindow(TRUE);
		m_oDlgVehicleInfo.ShowWindow(SW_SHOW);
	}


}

void CLibraryManagerment::OnBnClickedBtnAddVehicleInfo()
{
    // TODO: ڴӿؼ֪ͨ

    UpdateData(TRUE);
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    if(m_nType == 0)
    {
        NETDEV_LIB_INFO_S stPersonLibInfo = {0};
        UINT32 udwID = 0;
        MBToUTF8(m_strLibName.GetBuffer(0), stPersonLibInfo.szName, sizeof(stPersonLibInfo.szName) - 1);

        BOOL bRet = NETDEV_CreatePersonLibInfo(lpHandle, &stPersonLibInfo, &udwID);
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_CreatePersonLibInfo");
            return;
        }
        NETDEMO_LOG_SUCC(NULL, "NETDEV_CreatePersonLibInfo");
    }
    else
    {
        NETDEV_LIB_INFO_S stVehicleLibInfo = {0};
        MBToUTF8(m_strLibName.GetBuffer(0), stVehicleLibInfo.szName, sizeof(stVehicleLibInfo.szName) - 1);
        BOOL bRet = NETDEV_AddVehicleLibInfo(lpHandle, &stVehicleLibInfo);
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_AddVehicleLibInfo");
            return;
        }
        NETDEMO_LOG_SUCC(NULL, "NETDEV_AddVehicleLibInfo");
    }
}

void CLibraryManagerment::OnBnClickedBtnGetPersonLibList()
{
    // TODO: ڴӿؼ֪ͨ

    if(m_nType == 0)
    {
        FindPersonLibInfo();
    }
    else
    {
        FindVehicleLibInfo();
    }

    
}

void CLibraryManagerment::OnBnClickedBtnDelPersonLib()
{
    // TODO: ڴӿؼ֪ͨ

    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    INT32 dwIndex = m_oCBoxLibName.GetCurSel();
    if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
    {
        return;
    }

    if(m_nType == 0)
    {
        NETDEV_DELETE_DB_FLAG_INFO_S stFlagInfo = {0};
        stFlagInfo.bIsDeleteMember = 1;

        BOOL bRet = NETDEV_DeletePersonLibInfo(lpHandle,m_oLibInfoVector[dwIndex].udwID, &stFlagInfo);
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_DeletePersonLibInfo");
            return;
        }
        NETDEMO_LOG_SUCC(NULL, "NETDEV_DeletePersonLibInfo");
    }
    else
    {
        NETDEV_DELETE_DB_FLAG_INFO_S stFlagInfo = {0};
        stFlagInfo.bIsDeleteMember = 1;
        BOOL bRet = NETDEV_DeleteVehicleLibInfo(lpHandle, m_oLibInfoVector[dwIndex].udwID, &stFlagInfo);
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_DeleteVehicleLibInfo");
            return;
        }
        NETDEMO_LOG_SUCC(NULL, "NETDEV_DeleteVehicleLibInfo");
    }
}

void CLibraryManagerment::OnBnClickedBtnGetPersonInfo()
{
    // TODO: ڴӿؼ֪ͨ

    if(m_nType == 0)
    {
        FindPersonInfo();
    }
    else
    {
        FindVehicleInfo();
    }
    
}

void CLibraryManagerment::OnLvnItemchangedListPersonInfoList(NMHDR *pNMHDR, LRESULT *pResult)
{
    LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
    // TODO: ڴӿؼ֪ͨ
    *pResult = 0;
}

void CLibraryManagerment::OnBnClickedBtnDeletePersonInfo()
{
    // TODO: ڴӿؼ֪ͨ

    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    if (0 == m_nType)
    {
        INT32 dwPersonLibIndex = m_oCBoxLibName.GetCurSel();
        if (dwPersonLibIndex < 0 || dwPersonLibIndex > m_oLibInfoVector.size())
        {
            NETDEMO_LOG_ERROR(NULL, "Please select person first");
            return;
        }

        NETDEV_LIB_INFO_S stPersonLibInfo = m_oLibInfoVector[dwPersonLibIndex];

        INT32 dwPersonSelectIndex = m_oInfoList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if(dwPersonSelectIndex < 0 || dwPersonSelectIndex >= m_oPersomInfoVector.size())
        {
            NETDEMO_LOG_ERROR(NULL, "please select a person");
            return;
        }

        if (NETDEV_DTYPE_VMS == gastLoginDeviceInfo.stNETDEV_LoginInfo.dwDevType)
        {
            NETDEV_BATCH_OPERATE_MEMBER_LIST_S stIDList = {0};
            stIDList.udwMemberNum = 1;
            UINT32 dwPersonID = m_oPersomInfoVector[dwPersonSelectIndex].udwPersonID;
            stIDList.pstMemberIDList = &dwPersonID;

            NETDEV_BATCH_OPERATOR_LIST_S stResutList = {0};

            bRet = NETDEV_DeletePersonInfoList(lpHandle, stPersonLibInfo.udwID, &stIDList, &stResutList);
            if(TRUE != bRet)
            {
                NETDEMO_LOG_ERROR(NULL, "NETDEV_DeletePersonInfoList");
                return;
            }
            NETDEMO_LOG_SUCC(NULL, "NETDEV_DeletePersonInfoList");
        }
        else
        {
            bRet = NETDEV_DeletePersonInfo(lpHandle, stPersonLibInfo.udwID, m_oPersomInfoVector[dwPersonSelectIndex].udwPersonID, 0);
            if(TRUE != bRet)
            {
                NETDEMO_LOG_ERROR(NULL, "NETDEV_DeletePersonInfo");
                return;
            }
            NETDEMO_LOG_SUCC(NULL, "NETDEV_DeletePersonInfo");
        }
    }
    else
    {
        INT32 dwVehicleIndex = m_oInfoList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if (dwVehicleIndex < 0 || dwVehicleIndex > m_oLibInfoVector.size())
        {
            NETDEMO_LOG_ERROR(NULL, "Please select vehicle first");
            return;
        }

        NETDEV_VEHICLE_INFO_LIST_S stVehicleMemberList = {0};
        stVehicleMemberList.udwVehicleNum = 1;
        stVehicleMemberList.pstMemberInfoList = &m_oVehicleInfoVector[dwVehicleIndex];

        NETDEV_BATCH_OPERATOR_LIST_S stResutList = {0};
        stResutList.udwNum = 1;
        stResutList.pstBatchList = new NETDEV_BATCH_OPERATOR_INFO_S();

        /* 2ĿǰĬ0Ч */
        bRet = NETDEV_DelVehicleMemberList(lpHandle, 0, &stVehicleMemberList, &stResutList);
        delete[] stResutList.pstBatchList;
        if(TRUE != bRet)
        {
            NETDEMO_LOG_ERROR(NULL, "NETDEV_DelVehicleMemberList");
            return;
        }
        NETDEMO_LOG_SUCC(NULL, "NETDEV_DelVehicleMemberList");
    }

}

void CLibraryManagerment::OnBnClickedBtnModefyPersonInfo()
{
    // TODO: ڴӿؼ֪ͨ
    if (0 == m_nType)
    {
        INT32 dwIndex = m_oCBoxLibName.GetCurSel();
        if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
        {
            return;
        }

        m_oDlgPersonInfo.CleanCacheData();
        NETDEV_LIB_INFO_S stPersonLibInfo = m_oLibInfoVector[dwIndex];

        m_oDlgPersonInfo.SetPersonLibID(stPersonLibInfo.udwID);
        m_oDlgPersonInfo.SetType(1);

        INT32 dwPersonSelectIndex = m_oInfoList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if (dwPersonSelectIndex < 0 || dwPersonSelectIndex > m_oPersomInfoVector.size())
        {
            NETDEMO_LOG_ERROR(NULL, "Please select person first");
            return;
        }

        m_oDlgPersonInfo.SetPersonInfo(&m_oPersomInfoVector[dwPersonSelectIndex]);

        m_oDlgPersonInfo.ReloadPersonInfo();

        m_oDlgPersonInfo.ShowWindow(SW_SHOW);
    }
    else
    {
        INT32 dwIndex = m_oCBoxLibName.GetCurSel();
        if (dwIndex < 0 || dwIndex > m_oLibInfoVector.size())
        {
            return;
        }

        m_oDlgVehicleInfo.CleanCacheData();

        NETDEV_LIB_INFO_S stVehicleLibInfo = m_oLibInfoVector[dwIndex];

        m_oDlgVehicleInfo.SetVehicleLibID(stVehicleLibInfo.udwID);
        m_oDlgVehicleInfo.SetType(1);

        INT32 dwVehicleSelectIndex = m_oInfoList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if (dwVehicleSelectIndex < 0 || dwVehicleSelectIndex > m_oVehicleInfoVector.size())
        {
            NETDEMO_LOG_ERROR(NULL, "Please select vehicle first");
            return;
        }

        m_oDlgVehicleInfo.SetVehicleInfo(&m_oVehicleInfoVector[dwVehicleSelectIndex]);

        m_oDlgVehicleInfo.GetDlgItem(IDC_EDIT_VEHICLE_LICENSE)->EnableWindow(FALSE);

        m_oDlgVehicleInfo.ReloadVehicleInfo();
        m_oDlgVehicleInfo.ShowWindow(SW_SHOW);
    }
}
