// MonitoringTask.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "MonitoringTask.h"

#define COL_INDEX_TASK_NAME			1
#define COL_INDEX_ALARM_THRESHOLD	2
#define COL_INDEX_REMARKS			3
#define COL_INDEX_FACE_LIBRARY		4

#define COL_INDEX_NAME				1
#define COL_INDEX_DESCRIPTION		2
#define COL_INDEX_ALARM_TYPE		3
#define COL_INDEX_MONITOR_TYPE		4

// CMonitoringTask Ի

IMPLEMENT_DYNAMIC(CMonitoringTask, CDialog)

CMonitoringTask::CMonitoringTask(CWnd* pParent /*=NULL*/)
	: CDialog(CMonitoringTask::IDD, pParent)
{
	m_nType = 0;
}

CMonitoringTask::~CMonitoringTask()
{
}

void CMonitoringTask::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_MONITORING_TASK_LIST, m_oMonitoringTaskList);
}


BEGIN_MESSAGE_MAP(CMonitoringTask, CDialog)
	ON_BN_CLICKED(IDC_BTN_ADD_MONITORING_TASK, &CMonitoringTask::OnBnClickedBtnAddMonitoringTask)
    ON_BN_CLICKED(IDC_BTN_GET_MONITORING_TASK, &CMonitoringTask::OnBnClickedBtnGetMonitoringTask)
    ON_BN_CLICKED(IDC_BTN_DEL_MONITORING_TASK, &CMonitoringTask::OnBnClickedBtnDelMonitoringTask)
    ON_BN_CLICKED(IDC_BTN_MODIFY_MONITORING_TASK, &CMonitoringTask::OnBnClickedBtnModifyMonitoringTask)
END_MESSAGE_MAP()


// CMonitoringTask Ϣ
BOOL CMonitoringTask::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rc(0, 0, 0, 0);
	GetParent()->GetClientRect(&rc);
	((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
	MoveWindow(&rc);

	m_oDlgPersonMonitor.Create(IDD_DLG_PERSON_MONITOR,this);
	m_oDlgVehicleMonitor.Create(IDD_DLG_VEHICLE_MONITOR,this);
	InitCtrl();

	return TRUE;
}

void CMonitoringTask::InitCtrl()
{
	if (0 == m_nType)
	{
		m_oMonitoringTaskList.InsertColumn(0, "", LVCFMT_LEFT, 0, -1); 

		CString str="Task Name";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_TASK_NAME,str,LVCFMT_LEFT,120);

		str = "Alarm Threshold";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_ALARM_THRESHOLD, str, LVCFMT_LEFT, 120);

		str = "Remarks";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_REMARKS, str, LVCFMT_LEFT, 120);

		str = "Face Library";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_FACE_LIBRARY, str, LVCFMT_LEFT, 120);
	}
	else
	{
		m_oMonitoringTaskList.InsertColumn(0, "", LVCFMT_LEFT, 0, -1); 

		CString str="Name";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_NAME,str,LVCFMT_LEFT,120);

		str = "Description";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_DESCRIPTION, str, LVCFMT_LEFT, 120);

		str = "Alarm Type";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_ALARM_TYPE, str, LVCFMT_LEFT, 120);

		str = "Monitor Type";
		m_oMonitoringTaskList.InsertColumn(COL_INDEX_MONITOR_TYPE, str, LVCFMT_LEFT, 120);

	}
	m_oMonitoringTaskList.SetExtendedStyle(m_oMonitoringTaskList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

VOID CMonitoringTask::FindPersonMonitor()
{
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    INT32 dwChannelID = ga_pMainDlg->GetChlID();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

	for (INT32 i=0; i<m_oMotitorVector.size(); i++)
	{
		if (NULL != m_oMotitorVector[i].stMonitorRuleInfo.pudwMonitorChlIDList)
		{
			delete [] m_oMotitorVector[i].stMonitorRuleInfo.pudwMonitorChlIDList;
			m_oMotitorVector[i].stMonitorRuleInfo.pudwMonitorChlIDList = NULL;
		}
		if (NULL != m_oMotitorVector[i].pstLinkStrategyList)
		{
			delete [] m_oMotitorVector[i].pstLinkStrategyList;
			m_oMotitorVector[i].pstLinkStrategyList = NULL;
		}
	}
    m_oMotitorVector.clear();
    m_oMonitoringTaskList.DeleteAllItems();

    BOOL bRet = FALSE;
    NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = {0};
    stQueryInfo.udwLimit = 20;
    LPVOID lpPersonMonitorHandle = NETDEV_FindPersonMonitorList(lpHandle, dwChannelID, &stQueryInfo);
    if(lpPersonMonitorHandle == NULL)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindPersonMonitorList");
        return;
    }
    else 
    {
        while(TRUE)
        {
            NETDEV_MONITION_INFO_S stMonitorInfo = {0};

            stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 10;
            stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = new UINT32[10];
            memset(stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList, 0 ,sizeof(UINT32)* 10);

            stMonitorInfo.udwLinkStrategyNum = 10;
            //NETDEV_LINKAGE_STRATEGY_S stLinkStrategyList[10] = {0};

            stMonitorInfo.pstLinkStrategyList = new NETDEV_LINKAGE_STRATEGY_S[stMonitorInfo.udwLinkStrategyNum];

            bRet = NETDEV_FindNextPersonMonitorInfo(lpPersonMonitorHandle, &stMonitorInfo);
            if(bRet != true)
            {
                break;
            }
            else 
            {
               m_oMotitorVector.push_back(stMonitorInfo);
            }
        }
        NETDEV_FindClosePersonMonitorList(lpPersonMonitorHandle);
    }

    INT32 dwPersonNum = m_oMotitorVector.size();
    CHAR szBuf[64] = {0};
    for(INT32 i = 0; i < dwPersonNum; i++)
    {
        m_oMonitoringTaskList.InsertItem(i, _T(""));

        /*  */
        UTF8ToMB(m_oMotitorVector[i].stMonitorRuleInfo.szName, szBuf, sizeof(szBuf) - 1);
        m_oMonitoringTaskList.SetItemText(i, COL_INDEX_TASK_NAME, szBuf);

        /* ֵ */
        itoa(m_oMotitorVector[i].stMonitorRuleInfo.udwMultipleValue, szBuf, 10);
        m_oMonitoringTaskList.SetItemText(i, COL_INDEX_ALARM_THRESHOLD, szBuf);

        /*  */
        UTF8ToMB(m_oMotitorVector[i].stMonitorRuleInfo.szReason, szBuf, sizeof(szBuf) - 1);
        m_oMonitoringTaskList.SetItemText(i, COL_INDEX_REMARKS, szBuf);
    }
}

VOID CMonitoringTask::DeletePersonMonitor()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    INT32 dwPersonMonitorIndex = m_oMonitoringTaskList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
    if(dwPersonMonitorIndex < 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Please select monitor first");
        return;
    }
    NETDEV_BATCH_OPERATOR_LIST_S stResultList = {0};
    stResultList.udwNum = 1;
    stResultList.pstBatchList = new NETDEV_BATCH_OPERATOR_INFO_S[stResultList.udwNum];
    stResultList.pstBatchList[0].udwID = m_oMotitorVector[dwPersonMonitorIndex].udwID,

    bRet = NETDEV_BatchDeletePersonMonitorInfo(lpHandle, &stResultList);
    delete[] stResultList.pstBatchList;
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_BatchDeletePersonMonitorInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_BatchDeletePersonMonitorInfo");
}

VOID CMonitoringTask::FindVehicleMonitor()
{
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    m_oMotitorVector.clear();
    m_oMonitoringTaskList.DeleteAllItems();

    BOOL bRet = FALSE;
    NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = {0};
    stQueryInfo.udwLimit = 20;
    LPVOID lpVehicleMonitorHandle = NETDEV_FindVehicleMonitorList(lpHandle);
    if(lpVehicleMonitorHandle == NULL)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_FindVehicleMonitorList");
        return;
    }
    else 
    {
        while(TRUE)
        {
            NETDEV_MONITION_INFO_S stMonitorInfo = {0};

            bRet = NETDEV_FindNextVehicleMonitorInfo(lpVehicleMonitorHandle, &stMonitorInfo);
            if(bRet != true)
            {
                break;
            }
            else 
            {
                m_oMotitorVector.push_back(stMonitorInfo);
            }
        }
        NETDEV_FindCloseVehicleMonitorList(lpVehicleMonitorHandle);
    }

    INT32 dwPersonNum = m_oMotitorVector.size();
    CHAR szBuf[64] = {0};
    for(INT32 i = 0; i < dwPersonNum; i++)
    {
        m_oMonitoringTaskList.InsertItem(i, _T(""));

        /*  */
        UTF8ToMB(m_oMotitorVector[i].stMonitorRuleInfo.szName, szBuf, sizeof(szBuf) - 1);
        m_oMonitoringTaskList.SetItemText(i, COL_INDEX_NAME, szBuf);

        /*  */
        UTF8ToMB(m_oMotitorVector[i].stMonitorRuleInfo.szReason, szBuf, sizeof(szBuf) - 1);
        m_oMonitoringTaskList.SetItemText(i, COL_INDEX_DESCRIPTION, szBuf);

        /* 澯 */
        if(m_oMotitorVector[i].stMonitorRuleInfo.udwMonitorType == 0)
        {
            m_oMonitoringTaskList.SetItemText(i, COL_INDEX_ALARM_TYPE, "Match");
        }
        else
        {
            m_oMonitoringTaskList.SetItemText(i, COL_INDEX_ALARM_TYPE, "Not Match");
        }

        if(m_oMotitorVector[i].stMonitorRuleInfo.bEnabled == 1)
        {
            m_oMonitoringTaskList.SetItemText(i, COL_INDEX_MONITOR_TYPE, "Enable");
        }
        else
        {
            m_oMonitoringTaskList.SetItemText(i, COL_INDEX_MONITOR_TYPE, "Unable");
        }
    }
}

VOID CMonitoringTask::DeleteVehicleMonitor()
{
    BOOL bRet = FALSE;
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();

    INT32 dwMonitorIndex = m_oMonitoringTaskList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
    if(dwMonitorIndex < 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Please select monitor first");
        return;
    }

    NETDEV_BATCH_OPERATOR_LIST_S stResultList = {0};
    stResultList.udwNum = 1;
    stResultList.pstBatchList = new NETDEV_BATCH_OPERATOR_INFO_S[stResultList.udwNum];
    stResultList.pstBatchList[0].udwID = m_oMotitorVector[dwMonitorIndex].udwID,

    bRet = NETDEV_DeleteVehicleMonitorInfo(lpHandle, &stResultList);
    delete[] stResultList.pstBatchList;
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_DeleteVehicleMonitorInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_DeleteVehicleMonitorInfo");
}

void CMonitoringTask::SetType(INT32 nType)
{
	m_nType = nType;
}
void CMonitoringTask::OnBnClickedBtnAddMonitoringTask()
{
	// TODO: ڴӿؼ֪ͨ
	if (0 == m_nType)
	{
        m_oDlgPersonMonitor.CleanDialogCache();
        m_oDlgPersonMonitor.SetType(0);
        m_oDlgPersonMonitor.FindPersonLibInfo();
        m_oDlgPersonMonitor.UpdateData(TRUE);

        m_oDlgPersonMonitor.GetDlgItem(IDC_CMB_PERSON_LIB_LIST)->EnableWindow(TRUE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_MATCH_ALARM)->EnableWindow(TRUE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_LIB)->EnableWindow(TRUE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_FACE)->EnableWindow(FALSE);

		m_oDlgPersonMonitor.ShowWindow(SW_SHOW);
	}
	else
	{
        m_oDlgVehicleMonitor.CleanCache();
        m_oDlgVehicleMonitor.SetType(0);
        m_oDlgVehicleMonitor.InitDialog();
        m_oDlgVehicleMonitor.GetDlgItem(IDC_CMB_VEHICLE_LIB_LIST)->EnableWindow(TRUE);
		m_oDlgVehicleMonitor.ShowWindow(SW_SHOW);
	}
}

void CMonitoringTask::OnBnClickedBtnGetMonitoringTask()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        FindPersonMonitor();
    }
    else
    {
        FindVehicleMonitor();
    }
}

void CMonitoringTask::OnBnClickedBtnDelMonitoringTask()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        DeletePersonMonitor();
    }
    else
    {
        DeleteVehicleMonitor();
    }
}

void CMonitoringTask::OnBnClickedBtnModifyMonitoringTask()
{
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        m_oDlgPersonMonitor.CleanDialogCache();
        m_oDlgPersonMonitor.SetType(1);

        INT32 dwPersonMonitorIndex = m_oMonitoringTaskList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if(dwPersonMonitorIndex < 0)
        {
            NETDEMO_LOG_ERROR(NULL, "Please select monitor first!");
            return;
        }
        m_oDlgPersonMonitor.SetMontiorInfo(&m_oMotitorVector[dwPersonMonitorIndex]);

        m_oDlgPersonMonitor.ReloadMontiorInfo();

        m_oDlgPersonMonitor.UpdateData(TRUE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_CMB_PERSON_LIB_LIST)->EnableWindow(FALSE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_MATCH_ALARM)->EnableWindow(FALSE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_LIB)->EnableWindow(FALSE);
        m_oDlgPersonMonitor.GetDlgItem(IDC_RADIO_PERSON_FACE)->EnableWindow(FALSE);
        m_oDlgPersonMonitor.ShowWindow(SW_SHOW);
    }
    else
    {
        m_oDlgVehicleMonitor.SetType(1);
        m_oDlgVehicleMonitor.InitDialog();
        m_oDlgVehicleMonitor.CleanCache();

        INT32 dwVehicleMonitorIndex = m_oMonitoringTaskList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
        if(dwVehicleMonitorIndex < 0)
        {
            NETDEMO_LOG_ERROR(NULL, "Please select monitor first!");
            return;
        }
        m_oDlgVehicleMonitor.SetMonitorInfo(&m_oMotitorVector[dwVehicleMonitorIndex]);
        m_oDlgVehicleMonitor.ReloadMontiorInfo();
        m_oDlgVehicleMonitor.GetDlgItem(IDC_CMB_VEHICLE_LIB_LIST)->EnableWindow(FALSE);
        m_oDlgVehicleMonitor.ShowWindow(SW_SHOW);
    }
}
