// PersonAlarmRecord.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PersonAlarmRecord.h"

#define COL_PERSON_SMALLPICTUREPARH           0
#define COL_PERSON_MONTIORPICPATH           1
#define COL_PERSON_NAME                 2
#define COL_PERSON_GENDRE               3
#define COL_PERSON_IDNUMBER             4
#define COL_PERSON_ALARM_TMIE           5
#define COL_PERSON_ALARM_SOURCE         6
#define COL_PERSON_SIMILAR              7


// CPersonAlarmRecord Ի

IMPLEMENT_DYNAMIC(CPersonAlarmRecord, CDialog)


CPersonAlarmRecord::CPersonAlarmRecord(CWnd* pParent /*=NULL*/)
	: CDialog(CPersonAlarmRecord::IDD, pParent)
{
}

CPersonAlarmRecord::~CPersonAlarmRecord()
{
}

void CPersonAlarmRecord::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Control(pDX, IDC_COMBO_MONITOR_TYPE, m_oCBoxMonitoType);
    DDX_Control(pDX, IDC_PERSON_DATE_BEGIN, m_oBeginDate);
    DDX_Control(pDX, IDC_PERSON_TIME_BEGIN, m_oBeginTime);
    DDX_Control(pDX, IDC_PERSON_DATA_END, m_oEndDate);
    DDX_Control(pDX, IDC_PERSON_TIME_END, m_oEndTime);
    DDX_Text(pDX, IDC_EDIT_PERSON_NAME, m_strPersonName);
    DDX_Text(pDX, IDC_EDIT_CERTIFIC_NUMBER, m_strPersonName);

    if(TRUE == ((CButton *)GetDlgItem(IDC_GENDER_WOMAN))->GetCheck())
    {
        m_dwGender = NETDEV_GENDER_TYPE_WOMAN;
    }
    else if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_GENDER_MAN))->GetCheck())
    {
        m_dwGender = NETDEV_GENDER_TYPE_MAN;
    }
    else
    {
        m_dwGender = NETDEV_GENDER_TYPE_UNKNOW;
    }

    DDX_Text(pDX, IDC_EDIT_PERSON_ALARM_SOURCE, m_strAlarmSource);
    DDX_Control(pDX, IDC_LIST_PERSON_ALARM, m_oPersonInfoDisPlayList);
    DDX_Text(pDX, IDC_STATIC_PERSON_ALARM_TOTAL_NUM, m_strTotalNumber);
    DDX_Text(pDX, IDC_STATIC_PERSON_ALARM_CURRENT_NUMBER, m_strCurrentNumber);
}

BOOL CPersonAlarmRecord::OnInitDialog()
{
    CDialog::OnInitDialog();
    CRect rc(0, 0, 0, 0);
    GetParent()->GetClientRect(&rc);
    ((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
    MoveWindow(&rc);

    InitDialog();

    return TRUE;
}

VOID CPersonAlarmRecord::InitDialog()
{
    m_oCBoxMonitoType.InsertString(0, _T("Match"));
    m_oCBoxMonitoType.InsertString(1, _T("Not Match"));
    m_oCBoxMonitoType.SetCurSel(0);

    ((CButton *)GetDlgItem(IDC_RADIO_GENDER_ALL))->SetCheck(TRUE);

    InitPersonDisPlayList();
}

CImageList m_thumbnailList;     // ͼб
CRect rect;



VOID CPersonAlarmRecord::InitPersonDisPlayList()
{
    CString str = "Small picture path";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_SMALLPICTUREPARH, str, LVCFMT_LEFT, 100, 100);

    str = "Monitor picture path";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_MONTIORPICPATH, str, LVCFMT_LEFT, 150); 

    str = "Name";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_NAME, str, LVCFMT_LEFT, 150);

    str = "Gender";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_GENDRE, str, LVCFMT_LEFT, 100);

    str = "ID";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_IDNUMBER, str, LVCFMT_LEFT, 100);

    str = "Time";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_ALARM_TMIE, str, LVCFMT_LEFT, 100);

    str = "Alarm Source";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_ALARM_SOURCE, str, LVCFMT_LEFT, 100);

    str = "Similar";
    m_oPersonInfoDisPlayList.InsertColumn(COL_PERSON_SIMILAR, str, LVCFMT_LEFT, 100);

    m_oPersonInfoDisPlayList.SetExtendedStyle(m_oPersonInfoDisPlayList.GetExtendedStyle()|LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
}

BOOL CPersonAlarmRecord::getTimeInfo(INT64& dwBeginTime, INT64& dwEndTime)
{
    CString strBeginTime;
    CString strEndTime;
    CString strTemp;
    GetDlgItem(IDC_PERSON_DATE_BEGIN)->GetWindowText(strTemp);
    strBeginTime = strTemp;
    GetDlgItem(IDC_PERSON_TIME_BEGIN)->GetWindowText(strTemp);
    strBeginTime += " ";
    strBeginTime += strTemp;
    GetDlgItem(IDC_PERSON_DATA_END)->GetWindowText(strTemp);
    strEndTime = strTemp;
    GetDlgItem(IDC_PERSON_TIME_END)->GetWindowText(strTemp);
    strEndTime += " ";
    strEndTime += strTemp;

    dwBeginTime = GetTick(strBeginTime);
    dwEndTime = GetTick(strEndTime);

    if (difftime(dwBeginTime, dwEndTime) >= 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Start time is greater than end time");
        return FALSE;
    }

    return TRUE;
}

long CPersonAlarmRecord::GetTick(const CString& strTime)
{
    int nYear, nMonth, nDate, nHour, nMin, nSec;
    int nPos= strTime.Find('/');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d/%d/%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('-');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d-%d-%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }
    nPos= strTime.Find('.');
    if (nPos != std::string::npos)
    {
        sscanf(strTime, "%d.%d.%d %d:%d:%d", &nYear, &nMonth, &nDate, &nHour, &nMin, &nSec);
    }

    struct tm stm;
    memset(&stm,0,sizeof(stm));
    if (nYear > 1900)
    {
        stm.tm_year = nYear-1900;
    }
    else
    {
        stm.tm_year = 2000 + nYear - 1900;
    }
    stm.tm_mon = nMonth-1;
    stm.tm_mday = nDate;
    stm.tm_hour = nHour;
    stm.tm_min = nMin;
    stm.tm_sec = nSec;

    return mktime(&stm);
}

VOID CPersonAlarmRecord::SavePicture(CString pszFileName, CHAR *pszBuf, INT32 dwSize)
{
    if(pszBuf == NULL || dwSize <= 0)
    {
        return;
    }
    FILE *fp = fopen(pszFileName, "wb");
    if(fp != NULL)
    {
        fwrite(pszBuf, dwSize, 1, fp);
        fclose(fp);
    } 
}

VOID CPersonAlarmRecord::CleanFaceRecordSnapshotInfoVector()
{
    for(int i =0; i < m_oFaceRecordSnapshotInfoVector.size(); i++)
    {
        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData = NULL;
        }

        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData = NULL;
        }
 
        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stBigImage.pcData = NULL;
        }

        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData != NULL)
        {
            delete[] m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData;
            m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData = NULL;
        }
    }
    m_oFaceRecordSnapshotInfoVector.clear();
}

VOID CPersonAlarmRecord::DisPlayFaceRecordSnapshotInfoVector()
{
    m_oPersonInfoDisPlayList.DeleteAllItems();
    UpdateData(TRUE);

    CHAR szBuf[64] = {0};
    CString strFilePath = gstLocalParam.szPictureSavePath + CString("\\");
    CTime oTime = CTime::GetCurrentTime();
    CString strTime = oTime.Format("%y%m%d%H%M%S");

    for(INT32 i =0; i < m_oFaceRecordSnapshotInfoVector.size(); i++)
    {
        CString strPassTime = "";
        strPassTime.Format("%d", m_oFaceRecordSnapshotInfoVector[i].udwPassTime);

        CString strName = "";
        UTF8ToMB(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.szMemberName, szBuf, sizeof(szBuf) - 1);
        strName.Format("%s", szBuf);

        CString strGender = "";
        if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.udwMemberGender == 1)
        {
            strGender = "Man";
        }
        else if(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.udwMemberGender == 2)
        {
            strGender = "Woman";
        }
        else
        {
            strGender = "unknow";
        }

        CString strID = "";
        UTF8ToMB(m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberIDInfo.szNumber, szBuf, sizeof(szBuf) - 1);
        strID.Format("%s", szBuf);

        CString strAlarmSource = "";
        UTF8ToMB(m_oFaceRecordSnapshotInfoVector[i].szChannelName, szBuf, sizeof(szBuf) - 1);
        strAlarmSource.Format("%s", szBuf);

        CString strSimiliar = "";
        strSimiliar.Format("%d", m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.udwSimilarity);

        m_oPersonInfoDisPlayList.InsertItem(i, _T(""));

        /* Small picture */
        { 
            CString strFileNameSmall = strFilePath + "Name_" + strName+ "_Gender_" + strGender + "ID" + strID +"_PassTime_" + strPassTime + "AlarmSource"+ strAlarmSource + "Similiar" + strSimiliar +"_SmallImage.jpg";
            SavePicture(strFileNameSmall, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.pcData, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stSnapshotImage.stSmallImage.udwSize);
            m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_SMALLPICTUREPARH, strFileNameSmall);
    
        }

        /* Monitor picture */
        {
            CString strFileNameMemberImage = strFilePath + "Name_" + strName+ "_Gender_" + strGender + "ID" + strID +"_PassTime_" + strPassTime + "AlarmSource"+ strAlarmSource+ "Similiar" + strSimiliar + "_MemberImage.jpg";
            SavePicture(strFileNameMemberImage, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.pcData, m_oFaceRecordSnapshotInfoVector[i].stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize);
            m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_MONTIORPICPATH, strFileNameMemberImage);
        }

        /* Big Picture */
        {
            LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
            if (NULL != lpDevHandle)
            {
                NETDEV_FILE_INFO_S stFileInfo = {0};
                stFileInfo.udwSize = 1048576;
                stFileInfo.pcData = new CHAR[stFileInfo.udwSize];

                BOOL bRet = NETDEV_GetFaceRecordImageInfo(lpDevHandle, m_oFaceRecordSnapshotInfoVector[i].udwRecordID, 0, &stFileInfo);
                if(bRet == TRUE)
                {
                    CString strRecordID = "";
                    strRecordID.Format(_T("%d"), m_oFaceRecordSnapshotInfoVector[i].udwRecordID);
                    CString strFileNameBig = strFilePath + "Name_" + strName+ "_Gender_" + strGender + "ID" + strID +"_PassTime_" + strPassTime + "AlarmSource"+ strAlarmSource + "Similiar" + strSimiliar +"_BigImage.jpg";
                    SavePicture(strFileNameBig, stFileInfo.pcData, stFileInfo.udwSize);
                }
                delete[] stFileInfo.pcData;
                stFileInfo.pcData = NULL;
            }
        }

        /* Name */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_NAME, strName);

        /* Gender */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_GENDRE, strGender);

        /* ID */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_IDNUMBER, strID);

        /* Time */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_ALARM_TMIE, strPassTime);

        /* Alarm source */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_ALARM_SOURCE, strAlarmSource);

        /* similar */
        m_oPersonInfoDisPlayList.SetItemText(i, COL_PERSON_SIMILAR, strSimiliar);

    }

    m_strTotalNumber.Format("%d", m_dwTotalNumber);
    m_strCurrentNumber.Format("%d", m_dwCurrentNumber+16);
    UpdateData(FALSE);
    CleanFaceRecordSnapshotInfoVector();
}

VOID CPersonAlarmRecord::FindPersonAlarmInfo()
{
    UpdateData(TRUE);

    LPVOID lpDevHandle = ga_pMainDlg->GetDevHandle();
    if (NULL == lpDevHandle)
    {
        return ;
    }

    NETDEV_ALARM_LOG_COND_LIST_S stFindCond = {0};
    stFindCond.dwPageRow = 16;
    stFindCond.dwFirstRow = m_dwCurrentNumber;
    stFindCond.dwCondSize = 0;

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_ALARMTYPE;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
    if(m_oCBoxMonitoType.GetCurSel() == 0)
    {
        memcpy(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "1018", sizeof(stFindCond.astCondition[0].szConditionData)); //NETDEV_ALARM_SMART_FACE_MATCH_LIST
    }
    else if(m_oCBoxMonitoType.GetCurSel() == 1)
    {
        memcpy(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "1020", sizeof(stFindCond.astCondition[0].szConditionData)); //NETDEV_ALARM_SMART_FACE_MISMATCH_LIST
    }
    stFindCond.dwCondSize++;

    INT64 tBeginTime = 0;
    INT64 tEndTime = 0;
    if (FALSE == getTimeInfo(tBeginTime, tEndTime))
    {
        return ;
    }

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_LESS;
    sprintf(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "%ld", tBeginTime); 
    stFindCond.dwCondSize++;

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_NO_GREATER;
    sprintf(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, "%ld", tEndTime);
    stFindCond.dwCondSize++;

    if(!m_strPersonName.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_USERNAME;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        MBToUTF8(m_strPersonName.GetBuffer(0), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, sizeof(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData) - 1);
        stFindCond.dwCondSize++;
    }

    if(!m_strIDNumber.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_CARD_NUM;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        MBToUTF8(m_strIDNumber.GetBuffer(0), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, sizeof(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData) - 1);
        stFindCond.dwCondSize++;
    }

    if(m_dwGender != 0 && m_dwGender <= 2)
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_ALARM_GENDER;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_EQUAL;
        itoa(m_dwGender, stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, 10);
        stFindCond.dwCondSize++;
    }

    if(!m_strAlarmSource.IsEmpty())
    {
        stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_ALARMSRCNAME;
        stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
        MBToUTF8(m_strAlarmSource.GetBuffer(0), stFindCond.astCondition[stFindCond.dwCondSize].szConditionData, sizeof(stFindCond.astCondition[stFindCond.dwCondSize].szConditionData) - 1);
        stFindCond.dwCondSize++;
    }

    stFindCond.astCondition[stFindCond.dwCondSize].dwQueryType = NETDEV_QUERYCOND_TIME;
    stFindCond.astCondition[stFindCond.dwCondSize].dwLogicFlag = NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
    stFindCond.dwCondSize++;

    NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  stResultInfo = {0};
    BOOL bRet = FALSE;
    CString strFilePath = gstLocalParam.szPictureSavePath + CString("\\");

    LPVOID lpFindRecordHandlePointer = NETDEV_FindFaceRecordDetailList(lpDevHandle, &stFindCond, &stResultInfo);
    if(lpFindRecordHandlePointer != NULL)
    {
        m_dwTotalNumber = stResultInfo.udwTotal;
        while(TRUE)
        {
            NETDEV_FACE_RECORD_SNAPSHOT_INFO_S stRecordInfo = {0};

            stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize = 1048576;
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.pcData = new CHAR[stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize];
            
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.udwSize = 1048576;
            stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData = new CHAR[stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize];

            stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.udwSize = 1048576;
            stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.pcData = new CHAR[stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.udwSize];
            
            stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.udwSize = 1048576;
            stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.pcData = new CHAR[stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.udwSize];

            bRet = NETDEV_FindNextFaceRecordDetail(lpFindRecordHandlePointer, &stRecordInfo);
            if(bRet == TRUE)
            {
                CTime oTime = CTime::GetCurrentTime();
                CString strTime = oTime.Format("%y%m%d%H%M%S");

                m_oFaceRecordSnapshotInfoVector.push_back(stRecordInfo);
            }
            else 
            {
                break;
            }
        }
        NETDEV_FindCloseFaceRecordDetail(lpFindRecordHandlePointer);
    }

    DisPlayFaceRecordSnapshotInfoVector();
}


BEGIN_MESSAGE_MAP(CPersonAlarmRecord, CDialog)
    ON_BN_CLICKED(IDC_BUTTON_PERSON_FIND, &CPersonAlarmRecord::OnBnClickedButtonPersonFind)
    ON_BN_CLICKED(IDC_BUTTON_PERSON_ALARM_PREV, &CPersonAlarmRecord::OnBnClickedButtonPersonAlarmPrev)
    ON_BN_CLICKED(IDC_BUTTON_PERSON_ALARM_NEXT, &CPersonAlarmRecord::OnBnClickedButtonPersonAlarmNext)
END_MESSAGE_MAP()


// CPersonAlarmRecord Ϣ

void CPersonAlarmRecord::OnBnClickedButtonPersonFind()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwTotalNumber = 0;
    m_dwCurrentNumber = 0;
    FindPersonAlarmInfo();
}

void CPersonAlarmRecord::OnBnClickedButtonPersonAlarmPrev()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber -= 16;
    if(m_dwCurrentNumber < 0)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index less than 0");
        return;
    }
    FindPersonAlarmInfo();
}

void CPersonAlarmRecord::OnBnClickedButtonPersonAlarmNext()
{
    // TODO: ڴӿؼ֪ͨ
    m_dwCurrentNumber += 16;
    if(m_dwCurrentNumber >= m_dwTotalNumber)
    {
        NETDEMO_LOG_ERROR(NULL, "Current index big than total index");
        return;
    }
    FindPersonAlarmInfo();
}
