// PersonInfo.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "PersonInfo.h"


// CPersonInfo Ի

IMPLEMENT_DYNAMIC(CPersonInfo, CDialog)

CPersonInfo::CPersonInfo(CWnd* pParent /*=NULL*/)
	: CDialog(CPersonInfo::IDD, pParent)
{
}

CPersonInfo::~CPersonInfo()
{
}


BOOL CPersonInfo::OnInitDialog()
{
    CDialog::OnInitDialog();
    InitIDType();

    return TRUE;
}

void CPersonInfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);

    DDX_Text(pDX, IDC_EDIT_PERSON_NAME, m_strPersonName);
    DDX_Control(pDX, IDC_DATETIMEPICKER_BIRTHDAY, m_oBirthData);
    //Gender
    if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_MAN))->GetCheck())
    {
        m_dwGender = NETDEV_GENDER_TYPE_MAN;
    }
    else if(TRUE == ((CButton *)GetDlgItem(IDC_RADIO_WOMAN))->GetCheck())
    {
        m_dwGender = NETDEV_GENDER_TYPE_WOMAN;
    }
    else
    {
         m_dwGender = NETDEV_GENDER_TYPE_UNKNOW;
    }
    DDX_Text(pDX, IDC_EDIT_PERSON_NATION, m_strNation);
    DDX_Control(pDX, IDC_CMB_ID_TYPE, m_oCBoxIDType);
    DDX_Text(pDX, IDC_EDIT_PERSON_PROVINCE, m_strProvince);
    DDX_Text(pDX, IDC_EDIT_PERSON_ID_NUMBER, m_strIDNumber);
    DDX_Text(pDX, IDC_EDIT_PERSON_CITY, m_strCity);
    DDX_Text(pDX, IDC_EDIT_PERSON_PIC_PATH, m_strPicturePath);
}

VOID CPersonInfo::SetPersonLibID(INT32 dwPersonLibId)
{
    m_dwPersonLibID = dwPersonLibId;
}

VOID CPersonInfo::SetType(INT32 dwType)
{
    m_nType = dwType;
}

VOID CPersonInfo::AddPerson()
{
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    NETDEV_PERSON_INFO_LIST_S stPersonInfoList = {0};
    stPersonInfoList.udwNum = 1;

    NETDEV_PERSON_INFO_S stPersonInfo = {0};
    stPersonInfoList.pstPersonInfo = &stPersonInfo;

    //

    MBToUTF8(m_strPersonName.GetBuffer(0), stPersonInfo.szPersonName, sizeof(stPersonInfo.szPersonName) - 1);
    
    CTime tSysDate;
    m_oBirthData.GetTime(tSysDate);
    CString strDate = tSysDate.Format("%Y%m%d");
    MBToUTF8(strDate.GetBuffer(0), stPersonInfo.szBirthday, sizeof(stPersonInfo.szBirthday) - 1);
    stPersonInfo.udwGender = m_dwGender;
    MBToUTF8(m_strNation.GetBuffer(0), stPersonInfo.stRegionInfo.szNation, sizeof(stPersonInfo.stRegionInfo.szNation) - 1);
    stPersonInfo.udwIdentificationNum = 1;
    stPersonInfo.stIdentificationInfo[0].udwType = m_oCBoxIDType.GetCurSel();
    MBToUTF8(m_strProvince.GetBuffer(0), stPersonInfo.stRegionInfo.szProvince, sizeof(stPersonInfo.stRegionInfo.szProvince) - 1);
    MBToUTF8(m_strIDNumber.GetBuffer(0), stPersonInfo.stIdentificationInfo[0].szNumber, sizeof(stPersonInfo.stIdentificationInfo[0].szNumber) - 1);
    MBToUTF8(m_strCity.GetBuffer(0), stPersonInfo.stRegionInfo.szCity, sizeof(stPersonInfo.stRegionInfo.szCity) - 1);
    CHAR szPicturePath[NETDEV_LEN_256] = {0};
    MBToUTF8(m_strPicturePath.GetBuffer(0), szPicturePath, sizeof(szPicturePath) - 1);

    stPersonInfo.udwImageNum = 1;

    CFile file(m_strPicturePath, CFile::modeRead);
    DWORD dwFileLen = file.GetLength();
    stPersonInfo.stImageInfo[0].stFileInfo.udwSize = dwFileLen;
    stPersonInfo.stImageInfo[0].stFileInfo.pcData = new CHAR[stPersonInfo.stImageInfo[0].stFileInfo.udwSize];
    memset(stPersonInfo.stImageInfo[0].stFileInfo.pcData, 0, stPersonInfo.stImageInfo[0].stFileInfo.udwSize);
    file.Read(stPersonInfo.stImageInfo[0].stFileInfo.pcData, stPersonInfo.stImageInfo[0].stFileInfo.udwSize);
    file.Close();

    CString strFileName = m_strPicturePath.Right(m_strPicturePath.GetLength()-m_strPicturePath.ReverseFind('\\')-1);
    MBToUTF8(strFileName.GetBuffer(0), stPersonInfo.stImageInfo[0].stFileInfo.szName, sizeof(stPersonInfo.stImageInfo[0].stFileInfo.szName) - 1);

    NETDEV_PERSON_RESULT_LIST_S stPersonResultList = {0};

    BOOL bRet = NETDEV_AddPersonInfo(lpHandle, m_dwPersonLibID, &stPersonInfoList, &stPersonResultList);
    delete[] stPersonInfo.stImageInfo[0].stFileInfo.pcData;
    stPersonInfo.stImageInfo[0].stFileInfo.pcData = NULL;
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_AddPersonInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_AddPersonInfo");
}

VOID CPersonInfo::ModifyPerson()
{
    LPVOID lpHandle = ga_pMainDlg->GetDevHandle();
    if ((NULL == lpHandle))
    {
        NETDEMO_LOG_ERROR(NULL, "Device Handle : %p", lpHandle);
        return;
    }

    NETDEV_PERSON_INFO_LIST_S stPersonInfoList = {0};
    stPersonInfoList.udwNum = 1;

    stPersonInfoList.pstPersonInfo = m_pstPersomInfo;

    //

    MBToUTF8(m_strPersonName.GetBuffer(0), m_pstPersomInfo->szPersonName, sizeof(m_pstPersomInfo->szPersonName) - 1);

    CTime tSysDate;
    m_oBirthData.GetTime(tSysDate);
    CString strDate = tSysDate.Format("%Y%m%d");
    MBToUTF8(strDate.GetBuffer(0), m_pstPersomInfo->szBirthday, sizeof(m_pstPersomInfo->szBirthday) - 1);

    m_pstPersomInfo->udwGender = m_dwGender;
    MBToUTF8(m_strNation.GetBuffer(0), m_pstPersomInfo->stRegionInfo.szNation, sizeof(m_pstPersomInfo->stRegionInfo.szNation) - 1);
    m_pstPersomInfo->udwIdentificationNum = 1;
    m_pstPersomInfo->stIdentificationInfo[0].udwType = m_oCBoxIDType.GetCurSel();
    MBToUTF8(m_strProvince.GetBuffer(0), m_pstPersomInfo->stRegionInfo.szProvince, sizeof(m_pstPersomInfo->stRegionInfo.szProvince) - 1);
    MBToUTF8(m_strIDNumber.GetBuffer(0), m_pstPersomInfo->stIdentificationInfo[0].szNumber, sizeof(m_pstPersomInfo->stIdentificationInfo[0].szNumber) - 1);
    MBToUTF8(m_strCity.GetBuffer(0), m_pstPersomInfo->stRegionInfo.szCity, sizeof(m_pstPersomInfo->stRegionInfo.szCity) - 1);
    CHAR szPicturePath[NETDEV_LEN_256] = {0};
    MBToUTF8(m_strPicturePath.GetBuffer(0), szPicturePath, sizeof(szPicturePath) - 1);

    if(m_strPicturePath.GetLength() != 0)
    {
        m_pstPersomInfo->udwImageNum = 1;

        CFile file(m_strPicturePath, CFile::modeRead);
        DWORD dwFileLen = file.GetLength();
        m_pstPersomInfo->stImageInfo[0].stFileInfo.udwSize = dwFileLen;
        delete[] m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData;
        m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData = new CHAR[m_pstPersomInfo->stImageInfo[0].stFileInfo.udwSize];
        memset(m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData, 0, m_pstPersomInfo->stImageInfo[0].stFileInfo.udwSize);
        file.Read(m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData, m_pstPersomInfo->stImageInfo[0].stFileInfo.udwSize);
        file.Close();

        CString strFileName = m_strPicturePath.Right(m_strPicturePath.GetLength()-m_strPicturePath.ReverseFind('\\')-1);
        MBToUTF8(strFileName.GetBuffer(0), m_pstPersomInfo->stImageInfo[0].stFileInfo.szName, sizeof(m_pstPersomInfo->stImageInfo[0].stFileInfo.szName) - 1);
    }

    NETDEV_PERSON_RESULT_LIST_S stPersonResultList = {0};

    BOOL bRet = NETDEV_ModifyPersonInfo(lpHandle, m_dwPersonLibID, &stPersonInfoList, &stPersonResultList);
    delete[] m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData;
    m_pstPersomInfo->stImageInfo[0].stFileInfo.pcData = NULL;
    if(TRUE != bRet)
    {
        NETDEMO_LOG_ERROR(NULL, "NETDEV_ModifyPersonInfo");
        return;
    }
    NETDEMO_LOG_SUCC(NULL, "NETDEV_ModifyPersonInfo");
}

VOID CPersonInfo::SetPersonInfo(LPNETDEV_PERSON_INFO_S pstPersomInfo)
{
    m_pstPersomInfo = pstPersomInfo;
}

VOID CPersonInfo::InitIDType()
{
    m_oCBoxIDType.InsertString(NETDEV_CERTIFICATE_TYPE_ID, _T("ID"));
    m_oCBoxIDType.InsertString(NETDEV_CERTIFICATE_TYPE_IC, _T("IC"));
    m_oCBoxIDType.InsertString(NETDEV_CERTIFICATE_TYPE_PASSPORT, _T("PASSPORT"));
    m_oCBoxIDType.InsertString(NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE, _T("DRIVING LICENSE"));
    m_oCBoxIDType.InsertString(NETDEV_CERTIFICATE_TYPE_OTHER, _T("OTHER"));
    m_oCBoxIDType.SetCurSel(0);
}

INT32 CPersonInfo::ReadPictureFile(CString strFilePath, CHAR* pszDst)
{
    CFile file(strFilePath, CFile::modeRead);
    DWORD dwFileLen = file.GetLength();
    pszDst = new CHAR[dwFileLen+1];
    memset(pszDst, 0, dwFileLen+1);
    file.Read(pszDst, dwFileLen);
    file.Close();
    return dwFileLen;
}

VOID CPersonInfo::ReloadPersonInfo()
{
    CHAR szTmp[NETDEV_LEN_64] = {0};
    UTF8ToMB(m_pstPersomInfo->szPersonName, szTmp, sizeof(szTmp) - 1);
    m_strPersonName = szTmp;

    CHAR szTime[NETDEV_LEN_32] ={0}; 
    sprintf(szTime,"%.4s-%.2s-%.2s",m_pstPersomInfo->szBirthday,m_pstPersomInfo->szBirthday+4,m_pstPersomInfo->szBirthday+6);
    INT32 dwYear = 0;
    INT32 dwMonth = 0;
    INT32 dwDay = 0;
    sscanf(szTime,"%d-%d-%d",&dwYear,&dwMonth,&dwDay); 
    SYSTEMTIME oSysTime = {0};
    oSysTime.wYear = dwYear;
    oSysTime.wMonth = dwMonth;
    oSysTime.wDay = dwDay;
    m_oBirthData.SetTime(oSysTime);

    if(m_pstPersomInfo->udwGender == NETDEV_GENDER_TYPE_MAN)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_MAN))->SetCheck(TRUE);
    }
    else if(m_pstPersomInfo->udwGender == NETDEV_GENDER_TYPE_WOMAN)
    {
        ((CButton *)GetDlgItem(IDC_RADIO_WOMAN))->SetCheck(TRUE);
    }
    else
    {
        ((CButton *)GetDlgItem(IDC_RADIO_UNKNOW))->SetCheck(TRUE);
    }

    UTF8ToMB(m_pstPersomInfo->stRegionInfo.szNation, szTmp, sizeof(szTmp) - 1);
    m_strNation = szTmp;

    m_oCBoxIDType.SetCurSel(m_pstPersomInfo->stIdentificationInfo[0].udwType);

    UTF8ToMB(m_pstPersomInfo->stRegionInfo.szProvince, szTmp, sizeof(szTmp) - 1);
    m_strProvince = szTmp;

    UTF8ToMB(m_pstPersomInfo->stIdentificationInfo[0].szNumber, szTmp, sizeof(szTmp) - 1);
    m_strIDNumber = szTmp;

    UTF8ToMB(m_pstPersomInfo->stRegionInfo.szCity, szTmp, sizeof(szTmp) - 1);
    m_strCity = szTmp;


    UpdateData(FALSE);
}

VOID CPersonInfo::CleanCacheData()
{
    m_strPersonName = "";
    m_dwGender = 0;
    m_strNation = "";
    m_strProvince = "";
    m_strIDNumber = "";
    m_strCity = "";
    m_strPicturePath = "";

    m_dwPersonLibID = 0;
    m_pstPersomInfo = NULL;
    UpdateData(FALSE);
}


BEGIN_MESSAGE_MAP(CPersonInfo, CDialog)
	ON_BN_CLICKED(IDC_BTN_BROWSE, &CPersonInfo::OnBnClickedBtnBrowse)
    ON_BN_CLICKED(IDC_BTN_PERSON_INFO, &CPersonInfo::OnBnClickedBtnPersonInfo)
END_MESSAGE_MAP()


// CPersonInfo Ϣ

void CPersonInfo::OnBnClickedBtnBrowse()
{
	// TODO: ڴӿؼ֪ͨ

	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, _T("ļ(*.jpg)|*.jpg||"), NULL, NULL, FALSE);
	if (dlg.DoModal() == IDOK)
	{
		CString strPathName = dlg.GetPathName();
		GetDlgItem(IDC_EDIT_PERSON_PIC_PATH)->SetWindowText(strPathName);
	}
	else
	{
		GetDlgItem(IDC_EDIT_PERSON_PIC_PATH)->SetWindowText("");
	}
}

void CPersonInfo::OnBnClickedBtnPersonInfo()
{
    UpdateData(TRUE);
    // TODO: ڴӿؼ֪ͨ
    if(m_nType == 0)
    {
        AddPerson();
    }
    else if(m_nType == 1)
    {
        ModifyPerson();
    }
}
