// Vehicle.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDemo.h"
#include "Vehicle.h"

typedef enum tabIndexConfig
{
	TAB_INDEX_LIBRARY_MANAGERMENT  = 0,
	TAB_INDEX_MONITORING_TASK = 1,
	TAB_INDEX_REALTIME_MONITORING = 2,
    TAB_INDEX_VEHICLE_ALARM_RECORD = 3,
    TAB_INDEX_VEHICLE_PASS_RECORD = 4,
};

// CVehicle Ի

IMPLEMENT_DYNAMIC(CVehicle, CDialog)

CVehicle::CVehicle(CWnd* pParent /*=NULL*/)
	: CDialog(CVehicle::IDD, pParent)
{

}

CVehicle::~CVehicle()
{
}

void CVehicle::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_VEHICLE, m_oTabVehicle);
}


BEGIN_MESSAGE_MAP(CVehicle, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_VEHICLE, &CVehicle::OnTcnSelchangeTabVehicle)
END_MESSAGE_MAP()


// CVehicle Ϣ

BOOL CVehicle::OnInitDialog()
{
	CDialog::OnInitDialog();
	CRect rc(0, 0, 0, 0);
	GetParent()->GetClientRect(&rc);
	((CTabCtrl*)GetParent())->AdjustRect(FALSE, &rc);
	MoveWindow(&rc);

	m_oLibraryManagerment.SetType(1);
	m_oMonitoringTask.SetType(1);
	m_oRealtimeMonitoring.SetType(1);
	CString str = "Vehicle Library Managerment";
	m_oTabVehicle.InsertItem(TAB_INDEX_LIBRARY_MANAGERMENT, str);
	m_oLibraryManagerment.Create(IDD_FACE_LIBRARY_MANAGERMENT,&m_oTabVehicle);
	m_oLibraryManagerment.ShowWindow(SW_SHOW);

	str = "Monitoring Task";
	m_oTabVehicle.InsertItem(TAB_INDEX_MONITORING_TASK, str);
	m_oMonitoringTask.Create(IDD_MONITORING_TASK,&m_oTabVehicle);
	m_oMonitoringTask.ShowWindow(SW_HIDE);

	str = "Realtime Monitoring";
	m_oTabVehicle.InsertItem(TAB_INDEX_REALTIME_MONITORING, str);
	m_oRealtimeMonitoring.Create(IDD_REALTIME_MONITORING,&m_oTabVehicle);
	m_oRealtimeMonitoring.ShowWindow(SW_HIDE);

    str = "Alarm Record";
    m_oTabVehicle.InsertItem(TAB_INDEX_VEHICLE_ALARM_RECORD, str);
    m_oVehicleAlarmRecord.Create(IDD_VEHICLE_ALARM_RECORD,&m_oTabVehicle);
    m_oVehicleAlarmRecord.ShowWindow(SW_HIDE);

    str = "Pass Record";
    m_oTabVehicle.InsertItem(TAB_INDEX_VEHICLE_PASS_RECORD, str);
    m_oVehiclePassRecord.Create(IDD_VEHICLE_PASS_RECORD,&m_oTabVehicle);
    m_oVehiclePassRecord.ShowWindow(SW_HIDE);

	return TRUE;
}

void CVehicle::TabWithUpdate(INT32 nTabIndex)
{
	switch(nTabIndex)
	{
	case TAB_INDEX_LIBRARY_MANAGERMENT:
		m_oLibraryManagerment.ShowWindow(SW_SHOW);
		m_oMonitoringTask.ShowWindow(SW_HIDE);
		m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oVehicleAlarmRecord.ShowWindow(SW_HIDE);
        m_oVehiclePassRecord.ShowWindow(SW_HIDE);
		break;
	case TAB_INDEX_MONITORING_TASK:
		m_oLibraryManagerment.ShowWindow(SW_HIDE);
		m_oMonitoringTask.ShowWindow(SW_SHOW);
		m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oVehicleAlarmRecord.ShowWindow(SW_HIDE);
        m_oVehiclePassRecord.ShowWindow(SW_HIDE);
		break;
	case TAB_INDEX_REALTIME_MONITORING:
		m_oLibraryManagerment.ShowWindow(SW_HIDE);
		m_oMonitoringTask.ShowWindow(SW_HIDE);
		m_oRealtimeMonitoring.ShowWindow(SW_SHOW);
        m_oVehicleAlarmRecord.ShowWindow(SW_HIDE);
        m_oVehiclePassRecord.ShowWindow(SW_HIDE);
		break;
    case TAB_INDEX_VEHICLE_ALARM_RECORD:
        m_oLibraryManagerment.ShowWindow(SW_HIDE);
        m_oMonitoringTask.ShowWindow(SW_HIDE);
        m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oVehicleAlarmRecord.ShowWindow(SW_SHOW);
        m_oVehiclePassRecord.ShowWindow(SW_HIDE);
        break;
    case TAB_INDEX_VEHICLE_PASS_RECORD:
        m_oLibraryManagerment.ShowWindow(SW_HIDE);
        m_oMonitoringTask.ShowWindow(SW_HIDE);
        m_oRealtimeMonitoring.ShowWindow(SW_HIDE);
        m_oVehicleAlarmRecord.ShowWindow(SW_HIDE);
        m_oVehiclePassRecord.ShowWindow(SW_SHOW);
        break;
	default:
		break;
	}
}

void CVehicle::OnTcnSelchangeTabVehicle(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ڴӿؼ֪ͨ
	UpdateData(TRUE);
	TabWithUpdate(m_oTabVehicle.GetCurSel());

	*pResult = 0;
}
