package main.java.com.netdevsdk.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.config.basic.DST;
import main.java.com.netdevsdk.demo.config.basic.DeviceBasicInfo;
import main.java.com.netdevsdk.demo.config.basic.DeviceName;
import main.java.com.netdevsdk.demo.config.basic.HardDisk;
import main.java.com.netdevsdk.demo.config.basic.SettingWindow;
import main.java.com.netdevsdk.demo.config.basic.SystemTime;
import main.java.com.netdevsdk.demo.config.image.ImageExposure;
import main.java.com.netdevsdk.demo.config.image.ImageInfo;
import main.java.com.netdevsdk.demo.config.image.ResetImage;
import main.java.com.netdevsdk.demo.config.image.WhiteBlance;
import main.java.com.netdevsdk.demo.config.io.AlarmInput;
import main.java.com.netdevsdk.demo.config.io.AlarmOutput;
import main.java.com.netdevsdk.demo.config.motion.MotionArea;
import main.java.com.netdevsdk.demo.config.motion.MotionDectionInfo;
import main.java.com.netdevsdk.demo.config.network.Card;
import main.java.com.netdevsdk.demo.config.network.DHCP;
import main.java.com.netdevsdk.demo.config.network.DNS;
import main.java.com.netdevsdk.demo.config.network.IPAdress;
import main.java.com.netdevsdk.demo.config.network.NTP;
import main.java.com.netdevsdk.demo.config.network.OnvifPort;
import main.java.com.netdevsdk.demo.config.network.Port;
import main.java.com.netdevsdk.demo.config.network.Telnet;
import main.java.com.netdevsdk.demo.config.network.Version;
import main.java.com.netdevsdk.demo.config.network.Vpn;
import main.java.com.netdevsdk.demo.config.osd.OSD;
import main.java.com.netdevsdk.demo.config.osd.OSDStyle;
import main.java.com.netdevsdk.demo.config.privacymask.PrivacyMask;
import main.java.com.netdevsdk.demo.config.server.SmartServer;
import main.java.com.netdevsdk.demo.config.temper.TemperDetection;
import main.java.com.netdevsdk.demo.config.temper.TemperAlarm;
import main.java.com.netdevsdk.demo.alarm.Alarm;
import main.java.com.netdevsdk.demo.config.video.FocusMode;
import main.java.com.netdevsdk.demo.config.video.IrCutFilterMode;
import main.java.com.netdevsdk.demo.config.video.SnapShot;
import main.java.com.netdevsdk.demo.config.video.Stream;
import main.java.com.netdevsdk.demo.discovery.Discovery;
import main.java.com.netdevsdk.demo.liveview.live.EyeFish;
import main.java.com.netdevsdk.demo.liveview.information.LiveVoice;
import main.java.com.netdevsdk.demo.liveview.information.MetaData;
import main.java.com.netdevsdk.demo.liveview.information.VideoEffect;
import main.java.com.netdevsdk.demo.liveview.live.BasicLive;
import main.java.com.netdevsdk.demo.liveview.live.Capture;
import main.java.com.netdevsdk.demo.liveview.live.DigitalZoom;
import main.java.com.netdevsdk.demo.liveview.live.MakeI;
import main.java.com.netdevsdk.demo.liveview.live.Microphone;
import main.java.com.netdevsdk.demo.liveview.live.Mute;
import main.java.com.netdevsdk.demo.liveview.live.PictureFluency;
import main.java.com.netdevsdk.demo.liveview.live.PlayDataCallBack;
import main.java.com.netdevsdk.demo.liveview.live.PlayDecodeVideoCB;
import main.java.com.netdevsdk.demo.liveview.live.Record;
import main.java.com.netdevsdk.demo.liveview.live.RenderScale;
import main.java.com.netdevsdk.demo.liveview.live.SoundVolume;
import main.java.com.netdevsdk.demo.liveview.live.Talk;
import main.java.com.netdevsdk.demo.login.Login;
import main.java.com.netdevsdk.demo.maintenance.Configuration;
import main.java.com.netdevsdk.demo.maintenance.Find;
import main.java.com.netdevsdk.demo.maintenance.Maintenance;
import main.java.com.netdevsdk.demo.maintenance.ManualRecord;
import main.java.com.netdevsdk.demo.objectSearch.objectsearch;
import main.java.com.netdevsdk.demo.playback.config.PlayBackDigitalZoom;
import main.java.com.netdevsdk.demo.playback.config.PlayBackPlayLocalFile;
import main.java.com.netdevsdk.demo.playback.config.PlayBackRenderScale;
import main.java.com.netdevsdk.demo.playback.config.RecordStatus;
import main.java.com.netdevsdk.demo.playback.play.DownloadRecord;
import main.java.com.netdevsdk.demo.playback.play.Playback;
import main.java.com.netdevsdk.demo.playback.play.QueryPlayBackRecordByMonth;
import main.java.com.netdevsdk.demo.playback.play.QueryRecord;
import main.java.com.netdevsdk.demo.ptz.basicptz.BasicPTZ;
import main.java.com.netdevsdk.demo.ptz.basicptz.PresetPTZ;
import main.java.com.netdevsdk.demo.ptz.ptzextend.Heater;
import main.java.com.netdevsdk.demo.ptz.ptzextend.Light;
import main.java.com.netdevsdk.demo.ptz.ptzextend.PresetPatrols;
import main.java.com.netdevsdk.demo.ptz.ptzextend.RoutePatrols;
import main.java.com.netdevsdk.demo.ptz.ptzextend.SnowRemoval;
import main.java.com.netdevsdk.demo.ptz.ptzextend.Wiper;
import main.java.com.netdevsdk.demo.user.AddUser;
import main.java.com.netdevsdk.demo.user.ModifyUser;
import main.java.com.netdevsdk.demo.user.Userlist;
import main.java.com.netdevsdk.demo.util.CheckHeaderCellRenderer;
import main.java.com.netdevsdk.demo.util.CheckTableModle;
import main.java.com.netdevsdk.demo.util.ComboBoxTable;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.DateChooser;
import main.java.com.netdevsdk.demo.util.JComboBoxRenderer;
import main.java.com.netdevsdk.demo.util.Common.NETDEMO_DEV_LOGININFO_S;
import main.java.com.netdevsdk.demo.vca.accesscontrol.ACS;
import main.java.com.netdevsdk.demo.vca.accesscontrol.DataReport;
import main.java.com.netdevsdk.demo.vca.face.AlarmRecord;
import main.java.com.netdevsdk.demo.vca.face.PassRecord;
import main.java.com.netdevsdk.demo.vca.face.PersonAlarm;
import main.java.com.netdevsdk.demo.vca.face.PersonLib;
import main.java.com.netdevsdk.demo.vca.face.PersonMonitorFunction;
import main.java.com.netdevsdk.demo.vca.peoplecounting.CountThreadClass;
import main.java.com.netdevsdk.demo.vca.peoplecounting.IPCPeopleCounting;
import main.java.com.netdevsdk.demo.vca.peoplecounting.NVRPeopleCounting;
import main.java.com.netdevsdk.demo.vca.vehicle.VCAVehicleMonitor;
import main.java.com.netdevsdk.demo.vca.vehicle.VehicleAlarm;
import main.java.com.netdevsdk.demo.vca.vehicle.VehicleAlarmRecord;
import main.java.com.netdevsdk.demo.vca.vehicle.VehicleLib;
import main.java.com.netdevsdk.demo.vca.vehicle.VehiclePassRecord;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.*;
import javax.swing.JRadioButton;

public class NetDemo {
    
    private JFrame frame;
    public static Pointer lpUserID = null; 
    public static boolean isTimer=false;
    public static String strPicturePath = "."+File.separator+"Picture"+File.separator;
    public static NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
    
    /* Declaration of the login variable */
    public static JTextField jTextFieldLoginUserName;
    public static JPasswordField jPasswordFieldLoginPassword;
    public static JTextField jTextFieldLoginIP;
    public static JTextField jTextFieldLoginPort;
    public static String strIPAddr;
    public static JComboBox<String> jComboBoxLoginProtocol;
    public static ExecutorService singleLoginThread=Executors.newSingleThreadExecutor();
    public static NETDEMO_DEV_LOGININFO_S gastLoginDeviceInfo;
    public static JButton jButtonLogOut;
    public static JButton jButtonLogIn;
    
    /* Declaration of the Discovery device variable*/
    public static JTextField jTextFieldStartIP;
    public static JTextField jTextFieldEndIP;
    public static JTable DeviceTable;
    public static JTable DiscoveryTable;
    public static JButton jButtonCheckSameDevice;
    public static DefaultTableModel DiscoveryTableModel = new DefaultTableModel(
            new Object[][] {
            },
            new String[] {
                "Type", "IP", "Port", "MAC", "Serial Num", "Manufacturer"
            }
        );
    
    /* Declaration of the LiveView variable */
    public static int getVAsum=0;
    public static int getMute2=0;                           //实况静音状态
    public static int state=0;                              //麦克风状态，0：关闭，1：开启 
    public static boolean bStartRecord = false;
    public static String strRecordPath = "";                //本地保存路径
    public static Pointer lpPlayHandle = null;              //播放句柄
    public static Pointer lpID=null;
    public static Pointer lpID2=null;
    public static Pointer lpTalkHandle = null;
    public static JLabel jLabelLiveSound;
    public static JSlider jSliderLiveMicSound;
    public static JSlider jSliderLiveSound;
    public static JPanel jPanelliveVoice;
    public static Panel panelPlayLabel = new Panel();
    public static JTable VATable = new JTable();
    public static JButton jButtonStartLive;
    public static JButton jButtonStopLive;
    public static JButton jButtonStartTalk;
    public static JButton jButtonStopTalk;
    public static JButton jButtonStartRecord;
    public static JButton jButtonStopRecord;
    public static JButton jButtonStartSourceData;
    public static JButton jButtonStopSourceData;
    public static JButton jButtonStartDecodeData;
    public static JButton jButtonStopDecodeData;
    public static JButton jButtonLiveGetVoice;
    public static JButton jButtonLiveSoundSilence;
    public static JButton jButtonMic;
    public static JTextField jTextFieldDigitalZoomLeft;
    public static JTextField jTextFieldDigitalZoomRight;
    public static JTextField jTextFieldDigitalZoomTop;
    public static JTextField jTextFieldDigitalZoomBottom;
    public static JTextField jTextFieldContrast;
    public static JTextField jTextFieldBrightness;
    public static JTextField jTextFieldSaturation;
    public static JTextField jTextFieldHue;
    public static JTextField jTextFieldGamma;
    public static JTextField jTextFieldLiveVoice;
    public static JCheckBox jCheckBoxVAEnable;
    public static JComboBox<String> jComboBoxPreviewMode;
    public static JComboBox<String> jComboBoxFishEyeMount;
    public static JComboBox<String> jComboBoxPictureFluency;
    public static JComboBox<String> jComboBoxRenderScale;
    public static JComboBox<String> comboBoxConfigVideoStreamIndex;
    public static JComboBox<Object> comboBoxConfigVideoStreamEncodeFormat = new JComboBox<Object>();
    public static JComboBox<Object> comboBoxConfigVideoStreamQuality = new JComboBox<Object>();
    public static JComboBox<String> comboBoxConfigVideoStreamRate = new JComboBox<String>();
    
	/* Declaration of the PTZ variable*/
    public static int ptzPause=0;
    public static JTable jTablePTZBasePreset;
    public static JTable jTablePTZExtendPresetPatrols;
    public static JButton jButtonGetBasePTZPreset;
    public static JButton jButtonPTZExtendRouteRecordStop;
    public static JButton jButtonPTZExtendPresetPatrolsRefresh; 
    public static JTextField jTextFieldPTZExtendRoutePatrolsName;
    public static JTextField jTextFieldPTZExtendPresetPatrolsName;
    public static JTextField jTextFieldExtendPTZStayTime;
    public static JTextField jTextFieldPTZExtendPresetPatrolsSpeed;
    public static JComboBox<String> jComboBoxExtendPTZPresetID;
    public static JComboBox<String> jComboBoxPTZSpeed;
    public static JComboBox<String> jComboBoxPTZExtendPresetPatrolsID;
    public static DefaultTableModel PTZBasePresetModel  = new DefaultTableModel(
            new Object[][] {},
            new String[] {"Preset ID(1~255)", "Preset Name"}
        );
    
    /* Declaration of the PlayBack variable */
    public static int getMute=0;
    public static int PlayBackControlCmd = 0;
    public static Pointer lpDownloadHandle = null; 
    public static Pointer lpDownloadHandleByName = null; 
    public static JTable RecordTable;
    public static ExecutorService singleLiveThread=Executors.newFixedThreadPool(7);
    public static JSlider jSliderPlayBack;
    public static JProgressBar DownloadProgress;
    public static JLabel lblProgressLabel;
    public static JLabel lblPlaybackSpeed;
    public static JTable tableRecordByMonthList; 
    public static JTable tableRecordStatusList;
    public static JButton jButtonQueryrecord;
    public static JButton jButtonStopPlayback;
    public static JButton jButtonPauseOrResume;
    public static JButton jButtonFastSpeed;
    public static JButton jButtonSlowSpeed;
    public static JButton jButtonPlayLocalFile;
    public static JButton jButtonPlayLocalFilePause;
    public static JButton jButtonStopLocalFile;
    public static JButton jButtonStartdownload;
    public static JButton jButtonStartdownloadByName;
    public static JTextField jTextFieldPlayBackRecordByMonthISYear;
    public static JTextField jTextFieldPlayBackDigitalZoomLeft;
    public static JTextField jTextFieldPlayBackDigitalZoomRight;
    public static JTextField jTextFieldPlayBackDigitalZoomTop;
    public static JTextField jTextFieldPlayBackDigitalZoomBottom;
    public static JTextField jTextFieldPlayLocalFile;
    public static JComboBox<String> jComboBoxPlayBackRenderScale;
    public static JComboBox<String> jComboBoxPlayRecordMonth;
    
    /* Declaration of the VCA variable*/
    public static int currentPage=1;
    public static int currentPage2=1;
    public static int getCount=0;
    public static int dwPersonRecognizeMointerID = -1;
    public static int PersonStructMointerID = -1;
    public static int dwVehicleRecognizeMointerID = -1;
    public static int dwVehicleStructMointerID = -1;
    public static int dwAccessControlFGMointerID = -1;
    public static int ChannelID = 0;
    public static volatile boolean flag=false;
    public static IntByReference udwSearchID;
    public static String DateFormat = "yyyy-MM-dd HH:mm:ss";
    public static JTable PersonMonitorTable;
    public static JPanel jPanelAlarm1 = new JPanel();
    public static JPanel jPanelPeoplePass1 = new JPanel();
    public static JPanel jPanelAlarm2 = new JPanel();
    public static JPanel jPanelPeoplePass2 = new JPanel();
    public static JPanel jPanelAlarmVehicle = new JPanel();
    public static JPanel jPanelAlarmVehicle2 = new JPanel();
    public static JPanel jPanelPassVehicle = new JPanel();
    public static JPanel jPanelPassVehicle2 = new JPanel();
    public static JPanel jPanelBeginDate = new JPanel();
    public static JPanel jPanelEndDate = new JPanel();
    public static JPanel jPanelStatisticsBeginTime;
    public static JPanel jPanelStatisticsEndTime = new JPanel();
    public static JTable jTablePerson;
    public static JTable VehicleTable;
    public static JTable jTableVehicleMonitor;
    public static JTable jTableACS;
    public static JTable jTableVisitorACS;
    public static JTable jTablePeopleCountingIPC;
    public static JTable jTablePeopleCountingVMSNVRRealTime;
    public static JTable jTablePeopleCountingVMSNVRStatisticalReportType;
    public static Vector getRowData=null;
    public static Vector<String> RecordHeaderNames;
    public static Vector getVisitorData=new Vector();
    public static Vector<String> HeaderNames; 
    public static NETDEV_DEVICE_BASE_INFO_S pstDeviceInfo;
    public static NETDEV_VehicleAlarmMessCallBack_PF pfVehicleAlarmMessCB =new NETDEV_VehicleAlarmMessCallBack_PF();
    public static NETDEV_AlarmMessFGCallBack_PF pfAlarmMessFGCB =new NETDEV_AlarmMessFGCallBack_PF();
    public static ExecutorService CountThread=Executors.newFixedThreadPool(6);
    public static CountThreadClass t = new CountThreadClass();
    public static JButton jButtonFindPersonMonitor;
    public static JButton jButtonFindPerson;
    public static JButton jButtonFindPersonLib ;
    public static JButton jButtonAddPersonLib;
    public static JButton jButtonEnablePersonMonitor ;
    public static JButton jButtonShutDownPersonMonitor ;
    public static JButton jButtonVehicleFind;
    public static JButton jButtonVehicleLibFind;
    public static JButton jButtonFindVehicleMonitor; 
    public static JButton jButtonACSRecordsPre;
    public static JButton jButtonACSRecordsNext;
    public static JButton jButtonACSRecordsGo;
    public static JButton jButtonVisitorRecordPre;
    public static JButton jButtonVisitorRecordGo;
    public static JButton jButtonVisitorRecordNext;
    public static JButton jButtonRemoveSameCar;
    public static JTextField jTextFieldPersonPassAlarmSource;
    public static JTextField jTextFieldVehicleAlarmBayonetName;
    public static JTextField jTextFieldVehicleAlarmPlateNumber;
    public static JTextField jTextFieldVehicleRecordVayonetName;
    public static JTextField jTextFieldVehicleRecordPlateNumber;
    public static JTextField jTextFieldCountPageSize;
    public static JTextField jTextFieldACSRecord;
    public static JTextField jTextFieldGetVisitorName;
    public static JTextField jTextFieldVisitorPageCount;
    public static JTextField jTextFieldGetVisitorACSRecord;
    public static DateChooser PeopleAlarmStartTime = new DateChooser(jPanelAlarm1);
    public static DateChooser PeoplePassStartTime = new DateChooser(jPanelPeoplePass1);
    public static DateChooser PeopleAlarmEndTime = new DateChooser(jPanelAlarm2);
    public static DateChooser PeoplePassEndTime = new DateChooser(jPanelPeoplePass2);
    public static DateChooser VehicleAlarmStartTime = new DateChooser(jPanelAlarmVehicle);
    public static DateChooser VehicleAlarmEndTime = new DateChooser(jPanelAlarmVehicle2);
    public static DateChooser VehiclePassStartTime = new DateChooser(jPanelPassVehicle);
    public static DateChooser VehiclePassEndTime = new DateChooser(jPanelPassVehicle2);
    public static DateChooser BeginAcsDate = new DateChooser(jPanelBeginDate);
    public static DateChooser EndAcsDate = new DateChooser(jPanelEndDate);
    public static DateChooser CountingVMSNVRStattisticsEndTime = new DateChooser(jPanelStatisticsEndTime);
    public static DateChooser CountingVMSNVRStatisticsBeginTime = new DateChooser(jPanelStatisticsBeginTime);
    public static JComboBox<Object> jComboBoxPersonMonitorType;
    public static JComboBox<String> jComboBoxPersonLib;
    public static JComboBox<String> jComboBoxdeptID;
    public static JComboBox<String> jComboBoxVehicleLib;
    public static JComboBox<String> jComboBoxDeviceType;
    public static JComboBox<Object> jComboBoxVehicleAlarmMonitorType;
    public static JComboBox<Object> jComboBoxVehicleAlarmPlateColor;
    public static JComboBox<Object> jComboBoxVehicleAlarmCarColor;
    public static JComboBox<Object> jComboBoxVehicleAlarmMonitorReason;
    public static JComboBox<Object> jComboBoxVehiclePassPlateColor;
    public static JComboBox<Object> jComboBoxVehiclePassRecordCarColor;
    public static JComboBox<Object> jComboBoxPeopleCountingVMSNVRStatisticalReportType;
    public static Map<String, NETDEV_MONITION_INFO_S> mapPersonMonitorMap = new HashMap<String, NETDEV_MONITION_INFO_S>();
    public static Map<String, NETDEV_PERSON_INFO_S> mapPersonInfo = new HashMap<String, NETDEV_PERSON_INFO_S>();
    public static Map<String, NETDEV_LIB_INFO_S> mapPersonLib = new HashMap<String, NETDEV_LIB_INFO_S>();
    public static Map<String, NETDEV_LIB_INFO_S> mapVehicleLib = new HashMap<String, NETDEV_LIB_INFO_S>();
    public static Map<String, NETDEV_VEHICLE_DETAIL_INFO_S> mapVehicleInfo = new HashMap<String, NETDEV_VEHICLE_DETAIL_INFO_S>();
    public static Map<String, NETDEV_MONITION_INFO_S> mapVehicleMonitorMap = new HashMap<String, NETDEV_MONITION_INFO_S>();
    public static TableModel ACSTableModel;
    public static TableModel VisitorACSTableModel;
    
    /* Declaration of the video parameter variable */
    public static JPanel jPanelShowLiveParam = new JPanel();
    public static JLabel jLabelBitRateParam;
    public static JLabel jLabelFrameRate = new JLabel();
    public static JLabel jLabelLiveViewStreamUrl = new JLabel();
    public static JLabel jLabelVideoEncodeFmt;
    public static JLabel jLabelGetpdwWidth = new JLabel();
    public static JLabel jLabelGetpdwHeight  = new JLabel();
    public static JLabel jLabelGetpulRecvPktNum = new JLabel();
    public static JLabel jLabelLiveSound2;
    public static JLabel jLableLiveMicSound;
   
    /* Declaration of the Configure variable */ 
    public static boolean runflag=true;
    public static String lastTargetId=null;
    public static JLabel lblAreaRectangle = new JLabel("RectangleArea_Num");
    public static JLabel lblAreaGridInfo = new JLabel("GridArea_Info");
    public static JTable tableConfigPrivacyMask;
    public static JTable tableConfigBasicInformation = new JTable();
    public static JButton jButtonBasicGetSystemTime = new JButton("Get");
    public static JButton jButtonBasicSetSystemTime = new JButton("Set");
    public static JButton jButtonConfigGetDeviceName = new JButton("Get");
    public static JButton jButtonGetSummerTime = new JButton("Get");
    public static JButton jButtonGetConfigNetWorkNet = new JButton("Get");
    public static JButton jButtonGetSnapshot = new JButton("Get");
    public static JButton jButtonGetPrivacyMask = new JButton("Get");
    public static JButton jButtonModifyRectangleArea = new JButton("Modify");
    public static JButton jButtonModifyMacroArea = new JButton("Modify");
    public static JButton jButtonGetSmartServer = new JButton("Get");
    public static JButton btnNewButton_2;
    public static JButton btnNewButton_3;
    public static JButton btnNewButton_4;
    
    public static JRadioButton jRadioButtonOpenSVC ;
    public static JRadioButton jRadioButtonCloseSVC;
    public static Vector<String> headerNames=new Vector<>();
    public static JComboBox<Object> jComboBoxConfigNetWorkNTPIPType = new JComboBox<>();
    public static JComboBox<String> jComboBoxBasicTimeZone = new JComboBox<>();
    public static JComboBox<Object> jComboBoxNetworkPortHTTP = new JComboBox<>();
    public static JComboBox<Object> jComboBoxNetworkPortHTTPS = new JComboBox<>();
    public static JComboBox<Object> jComboBoxNetworkPortRTSP = new JComboBox<>();
    public static JComboBox<String> jComboBoxFocusModeConfig = new JComboBox<>();
    public static JComboBox<String> jComboBoxIRcutMode = new JComboBox<>();
    public static JComboBox<String> jComboBoxExposureMode = new JComboBox<>();
    public static JComboBox<String> jComboBoxMinShutter = new JComboBox<>();
    public static JComboBox<String> jComboBoxMaxShutter = new JComboBox<>();
    public static JComboBox<String> jComboBoxShutter = new JComboBox<>();
    public static JComboBox<String> jComboBoxDayNightMode = new JComboBox<>();
    public static JComboBox<String> jComboBoxExposureWDR = new JComboBox<>();
    public static JComboBox<String> jComboBoxWhiteBalance = new JComboBox<>();
    public static JComboBox<Object> jComboBoxConfigOSDTime1 = new JComboBox<Object>();
    public static JComboBox<Object> jComboBoxConfigOSDTim2 = new JComboBox<Object>();
    public static JComboBox<String> jComboBoxAlarmOutPutIndex = new JComboBox<String>();
    public static JComboBox<String> jComboBoxDefaultStatus = new JComboBox<>();
    public static JComboBox<String> jComboBoxAreaType = new JComboBox<String>();
    public static JComboBox<String> jComboBoxNetWorkMode = new JComboBox<>();
    public static JComboBox<String> jComboBoxUcode = new JComboBox<>(); 
    public static JComboBox<String> jComboBoxFontStyleAlign2;
    public static JComboBox<String> jComboBoxFontStyleAlign3;
    public static JComboBox<String> jComboBoxFontStyleAlign4;
    public static JComboBox<String> jComboBoxFontStyleAlign5;
    public static JComboBox<String> jComboBoxFontStyleAlign6;
    public static JComboBox<String> jComboBoxFontStyleAlign7;
    public static JComboBox<String> jComboBoxFontStyleAlign8;
    public static JComboBox<String> jComboBoxFontStyleAlign9;
    public static JComboBox<String> jComboBoxSmoothLevel;
    public static JComboBox<String> jComboBoxMainStreamType;
    public static JComboBox<String> jComboBoxIPtypeList = new JComboBox<String>();
    public static JComboBox<String> comboBox = new JComboBox<>();
    public static JComboBox<String> comboBox_1 = new JComboBox<>();
    public static JCheckBox jCheckBoxIsEnableSlowSh = new JCheckBox("EnableSlowShutter");
    public static JCheckBox chckbxConfigNetWorkNTPEnable = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDTime = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDName = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText1 = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText2 = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText3 = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText4 = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText5 = new JCheckBox("Enable");
    public static JCheckBox chckbxConfigOSDText6 = new JCheckBox("Enable"); 
    public static JCheckBox chckbxConfigNetWorkDHCPEnable = new JCheckBox("Enable");
    public static JCheckBox chckbxEnableGetPicture = new JCheckBox("Enable");
    public static NETDEV_DATA_SERVER_LIST serverList;
    public static ComboBoxTable SmartServerTable = new ComboBoxTable();
    public static JTextField jTextFieldNetworkPortHTTP = new JTextField();;
    public static JTextField jTextFieldNetworkPortHTTPS = new JTextField();
    public static JTextField jTextFieldUpdateChangeDeviceIpGateWay = new JTextField();
    public static JTextField jTextFieldNetworkPortRTSP = new JTextField();
    public static JTextField jTextFieldUpdateUserName = new JTextField();
    public static JTextField jTextFieldUpdateChangeDeviceIpMask = new JTextField();
    public static JTextField jTextFieldModifyDeviceIpv4Address = new JTextField();
    public static JTextField jTextFieldGetSDKVersion = new JTextField();
    public static JTextField jTextFieldConfigImageExposureSlowestShutter = new JTextField();
    public static JTextField jTextFieldConfigImageExposureDayNightSwitch = new JTextField();
    public static JTextField jTextFieldConfigImageExposureDayNightSence = new JTextField();
    public static JTextField jTextFieldFieldConfigImageExposureWDRLevel = new JTextField();
    public static JTextField textFieldConfigImageExposureGain;
    public static JTextField textFieldConfigImageExposureCompensation;
    public static JTextField textFieldConfigImageExposureMinGain;
    public static JTextField textFieldConfigImageExposureIsEnableSlowSh;
    public static JTextField textFieldConfigImageExposureMaxGain;
    public static JTextField textFieldConfigOSDTimeX;
    public static JTextField textFieldConfigOSDName;
    public static JTextField textFieldConfigOSDText1;
    public static JTextField textFieldConfigOSDText2;
    public static JTextField textFieldConfigOSDText3;
    public static JTextField textFieldConfigOSDText4;
    public static JTextField textFieldConfigOSDText5;
    public static JTextField textFieldConfigOSDText6;
    public static JTextField textFieldConfigOSDNameX;
    public static JTextField textFieldConfigOSDText1X;
    public static JTextField textFieldConfigOSDText2X;
    public static JTextField textFieldConfigOSDText3X;
    public static JTextField textFieldConfigOSDText4X;
    public static JTextField textFieldConfigOSDText5X;
    public static JTextField textFieldConfigOSDText6X;
    public static JTextField textFieldConfigOSDTimeY;
    public static JTextField textFieldConfigOSDNameY;
    public static JTextField textFieldConfigOSDText1Y;
    public static JTextField textFieldConfigOSDText2Y;
    public static JTextField textFieldConfigOSDText3Y;
    public static JTextField textFieldConfigOSDText4Y;
    public static JTextField textFieldConfigOSDText5Y;
    public static JTextField textFieldConfigOSDText6Y;
    public static JTextField textFieldImageInfo3DNoiseReduce;
    public static JPasswordField textFieldUpdatePassword;
    public static CheckTableModle SmartServertableModel = new CheckTableModle(null,headerNames);
    public static JCheckBox chckbxBViedeoenable = new JCheckBox("Enable");
    public static JPanel j = new JPanel();
    public static JPanel j2 = new JPanel();
    public static DateChooser Begindate = new DateChooser(j);
    public static DateChooser Enddate = new DateChooser(j2);
    public static String getLastYearString;
    public static JTextField textVpnAddress = new JTextField();
    public static JTextField textVpnPort = new JTextField();
    public static JComboBox<Object> comboBoxlblConfigIOAlarmOutputStatus = new JComboBox<Object>();
    public static JComboBox<String> comboBoxFontStyle = new JComboBox<String>();
    public static JComboBox<String> comboBoxFontStyleSize = new JComboBox<String>();
    public static JComboBox<String> comboBoxFontStyleAlign = new JComboBox<String>();
    public static JComboBox<String> comboBoxDateFormatStyle = new JComboBox<String>();
    public static JComboBox<String> comboBoxFontMargin = new JComboBox<String>();
    public static JComboBox<String> comboBoxTimeFormat = new JComboBox<String>();
    public static JCheckBox chckbxEnableSummerTime = new JCheckBox("enable");
    public static JComboBox<String> comboBoxDstBeginMonth = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTENDMonth = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTBeginTimeWeek = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTEndTimeWeek = new JComboBox<String>();
    public static JComboBox<String> comboBoxBeginTimeWeekNum = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTBeginTimeHour = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTEndTimeHour = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTBias = new JComboBox<String>();
    public static JComboBox<String> comboBoxDSTEndTimeWeekNum= new JComboBox<String>();
    public static JComboBox<Integer> comboBoxCardListSzName;
    public static JTextField textListCardOneMtuLength = new JTextField();
    public static JTextField textCardListOneMac = new JTextField();
    public static JTextField textIPv4Address = new JTextField();
    public static JTextField textCardListOneGateWay = new JTextField();
    public static JTextField textCardListOneNetMask = new JTextField();
    public static JTextField textBasicNetWorkPortHttp = new JTextField();
    public static JTextField textBasicNetWorkPortHttps = new JTextField();
    public static JTextField textBasicNetWorkPortRtsp = new JTextField();
    public static JTextField textRedOffSet = new JTextField();
    public static JTextField textBlueOffSet = new JTextField();
    public static JSlider RedoffSetslider = new JSlider();
    public static JSlider BlueoffSetslider = new JSlider();
    public static JTextField textPreferredAddress = new JTextField();
    public static JTextField textAlternate = new JTextField();
    public static JCheckBox chckbxConfigTamperChannelEnable = new JCheckBox("Enable");
    static Map<String, NETDEV_PERSON_INFO_S> mapPersonInfo2 = new HashMap<String, NETDEV_PERSON_INFO_S>();
    static Map<Integer, NETDEV_LIB_INFO_S> mapVehicleLib2 = new HashMap<Integer, NETDEV_LIB_INFO_S>();
    public static final int NETDEMO_FIND_ACS_PERSON_COUNT = 10;
    static Map<Integer,NETDEV_ORG_INFO_S> ACPersonDeptMap = new HashMap<Integer,NETDEV_ORG_INFO_S>();
    static Map<Integer, NETDEV_ACS_PERSON_BASE_INFO_S> mapACPersonInfo = new HashMap<Integer, NETDEV_ACS_PERSON_BASE_INFO_S>();
    public static String strPersonChosePicurePath;
    public static JTextField textFieldBasicTime;
    public static JTextField textFieldConfigDeviceName;
    public static JTextField textFieldConfigNetWorkIPAddr;
    public static JTextField textFieldConfigNetWorkSubMask;
    public static JTextField textFieldConfigNetWorkGateway;
    public static JTextField textFieldConfigNetWorkMTU;
    public static JTextField textFieldConfigNetWorkNTPServerIP;
    public static JTextField textFieldConfigNetWorkNTPDomainName;
    public static JTextField textFieldConfigNetWorkNTPPort;
    public static JTextField textFieldConfigNetWorkNTPSynchronizeInterval;
    public static JTextField textFieldConfigVideoStreamResolutionWidth;
    public static JTextField textFieldConfigVideoStreamResolutionHigth;
    public static JTextField textFieldConfigVideoStreamBitRate;
    public static JTextField textFieldConfigVideoStreamFrameRate;
    public static JTextField textFieldConfigVideoStreamIFremeInterval;
    public static JTextField textFieldConfigImageInfoBrightness;
    public static JTextField textFieldConfigImageInfoSaturation;
    public static JTextField textFieldConfigImageInfoContrast;
    public static JTextField textFieldConfigImageInfoSharpness;
    public static JTextField textFieldImageInfo2DNoiseReduce = new JTextField();
    public static JTextField textFieldConfigTemperEquipmentSensitivity;
    public static JTextField textFieldConfigTemperChannelSensitivity;
    public static JTextField textFieldConfigTemperChannelDuration;
    public static JTextField textFieldConfigEquipmentMotionHistory;
    public static JTextField textFieldlblConfigIOAlarmOutputName;
    public static JTextField textFieldConfigIOAlarmOutputChannelID;
    public static JTextField textFieldlblConfigIOAlarmOutputDelay;
    public static JTextField textFieldConfigIOAlarmOutputChannelNo;
    public static JTextField textFieldConfigIOAlarmOutputChannelDelay;
    public static JTextField textFieldConfigIOAlarmOutputIndex;
    public static JTable AccessControlPersonTable;
    public static JTextField textFieldConfigChannelMotionRectangleAreaNum;
    public static JTextField textFieldSnapshotWidth;
    public static JTextField textFieldSnapshotHeight;
    public static JTextField textFieldPictureMaxSize;
    public static JTextField textFieldSnapshotInterval;
    public static JTextField textFieldSnapshotNum;
    public static JTextField textFieldSetBasicSystemTime;
    public static JTextField textFieldNetWorkCardName;
    public static JTextField textFieldNetWorkCardMode;
    public static JTextField textField_BeginTime;
    public static JTextField textField_EndTime;
    public static JTextField textField_Total;
    public static JTextField textField_Remain;
    public static JTextField textField_AlarmTotal;
    public static JTextField textField_AlarmRemain;
    
    /* Declaration of the Maintenance variable*/
    public static JTextField jTextFieldMaintenanceManualConfigurationImport;
    
    /* Declaration of the User variable */
    public static String changeName=null;
    public static JTable jTableUserList;
    public static JButton jButtonUserListGetUserList;
    public static JTextField jTextFieldAddUserUserName;
    public static JTextField jTextFieldModifyUserUserName;
    public static JPasswordField jTextFieldlAddUserPasswd;   
    public static JPasswordField jTextFieldModifyUserOldPassword;
    public static JPasswordField jTextFieldlblModifyUserNewPasswd;
    public static JComboBox<Object> jComboBoxAddUserUserType = new JComboBox<Object>();
    public static JComboBox<Object> jComboBoxModifyUserUserType = new JComboBox<Object>();  
    public static JTable ObjectSearchTable;
    public static JTable ObjectAlarmTable;
	
    public static int udwObjectSearchID = 0;
    public static int dwTime = -1;
    public static Pointer lpObjectSearchFindHandle = null;
    public static int udwObjectSearchTotalNum = 0;
    public static NETDEV_PIC_QUERY_COND_S gstQueryCond = new NETDEV_PIC_QUERY_COND_S();
    public static int dwAlarmSearchTime = -1;
    public static int dwAlarmSearchTotal = -1;
    public static int dwAlarmID		= -1;
    
    public static DefaultTableModel PersonMonitorTableModel = new DefaultTableModel(
            new Object[][] {
            },
            new String[] {
                "Mission name", "Description", "Status"
            }
        );
    
    public static DefaultTableModel PersonTableModel = new DefaultTableModel(
        new Object[][] {
        },
        new String[] {  
            "Person ID","Name", "Gender", "Birthday", "Nationality", "Province", "City", "ID type", "Id"
        }
    );
    
    public static DefaultTableModel VehicleMonitorTableModel = new DefaultTableModel(
        new Object[][] {
        },
        new String[] {
            "Name", "Description", "Alarm type", "Monitor type"
        }
    );
    
    public static DefaultTableModel PeopleCountingVMSNVRStatistalTableModel = new DefaultTableModel(
        new Object[][] {
        },
        new String[] {
            "ChannelID", "Time", "EnterNum", "ExitNum"
        }
    );
	
	public static DefaultTableModel DeviceTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"ChannelID", "Status", "Name"
			}
		);
	
	public static DefaultTableModel RecordByMonthTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Year","Month","Day", "Record Type"
			}
		);
	public static  DefaultTableModel RecordStatusTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"ChannelId", "Type", "Status"
			}
		);
	
	public static DefaultTableModel AlarmTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Time", "ChannelID", "Info"
			}
		);
	
	public static DefaultTableModel VehicleTableModle = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Plate number", "Plate color", "Plate type", "Car color", "Status"
			}
		);

	public static DefaultTableModel ConfigBasicHardDiskTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"No.", "Total Capacity(M)", "Used Capacity(M)", "Status", "Manufacture"
			}
		);
	
	
	public static DefaultTableModel ConfigBasicInformationTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"No.", "DevModel", "SerialNum", "MacAddress", "DeviceName","FirmwareVersion"
			}
		);
	
	public static DefaultTableModel ConfigPrivacyMaskTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"No.", "Left Top(x)", "Left Top(y)", "Right Bottom(x)", "Right Bottom(y)"
			}
		);
	
	public static  DefaultTableModel ConfigIOAlarmInputTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Alarm Name", "Alarm Type", "Alarm Input"
			}
		);
	
	static DefaultTableModel AccessControlPersonTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"ID", "Person ID", "Name", "Gender", "Department", "Card Type", "ID No."
			}
		);
	
	public static DefaultTableModel VCAPeopleCountingTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Channel ID", "Report Time", "Interval Time", "Enter Number", "Exit Number", "Total Enter Number", "Total Exit Number"
			}
		);
	public static DefaultTableModel PeopleCountingVMSNVRRealTimeTableModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"ChannelID", "EnterCount", "ExitCount"
			}
		);
	public static DefaultTableModel UserListTableModel = new DefaultTableModel(
			new Object[][] {
	        },
	        new String[] {
		        "No.", "User Name", "User Type"
	        }
        );

	public static DefaultTableModel tablePTZExtendPresetPatrolsModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Cruise Point", "Stay Time", "Speed"
			}
		);
	
	public static DefaultTableModel RecordTableModel= new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"Begin Time", "End Time", "File Name"
			}
		);
	
	public static DefaultTableModel ObjectSearchModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"RecordID", "RecordType", "Time", "ChannelName", "ChannelID"
			}
		);
	
	public static DefaultTableModel AlarmSearchModel = new DefaultTableModel(
			new Object[][] {
			},
			new String[] {
				"AlarmID", "AlarmType", "Time", "AlarmSrc", "ChannelID"
			}
		);


	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NetDemo window = new NetDemo();
					window.frame.setResizable(false);
					window.frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}	
		});
	}
	
	/**
	 * Create the application.
	 */
	public NetDemo() {
		initialize();
		init();
	}
	
	public void init() {
    	String strLogPath = "./sdklog/";
    	boolean bRet = netdevsdk.NETDEV_SetLogPath(strLogPath);
    	if(false == bRet){
    		System.out.printf("NETDEV_SetLogPath failed:%d", netdevsdk.NETDEV_GetLastError());
    	}

        bRet = netdevsdk.NETDEV_Init();
    	if(false == bRet){
    		System.out.printf("Initialize failed:%d", netdevsdk.NETDEV_GetLastError());
    		return;
    	}

        try {
            Common.updateStructureByReferenceMethod = Structure.class.getDeclaredMethod("updateStructureByReference", Class.class, Structure.class, Pointer.class);
            Common.updateStructureByReferenceMethod.setAccessible(true);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

		File file=new File(strPicturePath);
		if(!file.exists()){
			file.mkdir();
		}

    	return;
    }

	public static NETDEV_DISCOVERY_CALLBACK_PF cbDiscoveryCallBack = new NETDEV_DISCOVERY_CALLBACK_PF();
	public static class NETDEV_DISCOVERY_CALLBACK_PF  implements NetDEVSDKLib.NETDEV_DISCOVERY_CALLBACK_PF {
		@Override
		public void invoke(NETDEV_DISCOVERY_DEVINFO_S pstDevInfo, Pointer lpUserData){
			
			Vector<String> vector = new Vector<String>();
			vector.add(Common.DevideTypeToString((int)pstDevInfo.enDevType));
			vector.add(Common.utfToString(pstDevInfo.szDevAddr));
			vector.add(String.valueOf(pstDevInfo.dwDevPort));
			vector.add(Common.utfToString(pstDevInfo.szDevMac));
			vector.add(Common.utfToString(pstDevInfo.szDevSerailNum));
			vector.add(Common.utfToString(pstDevInfo.szManuFacturer));
			DiscoveryTableModel.insertRow(0,vector);	
			jButtonCheckSameDevice.doClick();
		}
    }

	public static NETDEV_SOURCE_DATA_CALLBACK_PF fPlayDataCallBack = new NETDEV_SOURCE_DATA_CALLBACK_PF();
	public static class NETDEV_SOURCE_DATA_CALLBACK_PF implements NetDEVSDKLib.NETDEV_SOURCE_DATA_CALLBACK_PF{
    	@Override
    	public void invoke(Pointer lpPlayHandle, Pointer pucBuffer, int dwBufSize, int dwMediaDataType, Pointer lpUserParam){
    		byte[] szDataBuf = pucBuffer.getByteArray(0, dwBufSize);

    		System.out.println(dwBufSize + ":" + Common.utfToString(szDataBuf));
    	}
    }

    public static NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF fDecodeAudioDataCallBack = new NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF();
    public static class NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF implements NetDEVSDKLib.NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF{
    	@Override
    	public void invoke(Pointer lpPlayHandle, NETDEV_WAVE_DATA_S pstWaveData, Pointer lpUserParam){
    		byte[] szDataBuf = pstWaveData.pcData.getByteArray(0, pstWaveData.dwDataLen);

    		System.out.println(pstWaveData.dwWaveFormat + ":" + Common.utfToString(szDataBuf));
    	}
    }

    public static NETDEV_DECODE_VIDEO_DATA_CALLBACK fPlayDecodeVideoCALLBACK = new NETDEV_DECODE_VIDEO_DATA_CALLBACK();
    public static class NETDEV_DECODE_VIDEO_DATA_CALLBACK implements NetDEVSDKLib.NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF{
		@Override
		public void invoke(Pointer lpPlayHandle, NETDEV_PICTURE_DATA_S pstPictureData, Pointer lpUserParam){
			System.out.println(pstPictureData.dwPicHeight + "," + pstPictureData.dwPicWidth + ":" + pstPictureData.dwLineSize[0]+":" + pstPictureData.dwLineSize[1]+":" + pstPictureData.dwLineSize[2]);

			if (0 == pstPictureData.dwPicHeight || 0 == pstPictureData.dwPicWidth)
		    {
		        return ;
		    }

			@SuppressWarnings("unused")
			byte[] szUBuf = pstPictureData.pucData[1].getByteArray(0,pstPictureData.dwLineSize[1]);
			@SuppressWarnings("unused")
			byte[] szVBuf = pstPictureData.pucData[2].getByteArray(0,pstPictureData.dwLineSize[2]);

			byte[] szDataBuf = new byte[pstPictureData.dwPicHeight * pstPictureData.dwPicWidth * 3 / 2];

		    int dwHeight = pstPictureData.dwPicHeight;
		    int dwWidth = pstPictureData.dwPicWidth;

		    int dwOffset = 0;
		    int dwIndex = 0;

		    for (dwIndex = 0; dwIndex < dwHeight; dwIndex++)
		    {
		    	byte[] szBuf = pstPictureData.pucData[0].getByteArray(dwIndex * pstPictureData.dwLineSize[0],dwWidth);
		    	for(int j=0; j<szBuf.length; j++)
		    	{
		    		szDataBuf[dwOffset+j] = szBuf[j];
		    	}
		        dwOffset += dwWidth;
		    }

		    for (dwIndex = 0; dwIndex < dwHeight / 2; dwIndex++)
		    {
		    	byte[] szBuf = pstPictureData.pucData[1].getByteArray(dwIndex * pstPictureData.dwLineSize[1],dwWidth / 2);
		    	for(int j=0; j<dwWidth / 2; j++)
		    	{
		    		szDataBuf[dwOffset+j] = szBuf[j];
		    	}
		        dwOffset += dwWidth / 2;
		    }

		    for (dwIndex = 0; dwIndex < dwHeight / 2; dwIndex++)
		    {
		    	byte[] szBuf = pstPictureData.pucData[2].getByteArray(dwIndex * pstPictureData.dwLineSize[2],dwWidth / 2);
		    	for(int j=0; j<dwWidth / 2; j++)
		    	{
		    		szDataBuf[dwOffset+j] = szBuf[j];
		    	}
		        dwOffset += dwWidth / 2;
		    }


		    FileOutputStream fop = null;
		    File file;
		    try {
		    	file = new File("./videofile.yuv");
		    	fop = new FileOutputStream(file);
		    	if (!file.exists()) {
		    	    file.createNewFile();
		    	}
		    	fop.write(szDataBuf);
		    	fop.flush();
		    	fop.close();

		    	System.out.println("write Done");
			} catch (IOException e2) {
				e2.printStackTrace();
			}
		}
    }

    public static NETDEV_FaceSnapshotCallBack_PF cbFaceSnapshotCallBack = new NETDEV_FaceSnapshotCallBack_PF();
    public static class NETDEV_FaceSnapshotCallBack_PF implements NetDEVSDKLib.NETDEV_FaceSnapshotCallBack_PF{
		@Override
		public void invoke(Pointer lpPlayHandle, NETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S pstFaceSnapShotData, Pointer lpUserParam){
			System.out.println(pstFaceSnapShotData.udwPicBuffLen);

			byte[] szDataBuf = new byte[pstFaceSnapShotData.udwPicBuffLen];
			szDataBuf = pstFaceSnapShotData.pcPicBuff.getByteArray(0, pstFaceSnapShotData.udwPicBuffLen);

		    FileOutputStream fop = null;
		    File file;
		    try {
		    	file = new File("./face.jpg");
		    	fop = new FileOutputStream(file);
		    	if (!file.exists()) {
		    	    file.createNewFile();
		    	}
		    	fop.write(szDataBuf);
		    	fop.flush();
		    	fop.close();

		    	System.out.println("write Done");
			} catch (IOException e2) {
				e2.printStackTrace();
			}
		}
    }

    public static NETDEV_CarPlateCallBack_PF cbCarPlateCallBack = new NETDEV_CarPlateCallBack_PF();
    public static class NETDEV_CarPlateCallBack_PF implements NetDEVSDKLib.NETDEV_CarPlateCallBack_PF{
		@Override
		public void invoke(Pointer lpPlayHandle, NETDEV_TMS_CAR_PLATE_INFO_S pstCarPlateData, Pointer lpUserParam){
			System.out.println("PicNum:" + pstCarPlateData.udwPicNum);

			for(int i=0; i<pstCarPlateData.udwPicNum; i++){
				byte[] szDataBuf = new byte[pstCarPlateData.stTmsPicInfo[0].udwPicSize];
				szDataBuf = pstCarPlateData.stTmsPicInfo[0].pcPicData.getByteArray(0, pstCarPlateData.stTmsPicInfo[0].udwPicSize);

			    FileOutputStream fop = null;
			    File file;
			    String strPath = "./" +  Integer.toString(i) + "Car.jpg";
			    try {
			    	file = new File(strPath);
			    	fop = new FileOutputStream(file);
			    	if (!file.exists()) {
			    	    file.createNewFile();
			    	}
			    	fop.write(szDataBuf);
			    	fop.flush();
			    	fop.close();

			    	System.out.println("write Done");
				} catch (IOException e2) {
					e2.printStackTrace();
				}
			}
		}

    }

    public static NETDEV_PassengerFlowStatisticCallBack_PF cbPassengerFlowStatisticCallBack = new NETDEV_PassengerFlowStatisticCallBack_PF();
    public static class NETDEV_PassengerFlowStatisticCallBack_PF implements NetDEVSDKLib.NETDEV_PassengerFlowStatisticCallBack_PF{
		@Override
		public void invoke(Pointer lpPlayHandle, NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S pstPassengerFlowData, Pointer lpUserParam){
			String strTime = Common.timeStamp2Date(Long.toString(pstPassengerFlowData.tReportTime), DateFormat);
			System.out.println(strTime + ":" + pstPassengerFlowData.dwTotalExitNum+ "," + pstPassengerFlowData.dwTotalEnterNum);
			Vector<String> PassengerFlowStatisticVector = new Vector<String>();
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.dwChannelID));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.tReportTime));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.tInterval));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.dwEnterNum));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.dwExitNum));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.dwTotalEnterNum));
			PassengerFlowStatisticVector.add(String.valueOf(pstPassengerFlowData.dwTotalExitNum));

			VCAPeopleCountingTableModel.addRow(PassengerFlowStatisticVector);

		}
    }
    
    public static NETDEV_ExceptionCallBack_PF cbExceptionCallBack =new NETDEV_ExceptionCallBack_PF();
    public static class NETDEV_ExceptionCallBack_PF implements NetDEVSDKLib.NETDEV_ExceptionCallBack_PF{

		@Override
		public void invoke(Pointer lpUserID, int dwType, Pointer lpExpHandle, Pointer lpUserData,
				NETDEV_EXCEPTION_OUTPUT_INFO_S pstExceptionOutputInfo) {	
		}
    }
    
    public static  NETDEV_AlarmMessCallBack_PF_V30 cbAlarmMessCallBack = new NETDEV_AlarmMessCallBack_PF_V30();
    private JTabbedPane tabSmartList;
    public static class NETDEV_AlarmMessCallBack_PF_V30 implements NetDEVSDKLib.NETDEV_AlarmMessCallBack_PF_V30{
		@Override
		public void invoke(Pointer lpUserID, NETDEV_REPORT_INFO_S pstReportInfo, Pointer lpBuf, int dwBufLen,
				Pointer lpUserParam) {
			if (NETDEV_REPORT_TYPE_E.NETDEV_REPORT_TYPE_ALARM == pstReportInfo.dwReportType) {
				String strTime = Common.timeStamp2Date(Long.toString(pstReportInfo.stAlarmInfo.tAlarmTimeStamp),DateFormat);

				Vector<String> vector = new Vector<String>();
				vector.add(strTime);
				String ChannelInfo = Integer.toString(pstReportInfo.stAlarmInfo.dwChannelID);
				String AlarmSrc = Common.utfToString(pstReportInfo.stAlarmInfo.szAlarmSrc);
				if (!AlarmSrc.isEmpty()) {
					ChannelInfo += "(";
					ChannelInfo += AlarmSrc;
					ChannelInfo += ")";
				}
				vector.add(ChannelInfo);
				vector.add(Common.AlarmTypeToString(pstReportInfo.stAlarmInfo.dwAlarmType));
				AlarmTableModel.insertRow(0, vector);
				System.out.println(pstReportInfo.stAlarmInfo.dwAlarmID + ":" + pstReportInfo.stAlarmInfo.dwChannelID
						+ ":" + pstReportInfo.stAlarmInfo.dwAlarmLevel);
			}
			else{
				Vector<String> vector = new Vector<String>();
				vector.add("");
				vector.add("");
				vector.add("event_info");
				AlarmTableModel.insertRow(0, vector);
			}
		}
    }

    public static NETDEV_StructAlarmMessCallBack_PF cbStructAlarmCallBack = new NETDEV_StructAlarmMessCallBack_PF();
    private static class NETDEV_StructAlarmMessCallBack_PF implements NetDEVSDKLib.NETDEV_StructAlarmMessCallBack_PF
    {

		@Override
		public void invoke(Pointer lpUserID, NETDEV_STRUCT_ALARM_INFO_S pstAlarmInfo,
				NETDEV_STRUCT_DATA_INFO_S pstAlarmData, Pointer lpUserData) {
			// TODO Auto-generated method stub
			System.out.println("NETDEV_StructAlarmMessCallBack_PF, UseId is:"+ lpUserID);

			String strTime = Common.getDate();
			NETDEV_STRUCT_IMAGE_INFO_S[] pstImageInfo = Common.pointerToStructureArray(pstAlarmData.udwImageNum, pstAlarmData.pstImageInfo, NETDEV_STRUCT_IMAGE_INFO_S.class);

			//人脸信息
			if(null != pstAlarmData.stObjectInfo.pstFaceInfo && 0 <pstAlarmData.stObjectInfo.udwFaceNum && null != pstAlarmData.pstImageInfo && 0 < pstAlarmData.udwImageNum)
			{
				NETDEV_FACE_STRUCT_INFO_S[] pstFaceInfo = Common.pointerToStructureArray(pstAlarmData.stObjectInfo.udwFaceNum, pstAlarmData.stObjectInfo.pstFaceInfo, NETDEV_FACE_STRUCT_INFO_S.class);
				for(int i = 0; i < pstAlarmData.stObjectInfo.udwFaceNum; i++)
				{
					for(int j = 0;j < pstAlarmData.udwImageNum; j++)
					{
						 if(pstFaceInfo[i].udwLargePicAttachIndex == pstImageInfo[j].udwIndex)
						 {
							 String strFileName = strPicturePath + strTime + "Face_large.jpg";
							 String iCmpRet = Common.byteArrayToString(pstImageInfo[j].szUrl);
							 if(!iCmpRet.equals(""))
							 {
								 Pointer pszUrl = new Memory(260);
								 pszUrl.write(0, pstImageInfo[j].szUrl, 0, 260);
								 Pointer pszData = new Memory(pstImageInfo[j].udwSize);
								 netdevsdk.NETDEV_GetSystemPicture(lpUserID, pszUrl, pstImageInfo[j].udwSize, pszData);
								 
								 Common.savePicture(pszData, pstImageInfo[j].udwSize, strFileName);
							 }
							 else
							 {
								 Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							 }
							 continue;
						 }
						else if(pstFaceInfo[i].udwSmallPicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime + "Face_small.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
					}
				}
			}

			//人员信息
			if(null != pstAlarmData.stObjectInfo.pstPersonInfo && 0 <pstAlarmData.stObjectInfo.udwPersonNum &&  null != pstAlarmData.pstImageInfo && 0 < pstAlarmData.udwImageNum)
			{
				NETDEV_PERSON_STRUCT_INFO_S[] pstPersonInfo = Common.pointerToStructureArray(pstAlarmData.stObjectInfo.udwPersonNum, pstAlarmData.stObjectInfo.pstPersonInfo, NETDEV_PERSON_STRUCT_INFO_S.class);
				for(int i = 0; i < pstAlarmData.stObjectInfo.udwPersonNum; i++)
				{
					for(int j = 0;j < pstAlarmData.udwImageNum; j++)
					{
						if(pstPersonInfo[i].udwLargePicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_Person_Big.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
						else if(pstPersonInfo[i].udwSmallPicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_Person_Small.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
					}

				}
			}

			//非机动车信息
			if(null != pstAlarmData.stObjectInfo.pstNonMotorVehInfo && 0 <pstAlarmData.stObjectInfo.udwNonMotorVehNum &&  null != pstAlarmData.pstImageInfo && 0 < pstAlarmData.udwImageNum)
			{
				NETDEV_NON_MOTOR_VEH_INFO_S[] pstNonMotorVehInfo = Common.pointerToStructureArray(pstAlarmData.stObjectInfo.udwNonMotorVehNum, pstAlarmData.stObjectInfo.pstNonMotorVehInfo, NETDEV_NON_MOTOR_VEH_INFO_S.class);
				for(int i = 0; i < pstAlarmData.stObjectInfo.udwNonMotorVehNum; i++)
				{
					for(int j = 0;j < pstAlarmData.udwImageNum; j++)
					{
						if(pstNonMotorVehInfo[i].udwLargePicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_NonMotorVeh_Big.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
						else if(pstNonMotorVehInfo[i].udwSmallPicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_NonMotorVeh_Small.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
					}
				}

			}

			//车辆信息
			if(null != pstAlarmData.stObjectInfo.pstVehInfo && 0 <pstAlarmData.stObjectInfo.udwVehicleNum &&  null != pstAlarmData.pstImageInfo && 0 < pstAlarmData.udwImageNum)
			{
				NETDEV_VEH_INFO_S[] pstVehInfo = Common.pointerToStructureArray(pstAlarmData.stObjectInfo.udwVehicleNum, pstAlarmData.stObjectInfo.pstVehInfo, NETDEV_VEH_INFO_S.class);
				for(int i = 0; i < pstAlarmData.stObjectInfo.udwVehicleNum; i++)
				{
					for(int j = 0;j < pstAlarmData.udwImageNum; j++)
					{
						if(pstVehInfo[i].udwLargePicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_MotorVeh_Big.jpg";
							if(0 == pstImageInfo[j].szUrl.toString().compareTo(""))
							{
								Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
								continue;
							}
							else
							{
								 Pointer pszUrl = new Memory(260);
								 pszUrl.write(0, pstImageInfo[j].szUrl, 0, 260);
								 Pointer pszData = new Memory(pstImageInfo[j].udwSize);
								 netdevsdk.NETDEV_GetSystemPicture(lpUserID, pszUrl, pstImageInfo[j].udwSize, pszData);
								 Common.savePicture(pszData, pstImageInfo[j].udwSize, strFileName);
							}

						}
						else if(pstVehInfo[i].udwSmallPicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_MotorVeh_Small.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
						else if(pstVehInfo[i].udwPlatePicAttachIndex == pstImageInfo[j].udwIndex)
						{
							String strFileName = strPicturePath + strTime +"Struct_Plate_Small.jpg";
							Common.savePicture(pstImageInfo[j].pszData, pstImageInfo[j].udwSize, strFileName);
							continue;
						}
					}
				}
			}

		}
	}

    public static NETDEV_PersonAlarmMessCallBack_PF personAlarmMessCB =new NETDEV_PersonAlarmMessCallBack_PF();
    public static class NETDEV_PersonAlarmMessCallBack_PF implements NetDEVSDKLib.NETDEV_PersonAlarmMessCallBack_PF
    {

		@Override
		public void invoke(Pointer lpUserID, NETDEV_PERSON_EVENT_INFO_S pstAlarmData, Pointer lpUserData) {
			// TODO Auto-generated method stub
			String strTime = Common.getDate();
			System.out.println("Person AlarmTime:"+ pstAlarmData.udwTimestamp);
			for(int i = 0; i < pstAlarmData.udwFaceInfoNum; i++)
			{
				System.out.println("Person udwSimilarity:"+ pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.udwSimilarity);

				//布控的图片
				if(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPersonInfo.udwImageNum > 0)
				{
					String strFileName = strPicturePath + strTime +"bukong.jpg";
					Common.savePicture(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPersonInfo.stImageInfo[0].stFileInfo.pcData, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPersonInfo.stImageInfo[0].stFileInfo.udwSize, strFileName);
				}

				// 大图，一体机获取的方法，ipc/NVR直接写数据 */
				{
					if(jComboBoxDeviceType.getSelectedIndex() == 1)
					{
						String strFileName = strPicturePath + strTime +"Person_Big.jpg";
						String iCmRet = Common.byteArrayToString(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.szUrl);
						if(!iCmRet.equals(""))
						{
							 Pointer pszUrl = new Memory(260);
							 pszUrl.write(0, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.szUrl, 0, 260);
							 Pointer pszData = new Memory(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.udwSize);
							 netdevsdk.NETDEV_GetSystemPicture(lpUserID, pszUrl, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.udwSize, pszData);

							 Common.savePicture(pszData, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.udwSize, strFileName);
						}
						else
						{
							Common.savePicture(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.pcData, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stPanoImage.udwSize, strFileName);
						}
					}
				}

				//小图
				{
					String strFileName = strPicturePath + strTime +"Person_Small.jpg";
					Common.savePicture(pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stFaceImage.pcData, pstAlarmData.stCtrlFaceInfo[i].stCompareInfo.stFaceImage.udwSize, strFileName);
				}
			}
		}
    }

    public Vector<Vector<Object>> initTable() {
		Vector<Vector<Object>> data = new Vector<>();
        Vector<Object> rowVector1=new Vector<>();
        rowVector1.add(false);
        rowVector1.add("RULE");

        Vector<Object> rowVector2=new Vector<>();
        rowVector2.add(false);
        rowVector2.add("TOUTH_RULE");

        Vector<Object> rowVector3=new Vector<>();
        rowVector3.add(false);
        rowVector3.add("UNTOUTH_RULE");

        Vector<Object> rowVector4=new Vector<>();
        rowVector4.add(false);
        rowVector4.add("TRACK");
        data.add(rowVector1);
        data.add(rowVector2);
        data.add(rowVector3);
        data.add(rowVector4);
		return data;
    }

    public static class NETDEV_VehicleAlarmMessCallBack_PF implements NetDEVSDKLib.NETDEV_VehicleAlarmMessCallBack_PF
    {
		@Override
		public void invoke(Pointer lpUserID, NETDEV_VEH_RECOGNITION_EVENT_S pstVehicleAlarmInfo, Pointer lpBuf,
				int dwBufLen, Pointer lpUserData) {
			// TODO Auto-generated method stub
			System.out.println("NETDEV_VehicleAlarmMessCallBack_PF");
			String strTime = Common.getDate();
			NETDEV_VEHICLE_RECORD_INFO_S[] pstVehicleRecordInfo = Common.pointerToStructureArray(pstVehicleAlarmInfo.stVehicleEventInfo.udwVehicleInfoNum, pstVehicleAlarmInfo.stVehicleEventInfo.pstVehicleRecordInfo, NETDEV_VEHICLE_RECORD_INFO_S.class);
			for(int i = 0; i < pstVehicleAlarmInfo.stVehicleEventInfo.udwVehicleInfoNum; i++)
			{
	            /* 车牌抓拍图片 */
	            {
	                if(pstVehicleRecordInfo[i].stPlateImage.pcData != null)
	                {
	                	String strFileName = strPicturePath + strTime +"Plate.jpg";
	                	Common.savePicture(pstVehicleRecordInfo[i].stPlateImage.pcData, pstVehicleRecordInfo[i].stPlateImage.udwSize, strFileName);
	                }
	            }

	            /* 车辆抓拍图片 */
	            {
	                if(pstVehicleRecordInfo[i].stVehicleImage.pcData != null)
	                {
	                	String strFileName = strPicturePath + strTime +"Vehicle.jpg";
	                	Common.savePicture(pstVehicleRecordInfo[i].stVehicleImage.pcData, pstVehicleRecordInfo[i].stVehicleImage.udwSize, strFileName);
	                }
	            }

	            /* 全景图 */
	            {
	            	NETDEV_FILE_INFO_S stFileInfo = new NETDEV_FILE_INFO_S();
	                stFileInfo.udwSize = 1048576;
	                stFileInfo.pcData = new Memory(stFileInfo.udwSize);
	                boolean iRet= netdevsdk.NETDEV_GetVehicleRecordImageInfo(lpUserID, pstVehicleRecordInfo[i].udwRecordID, stFileInfo);
	                if(iRet == true)
	                {
		            	String strFileName = strPicturePath + strTime +"VehiclePanoImage.jpg";
		            	Common.savePicture(stFileInfo.pcData, stFileInfo.udwSize, strFileName);
	                }
	            }
			}
		}
    }

    public static class NETDEV_AlarmMessFGCallBack_PF implements NetDEVSDKLib.NETDEV_AlarmMessFGCallBack_PF
    {
		@Override
		public void invoke(Pointer lpUserID, NETDEV_PERSON_VERIFICATION_S pstAlarmData, Pointer lpUserData) {
			// TODO Auto-generated method stub
			System.out.println("NETDEV_AlarmMessFGCallBack_PF");

			/* 人脸信息 */
			NETDEV_CTRL_FACE_INFO_S[] pstFaceInfo = Common.pointerToStructureArray(pstAlarmData.udwFaceInfoNum, pstAlarmData.pstCtrlFaceInfo, NETDEV_CTRL_FACE_INFO_S.class);
			for(int i = 0; i < pstAlarmData.udwFaceInfoNum; i++)
		    {
				NETDEV_FEATURE_INFO_S[] pstFeatureInfo = Common.pointerToStructureArray(pstFaceInfo[i].udwFeatureNum, pstFaceInfo[i].pstFeatureInfo, NETDEV_FEATURE_INFO_S.class);
				for(int j = 0; j < pstFaceInfo[i].udwFeatureNum; j++)
			    {
					 System.out.println("FeatureVersion:" + pstFeatureInfo[j].szFeatureVersion + " Feature:" + pstFeatureInfo[j].szFeature);
			    }

				if(pstFaceInfo[i].stPanoImage.pcData != null && pstFaceInfo[i].stPanoImage.udwSize > 0)
				{
					String strFileName = strPicturePath + pstFaceInfo[i].udwTimestamp + "_" + pstFaceInfo[i].udwID + "_Pano.jpg";
					Common.savePicture(pstFaceInfo[i].stPanoImage.pcData, pstFaceInfo[i].stPanoImage.udwSize, strFileName);

					System.out.println(strFileName);
				}
				if(pstFaceInfo[i].stFaceImage.pcData != null && pstFaceInfo[i].stFaceImage.udwSize > 0)
				{
					String strFileName = strPicturePath + pstFaceInfo[i].udwTimestamp + "_" + pstFaceInfo[i].udwID + "_face.jpg";
					Common.savePicture(pstFaceInfo[i].stFaceImage.pcData, pstFaceInfo[i].stFaceImage.udwSize, strFileName);
					System.out.println(strFileName);
				}
		    }

			/* 卡信息 */
			NETDEV_CTRL_CARD_INFO_S[] pstCardInfo = Common.pointerToStructureArray(pstAlarmData.udwCardInfoNum, pstAlarmData.pstCtrlCardInfo, NETDEV_CTRL_CARD_INFO_S.class);

			for(int i = 0; i < pstAlarmData.udwCardInfoNum; i++)
		    {

				System.out.println("cardInfo:" + pstCardInfo[i].udwTimestamp + pstCardInfo[i].udwID + "_" + pstCardInfo[i].udwCardType);
				if(pstCardInfo[i].stIDImage.pcData != null && pstCardInfo[i].stIDImage.udwSize > 0)
				{
					String strFileName = strPicturePath + pstCardInfo[i].udwTimestamp + "_" + pstCardInfo[i].udwID + "_Card.jpg";
					Common.savePicture(pstCardInfo[i].stIDImage.pcData, pstCardInfo[i].stIDImage.udwSize, strFileName);

					System.out.println(strFileName);
				}
		    }

			/* 闸机信息 */
			NETDEV_CTRL_GATE_INFO_S[] pstGateInfo = Common.pointerToStructureArray(pstAlarmData.udwGateInfoNum, pstAlarmData.pstCtrlGateInfo, NETDEV_CTRL_GATE_INFO_S.class);

			for(int i = 0; i < pstAlarmData.udwGateInfoNum; i++)
		    {
				String strTime = Common.timeStamp2Date(String.valueOf(pstGateInfo[i].udwTimestamp), null);
				System.out.println("GateInfo:" + strTime + pstGateInfo[i].udwID + "_" + pstGateInfo[i].udwInPersonCnt + "_" + pstGateInfo[i].udwOutPersonCnt);
		    }

			/* 库比对信息 */
			NETDEV_CTRL_LIB_MATCH_INFO_S[] pstLibMatchInfo = Common.pointerToStructureArray(pstAlarmData.udwLibMatInfoNum, pstAlarmData.pstLibMatchInfo, NETDEV_CTRL_LIB_MATCH_INFO_S.class);

			for(int i = 0; i < pstAlarmData.udwLibMatInfoNum; i++)
		    {
				System.out.println("LibMatchInfo: udwID:" + pstLibMatchInfo[i].udwID + "_LibID:" +
		                            pstLibMatchInfo[i].udwLibID + "_MatchStatus:" + pstLibMatchInfo[i].udwMatchStatus + "_MatchPersonID:" +
		                            pstLibMatchInfo[i].udwMatchPersonID + "_MatchFaceID:" + pstLibMatchInfo[i].udwMatchFaceID );
		    }
		}
    }
     
	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frame = new JFrame();
		frame.setBackground(Color.WHITE);
		frame.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				singleLoginThread.shutdown();
				singleLiveThread.shutdown();
				netdevsdk.NETDEV_Cleanup();
				System.exit(0);
			}
		});
		
		frame.setBounds(100, 100, 1354, 850);
		frame.getContentPane().setLayout(null);

		JTabbedPane tabFunList = new JTabbedPane(JTabbedPane.TOP);
		tabFunList.setBounds(0, 279, 623, 520);
		frame.getContentPane().add(tabFunList);

		JPanel LiveViewPanel = new JPanel();
		tabFunList.addTab("LiveView", null, LiveViewPanel, "LiveView");
		LiveViewPanel.setLayout(null);

		JTabbedPane tabLiveList = new JTabbedPane(JTabbedPane.TOP);
		tabLiveList.setBounds(0, 0, 618, 481);
		LiveViewPanel.add(tabLiveList);

		Vector<String> VAvectorName= new Vector<String>();
		VAvectorName.add("Choose");
		VAvectorName.add("Mode");

		JPanel jPanelLive = new JPanel();
		tabLiveList.addTab("Live", null, jPanelLive, null);
		jPanelLive.setBorder(BorderFactory.createTitledBorder(""));
		jPanelLive.setLayout(null);
		
		JPanel jPanelBasicLive = new JPanel();
		jPanelBasicLive .setBorder(BorderFactory.createTitledBorder("BasicLive"));
		jPanelBasicLive .setBounds(31, 10, 250, 66);
		jPanelLive.add(jPanelBasicLive);
		jPanelBasicLive.setLayout(null);
		
		jButtonStopLive = new JButton("Stop");
		jButtonStopLive.setBounds(130, 25, 90, 23);
		jButtonStopLive.setEnabled(false);	
		jPanelBasicLive.add(jButtonStopLive);
		
		jButtonStartLive = new JButton("Start");
		jButtonStartLive.setBounds(21, 25, 90, 23);
		jPanelBasicLive.add(jButtonStartLive);

		JPanel jPanelRecord = new JPanel();
		jPanelRecord.setBounds(31, 86, 250, 66);
		jPanelRecord.setLayout(null);
        jPanelRecord.setBorder(BorderFactory.createTitledBorder("Record"));
		jPanelLive.add(jPanelRecord);

		jButtonStartRecord = new JButton("Start");
		jButtonStartRecord.setBounds(21, 25, 90, 23);
		jPanelRecord.add(jButtonStartRecord);
		
		jButtonStopRecord = new JButton("Stop");
		jButtonStopRecord.setEnabled(false);
		jButtonStopRecord.setBounds(131, 25, 90, 23);
		jPanelRecord.add(jButtonStopRecord);
		
		JPanel jPanelTalk = new JPanel();
		jPanelTalk.setBorder(BorderFactory.createTitledBorder("Talk"));
		jPanelTalk.setBounds(330, 10, 250, 66);
		jPanelLive.add(jPanelTalk);
		jPanelTalk.setLayout(null);
		
		jButtonStartTalk = new JButton("Start");
		jButtonStartTalk.setBounds(21, 25, 90, 23);
        jPanelTalk.add(jButtonStartTalk);

		jButtonStopTalk = new JButton("Stop");
		jButtonStopTalk.setBounds(131, 25, 90, 23);
		jButtonStopTalk.setEnabled(false);
		jPanelTalk.add(jButtonStopTalk);

	    JPanel jPanelOther = new JPanel();
	    jPanelOther.setBorder(BorderFactory.createTitledBorder("Other"));
	    jPanelOther.setBounds(330, 86, 250, 66);
	    jPanelLive.add(jPanelOther);
	    jPanelOther.setLayout(null);
	    
	    JButton jButtonCapture = new JButton("Capture");
	    jButtonCapture.setBounds(21, 25, 90, 23);
	    jPanelOther.add(jButtonCapture);
	    
	    JButton jButtonMakeI = new JButton("Make I");
	    jButtonMakeI.setBounds(130, 25, 90, 23);
	    jPanelOther.add(jButtonMakeI);
	    
	    JPanel jPanelSourceData = new JPanel();
	    jPanelSourceData.setBounds(31, 162, 250, 66);
	    jPanelSourceData.setBorder(BorderFactory.createTitledBorder("RTP+ES"));
	    jPanelSourceData.setLayout(null);
	    jPanelLive.add(jPanelSourceData);
	    
	    jButtonStartSourceData = new JButton("Start");
	    jButtonStartSourceData.setBounds(21, 25, 90, 23);
	    jPanelSourceData.add(jButtonStartSourceData);
	    
	    jButtonStopSourceData = new JButton("Stop");
	    jButtonStopSourceData.setBounds(128, 25, 90, 23);
	    jButtonStopSourceData.setEnabled(false);
	    jPanelSourceData.add(jButtonStopSourceData);
	    
	    JPanel jPanelDecodeData = new JPanel();
	    jPanelDecodeData.setBorder(BorderFactory.createTitledBorder("YUV"));
	    jPanelDecodeData.setBounds(330, 162, 250, 66);
	    jPanelLive.add(jPanelDecodeData);
	    jPanelDecodeData.setLayout(null);
	    
	    jButtonStartDecodeData = new JButton("Start");
	    jButtonStartDecodeData.setBounds(24, 25, 90, 23);
	    jPanelDecodeData.add(jButtonStartDecodeData);
	    
	    jButtonStopDecodeData = new JButton("Stop");
	    jButtonStopDecodeData.setBounds(134, 25, 90, 23);
	    jButtonStopDecodeData.setEnabled(false);
	    jPanelDecodeData.add(jButtonStopDecodeData);
	    
	    JPanel jPanelEyeFishData = new JPanel();
	    jPanelEyeFishData.setBorder(BorderFactory.createTitledBorder("EyeFish"));
	    jPanelEyeFishData.setBounds(31, 333, 250, 114);
	    jPanelLive.add(jPanelEyeFishData);
	    jPanelEyeFishData.setLayout(null);
	    
	    jComboBoxFishEyeMount = new JComboBox<String>();
	    jComboBoxFishEyeMount.setBounds(56, 29, 125, 23);
	    jComboBoxFishEyeMount.addItem("TOP");
	    jComboBoxFishEyeMount.addItem("BOTTOM");
	    jComboBoxFishEyeMount.addItem("Side");
	    jPanelEyeFishData.add(jComboBoxFishEyeMount);
	    
	    jComboBoxPreviewMode = new JComboBox<String>();
	    jComboBoxPreviewMode.setBounds(56, 69, 125, 23);
	    jComboBoxPreviewMode.addItem("ORIGINAL");
	    jComboBoxPreviewMode.addItem("360+1PTZ");
	    jComboBoxPreviewMode.addItem("LEFT+4PTZ");
	    jComboBoxPreviewMode.addItem("180");
	    jComboBoxPreviewMode.addItem("3PTZ");
	    jComboBoxPreviewMode.addItem("360+6PTZ");
	    jComboBoxPreviewMode.addItem("8PTZ");
	    jComboBoxPreviewMode.setSelectedIndex(0);
	    jPanelEyeFishData.add(jComboBoxPreviewMode);
	    
	    JPanel jPanelRenderScaleData = new JPanel();
	    jPanelRenderScaleData.setLayout(null);
	    jPanelRenderScaleData.setBorder(BorderFactory.createTitledBorder("RenderScale"));
	    jPanelRenderScaleData.setBounds(330, 238, 250, 86);
	    jPanelLive.add(jPanelRenderScaleData);
	    
	    jComboBoxRenderScale = new JComboBox<String>();
	    jComboBoxRenderScale.setBounds(63, 35, 125, 23);
	    jComboBoxRenderScale.addItem("FULL");
	    jComboBoxRenderScale.addItem("PROPORTION");
	    jComboBoxRenderScale.setSelectedIndex(0);
	    jPanelRenderScaleData.add(jComboBoxRenderScale);
	    
	    JPanel jPanelPictureFluencyData = new JPanel();
	    jPanelPictureFluencyData.setBounds(31, 238, 250, 86);
	    jPanelPictureFluencyData.setLayout(null);
	    jPanelPictureFluencyData.setBorder(BorderFactory.createTitledBorder("PictureFluency"));
	    jPanelLive.add(jPanelPictureFluencyData);
	    
	    jComboBoxPictureFluency = new JComboBox<String>();
	    jComboBoxPictureFluency.setBounds(55, 35, 125, 23);     
	    jComboBoxPictureFluency.addItem("REAL");
	    jComboBoxPictureFluency.addItem("FLUENCY");
	    jComboBoxPictureFluency.addItem("BALANCE");
	    jComboBoxPictureFluency.setSelectedIndex(0);
	    jPanelPictureFluencyData.add(jComboBoxPictureFluency);
	    
        JPanel DigitalZoomDataPanel = new JPanel();
        DigitalZoomDataPanel.setBounds(310, 333, 294, 114);
        DigitalZoomDataPanel.setLayout(null);
        DigitalZoomDataPanel.setBorder(BorderFactory.createTitledBorder("DigitalZoom"));
        jPanelLive.add(DigitalZoomDataPanel);
        
        jTextFieldDigitalZoomLeft = new JTextField();
        jTextFieldDigitalZoomLeft.setBounds(43, 28, 77, 19);
        jTextFieldDigitalZoomLeft.setColumns(10);
        DigitalZoomDataPanel.add(jTextFieldDigitalZoomLeft);
        
        jTextFieldDigitalZoomRight = new JTextField();
        jTextFieldDigitalZoomRight.setBounds(197, 28, 77, 19);
        jTextFieldDigitalZoomRight.setColumns(10);
        DigitalZoomDataPanel.add( jTextFieldDigitalZoomRight);
        
        jTextFieldDigitalZoomTop = new JTextField();
        jTextFieldDigitalZoomTop.setBounds(43, 51, 77, 19);
        jTextFieldDigitalZoomTop.setColumns(10);
        DigitalZoomDataPanel.add(jTextFieldDigitalZoomTop);
        
        jTextFieldDigitalZoomBottom = new JTextField();   
        jTextFieldDigitalZoomBottom.setBounds(197, 51, 77, 19);
        jTextFieldDigitalZoomBottom.setColumns(10);
        DigitalZoomDataPanel.add(jTextFieldDigitalZoomBottom);

        JButton jButtonSetDigitalZoom = new JButton("Set");
        jButtonSetDigitalZoom.setBounds(53, 80, 85, 23);
        DigitalZoomDataPanel.add(jButtonSetDigitalZoom);
        
        JButton jButtonExitDigitalZoom = new JButton("Exit");
        jButtonExitDigitalZoom .setBounds(167, 80, 85, 23);
        DigitalZoomDataPanel.add(jButtonExitDigitalZoom);
        
        JLabel jLableDigitalZoomLeft = new JLabel("left");
        jLableDigitalZoomLeft.setBounds(10, 30, 24, 15);
        DigitalZoomDataPanel.add(jLableDigitalZoomLeft);
        
        JLabel jLabelDigitalZoomTop = new JLabel("Top");
        jLabelDigitalZoomTop.setBounds(10, 55, 54, 15);
        DigitalZoomDataPanel.add(jLabelDigitalZoomTop);
        
        JLabel jLableDigitalZoomRight = new JLabel("Right");
        jLableDigitalZoomRight.setBounds(130, 30, 57, 15);
        DigitalZoomDataPanel.add(jLableDigitalZoomRight);
        
        JLabel jLableDigitalZoomBottom = new JLabel("Bottom");
        jLableDigitalZoomBottom.setBounds(130, 53, 58, 15);
        DigitalZoomDataPanel.add(jLableDigitalZoomBottom);
           
        JPanel jPanelLiveInformation = new JPanel();
        tabLiveList.addTab("Information", null, jPanelLiveInformation, null);
        jPanelLiveInformation.setLayout(null);
        
        JPanel jPanelVideoEffectData = new JPanel();
        jPanelVideoEffectData.setBounds(10, 10, 593, 120);
        jPanelVideoEffectData.setBorder(BorderFactory.createTitledBorder("VideoEffect"));
        jPanelVideoEffectData.setLayout(null);
        jPanelLiveInformation.add(jPanelVideoEffectData);
        
        JButton jButtonGetVideoEffect = new JButton("Get");
        jButtonGetVideoEffect.setBounds(297, 87, 77, 23);  
        jPanelVideoEffectData.add(jButtonGetVideoEffect);
        
        JButton jButtonSetVideoEffect = new JButton("Set");
        jButtonSetVideoEffect.setBounds(384, 87, 77, 23);
        jPanelVideoEffectData.add(jButtonSetVideoEffect);
        
        jTextFieldContrast = new JTextField();
        jTextFieldContrast.setBounds(73, 28, 77, 19);
        jTextFieldContrast.setColumns(10);
        jPanelVideoEffectData.add(jTextFieldContrast);    
        
        jTextFieldBrightness = new JTextField();
        jTextFieldBrightness.setBounds(371, 28, 77, 19);
        jTextFieldBrightness.setColumns(10); 
        jPanelVideoEffectData.add(jTextFieldBrightness);   
        
        jTextFieldSaturation = new JTextField();
        jTextFieldSaturation.setBounds(73, 55, 77, 19);
        jTextFieldSaturation.setColumns(10);
        jPanelVideoEffectData.add(jTextFieldSaturation);         
        
        jTextFieldHue = new JTextField();
        jTextFieldHue.setBounds(371, 55, 77, 19);
        jTextFieldHue.setColumns(10);
        jPanelVideoEffectData.add(jTextFieldHue);
        
        jTextFieldGamma = new JTextField();
        jTextFieldGamma.setBounds(73, 82, 77, 19);
        jTextFieldGamma.setColumns(10);
        jPanelVideoEffectData.add(jTextFieldGamma);         
        
        JLabel lblContrast = new JLabel("Contrast");
        lblContrast.setBounds(10, 30, 54, 15);
        jPanelVideoEffectData.add(lblContrast);     
        
        JLabel lblNewLabel = new JLabel("Saturation");
        lblNewLabel.setBounds(10, 57, 64, 15);
        jPanelVideoEffectData.add(lblNewLabel);  
        
        JLabel lblNewLabel_1 = new JLabel("Gamma");
        lblNewLabel_1.setBounds(10, 82, 54, 15);
        jPanelVideoEffectData.add(lblNewLabel_1);  
        
        JLabel lblNewLabel_2 = new JLabel("Brightness");
        lblNewLabel_2.setBounds(297, 30, 68, 15);
        jPanelVideoEffectData.add(lblNewLabel_2);
        
        JLabel lblNewLabel_3 = new JLabel("Hue");
        lblNewLabel_3.setBounds(297, 57, 54, 15);
        jPanelVideoEffectData.add(lblNewLabel_3);
        
        JLabel lblRangeContrast = new JLabel("Range:0-255");
        lblRangeContrast.setForeground(Color.RED);
        lblRangeContrast.setBounds(154, 30, 71, 15);
        jPanelVideoEffectData.add(lblRangeContrast);
        
        JLabel lblRangeSturation = new JLabel("Range:0-255");
        lblRangeSturation.setForeground(Color.RED);
        lblRangeSturation.setBounds(154, 57, 77, 15);
        jPanelVideoEffectData.add(lblRangeSturation);
        
        JLabel lblRangeGamma = new JLabel("Range:0-10");
        lblRangeGamma.setForeground(Color.RED);
        lblRangeGamma.setBounds(154, 82, 64, 15);
        jPanelVideoEffectData.add(lblRangeGamma);
        
        JLabel lblRangeBrightness = new JLabel("Range:0-255");
        lblRangeBrightness.setForeground(Color.RED);
        lblRangeBrightness.setBounds(458, 30, 75, 15);
        jPanelVideoEffectData.add(lblRangeBrightness);
        
        JLabel lblRangeHue = new JLabel("Range:0-255");
        lblRangeHue.setForeground(Color.RED);
        lblRangeHue.setBounds(458, 57, 75, 15);
        jPanelVideoEffectData.add(lblRangeHue);
        
        jPanelliveVoice = new JPanel();
        jPanelliveVoice.setLayout(null);
        jPanelliveVoice.setBounds(10, 140, 593, 61);
        jPanelliveVoice.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "LiveVoice", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
        jPanelLiveInformation.add(jPanelliveVoice);   
        
        JLabel jLabelPleaseChooseFile = new JLabel("Choose file");
        jLabelPleaseChooseFile.setBounds(10, 25, 67, 15);
        jPanelliveVoice.add(jLabelPleaseChooseFile);
        
        jTextFieldLiveVoice = new JTextField();
        jTextFieldLiveVoice.setBounds(81, 22, 236, 21);
        jTextFieldLiveVoice.setColumns(10);
        jTextFieldLiveVoice.setEditable(false);     
        jPanelliveVoice.add(jTextFieldLiveVoice);

        JButton jButtonChooseVoiceFile = new JButton("Choose");
        jButtonChooseVoiceFile.setBounds(327, 21, 93, 23); 
        jPanelliveVoice.add(jButtonChooseVoiceFile); 
        
        jButtonLiveGetVoice= new JButton("Voice acquisition");
        jButtonLiveGetVoice.setBounds(430, 21, 135, 23);
        jPanelliveVoice.add(jButtonLiveGetVoice);
        
        JPanel liveVAConfigPanel= new JPanel();
        liveVAConfigPanel.setLayout(null);
        liveVAConfigPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "LiveVA", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
        liveVAConfigPanel.setBounds(10, 211, 310, 210);
        jPanelLiveInformation.add(liveVAConfigPanel);
        
        JScrollPane scrollPaneVA = new JScrollPane();
        scrollPaneVA.setBounds(10, 64, 290, 87);
        liveVAConfigPanel.add(scrollPaneVA);
                   
        CheckTableModle checkTableVA=new CheckTableModle(this.initTable(),VAvectorName);
        VATable.setSize(280, 97);
        VATable.setLocation(36, 49);
        VATable.setModel(checkTableVA);
        scrollPaneVA.setViewportView(VATable);
                                 
        JLabel lblLiveVA = new JLabel("Metadata");
        lblLiveVA.setBounds(10, 39, 66, 15);
        liveVAConfigPanel.add(lblLiveVA);
            
        jCheckBoxVAEnable = new JCheckBox("Enable");
        jCheckBoxVAEnable.setBounds(82, 35, 66, 23);
        liveVAConfigPanel.add(jCheckBoxVAEnable);  
        
        JButton jButtonSetVAParam = new JButton("Set");
        jButtonSetVAParam.setBounds(208, 161, 92, 23);
        liveVAConfigPanel.add(jButtonSetVAParam);
        
		jPanelShowLiveParam.setBounds(633, 703, 695, 98);
		frame.getContentPane().add(jPanelShowLiveParam);
		jPanelShowLiveParam.setLayout(null);	
		
	    JLabel lblBitrateParam = new JLabel("BitRate:");
	    lblBitrateParam.setBounds(359, 40, 50, 20);
	    jPanelShowLiveParam.add(lblBitrateParam);
	    
	    JLabel labelFrameRate = new JLabel("FrameRate:");
	    labelFrameRate.setBounds(513, 5, 70, 20);
        jPanelShowLiveParam.add(labelFrameRate);
        
	    JLabel labelEncodeFmt = new JLabel("Code Format:");
	    labelEncodeFmt.setBounds(359, 5, 80, 20);
        jPanelShowLiveParam.add(labelEncodeFmt);
	    
	    JLabel labelResolution = new JLabel("Resolving Power:");
	    labelResolution.setBounds(10, 5, 102, 20);
        jPanelShowLiveParam.add(labelResolution);
        
	    JLabel labelPacket = new JLabel("Packet LossRate:");
	    labelPacket.setBounds(513, 40, 100, 20);
        jPanelShowLiveParam.add(labelPacket);
	    
	    JLabel lblLiveViewUrl = new JLabel("URL: ");
	    lblLiveViewUrl.setBounds(10, 40, 36, 20);
        jPanelShowLiveParam.add(lblLiveViewUrl);
	    
        jLabelBitRateParam = new JLabel();
		jLabelBitRateParam.setBounds(409, 40, 80, 20);
		jPanelShowLiveParam.add(jLabelBitRateParam);
		
		jLabelVideoEncodeFmt = new JLabel();
		jLabelVideoEncodeFmt.setBounds(440, 5, 63, 20);
		jPanelShowLiveParam.add(jLabelVideoEncodeFmt);
		 
		jLabelFrameRate = new JLabel();
		jLabelFrameRate.setBounds(584, 5, 20, 20);
		jPanelShowLiveParam.add(jLabelFrameRate);
		
		jLabelGetpdwWidth = new JLabel();
		jLabelGetpdwWidth.setBounds(113, 5, 35, 20);
		jPanelShowLiveParam.add(jLabelGetpdwWidth);
		
		jLabelGetpdwHeight  = new JLabel();
        jLabelGetpdwHeight.setBounds(149, 5, 35, 20);
        jPanelShowLiveParam.add(jLabelGetpdwHeight);
        
        jLabelGetpulRecvPktNum = new JLabel();
        jLabelGetpulRecvPktNum.setBounds(617, 40, 29, 20);
        jPanelShowLiveParam.add(jLabelGetpulRecvPktNum);
        
        jSliderLiveSound = new JSlider();
        jSliderLiveSound.setBounds(124, 70, 127, 26);
        jSliderLiveSound.setMaximum(255);
        jSliderLiveSound.setEnabled(true);
        jPanelShowLiveParam.add(jSliderLiveSound);
        
        jButtonLiveSoundSilence = new JButton("Mute");
        jButtonLiveSoundSilence.setBounds(10, 70, 102, 23);
        jPanelShowLiveParam.add(jButtonLiveSoundSilence);
        
        jSliderLiveMicSound = new JSlider();
        jSliderLiveMicSound.setEnabled(false);
        jSliderLiveMicSound.setMaximum(255);
        jSliderLiveMicSound.setBounds(434, 70, 127, 26);
        jPanelShowLiveParam.add(jSliderLiveMicSound);
        
        jLabelLiveSound2 = new JLabel();
        jLabelLiveSound2.setBounds(577, 70, 21, 21);
        jPanelShowLiveParam.add(jLabelLiveSound2);

		jLabelLiveSound = new JLabel();
		jLabelLiveSound.setBounds(261, 70, 21, 21);	
		jPanelShowLiveParam.add(jLabelLiveSound);
		
		jLableLiveMicSound = new JLabel();
	    jLableLiveMicSound.setBounds(566, 75, 21, 21);
	    jPanelShowLiveParam.add(jLableLiveMicSound);

	    jButtonMic = new JButton("Microphone");
	    jButtonMic.setBounds(310, 70, 112, 23);
	    jPanelShowLiveParam.add(jButtonMic);
	    
	    jLabelLiveViewStreamUrl = new JLabel();
	    jLabelLiveViewStreamUrl.setBounds(43, 40, 306, 20);
	    jLabelLiveViewStreamUrl.setText(null);
	    jPanelShowLiveParam.add(jLabelLiveViewStreamUrl);
	    
	    
		JPanel jPanelPTZ = new JPanel();
        tabFunList.addTab("PTZ", null, jPanelPTZ, null);
        jPanelPTZ.setLayout(null);

        JTabbedPane tabbedPane_1 = new JTabbedPane(JTabbedPane.TOP);
        tabbedPane_1.setBounds(0, 0, 618, 492);
        jPanelPTZ.add(tabbedPane_1);

        JPanel jPanelPTZBase = new JPanel();
        tabbedPane_1.addTab("BasicPTZ", null, jPanelPTZBase, null);
        jPanelPTZBase.setBorder(BorderFactory.createTitledBorder(""));
        jPanelPTZBase.setLayout(null);

        JPanel jPanelPTZBaseControl = new JPanel();
        jPanelPTZBaseControl.setBorder(new TitledBorder(null, "Base PTZ", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelPTZBaseControl.setBounds(10, 10, 593, 176);
        jPanelPTZBase.add(jPanelPTZBaseControl);
        jPanelPTZBaseControl.setLayout(null);
        
        jComboBoxPTZSpeed = new JComboBox<String>();
        jComboBoxPTZSpeed.setBounds(67, 21, 99, 21);
		jComboBoxPTZSpeed.addItem("Speed:1");
		jComboBoxPTZSpeed.addItem("Speed:2");
		jComboBoxPTZSpeed.addItem("Speed:3");
		jComboBoxPTZSpeed.addItem("Speed:4");
		jComboBoxPTZSpeed.addItem("Speed:5");
		jComboBoxPTZSpeed.addItem("Speed:6");
		jComboBoxPTZSpeed.addItem("Speed:7");
		jComboBoxPTZSpeed.addItem("Speed:8");
		jComboBoxPTZSpeed.addItem("Speed:9");
		jComboBoxPTZSpeed.setSelectedIndex(4);
		jPanelPTZBaseControl.add(jComboBoxPTZSpeed);

		JButton jButtonUp = new JButton("▲");//up
		jButtonUp.setBounds(127,52,50,23);
		jPanelPTZBaseControl.add(jButtonUp);

		JButton jButtonLeft = new JButton("◀");//left
		jButtonLeft.setBounds(67, 92, 50, 23);
		jPanelPTZBaseControl.add(jButtonLeft);

		JButton jButtonRight = new JButton("▶");//right
		jButtonRight.setBounds(187, 92, 50, 23);
		jPanelPTZBaseControl.add(jButtonRight);

		JButton jButtonDown = new JButton("▼");//bottom
		jButtonDown.setBounds(127, 132, 50, 23);
		jPanelPTZBaseControl.add(jButtonDown);

		JButton jButtonZoomNear = new JButton("Zoom+");
		jButtonZoomNear.setBounds(316, 74, 93, 23);
		jPanelPTZBaseControl.add(jButtonZoomNear);

		JButton jButtonZoomFar = new JButton("Zoom-");
		jButtonZoomFar.setBounds(419, 74, 93, 23);
		jPanelPTZBaseControl.add(jButtonZoomFar);

		JButton jButtonFocusFar = new JButton("Focus+");
		jButtonFocusFar.setBounds(316, 107, 93, 23);
		jPanelPTZBaseControl.add(jButtonFocusFar);

		JButton jButtonFocusNear = new JButton("Focus-");
		jButtonFocusNear.setBounds(419, 107, 93, 23);
		jPanelPTZBaseControl.add(jButtonFocusNear);
		
		JButton jButtonLeftUp = new JButton("◤");
		jButtonLeftUp.setBounds(67, 52, 50, 23);
	    jPanelPTZBaseControl.add(jButtonLeftUp);
	        
	    JButton jButtonRightUp = new JButton("◥");
	    jButtonRightUp.setBounds(187, 52, 50, 23);
	    jPanelPTZBaseControl.add(jButtonRightUp);
	    
	    JButton jButtonPtzControlLeftDown = new JButton("◣");
	    jButtonPtzControlLeftDown.setBounds(67, 132, 50, 23);
	    jPanelPTZBaseControl.add(jButtonPtzControlLeftDown);
	    
        JButton jButtonRightDown = new JButton("◢");
        jButtonRightDown.setBounds(187, 132, 50, 23);
        jPanelPTZBaseControl.add(jButtonRightDown);
        
        JButton jButtonPTZPause = new JButton("◼");
        jButtonPTZPause.setBounds(127, 92, 50, 23);
        jPanelPTZBaseControl.add(jButtonPTZPause);
        
        JPanel jPanelPTZBasePreset = new JPanel();
        jPanelPTZBasePreset.setBorder(new TitledBorder(null, "Preset", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelPTZBasePreset.setBounds(10, 189, 593, 186);
        jPanelPTZBase.add(jPanelPTZBasePreset);
        jPanelPTZBasePreset.setLayout(null);
        
        jButtonGetBasePTZPreset = new JButton("Get");
        jButtonGetBasePTZPreset.setBounds(20, 150, 68, 23);
        jPanelPTZBasePreset.add(jButtonGetBasePTZPreset);
        
        JButton jButtonBasePTZPresetGoTo = new JButton("Go to");
        jButtonBasePTZPresetGoTo.setBounds(114, 150, 68, 23);
        jPanelPTZBasePreset.add(jButtonBasePTZPresetGoTo);
        
        JButton jButtonAddBasePTZPreset = new JButton("Add");
        jButtonAddBasePTZPreset.setBounds(208, 150, 75, 23);
        jPanelPTZBasePreset.add(jButtonAddBasePTZPreset);
        
        JButton jButtonBasePTZPresetDelete = new JButton("Delete");
        jButtonBasePTZPresetDelete.setBounds(302, 150, 75, 23);
        jPanelPTZBasePreset.add(jButtonBasePTZPresetDelete);
        
        JScrollPane jScrollPanePTZBasePreset = new JScrollPane();
        jScrollPanePTZBasePreset.setBounds(20, 21, 563, 119);
        jPanelPTZBasePreset.add(jScrollPanePTZBasePreset);

        jTablePTZBasePreset = new JTable();
        jTablePTZBasePreset.setModel(PTZBasePresetModel);
        jScrollPanePTZBasePreset.setViewportView(jTablePTZBasePreset);
        
        JPanel jPanelPTZExtend = new JPanel();
        tabbedPane_1.addTab("PTZExtend", null, jPanelPTZExtend, null);
        jPanelPTZExtend.setLayout(null);
        
        JPanel jPanelPTZExtend1 = new JPanel();
        jPanelPTZExtend1.setBounds(10, 10, 593, 77);
        jPanelPTZExtend1.setBorder(new LineBorder(Color.LIGHT_GRAY));   
        jPanelPTZExtend1.setLayout(null); 
        jPanelPTZExtend.add(jPanelPTZExtend1);
        
        JLabel jLabelPTZExtendWiper = new JLabel("Wiper");
        jLabelPTZExtendWiper.setBounds(10, 9, 54, 15);
        jPanelPTZExtend1.add(jLabelPTZExtendWiper);
        
        JButton jButtonPTZExtendWiperON = new JButton("ON");
        jButtonPTZExtendWiperON.setBounds(74, 5, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendWiperON);
        
        JButton jButtonPTZExtendWiperOFF = new JButton("OFF");
        jButtonPTZExtendWiperOFF.setBounds(177, 5, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendWiperOFF);
        
        JLabel jLabelPTZExtendHeater = new JLabel("Heater");
        jLabelPTZExtendHeater.setBounds(304, 9, 54, 15);
        jPanelPTZExtend1.add(jLabelPTZExtendHeater);
        
        JButton jButtonPTZExtendHeaterON = new JButton("ON");
        jButtonPTZExtendHeaterON.setBounds(387, 5, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendHeaterON);
        
        JButton jButtonPTZExtendHeaterOFF = new JButton("OFF");
        jButtonPTZExtendHeaterOFF.setBounds(490, 5, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendHeaterOFF);
        
        JLabel jLabelPTZExtendLight = new JLabel("Light");
        jLabelPTZExtendLight.setBounds(10, 45, 54, 15);
        jPanelPTZExtend1.add(jLabelPTZExtendLight);
        
        JButton jButtonPTZExtendLightON = new JButton("ON");
        jButtonPTZExtendLightON.setBounds(74, 41, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendLightON);
        
        JButton jButtonPTZExtendLightOFF = new JButton("OFF");
        jButtonPTZExtendLightOFF.setBounds(177, 41, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendLightOFF);
        
        JLabel jLabelPTZExtendSnowRemoval = new JLabel("Snow Removal");
        jLabelPTZExtendSnowRemoval.setBounds(291, 45, 92, 15);
        jPanelPTZExtend1.add(jLabelPTZExtendSnowRemoval);
        
        JButton  jButtonPTZExtendSnowRemovalON = new JButton("ON");
        jButtonPTZExtendSnowRemovalON.setBounds(387, 38, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendSnowRemovalON);
        
        JButton jButtonPTZExtendSnowRemovalOFF = new JButton("OFF");
        jButtonPTZExtendSnowRemovalOFF.setBounds(490, 38, 93, 23);
        jPanelPTZExtend1.add(jButtonPTZExtendSnowRemovalOFF);
        
        JPanel jPanelPTZExtendRoutePatrols = new JPanel();
        jPanelPTZExtendRoutePatrols.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Route Patrols", TitledBorder.LEADING, TitledBorder.TOP, null, Color.BLACK));
        jPanelPTZExtendRoutePatrols.setBounds(10, 97, 593, 77);
        jPanelPTZExtend.add(jPanelPTZExtendRoutePatrols);
        jPanelPTZExtendRoutePatrols.setLayout(null);
        
        JLabel jLabelPTZExtendRoutePatrolsRecord = new JLabel("Record");
        jLabelPTZExtendRoutePatrolsRecord.setBounds(10, 47, 54, 15);
        jPanelPTZExtendRoutePatrols.add(jLabelPTZExtendRoutePatrolsRecord);
        
        JLabel jLabelPTZExtendRoutePatrolsName = new JLabel("Name");
        jLabelPTZExtendRoutePatrolsName.setBounds(10, 22, 54, 15);
        jPanelPTZExtendRoutePatrols.add(jLabelPTZExtendRoutePatrolsName);
        
        jTextFieldPTZExtendRoutePatrolsName = new JTextField();
        jTextFieldPTZExtendRoutePatrolsName.setBounds(74, 19, 196, 21);
        jTextFieldPTZExtendRoutePatrolsName.setColumns(10);
        jPanelPTZExtendRoutePatrols.add(jTextFieldPTZExtendRoutePatrolsName);
       
        JButton jButtonPTZExtendRoutePatrolsGet = new JButton("Get");
        jButtonPTZExtendRoutePatrolsGet.setBounds(284, 20, 93, 23);
        jPanelPTZExtendRoutePatrols.add(jButtonPTZExtendRoutePatrolsGet);
        
        JButton jButtonPTZExtendRoutePatrolsRun = new JButton("Run");
        jButtonPTZExtendRoutePatrolsRun.setBounds(387, 19, 93, 23);
        jPanelPTZExtendRoutePatrols.add(jButtonPTZExtendRoutePatrolsRun);
        
        JButton jButtonPTZExtendRoutePatrolsStop = new JButton("Stop");
        jButtonPTZExtendRoutePatrolsStop.setBounds(490, 19, 93, 23);
        jPanelPTZExtendRoutePatrols.add(jButtonPTZExtendRoutePatrolsStop);
        
        JButton jButtonPTZExtendRouteRecordStart = new JButton("Start");
        jButtonPTZExtendRouteRecordStart.setBounds(74, 47, 93, 23);
        jPanelPTZExtendRoutePatrols.add(jButtonPTZExtendRouteRecordStart);
        
        jButtonPTZExtendRouteRecordStop = new JButton("Stop");
        jButtonPTZExtendRouteRecordStop.setBounds(177, 47, 93, 23);
        jPanelPTZExtendRoutePatrols.add(jButtonPTZExtendRouteRecordStop);
        
        JPanel jPanelPTZExtendPresetPatrols = new JPanel();
        jPanelPTZExtendPresetPatrols.setBorder(new TitledBorder(null, "Preset Patrols", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelPTZExtendPresetPatrols.setBounds(10, 184, 593, 269);
        jPanelPTZExtend.add(jPanelPTZExtendPresetPatrols);
        jPanelPTZExtendPresetPatrols.setLayout(null);

        JLabel jLabelPTZExtendPresetPatrolsID = new JLabel("ID");
        jLabelPTZExtendPresetPatrolsID.setBounds(10, 24, 35, 15);
        jPanelPTZExtendPresetPatrols.add(jLabelPTZExtendPresetPatrolsID);

        jComboBoxPTZExtendPresetPatrolsID = new JComboBox<String>();
        jComboBoxPTZExtendPresetPatrolsID.setBounds(39, 21, 54, 21);
        jPanelPTZExtendPresetPatrols.add(jComboBoxPTZExtendPresetPatrolsID);
        for(int i=1;i<=16;i++) 
        {
            Integer j = i;
            jComboBoxPTZExtendPresetPatrolsID.addItem(j.toString());
        }
        jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(0);
        
        JLabel jLabelPTZExtendPresetPatrolsName = new JLabel("Name");
        jLabelPTZExtendPresetPatrolsName.setBounds(103, 24, 42, 15);
        jPanelPTZExtendPresetPatrols.add(jLabelPTZExtendPresetPatrolsName);
        
        jTextFieldPTZExtendPresetPatrolsName = new JTextField();
        jTextFieldPTZExtendPresetPatrolsName.setBounds(141, 21, 80, 21);
        jPanelPTZExtendPresetPatrols.add(jTextFieldPTZExtendPresetPatrolsName);
        jTextFieldPTZExtendPresetPatrolsName.setColumns(10);
        
        JButton jButtonPTZExtendPresetPatrolsStart = new JButton("Start");
        jButtonPTZExtendPresetPatrolsStart.setBounds(233, 20, 80, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsStart);
        
        JButton jButtonPTZExtendPresetPatrolsStop = new JButton("Stop");
        jButtonPTZExtendPresetPatrolsStop.setBounds(323, 20, 80, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsStop);
        
        JButton jButtonPTZExtendPresetPatrolsSave = new JButton("Save");
        jButtonPTZExtendPresetPatrolsSave.setBounds(413, 20, 80, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsSave);
        
        JButton jButtonPTZExtendPresetPatrolsDelete = new JButton("Delete");
        jButtonPTZExtendPresetPatrolsDelete.setBounds(503, 20, 80, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsDelete);
        
        JScrollPane jScrollPanePTZExtendPresetPatrols = new JScrollPane();
        jScrollPanePTZExtendPresetPatrols.setBounds(10, 55, 573, 132);
        jPanelPTZExtendPresetPatrols.add(jScrollPanePTZExtendPresetPatrols);

        jTablePTZExtendPresetPatrols = new JTable();
        jTablePTZExtendPresetPatrols.setModel(tablePTZExtendPresetPatrolsModel);
        jScrollPanePTZExtendPresetPatrols.setViewportView(jTablePTZExtendPresetPatrols);

        JLabel jLabelPTZExtendPresetPatrolsPresetID = new JLabel("Preset ID");
        jLabelPTZExtendPresetPatrolsPresetID.setBounds(10, 205, 62, 15);
        jPanelPTZExtendPresetPatrols.add(jLabelPTZExtendPresetPatrolsPresetID);

        jComboBoxExtendPTZPresetID = new JComboBox<String>();
        jComboBoxExtendPTZPresetID.setBounds(75, 205, 65, 21);
        jPanelPTZExtendPresetPatrols.add(jComboBoxExtendPTZPresetID);

        JLabel jLabelPTZExtendPresetPatrolsStayTime = new JLabel("StayTime(s)");
        jLabelPTZExtendPresetPatrolsStayTime.setBounds(159, 205, 74, 15);
        jPanelPTZExtendPresetPatrols.add(jLabelPTZExtendPresetPatrolsStayTime);

        jTextFieldExtendPTZStayTime = new JTextField();
        jTextFieldExtendPTZStayTime.setBounds(235, 202, 66, 21);
        jPanelPTZExtendPresetPatrols.add(jTextFieldExtendPTZStayTime);
        jTextFieldExtendPTZStayTime.setColumns(10);

        JLabel jLabelPTZExtendPresetPatrolsSpeed = new JLabel("Speed(1-9)");
        jLabelPTZExtendPresetPatrolsSpeed.setBounds(323, 205, 69, 15);
        jPanelPTZExtendPresetPatrols.add(jLabelPTZExtendPresetPatrolsSpeed);

        jTextFieldPTZExtendPresetPatrolsSpeed = new JTextField();
        jTextFieldPTZExtendPresetPatrolsSpeed.setBounds(395, 202, 66, 21);
        jPanelPTZExtendPresetPatrols.add(jTextFieldPTZExtendPresetPatrolsSpeed);
        jTextFieldPTZExtendPresetPatrolsSpeed.setColumns(10);
        
        JButton jButtonPTZExtendPresetPatrolsAdd = new JButton("Add");
        jButtonPTZExtendPresetPatrolsAdd.setBounds(210, 236, 93, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsAdd);
        
        JButton jButtonPTZExtendPresetIDDelete = new JButton("Delete");
        jButtonPTZExtendPresetIDDelete.setBounds(313, 236, 93, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetIDDelete);
        
        jButtonPTZExtendPresetPatrolsRefresh = new JButton("Refresh"); 
        jButtonPTZExtendPresetPatrolsRefresh.setBounds(490, 201, 93, 23);
        jPanelPTZExtendPresetPatrols.add(jButtonPTZExtendPresetPatrolsRefresh);

		JPanel PlayBackPanel = new JPanel();
		tabFunList.addTab("PlayBack", null, PlayBackPanel, null);
		PlayBackPanel.setLayout(null);

		JTabbedPane tabPlayBackList = new JTabbedPane(JTabbedPane.TOP);
		tabPlayBackList.setBounds(0, 0, 618, 580);
		PlayBackPanel.add(tabPlayBackList);

		JPanel PlayBackByTimePanel = new JPanel();
		tabPlayBackList.addTab("PlayBack", null,PlayBackByTimePanel, null);
		PlayBackByTimePanel.setLayout(null);

		JPanel PlayBackConfig = new JPanel();
		tabPlayBackList.addTab("PlayBackConfig", null, PlayBackConfig, null);
		PlayBackConfig.setLayout(null);

		JPanel jPanelQueryPlayBack = new JPanel();
        jPanelQueryPlayBack.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "QueryRecordByTime", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
        jPanelQueryPlayBack.setToolTipText("");
        jPanelQueryPlayBack.setBounds(10, 10, 593, 56);
        jPanelQueryPlayBack.setLayout(null);
        PlayBackByTimePanel.add(jPanelQueryPlayBack);
        
        JLabel lblBegintime = new JLabel("Begin");
        lblBegintime.setBounds(10, 24, 36, 15);
        jPanelQueryPlayBack.add(lblBegintime);
        
        JLabel lblEndtime = new JLabel("End");
        lblEndtime.setBounds(265, 24, 67, 15);
        jPanelQueryPlayBack.add(lblEndtime);
        
        j.setBounds(50, 16, 203, 30);
        jPanelQueryPlayBack.add(j);
        j.add(Begindate);
        
        j2.setBounds(297, 16, 203, 30);
        jPanelQueryPlayBack.add(j2);
        j2.add(Enddate);
        
        jButtonQueryrecord = new JButton("Query");
        jButtonQueryrecord.setBounds(510, 20, 76, 23);
        jPanelQueryPlayBack.add(jButtonQueryrecord);
        
        JPanel jPanelPlayRecord = new JPanel();
        jPanelPlayRecord.setBounds(10, 93, 593, 212);
        jPanelPlayRecord.setBorder(new TitledBorder(null, "PlayRecord", TitledBorder.LEADING, TitledBorder.TOP, null, null)); 
        jPanelPlayRecord.setLayout(null);
        PlayBackByTimePanel.add(jPanelPlayRecord);
        
        JScrollPane RecordScrollPane = new JScrollPane();
        RecordScrollPane.setBounds(10, 24, 443, 108);
        RecordScrollPane.setEnabled(false);
        RecordTable = new JTable(RecordTableModel) {
             public boolean isCellEditable(int row,int column) {
                 return false;
             }
         };
         RecordScrollPane.setViewportView(RecordTable);
         jPanelPlayRecord.add(RecordScrollPane);
         
         JButton jButtonPlaybackByTime = new JButton("PlayByTime");
         jButtonPlaybackByTime.setBounds(463, 109, 120, 23);
         jPanelPlayRecord.add(jButtonPlaybackByTime);
         
         JButton jButtonPlaybackByName = new JButton("PlayByName");
         jButtonPlaybackByName.setBounds(463, 63, 120, 23);
         jPanelPlayRecord.add(jButtonPlaybackByName);
         
         JButton jButtonPlaybackByURL = new JButton("PlayByURL");
         jButtonPlaybackByURL.setBounds(463, 21, 120, 23);
         jPanelPlayRecord.add(jButtonPlaybackByURL);
         
         jSliderPlayBack = new JSlider();
         jSliderPlayBack.setBounds(10, 133, 437, 25);
         jSliderPlayBack.setValue(0);
         jPanelPlayRecord.add(jSliderPlayBack);

         lblProgressLabel = new JLabel("");
         lblProgressLabel.setBounds(25, 160, 184, 15);
         jPanelPlayRecord.add(lblProgressLabel);
         
         jButtonPauseOrResume = new JButton("Pause");
         jButtonPauseOrResume.setBounds(20, 179, 100, 23);
         jPanelPlayRecord.add(jButtonPauseOrResume);
         
         jButtonStopPlayback = new JButton("Stop");
         jButtonStopPlayback.setBounds(137, 179, 100, 23);
         jPanelPlayRecord.add(jButtonStopPlayback);
         jButtonStopPlayback.setEnabled(false);

         lblPlaybackSpeed = new JLabel("1X");
         lblPlaybackSpeed.setBounds(350, 160, 37, 18);
         lblPlaybackSpeed.setHorizontalAlignment(SwingConstants.LEFT);
         jPanelPlayRecord.add(lblPlaybackSpeed);
         
         jButtonFastSpeed = new JButton(">>");
         jButtonFastSpeed.setBounds(390, 160, 48, 18);
         jPanelPlayRecord.add(jButtonFastSpeed);
         
         jButtonSlowSpeed = new JButton("<<");
         jButtonSlowSpeed.setBounds(289, 160, 48, 18);
         jPanelPlayRecord.add(jButtonSlowSpeed);
         
         JPanel jPanelDownload = new JPanel();
         jPanelDownload.setBounds(10, 338, 593, 114);
         jPanelDownload.setBorder(new TitledBorder(null, "Download Record", TitledBorder.LEADING, TitledBorder.TOP, null, null));
         jPanelDownload.setLayout(null);
         PlayBackByTimePanel.add(jPanelDownload);
         
         jButtonStartdownload = new JButton("StartDownload");
         jButtonStartdownload.setBounds(10, 46, 186, 23);
         jPanelDownload.add(jButtonStartdownload);
         
         jButtonStartdownloadByName = new JButton("StartDownloadByName");
         jButtonStartdownloadByName.setBounds(10, 79, 186, 23);
         jPanelDownload.add(jButtonStartdownloadByName);
         
         JButton jButtonStopdownload = new JButton("StopDownload");
         jButtonStopdownload.setBounds(206, 46, 186, 23);
         jPanelDownload.add(jButtonStopdownload);
         
         JButton jButtonStopdownloadByName = new JButton("StopDownloadByName");
         jButtonStopdownloadByName.setBounds(206, 79, 186, 23);
         jPanelDownload.add(jButtonStopdownloadByName);
         
         DownloadProgress = new JProgressBar();
         DownloadProgress.setBounds(10, 22, 573, 14);
         DownloadProgress.setStringPainted(true);
         jPanelDownload.add(DownloadProgress);
         
         JPanel PlayBackConfigRecord = new JPanel();
         tabPlayBackList.addTab("PlayBackMonthRecord", null, PlayBackConfigRecord, null);
         PlayBackConfigRecord.setLayout(null);
         
         JPanel panelPlayBackMonthRecord = new JPanel();
         panelPlayBackMonthRecord.setBorder(new TitledBorder(null, "Month Record", TitledBorder.LEADING, TitledBorder.TOP, null, null));
         panelPlayBackMonthRecord.setBounds(20, 20, 583, 429);
         panelPlayBackMonthRecord.setLayout(null);
         PlayBackConfigRecord.add(panelPlayBackMonthRecord);
		     
         JScrollPane scrollPaneRecordByMonthList = new JScrollPane();
         scrollPaneRecordByMonthList.setBounds(10, 73, 550, 328);
         panelPlayBackMonthRecord.add(scrollPaneRecordByMonthList);
		
         DefaultTableCellRenderer renderer=new DefaultTableCellRenderer();
         renderer.setHorizontalAlignment(JLabel.CENTER);
         tableRecordByMonthList = new JTable(); 
         tableRecordByMonthList.setModel(RecordByMonthTableModel);
         tableRecordByMonthList.setDefaultRenderer(Object.class,renderer);
         tableRecordByMonthList.setEnabled(false);
         scrollPaneRecordByMonthList.setViewportView(tableRecordByMonthList);

         jComboBoxPlayRecordMonth = new JComboBox<String>();
         jComboBoxPlayRecordMonth.setBounds(212, 26, 98, 23);
         jComboBoxPlayRecordMonth.addItem("January");
         jComboBoxPlayRecordMonth.addItem("February");
         jComboBoxPlayRecordMonth.addItem("March");
         jComboBoxPlayRecordMonth.addItem("April");
         jComboBoxPlayRecordMonth.addItem("May");
         jComboBoxPlayRecordMonth.addItem("June");
         jComboBoxPlayRecordMonth.addItem("July");
         jComboBoxPlayRecordMonth.addItem("August");
         jComboBoxPlayRecordMonth.addItem("September");
         jComboBoxPlayRecordMonth.addItem("October");
         jComboBoxPlayRecordMonth.addItem("November");
         jComboBoxPlayRecordMonth.addItem("December");
         jComboBoxPlayRecordMonth.setSelectedIndex(0);
         panelPlayBackMonthRecord.add(jComboBoxPlayRecordMonth);
		
		Date getLastYear=new Date();
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy");
		getLastYearString= sdf.format(getLastYear);	

		jTextFieldPlayBackRecordByMonthISYear = new JTextField();
		jTextFieldPlayBackRecordByMonthISYear.setBounds(104, 27, 66, 21);
		jTextFieldPlayBackRecordByMonthISYear.setColumns(10);
		jTextFieldPlayBackRecordByMonthISYear.setText(getLastYearString);
		panelPlayBackMonthRecord.add(jTextFieldPlayBackRecordByMonthISYear);
		
		JLabel lblPlayBackRecordISYear = new JLabel("Year");
		lblPlayBackRecordISYear.setBounds(40, 30, 54, 15);
		panelPlayBackMonthRecord.add(lblPlayBackRecordISYear);		         
		
		JButton jButtonQueryPlayBackRecordByMonth = new JButton("Query");
		jButtonQueryPlayBackRecordByMonth.setBounds(376, 26, 93, 23);
		panelPlayBackMonthRecord.add(jButtonQueryPlayBackRecordByMonth);
		
		JPanel DigitalZoomPlayBackDataPanel = new JPanel();
		DigitalZoomPlayBackDataPanel.setLayout(null);
		DigitalZoomPlayBackDataPanel.setBorder(BorderFactory.createTitledBorder("PlayBackDigitalZoom"));
		DigitalZoomPlayBackDataPanel.setBounds(10, 10, 309, 124);
		PlayBackConfig.add(DigitalZoomPlayBackDataPanel);

		JButton jButtonPlayBackSetDigitalZoom = new JButton("Set");
		jButtonPlayBackSetDigitalZoom.setBounds(43, 80, 93, 23);
		DigitalZoomPlayBackDataPanel.add(jButtonPlayBackSetDigitalZoom);
		
		JButton jButtonPlayBackExitDigitalZoom = new JButton("Exit");
		jButtonPlayBackExitDigitalZoom.setBounds(175, 80, 93, 23);
		DigitalZoomPlayBackDataPanel.add(jButtonPlayBackExitDigitalZoom );
		
		jTextFieldPlayBackDigitalZoomLeft  = new JTextField();
		jTextFieldPlayBackDigitalZoomLeft.setBounds(43, 28, 77, 19);
		jTextFieldPlayBackDigitalZoomLeft.setColumns(10);
		DigitalZoomPlayBackDataPanel.add(jTextFieldPlayBackDigitalZoomLeft);
		
		jTextFieldPlayBackDigitalZoomRight = new JTextField();
	    jTextFieldPlayBackDigitalZoomRight.setBounds(211, 28, 77, 19);
		jTextFieldPlayBackDigitalZoomRight.setColumns(10);
		DigitalZoomPlayBackDataPanel.add(jTextFieldPlayBackDigitalZoomRight);
		
		jTextFieldPlayBackDigitalZoomTop = new JTextField();
	    jTextFieldPlayBackDigitalZoomTop .setBounds(43, 51, 77, 19);
		jTextFieldPlayBackDigitalZoomTop .setColumns(10);
		DigitalZoomPlayBackDataPanel.add(jTextFieldPlayBackDigitalZoomTop);
		
		jTextFieldPlayBackDigitalZoomBottom = new JTextField();
		jTextFieldPlayBackDigitalZoomBottom.setBounds(211, 51, 77, 19);
		jTextFieldPlayBackDigitalZoomBottom.setColumns(10);
		DigitalZoomPlayBackDataPanel.add(jTextFieldPlayBackDigitalZoomBottom);

		JLabel lblPlayBackDigitalZoomLeft = new JLabel("Left");
		lblPlayBackDigitalZoomLeft.setBounds(10, 30, 24, 15);
		DigitalZoomPlayBackDataPanel.add(lblPlayBackDigitalZoomLeft);
	        
		JLabel lblPlayBackDigitalZoomTop = new JLabel("Top");
		lblPlayBackDigitalZoomTop.setBounds(10, 55, 54, 15);
		DigitalZoomPlayBackDataPanel.add(lblPlayBackDigitalZoomTop);

		JLabel lblPlayBackDigitalZoomRight = new JLabel("Right");
		lblPlayBackDigitalZoomRight.setBounds(150, 30, 51, 15);
		DigitalZoomPlayBackDataPanel.add(lblPlayBackDigitalZoomRight);

		JLabel lblPlayBackDigitalZoomBottom = new JLabel("Bottom");
		lblPlayBackDigitalZoomBottom.setBounds(150, 53, 54, 15);
		DigitalZoomPlayBackDataPanel.add(lblPlayBackDigitalZoomBottom);

		JPanel PlayLocalFile = new JPanel();
		PlayLocalFile.setBounds(10, 144, 593, 116);
		PlayLocalFile.setLayout(null);
		PlayLocalFile.setBorder(new TitledBorder(null, "PlayLocalFile", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		PlayBackConfig.add(PlayLocalFile);

		jTextFieldPlayLocalFile = new JTextField();
		jTextFieldPlayLocalFile.setBounds(82, 23, 318, 21);
        jTextFieldPlayLocalFile.setColumns(10);
        jTextFieldPlayLocalFile.setEditable(false);
        PlayLocalFile.add(jTextFieldPlayLocalFile);

        JButton jButtonOpenFile = new JButton("Open");
        jButtonOpenFile.setBounds(410, 22, 93, 23);
        PlayLocalFile.add(jButtonOpenFile);

        jButtonPlayLocalFile = new JButton("Play");
        jButtonPlayLocalFile.setBounds(82, 64, 93, 23);
        jButtonPlayLocalFile.setEnabled(true);
        PlayLocalFile.add(jButtonPlayLocalFile);

        JLabel lblLocalFile = new JLabel("Local file");
        lblLocalFile.setBounds(10, 26, 78, 15);
        PlayLocalFile.add(lblLocalFile);

        jButtonStopLocalFile = new JButton("Stop");
        jButtonStopLocalFile.setBounds(307, 64, 93, 23);
        jButtonStopLocalFile.setEnabled(false);
        PlayLocalFile.add(jButtonStopLocalFile);
    
        jButtonPlayLocalFilePause = new JButton("Pause");
        jButtonPlayLocalFilePause.setBounds(197, 64, 93, 23);
        PlayLocalFile.add(jButtonPlayLocalFilePause);

        JPanel RenderScalePlayBackDataPanel = new JPanel();
        RenderScalePlayBackDataPanel.setLayout(null);
        RenderScalePlayBackDataPanel.setBorder(BorderFactory.createTitledBorder("PlayBackRenderScale"));
        RenderScalePlayBackDataPanel.setBounds(329, 10, 274, 124);
        PlayBackConfig.add(RenderScalePlayBackDataPanel);

        jComboBoxPlayBackRenderScale = new JComboBox<String>();
        jComboBoxPlayBackRenderScale.setBounds(64, 51, 142, 23);
        jComboBoxPlayBackRenderScale.addItem("FULL");
        jComboBoxPlayBackRenderScale.addItem("PROPORTION");
        jComboBoxPlayBackRenderScale.setSelectedIndex(0);
        RenderScalePlayBackDataPanel.add(jComboBoxPlayBackRenderScale);
    
        JPanel panelRecordStatus = new JPanel();
        panelRecordStatus.setBounds(10, 270, 593, 181);
        panelRecordStatus.setBorder(new TitledBorder(null, "Record Status", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        PlayBackConfig.add(panelRecordStatus);
        panelRecordStatus.setLayout(null);
    
        JScrollPane scrollPaneRecordStatusList = new JScrollPane();
        scrollPaneRecordStatusList.setBounds(10, 20, 573, 118);
        panelRecordStatus.add(scrollPaneRecordStatusList);
    
        DefaultTableCellRenderer renderer2=new DefaultTableCellRenderer();
        renderer2.setHorizontalAlignment(JLabel.CENTER);
        tableRecordStatusList = new JTable();
        tableRecordStatusList.setModel(RecordStatusTableModel);
        tableRecordStatusList.setDefaultRenderer(Object.class,renderer2 );
        scrollPaneRecordStatusList.setViewportView(tableRecordStatusList);

        JButton jButtonGetRecordStatus = new JButton("Get");
        jButtonGetRecordStatus.setBounds(490, 148, 93, 23);
        panelRecordStatus.add(jButtonGetRecordStatus);   

	    JPanel jPanelVCA = new JPanel();
	    tabFunList.addTab("VCA", null, jPanelVCA, null);
	    jPanelVCA.setLayout(null);
	    
	    tabSmartList = new JTabbedPane(JTabbedPane.TOP);
        tabSmartList.setBounds(0, 0, 620, 485);
        jPanelVCA.add(tabSmartList);
        
        JPanel jPanelFace = new JPanel();
        tabSmartList.addTab("Face", null, jPanelFace, null);
        jPanelFace.setLayout(null);

        JTabbedPane tabFaceList = new JTabbedPane(JTabbedPane.TOP);
        tabFaceList.setBounds(0, 0, 615, 455);
        jPanelFace.add(tabFaceList);
        
        JPanel jPanelPersonLib = new JPanel();
        jPanelPersonLib.setToolTipText("");
        tabFaceList.addTab("PersonLib", null, jPanelPersonLib, null);
        jPanelPersonLib.setLayout(null);
        
        JPanel jPanelPersonLibManagee = new JPanel();
        jPanelPersonLibManagee.setBorder(new TitledBorder(null, "Person lib manage", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelPersonLibManagee.setBounds(0, 0, 134, 416);
        jPanelPersonLib.add(jPanelPersonLibManagee);
        jPanelPersonLibManagee.setLayout(null);

        jComboBoxPersonLib = new JComboBox<String>();
        jComboBoxPersonLib.setBounds(10, 22, 114, 32);
        jComboBoxPersonLib.setRenderer(new JComboBoxRenderer());
        jPanelPersonLibManagee.add(jComboBoxPersonLib);
        
        jButtonAddPersonLib = new JButton("Add");
        jButtonAddPersonLib.setBounds(20, 64, 93, 23);
        jPanelPersonLibManagee.add(jButtonAddPersonLib);
        
        JButton jButtonDeletePaersonLib = new JButton("Delete");
        jButtonDeletePaersonLib.setBounds(20, 110, 93, 23);
        jPanelPersonLibManagee.add(jButtonDeletePaersonLib);
        
        JButton jButtonModifyPersonLib = new JButton("Modify");
        jPanelPersonLibManagee.add(jButtonModifyPersonLib);
        jButtonModifyPersonLib.setBounds(20, 157, 93, 23);
        
        jButtonFindPersonLib = new JButton("Find");
        jButtonFindPersonLib.setBounds(20, 208, 93, 23);
        jPanelPersonLibManagee.add(jButtonFindPersonLib);
        
        JButton jButtonCapacity = new JButton("Capacity");
        jButtonCapacity.setBounds(20, 256, 93, 23);
        jPanelPersonLibManagee.add(jButtonCapacity);
        
        JPanel jPanelMersonManage = new JPanel();
        jPanelMersonManage.setBorder(new TitledBorder(null, "Person manage", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelMersonManage.setBounds(144, 0, 466, 426);
        jPanelPersonLib.add(jPanelMersonManage);
        jPanelMersonManage.setLayout(null);
        
        JScrollPane PersonScrollPane = new JScrollPane();
        PersonScrollPane.setBounds(10, 22, 456, 208);
        jPanelMersonManage.add(PersonScrollPane);
        
        jTablePerson = new JTable(PersonTableModel) {
            public boolean isCellEditable(int row,int column) {
                return false;
            }
        };
        jTablePerson.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jTablePerson.setModel(PersonTableModel);
        jTablePerson.getColumnModel().getColumn(0).setPreferredWidth(85);
        PersonScrollPane.setViewportView(jTablePerson);
        
        JButton jButtonModifyPerson = new JButton("Modify");
        jButtonModifyPerson.setBounds(253, 255, 93, 23);
        jPanelMersonManage.add(jButtonModifyPerson);
        
        JButton jButtonDeletePerson = new JButton("Delete");
        jButtonDeletePerson.setBounds(134, 255, 93, 23);
        jPanelMersonManage.add(jButtonDeletePerson);
        
        JButton jButtonAddPerson = new JButton("Add");
        jButtonAddPerson.setBounds(10, 255, 93, 23);
        
        jButtonFindPerson = new JButton("Find");
        jPanelMersonManage.add(jButtonAddPerson);
        jButtonFindPerson.setBounds(363, 255, 93, 23);
        jPanelMersonManage.add(jButtonFindPerson);
        
        JPanel jPanelPersonMonitor = new JPanel();
        tabFaceList.addTab("PersonMonitor", null, jPanelPersonMonitor, null);
        jPanelPersonMonitor.setLayout(null);
        
        JScrollPane jScrollPanePersionMonitor = new JScrollPane();
        jScrollPanePersionMonitor.setBounds(0, 0, 610, 249);
        jPanelPersonMonitor.add(jScrollPanePersionMonitor);
        
        PersonMonitorTable = new JTable(PersonMonitorTableModel) {
            public boolean isCellEditable(int row,int column) {
                return false;
            }
        };
        PersonMonitorTable.setModel(PersonMonitorTableModel);
        jScrollPanePersionMonitor.setViewportView(PersonMonitorTable);
        
        JButton jButtonAddPersonMonitor = new JButton("Add");
        jButtonAddPersonMonitor.setBounds(72, 269, 93, 23);
        jPanelPersonMonitor.add(jButtonAddPersonMonitor);
        
        JButton jButtonDeletePersonMonitor = new JButton("Delete");
        jButtonDeletePersonMonitor.setBounds(244, 269, 93, 23);
        jPanelPersonMonitor.add(jButtonDeletePersonMonitor);
        
        JButton jButtonModifyPersonMonitor = new JButton("Modify");
        jButtonModifyPersonMonitor.setBounds(438, 269, 93, 23);
        jPanelPersonMonitor.add(jButtonModifyPersonMonitor);
        
        jButtonEnablePersonMonitor = new JButton("Enable");
        jButtonShutDownPersonMonitor = new JButton("Disable");
        jButtonEnablePersonMonitor.setBounds(72, 318, 93, 23);
        jPanelPersonMonitor.add(jButtonEnablePersonMonitor);
        
        jButtonShutDownPersonMonitor.setBounds(244, 318, 93, 23);
        jPanelPersonMonitor.add(jButtonShutDownPersonMonitor);
        
        jButtonFindPersonMonitor = new JButton("Find");
        jButtonFindPersonMonitor.setBounds(438, 318, 93, 23);
        jPanelPersonMonitor.add(jButtonFindPersonMonitor);
        
        JPanel jPanelPersonDataReport = new JPanel();
        tabFaceList.addTab("DataReport", null, jPanelPersonDataReport, null);
        jPanelPersonDataReport.setLayout(null);

        JPanel jPanelPersonMatch = new JPanel();
        jPanelPersonMatch.setBounds(10, 10, 280, 410);
        jPanelPersonMatch.setBorder(new TitledBorder(null, "Person match and not match", TitledBorder.LEADING, TitledBorder.TOP, null, Color.BLACK));
        jPanelPersonMatch.setLayout(null);
        jPanelPersonDataReport.add(jPanelPersonMatch);

        JButton jButtonRegisterPersonAlarm = new JButton("Register");
        jButtonRegisterPersonAlarm.setBounds(20, 20, 93, 23);
        jPanelPersonMatch.add(jButtonRegisterPersonAlarm);

        JButton jButtonCancelRegisterPersonAlarm = new JButton("Cancel");
        jButtonCancelRegisterPersonAlarm.setBounds(165, 20, 93, 23);
        jPanelPersonMatch.add(jButtonCancelRegisterPersonAlarm);
            
        JPanel jPanelPersonRecognize = new JPanel();
        jPanelPersonRecognize.setBounds(300, 10, 280, 410);
        jPanelPersonRecognize.setLayout(null);  
        jPanelPersonRecognize.setBorder(new TitledBorder(null, "Person recognize", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelPersonDataReport.add(jPanelPersonRecognize);
        
        JPanel PersonAlarmRecordPanel = new JPanel();
        tabFaceList.addTab("AlarmRecord", null, PersonAlarmRecordPanel, null);
        PersonAlarmRecordPanel.setLayout(null);

        PersonAlarmRecordPanel.add(jPanelAlarm1);
        jPanelAlarm1.setBounds(70, 48, 207, 30);
        PeopleAlarmStartTime.setBounds(25, 5, 156, 21);
        jPanelAlarm1.add(PeopleAlarmStartTime);
        
        PersonAlarmRecordPanel.add(jPanelAlarm2);
        jPanelAlarm2.setBounds(300, 48, 207, 30);
        PeopleAlarmEndTime.setBounds(25, 5, 156, 21);
        jPanelAlarm2.add(PeopleAlarmEndTime);
        
        JButton jButtonPersonAlarmFind = new JButton("Query");
        jButtonPersonAlarmFind.setBounds(527, 52, 73, 23);
        PersonAlarmRecordPanel.add(jButtonPersonAlarmFind);
        
        JButton jButtonFindPersonPassAlarmRecord = new JButton("Query");
        jButtonFindPersonPassAlarmRecord.setBounds(534, 56, 70, 23);
        JPanel jPanelPersonPassRecord = new JPanel();
        jPanelPersonPassRecord.add(jButtonFindPersonPassAlarmRecord);
        
        JButton jButtonCancelPersonRecognize = new JButton("Cancel");
        jButtonCancelPersonRecognize.setBounds(165, 20, 93, 23);
        jPanelPersonRecognize.add(jButtonCancelPersonRecognize);
        
        JButton jButtonRegistPersonRecognize = new JButton("Register");
        jButtonRegistPersonRecognize.setBounds(20, 20, 93, 23);
        jPanelPersonRecognize.add(jButtonRegistPersonRecognize);

        JLabel jLabelPersonMonitorType = new JLabel("MonitorType:");
        jLabelPersonMonitorType.setBounds(10, 10, 75, 28);
        PersonAlarmRecordPanel.add(jLabelPersonMonitorType);
        
        jComboBoxPersonMonitorType = new JComboBox<Object>();
        jComboBoxPersonMonitorType.setModel(
                new DefaultComboBoxModel<Object>(new String[] {"Match", "Not match"}));
        jComboBoxPersonMonitorType.setBounds(112, 14, 94, 24);
        PersonAlarmRecordPanel.add(jComboBoxPersonMonitorType);

        JLabel jLabelPersonAlarmTime = new JLabel("AlarmTime:");
        jLabelPersonAlarmTime.setBounds(10, 56, 66, 15);
        PersonAlarmRecordPanel.add(jLabelPersonAlarmTime);
        
        JLabel jLabelSymbol = new JLabel("——");
        jLabelSymbol.setBounds(274, 55, 32, 15);
        PersonAlarmRecordPanel.add(jLabelSymbol);
        
        tabFaceList.addTab("PassRecord", null, jPanelPersonPassRecord, null);
        jPanelPersonPassRecord.setLayout(null);
        
        jPanelPersonPassRecord.add(jPanelPeoplePass1);
        jPanelPeoplePass1.setBounds(74, 51, 207, 30);
        PeoplePassStartTime.setBounds(25, 5, 156, 21);
        jPanelPeoplePass1.add(PeoplePassStartTime);

        jPanelPersonPassRecord.add(jPanelPeoplePass2);
        jPanelPeoplePass2.setBounds(317, 51, 207, 30);
        PeoplePassEndTime.setBounds(25, 5, 156, 21);
        jPanelPeoplePass2.add(PeoplePassEndTime);

        JLabel jLabelPersonPassTime = new JLabel("Alarm time:");
        jLabelPersonPassTime.setBounds(10, 61, 66, 15);
        jPanelPersonPassRecord.add(jLabelPersonPassTime);

        JLabel jLabelSymbol2 = new JLabel("——");
        jLabelSymbol2.setBounds(286, 59, 30, 15);
        jPanelPersonPassRecord.add(jLabelSymbol2);

        JLabel jLabelPersonPassAlarmSource = new JLabel("Alarm source:");
        jLabelPersonPassAlarmSource.setBounds(10, 13, 90, 15);
        jPanelPersonPassRecord.add(jLabelPersonPassAlarmSource);

        jTextFieldPersonPassAlarmSource = new JTextField();
        jTextFieldPersonPassAlarmSource.setColumns(10);
        jTextFieldPersonPassAlarmSource.setBounds(110, 10, 168, 21);
        jPanelPersonPassRecord.add(jTextFieldPersonPassAlarmSource);

        JPanel jPanelVehicle = new JPanel();
        tabSmartList.addTab("Vehicle", null, jPanelVehicle, null);
        jPanelVehicle.setLayout(null);

        JTabbedPane tabVehicleList = new JTabbedPane(JTabbedPane.TOP);
        tabVehicleList.setBounds(0, 0, 615, 460);
        jPanelVehicle.add(tabVehicleList);

        JPanel VehicleLibPanel = new JPanel();
        tabVehicleList.addTab("VehicleLib", null, VehicleLibPanel, null);
        VehicleLibPanel.setLayout(null);
        
        JPanel jPanelVehicleLibManage = new JPanel();
        jPanelVehicleLibManage.setBorder(new TitledBorder(null, "Vehicle lib manage", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelVehicleLibManage.setBounds(0, 0, 130, 431);
        jPanelVehicleLibManage.setLayout(null);
        VehicleLibPanel.add(jPanelVehicleLibManage);
        
        jComboBoxVehicleLib = new JComboBox<String>();
        jComboBoxVehicleLib.setBounds(10, 30, 110, 21);
        jComboBoxVehicleLib.setRenderer(new JComboBoxRenderer());
        jPanelVehicleLibManage.add(jComboBoxVehicleLib);
        
        JButton jButtonVehicleLibAdd = new JButton("Add");
        jButtonVehicleLibAdd.setBounds(23, 76, 81, 23);
        jPanelVehicleLibManage.add(jButtonVehicleLibAdd);

        JButton jButtonVehicleLibDelete = new JButton("Delete");
        jButtonVehicleLibDelete .setBounds(23, 119, 81, 23);
        jPanelVehicleLibManage.add(jButtonVehicleLibDelete);
        
        JButton jButtonVehicleLibModify = new JButton("Modify");
        jButtonVehicleLibModify.setBounds(23, 165, 81, 23);
        jPanelVehicleLibManage.add(jButtonVehicleLibModify);

        jButtonVehicleLibFind = new JButton("Find");
        jButtonVehicleLibFind.setBounds(23, 216, 81, 23);
        jPanelVehicleLibManage.add(jButtonVehicleLibFind);
        
        JPanel jPanelVehicleManage = new JPanel();
        jPanelVehicleManage.setBorder(new TitledBorder(null, "Vehicle manage", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelVehicleManage.setBounds(140, 0, 470, 431);
        VehicleLibPanel.add(jPanelVehicleManage);
        jPanelVehicleManage.setLayout(null);

        JScrollPane VehicleScrollPane = new JScrollPane();
        VehicleScrollPane.setBounds(0, 20, 470, 252);
        jPanelVehicleManage.add(VehicleScrollPane);

        VehicleTable = new JTable();
        VehicleTable.setModel(VehicleTableModle);
        VehicleScrollPane.setViewportView(VehicleTable);
        
        JButton jButtonAddVehicle = new JButton("Add");
        jButtonAddVehicle.setBounds(10, 287, 93, 23);
        jPanelVehicleManage.add(jButtonAddVehicle);
        
        JButton jButtonDeleteVehicle = new JButton("Delete");
        jButtonDeleteVehicle.setBounds(115, 287, 93, 23);
        jPanelVehicleManage.add(jButtonDeleteVehicle);
        JButton jButtonVehicleModify = new JButton("Modify");
        jButtonVehicleModify.setBounds(223, 287, 93, 23);
        jPanelVehicleManage.add(jButtonVehicleModify);
        
        jButtonVehicleFind = new JButton("Find");
        jButtonVehicleFind.setBounds(340, 287, 93, 23);
        jPanelVehicleManage.add(jButtonVehicleFind);
 
        JLabel jLabelBatchTransfer = new JLabel("Batch Transfer:");
        jLabelBatchTransfer.setBounds(10, 334, 99, 15);
        jPanelVehicleManage.add(jLabelBatchTransfer);
        
        JLabel jLabelBatchCancel = new JLabel("Batch  Cancel:");
        jLabelBatchCancel.setBounds(237, 330, 93, 23);
        jPanelVehicleManage.add(jLabelBatchCancel);
        
        JPanel jPanelVehicleMonitor = new JPanel();
        tabVehicleList.addTab("VehicleMonitor", null, jPanelVehicleMonitor, null);
        jPanelVehicleMonitor.setLayout(null);

        JScrollPane VehicleMonitorScrollPane = new JScrollPane();
        VehicleMonitorScrollPane.setBounds(0, 0, 610, 205);
        jPanelVehicleMonitor.add(VehicleMonitorScrollPane);

        jTableVehicleMonitor = new JTable();
        jTableVehicleMonitor.setModel(VehicleMonitorTableModel);
        VehicleMonitorScrollPane.setViewportView(jTableVehicleMonitor);
        
        JButton jButtonAddVehicleMonitor = new JButton("Add");
        jButtonAddVehicleMonitor.setBounds(78, 223, 93, 23);
        jPanelVehicleMonitor.add(jButtonAddVehicleMonitor);
        
        JButton jButtonDeleteVehicleMonitor = new JButton("Delete");
        jButtonDeleteVehicleMonitor.setBounds(259, 223, 93, 23);
        jPanelVehicleMonitor.add(jButtonDeleteVehicleMonitor);

        JButton jButtonModifyVehicleMonitor = new JButton("Modify");
        jButtonModifyVehicleMonitor.setBounds(421, 223, 93, 23);
        jPanelVehicleMonitor.add(jButtonModifyVehicleMonitor);
        
        jButtonFindVehicleMonitor = new JButton("Find"); 
        jButtonFindVehicleMonitor.setBounds(421, 267, 93, 23);
        jPanelVehicleMonitor.add(jButtonFindVehicleMonitor);
        
        JButton jButtonEnableVehicleMonitor = new JButton("Enable");
        jButtonEnableVehicleMonitor.setBounds(78, 267, 93, 23);
        jPanelVehicleMonitor.add(jButtonEnableVehicleMonitor);
        
        JButton jButtonDiaableVehicleMonitor = new JButton("Disable");
        jButtonDiaableVehicleMonitor.setBounds(259, 267, 93, 23);
        jPanelVehicleMonitor.add(jButtonDiaableVehicleMonitor);
        
        JPanel jPanelVehicleAlarmReport = new JPanel();
        tabVehicleList.addTab("VehicleAlarm", null, jPanelVehicleAlarmReport, null);
        jPanelVehicleAlarmReport.setLayout(null);
        
        JPanel jPanelVehicleMatchOrNotMatch = new JPanel();
        jPanelVehicleMatchOrNotMatch.setBorder(new TitledBorder(null, "Vehicle match and not match", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelVehicleMatchOrNotMatch.setBounds(10, 10, 280, 410);
        jPanelVehicleAlarmReport.add(jPanelVehicleMatchOrNotMatch);
        jPanelVehicleMatchOrNotMatch.setLayout(null);
        
        JButton jButtonRegisterVehicleMatch = new JButton("Register");
        jButtonRegisterVehicleMatch.setBounds(20, 20, 93, 23);
        jPanelVehicleMatchOrNotMatch.add(jButtonRegisterVehicleMatch);
        
        JButton jButtonCancelVehicleMatch = new JButton("Cancel");
        jButtonCancelVehicleMatch.setBounds(165, 20, 93, 23);
        jPanelVehicleMatchOrNotMatch.add(jButtonCancelVehicleMatch);
        
        JPanel jPanelVehicleStructAlarm = new JPanel();
        jPanelVehicleStructAlarm.setBorder(new TitledBorder(null, "Vehicle alarm", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelVehicleStructAlarm.setBounds(300, 10, 300, 410);
        jPanelVehicleAlarmReport.add(jPanelVehicleStructAlarm);
        jPanelVehicleStructAlarm.setLayout(null);
        
        JButton jButtonRegisterVehicleAlarm = new JButton("Register");
        jButtonRegisterVehicleAlarm.setBounds(20, 20, 93, 23);
        jPanelVehicleStructAlarm.add(jButtonRegisterVehicleAlarm);
        
        JButton jButtonCancelVehicleAlarm = new JButton("Cancel");
        jButtonCancelVehicleAlarm.setBounds(175, 20, 93, 23);
        jPanelVehicleStructAlarm.add(jButtonCancelVehicleAlarm);
        
        JPanel jPanelVehicleAlarmRecord = new JPanel();
        tabVehicleList.addTab("VehicleAlarmRecord", null, jPanelVehicleAlarmRecord, null);
        jPanelVehicleAlarmRecord.setLayout(null);
        
        jPanelAlarmVehicle.setBounds(51, 142, 207, 30);
        jPanelVehicleAlarmRecord.add(jPanelAlarmVehicle);
        
        VehicleAlarmStartTime.setBounds(25, 5, 156, 21);
        jPanelAlarmVehicle.add(VehicleAlarmStartTime);
        
        jPanelAlarmVehicle2.setBounds(306, 142, 207, 30);
        jPanelVehicleAlarmRecord.add(jPanelAlarmVehicle2);
       
        VehicleAlarmEndTime.setBounds(25, 5, 156, 21);
        jPanelAlarmVehicle2.add(VehicleAlarmEndTime);
        
        JLabel jLabelVehicleAlarmMonitorType = new JLabel("MinitorType:");
        jLabelVehicleAlarmMonitorType.setBounds(10, 7, 72, 21);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmMonitorType);
        
        jComboBoxVehicleAlarmMonitorType = new JComboBox<Object>();
        jComboBoxVehicleAlarmMonitorType.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"match", "not match"}));
        jComboBoxVehicleAlarmMonitorType.setBounds(97, 7, 90, 21);
        jPanelVehicleAlarmRecord.add(jComboBoxVehicleAlarmMonitorType);
        
        JLabel jLabelVehicleAlarmFindTime = new JLabel("Time:");
        jLabelVehicleAlarmFindTime.setBounds(10, 146, 41, 15);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmFindTime);
        
        JLabel jLabelSymbol3 = new JLabel("——");
        jLabelSymbol3.setBounds(270, 148, 28, 15);
        jPanelVehicleAlarmRecord.add(jLabelSymbol3);
        
        JLabel jLabelVehicleAlarmBayonetName = new JLabel("BayonetName:");
        jLabelVehicleAlarmBayonetName.setBounds(10, 49, 87, 18);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmBayonetName);
        
        jTextFieldVehicleAlarmBayonetName = new JTextField();
        jTextFieldVehicleAlarmBayonetName.setBounds(97, 48, 113, 21);
        jTextFieldVehicleAlarmBayonetName.setColumns(10);
        jPanelVehicleAlarmRecord.add(jTextFieldVehicleAlarmBayonetName);
        
        JLabel jLabelVehicleAlarmPlateNumber = new JLabel("PlateNumber:");
        jLabelVehicleAlarmPlateNumber.setBounds(10, 100, 86, 15);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmPlateNumber);
        
        jTextFieldVehicleAlarmPlateNumber = new JTextField();
        jTextFieldVehicleAlarmPlateNumber.setBounds(97, 97, 113, 21);
        jTextFieldVehicleAlarmPlateNumber.setColumns(10);
        jPanelVehicleAlarmRecord.add(jTextFieldVehicleAlarmPlateNumber);
        
        JLabel jLabelVehicleAlarmPlateColor = new JLabel("PlateColor:");
        jLabelVehicleAlarmPlateColor.setBounds(253, 102, 82, 15);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmPlateColor);
        
        jComboBoxVehicleAlarmPlateColor = new JComboBox<Object>();
        jComboBoxVehicleAlarmPlateColor.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"OTHER", "BLACK", "WHITE", "GRAY", "RED", "BLUE", "YELLOW", "ORANGE", "BROWN", "GREEN", "PURPLE", "CYAN", "PINK", "TRANSPARENT", "SILVERYWHITE", "DARK", "LIGHT", "COLOURLESS", "YELLOWGREEN", "GRADUALGREEN"}));
        jComboBoxVehicleAlarmPlateColor.setBounds(353, 97, 160, 21);
        jPanelVehicleAlarmRecord.add(jComboBoxVehicleAlarmPlateColor);
        
        JLabel jLabelVehicleAlarmCarColor = new JLabel("CarColor:");
        jLabelVehicleAlarmCarColor.setBounds(253, 9, 60, 15);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmCarColor);
        
        jComboBoxVehicleAlarmCarColor = new JComboBox<Object>();
        jComboBoxVehicleAlarmCarColor.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"OTHER", "BLACK", "WHITE", "GRAY", "RED", "BLUE", "YELLOW", "ORANGE", "BROWN", "GREEN", "PURPLE", "CYAN", "PINK", "TRANSPARENT", "SILVERYWHITE", "DARK", "LIGHT", "COLOURLESS", "YELLOWGREEN", "GRADUALGREEN"}));
        jComboBoxVehicleAlarmCarColor.setBounds(353, 7, 160, 21);
        jPanelVehicleAlarmRecord.add(jComboBoxVehicleAlarmCarColor);
        
        JLabel jLabelVehicleAlarmMonitorReason = new JLabel("MonitorReason:");
        jLabelVehicleAlarmMonitorReason.setBounds(253, 51, 102, 15);
        jPanelVehicleAlarmRecord.add(jLabelVehicleAlarmMonitorReason);
        
        jComboBoxVehicleAlarmMonitorReason = new JComboBox<Object>();
        jComboBoxVehicleAlarmMonitorReason.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"OTHER", "Robbed car", "Stolen car", "Suspected vehicle", "Illegal vehicles", "Emergency check and control vehicle"}));
        jComboBoxVehicleAlarmMonitorReason.setBounds(353, 49, 160, 21);
        jPanelVehicleAlarmRecord.add(jComboBoxVehicleAlarmMonitorReason);
        
        JButton jButtonQueryVehicleAlarm = new JButton("Query");
        jButtonQueryVehicleAlarm.setBounds(525, 149, 75, 23);
        jPanelVehicleAlarmRecord.add(jButtonQueryVehicleAlarm);
        
        JPanel jPanelVehiclePassRecord = new JPanel();
        tabVehicleList.addTab("VehiclePassRecord", null, jPanelVehiclePassRecord, null);
        jPanelVehiclePassRecord.setLayout(null);
        
        jPanelPassVehicle.setBounds(104, 12, 200, 30);
        jPanelVehiclePassRecord.add(jPanelPassVehicle);
      
        VehiclePassStartTime.setBounds(25, 5, 156, 21);
        jPanelPassVehicle.add(VehiclePassStartTime);
        
        jPanelPassVehicle2.setBounds(354, 12, 207, 30);
        jPanelVehiclePassRecord.add(jPanelPassVehicle2);
        
        VehiclePassEndTime.setBounds(25, 5, 156, 21);
        jPanelPassVehicle2.add(VehiclePassEndTime);
        
        JLabel jLabelVehicleRecordPassTime = new JLabel("Query time:");
        jLabelVehicleRecordPassTime.setBounds(10, 20, 84, 15);
        jPanelVehiclePassRecord.add(jLabelVehicleRecordPassTime);
        
        JLabel jLabelSymbol4 = new JLabel("——");
        jLabelSymbol4.setBounds(316, 18, 32, 15);
        jPanelVehiclePassRecord.add(jLabelSymbol4);
        
        JButton jButtonQueryVehiclePassRecord = new JButton("Query");
        jButtonQueryVehiclePassRecord.setBounds(278, 175, 95, 23);
        jPanelVehiclePassRecord.add(jButtonQueryVehiclePassRecord);
        
        JLabel jLabelVehicleRecordVayonetName = new JLabel("BayonetName:");
        jLabelVehicleRecordVayonetName.setBounds(10, 177, 83, 15);
        jPanelVehiclePassRecord.add(jLabelVehicleRecordVayonetName);
        
        jTextFieldVehicleRecordVayonetName = new JTextField();
        jTextFieldVehicleRecordVayonetName.setBounds(104, 175, 124, 21);
        jTextFieldVehicleRecordVayonetName.setColumns(10);
        jPanelVehiclePassRecord.add(jTextFieldVehicleRecordVayonetName);
       
        JLabel jLabelVehicleRecordPlateNumber = new JLabel("PlateNumber:");
        jLabelVehicleRecordPlateNumber.setBounds(10, 136, 84, 15);
        jPanelVehiclePassRecord.add(jLabelVehicleRecordPlateNumber);
        
        jTextFieldVehicleRecordPlateNumber = new JTextField();
        jTextFieldVehicleRecordPlateNumber.setBounds(104, 134, 124, 21);
        jTextFieldVehicleRecordPlateNumber.setColumns(10);
        jPanelVehiclePassRecord.add(jTextFieldVehicleRecordPlateNumber);
       
        JLabel jLabelVehiclePassPlateColor = new JLabel("PlateColor:");
        jLabelVehiclePassPlateColor.setBounds(10, 54, 66, 15);
        jPanelVehiclePassRecord.add(jLabelVehiclePassPlateColor);
        
        jComboBoxVehiclePassPlateColor = new JComboBox<Object>();
        jComboBoxVehiclePassPlateColor.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"OTHER", "BLACK", "WHITE", "GRAY", "RED", "BLUE", "YELLOW", "ORANGE", "BROWN", "GREEN", "PURPLE", "CYAN", "PINK", "TRANSPARENT", "SILVERYWHITE", "DARK", "LIGHT", "COLOURLESS", "YELLOWGREEN", "GRADUALGREEN"}));
        jComboBoxVehiclePassPlateColor.setBounds(104, 52, 124, 21);
        jPanelVehiclePassRecord.add(jComboBoxVehiclePassPlateColor);
        
        JLabel jLabelVehiclePassRecordCarColor = new JLabel("CarColor:");
        jLabelVehiclePassRecordCarColor.setBounds(10, 94, 54, 15);
        jPanelVehiclePassRecord.add(jLabelVehiclePassRecordCarColor);
        
        jComboBoxVehiclePassRecordCarColor = new JComboBox<Object>();
        jComboBoxVehiclePassRecordCarColor.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"OTHER", "BLACK", "WHITE", "GRAY", "RED", "BLUE", "YELLOW", "ORANGE", "BROWN", "GREEN", "PURPLE", "CYAN", "PINK", "TRANSPARENT", "SILVERYWHITE", "DARK", "LIGHT", "COLOURLESS", "YELLOWGREEN", "GRADUALGREEN"}));
        jComboBoxVehiclePassRecordCarColor.setBounds(104, 92, 124, 21);
        jPanelVehiclePassRecord.add(jComboBoxVehiclePassRecordCarColor);

        JButton jButtonAddVechileSendLibMember = new JButton("Add");
        jButtonAddVechileSendLibMember.setBounds(115, 330, 93, 23);
        jPanelVehicleManage.add(jButtonAddVechileSendLibMember);
        
        JButton jButtonDeleteVehicleListSend = new JButton("Delete");
        jButtonDeleteVehicleListSend.setBounds(340, 330, 93, 23);
        jPanelVehicleManage.add(jButtonDeleteVehicleListSend);
				
        jButtonRemoveSameCar = new JButton("Remove");
		jButtonRemoveSameCar.setBounds(115, 384, 93, 23);
		jButtonRemoveSameCar.setVisible(false);
		jPanelVehicleManage.add(jButtonRemoveSameCar);
		
		JPanel jPanelAccessControl = new JPanel();
        jPanelAccessControl.setToolTipText("");
        tabSmartList.addTab("AccessControl", null, jPanelAccessControl, null);
        jPanelAccessControl.setLayout(null);

        JTabbedPane AccessControlList = new JTabbedPane(JTabbedPane.TOP);
        AccessControlList.setToolTipText("");
        AccessControlList.setBounds(0, 0, 615, 456);
        jPanelAccessControl.add(AccessControlList);

        JPanel jPanelAccessControlDataReport = new JPanel();
        AccessControlList.addTab("DataReport", null, jPanelAccessControlDataReport, null);
        
        JButton jButtonSubscibeAlarm = new JButton("Subscribe Alarm");
        jPanelAccessControlDataReport.add(jButtonSubscibeAlarm);
        
        JButton jButtonUnSubscibeAlarm = new JButton("Unsubscribe Alarm");
        jPanelAccessControlDataReport.add(jButtonUnSubscibeAlarm);
        
        JPanel jPanelPeoplFindACS = new JPanel();
        AccessControlList.addTab("ACS", null, jPanelPeoplFindACS, null);
        jPanelPeoplFindACS.setLayout(null);
       
        jPanelBeginDate.setBounds(66, 25, 200, 30);
        jPanelPeoplFindACS.add(jPanelBeginDate);
        jPanelEndDate.setBounds(316, 25, 207, 30);
        jPanelPeoplFindACS.add(jPanelEndDate);
        jPanelBeginDate.add(BeginAcsDate);
        jPanelEndDate.add(EndAcsDate);
        
        jTableACS = new JTable();
        jTableACS.setBounds(30, 140, 400, 100);
        JScrollPane scrollACSTable = new JScrollPane(jTableACS,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        scrollACSTable.setBounds(10, 58, 594, 124);
        jPanelPeoplFindACS.add(scrollACSTable);
        
        RecordHeaderNames = new Vector<>();
        RecordHeaderNames.add("NO");
        RecordHeaderNames.add("UserName");
        RecordHeaderNames.add("Alarm Time");
        RecordHeaderNames.add("Door Name");
        RecordHeaderNames.add("Direction");
        RecordHeaderNames.add("Temperature");
        ACSTableModel = new DefaultTableModel(RecordHeaderNames,0);
        jTableACS.setModel(ACSTableModel);
        
        jTableVisitorACS = new JTable();
        jTableVisitorACS.setBounds(30, 140, 400, 600);
        JScrollPane scrollVisitorACSTable = new JScrollPane(jTableVisitorACS,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        scrollVisitorACSTable.setBounds(10, 270, 594, 124);
        jPanelPeoplFindACS.add(scrollVisitorACSTable);
       
        HeaderNames = new Vector<>(); 
        HeaderNames.add("NO");
        HeaderNames.add("Visitor's Name");
        HeaderNames.add("Phone");
        HeaderNames.add("Organization");
        HeaderNames.add("Person to visit");
        HeaderNames.add("Dept");
        VisitorACSTableModel = new DefaultTableModel(HeaderNames,0);
        jTableVisitorACS.setModel(VisitorACSTableModel);
        
        JButton jButtonSearchVisitorRecord = new JButton("Search");
        jButtonSearchVisitorRecord.setBounds(276, 241, 93, 23);
        jPanelPeoplFindACS.add(jButtonSearchVisitorRecord);
    
        jTextFieldACSRecord = new JTextField();
        jTextFieldACSRecord.setBounds(573, 193, 27, 21);
        jTextFieldACSRecord.setColumns(10);
        jPanelPeoplFindACS.add(jTextFieldACSRecord);
        
        jButtonACSRecordsPre = new JButton("Pre");
        jButtonACSRecordsPre.setBounds(305, 192, 93, 23);
        jPanelPeoplFindACS.add(jButtonACSRecordsPre);
        jButtonACSRecordsPre.setEnabled(false);
        
        jButtonACSRecordsNext = new JButton("Next");
        jButtonACSRecordsNext.setBounds(408, 192, 93, 23);
        jPanelPeoplFindACS.add(jButtonACSRecordsNext);
        jButtonACSRecordsNext.setEnabled(false);
        
        jButtonACSRecordsGo = new JButton("Go");
        jButtonACSRecordsGo.setBounds(513, 192, 50, 23);
        jButtonACSRecordsGo.setEnabled(false);
        jPanelPeoplFindACS.add(jButtonACSRecordsGo);
        
        JButton jButtonSearchAccessRecord = new JButton("Search");
        jButtonSearchAccessRecord.setBounds(526, 28, 78, 23);
        jPanelPeoplFindACS.add(jButtonSearchAccessRecord);

        jButtonVisitorRecordPre = new JButton("Pre");
        jButtonVisitorRecordPre.setBounds(305, 400, 93, 23);
        jButtonVisitorRecordPre.setEnabled(false);
        jPanelPeoplFindACS.add(jButtonVisitorRecordPre);
        
        jButtonVisitorRecordGo = new JButton("Go");
        jButtonVisitorRecordGo.setBounds(513, 400, 50, 23);
        jButtonVisitorRecordGo.setEnabled(false);
        jPanelPeoplFindACS.add(jButtonVisitorRecordGo);

        jButtonVisitorRecordNext = new JButton("Next");
        jButtonVisitorRecordNext.setBounds(408, 400, 93, 23);
        jButtonVisitorRecordNext.setEnabled(false);
        jPanelPeoplFindACS.add(jButtonVisitorRecordNext);
        
        jTextFieldGetVisitorACSRecord = new JTextField();
        jTextFieldGetVisitorACSRecord.setBounds(573, 400, 27, 21);
        jTextFieldGetVisitorACSRecord.setColumns(10);
        jPanelPeoplFindACS.add(jTextFieldGetVisitorACSRecord);

        jTextFieldGetVisitorName = new JTextField();
        jTextFieldGetVisitorName.setBounds(86, 242, 180, 21);
        jTextFieldGetVisitorName.setColumns(10);
        jPanelPeoplFindACS.add(jTextFieldGetVisitorName);
        
        JLabel jLabelVisitorName = new JLabel("Visitor Name");
        jLabelVisitorName.setBounds(10, 245, 81, 15);
        jPanelPeoplFindACS.add(jLabelVisitorName);
        
        JLabel jLabelStartTime = new JLabel("StartTime");
        jLabelStartTime.setBounds(10, 31, 59, 15);
        jPanelPeoplFindACS.add(jLabelStartTime);
        
        Date nowDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(nowDate);
        cal.add(Calendar.DATE,-1);
        
        JLabel jLabelEndtime_1 = new JLabel("EndTime");
        jLabelEndtime_1.setBounds(266, 31, 49, 15);
        jPanelPeoplFindACS.add(jLabelEndtime_1);
        
        JLabel jLabelAccessRecords = new JLabel("Access Records");
        jLabelAccessRecords.setForeground(Color.RED);
        jLabelAccessRecords.setBounds(10, 6, 105, 15);
        jPanelPeoplFindACS.add(jLabelAccessRecords);
        
        JLabel jLabelVisitorRecords = new JLabel("Visitor Records");
        jLabelVisitorRecords.setForeground(Color.RED);
        jLabelVisitorRecords.setBounds(10, 224, 94, 15);
        jPanelPeoplFindACS.add(jLabelVisitorRecords);
        
        jTextFieldCountPageSize = new JTextField();
        jTextFieldCountPageSize.setBounds(86, 193, 36, 21);
        jTextFieldCountPageSize.setColumns(10);
        jTextFieldCountPageSize.setEnabled(false);
        jPanelPeoplFindACS.add(jTextFieldCountPageSize);
        
        JLabel jLabelPagecount = new JLabel("PageCount:");
        jLabelPagecount.setBounds(10, 196, 66, 15);
        jPanelPeoplFindACS.add(jLabelPagecount);
        
        jTextFieldVisitorPageCount = new JTextField();
        jTextFieldVisitorPageCount.setBounds(86, 400, 36, 21);
        jTextFieldVisitorPageCount.setColumns(10);
        jTextFieldVisitorPageCount.setEnabled(false);
        jPanelPeoplFindACS.add(jTextFieldVisitorPageCount);
        
        JLabel jLabelVisitorPagecount = new JLabel("PageCount:");
        jLabelVisitorPagecount.setBounds(10, 404, 72, 15);
        jPanelPeoplFindACS.add(jLabelVisitorPagecount);

        JPanel jPanelPeopleCounting = new JPanel();
        tabSmartList.addTab("People Counting", null, jPanelPeopleCounting, null);
        jPanelPeopleCounting.setLayout(null);
        JTabbedPane jTabbedPanePerpleCounting = new JTabbedPane(JTabbedPane.TOP);
        jTabbedPanePerpleCounting.setBounds(0, 0, 615, 466);
        jPanelPeopleCounting.add(jTabbedPanePerpleCounting);
        
        JPanel jPanelPeopleCountingVMSNVR = new JPanel();
        jTabbedPanePerpleCounting.addTab("NVR/VMS", null, jPanelPeopleCountingVMSNVR, null);
        jPanelPeopleCountingVMSNVR.setLayout(null);
        
        JTabbedPane jTabbedPeopleCountingVMSNVR = new JTabbedPane(JTabbedPane.TOP);
        jTabbedPeopleCountingVMSNVR.setBounds(0, 0, 610, 437);
        jPanelPeopleCountingVMSNVR.add(jTabbedPeopleCountingVMSNVR);
        
        JPanel jPanelPeopleCountingVMSNVRRealTime = new JPanel();
        jTabbedPeopleCountingVMSNVR.addTab("RealTime", null, jPanelPeopleCountingVMSNVRRealTime, null);
        jPanelPeopleCountingVMSNVRRealTime.setLayout(null);
        
        JScrollPane jScrollPanePeopleCountingVMSNVRRealTime = new JScrollPane();
        jScrollPanePeopleCountingVMSNVRRealTime.setBounds(10, 10, 585, 317);
        jPanelPeopleCountingVMSNVRRealTime.add(jScrollPanePeopleCountingVMSNVRRealTime);
        jTablePeopleCountingVMSNVRRealTime = new JTable();
        jTablePeopleCountingVMSNVRRealTime.setModel(PeopleCountingVMSNVRRealTimeTableModel);
        jScrollPanePeopleCountingVMSNVRRealTime.setViewportView(jTablePeopleCountingVMSNVRRealTime);
        
        JButton jButtonPeopleCountingStartRealTime = new JButton("Begin");
        jButtonPeopleCountingStartRealTime.setBounds(198, 348, 93, 23);
        jPanelPeopleCountingVMSNVRRealTime.add(jButtonPeopleCountingStartRealTime);
        
        JButton jButtonPeopleCountingStopRealTime = new JButton("Stop");
        jButtonPeopleCountingStopRealTime.setBounds(301, 348, 93, 23);
        jPanelPeopleCountingVMSNVRRealTime.add(jButtonPeopleCountingStopRealTime);
        
        JPanel jPanelPeopleCountingVMSNVRStatistical = new JPanel();
        jTabbedPeopleCountingVMSNVR.addTab("Statistical", null, jPanelPeopleCountingVMSNVRStatistical, null);
        jPanelPeopleCountingVMSNVRStatistical.setLayout(null);
        
        JLabel jLabelPeopleCountingVMSNVRStatisticalReportType = new JLabel("ReportType");
        jLabelPeopleCountingVMSNVRStatisticalReportType.setBounds(10, 10, 72, 15);
        jPanelPeopleCountingVMSNVRStatistical.add(jLabelPeopleCountingVMSNVRStatisticalReportType);
       
        jComboBoxPeopleCountingVMSNVRStatisticalReportType = new JComboBox<Object>();
        jComboBoxPeopleCountingVMSNVRStatisticalReportType.setModel(new DefaultComboBoxModel<Object>(
                new String[] {"Minute", "Hour", "Day", "Month"}));
        jComboBoxPeopleCountingVMSNVRStatisticalReportType.setBounds(92, 7, 77, 21);
        jPanelPeopleCountingVMSNVRStatistical.add(jComboBoxPeopleCountingVMSNVRStatisticalReportType);
        
        jPanelStatisticsBeginTime = new JPanel();
        jPanelStatisticsBeginTime.setBounds(84, 38, 212, 30);
        jPanelPeopleCountingVMSNVRStatistical.add(jPanelStatisticsBeginTime);
        
        CountingVMSNVRStatisticsBeginTime.setBounds(22, 5, 156, 21);
        jPanelStatisticsBeginTime.add(CountingVMSNVRStatisticsBeginTime);       
        
        jPanelPeopleCountingVMSNVRStatistical.add(jPanelStatisticsEndTime);
        jPanelStatisticsEndTime.setBounds(388, 38, 207, 30);
        
        CountingVMSNVRStattisticsEndTime.setBounds(25, 5, 156, 21);
        jPanelStatisticsEndTime.add(CountingVMSNVRStattisticsEndTime);
        JButton jButtonPeopleCountingVMSNVRStatistics = new JButton("Statistics");
        jButtonPeopleCountingVMSNVRStatistics.setBounds(193, 6, 93, 23);
        jPanelPeopleCountingVMSNVRStatistical.add(jButtonPeopleCountingVMSNVRStatistics);
        JScrollPane jScrollPanePeopleCountingVMSNVRPeopleCountingVMSNVRStatisticalReportType = new JScrollPane();
        jScrollPanePeopleCountingVMSNVRPeopleCountingVMSNVRStatisticalReportType.setBounds(10, 75, 585, 309);
        jPanelPeopleCountingVMSNVRStatistical.add(jScrollPanePeopleCountingVMSNVRPeopleCountingVMSNVRStatisticalReportType);
        jTablePeopleCountingVMSNVRStatisticalReportType = new JTable();
        jTablePeopleCountingVMSNVRStatisticalReportType.setModel(PeopleCountingVMSNVRStatistalTableModel);
        jScrollPanePeopleCountingVMSNVRPeopleCountingVMSNVRStatisticalReportType.setViewportView(jTablePeopleCountingVMSNVRStatisticalReportType);
        JLabel jLabelNVRVMSStarttime = new JLabel("StartTime");
        jLabelNVRVMSStarttime.setBounds(10, 46, 72, 15);
        jPanelPeopleCountingVMSNVRStatistical.add(jLabelNVRVMSStarttime);
        JLabel jLabelEnetime = new JLabel("EndTime");
        jLabelEnetime.setBounds(324, 46, 54, 15);
        jPanelPeopleCountingVMSNVRStatistical.add(jLabelEnetime);
        JPanel jPanelPeopleCountingIPC = new JPanel();
        jTabbedPanePerpleCounting.addTab("IPC", null, jPanelPeopleCountingIPC, null);
        jPanelPeopleCountingIPC.setLayout(null);
        
        JButton jButtonPeopleCountingIPCRegister = new JButton("Register");
        jButtonPeopleCountingIPCRegister.setBounds(175, 324, 93, 23);
        jPanelPeopleCountingIPC.add(jButtonPeopleCountingIPCRegister);
        
        JButton jButtonPeopleCountingIPCCancel = new JButton("Cancel");
        jButtonPeopleCountingIPCCancel.setBounds(278, 324, 93, 23);
        jPanelPeopleCountingIPC.add(jButtonPeopleCountingIPCCancel);
        
        JScrollPane jScrollPanePeopleCountingIPC = new JScrollPane();
        jScrollPanePeopleCountingIPC.setBounds(10, 10, 590, 298);
        jPanelPeopleCountingIPC.add(jScrollPanePeopleCountingIPC);
        
        jTablePeopleCountingIPC = new JTable();
        jTablePeopleCountingIPC.setModel(VCAPeopleCountingTableModel);
        jScrollPanePeopleCountingIPC.setViewportView(jTablePeopleCountingIPC);
        
        jButtonPeopleCountingIPCRegister.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                IPCPeopleCounting.IPCRegister();
            }
        });
        jButtonPeopleCountingIPCCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                IPCPeopleCounting.IPCCancel();
            }
        });

		JPanel jPanelAlarm = new JPanel();
		tabFunList.addTab("Alarm", null, jPanelAlarm, null);
		jPanelAlarm.setLayout(null);
		JScrollPane AlarmScrollPane = new JScrollPane();
		AlarmScrollPane.setEnabled(false);
		AlarmScrollPane.setBounds(10, 5, 598, 428);
		jPanelAlarm.add(AlarmScrollPane);
		
		JTable AlarmTable = new JTable();
		AlarmTable.setModel(AlarmTableModel);
		AlarmTable.setEnabled(false);
		
		AlarmScrollPane.setViewportView(AlarmTable);
		JButton jButtonAlarmSubscibe = new JButton("Subscribe");
		jButtonAlarmSubscibe.setBounds(20, 443, 131, 28);
		jPanelAlarm.add(jButtonAlarmSubscibe);
		
		JButton jButtonAlarmUnSub = new JButton("UnSubscribe");
		jButtonAlarmUnSub.setBounds(173, 443, 131, 28);
		jPanelAlarm.add(jButtonAlarmUnSub);
		
		JButton jButtonClearAlarm = new JButton("Clear");
		jButtonClearAlarm.setBounds(465, 443, 131, 28);
		jPanelAlarm.add(jButtonClearAlarm);

		JPanel ConfigPanel = new JPanel();
		ConfigPanel.setToolTipText("");
		tabFunList.addTab("Configure", null, ConfigPanel, null);
		ConfigPanel.setLayout(null);

		JTabbedPane tabConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabConfigList.setBounds(0, 0, 618, 481);
		ConfigPanel.add(tabConfigList);

		JPanel panelConfigBasic = new JPanel();
		tabConfigList.addTab("Basic", null, panelConfigBasic, null);
		panelConfigBasic.setLayout(null);

		JTabbedPane tabBasicConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabBasicConfigList .setBounds(0, 0, 618, 481);
		panelConfigBasic.add(tabBasicConfigList );

		JPanel panelBasicConfigure = new JPanel();
		tabBasicConfigList.addTab("BasicConfigure ", null, panelBasicConfigure, null);
		panelBasicConfigure.setLayout(null);

		JPanel panelBasicConfigureInformation = new JPanel();
		tabBasicConfigList.addTab("Information", null, panelBasicConfigureInformation, null);
		panelBasicConfigureInformation.setLayout(null);
		
		JPanel panelSummerTime = new JPanel();
		panelSummerTime.setBorder(new TitledBorder(null, "DST", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelSummerTime.setBounds(10, 10, 593, 155);
		panelBasicConfigureInformation.add(panelSummerTime);
		panelSummerTime.setLayout(null);
		
		chckbxEnableSummerTime.setBounds(28, 17, 103, 23);
		panelSummerTime.add(chckbxEnableSummerTime);
		
		comboBoxDstBeginMonth.setBounds(139, 46, 93, 23);
		panelSummerTime.add(comboBoxDstBeginMonth);
		comboBoxDstBeginMonth.addItem("January");
		comboBoxDstBeginMonth.addItem("February");
		comboBoxDstBeginMonth.addItem("March");
		comboBoxDstBeginMonth.addItem("April");
		comboBoxDstBeginMonth.addItem("May");
		comboBoxDstBeginMonth.addItem("June");
		comboBoxDstBeginMonth.addItem("July");
		comboBoxDstBeginMonth.addItem("August");
		comboBoxDstBeginMonth.addItem("September");
		comboBoxDstBeginMonth.addItem("October");
		comboBoxDstBeginMonth.addItem("November");
		comboBoxDstBeginMonth.addItem("December");
		comboBoxDstBeginMonth.setSelectedIndex(0);
		
		JLabel lblDSTBeginMonth = new JLabel("Month");
		lblDSTBeginMonth.setBounds(87, 50, 42, 15);
		panelSummerTime.add(lblDSTBeginMonth);
		
		JLabel lblDSTBeginTime = new JLabel("Begin Time");
		lblDSTBeginTime.setBounds(12, 50, 77, 15);
		panelSummerTime.add(lblDSTBeginTime);
		
		JLabel lblDSTEndTime = new JLabel("End Time");
		lblDSTEndTime.setBounds(12, 88, 54, 15);
		panelSummerTime.add(lblDSTEndTime);
		
		JLabel lblDSTENDMonth = new JLabel("Month");
		lblDSTENDMonth.setBounds(87, 88, 42, 15);
		panelSummerTime.add(lblDSTENDMonth);
				
		comboBoxDSTENDMonth.setBounds(139, 84, 93, 23);
		panelSummerTime.add(comboBoxDSTENDMonth);
		comboBoxDSTENDMonth.addItem("January");
		comboBoxDSTENDMonth.addItem("February");
		comboBoxDSTENDMonth.addItem("March");
		comboBoxDSTENDMonth.addItem("April");
		comboBoxDSTENDMonth.addItem("May");
		comboBoxDSTENDMonth.addItem("June");
		comboBoxDSTENDMonth.addItem("July");
		comboBoxDSTENDMonth.addItem("August");
		comboBoxDSTENDMonth.addItem("September");
		comboBoxDSTENDMonth.addItem("October");
		comboBoxDSTENDMonth.addItem("November");
		comboBoxDSTENDMonth.addItem("December");
		comboBoxDSTENDMonth.setSelectedIndex(0);
		
		comboBoxDSTBeginTimeWeek.setBounds(356, 46, 93, 23);
		panelSummerTime.add(comboBoxDSTBeginTimeWeek);
		comboBoxDSTBeginTimeWeek.addItem("Mon");
		comboBoxDSTBeginTimeWeek.addItem("Tue");
		comboBoxDSTBeginTimeWeek.addItem("Wed");
		comboBoxDSTBeginTimeWeek.addItem("Thu");
		comboBoxDSTBeginTimeWeek.addItem("Fri");
		comboBoxDSTBeginTimeWeek.addItem("Sat");
		comboBoxDSTBeginTimeWeek.addItem("Sun");
		comboBoxDSTBeginTimeWeek.setSelectedIndex(0);
		
		comboBoxBeginTimeWeekNum.setBounds(242, 46, 93, 23);
		panelSummerTime.add(comboBoxBeginTimeWeekNum);
		comboBoxBeginTimeWeekNum.addItem("First");
		comboBoxBeginTimeWeekNum.addItem("Second");
		comboBoxBeginTimeWeekNum.addItem("Third");
		comboBoxBeginTimeWeekNum.addItem("Fourth");
		comboBoxBeginTimeWeekNum.addItem("Last");
		comboBoxBeginTimeWeekNum.setSelectedIndex(0);
		
		comboBoxDSTEndTimeWeekNum.setBounds(242, 84, 93, 23);
		panelSummerTime.add(comboBoxDSTEndTimeWeekNum);
		comboBoxDSTEndTimeWeekNum.addItem("First");
		comboBoxDSTEndTimeWeekNum.addItem("Second");
		comboBoxDSTEndTimeWeekNum.addItem("Third");
		comboBoxDSTEndTimeWeekNum.addItem("Fourth");
		comboBoxDSTEndTimeWeekNum.addItem("Last");
		comboBoxDSTEndTimeWeekNum.setSelectedIndex(0);
		
		comboBoxDSTBeginTimeHour.setBounds(459, 46, 77, 23);
		panelSummerTime.add(comboBoxDSTBeginTimeHour);
		comboBoxDSTBeginTimeHour.addItem("00");
		comboBoxDSTBeginTimeHour.addItem("01");
		comboBoxDSTBeginTimeHour.addItem("02");
		comboBoxDSTBeginTimeHour.addItem("03");
		comboBoxDSTBeginTimeHour.addItem("04");
		comboBoxDSTBeginTimeHour.addItem("05");
		comboBoxDSTBeginTimeHour.addItem("06");
		comboBoxDSTBeginTimeHour.addItem("07");
		comboBoxDSTBeginTimeHour.addItem("08");
		comboBoxDSTBeginTimeHour.addItem("09");
		comboBoxDSTBeginTimeHour.addItem("10");
		comboBoxDSTBeginTimeHour.addItem("11");
		comboBoxDSTBeginTimeHour.addItem("12");
		comboBoxDSTBeginTimeHour.addItem("13");
		comboBoxDSTBeginTimeHour.addItem("14");
		comboBoxDSTBeginTimeHour.addItem("15");
		comboBoxDSTBeginTimeHour.addItem("16");
		comboBoxDSTBeginTimeHour.addItem("17");
		comboBoxDSTBeginTimeHour.addItem("18");
		comboBoxDSTBeginTimeHour.addItem("19");
		comboBoxDSTBeginTimeHour.addItem("20");
		comboBoxDSTBeginTimeHour.addItem("21");
		comboBoxDSTBeginTimeHour.addItem("22");
		comboBoxDSTBeginTimeHour.addItem("23");
		comboBoxDSTBeginTimeHour.setSelectedIndex(0);
		
		comboBoxDSTEndTimeHour.setBounds(459, 84, 77, 23);
		panelSummerTime.add(comboBoxDSTEndTimeHour);
		comboBoxDSTEndTimeHour.addItem("00");
		comboBoxDSTEndTimeHour.addItem("01");
		comboBoxDSTEndTimeHour.addItem("02");
		comboBoxDSTEndTimeHour.addItem("03");
		comboBoxDSTEndTimeHour.addItem("04");
		comboBoxDSTEndTimeHour.addItem("05");
		comboBoxDSTEndTimeHour.addItem("06");
		comboBoxDSTEndTimeHour.addItem("07");
		comboBoxDSTEndTimeHour.addItem("08");
		comboBoxDSTEndTimeHour.addItem("09");
		comboBoxDSTEndTimeHour.addItem("10");
		comboBoxDSTEndTimeHour.addItem("11");
		comboBoxDSTEndTimeHour.addItem("12");
		comboBoxDSTEndTimeHour.addItem("13");
		comboBoxDSTEndTimeHour.addItem("14");
		comboBoxDSTEndTimeHour.addItem("15");
		comboBoxDSTEndTimeHour.addItem("16");
		comboBoxDSTEndTimeHour.addItem("17");
		comboBoxDSTEndTimeHour.addItem("18");
		comboBoxDSTEndTimeHour.addItem("19");
		comboBoxDSTEndTimeHour.addItem("20");
		comboBoxDSTEndTimeHour.addItem("21");
		comboBoxDSTEndTimeHour.addItem("22");
		comboBoxDSTEndTimeHour.addItem("23");
		comboBoxDSTEndTimeHour.setSelectedIndex(0);
		
		JLabel lblDSTBeginTimeHour = new JLabel("h");
		lblDSTBeginTimeHour.setBounds(546, 50, 26, 15);
		panelSummerTime.add(lblDSTBeginTimeHour);
		
		JLabel lblDSTEndTiemHour = new JLabel("h");
		lblDSTEndTiemHour.setBounds(546, 88, 26, 15);
		panelSummerTime.add(lblDSTEndTiemHour);
		
		comboBoxDSTEndTimeWeek.setBounds(356, 84, 93, 23);
		panelSummerTime.add(comboBoxDSTEndTimeWeek);
		comboBoxDSTEndTimeWeek.addItem("Mon");
		comboBoxDSTEndTimeWeek.addItem("Tue");
		comboBoxDSTEndTimeWeek.addItem("Wed");
		comboBoxDSTEndTimeWeek.addItem("Thu");
		comboBoxDSTEndTimeWeek.addItem("Fri");
		comboBoxDSTEndTimeWeek.addItem("Sat");
		comboBoxDSTEndTimeWeek.addItem("Sun");
		comboBoxDSTEndTimeWeek.setSelectedIndex(0);
		
		comboBoxDSTBias.setBounds(356, 121, 93, 23);
		panelSummerTime.add(comboBoxDSTBias);
		comboBoxDSTBias.addItem("30mins");
		comboBoxDSTBias.addItem("60mins");
		comboBoxDSTBias.addItem("90mins");
		comboBoxDSTBias.addItem("120mins");
		comboBoxDSTBias.setSelectedIndex(0);
		
		jButtonGetSummerTime.setBounds(12, 121, 93, 23);
		panelSummerTime.add(jButtonGetSummerTime);
		
		JButton jButtonSaveDSTtime = new JButton("Set");
		jButtonSaveDSTtime.setBounds(139, 121, 93, 23);
		panelSummerTime.add(jButtonSaveDSTtime);
		
		JPanel panelGetSDKVersion = new JPanel();
		panelGetSDKVersion.setBorder(new TitledBorder(null, "SDK Version", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelGetSDKVersion .setBounds(10, 181, 287, 67);
		panelBasicConfigureInformation.add(panelGetSDKVersion);
		panelGetSDKVersion.setLayout(null);
		
		jTextFieldGetSDKVersion.setBounds(61, 24, 108, 21);
		jTextFieldGetSDKVersion.setColumns(10);
		jTextFieldGetSDKVersion.setEditable(false);
		panelGetSDKVersion.add(jTextFieldGetSDKVersion);
		
		JButton jButtonGetSDKVersion = new JButton("Get");
		jButtonGetSDKVersion.setBounds(179, 23, 93, 23);
		panelGetSDKVersion.add(jButtonGetSDKVersion);
		
		JLabel lblSDKVersion = new JLabel("Version");
		lblSDKVersion.setBounds(10, 27, 58, 15);
		panelGetSDKVersion.add(lblSDKVersion);
		
		JPanel panelLogAndTimeConfig = new JPanel();
		panelLogAndTimeConfig.setBorder(new TitledBorder(null, "Log Config", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelLogAndTimeConfig.setBounds(316, 181, 287, 67);
		panelBasicConfigureInformation.add(panelLogAndTimeConfig);
		panelLogAndTimeConfig.setLayout(null);
		JButton jButtonSetLog = new JButton("Setting");
		jButtonSetLog.setBounds(102, 23, 93, 23);
		panelLogAndTimeConfig.add(jButtonSetLog);
		
		JPanel panelConfigBasicSystemTime = new JPanel();
		panelConfigBasicSystemTime.setBorder(new TitledBorder(null, "System Time", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigBasicSystemTime.setBounds(10, 10, 593, 74);
		panelBasicConfigure.add(panelConfigBasicSystemTime);
		panelConfigBasicSystemTime.setLayout(null);
		
		jComboBoxBasicTimeZone.setBounds(10, 20, 264, 21);
		panelConfigBasicSystemTime.add(jComboBoxBasicTimeZone);
		jComboBoxBasicTimeZone.insertItemAt("GMT-12:00 International Date Line West", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W1200);
		jComboBoxBasicTimeZone.insertItemAt("GMT-11:00 Midway Island, Samoa", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W1100);
		jComboBoxBasicTimeZone.insertItemAt("GMT-10:00 Hawaii", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W1000);
		jComboBoxBasicTimeZone.insertItemAt("GMT-09:00 Alaska", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0900);
		jComboBoxBasicTimeZone.insertItemAt("GMT-08:00 Pacific Time (U.S. & Canada)", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0800);
		jComboBoxBasicTimeZone.insertItemAt("GMT-07:00 Mountain Time (U.S. & Canada)", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0700);
		jComboBoxBasicTimeZone.insertItemAt("GMT-06:00 Central Time (U.S. & Canada)", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0600);
		jComboBoxBasicTimeZone.insertItemAt("GMT-05:00 Eastern Time (U.S. & Canada)", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0500);
		jComboBoxBasicTimeZone.insertItemAt("GMT-04:30 Caracas", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0430);
		jComboBoxBasicTimeZone.insertItemAt("GMT-04:00 Atlantic Time (Canada)", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0400);
		jComboBoxBasicTimeZone.insertItemAt("GMT-03:30 Newfoundland", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0330);
		jComboBoxBasicTimeZone.insertItemAt("GMT-03:00 Georgetown, Brasilia", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0300);
		jComboBoxBasicTimeZone.insertItemAt("GMT-02:00 Mid-Atlantic", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0200);
		jComboBoxBasicTimeZone.insertItemAt("GMT-01:00 Cape verde Islands, Azores", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_W0100);
		jComboBoxBasicTimeZone.insertItemAt("GMT+00:00 Dublin, Edinburgh, London", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_0000);
		jComboBoxBasicTimeZone.insertItemAt("GMT+01:00 Amsterdam, Berlin, Rome, Paris", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0100);
		jComboBoxBasicTimeZone.insertItemAt("GMT+02:00 Athens, Jerusalem, Istanbul", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0200);
		jComboBoxBasicTimeZone.insertItemAt("GMT+03:00 Baghdad, Kuwait, Moscow", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0300);
		jComboBoxBasicTimeZone.insertItemAt("GMT+03:30 Tehran", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0330);
		jComboBoxBasicTimeZone.insertItemAt("GMT+04:00 Caucasus Standard Time", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0400);
		jComboBoxBasicTimeZone.insertItemAt("GMT+04:30 Kabul", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0430);
		jComboBoxBasicTimeZone.insertItemAt("GMT+05:00 Islamabad, Karachi, Tashkent", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0500);
		jComboBoxBasicTimeZone.insertItemAt("GMT+05:30 Madras, Bombay, New Delhi", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0530);
		jComboBoxBasicTimeZone.insertItemAt("GMT+05:45 Kathmandu", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0545);
		jComboBoxBasicTimeZone.insertItemAt("GMT+06:00 Almaty, Novosibirsk, Dhaka", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0600);
		jComboBoxBasicTimeZone.insertItemAt("GMT+06:30 Yangon", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0630);
		jComboBoxBasicTimeZone.insertItemAt("GMT+07:00 Bangkok, Hanoi, Jakarta", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0700);
		jComboBoxBasicTimeZone.insertItemAt("GMT+08:00 Beijing, Hong Kong, Urumqi, Singapore, Taipei", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0800);
		jComboBoxBasicTimeZone.insertItemAt("GMT+09:00 Seoul, Tokyo, Osaka, Sapporo", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0900);
		jComboBoxBasicTimeZone.insertItemAt("GMT+09:30 Adelaide, Darwin", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0930);
		jComboBoxBasicTimeZone.insertItemAt("GMT+10:00 Melbourne, Sydney, Canberra", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E1000);
		jComboBoxBasicTimeZone.insertItemAt("GMT+11:00 Magadan, Solomon Islands", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E1100);
		jComboBoxBasicTimeZone.insertItemAt("GMT+12:00 Auckland, Wellington", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E1200);
		jComboBoxBasicTimeZone.insertItemAt("GMT+13:00 Nuku'alofa", NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E1300);

		jComboBoxBasicTimeZone.setSelectedIndex(0);
		textFieldBasicTime = new JTextField();
		textFieldBasicTime.setBounds(285, 46, 154, 21);
		jComboBoxBasicTimeZone.setRenderer(new JComboBoxRenderer());

		panelConfigBasicSystemTime.add(textFieldBasicTime);
		textFieldBasicTime.setColumns(10);
		textFieldBasicTime.setEnabled(false);
		textFieldBasicTime.setText(null);

		jButtonBasicGetSystemTime.setBounds(449, 19, 60, 23);
		panelConfigBasicSystemTime.add(jButtonBasicGetSystemTime);
		
		jButtonBasicSetSystemTime.setBounds(523, 19, 60, 23);
		panelConfigBasicSystemTime.add(jButtonBasicSetSystemTime);
		
		textFieldSetBasicSystemTime = new JTextField();
		textFieldSetBasicSystemTime.setBounds(284, 20, 155, 21);
		panelConfigBasicSystemTime.add(textFieldSetBasicSystemTime);
		textFieldSetBasicSystemTime.setColumns(10);
		textFieldSetBasicSystemTime.setText(null);
		
		JButton jButtonSynchronization = new JButton("Synchronization");
		jButtonSynchronization.setBounds(449, 45, 134, 23);
		panelConfigBasicSystemTime.add(jButtonSynchronization);
		
		JLabel lblSystemTime = new JLabel("System Time：");
		lblSystemTime.setBounds(183, 49, 91, 15);
		panelConfigBasicSystemTime.add(lblSystemTime);

		JPanel panelConfigBasicDeviceName = new JPanel();
		panelConfigBasicDeviceName.setBorder(new TitledBorder(null, "Device Name", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigBasicDeviceName.setBounds(10, 82, 593, 56);
		panelBasicConfigure.add(panelConfigBasicDeviceName);
		panelConfigBasicDeviceName.setLayout(null);

		textFieldConfigDeviceName = new JTextField();
		textFieldConfigDeviceName.setBounds(10, 25, 429, 21);
		panelConfigBasicDeviceName.add(textFieldConfigDeviceName);
		textFieldConfigDeviceName.setColumns(10);

		jButtonConfigGetDeviceName.setBounds(449, 24, 60, 23);
		panelConfigBasicDeviceName.add(jButtonConfigGetDeviceName);

		JButton jButtonConfigDeviceNameSet = new JButton("Set");
		jButtonConfigDeviceNameSet.setBounds(523, 24, 60, 23);
		panelConfigBasicDeviceName.add(jButtonConfigDeviceNameSet);

		JPanel panelConfigBasicHardDisk = new JPanel();
		panelConfigBasicHardDisk.setBorder(new TitledBorder(null, "Hard Disk", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigBasicHardDisk.setBounds(10, 162, 593, 126);
		panelBasicConfigure.add(panelConfigBasicHardDisk);
		panelConfigBasicHardDisk.setLayout(null);

		JScrollPane scrollPaneConfigBasicHardDisk = new JScrollPane();
		scrollPaneConfigBasicHardDisk.setBounds(10, 21, 573, 65);
		panelConfigBasicHardDisk.add(scrollPaneConfigBasicHardDisk);

		JTable tableConfigBasicHardDisk = new JTable();
		tableConfigBasicHardDisk.setModel(ConfigBasicHardDiskTableModel);
		scrollPaneConfigBasicHardDisk.setViewportView(tableConfigBasicHardDisk);

		JButton jButtonConfigBasicHardDiskRefresh = new JButton("Get");
		jButtonConfigBasicHardDiskRefresh.setBounds(494, 93, 90, 23);
		panelConfigBasicHardDisk.add(jButtonConfigBasicHardDiskRefresh);

		JPanel panelBasicInformation = new JPanel();
		panelBasicInformation.setBounds(10, 298, 593, 126);
		panelBasicConfigure.add(panelBasicInformation);
		panelBasicInformation.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Basic Information", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelBasicInformation.setLayout(null);

		JScrollPane scrollPaneConfigBasicInformation = new JScrollPane();
		scrollPaneConfigBasicInformation.setBounds(10, 33, 573, 51);
		panelBasicInformation.add(scrollPaneConfigBasicInformation);
		
		tableConfigBasicInformation.setModel(ConfigBasicInformationTableModel);
		scrollPaneConfigBasicInformation.setViewportView(tableConfigBasicInformation);

		JButton jButtonGetBasicInformation = new JButton("Get");
		jButtonGetBasicInformation.setBounds(493, 93, 90, 23);
		panelBasicInformation.add(jButtonGetBasicInformation);

		JPanel panelConfigNetwork = new JPanel();
		tabConfigList.addTab("Network", null, panelConfigNetwork, null);
		panelConfigNetwork.setLayout(null);

		JTabbedPane tabNetWorkBasicConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabNetWorkBasicConfigList.setBounds(0, 0, 618, 481);
		panelConfigNetwork.add(tabNetWorkBasicConfigList);

		JPanel panelBasicNetWorkConfigure = new JPanel();
		tabNetWorkBasicConfigList.addTab("Basic NetWork", null, panelBasicNetWorkConfigure, null);
		panelBasicNetWorkConfigure.setLayout(null);

		JPanel panelEXNetWorkConfigure = new JPanel();
		tabNetWorkBasicConfigList.addTab("NetWork", null, panelEXNetWorkConfigure, null);
		panelEXNetWorkConfigure.setLayout(null);

		JPanel panelEXNetWorkVPNConfigure = new JPanel();
		tabNetWorkBasicConfigList.addTab("VPN", null, panelEXNetWorkVPNConfigure, null);
		panelEXNetWorkVPNConfigure.setLayout(null);
		
		JPanel panelNetWorkVpnConfig = new JPanel();
		panelNetWorkVpnConfig.setBorder(new TitledBorder(null, "VPN", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelNetWorkVpnConfig.setBounds(10, 10, 250, 117);
		panelEXNetWorkVPNConfigure.add(panelNetWorkVpnConfig);
		panelNetWorkVpnConfig.setLayout(null);
		
		JLabel lblVpnAddress = new JLabel("Address");
		lblVpnAddress.setBounds(33, 23, 54, 15);
		panelNetWorkVpnConfig.add(lblVpnAddress);
		
		JLabel lblVpnPort = new JLabel("Port");
		lblVpnPort.setBounds(33, 56, 54, 15);
		panelNetWorkVpnConfig.add(lblVpnPort);
		
		textVpnAddress.setBounds(109, 20, 66, 21);
		panelNetWorkVpnConfig.add(textVpnAddress);
		textVpnAddress.setColumns(10);
		
		textVpnPort.setBounds(109, 53, 66, 21);
		panelNetWorkVpnConfig.add(textVpnPort);
		textVpnPort.setColumns(10);
		
		JButton jButtonGetNetWorkVpnConfig = new JButton("Get");
		jButtonGetNetWorkVpnConfig.setBounds(10, 84, 93, 23);
		panelNetWorkVpnConfig.add(jButtonGetNetWorkVpnConfig);
		
		JButton jButtonSetNetWorkVpnConfig = new JButton("Set");
		jButtonSetNetWorkVpnConfig.setBounds(113, 84, 93, 23);
		panelNetWorkVpnConfig.add(jButtonSetNetWorkVpnConfig);
		
		JPanel panelNetWorkPort = new JPanel();
		panelNetWorkPort.setBorder(new TitledBorder(null, "Port (LAPI)", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelNetWorkPort.setBounds(10, 10, 222, 138);
		panelEXNetWorkConfigure.add(panelNetWorkPort);
		panelNetWorkPort.setLayout(null);

		JLabel lblliNetWorkHttp = new JLabel("Http");
		lblliNetWorkHttp.setBounds(24, 29, 45, 15);
		panelNetWorkPort.add(lblliNetWorkHttp);

		JLabel lblliNetWorkHttps = new JLabel("Https");
		lblliNetWorkHttps.setBounds(24, 54, 45, 15);
		panelNetWorkPort.add(lblliNetWorkHttps);

		JLabel lblliNetWorkRtsp = new JLabel("Rtsp");
		lblliNetWorkRtsp.setBounds(24, 79, 45, 15);
		panelNetWorkPort.add(lblliNetWorkRtsp);

		textBasicNetWorkPortHttp.setBounds(88, 26, 103, 21);
		panelNetWorkPort.add(textBasicNetWorkPortHttp);
		textBasicNetWorkPortHttp.setColumns(10);
		
		textBasicNetWorkPortHttps.setBounds(88, 51, 103, 21);
		panelNetWorkPort.add(textBasicNetWorkPortHttps);
		textBasicNetWorkPortHttps.setColumns(10);

		textBasicNetWorkPortRtsp.setBounds(88, 76, 103, 21);
		panelNetWorkPort.add(textBasicNetWorkPortRtsp);
		textBasicNetWorkPortRtsp.setColumns(10);

		JButton jButtonGetNetWorkPortHttp = new JButton("Get");
		jButtonGetNetWorkPortHttp.setBounds(30, 104, 70, 23);
		panelNetWorkPort.add(jButtonGetNetWorkPortHttp);

		JButton jButtonSetNetWorHttp = new JButton("Set");
	    jButtonSetNetWorHttp.setBounds(115, 104, 70, 23);
	    panelNetWorkPort.add(jButtonSetNetWorHttp);
		
		JPanel panelDNSconfig = new JPanel();
		panelDNSconfig.setBorder(new TitledBorder(null, "DNS", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelDNSconfig.setBounds(242, 10, 361, 138);
		panelEXNetWorkConfigure.add(panelDNSconfig);
		panelDNSconfig.setLayout(null);

		JPanel panelNetWorkNetCard = new JPanel();
		panelNetWorkNetCard.setBorder(new TitledBorder(null, "Card", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelNetWorkNetCard .setBounds(10, 158, 593, 175);
		panelEXNetWorkConfigure.add(panelNetWorkNetCard);
		panelNetWorkNetCard.setLayout(null);

		JButton jButtonGetCardInformation = new JButton("Get");
		jButtonGetCardInformation.setBounds(169, 142, 93, 23);
		panelNetWorkNetCard.add(jButtonGetCardInformation);
		
		comboBoxCardListSzName = new JComboBox<Integer>();
		comboBoxCardListSzName.setBounds(284, 19, 63, 23);
		panelNetWorkNetCard.add(comboBoxCardListSzName);
		
		JLabel lblListOneCardMtu = new JLabel("MTU");
        lblListOneCardMtu.setBounds(11, 86, 54, 15);
        panelNetWorkNetCard.add(lblListOneCardMtu);

        textListCardOneMtuLength.setBounds(81, 83, 122, 21);
        panelNetWorkNetCard.add(textListCardOneMtuLength);
        textListCardOneMtuLength.setColumns(10);

        JLabel lblCardListOneMac = new JLabel("MAC");
        lblCardListOneMac.setBounds(10, 54, 30, 15);
        panelNetWorkNetCard.add(lblCardListOneMac);
        
        textCardListOneMac.setBounds(81, 52, 122, 21);
        panelNetWorkNetCard.add(textCardListOneMac);
        textCardListOneMac.setColumns(10);
        textCardListOneMac.setEditable(false);

        jComboBoxIPtypeList.setBounds(15, 26, 104, 23);
        
		panelDNSconfig.add(jComboBoxIPtypeList);
		jComboBoxIPtypeList.addItem("IPV4");
		jComboBoxIPtypeList.addItem("IPV6");
		jComboBoxIPtypeList.addItem("Domain");
		jComboBoxIPtypeList.addItem("IPV4 AND IPV6");
		jComboBoxIPtypeList.setSelectedIndex(0);

		JLabel lblPreferredAddress = new JLabel("Preferred");
		lblPreferredAddress.setBounds(10, 65, 70, 23);
		panelDNSconfig.add(lblPreferredAddress);
		
		textPreferredAddress.setBounds(79, 65, 80, 21);
		panelDNSconfig.add(textPreferredAddress);
		textPreferredAddress.setColumns(10);

		JLabel lblAlternate = new JLabel("Alternate");
		lblAlternate.setBounds(188, 69, 61, 15);
		panelDNSconfig.add(lblAlternate);
		
		textAlternate.setBounds(252, 66, 80, 21);
		panelDNSconfig.add(textAlternate);
		textAlternate.setColumns(10);

		JButton jButtonSetDNSConfig = new JButton("Set");
		jButtonSetDNSConfig.setBounds(198, 102, 93, 23);
		panelDNSconfig.add(jButtonSetDNSConfig);

		JButton jButtonSetCardListOne = new JButton("Set");
		jButtonSetCardListOne.setBounds(272, 142, 93, 23);
		panelNetWorkNetCard.add(jButtonSetCardListOne);

		textIPv4Address.setBounds(376, 83, 122, 21);
		panelNetWorkNetCard.add(textIPv4Address);
		textIPv4Address.setColumns(10);

		JLabel lblIpAddress = new JLabel("IPV4 Address");
		lblIpAddress.setBounds(284, 86, 82, 15);
		panelNetWorkNetCard.add(lblIpAddress);

		textCardListOneGateWay.setBounds(81, 114, 122, 21);
		panelNetWorkNetCard.add(textCardListOneGateWay);
		textCardListOneGateWay.setColumns(10);

		JLabel lblGateway = new JLabel("GateWay");
		lblGateway.setBounds(10, 117, 54, 15);
		panelNetWorkNetCard.add(lblGateway);

		JLabel lblNetmask = new JLabel("NetMask");
		lblNetmask.setBounds(284, 114, 80, 15);
		panelNetWorkNetCard.add(lblNetmask);
		
		textCardListOneNetMask.setBounds(376, 114, 122, 21);
		panelNetWorkNetCard.add(textCardListOneNetMask);
		textCardListOneNetMask.setColumns(10);
		
		textFieldNetWorkCardName = new JTextField();
		textFieldNetWorkCardName.setBounds(502, 20, 81, 21);
		panelNetWorkNetCard.add(textFieldNetWorkCardName);
		textFieldNetWorkCardName.setColumns(10);
		textFieldNetWorkCardName.setEnabled(false);
		
		textFieldNetWorkCardMode = new JTextField();
		textFieldNetWorkCardMode.setBounds(376, 51, 122, 21);
		panelNetWorkNetCard.add(textFieldNetWorkCardMode);
		textFieldNetWorkCardMode.setColumns(10);
		textFieldNetWorkCardMode.setEnabled(false);
		
		JLabel lblIndexNetCard = new JLabel("Index");
		lblIndexNetCard.setBounds(236, 21, 38, 19);
		panelNetWorkNetCard.add(lblIndexNetCard);
		
		JLabel lblCardName = new JLabel("NetWork Card Name");
		lblCardName.setBounds(376, 23, 116, 15);
		panelNetWorkNetCard.add(lblCardName);
		
		JLabel lblMode = new JLabel("Work Mode");
		lblMode.setBounds(284, 54, 93, 15);
		panelNetWorkNetCard.add(lblMode);
		
		jComboBoxNetWorkMode.setBounds(81, 19, 122, 23);
		panelNetWorkNetCard.add(jComboBoxNetWorkMode);
		jComboBoxNetWorkMode.addItem("多址设定");
		jComboBoxNetWorkMode.addItem("负载均衡");
		jComboBoxNetWorkMode.addItem("网络容错");
		jComboBoxNetWorkMode.setSelectedIndex(0);
		
		JLabel lblCardListWordMode = new JLabel("Work Mode");
		lblCardListWordMode.setBounds(11, 23, 75, 15);
		panelNetWorkNetCard.add(lblCardListWordMode);
			
		JPanel panelChangeIpAddress = new JPanel();
		panelChangeIpAddress.setBorder(new TitledBorder(null, "IP Adress", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelChangeIpAddress.setBounds(10, 333, 593, 84);
		panelEXNetWorkConfigure.add(panelChangeIpAddress);
		panelChangeIpAddress.setLayout(null);
			
		jTextFieldModifyDeviceIpv4Address.setBounds(237, 21, 88, 21);
		panelChangeIpAddress.add(jTextFieldModifyDeviceIpv4Address);
		jTextFieldModifyDeviceIpv4Address.setColumns(10);
		
		JButton jButtonSetIPV4DeviceAddress = new JButton("Set");
		jButtonSetIPV4DeviceAddress.setBounds(490, 52, 93, 23);
		panelChangeIpAddress.add(jButtonSetIPV4DeviceAddress);
		
		JLabel lblUpdateUsername = new JLabel("Username");
		lblUpdateUsername.setBounds(10, 24, 66, 15);
		panelChangeIpAddress.add(lblUpdateUsername);
		
		jTextFieldUpdateUserName.setBounds(86, 21, 66, 21);
		panelChangeIpAddress.add(jTextFieldUpdateUserName);
		jTextFieldUpdateUserName.setColumns(10);
		
		JLabel lblNewLabelUpdatePassword = new JLabel("Password");
		lblNewLabelUpdatePassword.setBounds(10, 56, 66, 15);
		panelChangeIpAddress.add(lblNewLabelUpdatePassword);
		
		textFieldUpdatePassword = new JPasswordField();
		textFieldUpdatePassword.setBounds(86, 53, 66, 21);
		panelChangeIpAddress.add(textFieldUpdatePassword);
		textFieldUpdatePassword.setColumns(10);
		
		JLabel lblIpv = new JLabel("IPV4");
		lblIpv.setBounds(184, 24, 41, 15);
		panelChangeIpAddress.add(lblIpv);
		
		JLabel lblMask = new JLabel("Mask");
		lblMask.setBounds(184, 56, 31, 15);
		panelChangeIpAddress.add(lblMask);
		
		jTextFieldUpdateChangeDeviceIpMask.setBounds(237, 53, 88, 21);
		panelChangeIpAddress.add(jTextFieldUpdateChangeDeviceIpMask);
		jTextFieldUpdateChangeDeviceIpMask.setColumns(10);
		
		JLabel lblNewLabelUPdateGateWay = new JLabel("GateWay");
		lblNewLabelUPdateGateWay.setBounds(339, 24, 54, 15);
		panelChangeIpAddress.add(lblNewLabelUPdateGateWay);
		
		jTextFieldUpdateChangeDeviceIpGateWay.setBounds(397, 21, 88, 21);
		panelChangeIpAddress.add(jTextFieldUpdateChangeDeviceIpGateWay);
		jTextFieldUpdateChangeDeviceIpGateWay.setColumns(10);
		
		JButton jButtonnGetDNSConfig = new JButton("Get");
		jButtonnGetDNSConfig.setBounds(79, 102, 93, 23);
		panelDNSconfig.add(jButtonnGetDNSConfig);
		
		JLabel lblNewLabelDNS = new JLabel("Only support IPV4");
		lblNewLabelDNS.setForeground(Color.RED);
		lblNewLabelDNS.setBounds(129, 26, 134, 23);
		panelDNSconfig.add(lblNewLabelDNS);

		JPanel panelConfigNetWorkNet = new JPanel();
		panelConfigNetWorkNet.setBorder(new TitledBorder(null, "Net", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigNetWorkNet.setBounds(10, 10, 283, 228);
		panelBasicNetWorkConfigure.add(panelConfigNetWorkNet);
		panelConfigNetWorkNet.setLayout(null);

		JLabel lblConfigNetWorkDHCP = new JLabel("DHCP");
		lblConfigNetWorkDHCP.setBounds(10, 19, 34, 15);
		panelConfigNetWorkNet.add(lblConfigNetWorkDHCP);

		chckbxConfigNetWorkDHCPEnable.setBounds(107, 15, 66, 23);
		panelConfigNetWorkNet.add(chckbxConfigNetWorkDHCPEnable);

		JLabel lblConfigNetWorkIPAddr = new JLabel("IP Address");
		lblConfigNetWorkIPAddr.setBounds(10, 44, 94, 15);
		panelConfigNetWorkNet.add(lblConfigNetWorkIPAddr);

		textFieldConfigNetWorkIPAddr = new JTextField();
		textFieldConfigNetWorkIPAddr.setBounds(114, 41, 135, 21);
		panelConfigNetWorkNet.add(textFieldConfigNetWorkIPAddr);
		textFieldConfigNetWorkIPAddr.setColumns(10);

		JLabel lblConfigNetWorkSubMask = new JLabel("Subnet Mask");
		lblConfigNetWorkSubMask.setBounds(10, 77, 94, 15);
		panelConfigNetWorkNet.add(lblConfigNetWorkSubMask);

		textFieldConfigNetWorkSubMask = new JTextField();
		textFieldConfigNetWorkSubMask.setBounds(114, 74, 135, 21);
		panelConfigNetWorkNet.add(textFieldConfigNetWorkSubMask);
		textFieldConfigNetWorkSubMask.setColumns(10);

		JLabel lblConfigNetWorkGateway = new JLabel("Gateway");
		lblConfigNetWorkGateway.setBounds(10, 111, 73, 15);
		panelConfigNetWorkNet.add(lblConfigNetWorkGateway);

		textFieldConfigNetWorkGateway = new JTextField();
		textFieldConfigNetWorkGateway.setBounds(114, 105, 135, 21);
		panelConfigNetWorkNet.add(textFieldConfigNetWorkGateway);
		textFieldConfigNetWorkGateway.setColumns(10);

		JLabel lblConfigNetWorkMTU = new JLabel("MTU");
		lblConfigNetWorkMTU.setBounds(10, 147, 54, 15);
		panelConfigNetWorkNet.add(lblConfigNetWorkMTU);

		textFieldConfigNetWorkMTU = new JTextField();
		textFieldConfigNetWorkMTU.setBounds(114, 136, 135, 21);
		panelConfigNetWorkNet.add(textFieldConfigNetWorkMTU);
		textFieldConfigNetWorkMTU.setColumns(10);

		jButtonGetConfigNetWorkNet.setBounds(31, 184, 93, 23);
		panelConfigNetWorkNet.add(jButtonGetConfigNetWorkNet);

		JButton jButtonSetConfigNetWorkNet = new JButton("Set");
		jButtonSetConfigNetWorkNet.setBounds(156, 184, 93, 23);
		panelConfigNetWorkNet.add(jButtonSetConfigNetWorkNet);

		JPanel panelConfigNetWorkPort = new JPanel();
		panelConfigNetWorkPort.setBorder(new TitledBorder(null, "Port (Onvif)  only support IPC", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigNetWorkPort.setBounds(303, 10, 300, 157);
		panelBasicNetWorkConfigure.add(panelConfigNetWorkPort);
		panelConfigNetWorkPort.setLayout(null);

		JLabel lblNetworkPortHTTP = new JLabel("HTTP");
		lblNetworkPortHTTP.setBounds(10, 24, 49, 15);
		panelConfigNetWorkPort.add(lblNetworkPortHTTP);

		jTextFieldNetworkPortHTTP.setBounds(69, 21, 66, 21);
		panelConfigNetWorkPort.add(jTextFieldNetworkPortHTTP);
		jTextFieldNetworkPortHTTP.setColumns(10);

		jComboBoxNetworkPortHTTP.setEnabled(false);
		jComboBoxNetworkPortHTTP.setModel(new DefaultComboBoxModel<Object>(new String[] {"", "Enable", "Disable"}));
		jComboBoxNetworkPortHTTP.setBounds(145, 21, 66, 21);
		panelConfigNetWorkPort.add(jComboBoxNetworkPortHTTP);

		JLabel lblNetworkPortHTTPS = new JLabel("HTTPS");
		lblNetworkPortHTTPS.setBounds(10, 63, 49, 15);
		panelConfigNetWorkPort.add(lblNetworkPortHTTPS);

		jTextFieldNetworkPortHTTPS.setBounds(69, 60, 66, 21);
		panelConfigNetWorkPort.add(jTextFieldNetworkPortHTTPS);
		jTextFieldNetworkPortHTTPS.setColumns(10);

		jComboBoxNetworkPortHTTPS.setEnabled(false);
		jComboBoxNetworkPortHTTPS.setModel(new DefaultComboBoxModel<Object>(new String[] {"", "Enable", "Disable"}));
		jComboBoxNetworkPortHTTPS.setBounds(145, 60, 66, 21);
		panelConfigNetWorkPort.add(jComboBoxNetworkPortHTTPS);

		JLabel lblNetworkPortRTSP = new JLabel("RTSP");
		lblNetworkPortRTSP.setBounds(10, 99, 49, 15);
		panelConfigNetWorkPort.add(lblNetworkPortRTSP);

		jTextFieldNetworkPortRTSP.setBounds(69, 96, 66, 21);
		panelConfigNetWorkPort.add(jTextFieldNetworkPortRTSP);
		jTextFieldNetworkPortRTSP.setColumns(10);

		jComboBoxNetworkPortRTSP.setEnabled(false);
		jComboBoxNetworkPortRTSP.setModel(new DefaultComboBoxModel<Object>(new String[] {"", "Enable", "Disable"}));
		jComboBoxNetworkPortRTSP.setBounds(145, 96, 66, 21);
		panelConfigNetWorkPort.add(jComboBoxNetworkPortRTSP);

		JButton jButtonGetNetworkPort = new JButton("Get");
		jButtonGetNetworkPort.setBounds(50, 124, 93, 23);
		panelConfigNetWorkPort.add(jButtonGetNetworkPort);

		JButton jButtonSetNetworkPort = new JButton("Set");
		jButtonSetNetworkPort.setBounds(174, 124, 93, 23);
		panelConfigNetWorkPort.add(jButtonSetNetworkPort);

		JPanel panelConfigNetWorkTelnet = new JPanel();
		panelConfigNetWorkTelnet.setBorder(new TitledBorder(null, "Telnet", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigNetWorkTelnet.setBounds(303, 177, 300, 59);
		panelBasicNetWorkConfigure.add(panelConfigNetWorkTelnet);
		panelConfigNetWorkTelnet.setLayout(null);

		JButton jButtonOpenNetWorkTelnet = new JButton("Open");
		jButtonOpenNetWorkTelnet.setBounds(50, 26, 93, 23);
		panelConfigNetWorkTelnet.add(jButtonOpenNetWorkTelnet);

		JButton jButtonCloseNetWorkTelnet = new JButton("Close");
		jButtonCloseNetWorkTelnet.setBounds(174, 26, 93, 23);
		panelConfigNetWorkTelnet.add(jButtonCloseNetWorkTelnet);

		JPanel panelConfigNetWorkNTP = new JPanel();
		panelConfigNetWorkNTP.setBorder(new TitledBorder(null, "NTP", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigNetWorkNTP.setBounds(10, 242, 593, 210);
		panelBasicNetWorkConfigure.add(panelConfigNetWorkNTP);
		panelConfigNetWorkNTP.setLayout(null);
		
		chckbxConfigNetWorkNTPEnable.setBounds(20, 21, 103, 23);
		panelConfigNetWorkNTP.add(chckbxConfigNetWorkNTPEnable);

		JLabel lblConfigNetWorkNTPIPType = new JLabel("IP Type");
		lblConfigNetWorkNTPIPType.setBounds(20, 60, 54, 15);
		panelConfigNetWorkNTP.add(lblConfigNetWorkNTPIPType);

		JLabel lblConfigNetWorkNTPServerIP = new JLabel("Server IP");
		lblConfigNetWorkNTPServerIP.setBounds(20, 95, 62, 15);
		panelConfigNetWorkNTP.add(lblConfigNetWorkNTPServerIP);

		textFieldConfigNetWorkNTPServerIP = new JTextField();
		textFieldConfigNetWorkNTPServerIP.setBounds(91, 92, 131, 21);
		panelConfigNetWorkNTP.add(textFieldConfigNetWorkNTPServerIP);
		textFieldConfigNetWorkNTPServerIP.setColumns(10);
		
		jComboBoxConfigNetWorkNTPIPType.setModel(new DefaultComboBoxModel<Object>(new String[] {"IPv4", "IPv6", "Domain name"}));
		jComboBoxConfigNetWorkNTPIPType.setBounds(91, 57, 131, 21);
		panelConfigNetWorkNTP.add(jComboBoxConfigNetWorkNTPIPType);
		
		JLabel lblConfigNetWorkNTPDomainName = new JLabel("DomainName");
		lblConfigNetWorkNTPDomainName.setBounds(258, 25, 88, 15);
		panelConfigNetWorkNTP.add(lblConfigNetWorkNTPDomainName);

		JLabel lblConfigNetWorkNTPPort = new JLabel("Port");
		lblConfigNetWorkNTPPort.setBounds(258, 60, 54, 15);
		panelConfigNetWorkNTP.add(lblConfigNetWorkNTPPort);

		JLabel lblConfigNetWorkNTPSynchronizeInterval = new JLabel("Synchronize Interval");
		lblConfigNetWorkNTPSynchronizeInterval.setBounds(258, 95, 120, 15);
		panelConfigNetWorkNTP.add(lblConfigNetWorkNTPSynchronizeInterval);

		textFieldConfigNetWorkNTPDomainName = new JTextField();
		textFieldConfigNetWorkNTPDomainName.setBounds(393, 22, 94, 21);
		panelConfigNetWorkNTP.add(textFieldConfigNetWorkNTPDomainName);
		textFieldConfigNetWorkNTPDomainName.setColumns(10);

		textFieldConfigNetWorkNTPPort = new JTextField();
		textFieldConfigNetWorkNTPPort.setBounds(393, 57, 94, 21);
		panelConfigNetWorkNTP.add(textFieldConfigNetWorkNTPPort);
		textFieldConfigNetWorkNTPPort.setColumns(10);

		textFieldConfigNetWorkNTPSynchronizeInterval = new JTextField();
		textFieldConfigNetWorkNTPSynchronizeInterval.setBounds(393, 92, 94, 21);
		panelConfigNetWorkNTP.add(textFieldConfigNetWorkNTPSynchronizeInterval);
		textFieldConfigNetWorkNTPSynchronizeInterval.setColumns(10);

		JButton btnConfigNetWorkNTPGet = new JButton("Get");

		btnConfigNetWorkNTPGet.setBounds(181, 146, 93, 23);
		panelConfigNetWorkNTP.add(btnConfigNetWorkNTPGet);

		JButton btnConfigNetWorkNTPSet = new JButton("Set");
	      
		btnConfigNetWorkNTPSet.setBounds(284, 146, 93, 23);
		panelConfigNetWorkNTP.add(btnConfigNetWorkNTPSet);
		
		JLabel lblNTPSeconds = new JLabel(":Seconds");
		lblNTPSeconds.setBounds(494, 95, 54, 15);
		panelConfigNetWorkNTP.add(lblNTPSeconds);

		JPanel panelConfigVideo = new JPanel();
		tabConfigList.addTab("Video", null, panelConfigVideo, null);
		panelConfigVideo.setLayout(null);

		JTabbedPane tabVideoConfigConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabVideoConfigConfigList.setBounds(0, 0, 618, 481);
		panelConfigVideo.add(tabVideoConfigConfigList);
		
		
		JPanel panelBasciVideoConfigure = new JPanel();
		tabVideoConfigConfigList.addTab("Video", null, panelBasciVideoConfigure, null);
		panelBasciVideoConfigure.setLayout(null);
		
		
		JPanel panelEXVideoConfigure = new JPanel();
		tabVideoConfigConfigList.addTab("Video config", null, panelEXVideoConfigure, null);
		panelEXVideoConfigure.setLayout(null);
		
		JPanel panelFocusMode = new JPanel();
		panelFocusMode.setBorder(new TitledBorder(null, "Focus Mode", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelFocusMode.setBounds(10, 10, 264, 95);
		panelEXVideoConfigure.add(panelFocusMode);
		panelFocusMode.setLayout(null);
		
		jComboBoxFocusModeConfig.setBounds(50, 21, 140, 23);
		panelFocusMode.add(jComboBoxFocusModeConfig);
		jComboBoxFocusModeConfig.addItem("AUTO");
		jComboBoxFocusModeConfig.addItem("MANUAL");
		jComboBoxFocusModeConfig.setSelectedIndex(0);
		
		JButton jButtonGetFocusMode = new JButton("Get");
		jButtonGetFocusMode.setBounds(50, 61, 65, 23);
		panelFocusMode.add(jButtonGetFocusMode);
		
		JButton jButtonSetFocusMode = new JButton("Set");
		jButtonSetFocusMode.setBounds(125, 61, 65, 23);
		panelFocusMode.add(jButtonSetFocusMode);
		
		JPanel panelIRcutMode = new JPanel();
		panelIRcutMode.setBorder(new TitledBorder(null, "IRcut Mode", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelIRcutMode.setBounds(309, 10, 294, 95);
		panelEXVideoConfigure.add(panelIRcutMode);
		panelIRcutMode.setLayout(null);
		
		jComboBoxIRcutMode.setBounds(71, 23, 140, 23);
		panelIRcutMode.add(jComboBoxIRcutMode);
		jComboBoxIRcutMode.addItem("DAY");
		jComboBoxIRcutMode.addItem("NIGHT");
		jComboBoxIRcutMode.addItem("AUTO");
		jComboBoxIRcutMode.setSelectedIndex(0);
		
		JButton jButtonGetIRcutMode = new JButton("Get");
		jButtonGetIRcutMode.setBounds(71, 62, 65, 23);
		panelIRcutMode.add(jButtonGetIRcutMode);
		
		JButton jButtonSetIRcutMode = new JButton("Set");
		jButtonSetIRcutMode.setBounds(146, 62, 65, 23);
		panelIRcutMode.add(jButtonSetIRcutMode);
		
		JPanel panelSnapshot = new JPanel();
		panelSnapshot.setBorder(new TitledBorder(null, "Snapshot", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelSnapshot.setBounds(10, 126, 328, 206);
		panelEXVideoConfigure.add(panelSnapshot);
		panelSnapshot.setLayout(null);
		
		chckbxEnableGetPicture.setBounds(22, 18, 103, 23);
		chckbxEnableGetPicture.setSelected(false);
		panelSnapshot.add(chckbxEnableGetPicture);
		
		jButtonGetSnapshot.setBounds(27, 167, 65, 23);
		panelSnapshot.add(jButtonGetSnapshot);
		
		textFieldSnapshotWidth = new JTextField();
		textFieldSnapshotWidth.setBounds(102, 44, 48, 21);
		panelSnapshot.add(textFieldSnapshotWidth);
		textFieldSnapshotWidth.setColumns(10);
		
		textFieldSnapshotHeight = new JTextField();
		textFieldSnapshotHeight.setBounds(160, 44, 48, 21);
		panelSnapshot.add(textFieldSnapshotHeight);
		textFieldSnapshotHeight.setColumns(10);
		
		JLabel lblSnapshotResolution = new JLabel("Resolution");
		lblSnapshotResolution.setBounds(27, 47, 65, 15);
		panelSnapshot.add(lblSnapshotResolution);
		
		textFieldPictureMaxSize = new JTextField();
		textFieldPictureMaxSize.setBounds(102, 75, 108, 21);
		panelSnapshot.add(textFieldPictureMaxSize);
		textFieldPictureMaxSize.setColumns(10);
		
		textFieldSnapshotInterval = new JTextField();
		textFieldSnapshotInterval.setBounds(102, 106, 108, 21);
		panelSnapshot.add(textFieldSnapshotInterval);
		textFieldSnapshotInterval.setColumns(10);
		
		textFieldSnapshotNum = new JTextField();
		textFieldSnapshotNum.setBounds(102, 137, 108, 21);
		panelSnapshot.add(textFieldSnapshotNum);
		textFieldSnapshotNum.setColumns(10);
		
		JButton jButtonSetSnapshotNum = new JButton("Set");
		jButtonSetSnapshotNum.setBounds(112, 167, 65, 23);
		panelSnapshot.add(jButtonSetSnapshotNum);
		
		JLabel lblPicturemaxsize = new JLabel("MaxSize");
		lblPicturemaxsize.setBounds(27, 78, 54, 15);
		panelSnapshot.add(lblPicturemaxsize);
		
		JLabel lblInterval = new JLabel("Interval");
		lblInterval.setBounds(27, 109, 54, 15);
		panelSnapshot.add(lblInterval);
		
		JLabel lblShotNum = new JLabel("Shot Num");
		lblShotNum.setBounds(27, 142, 65, 15);
		panelSnapshot.add(lblShotNum);
		
		JLabel lblNewLabelIntervalRange = new JLabel("Range:1-60");
		lblNewLabelIntervalRange.setForeground(Color.RED);
		lblNewLabelIntervalRange.setBounds(220, 109, 91, 15);
		panelSnapshot.add(lblNewLabelIntervalRange);
		
		JLabel lblNewLabelShotNum = new JLabel("Range:1-3");
		lblNewLabelShotNum.setForeground(Color.RED);
		lblNewLabelShotNum.setBounds(220, 140, 65, 15);
		panelSnapshot.add(lblNewLabelShotNum);
		
		JPanel panelConfigVideoStream = new JPanel();
		panelConfigVideoStream.setBorder(new TitledBorder(null, "Stream Configuration", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigVideoStream.setBounds(0, 28, 603, 319);
		panelBasciVideoConfigure.add(panelConfigVideoStream);
		panelConfigVideoStream.setLayout(null);
		
		JLabel lblConfigVideoStreamIndex = new JLabel("Stream Index");
		lblConfigVideoStreamIndex.setBounds(10, 60, 221, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamIndex);

		comboBoxConfigVideoStreamIndex = new JComboBox<String>();
		comboBoxConfigVideoStreamIndex.addItem("MAIN");
		comboBoxConfigVideoStreamIndex.addItem("AUX");
		comboBoxConfigVideoStreamIndex.addItem("THIRD");
		comboBoxConfigVideoStreamIndex.setSelectedIndex(0);
		comboBoxConfigVideoStreamIndex.setBounds(100, 57, 131, 21);
		panelConfigVideoStream.add(comboBoxConfigVideoStreamIndex);

		JLabel lblConfigVideoStreamEncodeFormat = new JLabel("Encode Format");
		lblConfigVideoStreamEncodeFormat.setBounds(311, 94, 89, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamEncodeFormat);
		
		comboBoxConfigVideoStreamEncodeFormat = new JComboBox<Object>();
		comboBoxConfigVideoStreamEncodeFormat.addItem("MJPEG");
		comboBoxConfigVideoStreamEncodeFormat.addItem("H.264");
		comboBoxConfigVideoStreamEncodeFormat.addItem("H.265");
		
		comboBoxConfigVideoStreamEncodeFormat.setBounds(423, 93, 113, 21);
		panelConfigVideoStream.add(comboBoxConfigVideoStreamEncodeFormat);
		comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);

		JLabel lbllblConfigVideoStreamResolution = new JLabel("Resolution");
		lbllblConfigVideoStreamResolution.setBounds(10, 96, 72, 15);
		panelConfigVideoStream.add(lbllblConfigVideoStreamResolution);

		textFieldConfigVideoStreamResolutionWidth = new JTextField();
		textFieldConfigVideoStreamResolutionWidth.setBounds(100, 93, 54, 21);
		panelConfigVideoStream.add(textFieldConfigVideoStreamResolutionWidth);
		textFieldConfigVideoStreamResolutionWidth.setColumns(10);

		JLabel lblConfigVideoStreamResolutionX = new JLabel("x");
		lblConfigVideoStreamResolutionX.setBounds(164, 96, 14, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamResolutionX);

		textFieldConfigVideoStreamResolutionHigth = new JTextField();
		textFieldConfigVideoStreamResolutionHigth.setBounds(174, 93, 57, 21);
		panelConfigVideoStream.add(textFieldConfigVideoStreamResolutionHigth);
		textFieldConfigVideoStreamResolutionHigth.setColumns(10);

		JLabel lblConfigVideoStreamBitRate = new JLabel("Bit Rate(kbps)");
		lblConfigVideoStreamBitRate.setBounds(311, 213, 89, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamBitRate);

		textFieldConfigVideoStreamBitRate = new JTextField();
		textFieldConfigVideoStreamBitRate.setBounds(423, 209, 113, 21);
		panelConfigVideoStream.add(textFieldConfigVideoStreamBitRate);
		textFieldConfigVideoStreamBitRate.setColumns(10);
		
		JLabel lblConfigVideoStreamQuality = new JLabel("Quality");
		lblConfigVideoStreamQuality.setBounds(10, 132, 54, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamQuality);
	
		comboBoxConfigVideoStreamQuality.setModel(new DefaultComboBoxModel<Object>(new String[] {"L1", "L2", "L3", "L4", "L5", "L6", "L7", "L8", "L9"}));
		comboBoxConfigVideoStreamQuality.setBounds(100, 129, 131, 21);
		panelConfigVideoStream.add(comboBoxConfigVideoStreamQuality);

		JLabel lblConfigVideoStreamFrameRate = new JLabel("Frame Rate(fps)");
		lblConfigVideoStreamFrameRate.setBounds(311, 169, 102, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamFrameRate);

		textFieldConfigVideoStreamFrameRate = new JTextField();
		textFieldConfigVideoStreamFrameRate.setBounds(423, 167, 113, 21);
		panelConfigVideoStream.add(textFieldConfigVideoStreamFrameRate);
		textFieldConfigVideoStreamFrameRate.setColumns(10);

		JLabel lblConfigVideoStreamIFremeInterval = new JLabel("I Frame Interval");
		lblConfigVideoStreamIFremeInterval.setBounds(10, 215, 102, 15);
		panelConfigVideoStream.add(lblConfigVideoStreamIFremeInterval);

		textFieldConfigVideoStreamIFremeInterval = new JTextField();
		textFieldConfigVideoStreamIFremeInterval.setBounds(122, 209, 110, 21);
		panelConfigVideoStream.add(textFieldConfigVideoStreamIFremeInterval);
		textFieldConfigVideoStreamIFremeInterval.setColumns(10);

		chckbxBViedeoenable.setBounds(10, 20, 80, 23);
		panelConfigVideoStream.add(chckbxBViedeoenable);
		chckbxBViedeoenable.setSelected(false);
		
		comboBoxConfigVideoStreamRate.setBounds(423, 129, 113, 21);
		panelConfigVideoStream.add(comboBoxConfigVideoStreamRate);
		comboBoxConfigVideoStreamRate.addItem("Fixed Rate");
		comboBoxConfigVideoStreamRate.addItem("Variable Rate");
		comboBoxConfigVideoStreamRate.setSelectedIndex(0);
		
		JButton jButtonGetVideoStream = new JButton("Get");
		jButtonGetVideoStream.setBounds(174, 286, 93, 23);
		panelConfigVideoStream.add(jButtonGetVideoStream);

		JButton jButtonSetVideoStream = new JButton("Set");
		jButtonSetVideoStream.setBounds(290, 286, 93, 23);
		panelConfigVideoStream.add(jButtonSetVideoStream);
		
		JLabel lblBitrateType = new JLabel("Bitrate  Type");
		lblBitrateType.setBounds(311, 125, 99, 25);
		panelConfigVideoStream.add(lblBitrateType);
		
		jRadioButtonOpenSVC = new JRadioButton("open");
		jRadioButtonOpenSVC.setBounds(122, 243, 62, 23);
		panelConfigVideoStream.add(jRadioButtonOpenSVC);
		jRadioButtonOpenSVC.setSelected(true);
		jRadioButtonOpenSVC.setEnabled(true);
		
		jRadioButtonCloseSVC = new JRadioButton("close");
		jRadioButtonCloseSVC.setBounds(190, 243, 62, 23);
		panelConfigVideoStream.add(jRadioButtonCloseSVC);
		jRadioButtonCloseSVC.setSelected(false);
		jRadioButtonCloseSVC.setEnabled(true);
		
		JLabel lblSvcConrfig = new JLabel("SVC(support IPC)");
		lblSvcConrfig.setBounds(10, 247, 102, 15);
		panelConfigVideoStream.add(lblSvcConrfig);
		
		jComboBoxMainStreamType = new JComboBox();
		jComboBoxMainStreamType.setBounds(423, 60, 113, 23);
		jComboBoxMainStreamType.addItem("Time");
		jComboBoxMainStreamType.addItem("Event");
		panelConfigVideoStream.add(jComboBoxMainStreamType);
		jComboBoxMainStreamType.setSelectedIndex(0);
		
		JLabel lblStramType = new JLabel("Stream Type");
		lblStramType.setBounds(311, 59, 80, 15);
		panelConfigVideoStream.add(lblStramType);
		
		JLabel lblSmoothLevel = new JLabel("Smooth Level");
		lblSmoothLevel.setBounds(10, 171, 80, 15);
		panelConfigVideoStream.add(lblSmoothLevel);
		
		jComboBoxSmoothLevel = new JComboBox<>();
		jComboBoxSmoothLevel.setBounds(100, 167, 131, 23);
		panelConfigVideoStream.add(jComboBoxSmoothLevel);
		jComboBoxSmoothLevel.addItem("L1");
		jComboBoxSmoothLevel.addItem("L2");
		jComboBoxSmoothLevel.addItem("L3");
		jComboBoxSmoothLevel.addItem("L4");
		jComboBoxSmoothLevel.addItem("L5");
		jComboBoxSmoothLevel.addItem("L6");
		jComboBoxSmoothLevel.addItem("L7");
		jComboBoxSmoothLevel.addItem("L8");
		jComboBoxSmoothLevel.addItem("L9");
		jComboBoxSmoothLevel.setSelectedIndex(0);
		jComboBoxSmoothLevel.setEnabled(true);
		
		JLabel lblUcode = new JLabel("U-Code");
		lblUcode.setBounds(311, 252, 89, 15);
		panelConfigVideoStream.add(lblUcode);
		
		jComboBoxUcode.setBounds(423, 246, 113, 23);
		panelConfigVideoStream.add(jComboBoxUcode);
		jComboBoxUcode.addItem("Off");
		jComboBoxUcode.addItem("Basic");
		jComboBoxUcode.addItem("Smart");
		jComboBoxUcode.setSelectedIndex(0);
		
		JLabel lblStreamConfigurationNot = new JLabel("Stream Configuration not support VMS");
		lblStreamConfigurationNot.setForeground(Color.RED);
		lblStreamConfigurationNot.setBounds(10, 10, 234, 15);
		panelBasciVideoConfigure.add(lblStreamConfigurationNot);
		
		JPanel panelConfigImage = new JPanel();
		tabConfigList.addTab("Image", null, panelConfigImage, null);
		panelConfigImage.setLayout(null);

		JTabbedPane tabImgConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabImgConfigList.setBounds(0, 0, 618, 481);
		panelConfigImage.add(tabImgConfigList);

		JPanel panelImageconfig = new JPanel();
		tabImgConfigList.addTab("Image ", null, panelImageconfig, null);
		panelImageconfig.setLayout(null);

		JPanel panelImageEX = new JPanel();
		tabImgConfigList.addTab("Image ex", null, panelImageEX, null);
		panelImageEX.setLayout(null);
		
		JPanel panelWhiteBalance = new JPanel();
		panelWhiteBalance.setBorder(new TitledBorder(null, "White Balance", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelWhiteBalance.setBounds(10, 10, 593, 167);
		panelImageEX.add(panelWhiteBalance);
		panelWhiteBalance.setLayout(null);

		jComboBoxWhiteBalance.setBounds(67, 36, 120, 23);
		panelWhiteBalance.add(jComboBoxWhiteBalance);
		jComboBoxWhiteBalance.addItem("AUTO");
		jComboBoxWhiteBalance.addItem("TRIMMING");
		jComboBoxWhiteBalance.addItem("INDOOR");
		jComboBoxWhiteBalance.addItem("OUTDOOR");
		jComboBoxWhiteBalance.addItem("MERCURYLAMP");
		jComboBoxWhiteBalance.addItem("NIGHT");
		jComboBoxWhiteBalance.addItem("AUTONALAMP");
		jComboBoxWhiteBalance.addItem("LOCK");
		jComboBoxWhiteBalance.addItem("SELFADAPT");
		jComboBoxWhiteBalance.addItem("AUTOSECOND");
		jComboBoxWhiteBalance.setSelectedIndex(0);

		JLabel lblModel = new JLabel("Model");
		lblModel.setBounds(20, 40, 54, 15);
		panelWhiteBalance.add(lblModel);

		JButton jButtonGetWhiteBalance = new JButton("Get");
		jButtonGetWhiteBalance.setBounds(387, 131, 93, 23);
		panelWhiteBalance.add(jButtonGetWhiteBalance);

		textRedOffSet.setBounds(307, 79, 66, 21);
		panelWhiteBalance.add(textRedOffSet);
		textRedOffSet.setColumns(10);
		textRedOffSet.setEditable(false);

		textBlueOffSet.setBounds(307, 132, 66, 21);
		panelWhiteBalance.add(textBlueOffSet);
		textBlueOffSet.setColumns(10);
		textBlueOffSet.setEditable(false);

		RedoffSetslider .setBounds(97, 79, 200, 26);
		panelWhiteBalance.add(RedoffSetslider);
		RedoffSetslider.setEnabled(false);
		RedoffSetslider.setValue(0);
		RedoffSetslider.setMinimum(-127);
		RedoffSetslider.setMaximum(127);
		
		BlueoffSetslider.setBounds(97, 127, 200, 26);
		panelWhiteBalance.add(BlueoffSetslider);
		BlueoffSetslider.setEnabled(false);
		BlueoffSetslider.setValue(0);
		BlueoffSetslider.setMaximum(127);
		BlueoffSetslider.setMinimum(-127);

		JLabel lblRedOffset = new JLabel("Red OffSet");
		lblRedOffset.setBounds(20, 87, 67, 15);
		panelWhiteBalance.add(lblRedOffset);

		JLabel lblBlueOffset = new JLabel("Blue OffSet");
		lblBlueOffset.setBounds(20, 135, 73, 15);
		panelWhiteBalance.add(lblBlueOffset);
		
		JButton jButtonSetWhiteBlance = new JButton("Set");
		jButtonSetWhiteBlance.setBounds(490, 131, 93, 23);
		panelWhiteBalance.add(jButtonSetWhiteBlance);
		
		JPanel panelResetImg = new JPanel();
		panelResetImg.setLayout(null);
		panelResetImg.setBorder(new TitledBorder(null, "Reset Img", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelResetImg.setBounds(10, 187, 199, 60);
		panelImageEX.add(panelResetImg);
		
		JButton jButtonResetImg = new JButton("Reset");
		jButtonResetImg.setBounds(55, 25, 93, 23);
		panelResetImg.add(jButtonResetImg);

		JPanel panelConfigImageInfo = new JPanel();
		panelConfigImageInfo.setBorder(new TitledBorder(null, "Image Info", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigImageInfo.setBounds(10, 10, 593, 111);
		panelImageconfig.add(panelConfigImageInfo);
		panelConfigImageInfo.setLayout(null);

		JLabel lblConfigImageInfoBrightness = new JLabel("Brightness(0~255)");
		lblConfigImageInfoBrightness.setBounds(10, 23, 113, 15);
		panelConfigImageInfo.add(lblConfigImageInfoBrightness);

		textFieldConfigImageInfoBrightness = new JTextField();
		textFieldConfigImageInfoBrightness.setBounds(122, 20, 66, 21);
		panelConfigImageInfo.add(textFieldConfigImageInfoBrightness);
		textFieldConfigImageInfoBrightness.setColumns(10);

		JLabel lblConfigImageInfoSaturation = new JLabel("Saturation(0~255)");
		lblConfigImageInfoSaturation.setBounds(223, 23, 113, 15);
		panelConfigImageInfo.add(lblConfigImageInfoSaturation);

		textFieldConfigImageInfoSaturation = new JTextField();
		textFieldConfigImageInfoSaturation.setBounds(333, 20, 66, 21);
		panelConfigImageInfo.add(textFieldConfigImageInfoSaturation);
		textFieldConfigImageInfoSaturation.setColumns(10);

		JLabel lblConfigImageInfoContrast = new JLabel("Contrast(0~255)");
		lblConfigImageInfoContrast.setBounds(10, 58, 101, 15);
		panelConfigImageInfo.add(lblConfigImageInfoContrast);

		textFieldConfigImageInfoContrast = new JTextField();
		textFieldConfigImageInfoContrast.setBounds(122, 55, 66, 21);
		panelConfigImageInfo.add(textFieldConfigImageInfoContrast);
		textFieldConfigImageInfoContrast.setColumns(10);

		JLabel lblConfigImageInfoSharpness = new JLabel("Sharpness(0~255)");
		lblConfigImageInfoSharpness.setBounds(223, 58, 113, 15);
		panelConfigImageInfo.add(lblConfigImageInfoSharpness);

		textFieldConfigImageInfoSharpness = new JTextField();
		textFieldConfigImageInfoSharpness.setBounds(333, 55, 66, 21);
		panelConfigImageInfo.add(textFieldConfigImageInfoSharpness);
		textFieldConfigImageInfoSharpness.setColumns(10);

		textFieldImageInfo2DNoiseReduce.setBounds(504, 20, 66, 21);
		panelConfigImageInfo.add(textFieldImageInfo2DNoiseReduce);
		textFieldImageInfo2DNoiseReduce.setColumns(10);
		textFieldImageInfo2DNoiseReduce.setEnabled(false);
		
		JButton jButtonGetImageInfo = new JButton("Get");
		jButtonGetImageInfo.setBounds(387, 82, 93, 23);
		panelConfigImageInfo.add(jButtonGetImageInfo);

		JButton jButtonSetImageInfo = new JButton("Set");
		jButtonSetImageInfo.setBounds(490, 82, 93, 23);
		panelConfigImageInfo.add(jButtonSetImageInfo);
		
		JLabel lbldNoisereduce = new JLabel("2D Noise(0~255)");
		lbldNoisereduce.setBounds(409, 23, 95, 15);
		panelConfigImageInfo.add(lbldNoisereduce);
		
		JLabel lbldNoise = new JLabel("3D Noise(0~255)");
		lbldNoise.setBounds(409, 58, 95, 15);
		panelConfigImageInfo.add(lbldNoise);
		
		textFieldImageInfo3DNoiseReduce = new JTextField();
		textFieldImageInfo3DNoiseReduce.setBounds(504, 55, 66, 21);
		panelConfigImageInfo.add(textFieldImageInfo3DNoiseReduce);
		textFieldImageInfo3DNoiseReduce.setColumns(10);
		textFieldImageInfo3DNoiseReduce.setEnabled(false);

		
		JPanel panelConfigImageExposure = new JPanel();
		panelConfigImageExposure.setBorder(new TitledBorder(null, "Image Exposure Info", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigImageExposure.setBounds(10, 131, 593, 283);
		panelImageconfig.add(panelConfigImageExposure);
		panelConfigImageExposure.setLayout(null);

		JLabel lblConfigImageExposureCompensation = new JLabel("Compensation");
		lblConfigImageExposureCompensation.setBounds(185, 225, 83, 15);
		panelConfigImageExposure.add(lblConfigImageExposureCompensation);

		textFieldConfigImageExposureCompensation = new JTextField();
		textFieldConfigImageExposureCompensation.setBounds(275, 222, 66, 21);
		panelConfigImageExposure.add(textFieldConfigImageExposureCompensation);
		textFieldConfigImageExposureCompensation.setColumns(10);

		JLabel lblConfigImageExposureMinShutter = new JLabel("MinShutter");
		lblConfigImageExposureMinShutter.setBounds(399, 118, 66, 15);
		panelConfigImageExposure.add(lblConfigImageExposureMinShutter);

		JLabel lblConfigImageExposureShutter = new JLabel("Shutter(s)");
		lblConfigImageExposureShutter.setBounds(399, 81, 75, 15);
		panelConfigImageExposure.add(lblConfigImageExposureShutter);

		JLabel lblConfigImageExposureDayNightSence = new JLabel("DayNightSence");
		lblConfigImageExposureDayNightSence.setBounds(185, 150, 91, 15);
		panelConfigImageExposure.add(lblConfigImageExposureDayNightSence);

		jTextFieldConfigImageExposureDayNightSence.setBounds(275, 150, 66, 21);
		panelConfigImageExposure.add(jTextFieldConfigImageExposureDayNightSence);
		jTextFieldConfigImageExposureDayNightSence.setColumns(10);

		JLabel lblConfigImageExposureMaxShutter = new JLabel("MaxShutter");
		lblConfigImageExposureMaxShutter.setBounds(399, 153, 66, 15);
		panelConfigImageExposure.add(lblConfigImageExposureMaxShutter);

		JLabel lblConfigImageExposureGain = new JLabel("Gain");
		lblConfigImageExposureGain.setBounds(10, 150, 54, 15);
		panelConfigImageExposure.add(lblConfigImageExposureGain);

		textFieldConfigImageExposureGain = new JTextField();
		textFieldConfigImageExposureGain.setBounds(70, 150, 54, 21);
		panelConfigImageExposure.add(textFieldConfigImageExposureGain);
		textFieldConfigImageExposureGain.setColumns(10);

		JLabel lblConfigImageExposureDayNightMode = new JLabel("DayNightMode");
		lblConfigImageExposureDayNightMode.setBounds(185, 118, 83, 15);
		panelConfigImageExposure.add(lblConfigImageExposureDayNightMode);

		JLabel lblConfigImageExposureMinGain = new JLabel("MinGain");
		lblConfigImageExposureMinGain.setBounds(10, 190, 54, 15);
		panelConfigImageExposure.add(lblConfigImageExposureMinGain);

		textFieldConfigImageExposureMinGain = new JTextField();
		textFieldConfigImageExposureMinGain.setBounds(70, 187, 99, 21);
		panelConfigImageExposure.add(textFieldConfigImageExposureMinGain);
		textFieldConfigImageExposureMinGain.setColumns(10);

		JLabel lblConfigImageExposureDayNightSwitch = new JLabel("NightTime");
		lblConfigImageExposureDayNightSwitch.setBounds(185, 190, 75, 15);
		panelConfigImageExposure.add(lblConfigImageExposureDayNightSwitch);

		jTextFieldConfigImageExposureDayNightSwitch.setBounds(275, 187, 66, 21);
		panelConfigImageExposure.add(jTextFieldConfigImageExposureDayNightSwitch);
		jTextFieldConfigImageExposureDayNightSwitch.setColumns(10);
		
		jTextFieldConfigImageExposureDayNightSwitch.setEnabled(false);

		JLabel lblConfigImageExposureMaxGain = new JLabel("MaxGain");
		lblConfigImageExposureMaxGain.setBounds(10, 225, 54, 15);
		panelConfigImageExposure.add(lblConfigImageExposureMaxGain);

		textFieldConfigImageExposureMaxGain = new JTextField();
		textFieldConfigImageExposureMaxGain.setBounds(70, 222, 99, 21);
		panelConfigImageExposure.add(textFieldConfigImageExposureMaxGain);
		textFieldConfigImageExposureMaxGain.setColumns(10);

		JLabel lblConfigImageExposureSloweShutter = new JLabel("Slowest Shutter");
		lblConfigImageExposureSloweShutter.setBounds(399, 190, 91, 15);
		panelConfigImageExposure.add(lblConfigImageExposureSloweShutter);

		jTextFieldConfigImageExposureSlowestShutter.setBounds(500, 187, 83, 21);
		panelConfigImageExposure.add(jTextFieldConfigImageExposureSlowestShutter);
		jTextFieldConfigImageExposureSlowestShutter.setColumns(10);

		JLabel lblConfigImageExposureWDR = new JLabel("WDR");
		lblConfigImageExposureWDR.setBounds(10, 83, 54, 15);
		panelConfigImageExposure.add(lblConfigImageExposureWDR);

		JLabel lblConfigImageExposureWDRLevel = new JLabel("WDRLevel");
		lblConfigImageExposureWDRLevel.setBounds(10, 115, 66, 15);
		panelConfigImageExposure.add(lblConfigImageExposureWDRLevel);

		jTextFieldFieldConfigImageExposureWDRLevel.setBounds(70, 115, 54, 21);
		panelConfigImageExposure.add(jTextFieldFieldConfigImageExposureWDRLevel);
		jTextFieldFieldConfigImageExposureWDRLevel.setColumns(10);
		
		jComboBoxExposureMode.setBounds(275, 81, 99, 23);
		panelConfigImageExposure.add(jComboBoxExposureMode);
		jComboBoxExposureMode.addItem("AUTOMATIC");
		jComboBoxExposureMode.addItem("CUSTOM");
		jComboBoxExposureMode.addItem("SHUTTER");
		jComboBoxExposureMode.addItem("APERTURE");
		jComboBoxExposureMode.addItem("GAIN");
		jComboBoxExposureMode.addItem("INDOOR-50");
		jComboBoxExposureMode.addItem("INDOOR-60");
		jComboBoxExposureMode.addItem("MANUAL");
		jComboBoxExposureMode.addItem("LOWER");
		jComboBoxExposureMode.setSelectedIndex(0);
		
		jCheckBoxIsEnableSlowSh.setBounds(10, 50, 146, 23);
		panelConfigImageExposure.add(jCheckBoxIsEnableSlowSh);
		
		jTextFieldConfigImageExposureDayNightSence.setEnabled(false);
		
		jComboBoxDayNightMode.setBounds(275, 115, 99, 23);
		panelConfigImageExposure.add(jComboBoxDayNightMode);
		jComboBoxDayNightMode.addItem("AUTO");
		jComboBoxDayNightMode.addItem("DAY");
		jComboBoxDayNightMode.addItem("NIGHT");
		jComboBoxDayNightMode.addItem("COLOR");
		jComboBoxDayNightMode.setSelectedIndex(0);

		jComboBoxExposureWDR.setBounds(70, 79, 99, 23);
		panelConfigImageExposure.add(jComboBoxExposureWDR);
		jComboBoxExposureWDR.addItem("CLOSE");
		jComboBoxExposureWDR.addItem("OPEN");
		jComboBoxExposureWDR.addItem("AUTO");
		jComboBoxExposureWDR.setSelectedIndex(0);
		
		jComboBoxShutter.setBounds(484, 81, 99, 23);
		panelConfigImageExposure.add(jComboBoxShutter);
		jComboBoxShutter.addItem("AUTOMATIC");
		jComboBoxShutter.addItem("TIME-1");
		jComboBoxShutter.addItem("TIME-1-2");
		jComboBoxShutter.addItem("TIME-1-3");
		jComboBoxShutter.addItem("TIME-1-4");
		jComboBoxShutter.addItem("TIME-1-6");
		jComboBoxShutter.addItem("TIME-1-8");
		jComboBoxShutter.addItem("TIME-1-10");
		jComboBoxShutter.addItem("TIME-1-12");
		jComboBoxShutter.addItem("TIME-1-15");
		jComboBoxShutter.addItem("TIME-1-20");
		jComboBoxShutter.addItem("TIME-1-25");
		jComboBoxShutter.addItem("TIME-1-30");
		jComboBoxShutter.addItem("TIME-1-50");
		jComboBoxShutter.addItem("TIME-1-60");
		jComboBoxShutter.addItem("TIME-1-100");
		jComboBoxShutter.addItem("TIME-1-120");
		jComboBoxShutter.addItem("TIME-1-150");
		jComboBoxShutter.addItem("TIME-1-180");
		jComboBoxShutter.addItem("TIME-1-200");
		jComboBoxShutter.addItem("TIME-1-250");
		jComboBoxShutter.addItem("TIME-1-500");
		jComboBoxShutter.addItem("TIME-1-1000");
		jComboBoxShutter.addItem("TIME-1-2000");
		jComboBoxShutter.addItem("TIME-1-4000");
		jComboBoxShutter.addItem("TIME-1-8000");
		jComboBoxShutter.addItem("TIME-1-50000");
		jComboBoxShutter.addItem("TIME-1-100000");
		jComboBoxShutter.setSelectedIndex(0);
		
		jComboBoxMinShutter.setBounds(484, 115, 99, 23);
		panelConfigImageExposure.add(jComboBoxMinShutter);
		jComboBoxMinShutter.addItem("TIME-1");
		jComboBoxMinShutter.addItem("TIME-1-2");
		jComboBoxMinShutter.addItem("TIME-1-3");
		jComboBoxMinShutter.addItem("TIME-1-4");
		jComboBoxMinShutter.addItem("TIME-1-6");
		jComboBoxMinShutter.addItem("TIME-1-8");
		jComboBoxMinShutter.addItem("TIME-1-10");
		jComboBoxMinShutter.addItem("TIME-1-12");
		jComboBoxMinShutter.addItem("TIME-1-15");
		jComboBoxMinShutter.addItem("TIME-1-20");
		jComboBoxMinShutter.addItem("TIME-1-25");
		jComboBoxMinShutter.addItem("TIME-1-30");
		jComboBoxMinShutter.addItem("TIME-1-50");
		jComboBoxMinShutter.addItem("TIME-1-60");
		jComboBoxMinShutter.addItem("TIME-1-100");
		jComboBoxMinShutter.addItem("TIME-1-120");
		jComboBoxMinShutter.addItem("TIME-1-150");
		jComboBoxMinShutter.addItem("TIME-1-180");
		jComboBoxMinShutter.addItem("TIME-1-200");
		jComboBoxMinShutter.addItem("TIME-1-250");
		jComboBoxMinShutter.addItem("TIME-1-500");
		jComboBoxMinShutter.addItem("TIME-1-1000");
		jComboBoxMinShutter.addItem("TIME-1-2000");
		jComboBoxMinShutter.addItem("TIME-1-4000");
		jComboBoxMinShutter.addItem("TIME-1-8000");
		jComboBoxMinShutter.addItem("TIME-1-50000");
		jComboBoxMinShutter.addItem("TIME-1-100000");
		jComboBoxMinShutter.setSelectedIndex(0);
		
		jComboBoxMaxShutter.setBounds(484, 150, 99, 23);
		panelConfigImageExposure.add(jComboBoxMaxShutter);
		jComboBoxMaxShutter.addItem("TIME-1");
		jComboBoxMaxShutter.addItem("TIME-1-2");
		jComboBoxMaxShutter.addItem("TIME-1-3");
		jComboBoxMaxShutter.addItem("TIME-1-4");
		jComboBoxMaxShutter.addItem("TIME-1-6");
		jComboBoxMaxShutter.addItem("TIME-1-8");
		jComboBoxMaxShutter.addItem("TIME-1-10");
		jComboBoxMaxShutter.addItem("TIME-1-12");
		jComboBoxMaxShutter.addItem("TIME-1-15");
		jComboBoxMaxShutter.addItem("TIME-1-20");
		jComboBoxMaxShutter.addItem("TIME-1-25");
		jComboBoxMaxShutter.addItem("TIME-1-30");
		jComboBoxMaxShutter.addItem("TIME-1-50");
		jComboBoxMaxShutter.addItem("TIME-1-60");
		jComboBoxMaxShutter.addItem("TIME-1-100");
		jComboBoxMaxShutter.addItem("TIME-1-120");
		jComboBoxMaxShutter.addItem("TIME-1-150");
		jComboBoxMaxShutter.addItem("TIME-1-180");
		jComboBoxMaxShutter.addItem("TIME-1-200");
		jComboBoxMaxShutter.addItem("TIME-1-250");
		jComboBoxMaxShutter.addItem("TIME-1-500");
		jComboBoxMaxShutter.addItem("TIME-1-1000");
		jComboBoxMaxShutter.addItem("TIME-1-2000");
		jComboBoxMaxShutter.addItem("TIME-1-4000");
		jComboBoxMaxShutter.addItem("TIME-1-8000");
		jComboBoxMaxShutter.addItem("TIME-1-50000");
		jComboBoxMaxShutter.addItem("TIME-1-100000");
		
		jComboBoxMaxShutter.setSelectedIndex(0);	
		jComboBoxMaxShutter.setEnabled(false);
		jComboBoxMinShutter.setEnabled(false);
		jComboBoxShutter.setEnabled(false);
		jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);

		JButton jButtonGetImageExposure = new JButton("Get");
		jButtonGetImageExposure.setBounds(385, 250, 93, 23);
		panelConfigImageExposure.add(jButtonGetImageExposure);
		
		JButton jButtonSetImageExposure = new JButton("Set");
		jButtonSetImageExposure.setBounds(490, 250, 93, 23);
		panelConfigImageExposure.add(jButtonSetImageExposure);
		
		JLabel lblExposeMode = new JLabel("Mode");
		lblExposeMode.setBounds(185, 83, 39, 15);
		panelConfigImageExposure.add(lblExposeMode);
		
		JLabel label = new JLabel("-100-100");
		label.setForeground(Color.RED);
		label.setBounds(350, 225, 54, 15);
		panelConfigImageExposure.add(label);
		
		JLabel label_1 = new JLabel("1-100");
		label_1.setForeground(Color.RED);
		label_1.setBounds(130, 150, 43, 15);
		panelConfigImageExposure.add(label_1);
		
		JLabel label_2 = new JLabel("1-9");
		label_2.setForeground(Color.RED);
		label_2.setBounds(130, 115, 47, 15);
		panelConfigImageExposure.add(label_2);
		
		JLabel label_3 = new JLabel("0-9");
		label_3.setForeground(Color.RED);
		label_3.setBounds(350, 150, 39, 15);
		panelConfigImageExposure.add(label_3);
		
		JLabel label_4 = new JLabel("3-120");
		label_4.setForeground(Color.RED);
		label_4.setBounds(350, 191, 54, 15);
		panelConfigImageExposure.add(label_4);
		
		JLabel lblOnlySupportIpc = new JLabel("Image Exposure Info Only Support IPC");
		lblOnlySupportIpc.setBounds(10, 25, 267, 22);
		panelConfigImageExposure.add(lblOnlySupportIpc);
		lblOnlySupportIpc.setForeground(Color.RED);

		JPanel panelConfigOSD = new JPanel();
		tabConfigList.addTab("OSD", null, panelConfigOSD, null);
		panelConfigOSD.setLayout(null);

		JTabbedPane tabOSDConfigList = new JTabbedPane(JTabbedPane.TOP);
		tabOSDConfigList.setBounds(0, 0, 618, 481);
		panelConfigOSD.add(tabOSDConfigList );

		JPanel panelOSDconfig = new JPanel();
		tabOSDConfigList.addTab("BasicOSD ", null, panelOSDconfig, null);
		panelOSDconfig.setLayout(null);

		JPanel panelOSDEX = new JPanel();
		tabOSDConfigList.addTab("OSDEX", null, panelOSDEX, null);
		panelOSDEX .setLayout(null);

		JPanel panelOSDstyle = new JPanel();
		panelOSDstyle.setBorder(new TitledBorder(null, "OSD Style", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelOSDstyle.setBounds(21, 10, 582, 359);
		panelOSDEX.add(panelOSDstyle);
		panelOSDstyle.setLayout(null);
		
		comboBoxFontStyle.setBounds(228, 27, 149, 23);
		panelOSDstyle.add(comboBoxFontStyle);
		comboBoxFontStyle.addItem("BACKGROUND");
		comboBoxFontStyle.addItem("STROKE");
		comboBoxFontStyle.addItem("HOLLOW");
		comboBoxFontStyle.addItem("NORMAL");
		comboBoxFontStyle.setSelectedIndex(0);

		comboBoxFontStyleSize.setBounds(496, 101, 76, 23);
		panelOSDstyle.add(comboBoxFontStyleSize);
		comboBoxFontStyleSize.addItem("LARGE");
		comboBoxFontStyleSize.addItem("BIG");
		comboBoxFontStyleSize.addItem("MEDIUM");
		comboBoxFontStyleSize.addItem("SMALL");
		comboBoxFontStyleSize.setSelectedIndex(0);

		comboBoxDateFormatStyle.setBounds(50, 101, 150, 23);
		panelOSDstyle.add(comboBoxDateFormatStyle);
		comboBoxDateFormatStyle.addItem("yyyy-MM-dd");
		comboBoxDateFormatStyle.addItem("MM-dd-yyyy");
		comboBoxDateFormatStyle.addItem("yyyy/MM/dd");
		comboBoxDateFormatStyle.addItem("MM/dd/yyyy");
		comboBoxDateFormatStyle.addItem("dddd yyyy MM dd");

		comboBoxDateFormatStyle.addItem("dddd MM dd yyyy");
		comboBoxDateFormatStyle.addItem("dd/MM/yyyy");
		comboBoxDateFormatStyle.addItem("MM/dd/yyyy");
		comboBoxDateFormatStyle.addItem("dd MMMM, yyyy");
		comboBoxDateFormatStyle.addItem("MMMM dd, yyyy");
		comboBoxDateFormatStyle.addItem("dddd, dd MMMM, yyyy");
		comboBoxDateFormatStyle.addItem("dddd, MMMM dd, yyyy");
		comboBoxDateFormatStyle.addItem("yyyy/MM/dd");
		comboBoxDateFormatStyle.addItem("yyyy, MMMM dd");
		comboBoxDateFormatStyle.addItem("dddd, yy, MM dd");
		comboBoxDateFormatStyle.setSelectedIndex(0);

		comboBoxFontMargin.addItem("NONE");
		comboBoxFontMargin.addItem("SINGLE");
		comboBoxFontMargin.addItem("DOUBLE");
		comboBoxFontMargin.setBounds(228, 64, 149, 23);
		panelOSDstyle.add(comboBoxFontMargin);
		comboBoxFontMargin.setSelectedIndex(0);

		comboBoxTimeFormat.setBounds(269, 101, 108, 23);
		panelOSDstyle.add(comboBoxTimeFormat);
		comboBoxTimeFormat.addItem("HH:mm:ss");
		comboBoxTimeFormat.addItem("hh:mm:ss t.t.");
		comboBoxTimeFormat.addItem("hh:mm:ss tt");
		comboBoxTimeFormat.addItem("tt hh:mm:ss");
		comboBoxTimeFormat.addItem("下午 hh:mm:ss  P.M. hh:mm:ss");
		comboBoxTimeFormat.addItem("HH:mm:ss.xxx");
		comboBoxTimeFormat.addItem("hh:mm:ss.xxx tt");
		comboBoxTimeFormat.setSelectedIndex(0);
		
		comboBoxFontMargin.setEnabled(true);
		comboBoxFontStyle.setEnabled(true);

		JButton jButtonSetOSDStyle = new JButton("Set");
		jButtonSetOSDStyle.setBounds(306, 325, 93, 23);
		panelOSDstyle.add(jButtonSetOSDStyle );
		
		JButton jButtonGetOSDStyle = new JButton("Get");
		jButtonGetOSDStyle.setBounds(164, 325, 93, 23);
		panelOSDstyle.add(jButtonGetOSDStyle);

		JLabel lblFontStyle = new JLabel("Font Style(Support IPC,VMS-IPC)");
		lblFontStyle.setBounds(14, 31, 186, 15);
		panelOSDstyle.add(lblFontStyle);

		JLabel lblFontSize = new JLabel("Font Size");
		lblFontSize.setBounds(432, 103, 54, 19);
		panelOSDstyle.add(lblFontSize);

		JLabel lblMargin = new JLabel("Margin   (Support IPC,VMS-IPC)");
		lblMargin.setBounds(14, 68, 186, 15);
		panelOSDstyle.add(lblMargin);

		JLabel lblDate = new JLabel("Date");
		lblDate.setBounds(14, 105, 37, 15);
		panelOSDstyle.add(lblDate);

		JLabel lblTime = new JLabel("Time");
		lblTime.setBounds(228, 105, 31, 15);
		panelOSDstyle.add(lblTime);
		
		JPanel OSDStylepanelAlignConfig = new JPanel();
		OSDStylepanelAlignConfig.setForeground(Color.BLACK);
		OSDStylepanelAlignConfig.setBorder(new TitledBorder(null, "OSD Style Align Configure(Support IPC,VMS-IPC)", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		OSDStylepanelAlignConfig.setBounds(14, 136, 562, 179);
		panelOSDstyle.add(OSDStylepanelAlignConfig);
		OSDStylepanelAlignConfig.setLayout(null);
		
		comboBoxFontStyleAlign.setBounds(98, 22, 108, 23);
		comboBoxFontStyleAlign.addItem("LEFT");
		comboBoxFontStyleAlign.addItem("RIGHT");
		comboBoxFontStyleAlign.setSelectedIndex(0);
		comboBoxFontStyleAlign.setEnabled(true);
		OSDStylepanelAlignConfig.add(comboBoxFontStyleAlign);
		
		JLabel lblAlign = new JLabel("Area 1");
        lblAlign.setBounds(10, 26, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign);
        
        jComboBoxFontStyleAlign2 = new JComboBox<>();
        jComboBoxFontStyleAlign2.setBounds(386, 22, 108, 23);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign2);
        jComboBoxFontStyleAlign2.addItem("LEFT");
        jComboBoxFontStyleAlign2.addItem("RIGHT");
        jComboBoxFontStyleAlign2.setSelectedIndex(0);
        
        JLabel lblAlign_1 = new JLabel("Area 2");
        lblAlign_1.setBounds(299, 26, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_1);
        
        jComboBoxFontStyleAlign3 = new JComboBox<>();
        jComboBoxFontStyleAlign3.setBounds(98, 55, 108, 23);
        jComboBoxFontStyleAlign3.addItem("LEFT");
        jComboBoxFontStyleAlign3.addItem("RIGHT");
        jComboBoxFontStyleAlign3.setSelectedIndex(0);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign3);
        
        jComboBoxFontStyleAlign4 = new JComboBox<>();
        jComboBoxFontStyleAlign4.setBounds(386, 55, 108, 23);
        jComboBoxFontStyleAlign4.addItem("LEFT");
        jComboBoxFontStyleAlign4.addItem("RIGHT");
        jComboBoxFontStyleAlign4.setSelectedIndex(0);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign4);
        
        JLabel lblAlign_3 = new JLabel("Area 4");
        lblAlign_3.setBounds(299, 59, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_3);
        
        JLabel lblAlign_2 = new JLabel("Area 3");
        lblAlign_2.setBounds(10, 59, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_2);
        
        jComboBoxFontStyleAlign5 = new JComboBox<>();
        jComboBoxFontStyleAlign5.setBounds(98, 88, 108, 23);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign5);
        jComboBoxFontStyleAlign5.addItem("LEFT");
        jComboBoxFontStyleAlign5.addItem("RIGHT");
        jComboBoxFontStyleAlign5.setSelectedIndex(0);
        
        JLabel lblAlign_4 = new JLabel("Area 5");
        lblAlign_4.setBounds(10, 92, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_4);
        
        JLabel lblAlign_5 = new JLabel("Area 6");
        lblAlign_5.setBounds(299, 92, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_5);
        
        jComboBoxFontStyleAlign6 = new JComboBox<>();
        jComboBoxFontStyleAlign6.setBounds(386, 88, 109, 23);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign6);
        jComboBoxFontStyleAlign6.addItem("LEFT");
        jComboBoxFontStyleAlign6.addItem("RIGHT");
        jComboBoxFontStyleAlign6.setSelectedIndex(0);
        
        jComboBoxFontStyleAlign7 = new JComboBox<>();
        jComboBoxFontStyleAlign7.setBounds(98, 121, 108, 23);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign7);
        jComboBoxFontStyleAlign7.addItem("LEFT");
        jComboBoxFontStyleAlign7.addItem("RIGHT");
        jComboBoxFontStyleAlign7.setSelectedIndex(0);
        
        JLabel lblAlign_6 = new JLabel("Area 7");
        lblAlign_6.setBounds(10, 125, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_6);
        
        JLabel lblAlign_7 = new JLabel("Area 8");
        lblAlign_7.setBounds(299, 125, 54, 15);
        OSDStylepanelAlignConfig.add(lblAlign_7);
        
        jComboBoxFontStyleAlign8 = new JComboBox<>();
        jComboBoxFontStyleAlign8.setBounds(386, 121, 108, 23);
        OSDStylepanelAlignConfig.add(jComboBoxFontStyleAlign8);
        jComboBoxFontStyleAlign8.addItem("LEFT");
        jComboBoxFontStyleAlign8.addItem("RIGHT");
        jComboBoxFontStyleAlign8.setSelectedIndex(0);
		
		JPanel panelConfigOSD2 = new JPanel();
		panelConfigOSD2.setBorder(new TitledBorder(null, "OSD", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigOSD2.setBounds(10, 10, 593, 275);
		panelOSDconfig.add(panelConfigOSD2);
		panelConfigOSD2.setLayout(null);

		JLabel lblConfigOSDTime = new JLabel("Time");
		lblConfigOSDTime.setBounds(10, 22, 54, 15);
		panelConfigOSD2.add(lblConfigOSDTime);

		JLabel lblConfigOSDName = new JLabel("Name");
		lblConfigOSDName.setBounds(10, 47, 54, 15);
		panelConfigOSD2.add(lblConfigOSDName);

		JLabel lblConfigOSDText1 = new JLabel("Text 1");
		lblConfigOSDText1.setBounds(10, 72, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText1);

		JLabel lblConfigOSDText2 = new JLabel("Text 2");
		lblConfigOSDText2.setBounds(10, 97, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText2);

		JLabel lblConfigOSDText3 = new JLabel("Text 3");
		lblConfigOSDText3.setBounds(10, 122, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText3);

		JLabel lblConfigOSDText4 = new JLabel("Text 4");
		lblConfigOSDText4.setBounds(10, 147, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText4);

		JLabel lblConfigOSDText5 = new JLabel("Text 5");
		lblConfigOSDText5.setBounds(10, 172, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText5);

		JLabel lblConfigOSDText6 = new JLabel("Text 6");
		lblConfigOSDText6.setBounds(10, 197, 54, 15);
		panelConfigOSD2.add(lblConfigOSDText6);

		jComboBoxConfigOSDTime1.setModel(new DefaultComboBoxModel<Object>(new String[] {"M/d/yyyy", "MM/dd/yyyy", "dd/MM/yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "dddd, MMMM dd, yyyy", "MMMM dd, yyyy", "dd MMMM, yyyy"}));
		jComboBoxConfigOSDTime1.setBounds(94, 19, 107, 21);
		panelConfigOSD2.add(jComboBoxConfigOSDTime1);

		jComboBoxConfigOSDTim2.setModel(new DefaultComboBoxModel<Object>(new String[] {"HH:mm:ss", "hh:mm:ss tt"}));
		jComboBoxConfigOSDTim2.setBounds(211, 19, 98, 21);
		panelConfigOSD2.add(jComboBoxConfigOSDTim2);

		textFieldConfigOSDName = new JTextField();
		textFieldConfigOSDName.setBounds(94, 44, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDName);
		textFieldConfigOSDName.setColumns(10);

		textFieldConfigOSDText1 = new JTextField();
		textFieldConfigOSDText1.setBounds(94, 69, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText1);
		textFieldConfigOSDText1.setColumns(10);

		textFieldConfigOSDText2 = new JTextField();
		textFieldConfigOSDText2.setBounds(94, 94, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText2);
		textFieldConfigOSDText2.setColumns(10);

		textFieldConfigOSDText3 = new JTextField();
		textFieldConfigOSDText3.setBounds(94, 119, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText3);
		textFieldConfigOSDText3.setColumns(10);

		textFieldConfigOSDText4 = new JTextField();
		textFieldConfigOSDText4.setBounds(94, 144, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText4);
		textFieldConfigOSDText4.setColumns(10);

		textFieldConfigOSDText5 = new JTextField();
		textFieldConfigOSDText5.setBounds(94, 169, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText5);
		textFieldConfigOSDText5.setColumns(10);

		textFieldConfigOSDText6 = new JTextField();
		textFieldConfigOSDText6.setBounds(94, 194, 215, 21);
		panelConfigOSD2.add(textFieldConfigOSDText6);
		textFieldConfigOSDText6.setColumns(10);

		JLabel lblConfigOSDX1 = new JLabel("x");
		lblConfigOSDX1.setBounds(315, 22, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX1);

		JLabel lblConfigOSDX2 = new JLabel("x");
		lblConfigOSDX2.setBounds(315, 47, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX2);

		JLabel lblConfigOSDX3 = new JLabel("x");
		lblConfigOSDX3.setBounds(315, 72, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX3);

		JLabel lblConfigOSDX4 = new JLabel("x");
		lblConfigOSDX4.setBounds(315, 97, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX4);

		JLabel lblConfigOSDX5 = new JLabel("x");
		lblConfigOSDX5.setBounds(315, 122, 14, 15);
		panelConfigOSD2.add(lblConfigOSDX5);

		JLabel lblConfigOSDX6 = new JLabel("x");
		lblConfigOSDX6.setBounds(315, 147, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX6);

		JLabel lblConfigOSDX7 = new JLabel("x");
		lblConfigOSDX7.setBounds(315, 172, 20, 15);
		panelConfigOSD2.add(lblConfigOSDX7);

		JLabel lblConfigOSDX8 = new JLabel("x");
		lblConfigOSDX8.setBounds(315, 197, 14, 15);
		panelConfigOSD2.add(lblConfigOSDX8);

		chckbxConfigOSDTime.setBounds(484, 18, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDTime);
		
		chckbxConfigOSDName.setBounds(483, 43, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDName);

		chckbxConfigOSDText1.setBounds(483, 68, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText1);
		
		chckbxConfigOSDText2.setBounds(483, 93, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText2);
		
		chckbxConfigOSDText3.setBounds(484, 118, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText3);
		
		chckbxConfigOSDText4.setBounds(484, 143, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText4);
		
		chckbxConfigOSDText5.setBounds(483, 168, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText5);
		
		chckbxConfigOSDText6.setBounds(483, 193, 66, 23);
		panelConfigOSD2.add(chckbxConfigOSDText6);

		textFieldConfigOSDTimeX = new JTextField();
		textFieldConfigOSDTimeX.setBounds(325, 19, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDTimeX);
		textFieldConfigOSDTimeX.setColumns(10);

		textFieldConfigOSDNameX = new JTextField();
		textFieldConfigOSDNameX.setBounds(325, 44, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDNameX);
		textFieldConfigOSDNameX.setColumns(10);

		textFieldConfigOSDText1X = new JTextField();
		textFieldConfigOSDText1X.setBounds(325, 69, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText1X);
		textFieldConfigOSDText1X.setColumns(10);

		textFieldConfigOSDText2X = new JTextField();
		textFieldConfigOSDText2X.setBounds(325, 94, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText2X);
		textFieldConfigOSDText2X.setColumns(10);

		textFieldConfigOSDText3X = new JTextField();
		textFieldConfigOSDText3X.setBounds(325, 119, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText3X);
		textFieldConfigOSDText3X.setColumns(10);

		textFieldConfigOSDText4X = new JTextField();
		textFieldConfigOSDText4X.setBounds(325, 144, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText4X);
		textFieldConfigOSDText4X.setColumns(10);

		textFieldConfigOSDText5X = new JTextField();
		textFieldConfigOSDText5X.setBounds(325, 169, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText5X);
		textFieldConfigOSDText5X.setColumns(10);

		textFieldConfigOSDText6X = new JTextField();
		textFieldConfigOSDText6X.setBounds(325, 194, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText6X);
		textFieldConfigOSDText6X.setColumns(10);

		JLabel lblConfigOSDY1 = new JLabel("y");
		lblConfigOSDY1.setBounds(401, 22, 20, 15);
		panelConfigOSD2.add(lblConfigOSDY1);

		JLabel lblConfigOSDY2 = new JLabel("y");
		lblConfigOSDY2.setBounds(401, 47, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY2);

		JLabel lblConfigOSDY3 = new JLabel("y");
		lblConfigOSDY3.setBounds(401, 72, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY3);

		JLabel lblConfigOSDY4 = new JLabel("y");
		lblConfigOSDY4.setBounds(401, 97, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY4);

		JLabel lblConfigOSDY5 = new JLabel("y");
		lblConfigOSDY5.setBounds(401, 122, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY5);

		JLabel lblConfigOSDY6 = new JLabel("y");
		lblConfigOSDY6.setBounds(401, 147, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY6);

		JLabel lblConfigOSDY7 = new JLabel("y");
		lblConfigOSDY7.setBounds(401, 172, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY7);

		JLabel lblConfigOSDY8 = new JLabel("y");
		lblConfigOSDY8.setBounds(401, 197, 14, 15);
		panelConfigOSD2.add(lblConfigOSDY8);

		textFieldConfigOSDTimeY = new JTextField();
		textFieldConfigOSDTimeY.setBounds(411, 19, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDTimeY);
		textFieldConfigOSDTimeY.setColumns(10);

		textFieldConfigOSDNameY = new JTextField();
		textFieldConfigOSDNameY.setBounds(411, 44, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDNameY);
		textFieldConfigOSDNameY.setColumns(10);

		textFieldConfigOSDText1Y = new JTextField();
		textFieldConfigOSDText1Y.setBounds(411, 69, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText1Y);
		textFieldConfigOSDText1Y.setColumns(10);

		textFieldConfigOSDText2Y = new JTextField();
		textFieldConfigOSDText2Y.setBounds(411, 94, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText2Y);
		textFieldConfigOSDText2Y.setColumns(10);

		textFieldConfigOSDText3Y = new JTextField();
		textFieldConfigOSDText3Y.setBounds(411, 119, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText3Y);
		textFieldConfigOSDText3Y.setColumns(10);

		textFieldConfigOSDText4Y = new JTextField();
		textFieldConfigOSDText4Y.setBounds(411, 144, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText4Y);
		textFieldConfigOSDText4Y.setColumns(10);

		textFieldConfigOSDText5Y = new JTextField();
		textFieldConfigOSDText5Y.setBounds(411, 169, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText5Y);
		textFieldConfigOSDText5Y.setColumns(10);

		textFieldConfigOSDText6Y = new JTextField();
		textFieldConfigOSDText6Y.setBounds(411, 194, 66, 21);
		panelConfigOSD2.add(textFieldConfigOSDText6Y);
		textFieldConfigOSDText6Y.setColumns(10);

		JButton jButtonGetOSDConfig = new JButton("Get");
		jButtonGetOSDConfig.setBounds(298, 236, 93, 23);
		panelConfigOSD2.add(jButtonGetOSDConfig);

		JButton jButtonSetOSDConfig = new JButton("Set");
		jButtonSetOSDConfig.setBounds(431, 236, 93, 23);
		panelConfigOSD2.add(jButtonSetOSDConfig);

		JPanel panelConfigIO = new JPanel();
		tabConfigList.addTab("IO", null, panelConfigIO, null);
		panelConfigIO.setLayout(null);
				
		JPanel panelConfigIOAlarmInput = new JPanel();
		panelConfigIOAlarmInput.setBorder(new TitledBorder(null, "Alarm Input", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigIOAlarmInput.setBounds(10, 10, 593, 196);
		panelConfigIO.add(panelConfigIOAlarmInput);
		panelConfigIOAlarmInput.setLayout(null);

		JScrollPane scrollPane = new JScrollPane();
		scrollPane.setBounds(10, 23, 573, 134);
		panelConfigIOAlarmInput.add(scrollPane);

		JTable tableConfigIOAlarmInput = new JTable();
		tableConfigIOAlarmInput.setModel(ConfigIOAlarmInputTableModel);
		scrollPane.setViewportView(tableConfigIOAlarmInput);
		
		JButton jButtonGetIOAlarmInput = new JButton("Get");
		jButtonGetIOAlarmInput.setBounds(244, 163, 93, 23);
		panelConfigIOAlarmInput.add(jButtonGetIOAlarmInput);
		
		JPanel panelConfigIOAlarmOutput = new JPanel();
		panelConfigIOAlarmOutput.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Alarm Output", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelConfigIOAlarmOutput.setBounds(10, 216, 593, 97);
		panelConfigIO.add(panelConfigIOAlarmOutput);
		panelConfigIOAlarmOutput.setLayout(null);

		JLabel lblConfigIOAlarmOutputIndex = new JLabel("Index");
		lblConfigIOAlarmOutputIndex.setBounds(10, 28, 54, 15);
		panelConfigIOAlarmOutput.add(lblConfigIOAlarmOutputIndex);

		JLabel lblConfigIOAlarmOutputName = new JLabel("Name");
		lblConfigIOAlarmOutputName.setBounds(171, 28, 43, 15);
		panelConfigIOAlarmOutput.add(lblConfigIOAlarmOutputName);

		textFieldlblConfigIOAlarmOutputName = new JTextField();
		textFieldlblConfigIOAlarmOutputName.setBounds(213, 25, 120, 21);
		panelConfigIOAlarmOutput.add(textFieldlblConfigIOAlarmOutputName);
		textFieldlblConfigIOAlarmOutputName.setColumns(10);
		textFieldlblConfigIOAlarmOutputName.setEditable(false);

		
		comboBoxlblConfigIOAlarmOutputStatus.setModel(new DefaultComboBoxModel<Object>(new String[] {"OPEN", "CLOSE"}));
		comboBoxlblConfigIOAlarmOutputStatus.setBounds(409, 25, 66, 21);
		panelConfigIOAlarmOutput.add(comboBoxlblConfigIOAlarmOutputStatus);

		JLabel lblConfigIOAlarmOutputStatus = new JLabel("Status");
		lblConfigIOAlarmOutputStatus.setBounds(356, 28, 43, 15);
		panelConfigIOAlarmOutput.add(lblConfigIOAlarmOutputStatus);

		JLabel lblConfigIOAlarmOutputChannelID = new JLabel("Channel ID");
		lblConfigIOAlarmOutputChannelID.setBounds(10, 68, 66, 15);
		panelConfigIOAlarmOutput.add(lblConfigIOAlarmOutputChannelID);

		textFieldConfigIOAlarmOutputChannelID = new JTextField();
		textFieldConfigIOAlarmOutputChannelID.setBounds(77, 65, 66, 21);
		panelConfigIOAlarmOutput.add(textFieldConfigIOAlarmOutputChannelID);
		textFieldConfigIOAlarmOutputChannelID.setColumns(10);
		textFieldConfigIOAlarmOutputChannelID.setEnabled(false);

		JLabel lblConfigIOAlarmOutputDelay = new JLabel("Delay(s)");
		lblConfigIOAlarmOutputDelay.setBounds(160, 68, 54, 15);
		panelConfigIOAlarmOutput.add(lblConfigIOAlarmOutputDelay);

		textFieldlblConfigIOAlarmOutputDelay = new JTextField();
		textFieldlblConfigIOAlarmOutputDelay.setBounds(213, 65, 43, 21);
		panelConfigIOAlarmOutput.add(textFieldlblConfigIOAlarmOutputDelay);
		textFieldlblConfigIOAlarmOutputDelay.setColumns(10);

		JButton jButtonTriggerIOAlarmOutput = new JButton("Trigger");
		jButtonTriggerIOAlarmOutput.setBounds(430, 63, 75, 23);
		panelConfigIOAlarmOutput.add(jButtonTriggerIOAlarmOutput);

		jComboBoxAlarmOutPutIndex.setBounds(67, 24, 76, 23);
		panelConfigIOAlarmOutput.add(jComboBoxAlarmOutPutIndex);
		
		JButton jButtonCancelTriggerIOAlarmOutput = new JButton("Clear");
		jButtonCancelTriggerIOAlarmOutput.setBounds(508, 63, 75, 23);
		panelConfigIOAlarmOutput.add(jButtonCancelTriggerIOAlarmOutput);
		
		JButton jButtonGetIOAlarmOutput = new JButton("Get");
		jButtonGetIOAlarmOutput.setBounds(273, 64, 66, 23);
        panelConfigIOAlarmOutput.add(jButtonGetIOAlarmOutput);
        
        JButton jButtonSetIOAlarmOutput = new JButton("Set");
        jButtonSetIOAlarmOutput.setBounds(342, 64, 66, 23);
        panelConfigIOAlarmOutput.add(jButtonSetIOAlarmOutput);
						
		JPanel panelConfigIOAlarmOutputChannelInfo = new JPanel();
		panelConfigIOAlarmOutputChannelInfo.setBorder(new TitledBorder(null, "Alarm Output Channel Info", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigIOAlarmOutputChannelInfo.setBounds(10, 323, 593, 119);
		panelConfigIO.add(panelConfigIOAlarmOutputChannelInfo);
		panelConfigIOAlarmOutputChannelInfo.setLayout(null);

		JLabel lblConfigIOAlarmOutputChannelDelay = new JLabel("Delay(ms)");
		lblConfigIOAlarmOutputChannelDelay.setBounds(218, 49, 81, 15);
		panelConfigIOAlarmOutputChannelInfo.add(lblConfigIOAlarmOutputChannelDelay);

		JLabel lblConfigIOAlarmOutputChannelNo = new JLabel("AlarmOutputNo.");
		lblConfigIOAlarmOutputChannelNo.setBounds(10, 52, 93, 15);
		panelConfigIOAlarmOutputChannelInfo.add(lblConfigIOAlarmOutputChannelNo);

		textFieldConfigIOAlarmOutputChannelNo = new JTextField();
		textFieldConfigIOAlarmOutputChannelNo.setBounds(100, 49, 66, 21);
		panelConfigIOAlarmOutputChannelInfo.add(textFieldConfigIOAlarmOutputChannelNo);
		textFieldConfigIOAlarmOutputChannelNo.setColumns(10);

		textFieldConfigIOAlarmOutputChannelDelay = new JTextField();
		textFieldConfigIOAlarmOutputChannelDelay.setBounds(280, 46, 66, 21);
		panelConfigIOAlarmOutputChannelInfo.add(textFieldConfigIOAlarmOutputChannelDelay);
		textFieldConfigIOAlarmOutputChannelDelay.setColumns(10);

		JLabel lblConfigIOAlarmOutputChannelDefaultStatus = new JLabel("DefaultStatus");
		lblConfigIOAlarmOutputChannelDefaultStatus.setBounds(395, 49, 81, 15);
		panelConfigIOAlarmOutputChannelInfo.add(lblConfigIOAlarmOutputChannelDefaultStatus);
		
		jComboBoxDefaultStatus.setBounds(486, 46, 97, 23);
		panelConfigIOAlarmOutputChannelInfo.add(jComboBoxDefaultStatus);
		jComboBoxDefaultStatus.addItem("OPEN");
		jComboBoxDefaultStatus.addItem("CLOSE");
		jComboBoxDefaultStatus.setSelectedIndex(0);
		
		JButton btnConfigIOAlarmOutputChannelGet = new JButton("Get");

		btnConfigIOAlarmOutputChannelGet.setBounds(195, 86, 93, 23);
		panelConfigIOAlarmOutputChannelInfo.add(btnConfigIOAlarmOutputChannelGet);

		JButton jButtonSetIOAlarmOutputChannel = new JButton("Set");
		jButtonSetIOAlarmOutputChannel.setBounds(299, 86, 93, 23);
		panelConfigIOAlarmOutputChannelInfo.add(jButtonSetIOAlarmOutputChannel);
		
		JLabel lblAlarmOutputChannel = new JLabel("Alarm Output Channel Info Not Support VMS");
		lblAlarmOutputChannel.setFont(new Font("宋体", Font.PLAIN, 14));
		lblAlarmOutputChannel.setBounds(10, 23, 306, 15);
		panelConfigIOAlarmOutputChannelInfo.add(lblAlarmOutputChannel);
		lblAlarmOutputChannel.setForeground(Color.RED);
		
		JPanel panelConfigPrivacyMask = new JPanel();
		tabConfigList.addTab("Privacy Mask", null, panelConfigPrivacyMask, null);
		panelConfigPrivacyMask.setLayout(null);

		JPanel panelConfigPrivacyMask2 = new JPanel();
		panelConfigPrivacyMask2.setBorder(new TitledBorder(null, "Privacy Mask", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelConfigPrivacyMask2.setBounds(10, 10, 593, 253);
		panelConfigPrivacyMask.add(panelConfigPrivacyMask2);
		panelConfigPrivacyMask2.setLayout(null);

		JScrollPane scrollPaneConfigPrivacyMask = new JScrollPane();
		scrollPaneConfigPrivacyMask.setBounds(10, 21, 573, 182);
		panelConfigPrivacyMask2.add(scrollPaneConfigPrivacyMask);

		tableConfigPrivacyMask = new JTable();
		tableConfigPrivacyMask.setModel(ConfigPrivacyMaskTableModel);
		scrollPaneConfigPrivacyMask.setViewportView(tableConfigPrivacyMask);

		JButton jButtonAddPrivacyMask = new JButton("Add");
		jButtonAddPrivacyMask.setBounds(175, 220, 93, 23);
		panelConfigPrivacyMask2.add(jButtonAddPrivacyMask);

		JButton jButtonDeletePrivacyMask = new JButton("Delete");
		jButtonDeletePrivacyMask.setBounds(278, 220, 93, 23);
		panelConfigPrivacyMask2.add(jButtonDeletePrivacyMask);

		JButton jButtonSetPrivacyMask = new JButton("Set");
		jButtonSetPrivacyMask.setBounds(490, 220, 93, 23);
		panelConfigPrivacyMask2.add(jButtonSetPrivacyMask);
		
		jButtonGetPrivacyMask.setBounds(387, 220, 93, 23);
		panelConfigPrivacyMask2.add(jButtonGetPrivacyMask);

		JPanel panelConfigMotion = new JPanel();
		tabConfigList.addTab("Motion", null, panelConfigMotion, null);
		panelConfigMotion.setLayout(null);

		JPanel panelConfigEquipmentMotion = new JPanel();
		panelConfigEquipmentMotion.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "MotionDetection Alarm Information", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelConfigEquipmentMotion.setBounds(10, 10, 593, 76);
		panelConfigMotion.add(panelConfigEquipmentMotion);
		panelConfigEquipmentMotion.setLayout(null);

		JLabel lblEquipmentConfigMotionHistory = new JLabel("Motion detection history（s）");
		lblEquipmentConfigMotionHistory.setBounds(10, 31, 174, 15);
		panelConfigEquipmentMotion.add(lblEquipmentConfigMotionHistory);

		textFieldConfigEquipmentMotionHistory = new JTextField();
		textFieldConfigEquipmentMotionHistory.setBounds(185, 28, 66, 21);
		panelConfigEquipmentMotion.add(textFieldConfigEquipmentMotionHistory);
		textFieldConfigEquipmentMotionHistory.setColumns(10);

		JButton jButtonGetMotionConfigure = new JButton("Get");
		jButtonGetMotionConfigure.setBounds(387, 28, 93, 23);
		panelConfigEquipmentMotion.add(jButtonGetMotionConfigure);

		JButton jButtonSetMotionConfigure = new JButton("Set");
		jButtonSetMotionConfigure.setBounds(490, 28, 93, 23);
		panelConfigEquipmentMotion.add(jButtonSetMotionConfigure);

		JPanel panelConfigChannelMotion = new JPanel();
		panelConfigChannelMotion.setLayout(null);
		panelConfigChannelMotion.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Area information", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelConfigChannelMotion.setBounds(10, 107, 593, 350);
		panelConfigMotion.add(panelConfigChannelMotion);

		jComboBoxAreaType.setBounds(10, 36, 127, 23);
		panelConfigChannelMotion.add(jComboBoxAreaType);

		JButton jButtonGetMotionArea = new JButton("Get");
		jButtonGetMotionArea.setBounds(387, 36, 93, 23);
		panelConfigChannelMotion.add(jButtonGetMotionArea);

		JButton jButtonSetMotionArea = new JButton("Set");
		jButtonSetMotionArea.setBounds(490, 36, 93, 23);
		panelConfigChannelMotion.add(jButtonSetMotionArea);

		jComboBoxAreaType.addItem("Rectangle Area");
		jComboBoxAreaType.addItem("Grid Area");

		//矩形区域元素	
		lblAreaRectangle.setBounds(10, 87, 127, 15);
		panelConfigChannelMotion.add(lblAreaRectangle);
		textFieldConfigChannelMotionRectangleAreaNum = new JTextField();
		textFieldConfigChannelMotionRectangleAreaNum.setColumns(10);
		textFieldConfigChannelMotionRectangleAreaNum.setBounds(147, 84, 66, 21);
		textFieldConfigChannelMotionRectangleAreaNum.setEditable(false);
		panelConfigChannelMotion.add(textFieldConfigChannelMotionRectangleAreaNum);
		
		jButtonModifyRectangleArea.setBounds(387, 83, 93, 23);
		panelConfigChannelMotion.add(jButtonModifyRectangleArea);
		//宏块区域元素
		
		lblAreaGridInfo.setBounds(10, 87, 127, 15);
		panelConfigChannelMotion.add(lblAreaGridInfo);
		
		jButtonModifyMacroArea.setBounds(387, 83, 93, 23);
		panelConfigChannelMotion.add(jButtonModifyMacroArea);
		{
			lblAreaRectangle.setVisible(true);
			textFieldConfigChannelMotionRectangleAreaNum.setVisible(true);
			jButtonModifyRectangleArea.setVisible(true);
			lblAreaGridInfo.setVisible(false);
			jButtonModifyMacroArea.setVisible(false);
		}

		JPanel panelConfigTemper = new JPanel();
		tabConfigList.addTab("Temper", null, panelConfigTemper, null);
		panelConfigTemper.setLayout(null);

		JPanel panelConfigTemperEquipMent = new JPanel();
		panelConfigTemperEquipMent.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Temper Alarm", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelConfigTemperEquipMent.setBounds(10, 10, 593, 66);
		panelConfigTemper.add(panelConfigTemperEquipMent);
		panelConfigTemperEquipMent.setLayout(null);

		JLabel lblConfigEquipmentTemperSensitivity = new JLabel("Sensitivity(1~100)");
		lblConfigEquipmentTemperSensitivity.setBounds(10, 30, 119, 15);
		panelConfigTemperEquipMent.add(lblConfigEquipmentTemperSensitivity);

		JButton jButtonGetTemperAlarmSensitivity = new JButton("Get");
		jButtonGetTemperAlarmSensitivity.setBounds(387, 26, 93, 23);
		panelConfigTemperEquipMent.add(jButtonGetTemperAlarmSensitivity);

		JButton jButtonSetTemperAlarmSensitivity = new JButton("Set");
		jButtonSetTemperAlarmSensitivity.setBounds(490, 26, 93, 23);
		panelConfigTemperEquipMent.add(jButtonSetTemperAlarmSensitivity);

		textFieldConfigTemperEquipmentSensitivity = new JTextField();
		textFieldConfigTemperEquipmentSensitivity.setBounds(139, 30, 66, 21);
		panelConfigTemperEquipMent.add(textFieldConfigTemperEquipmentSensitivity);
		textFieldConfigTemperEquipmentSensitivity.setColumns(10);

		JPanel panelConfigTemperChannel = new JPanel();
		panelConfigTemperChannel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Temper Detection", TitledBorder.LEADING, TitledBorder.TOP, null, new Color(0, 0, 0)));
		panelConfigTemperChannel.setBounds(10, 86, 593, 135);
		panelConfigTemper.add(panelConfigTemperChannel);
		panelConfigTemperChannel.setLayout(null);

		JLabel lblConfigChannelTemperSensitivity = new JLabel("Sensitivity(1~100)");
		lblConfigChannelTemperSensitivity.setBounds(10, 58, 119, 15);
		panelConfigTemperChannel.add(lblConfigChannelTemperSensitivity);

		chckbxConfigTamperChannelEnable.setBounds(139, 23, 66, 23);
		panelConfigTemperChannel.add(chckbxConfigTamperChannelEnable);

		JButton jButtonGetTemperDetection = new JButton("Get");
		jButtonGetTemperDetection.setBounds(387, 23, 93, 23);
		panelConfigTemperChannel.add(jButtonGetTemperDetection);

		JButton jButtonSetTemperDetection = new JButton("Set");
		jButtonSetTemperDetection.setBounds(490, 23, 93, 23);
		panelConfigTemperChannel.add(jButtonSetTemperDetection);

		textFieldConfigTemperChannelSensitivity = new JTextField();
		textFieldConfigTemperChannelSensitivity.setBounds(139, 58, 66, 21);
		panelConfigTemperChannel.add(textFieldConfigTemperChannelSensitivity);
		textFieldConfigTemperChannelSensitivity.setColumns(10);

		JLabel lblDuration = new JLabel("Duration(1~10)");
		lblDuration.setBounds(10, 100, 119, 15);
		panelConfigTemperChannel.add(lblDuration);

		textFieldConfigTemperChannelDuration = new JTextField();
		textFieldConfigTemperChannelDuration.setColumns(10);
		textFieldConfigTemperChannelDuration.setBounds(139, 100, 66, 21);
		panelConfigTemperChannel.add(textFieldConfigTemperChannelDuration);

		JLabel lblNoteonlySupportIpc = new JLabel("Note: Set duration only support IPC");
		lblNoteonlySupportIpc.setBounds(215, 101, 244, 18);
		panelConfigTemperChannel.add(lblNoteonlySupportIpc);
		lblNoteonlySupportIpc.setVerticalAlignment(SwingConstants.TOP);
		lblNoteonlySupportIpc.setHorizontalAlignment(SwingConstants.LEFT);
		lblNoteonlySupportIpc.setForeground(Color.RED);
		lblNoteonlySupportIpc.setFont(new Font("微软雅黑", Font.PLAIN, 14));

		JLabel lblChannel = new JLabel("ChannelTemperSet");
		lblChannel.setBounds(10, 23, 119, 15);
		panelConfigTemperChannel.add(lblChannel);
		
		JPanel panelConfigServer = new JPanel();
		tabConfigList.addTab("Server", null, panelConfigServer, null);
		panelConfigServer.setLayout(null);
		
		JTabbedPane tabServerList = new JTabbedPane(JTabbedPane.TOP);
		tabServerList.setBounds(0, 0, 615, 455);
		panelConfigServer.add(tabServerList);

		JPanel panelConfigTemperSmartServer = new JPanel();
		panelConfigTemperSmartServer.setToolTipText("");
		tabServerList.addTab("Smart Server",null,panelConfigTemperSmartServer,null);
		panelConfigTemperSmartServer.setVisible(true);
		panelConfigTemperSmartServer.setLayout(null);
		
		JScrollPane scrollPaneConfigSmartServer = new JScrollPane(SmartServerTable,
				JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
	    		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPaneConfigSmartServer.setBounds(0, 0, 615, 390);
		panelConfigTemperSmartServer.add(scrollPaneConfigSmartServer, BorderLayout.CENTER);
	    		
		headerNames.add("Index");
		headerNames.add("Enable");
        headerNames.add("Protocol");
        headerNames.add("CameraId");
        headerNames.add("TollgateId");
        headerNames.add("ServerAddr");
        headerNames.add("ServerPort");
        headerNames.add("DriveWayId");
        headerNames.add("DirectionId");
        headerNames.add("DeviceId");
        headerNames.add("AreaId");          
        
        SmartServerTable.setModel(SmartServertableModel);
        SmartServerTable.getColumnModel().getColumn(0).setPreferredWidth(32);
        SmartServerTable.getColumnModel().getColumn(1).setPreferredWidth(39);
        SmartServerTable.getColumnModel().getColumn(2).setPreferredWidth(46);
        SmartServerTable.getColumnModel().getColumn(3).setPreferredWidth(51);
        SmartServerTable.getColumnModel().getColumn(4).setPreferredWidth(51);
        SmartServerTable.getColumnModel().getColumn(5).setPreferredWidth(61);
        SmartServerTable.getColumnModel().getColumn(6).setPreferredWidth(61);
        SmartServerTable.getColumnModel().getColumn(7).setPreferredWidth(61);
        SmartServerTable.getColumnModel().getColumn(8).setPreferredWidth(57);
        SmartServerTable.getColumnModel().getColumn(9).setPreferredWidth(46);
        SmartServerTable.getColumnModel().getColumn(10).setPreferredWidth(36);
        SmartServerTable.getTableHeader().setDefaultRenderer(new CheckHeaderCellRenderer(SmartServerTable));
        
        JLabel lblProtocoltypetcp = new JLabel("protocolType: 1-TCP;4-FTP;51-HTTP");
        lblProtocoltypetcp.setForeground(Color.RED);
        lblProtocoltypetcp.setBackground(Color.WHITE);
        lblProtocoltypetcp.setBounds(355, 395, 245, 16);
        panelConfigTemperSmartServer.add(lblProtocoltypetcp);
        
        jButtonGetSmartServer.setBounds(119, 395, 93, 23);
        panelConfigTemperSmartServer.add(jButtonGetSmartServer);

        JButton jButtonSetSmartServer = new JButton("Set");
        jButtonSetSmartServer.setBounds(222, 395, 93, 23);
        panelConfigTemperSmartServer.add(jButtonSetSmartServer);
	    		
	    JPanel jPanelUser = new JPanel();
	    jPanelUser.setForeground(Color.BLACK);
	    tabFunList.addTab("User", null, jPanelUser, null);
	    jPanelUser.setLayout(null);
	    JPanel jPanelUserList = new JPanel();
	    jPanelUserList.setBorder(new TitledBorder(null, "User List", TitledBorder.LEADING, TitledBorder.TOP, null, null));
	    jPanelUserList.setBounds(10, 34, 598, 161);
	    jPanelUser.add(jPanelUserList);
	    jPanelUserList.setLayout(null);
	    JScrollPane jScrollPaneUserList = new JScrollPane();
	    jScrollPaneUserList.setBounds(10, 20, 578, 100);
	    jPanelUserList.add(jScrollPaneUserList);
	    jTableUserList = new JTable();
	    jTableUserList.setModel(UserListTableModel);
	    jScrollPaneUserList.setViewportView(jTableUserList);
	    
	    jButtonUserListGetUserList = new JButton("GetUserList");
	    jButtonUserListGetUserList.setBounds(360, 130, 106, 23);
	    jPanelUserList.add(jButtonUserListGetUserList);
	    
	    JButton jButtonUserListDeleteUser = new JButton("DeleteUser");
	    jButtonUserListDeleteUser.setBounds(476, 130, 106, 23);
	    jPanelUserList.add(jButtonUserListDeleteUser);
	    
	    JButton jButtonUserListGetUserInfo = new JButton("UserInfo");
	    jButtonUserListGetUserInfo.setBounds(10, 130, 106, 23);
	    jPanelUserList.add(jButtonUserListGetUserInfo);
	    
	    JPanel jPanelAddUser = new JPanel();
	    jPanelAddUser.setBounds(10, 205, 598, 55);
	    jPanelAddUser.setBorder(new TitledBorder(null, "Add User", TitledBorder.LEADING, TitledBorder.TOP, null, null));
	    jPanelAddUser.setLayout(null);
	    jPanelUser.add(jPanelAddUser);
	    
	    JLabel jLabelAddUserUserName = new JLabel("UserName");
	    jLabelAddUserUserName.setBounds(10, 21, 66, 15);
	    jPanelAddUser.add(jLabelAddUserUserName);
	    
	    jTextFieldAddUserUserName = new JTextField();
	    jTextFieldAddUserUserName.setBounds(94, 18, 66, 21);
	    jTextFieldAddUserUserName.setColumns(10);
	    jPanelAddUser.add(jTextFieldAddUserUserName);
	    
	    JLabel jLabelAddUserPasswd = new JLabel("Password");
	    jLabelAddUserPasswd.setBounds(183, 21, 61, 15);
	    jPanelAddUser.add(jLabelAddUserPasswd);
	    
	    jTextFieldlAddUserPasswd = new JPasswordField();
	    jTextFieldlAddUserPasswd.setColumns(10);
	    jTextFieldlAddUserPasswd.setBounds(254, 18, 66, 21);
	    jPanelAddUser.add(jTextFieldlAddUserPasswd);
	    
	    JLabel jLabellAddUserUserType = new JLabel("User Type");
	    jLabellAddUserUserType.setBounds(340, 21, 65, 15);
	    jPanelAddUser.add(jLabellAddUserUserType);
	    
	    jComboBoxAddUserUserType.setModel(new DefaultComboBoxModel<Object>(new String[] {"OPERATOR", "USER"}));
	    jComboBoxAddUserUserType.setBounds(415, 18, 97, 21);
	    jPanelAddUser.add(jComboBoxAddUserUserType);
	    
	    JButton jButtonAddUserAdd = new JButton("Add");
	    jButtonAddUserAdd.setBounds(522, 17, 66, 23);
	    jPanelAddUser.add(jButtonAddUserAdd);
	    
	    JPanel jPanelModifyUser = new JPanel();
	    jPanelModifyUser.setBorder(new TitledBorder(null, "Modify User", TitledBorder.LEADING, TitledBorder.TOP, null, null));
	    jPanelModifyUser.setBounds(10, 270, 598, 99);
	    jPanelModifyUser.setLayout(null);
	    jPanelUser.add(jPanelModifyUser);
	    
	    JLabel jLabelModifyUserUserName = new JLabel("User Name");
	    jLabelModifyUserUserName.setBounds(10, 25, 72, 15);
	    jPanelModifyUser.add(jLabelModifyUserUserName);
	    
	    jTextFieldModifyUserUserName = new JTextField();
	    jTextFieldModifyUserUserName.setBounds(92, 22, 80, 21);
	    jPanelModifyUser.add(jTextFieldModifyUserUserName);
	    jTextFieldModifyUserUserName.setColumns(10);
	    
	    JLabel jLabelModifyUserOldPassword = new JLabel("Old Password");
	    jLabelModifyUserOldPassword.setBounds(182, 25, 85, 15);
	    jPanelModifyUser.add(jLabelModifyUserOldPassword);
	    
	    jTextFieldModifyUserOldPassword = new JPasswordField();
	    jTextFieldModifyUserOldPassword.setBounds(277, 22, 80, 21);
	    jPanelModifyUser.add(jTextFieldModifyUserOldPassword);
	    jTextFieldModifyUserOldPassword.setColumns(10);
	    
	    JLabel jLabelModifyUserUserType = new JLabel("User Type");
	    jLabelModifyUserUserType.setBounds(10, 61, 68, 15);
	    jPanelModifyUser.add(jLabelModifyUserUserType);
	    
	    jComboBoxModifyUserUserType.setModel(new DefaultComboBoxModel<Object>(new String[] {"OPERATOR", "USER"}));
	    jComboBoxModifyUserUserType.setBounds(92, 59, 96, 21);
	    jPanelModifyUser.add(jComboBoxModifyUserUserType);
	    jTextFieldModifyUserUserName.setEditable(false);
	    jTextFieldModifyUserOldPassword.setEditable(false);
	    
	    JButton jButtonModifyUserModify = new JButton("Modify");
	    jButtonModifyUserModify.setBounds(208, 57, 93, 23);
	    jPanelModifyUser.add(jButtonModifyUserModify);
	    
	    JLabel jLabelModifyUserNote = new JLabel("Note: This function is available for NVR only");
	    jLabelModifyUserNote.setForeground(Color.RED);
	    jLabelModifyUserNote.setBounds(310, 61, 278, 15);
	    jPanelModifyUser.add(jLabelModifyUserNote);
	    
	    JLabel jLabelModifyUserNewPasswd = new JLabel("New Password");
	    jLabelModifyUserNewPasswd.setBounds(378, 25, 96, 15);
	    jPanelModifyUser.add(jLabelModifyUserNewPasswd);
	    
	    jTextFieldlblModifyUserNewPasswd = new JPasswordField();
	    jTextFieldlblModifyUserNewPasswd.setBounds(471, 22, 117, 21);
	    jTextFieldlblModifyUserNewPasswd.setColumns(10);
	    jPanelModifyUser.add(jTextFieldlblModifyUserNewPasswd);
	    
	    JLabel jLabelOnlySupportIpc_1 = new JLabel("This User Module Only Support NVR");
	    jLabelOnlySupportIpc_1.setForeground(Color.RED);
	    jLabelOnlySupportIpc_1.setBounds(10, 10, 228, 24);
	    jPanelUser.add(jLabelOnlySupportIpc_1);
	    
	    JPanel jPanelMaintenance = new JPanel();
	    jPanelMaintenance.setLayout(null);
	    tabFunList.addTab("Maintenance", null, jPanelMaintenance, null);
	    
	    JPanel jPanelMaintenanceReboot = new JPanel();
	    jPanelMaintenanceReboot.setBounds(10, 10, 598, 59);
	    jPanelMaintenanceReboot.setBorder(new TitledBorder(null, "Maintenance", TitledBorder.LEADING, TitledBorder.TOP, null, null));
	    jPanelMaintenanceReboot.setLayout(null);
	    jPanelMaintenance.add(jPanelMaintenanceReboot);
	    
	    JButton jButtonMaintenanceReboot = new JButton("Reboot");
        jButtonMaintenanceReboot.setBounds(10, 21, 93, 23);
        jPanelMaintenanceReboot.add(jButtonMaintenanceReboot);
        
        JButton jButtonMaintenanceFactoryDefault = new JButton("Factory Default");
        jButtonMaintenanceFactoryDefault.setBounds(155, 21, 123, 23);
        jButtonMaintenanceFactoryDefault.setEnabled(false);
        jButtonMaintenanceFactoryDefault.setVisible(false); 
        jPanelMaintenanceReboot.add(jButtonMaintenanceFactoryDefault);
        
        JPanel jPanelMaintenanceManualRecord = new JPanel();
        jPanelMaintenanceManualRecord.setBorder(new TitledBorder(null, "Manual Record", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelMaintenanceManualRecord.setBounds(10, 79, 598, 59);
        jPanelMaintenanceManualRecord.setLayout(null);
        jPanelMaintenance.add(jPanelMaintenanceManualRecord);
        
        JButton jButtonMaintenanceManualRecordStart = new JButton("Start");
        jButtonMaintenanceManualRecordStart.setBounds(10, 21, 93, 23);
        jPanelMaintenanceManualRecord.add(jButtonMaintenanceManualRecordStart);
        
        JButton jButtonMaintenanceManualRecordStop = new JButton("Stop");
        jButtonMaintenanceManualRecordStop.setBounds(158, 21, 93, 23);
        jPanelMaintenanceManualRecord.add(jButtonMaintenanceManualRecordStop);
        
        JPanel jPanelMaintenanceManualConfiguration = new JPanel();
        jPanelMaintenanceManualConfiguration.setBorder(new TitledBorder(null, "Configuration", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelMaintenanceManualConfiguration.setBounds(10, 148, 598, 59);
        jPanelMaintenanceManualConfiguration.setLayout(null);
        jPanelMaintenance.add(jPanelMaintenanceManualConfiguration);
        
        JButton jButtonMaintenanceManualConfigurationExport = new JButton("Export");
        jButtonMaintenanceManualConfigurationExport.setBounds(10, 23, 93, 23);
        jPanelMaintenanceManualConfiguration.add(jButtonMaintenanceManualConfigurationExport);
        
        JLabel jLabelMaintenanceManualConfigurationImport = new JLabel("Import Configuration");
        jLabelMaintenanceManualConfigurationImport.setBounds(113, 27, 129, 15);
        jLabelMaintenanceManualConfigurationImport.setEnabled(false);
        jPanelMaintenanceManualConfiguration.add(jLabelMaintenanceManualConfigurationImport);
        
        jTextFieldMaintenanceManualConfigurationImport = new JTextField();
        jTextFieldMaintenanceManualConfigurationImport.setBounds(252, 24, 164, 21);
        jTextFieldMaintenanceManualConfigurationImport.setColumns(10);
        jTextFieldMaintenanceManualConfigurationImport.setEnabled(false);
        jPanelMaintenanceManualConfiguration.add(jTextFieldMaintenanceManualConfigurationImport);
        
        JButton jButtonMaintenanceManualConfigurationBrowse = new JButton("Browse");
        jButtonMaintenanceManualConfigurationBrowse.setBounds(426, 23, 80, 23);
        jPanelMaintenanceManualConfiguration.add(jButtonMaintenanceManualConfigurationBrowse);
        
        JButton jButtonMaintenanceManualConfigurationImport = new JButton("Import");
        jButtonMaintenanceManualConfigurationImport.setBounds(513, 23, 80, 23);
        jPanelMaintenanceManualConfiguration.add(jButtonMaintenanceManualConfigurationImport);
        
        JPanel jPanelLog = new JPanel();
        jPanelLog.setBorder(new TitledBorder(null, "FindLog", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelLog.setLayout(null);
        jPanelLog.setBounds(10, 217, 193, 59);
        jPanelMaintenance.add(jPanelLog);
        
        JButton jButtonMaintenanceLookLog = new JButton("Look up");
        jButtonMaintenanceLookLog.setEnabled(true);
        jButtonMaintenanceLookLog.setBounds(50, 22, 93, 23);
        jPanelLog.add(jButtonMaintenanceLookLog);
        
        JPanel jPanelAlarmSearch = new JPanel();
        jPanelAlarmSearch.setBorder(new TitledBorder(null, "AlarmSearch", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelAlarmSearch.setBounds(212, 217, 193, 59);      
        jPanelAlarmSearch.setLayout(null);
        jPanelMaintenance.add(jPanelAlarmSearch);
        
        JButton jButtonMaintenanceAlarmFind = new JButton("Look up");
        jButtonMaintenanceAlarmFind.setBounds(50, 22, 93, 23);
        jButtonMaintenanceAlarmFind.setEnabled(true);
        jPanelAlarmSearch.add(jButtonMaintenanceAlarmFind);
        
        JPanel jPanelAlarmLog = new JPanel();
        jPanelAlarmLog.setLayout(null);
        jPanelAlarmLog.setBorder(new TitledBorder(null, "AlarmLog", TitledBorder.LEADING, TitledBorder.TOP, null, null));
        jPanelAlarmLog.setBounds(415, 217, 193, 59);
        jPanelMaintenance.add(jPanelAlarmLog);
        
        JButton jButtonMaintenanceAlarmLog = new JButton("Look up");
        jButtonMaintenanceAlarmLog.setEnabled(true);
        jButtonMaintenanceAlarmLog.setBounds(50, 22, 93, 23);
        jPanelAlarmLog.add(jButtonMaintenanceAlarmLog);
        
        JPanel ObjectSearchPanel = new JPanel();
		tabFunList.addTab("ObjectSearch", null, ObjectSearchPanel, null);
		ObjectSearchPanel.setLayout(null);
		
		JPanel ObjectSearch1panel = new JPanel();
		ObjectSearch1panel.setBorder(new TitledBorder(null, "Search", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		ObjectSearch1panel.setBounds(10, 10, 598, 471);
		ObjectSearchPanel.add(ObjectSearch1panel);
		ObjectSearch1panel.setLayout(null);
		
		JLabel lblNewLabel1 = new JLabel("Search Object");
		lblNewLabel1.setBounds(10, 32, 84, 15);
		ObjectSearch1panel.add(lblNewLabel1);
	   
		JScrollPane scrollPane_1 = new JScrollPane();
		scrollPane_1.setBounds(10, 142, 578, 129);
		ObjectSearch1panel.add(scrollPane_1);
		
		ObjectSearchTable = new JTable();
		ObjectSearchTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ObjectSearchTable.setModel(ObjectSearchModel);
		ObjectSearchTable.getColumnModel().getColumn(0).setPreferredWidth(85);
		scrollPane_1.setViewportView(ObjectSearchTable);
		
		comboBox.setBounds(124, 28, 146, 23);
		ObjectSearch1panel.add(comboBox);
		comboBox.insertItemAt("ALL", 0);
		comboBox.insertItemAt("Face", 1);
		comboBox.insertItemAt("Person", 2);
		comboBox.insertItemAt("Non Motor Vehicle", 3);
		comboBox.insertItemAt("Vehicle", 4);
		comboBox.setSelectedIndex(0);
		
		JLabel lblNewLabel_11 = new JLabel("Alarm Type");
		lblNewLabel_11.setBounds(10, 69, 84, 15);
		ObjectSearch1panel.add(lblNewLabel_11);
		
		comboBox_1.setBounds(124, 65, 146, 23);
		ObjectSearch1panel.add(comboBox_1);
		comboBox_1.insertItemAt("ALL", 0);
		comboBox_1.insertItemAt("LINE CROSS", 1);
		comboBox_1.insertItemAt("OBJECTS INSIDE", 2);
		comboBox_1.insertItemAt("ENTER AREA", 3);
		comboBox_1.insertItemAt("LEAVE AREA", 4);
		comboBox_1.setSelectedIndex(0);
		
		JLabel lblNewLabel_Begin = new JLabel("Begin Time");
		lblNewLabel_Begin.setBounds(10, 117, 75, 15);
		ObjectSearch1panel.add(lblNewLabel_Begin);
		
		JLabel lblNewLabel_End = new JLabel("End Time");
		lblNewLabel_End.setBounds(280, 117, 54, 15);
		ObjectSearch1panel.add(lblNewLabel_End);
		
		textField_BeginTime = new JTextField();
		textField_BeginTime.setBounds(124, 114, 132, 21);
		ObjectSearch1panel.add(textField_BeginTime);
		textField_BeginTime.setColumns(10);
		textField_BeginTime.setText(Common.timeStamp2Date(String.valueOf(Common.timeStamp()-24*3600), DateFormat));
		
		textField_EndTime = new JTextField();
		textField_EndTime.setBounds(354, 114, 123, 21);
		ObjectSearch1panel.add(textField_EndTime);
		textField_EndTime.setColumns(10);
		textField_EndTime.setText(Common.timeStamp2Date(String.valueOf(Common.timeStamp()-24*3600), DateFormat));
		
		JButton btnNewButton = new JButton("ObjectFind");
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.objectfind();
			}
		});
		btnNewButton.setBounds(487, 65, 101, 23);
		ObjectSearch1panel.add(btnNewButton);
		
		JButton btnNewButton_1 = new JButton("AlarmFind");
		btnNewButton_1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.findAlarm();
			}
		});
		btnNewButton_1.setBounds(487, 113, 101, 23);
		ObjectSearch1panel.add(btnNewButton_1);
		
		JLabel lblNewLabel_4 = new JLabel("Total");
		lblNewLabel_4.setBounds(78, 272, 54, 15);
		ObjectSearch1panel.add(lblNewLabel_4);
		
		textField_Total = new JTextField();
		textField_Total.setEditable(false);
		textField_Total.setBounds(143, 269, 66, 21);
		ObjectSearch1panel.add(textField_Total);
		textField_Total.setColumns(10);
		
		JLabel lblNewLabel_5 = new JLabel("Remain");
		lblNewLabel_5.setBounds(230, 272, 54, 15);
		ObjectSearch1panel.add(lblNewLabel_5);
		
		textField_Remain = new JTextField();
		textField_Remain.setEditable(false);
		textField_Remain.setBounds(305, 269, 66, 21);
		ObjectSearch1panel.add(textField_Remain);
		textField_Remain.setColumns(10);
		
		btnNewButton_2 = new JButton("Next");
		btnNewButton_2.setEnabled(false);
		btnNewButton_2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.objectfindNext();
			}
		});
		btnNewButton_2.setBounds(397, 268, 66, 23);
		ObjectSearch1panel.add(btnNewButton_2);
		
		btnNewButton_3 = new JButton("GetSmallPic");
		btnNewButton_3.setEnabled(false);
		btnNewButton_3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.getSmallPic();
			}
		});
		btnNewButton_3.setBounds(483, 269, 105, 23);
		ObjectSearch1panel.add(btnNewButton_3);
		
		
		JScrollPane scrollPane_3 = new JScrollPane();
		scrollPane_3.setBounds(10, 292, 578, 147);
		ObjectSearch1panel.add(scrollPane_3);
		
		ObjectAlarmTable = new JTable();
		ObjectAlarmTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ObjectAlarmTable.setModel(AlarmSearchModel);
		ObjectAlarmTable.getColumnModel().getColumn(0).setPreferredWidth(85);
		scrollPane_3.setViewportView(ObjectAlarmTable);
		
		JLabel lblNewLabel_6 = new JLabel("Total");
		lblNewLabel_6.setBounds(78, 443, 54, 15);
		ObjectSearch1panel.add(lblNewLabel_6);
		
		textField_AlarmTotal = new JTextField();
		textField_AlarmTotal.setEditable(false);
		textField_AlarmTotal.setBounds(143, 440, 66, 21);
		ObjectSearch1panel.add(textField_AlarmTotal);
		textField_AlarmTotal.setColumns(10);
		
		JLabel lblNewLabel_7 = new JLabel("Remain");
		lblNewLabel_7.setBounds(230, 443, 54, 15);
		ObjectSearch1panel.add(lblNewLabel_7);
		
		textField_AlarmRemain = new JTextField();
		textField_AlarmRemain.setEditable(false);
		textField_AlarmRemain.setBounds(305, 440, 66, 21);
		ObjectSearch1panel.add(textField_AlarmRemain);
		textField_AlarmRemain.setColumns(10);
		
		btnNewButton_4 = new JButton("Next");
		btnNewButton_4.setEnabled(false);
		btnNewButton_4.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.findNextAlarm();
			}
		});
		btnNewButton_4.setBounds(397, 439, 66, 23);
		ObjectSearch1panel.add(btnNewButton_4);
		
		JButton btnNewButton_5 = new JButton("GetRelatedData");
		btnNewButton_5.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				objectsearch.getRelatedData();
			}
		});
		btnNewButton_5.setBounds(473, 439, 115, 23);
		ObjectSearch1panel.add(btnNewButton_5);
		

        if(0 == UserListTableModel.getRowCount()  || jTableUserList.getSelectedRow() < 0)
        {
            jTableUserList.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
                @Override
                public void valueChanged(ListSelectionEvent e) {
                    try {
                        changeName=(String)jTableUserList.getValueAt(jTableUserList.getSelectedRow(), 1);
                        jTextFieldModifyUserUserName.setText(changeName);
                        if(jTextFieldLoginUserName.getText().equals(changeName)) {
                            jTextFieldModifyUserOldPassword.setText(jPasswordFieldLoginPassword.getText());  
                        }else {
                            jTextFieldModifyUserOldPassword.setText(null);
                        }
                    }catch(Exception m) {
                        
                    }
                }
            });
        }
        
		panelPlayLabel.setBounds(643, 245, 687, 452);
        frame.getContentPane().add(panelPlayLabel);
        panelPlayLabel.setBackground(Color.LIGHT_GRAY);
		JTabbedPane tabDevLoginList = new JTabbedPane(JTabbedPane.TOP);
		tabDevLoginList.setBounds(10, 10, 278, 259);
		frame.getContentPane().add(tabDevLoginList);

		JPanel LocalLoginPanel = new JPanel();
		tabDevLoginList.addTab("Local Login", null, LocalLoginPanel, null);
		LocalLoginPanel.setLayout(null);

		JLabel lblIp = new JLabel("IP:");
		lblIp.setBounds(10, 9, 47, 15);
		LocalLoginPanel.add(lblIp);

		jTextFieldLoginIP = new JTextField();
		jTextFieldLoginIP.setBounds(87, 6, 140, 21);
		LocalLoginPanel.add(jTextFieldLoginIP);
		jTextFieldLoginIP.setColumns(10);

		jTextFieldLoginPort = new JTextField();
		jTextFieldLoginPort.setBounds(87, 34, 140, 21);
		LocalLoginPanel.add(jTextFieldLoginPort);
		jTextFieldLoginPort.setColumns(10);

		JLabel lblUsername = new JLabel("UserName:");
		lblUsername.setBounds(10, 65, 67, 15);
		LocalLoginPanel.add(lblUsername);

		jTextFieldLoginUserName = new JTextField();
		jTextFieldLoginUserName.setBounds(87, 62, 140, 21);
		LocalLoginPanel.add(jTextFieldLoginUserName);
		jTextFieldLoginUserName.setColumns(10);

		JLabel lblPassword = new JLabel("Password:");
		lblPassword.setBounds(10, 93, 67, 15);
		LocalLoginPanel.add(lblPassword);

		jPasswordFieldLoginPassword = new JPasswordField();
		jPasswordFieldLoginPassword.setBounds(87, 90, 140, 21);
		LocalLoginPanel.add(jPasswordFieldLoginPassword);
		jPasswordFieldLoginPassword.setColumns(10);

		JLabel lblPort = new JLabel("Port:");
		lblPort.setBounds(10, 37, 54, 15);
		LocalLoginPanel.add(lblPort);

		jButtonLogIn = new JButton("Login");
		jButtonLogIn.setBounds(36, 202, 80, 23);
		LocalLoginPanel.add(jButtonLogIn);

		jButtonLogOut = new JButton("Logout");
		jButtonLogOut.setEnabled(false);
		jButtonLogOut.setBounds(136, 202, 80, 23);
		LocalLoginPanel.add(jButtonLogOut);

		JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);
		tabbedPane.setBounds(643, 10, 687, 229);
		frame.getContentPane().add(tabbedPane);
		
		JPanel DiscoveryPanel = new JPanel();
		tabbedPane.addTab("Discovery", null, DiscoveryPanel, null);
		DiscoveryPanel.setLayout(null);

		JScrollPane DiscoveryScrollPane = new JScrollPane();
		DiscoveryScrollPane.setEnabled(false);
		DiscoveryScrollPane.setBounds(10, 10, 662, 145);
		DiscoveryPanel.add(DiscoveryScrollPane);

		DiscoveryTable = new JTable(DiscoveryTableModel) {
		    public boolean isCellEditable(int row,int column) {
		    	return false;
		    }
		};
		DiscoveryScrollPane.setViewportView(DiscoveryTable);
		
		JButton btnDiscovery = new JButton("Discovery");
		btnDiscovery.setBounds(390, 165, 94, 23);
		DiscoveryPanel.add(btnDiscovery);

		jTextFieldStartIP = new JTextField();
		jTextFieldStartIP.setBounds(65, 167, 114, 21);
		DiscoveryPanel.add(jTextFieldStartIP);
		jTextFieldStartIP.setColumns(10);

		JLabel jLabelStartIp = new JLabel("StartIP:");
        jLabelStartIp.setBounds(10, 165, 55, 22);
        DiscoveryPanel.add(jLabelStartIp);

		jTextFieldEndIP = new JTextField();
		jTextFieldEndIP.setBounds(243, 167, 114, 21);
		DiscoveryPanel.add(jTextFieldEndIP);
		jTextFieldEndIP.setColumns(10);

		JLabel jLabelEndIp = new JLabel("EndIP:");
	    jLabelEndIp.setBounds(199, 167, 46, 22);
	    DiscoveryPanel.add(jLabelEndIp);
		
	    jButtonCheckSameDevice = new JButton("Check");
		jButtonCheckSameDevice.setVisible(false);
		jButtonCheckSameDevice.setBounds(494, 165, 93, 23);
		DiscoveryPanel.add(jButtonCheckSameDevice);
		
		jTextFieldLoginIP.setText(null);
		jTextFieldLoginUserName.setText(null);
		jPasswordFieldLoginPassword.setText(null);
		jTextFieldLoginPort.setText(null);
		
		JLabel lblDeviceType = new JLabel("DeviceType:");
		lblDeviceType.setBounds(10, 121, 72, 15);
		LocalLoginPanel.add(lblDeviceType);
		lblDeviceType.setForeground(Color.BLACK);
		
		jComboBoxDeviceType = new JComboBox<String>();
		jComboBoxDeviceType.setBounds(87, 121, 90, 21);
		LocalLoginPanel.add(jComboBoxDeviceType);
		
		JLabel LoginProtoLabel = new JLabel("Protocol:");
        LoginProtoLabel.setBounds(10, 171, 106, 15);
        LocalLoginPanel.add(LoginProtoLabel);
        LoginProtoLabel.setForeground(Color.BLACK);
          
        jComboBoxLoginProtocol = new JComboBox<String>();
        jComboBoxLoginProtocol.setBounds(87, 171, 90, 21);
        LocalLoginPanel.add(jComboBoxLoginProtocol);
                  
        JLabel lblLoginDevice = new JLabel("VMS only supports private protocol");
        lblLoginDevice.setBounds(10, 149, 228, 15);
        LocalLoginPanel.add(lblLoginDevice);
        lblLoginDevice.setFont(new Font("微软雅黑", Font.PLAIN, 12));
        lblLoginDevice.setForeground(Color.RED);
        lblLoginDevice.setHorizontalAlignment(SwingConstants.LEFT);
        lblLoginDevice.setVerticalAlignment(SwingConstants.TOP);
        jComboBoxLoginProtocol.addItem("Onvif");
        jComboBoxLoginProtocol.addItem("Private");
        jComboBoxDeviceType.addItem("IPC/NVR");
        jComboBoxDeviceType.addItem("VMS");

		JScrollPane DeviceScrollPane = new JScrollPane();
		DeviceScrollPane.setBounds(298, 10, 325, 259);
		frame.getContentPane().add(DeviceScrollPane);

		DeviceTable = new JTable(DeviceTableModel) {
		    public boolean isCellEditable(int row,int column) {
		    	return false;
		    }
		};
		DeviceScrollPane.setViewportView(DeviceTable);
		
        /* Discovery */
		btnDiscovery.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Discovery.discoverEquipment();
            }
        });
		jButtonCheckSameDevice.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Discovery.checkSameDevice();
            }
        });
		
        /* LiveView */
		jButtonStartLive.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {				
			    BasicLive.startLive();
			}
		});
		jButtonStopLive.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    BasicLive.stopLive();
			}
		});

        jButtonStartTalk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Talk.startTalk();
            }
        });
        jButtonStopTalk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Talk.stopTak();
            }
        });
        
        jButtonStartRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Record.startRecord();
            }
        });
        jButtonStopRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Record.stopRecord();
            }
        });
        
        jButtonCapture.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Capture.CapturePicture();               
            }
        });

        jButtonMakeI.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MakeI.makeI();
            }
        });
        
        jButtonStartSourceData.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayDataCallBack.startCallBack();
            }
        });
        jButtonStopSourceData.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayDataCallBack.stopCallBack();
            }
        });

        jButtonStartDecodeData.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayDecodeVideoCB.startCallBack();
            }
        });
        jButtonStopDecodeData.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayDecodeVideoCB.stopCallBack();
            }
        });
        
		jComboBoxFishEyeMount.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    EyeFish.changeMount();
			}
		});	
		jComboBoxPreviewMode.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    EyeFish.selectPreviewMode();
			}
		});
		
	    jComboBoxRenderScale.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	            RenderScale.changeRenderScale();
	        }
	    });

		jButtonSetDigitalZoom.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DigitalZoom.setDigitalZoom();
			}
		});
		jButtonExitDigitalZoom.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
			    DigitalZoom.closeDigitalZoom();
			}
		});
		
	    jComboBoxPictureFluency.addActionListener(new ActionListener() {
	        public void actionPerformed(ActionEvent e) {
	            PictureFluency.changeFluency();
	        }
	    });
	    
        jButtonGetVideoEffect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VideoEffect.getVideoEffect();
            }
        });	    
        jButtonSetVideoEffect.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VideoEffect.setVideoEffect();
            }
        });
	    
        jButtonChooseVoiceFile.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                LiveVoice.chooseVoiceFile();
            }
        }); 
        jButtonLiveGetVoice.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                LiveVoice.voiceAcquisition();
            }
        });
        
        jButtonSetVAParam.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MetaData.setMetaData();
            }
        });
        
        /* LiveView parameter */
        jButtonLiveSoundSilence.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Mute.changeMuteStatus();
            }
        });
        
        jButtonMic.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Microphone.changeMicrophoneState();
            }
        });

        jSliderLiveSound.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                SoundVolume.changeLiveSound(e);
            }
        });
        
        jSliderLiveMicSound.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                SoundVolume.changeMicrophoneSound(e);
            }
        });
        
        /* PTZ */
        jButtonUp.addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {    
                BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_TILTUP);
            }
            @Override
            public void mouseReleased(MouseEvent e) {
                BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
            }
          });
        
          jButtonLeftUp.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_LEFTUP);
                }
                
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
          
          
          jButtonRightUp.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_RIGHTUP);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
            
          jButtonPtzControlLeftDown.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_LEFTDOWN);    
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
            
          jButtonRightDown.addMouseListener(new MouseAdapter() {
                
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_RIGHTDOWN);
                }
                
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });

          jButtonDown.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_TILTDOWN);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });

          jButtonRight.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_PANRIGHT);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });

          jButtonLeft.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_PANLEFT);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
          
          jButtonFocusNear.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_FOCUSNEAR);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl( NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
        
          jButtonFocusFar.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_FOCUSFAR);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl( NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
              });

          jButtonZoomFar.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl(NETDEV_PTZ_E.NETDEV_PTZ_ZOOMWIDE);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                BasicPTZ.directionControl( NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
            

          jButtonZoomNear.addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    BasicPTZ.directionControl( NETDEV_PTZ_E.NETDEV_PTZ_ZOOMTELE);
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    BasicPTZ.directionControl( NETDEV_PTZ_E.NETDEV_PTZ_ALLSTOP);
                }
            });
          
          ObjectAlarmTable.addMouseListener(new MouseAdapter() {
  			@Override
  			public void mouseClicked(MouseEvent arg0) {
  				int row = ObjectAlarmTable.rowAtPoint(arg0.getPoint());
  				dwAlarmID = Integer.parseInt(ObjectAlarmTable.getValueAt(row, 0).toString());
  				System.out.println("AlarmID:" + dwAlarmID);
  			}
  		});
          
          jButtonPTZPause.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    BasicPTZ.PTZPause();
                }
            });
          
          jButtonGetBasePTZPreset.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    PresetPTZ.getPTZPreset();
                }
            });
          
          jButtonBasePTZPresetGoTo.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    PresetPTZ.gotoPTZPreset();
                }
            });
          
          jButtonAddBasePTZPreset.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                PresetPTZ.addPTZPreset();
                }
            });
          
          jButtonBasePTZPresetDelete.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    PresetPTZ.deletePTZPreset();
                }
            });
          
          jButtonPTZExtendWiperON.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent arg0) {
                  Wiper.WiperOn();
              }
          });
          
          jButtonPTZExtendWiperOFF.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  Wiper.WiperOff();
              }
          });
          
          jButtonPTZExtendHeaterON.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  Heater.heaterOn();
              }
          });
          
          jButtonPTZExtendHeaterOFF.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  Heater.heaterOff();
              }
          });
          
          jButtonPTZExtendLightON.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  Light.lightOn();
              }
          });
          
          jButtonPTZExtendLightOFF.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  Light.lightOff();
              }
          });
        
          jButtonPTZExtendSnowRemovalON.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  SnowRemoval.snowRemoveOn();
              }
          });
          
          jButtonPTZExtendSnowRemovalOFF.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  SnowRemoval.snowRemoveOff();
              }
          });
          
          jButtonPTZExtendRoutePatrolsGet.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  RoutePatrols.getRoutePatrols();
              }
          });
          
          jButtonPTZExtendRoutePatrolsRun.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  RoutePatrols.runRoutePatrols();
              }
          });
          
          jButtonPTZExtendRoutePatrolsStop.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  RoutePatrols.stopRoutePatrols();
              }
          });
          
          jButtonPTZExtendRouteRecordStart.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                 RoutePatrols.startRecordRoute();
              }
          });
          
          jButtonPTZExtendRouteRecordStop.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  RoutePatrols.stopRecordRoute();
              }
          });
          
          jButtonPTZExtendPresetPatrolsStart.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  PresetPatrols.startPresetPatrols();
              }
          });
          
          jButtonPTZExtendPresetPatrolsStop.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  PresetPatrols.stopPresetPatrols();
              }
          });
          
          jButtonPTZExtendPresetPatrolsSave.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  PresetPatrols.savePresetPatrols();
              }
          });
          
          jButtonPTZExtendPresetPatrolsDelete.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  PresetPatrols.deletePresetPatrols();
              }
          });
          
          jButtonPTZExtendPresetPatrolsAdd.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent arg0) {
                  PresetPatrols.addPresetPatrols();
              }
          });
          
          jButtonPTZExtendPresetIDDelete.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent arg0) {
                  PresetPatrols.deletePresetID();
              }
          });
          
          jButtonPTZExtendPresetPatrolsRefresh.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                  PresetPatrols.refreshPresetPatrols();
              }
          });
          
          jComboBoxPTZExtendPresetPatrolsID.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent et) {
                  PresetPatrols.jComboxPresetPatrolsID();
              }
          });
 
        
        /* Playback */
        jButtonQueryrecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                QueryRecord.queryRecord();
            }
        });
        
        jButtonPlaybackByURL.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Playback.playByURL();
            }
        });
        
        jButtonPlaybackByName.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Playback.playByName();
            }
        });
        
        jButtonPlaybackByTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Playback.playByTime();
            }
        });
        
        jButtonPauseOrResume.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Playback.pauseOrResume();
            }
        });
        
        jSliderPlayBack.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent arg0) {
                Playback.dragPlaybackSlider();
            }
        });
        
        jButtonStopPlayback.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Playback.stopPlay();
            }
        });
        
        jButtonFastSpeed.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Playback.fastPlaySpeed();
            }
        });
        
        jButtonSlowSpeed.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Playback.slowPlaySpeed();
            }
        });
        
        jButtonStartdownload.addActionListener(new ActionListener() {
             public void actionPerformed(ActionEvent arg0) {
                DownloadRecord.startDownload();
            }
        });
        
        jButtonStartdownloadByName.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DownloadRecord.startDownloadByName();
            }
        });
        
        jButtonStopdownload.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DownloadRecord.stopDownload();
            }
        });
        
        jButtonStopdownloadByName.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DownloadRecord.stopDownloadByName();
            }
        });
     
		jButtonPlayBackSetDigitalZoom.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				PlayBackDigitalZoom.setPlayBackDigitalZoom();
			}
		});

		jButtonPlayBackExitDigitalZoom.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				PlayBackDigitalZoom.exitPlayBackDigitalZoom();
			}
		});
		
		jComboBoxPlayBackRenderScale.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
		        PlayBackRenderScale.setPlayBackRenderScale();
		    }
	      });
		
		jButtonOpenFile.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayBackPlayLocalFile.openFile();
            }
        });
		
		jButtonPlayLocalFile.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
		        jButtonStopPlayback.doClick();
		        PlayBackPlayLocalFile.startPlayLocalFile();
		    }
		});
		
		jButtonPlayLocalFilePause.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayBackPlayLocalFile.pausePlayLocalFile();
            }
        });
		
		jButtonStopLocalFile.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PlayBackPlayLocalFile.stopPlayLocalFile();
            }
        });
		
        jButtonGetRecordStatus.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                RecordStatus.getRecordStatus();
            }
        });
        
        jComboBoxPlayRecordMonth.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent el) {
                QueryPlayBackRecordByMonth.ComboxQueryPlayBackRecordByMonth();
            }
        });
        
        jButtonQueryPlayBackRecordByMonth.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                QueryPlayBackRecordByMonth.queryPlayBackRecordByMonth();
            }
        });
        
        /* VCA */
        jButtonAddPersonLib.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonLib.addPersonLib();
            }
        });
        
        jButtonDeletePaersonLib.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonLib.deletePersonLib();
            }
        });
        
        jButtonModifyPersonLib.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonLib.modifyPersonLib();
            }
        });
       
        
        jButtonFindPersonLib.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonLib.findPersonLib();
            }
        });
        
        jButtonCapacity.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonLib.Capacity();
            }
        });
        
        jButtonAddPersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonMonitorFunction.addPersonMonitor();
            }
        });
        
        jButtonDeletePersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonMonitorFunction.deletePersonMonitor();
            }
        });
        
        jButtonModifyPersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonMonitorFunction.modifyPersonMonitor();
            }
        });
        
        jButtonEnablePersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonMonitorFunction.enablePersonMonitor();
            }
        });
        
        jButtonShutDownPersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonMonitorFunction.disablePersonMonitor();
            }
        });
        
        jButtonFindPersonMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonMonitorFunction.findPersonMonitor();
            }
        });
        
        jButtonModifyPerson.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonLib.modifyPerson();
            }
        });
        
        jButtonDeletePerson.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonLib.deletePerson();
            }
        });
        
        jButtonAddPerson.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonLib.addPerson();
            }
        });
        
        jButtonFindPerson.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonLib.findPerson();
            }
        });
        
        jButtonVehicleLibAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.addVehicleLib();
            }
        });
        
        jButtonVehicleLibDelete.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.deleteVehicleLib();
            }
        });
        
        jButtonVehicleLibModify.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.modifyVehicleLib();
            }
        });
        
        jButtonVehicleLibFind.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                VehicleLib.findVehicleLib();
            }
        });
        
        jButtonAddVehicle.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                VehicleLib.addVehicle();
            }
        });
        
        jButtonDeleteVehicle.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.deleteVehicle();
            }
        });
        
        jButtonVehicleModify.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
               VehicleLib.modifyVehicle();
            }
        });
        
        jButtonVehicleFind.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.findVehicle();
            }
        });
        
        jButtonAddVechileSendLibMember.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.addVechileSendLibMember();
            }
        });
        
        jButtonRemoveSameCar.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.removeSameCar();
            }
        });
        
        jButtonDeleteVehicleListSend.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleLib.deleteVehicleListSend();
            }
        });
        
        jButtonAddVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.addVehicleMonitor();
            }
        });
        
        jButtonDeleteVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.deleteVehicleMonitor();
            }
        });
        jButtonModifyVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.modifyVehicleMonitor();
            }
        });
        
        jButtonFindVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.findVehicleMonitor();
            }
        });
        
        jButtonEnableVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.enableVehicleMonitor();
            }
        });
        jButtonDiaableVehicleMonitor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VCAVehicleMonitor.disableVehicleMonitor();
            }
        });
        
        jButtonRegisterVehicleMatch.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleAlarm.registerVehicleMatch();
            }
        });
        
        jButtonCancelVehicleMatch.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleAlarm.cancelVehicleMatch();
            }
        });
        
        jButtonRegisterVehicleAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                VehicleAlarm.registerVehicleAlarm();
            }
        });
        
        jButtonCancelVehicleAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                VehicleAlarm.cancelVehicleAlarm();
            }
        });
        
        jButtonQueryVehicleAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable()
                {
                    @Override
                    public void run() {
                        VehicleAlarmRecord.queryVehicleAlarmRecord();
                    }
                }).start();
            }
        });
        
        jButtonQueryVehiclePassRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                new Thread(new Runnable()
                {
                    @Override
                    public void run() {
                        VehiclePassRecord.queryVehiclePassRecord();
                    }

                }).start();
            }
        });
        
        jButtonCancelRegisterPersonAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonAlarm.cancelRegisterPersonAlarm();
            }
        });
        
        jButtonPersonAlarmFind.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                new Thread(new Runnable()
                {
                    @Override
                    public void run() {
                        AlarmRecord.queryAlarmRecord();
                    }
                }).start();
            }
        });
        
        jButtonFindPersonPassAlarmRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                new Thread(new Runnable()
                {
                    @Override
                    public void run() {
                            PassRecord.queryPassRecord();
                        }
                }).start();
            }
        });
        
        jButtonRegisterPersonAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PersonAlarm.registerPersonAlarm();
            }
        });
        
        jButtonCancelPersonRecognize.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonAlarm.cancelPersonRecognize();
            }
        });
        
        jButtonRegistPersonRecognize.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PersonAlarm.registerPersonRecognize();
            }
        });
        
        jButtonSubscibeAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                DataReport.subscribeAlarm();
            }
        });
        jButtonUnSubscibeAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DataReport.unsubscribeAlarm();
            }
        });
        jButtonACSRecordsNext.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.accessRecordsNext();
            }
        });
        jButtonACSRecordsPre.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.accessRecordsPre();
            }
        });
        jButtonACSRecordsGo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.accessRecordsGo();
            }
        });
        jButtonSearchAccessRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.searchAccessRecords();
            }
        });
        jButtonVisitorRecordPre.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.visitorRecordsPre();
            }
        });
        jButtonVisitorRecordGo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.visitorRecordsGo();
            }
        });
        jButtonSearchVisitorRecord.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.searchVisitorRecords();
            }       
        });
        jButtonVisitorRecordNext.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ACS.visitorRecordsNext();
            }
        });
        jButtonPeopleCountingStartRealTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                NVRPeopleCounting.startRealTime();
            }
        });
        jButtonPeopleCountingStopRealTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                NVRPeopleCounting.stopRealTime();
            }
        });
        jButtonPeopleCountingVMSNVRStatistics.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                NVRPeopleCounting.dataStatistics();
            }
        });
        
        /* Alarm */
        jButtonAlarmSubscibe.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Alarm.SubscribeAlarm();
            }
        });
        jButtonAlarmUnSub.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Alarm.UnSubscribeAlarm();
            }
        });
        jButtonClearAlarm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Alarm.ClearAlarm();
            }
        });
        
        /* Configure */
        jButtonGetConfigNetWorkNet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DHCP.getDHCP();
            }
        });
        
        jButtonBasicGetSystemTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                SystemTime.getSystemTime();
            }
        });
        
        jButtonBasicSetSystemTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                SystemTime.setSystemTime();
            }
        });
        
        comboBoxCardListSzName.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {    
              Card.changeCardListConfig();
            }
        });
        
        jComboBoxBasicTimeZone.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SystemTime.changeComboxBasicTime();
            }
        });
        
        jButtonSynchronization.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SystemTime.synchronizationComputerTime();
            }
        });
        
        jButtonConfigGetDeviceName.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DeviceName.getDeviceName();
            }
        });
        
        jButtonConfigDeviceNameSet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DeviceName.setDeviceName();
            }
        });
        
        jButtonConfigBasicHardDiskRefresh.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                HardDisk.getHardDiskInformation();
            }
        });
        
        jButtonGetBasicInformation.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DeviceBasicInfo.getDeviceBasicInformation();
            }
        });
        
        jButtonGetSummerTime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DST.getDst();
            }
        });
        
        jButtonSaveDSTtime.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DST.setDst();
            }
        });
        
        jButtonGetSDKVersion.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Version.getSdkVersion();
            }
        });
        
        jButtonSetLog.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {    
                SettingWindow s=new SettingWindow();
                s.setVisible(true);
            }
        });
        
        jButtonSetConfigNetWorkNet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DHCP.setDHCP();
            }
        });
        
        jButtonGetNetworkPort.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OnvifPort.getPort();
            }
        });
        
        jButtonSetNetworkPort.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OnvifPort.setPort();
            }
        });
        
        btnConfigNetWorkNTPGet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                NTP.getNTPInfo();
            }
        });
        
        btnConfigNetWorkNTPSet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                NTP.setNTPInfo();
                }
            });
        
        jButtonOpenNetWorkTelnet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Telnet.openTelnet();
            }
        });
        
        jButtonCloseNetWorkTelnet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Telnet.closeTelnet();
            }
        });
        
        jComboBoxConfigNetWorkNTPIPType.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                NTP.changeIPType();
            }
        });
        
        jButtonGetNetWorkPortHttp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Port.getPort();
            }
        });
        
        jButtonSetNetWorHttp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Port.setPort();
            }
        });
        
        jButtonGetCardInformation.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Card.getCardInfo();
            }
        });

        jButtonSetCardListOne.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Card.setCardInfo();
            }
        });
        
        jButtonSetIPV4DeviceAddress.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                IPAdress.setIpv4DeviceAddress();
            }
        });
        
        jButtonnGetDNSConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DNS.getDNSInfo();
            }
        });
        
        jButtonSetDNSConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                DNS.setDNSInfo();
            }
        });
        
        jComboBoxNetWorkMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Card.changeNetWorkMode();
            }
        });

        jButtonSetNetWorkVpnConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Vpn.setVpn();
            }
        });
        
        jButtonGetNetWorkVpnConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Vpn.getVpn();
            }
        });
        
        jRadioButtonOpenSVC.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(jRadioButtonCloseSVC.isSelected()) {
                    jRadioButtonCloseSVC.setSelected(false);
                }
            }
        });
        
        jRadioButtonCloseSVC.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(jRadioButtonOpenSVC.isSelected()) {
                    jRadioButtonOpenSVC.setSelected(false);
                }
            }
        });
        
        comboBoxConfigVideoStreamIndex.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent et) {
                try {
                    if(pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS 
                        ){
                        return;
                    }else {
                        Stream.comboxStream();
                    }
                }catch(Exception e) {}  
            }
        });
        
        jComboBoxMainStreamType.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                try {   
                    Stream.comboxMainStreamType();
                }catch(Exception t) {       
                }
            }
        });
        
        jButtonGetVideoStream.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Stream.getStreamInfo();
            }
        });
        
        jButtonSetVideoStream.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Stream.setStream();   
            }
        });
        
        jButtonGetFocusMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                FocusMode.getFocusMode();
                }
        });
        
        jButtonSetFocusMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                FocusMode.setFocusMode();
            }
        });
        
        jButtonGetIRcutMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                IrCutFilterMode.getIrCutFilterMode();
            }
        });
        jButtonSetIRcutMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                IrCutFilterMode.setIrCutFilterMode();
            }
        });
        
        jButtonGetSnapshot.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SnapShot.getSnapShot();
            }
        });
        
        jButtonSetSnapshotNum.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SnapShot.setSnapShot();
            }
        });
        
        jButtonGetImageInfo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageInfo.getImageInfo();
                
            }
        });
        
        jButtonSetImageInfo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageInfo.setImageInfo();
            }
        });
        
        jComboBoxExposureWDR.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageExposure.changeWDR();
            }
        });
        
        jComboBoxExposureMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageExposure.changeImageExposureMode();
            }
        });
        
        jComboBoxDayNightMode.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageExposure.changeDayNightMode();
            }
        });
        
        jButtonGetImageExposure.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageExposure.getImageExposureInfo();
            }
        });
        
        jButtonSetImageExposure.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ImageExposure.setImageExposureInfo();
            }
        });
        
        jButtonGetWhiteBalance.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                WhiteBlance.getWhiteBlance();
            }
        });
        
        jButtonSetWhiteBlance.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                WhiteBlance.setWhiteBlance();
            }
        });
        
        jComboBoxWhiteBalance.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent et) {
                WhiteBlance.comboxWhiteBlance();
            }
        });
        
        jButtonResetImg.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ResetImage.resetImage();
            }
        });
        
        jCheckBoxIsEnableSlowSh.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if(jCheckBoxIsEnableSlowSh.isSelected()) {
                    jTextFieldConfigImageExposureSlowestShutter.setEnabled(true);
                }else {
                    jTextFieldConfigImageExposureSlowestShutter.setEnabled(false);
                }
            }
        });
        
        RedoffSetslider.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                int Red=((JSlider)e.getSource()).getValue();
                textRedOffSet.setText(String.valueOf(Red));
            }
        });

        BlueoffSetslider.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                int Blue=((JSlider)e.getSource()).getValue();
                textBlueOffSet.setText(String.valueOf(Blue));
            }
        });
        
        jButtonGetOSDConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OSD.getOSD();
            }
        });
        
        jButtonSetOSDConfig.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OSD.setOSD();
            }
        });
        
        jButtonGetOSDStyle.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OSDStyle.getOSDStyle();
            }
        });
        
        jButtonSetOSDStyle.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                OSDStyle.setOSDStyle();
            }
        });
        
        jButtonGetIOAlarmInput.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmInput.getAlarmInput();
            }
        });
        
        jComboBoxAlarmOutPutIndex.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmOutput.comgboxAlarmOuptConfig();
            }
        });
        
        jButtonTriggerIOAlarmOutput.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmOutput.triggerAlarmOutPut();
            }
        });
        
        jButtonGetIOAlarmOutput.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                AlarmOutput.getAlarmOutPut();
            }
        });
        
        jButtonSetIOAlarmOutput.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                AlarmOutput.setAlarmOutPut();
            }
        });
        
        jButtonCancelTriggerIOAlarmOutput.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmOutput.cancelTriggerAlarmOutPut();
            }
        });
        
        btnConfigIOAlarmOutputChannelGet.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmOutput.getAlarmOutputChannelInfo();
            }
        });
        
        jButtonSetIOAlarmOutputChannel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AlarmOutput.setAlarmOutputChannelInfo();
            }
        });
        
        jButtonAddPrivacyMask.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PrivacyMask.addPrivacyMask();
            }
        });
        
        jButtonDeletePrivacyMask.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                PrivacyMask.deletePrivacyMask();
            }
        });
        
        jButtonGetPrivacyMask.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PrivacyMask.getPrivacyMask();
            }
        });
        
        jButtonSetPrivacyMask.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                PrivacyMask.setPrivacyMask();
            }
        });
        
        jButtonGetMotionConfigure.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionDectionInfo.getAlarmInfo();
            }
        });
        
        jButtonSetMotionConfigure.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionDectionInfo.setAlarmInfo();
            }
        });
        
        jButtonGetMotionArea.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionArea.getMotionArea();
            }
        });
        
        jButtonSetMotionArea.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionArea.setMotionAera();
            }
        });
        
        jButtonModifyRectangleArea.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionArea.modifyReactangleArea();
            }
        });

        jButtonModifyMacroArea.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                MotionArea.modifyMacroArea();
            }
        });
        
        jComboBoxAreaType.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {
                MotionArea.changeAreaType(e);
            }
        });
        
        jButtonGetTemperAlarmSensitivity.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                TemperAlarm.getTemperSensitivity(); 
            }
        });
        
        jButtonSetTemperAlarmSensitivity.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                TemperAlarm.setTemperSensitivity();
            }
        });
        
        jButtonGetTemperDetection.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                TemperDetection.getTemperDetection();
            }
        });
        
        jButtonSetTemperDetection.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                TemperDetection.setTemperDetection();
            }
        });
        
        jButtonGetSmartServer.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SmartServer.getSmartServer();
            }
        });
        
        jButtonSetSmartServer.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                SmartServer.setSmartServer();
            }
        });
        
        jButtonUserListGetUserList.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Userlist.getUserList();
            }
        });
        
        jButtonUserListDeleteUser.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Userlist.deleteUser();
            }
        });
        
        jButtonUserListGetUserInfo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Userlist.getUserInfo();
            }
        });
        
        jButtonAddUserAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                AddUser.addUser();   
            }
        });
        
        jButtonModifyUserModify.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ModifyUser.modifyUser();
            }
        });
        
        jButtonMaintenanceReboot.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Maintenance.Reboot();
            }
        });
        
        jButtonMaintenanceFactoryDefault.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Maintenance.factoryDefault();
            }
        });
        
        jButtonMaintenanceManualRecordStart.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ManualRecord.startRecord();
            }
        });
        
        jButtonMaintenanceManualRecordStop.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ManualRecord.stopRecord();
            }
        });
        
        jButtonMaintenanceManualConfigurationExport.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Configuration.Export();
            }
        });
        
        jButtonMaintenanceManualConfigurationBrowse.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Configuration.Browse();
            }
        });
        
        jButtonMaintenanceManualConfigurationImport.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                Configuration.Import();
            }
        });
        
        jButtonMaintenanceLookLog.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Find.LogLookUp();
            }
        });
        
        jButtonMaintenanceAlarmFind.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Find.AlarmLookUp();
            }
        });
        
        jButtonMaintenanceAlarmLog.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Find.AlarmLogLookUp();
            }
        });
        
        /* Login */
        jButtonLogIn.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Login.loginIn();
            }
        });
        
        jButtonLogOut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Login.loginOut();
            }
        });

        /* Get channel ID */
		DeviceTable.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				int row = DeviceTable.rowAtPoint(e.getPoint());
				ChannelID = Integer.parseInt(DeviceTable.getValueAt(row, 0).toString());
				System.out.println("ChannelID:" + ChannelID);
				}
			});
		}
	}

