package main.java.com.netdevsdk.demo.alarm;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;

/**
 * @description This section includes subscribing alarm,closing subscribe alarm and clearing alarm.
 * @introduction Support IPC/NVR/VMS.
 */
public class Alarm {
    /**
     * @description To subscribe alarm.
     * @introduction Calling the interface of NETDEV_SetAlarmCallBack_V30.
     */
    public static void SubscribeAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, NetDemo.cbAlarmMessCallBack, null);
        if(bRet) {
            JOptionPane.showMessageDialog(null, "Subscribe success");
        }else {
            JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
        }
    }
    /**
     * @description To close subscribe alarm.
     * @introduction Calling the interface of NETDEV_SetAlarmCallBack_V30.
     */
    public static void UnSubscribeAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, null, null);
        if(bRet==false) {
            JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "UnSubscribe success");
        }
    }
    /**
     * @description To clear alarm.
     */
    public static void ClearAlarm() {
        NetDemo.AlarmTableModel.setRowCount(0);
    }
    
}
