package main.java.com.netdevsdk.demo.config.basic;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DAY_IN_WEEK_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DST_CFG_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DST_OFFSET_TIME;

/**
 * 
 * @introduction DST configuration
 * @description Support IPC/NVR/VMS
 */
public class DST {
	
    /**
     * 
     * @introduction Get DST
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getDst() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return ;
		}

		IntByReference dwBytesReturned = new IntByReference();

		NETDEV_DST_CFG_S dstInfo=new NETDEV_DST_CFG_S();
		dstInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DST_CFG, dstInfo.getPointer(),dstInfo.size(),dwBytesReturned);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
        }
        else {
        	dstInfo.read();
        	if(dstInfo.bEnableDST==0) {
        		NetDemo.chckbxEnableSummerTime.setSelected(false);
        	}else {
        		NetDemo.chckbxEnableSummerTime.setSelected(true);
        	}
        	
        	int beginMonth = dstInfo.stTimeDSTCfg.stBeginTime.dwMonth;
        	NetDemo.comboBoxDstBeginMonth.setSelectedIndex(beginMonth-1);

        	int endMonth = dstInfo.stTimeDSTCfg.stEndTime.dwMonth;
        	NetDemo.comboBoxDSTENDMonth.setSelectedIndex(endMonth-1);
        	
        	int beginDayInWeek = dstInfo.stTimeDSTCfg.stBeginTime.dwDayInWeek;
        	if(beginDayInWeek==0) {
                NetDemo.comboBoxDSTBeginTimeWeek.setSelectedIndex(6);
            }else {
                NetDemo.comboBoxDSTBeginTimeWeek.setSelectedIndex(beginDayInWeek-1);
            }
        	
            int endDayInWeek = dstInfo.stTimeDSTCfg.stEndTime.dwDayInWeek;
            if(endDayInWeek==0) {
                NetDemo.comboBoxDSTEndTimeWeek.setSelectedIndex(6);
            }else {
                NetDemo.comboBoxDSTEndTimeWeek.setSelectedIndex(endDayInWeek-1);
            }
        	
            int beginWeekInMonth = dstInfo.stTimeDSTCfg.stBeginTime.dwWeekInMonth;
            NetDemo.comboBoxBeginTimeWeekNum.setSelectedIndex(beginWeekInMonth-1);
            
            int endWeekInMonth = dstInfo.stTimeDSTCfg.stEndTime.dwWeekInMonth;
            NetDemo.comboBoxDSTEndTimeWeekNum.setSelectedIndex(endWeekInMonth-1);

            int beginHour = dstInfo.stTimeDSTCfg.stBeginTime.dwHour;
            NetDemo.comboBoxDSTBeginTimeHour.setSelectedIndex(beginHour);
            
            int endHour = dstInfo.stTimeDSTCfg.stEndTime.dwHour;
            NetDemo.comboBoxDSTEndTimeHour.setSelectedIndex(endHour);
        	
            int OffsetTime = dstInfo.stTimeDSTCfg.dwOffsetTime;
            NetDemo.comboBoxDSTBias.setSelectedIndex((OffsetTime/30)-1);
        }
	}

	/**
	 * 
	 * @introduction Set DST
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setDst() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return ;
		}

		IntByReference dwBytesReturned = new IntByReference();
		NETDEV_DST_CFG_S dstInfo=new NETDEV_DST_CFG_S();
		dstInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DST_CFG, dstInfo.getPointer(),dstInfo.size(),dwBytesReturned);
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
        }
        else {
        	dstInfo.read();
        	if(NetDemo.chckbxEnableSummerTime.isSelected()) {
        		dstInfo.bEnableDST=1;
        	}else {
        		dstInfo.bEnableDST=0;
        	}
        	
        	int beginMonth=0;
        	switch (NetDemo.comboBoxDstBeginMonth.getItemAt(NetDemo.comboBoxDstBeginMonth.getSelectedIndex())) {
            case "January":
                beginMonth = 1;
                break;
            case "February":
                beginMonth = 2;
                break;
            case "March":
                beginMonth = 3;
                break;
            case "April":
                beginMonth = 4;
                break;
            case "May":
                beginMonth = 5;
                break;
            case "June":
                beginMonth = 6;
                break;
            case "July":
                beginMonth = 7;
                break;
            case "August":
                beginMonth = 8;
                break;
            case "September":
                beginMonth = 9;
                break;
            case "October":
                beginMonth = 10;
                break;
            case "November":
                beginMonth = 11;
                break;
            case "December":
                beginMonth = 12;
                break;
        	}
        	dstInfo.stTimeDSTCfg.stBeginTime.dwMonth=beginMonth;
        	
    		int weekInMonth=0;
    		switch (NetDemo.comboBoxBeginTimeWeekNum.getItemAt(NetDemo.comboBoxBeginTimeWeekNum.getSelectedIndex())) {
            case "First":
                weekInMonth = 1;
                break;
            case "Second":
                weekInMonth = 2;
                break;
            case "Third":
                weekInMonth = 3;
                break;
            case "Fourth":
                weekInMonth = 4;
                break;
            case "Last":
                weekInMonth = 5;
                break;
    		}
    		dstInfo.stTimeDSTCfg.stBeginTime.dwWeekInMonth=weekInMonth;

    		int dayInWeek=0;
    		switch (NetDemo.comboBoxDSTBeginTimeWeek.getItemAt(NetDemo.comboBoxDSTBeginTimeWeek.getSelectedIndex())) {
            case "Mon":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_MONDAY;
                break;
            case "Tue":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_TUESDAY;
                break;
            case "Wed":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_WEDNESDAY;
                break;
            case "Thu":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_THURSDAY;
                break;
            case "Fri":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_FRIDAY;
                break;
            case "Sat":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_SATURDAY;
                break;
            case "Sun":
                dayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_SUNDAY;
                break;
    		}
    		dstInfo.stTimeDSTCfg.stBeginTime.dwDayInWeek=dayInWeek;
    		
    		int BeginHour=0;
    		switch (NetDemo.comboBoxDSTBeginTimeHour.getItemAt(NetDemo.comboBoxDSTBeginTimeHour.getSelectedIndex())) {
            case "00":
                BeginHour = 0;
                break;
            case "01":
                BeginHour = 1;
                break;
            case "02":
                BeginHour = 2;
                break;
            case "03":
                BeginHour = 3;
                break;
            case "04":
                BeginHour = 4;
                break;
            case "05":
                BeginHour = 5;
                break;
            case "06":
                BeginHour = 6;
                break;
            case "07":
                BeginHour = 7;
                break;
            case "08":
                BeginHour = 8;
                break;
            case "09":
                BeginHour = 9;
                break;
            case "10":
                BeginHour = 10;
                break;
            case "11":
                BeginHour = 11;
                break;
            case "12":
                BeginHour = 12;
                break;
            case "13":
                BeginHour = 13;
                break;
            case "14":
                BeginHour = 14;
                break;
            case "15":
                BeginHour = 15;
                break;
            case "16":
                BeginHour = 16;
                break;
            case "17":
                BeginHour = 17;
                break;
            case "18":
                BeginHour = 18;
                break;
            case "19":
                BeginHour = 19;
                break;
            case "20":
                BeginHour = 20;
                break;
            case "21":
                BeginHour = 21;
                break;
            case "22":
                BeginHour = 22;
                break;
            case "23":
                BeginHour = 23;
                break;
        }
    		dstInfo.stTimeDSTCfg.stBeginTime.dwHour=BeginHour;

    		int EedMonth=0;
    		switch (NetDemo.comboBoxDSTENDMonth.getItemAt(NetDemo.comboBoxDSTENDMonth.getSelectedIndex())) {
            case "January":
                EedMonth = 1;
                break;
            case "February":
                EedMonth = 2;
                break;
            case "March":
                EedMonth = 3;
                break;
            case "April":
                EedMonth = 4;
                break;
            case "May":
                EedMonth = 5;
                break;
            case "June":
                EedMonth = 6;
                break;
            case "July":
                EedMonth = 7;
                break;
            case "August":
                EedMonth = 8;
                break;
            case "September":
                EedMonth = 9;
                break;
            case "October":
                EedMonth = 10;
                break;
            case "November":
                EedMonth = 11;
                break;
            case "December":
                EedMonth = 12;
                break;
    		}
    		dstInfo.stTimeDSTCfg.stEndTime.dwMonth=EedMonth;
    		
    		int EndWeekInMonth=0;
    		switch (NetDemo.comboBoxDSTEndTimeWeekNum.getItemAt(NetDemo.comboBoxDSTEndTimeWeekNum.getSelectedIndex())) {
            case "First":
                EndWeekInMonth = 1;
                break;
            case "Second":
                EndWeekInMonth = 2;
                break;
            case "Third":
                EndWeekInMonth = 3;
                break;
            case "Fourth":
                EndWeekInMonth = 4;
                break;
            case "Last":
                EndWeekInMonth = 5;
                break;
    		}
    		dstInfo.stTimeDSTCfg.stEndTime.dwWeekInMonth=EndWeekInMonth;
    		

    		int EnddayInWeek=0;
    		switch (NetDemo.comboBoxDSTEndTimeWeek.getItemAt(NetDemo.comboBoxDSTEndTimeWeek.getSelectedIndex())) {
            case "Mon":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_MONDAY;
                break;
            case "Tue":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_TUESDAY;
                break;
            case "Wed":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_WEDNESDAY;
                break;
            case "Thu":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_THURSDAY;
                break;
            case "Fri":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_FRIDAY;
                break;
            case "Sat":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_SATURDAY;
                break;
            case "Sun":
                EnddayInWeek = NETDEV_DAY_IN_WEEK_E.NETDEV_WEEK_SUNDAY;
                break;
        }
    		dstInfo.stTimeDSTCfg.stEndTime.dwDayInWeek=EnddayInWeek;
    		
    		int EndHour=0;
    		switch (NetDemo.comboBoxDSTEndTimeHour.getItemAt(NetDemo.comboBoxDSTEndTimeHour.getSelectedIndex())) {
            case "00":
                BeginHour = 0;
                break;
            case "01":
                EndHour = 1;
                break;
            case "02":
                EndHour = 2;
                break;
            case "03":
                EndHour = 3;
                break;
            case "04":
                EndHour = 4;
                break;
            case "05":
                EndHour = 5;
                break;
            case "06":
                EndHour = 6;
                break;
            case "07":
                EndHour = 7;
                break;
            case "08":
                EndHour = 8;
                break;
            case "09":
                EndHour = 9;
                break;
            case "10":
                EndHour = 10;
                break;
            case "11":
                EndHour = 11;
                break;
            case "12":
                EndHour = 12;
                break;
            case "13":
                EndHour = 13;
                break;
            case "14":
                EndHour = 14;
                break;
            case "15":
                EndHour = 15;
                break;
            case "16":
                EndHour = 16;
                break;
            case "17":
                EndHour = 17;
                break;
            case "18":
                EndHour = 18;
                break;
            case "19":
                EndHour = 19;
                break;
            case "20":
                EndHour = 20;
                break;
            case "21":
                EndHour = 21;
                break;
            case "22":
                EndHour = 22;
                break;
            case "23":
                EndHour = 23;
                break;
    		}
    		dstInfo.stTimeDSTCfg.stEndTime.dwHour=EndHour;
    		
    		int offsetTime=30;
    		switch (NetDemo.comboBoxDSTBias.getItemAt(NetDemo.comboBoxDSTBias.getSelectedIndex())) {
            case "30mins":
                offsetTime = NETDEV_DST_OFFSET_TIME.NETDEV_DST_OFFSET_TIME_30MIN;
                break;
            case "60mins":
                offsetTime = NETDEV_DST_OFFSET_TIME.NETDEV_DST_OFFSET_TIME_60MIN;
                break;
            case "90mins":
                offsetTime = NETDEV_DST_OFFSET_TIME.NETDEV_DST_OFFSET_TIME_90MIN;
                break;
            case "120mins":
                offsetTime = NETDEV_DST_OFFSET_TIME.NETDEV_DST_OFFSET_TIME_120MIN;
                break;
    		}
    		dstInfo.stTimeDSTCfg.dwOffsetTime=offsetTime;
    		
    		dstInfo.write();
    		boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_DST_CFG, dstInfo.getPointer(), dstInfo.size() );
            if(bRet2 != true)
            {
            	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            	NetDemo.jButtonGetSummerTime.doClick();
            }
        	
        }
	}

}
