package main.java.com.netdevsdk.demo.config.basic;


import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TIME_CFG_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TIME_ZONE_E;

/**
 * 
 * @introduction System time
 * @description Support IPC/NVR/VMS
 */
public class SystemTime {
    
    /**
     * 
     * @introduction Get the system time
     * @description Calling the interface of NETDEV_GetSystemTimeCfg
     *
     */
    public static void getSystemTime() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.textFieldBasicTime.setText(null);
        NetDemo.textFieldSetBasicSystemTime.setText(null);
            try {
                NetDemo.runflag=false;
                NETDEV_TIME_CFG_S stTimeCfg = new NETDEV_TIME_CFG_S();
                stTimeCfg.write();
                boolean bRet = NetDemo.netdevsdk.NETDEV_GetSystemTimeCfg(NetDemo.lpUserID, stTimeCfg);
                if(bRet != true)
                {
                    JOptionPane.showMessageDialog(null, "Get Time failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                    System.out.printf("NETDEV_GetSystemTimeCfg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                }else {
                    stTimeCfg.read();
                    NetDemo.jComboBoxBasicTimeZone.setSelectedIndex(stTimeCfg.dwTimeZone);
                    String strTime = "" + stTimeCfg.stTime.dwYear+"-";
                    if(stTimeCfg.stTime.dwMonth < 10) {
                        strTime+= "0";
                    }
                    strTime = strTime + stTimeCfg.stTime.dwMonth + "-";
                    if(stTimeCfg.stTime.dwDay < 10) {
                        strTime+= "0";
                    }
                    strTime = strTime + stTimeCfg.stTime.dwDay + " ";
                    if(stTimeCfg.stTime.dwHour < 10) {
                        strTime+= "0";
                    }
                    strTime = strTime + stTimeCfg.stTime.dwHour + ":";
                    if(stTimeCfg.stTime.dwMinute < 10) {
                        strTime+= "0";
                    }
                    strTime = strTime + stTimeCfg.stTime.dwMinute + ":";

                    if(stTimeCfg.stTime.dwSecond < 10) {
                        strTime+= "0";
                    }
                    strTime = strTime + stTimeCfg.stTime.dwSecond;
                       
                    NetDemo.lastTargetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
                    NetDemo.textFieldBasicTime.setText(strTime);
                    NetDemo.textFieldSetBasicSystemTime.setText(strTime);
                } 
            
                NetDemo.lastTargetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
                Thread.sleep(1001);
                NetDemo.runflag=true;
                autoAddTime();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
    }
	
    /**
     * 
     * @introduction Set system time
     * @description Calling the interface of NETDEV_SetSystemTimeCfg
     *
     */
    public static void setSystemTime() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.runflag=false;
        NETDEV_TIME_CFG_S stTimeCfg = new NETDEV_TIME_CFG_S();
        String strTime = NetDemo.textFieldSetBasicSystemTime.getText();
        if(strTime==null||strTime.equals("")) {
            JOptionPane.showMessageDialog(null, "Time is null");
            return;
        }
        int getSTyear=0;
        int getSTmonth=0;
        int getSTday=0;
        int getSThour=0;
        int getSTminute=0;
        int getSTsecond=0;
        try {
            getSTyear=Integer.parseInt(strTime.substring(0, 4));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Year format error");
            return;
        }
        try {
            getSTmonth= Integer.parseInt(strTime.substring(5, 7));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Month format error");
            return;
        }
        try {
            getSTday= Integer.parseInt(strTime.substring(8, 10));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Day format error");
            return;
        }
        try {
            getSThour= Integer.parseInt(strTime.substring(11, 13));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Hour format error");
            return;
        }
        try {
            getSTminute= Integer.parseInt(strTime.substring(14, 16));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Minute format error");
            return;
        }
        try {
            getSTsecond= Integer.parseInt(strTime.substring(17, 19));
        }catch(Exception e) {
            JOptionPane.showMessageDialog(null, "Second format error");
            return;
        }

        stTimeCfg.stTime.dwYear = getSTyear;
        stTimeCfg.stTime.dwMonth = getSTmonth;
        stTimeCfg.stTime.dwDay = getSTday;
        stTimeCfg.stTime.dwHour = getSThour;
        stTimeCfg.stTime.dwMinute = getSTminute;
        stTimeCfg.stTime.dwSecond = getSTsecond;
        stTimeCfg.dwTimeZone = NetDemo.jComboBoxBasicTimeZone.getSelectedIndex();    
        stTimeCfg.write();
        System.out.println(stTimeCfg.stTime.dwHour);

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetSystemTimeCfg(NetDemo.lpUserID, stTimeCfg);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Set time failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetSystemTimeCfg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Set Success");
        }
    }
    
    /**
     * 
     * @introduction Select timezone
     * @description
     *
     */
    public static void changeComboxBasicTime() {
        try {
            if(NetDemo.textFieldSetBasicSystemTime.getText()==null||NetDemo.textFieldSetBasicSystemTime.getText().equals("")) {
                String sourceTime=getCheck();
                String targetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
                comboxBasicTime(sourceTime,targetId);
            }else { 
                String getsourceTime=NetDemo.textFieldSetBasicSystemTime.getText();
                String targetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
                comboxBasicTime(getsourceTime,targetId);
                NetDemo.lastTargetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
            }
        }catch(Exception e) {         
        }
    }
	
	/**
	 * 
	 * @introduction Synchronization computer time
	 * @description Calling the interface of NETDEV_SetSystemTimeCfg
	 *
	 */
	public static void synchronizationComputerTime() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		NetDemo.runflag=false;
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String getComputerTime=sdf.format(new Date());
		NETDEV_TIME_CFG_S stTimeCfg = new NETDEV_TIME_CFG_S();
		
		if(getComputerTime==null||getComputerTime.equals("")) {
			JOptionPane.showMessageDialog(null, "Time is null");
			return;
		}
		
		int getSTyear=0;
		int getSTmonth=0;
		int getSTday=0;
		int getSThour=0;
		int getSTminute=0;
		int getSTsecond=0;
		try {
			getSTyear=Integer.parseInt(getComputerTime.substring(0, 4));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Year format error");
			return;
		}
		try {
			getSTmonth= Integer.parseInt(getComputerTime.substring(5, 7));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Month format error");
			return;
		}
		try {
			getSTday= Integer.parseInt(getComputerTime.substring(8, 10));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Day format error");
			return;
		}
		try {
			getSThour= Integer.parseInt(getComputerTime.substring(11, 13));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Hour format error");
			return;
		}
		try {
			getSTminute= Integer.parseInt(getComputerTime.substring(14, 16));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "Minute format error");
			return;
		}
		try {
			getSTsecond= Integer.parseInt(getComputerTime.substring(17, 19));
		}catch(Exception e) {
			JOptionPane.showMessageDialog(null, "second format error");
			return;
		}

		stTimeCfg.stTime.dwYear = getSTyear;
		stTimeCfg.stTime.dwMonth = getSTmonth;
		stTimeCfg.stTime.dwDay = getSTday;
		stTimeCfg.stTime.dwHour = getSThour;
		stTimeCfg.stTime.dwMinute = getSTminute;
		stTimeCfg.stTime.dwSecond = getSTsecond;
		stTimeCfg.dwTimeZone = NETDEV_TIME_ZONE_E.NETDEV_TIME_ZONE_E0800;
		stTimeCfg.write();
		
		boolean bRet = NetDemo.netdevsdk.NETDEV_SetSystemTimeCfg(NetDemo.lpUserID, stTimeCfg);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "set time failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetSystemTimeCfg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stTimeCfg.read();
        	String strTime = "" + stTimeCfg.stTime.dwYear+"-";
            if(stTimeCfg.stTime.dwMonth < 10) {
            	strTime+= "0";
            }
            strTime = strTime + stTimeCfg.stTime.dwMonth + "-";
            if(stTimeCfg.stTime.dwDay < 10) {
            	strTime+= "0";
            }
            strTime = strTime + stTimeCfg.stTime.dwDay + " ";
            if(stTimeCfg.stTime.dwHour < 10) {
            	strTime+= "0";
            }
            strTime = strTime + stTimeCfg.stTime.dwHour + ":";
            if(stTimeCfg.stTime.dwMinute < 10) {
            	strTime+= "0";
            }
            strTime = strTime + stTimeCfg.stTime.dwMinute + ":";
            if(stTimeCfg.stTime.dwSecond < 10) {
            	strTime+= "0";
            }
            strTime = strTime + stTimeCfg.stTime.dwSecond;

        	JOptionPane.showMessageDialog(null, "Set Success");
        	NetDemo.textFieldBasicTime.setText(strTime);
            NetDemo.textFieldSetBasicSystemTime.setText(strTime);
            NetDemo.jComboBoxBasicTimeZone.setSelectedIndex(27);
        	NetDemo.jButtonBasicGetSystemTime.doClick();
        }
	}

	public static void comboxBasicTime(String sourceTime,String targetId) {
	    timeConvert(sourceTime,targetId);
	}
	
	/**
	 * 
	 * @introduction Time format conversion
	 * @description
	 *
	 * @param [sourceTime] [时区时间]
	 * @param [targetId] [时差]
	 * @return [String]
	 */
	public static String timeConvert(String sourceTime,String targetId){	
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return null;
		}

		NETDEV_TIME_CFG_S stTimeCfg = new NETDEV_TIME_CFG_S();
		stTimeCfg.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetSystemTimeCfg(NetDemo.lpUserID, stTimeCfg);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "get Time failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetSystemTimeCfg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return null;
        }else {
            stTimeCfg.read();
            String reg = "^[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}$";
            if (!sourceTime.matches(reg)){
                return null;
            }
            targetId=NetDemo.jComboBoxBasicTimeZone.getItemAt(NetDemo.jComboBoxBasicTimeZone.getSelectedIndex()).substring(3, 9);
            try{
                //时间格式
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                //根据入参原时区id，获取对应的timezone对象
                TimeZone sourceTimeZone = TimeZone.getTimeZone("GMT"+NetDemo.lastTargetId);
                //设置SimpleDateFormat时区为原时区（否则是本地默认时区），目的:用来将字符串sourceTime转化成原时区对应的date对象
                df.setTimeZone(sourceTimeZone);
                //将字符串sourceTime转化成原时区对应的date对象
                java.util.Date sourceDate = df.parse(sourceTime);
                //开始转化时区：根据目标时区id设置目标TimeZone
                TimeZone targetTimeZone = TimeZone.getTimeZone("GMT"+targetId);
                //设置SimpleDateFormat时区为目标时区（否则是本地默认时区），目的:用来将字符串sourceTime转化成目标时区对应的date对象
                df.setTimeZone(targetTimeZone);
                //得到目标时间字符串
                String targetTime = df.format(sourceDate);
                NetDemo.textFieldSetBasicSystemTime.setText(targetTime);     
                }
            catch (Exception e){
                e.printStackTrace();
                }      
            }
        return null;
        }
	
	/**
	 * 
	 * @introduction Check time format
	 * @description
	 *
	 */
	public static String getCheck() {
        NETDEV_TIME_CFG_S stTimeCfg = new NETDEV_TIME_CFG_S();
        stTimeCfg.write();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetSystemTimeCfg(NetDemo.lpUserID, stTimeCfg);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "get Time failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetSystemTimeCfg failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return null;
        }else {
            stTimeCfg.read();
        String strTime = "" + stTimeCfg.stTime.dwYear+"-";
           if(stTimeCfg.stTime.dwMonth < 10)
           {
            strTime+= "0";
           }
           strTime = strTime + stTimeCfg.stTime.dwMonth + "-";

           if(stTimeCfg.stTime.dwDay < 10)
           {
            strTime+= "0";
           }
           strTime = strTime + stTimeCfg.stTime.dwDay + " ";

           if(stTimeCfg.stTime.dwHour < 10)
           {
            strTime+= "0";
           }
           strTime = strTime + stTimeCfg.stTime.dwHour + ":";

           if(stTimeCfg.stTime.dwMinute < 10)
           {
            strTime+= "0";
           }
           strTime = strTime + stTimeCfg.stTime.dwMinute + ":";

           if(stTimeCfg.stTime.dwSecond < 10)
           {
            strTime+= "0";
           }
           strTime = strTime + stTimeCfg.stTime.dwSecond;
        return strTime;
    }
    }

	/**
	 * 
	 * @introduction Auto add time
	 * @description
	 *
	 */
	public static void autoAddTime() {
	    String strTime=NetDemo.textFieldSetBasicSystemTime.getText();
	    NetDemo.textFieldBasicTime.setText(strTime);
	    NetDemo.textFieldSetBasicSystemTime.setText(strTime);
	    if(NetDemo.runflag==false) {
	        return;
	        }
	    new Thread() {
	        @Override
	        public void run() {
	            while(NetDemo.runflag) {
	                try {
	                    String strTime2=NetDemo.textFieldBasicTime.getText();
	                    Calendar c = Calendar.getInstance();
	                    c.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strTime2));
	                    long sec=c.getTimeInMillis();
	                    SimpleDateFormat sdd=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");  
	                    Thread.sleep(1000);
	                    sec+=1000;
	                    NetDemo.textFieldBasicTime.setText(sdd.format(new Date(sec)));
	                    } catch (Exception e) {
	                        e.printStackTrace();
	                        }
	                }
	            }   
	        }.start();
	        }
	}