package main.java.com.netdevsdk.demo.config.image;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_WHITE_BALANCE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_WHITE_BALANCE_MODE_E;

/**
 * 
 * @introduction White balance
 * @description Support IPC
 */
public class WhiteBlance {
	
    /**
     * 
     * @introduction Get white balance configure information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getWhiteBlance() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_WHITE_BALANCE_INFO_S balanceInfo=new NETDEV_WHITE_BALANCE_INFO_S();
		balanceInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGE_WHITE_BALANCE, balanceInfo.getPointer(), balanceInfo.size(), dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	balanceInfo.read();
        	int udwMode = balanceInfo.udwMode;
        	NetDemo.jComboBoxWhiteBalance.setSelectedIndex(udwMode);
        	
        	if(udwMode==1||udwMode==5||udwMode==8) {
                NetDemo.textRedOffSet.setEditable(true);
                NetDemo.RedoffSetslider.setValue(balanceInfo.dwRedOffset);
                NetDemo.textBlueOffSet.setEditable(true);
                NetDemo.BlueoffSetslider.setValue(balanceInfo.dwBlueOffset);
            }else {
                NetDemo.textRedOffSet.setEditable(false);
                NetDemo.textBlueOffSet.setEditable(false);
                NetDemo.BlueoffSetslider.setValue(0);
                NetDemo.RedoffSetslider.setValue(0);
            }
            NetDemo.textRedOffSet.setText(String.valueOf(balanceInfo.dwRedOffset));
            NetDemo.textBlueOffSet.setText(String.valueOf(balanceInfo.dwBlueOffset));
        }
	}
	
	/**
	 * 
	 * @introduction Set WhiteBlance
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setWhiteBlance() {
	    if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
		NETDEV_WHITE_BALANCE_INFO_S balanceInfo=new NETDEV_WHITE_BALANCE_INFO_S();
		balanceInfo.write();
		IntByReference dwBytesReturned = new IntByReference();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGE_WHITE_BALANCE, balanceInfo.getPointer(),balanceInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	balanceInfo.read();
        	int Mode=0;
			if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("AUTO")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_AUTO;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("TRIMMING")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_TRIMMING;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("INDOOR")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_INDOOR;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("OUTDOOR")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_OUTDOOR;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("MERCURYLAMP")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_AUTO_MERCURY_LAMP;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("NIGHT")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_NIGHT_TRIMMING;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("AUTONALAMP")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_AUTO_NA_LAMP;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("LOCK")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_LOCK;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("SELFADAPT")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_SELF_ADAPT_NIGHT_TRIMMING;
			}else if(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("AUTOSECOND")) {
				Mode=NETDEV_WHITE_BALANCE_MODE_E.NETDEV_WBM_AUTO_SECOND;
			}
			balanceInfo.udwMode=Mode;
			String getRedTextString=NetDemo.textRedOffSet.getText();
			int tRedTextString=0;
			try {
				tRedTextString=Integer.parseInt(getRedTextString);
			}catch(Exception n) {
				JOptionPane.showMessageDialog(null, "Red Parameter Exception");
				NetDemo.textRedOffSet.setText(null);
				return;
			}
			balanceInfo.dwRedOffset=tRedTextString;

			String getBlueTextString=NetDemo.textBlueOffSet.getText();
			int blueTextString=0;
			try {
				blueTextString=Integer.parseInt(getBlueTextString);
			}catch(Exception n) {
				JOptionPane.showMessageDialog(null, "Blue Parameter Exception");
				NetDemo.textBlueOffSet.setText(null);
				return;
			}
			balanceInfo.dwBlueOffset=blueTextString;
			balanceInfo.write();
			boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID,NETDEV_CONFIG_COMMAND_E.NETDEV_SET_IMAGE_WHITE_BALANCE, balanceInfo.getPointer(), balanceInfo.size() );
            if(bRet2 != true)
            {
            	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set success");
            }
        }
	}
	
	/**
	 * 
	 * @introduction Change white balance
	 * @description
	 *
	 */
	public static void comboxWhiteBlance() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

    	if((NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("TRIMMING"))||
    			(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("NIGHT"))||
    			(NetDemo.jComboBoxWhiteBalance.getItemAt(NetDemo.jComboBoxWhiteBalance.getSelectedIndex()).equals("SELFADAPT"))) {
    		NetDemo.textRedOffSet.setEditable(true);
    		NetDemo.textBlueOffSet.setEditable(true);
    		NetDemo.BlueoffSetslider.setEnabled(true);
    		NetDemo.RedoffSetslider.setEnabled(true);
        }else {
        	NetDemo.textRedOffSet.setEditable(false);
        	NetDemo.textBlueOffSet.setEditable(false);
        	NetDemo.BlueoffSetslider.setEnabled(false);
        	NetDemo.RedoffSetslider.setEnabled(false);
    	}
    	NETDEV_WHITE_BALANCE_INFO_S balanceInfo=new NETDEV_WHITE_BALANCE_INFO_S();
		balanceInfo.write();
		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IMAGE_WHITE_BALANCE, balanceInfo.getPointer(), balanceInfo.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	if(balanceInfo.udwMode==NetDemo.jComboBoxWhiteBalance.getSelectedIndex()) {
        	    int udwMode = balanceInfo.udwMode;
        	    NetDemo.jComboBoxWhiteBalance.setSelectedIndex(udwMode);
            	
            	NetDemo.textRedOffSet.setText(String.valueOf(balanceInfo.dwRedOffset));
            	NetDemo.textBlueOffSet.setText(String.valueOf(balanceInfo.dwBlueOffset));
        	}
        }
	}
}
