package main.java.com.netdevsdk.demo.config.network;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DNS_INFO_S;

/**
 * 
 * @introduction DNS configure
 * @description
 */
public class DNS {
    
    /**
     * 
     * @introduction Get DNS information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getDNSInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_DNS_INFO_S dnsList=new NETDEV_DNS_INFO_S();
		IntByReference dwBytesReturned=new IntByReference();
		dnsList.udwNum=2;
		dnsList.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DNS_CFG, dnsList.getPointer(), dnsList.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	dnsList.read();
        	for(int i=0;i<dnsList.udwNum;i++) {
        		int type=dnsList.astDNSList[i].udwAddressType;
        		if(type==0) {
        			NetDemo.jComboBoxIPtypeList.setSelectedIndex(0);
        		}else if(type==1) {
        			NetDemo.jComboBoxIPtypeList.setSelectedIndex(1);
        		}else if(type==2) {
        			NetDemo.jComboBoxIPtypeList.setSelectedIndex(2);
        		}else if(type==3) {
        			NetDemo.jComboBoxIPtypeList.setSelectedIndex(3);
        		}

        		byte[] ip4=dnsList.astDNSList[0].szIPAddress;
        		String ip4String1=Common.byteArrayToString(ip4);
        		byte[] ip41=dnsList.astDNSList[1].szIPAddress;
        		String ip4String2=Common.byteArrayToString(ip41);

        		NetDemo.textPreferredAddress.setText(ip4String1);
        		NetDemo.textAlternate.setText(ip4String2);
        	}
        }
	}
	
	/**
	 * 
	 * @introduction Set DNS informaiton
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setDNSInfo() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_DNS_INFO_S dnsList=new NETDEV_DNS_INFO_S();
		IntByReference dwBytesReturned=new IntByReference();
		dnsList.udwNum=2;
		dnsList.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_DNS_CFG, dnsList.getPointer(), dnsList.size(), dwBytesReturned );
        if(bRet != true)
        {
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {

        dnsList.read();
        dnsList.udwNum=2;
        String mainAddressString=NetDemo.textPreferredAddress.getText().replaceAll("  |","");
        String secondAddressString=NetDemo.textAlternate.getText().replaceAll("  |","");
    	if(mainAddressString==null||mainAddressString.equals("")) {
    		JOptionPane.showMessageDialog(null, "Please input PreferredAddress");
    		return;
    	}
    	try {
     		System.arraycopy(mainAddressString.getBytes(), 0, dnsList.astDNSList[0].szIPAddress, 0, mainAddressString.getBytes().length);
		}catch(NumberFormatException |InputMismatchException e2) {
			JOptionPane.showMessageDialog(null, "PreferredAddress is null or transformation Exception");
			return;
		}


     	if(secondAddressString==null||secondAddressString.equals("")) {
     		JOptionPane.showMessageDialog(null, "Please input AlternateAddress");
     		return;
     	}
     	try {
     		System.arraycopy(secondAddressString.getBytes(), 0, dnsList.astDNSList[1].szIPAddress, 0, secondAddressString.getBytes().length);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "AlternateAddress is null or transformation Exception");
				return;
			}
     	dnsList.write();
     	boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_DNS_CFG, dnsList.getPointer(), dnsList.size() );
        if(bRet2 != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	JOptionPane.showMessageDialog(null, "Set success");
        	}
        }
	}
}
