package main.java.com.netdevsdk.demo.config.privacymask;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PRIVACY_MASK_AREA_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PRIVACY_MASK_CFG_S;

/**
 * 
 * @introduction Privacy Mask
 * @description Support IPC/NVR
 */
public class PrivacyMask {
    
    /**
     * 
     * @introduction Add privacy mask
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void addPrivacyMask() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        Vector<String> PrivacyMaskVector = new Vector<String>();
        int dwInsertIndex = 0;
        for(int i = 0; i < NetDEVSDKLib.NETDEV_MAX_PRIVACY_MASK_AREA_NUM; i++) {
            dwInsertIndex = i + 1;
            if(i < NetDemo.ConfigPrivacyMaskTableModel.getRowCount()) {
                int dwCurrentIndex = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 0));
                if (dwInsertIndex >= dwCurrentIndex) {
                    continue;
                }
            }
            PrivacyMaskVector.add(String.valueOf(dwInsertIndex));
            PrivacyMaskVector.add("0");
            PrivacyMaskVector.add("0");
            PrivacyMaskVector.add("1000");
            PrivacyMaskVector.add("1000");
            NetDemo.ConfigPrivacyMaskTableModel.insertRow(i, PrivacyMaskVector);
            break;
        }

        NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskInfo = new NETDEV_PRIVACY_MASK_CFG_S();
        for(int i =0; i < NetDEVSDKLib.NETDEV_MAX_PRIVACY_MASK_AREA_NUM; i++) {
            stPrivacyMaskInfo.astArea[i] = new NETDEV_PRIVACY_MASK_AREA_INFO_S();
        }

        for(int i =0; i< NetDemo.ConfigPrivacyMaskTableModel.getRowCount(); i++) {
            stPrivacyMaskInfo.astArea[i].dwIndex = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 0));
            stPrivacyMaskInfo.astArea[i].dwTopLeftX = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 1));
            stPrivacyMaskInfo.astArea[i].dwTopLeftY = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 2));
            stPrivacyMaskInfo.astArea[i].dwBottomRightX = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 3));
            stPrivacyMaskInfo.astArea[i].dwBottomRightY = Integer.valueOf((String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 4));
            stPrivacyMaskInfo.astArea[i].bIsEanbled = 1;
        }
        stPrivacyMaskInfo.dwSize = NetDemo.ConfigPrivacyMaskTableModel.getRowCount();
        stPrivacyMaskInfo.write();

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_PRIVACYMASKCFG, stPrivacyMaskInfo.getPointer(), stPrivacyMaskInfo.size());
        if(bRet != true)
        {
            System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonGetPrivacyMask.doClick();
    }

    /**
     * 
     * @introduction Delete privacy mask
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void deletePrivacyMask() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0) {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        if(0 == NetDemo.tableConfigPrivacyMask.getRowCount()  || NetDemo.tableConfigPrivacyMask.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(null, "Please find privacy mask or seletc first.");
            return;
        }

        String strIndex = (String) NetDemo.tableConfigPrivacyMask.getValueAt(NetDemo.tableConfigPrivacyMask.getSelectedRow(), 0);
        IntByReference dwIndex = new IntByReference(Integer.valueOf(strIndex));

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_DELETE_PRIVACYMASKCFG, dwIndex.getPointer(), 4);
        if(bRet != true)
        {
            System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonGetPrivacyMask.doClick();
    }

    /**
     * 
     * @introduction Get Privacy mask
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getPrivacyMask() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        NetDemo.ConfigPrivacyMaskTableModel.setRowCount(0);
        NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskInfo = new NETDEV_PRIVACY_MASK_CFG_S();
        stPrivacyMaskInfo.write();
        IntByReference dwBytesReturned = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_PRIVACYMASKCFG, stPrivacyMaskInfo.getPointer(), stPrivacyMaskInfo.size(), dwBytesReturned );
        if(bRet != true) {
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stPrivacyMaskInfo.read();
        for(int i = 0; i < stPrivacyMaskInfo.dwSize; i++) {
            Vector<String> PrivacyMaskVector = new Vector<String>();
            PrivacyMaskVector.add(String.valueOf(stPrivacyMaskInfo.astArea[i].dwIndex));
            PrivacyMaskVector.add(String.valueOf(stPrivacyMaskInfo.astArea[i].dwTopLeftX));
            PrivacyMaskVector.add(String.valueOf(stPrivacyMaskInfo.astArea[i].dwTopLeftY));
            PrivacyMaskVector.add(String.valueOf(stPrivacyMaskInfo.astArea[i].dwBottomRightX));
            PrivacyMaskVector.add(String.valueOf(stPrivacyMaskInfo.astArea[i].dwBottomRightY));
            NetDemo.ConfigPrivacyMaskTableModel.addRow(PrivacyMaskVector);
        }
    }

    /**
     * 
     * @introduction Set privacy mask
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setPrivacyMask() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskInfo = new NETDEV_PRIVACY_MASK_CFG_S();
        for(int i =0; i < NetDEVSDKLib.NETDEV_MAX_PRIVACY_MASK_AREA_NUM; i++) {
            stPrivacyMaskInfo.astArea[i] = new NETDEV_PRIVACY_MASK_AREA_INFO_S();
        }
        for(int i =0; i< NetDemo.ConfigPrivacyMaskTableModel.getRowCount(); i++) {   
            String index=(String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 0);
            if(index==null||index.equals("")) {
                JOptionPane.showMessageDialog(null, "Index is null");
                return;
            }
            int getIndex=0;
            int getLeftX=0;
            int getLeftY=0;
            int getRightX=0;
            int getRightY=0;
            
            try {
                getIndex=Integer.parseInt(index);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "Index transformation Exception");
                return;
            }
            if(getIndex<0) {
                JOptionPane.showMessageDialog(null, "Index can not less than zero");
                return;
            } 
              
            String LeftX=(String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 1);
            try {
                getLeftX=Integer.parseInt(LeftX);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "LeftX transformation Exception");
                return;
            }
            if(getLeftX<0 || getLeftX>10000) {
                JOptionPane.showMessageDialog(null, "LeftX should between 0 and 10000");
                return;
            }
           
            String LeftY=(String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 2);
            if(LeftY==null||LeftY.equals("")) {
                JOptionPane.showMessageDialog(null, "LeftY is null");
                return;
            }
            try {
                getLeftY=Integer.parseInt(LeftY);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "LeftY transformation Exception");
                return;
            }
            if(getLeftY<0 || getLeftY>10000) {
                JOptionPane.showMessageDialog(null, "LeftY should between 0 and 10000");
                return;
            }
           
            String RightX=(String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 3);
            if(RightX==null||RightX.equals("")) {
                JOptionPane.showMessageDialog(null, "RightX is null");
                return;
            }
            try {
                getRightX=Integer.parseInt(RightX);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "RightX transformation Exception");
                return;
            }
            if(getRightX<0 || getRightX>10000) {
                JOptionPane.showMessageDialog(null, "RightX should between 0 and 10000");
                return;
            }
           
            String RightY=(String) NetDemo.ConfigPrivacyMaskTableModel.getValueAt(i, 4);
            if(RightY==null||RightY.equals("")) {
                JOptionPane.showMessageDialog(null, "RightY is null");
                return;
            }
            try {
                getRightY=Integer.parseInt(RightY);
            }catch(Exception t) {
                JOptionPane.showMessageDialog(null, "RightY transformation Exception");
                return;
            }
            if(getRightY<0 || getRightY>10000) {
                JOptionPane.showMessageDialog(null, "RightY should between 0 and 10000");
                return;
            }
            
            if(getRightX<getLeftX) {
                JOptionPane.showMessageDialog(null, "Right BottomX should more than Left TopX");
                return;
            }
            if(getRightY<getLeftY) {
                JOptionPane.showMessageDialog(null, "Right BottomY should more than Left TopY");
                return;
            }
            
            stPrivacyMaskInfo.astArea[i].dwIndex = getIndex;
            stPrivacyMaskInfo.astArea[i].dwTopLeftX = getLeftX;
            stPrivacyMaskInfo.astArea[i].dwTopLeftY = getLeftY;
            stPrivacyMaskInfo.astArea[i].dwBottomRightX =getRightX;
            stPrivacyMaskInfo.astArea[i].dwBottomRightY = getRightY;
            stPrivacyMaskInfo.astArea[i].bIsEanbled = 1;
        }
        
        stPrivacyMaskInfo.dwSize = NetDemo.ConfigPrivacyMaskTableModel.getRowCount();
        stPrivacyMaskInfo.write();
        
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_PRIVACYMASKCFG, stPrivacyMaskInfo.getPointer(), stPrivacyMaskInfo.size());
        if(bRet != true) {
            System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Set success");
            }
        NetDemo.jButtonGetPrivacyMask.doClick();
        }
    }
