package main.java.com.netdevsdk.demo.config.temper;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_TAMPER_DETECTION_RULE_INFO_S;

/**
 * 
 * @introduction Temper detection
 * @description Suppport IPC/NVR
 */
public class TemperDetection {
	
    /**
     * 
     * @introduction Get temper detection
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getTemperDetection() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}

		NETDEV_TAMPER_DETECTION_RULE_INFO_S stTamperDetectionInfo = new NETDEV_TAMPER_DETECTION_RULE_INFO_S();
		stTamperDetectionInfo.write();
		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_TAMPER_DETECTION_RULE_INFO, stTamperDetectionInfo.getPointer(), stTamperDetectionInfo.size() , dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	stTamperDetectionInfo.read();
            if(stTamperDetectionInfo.bEnabled == 1) {
            	NetDemo.chckbxConfigTamperChannelEnable.setSelected(true);
            }else {
                NetDemo.chckbxConfigTamperChannelEnable.setSelected(false);
            }
            NetDemo.textFieldConfigTemperChannelSensitivity.setText(String.valueOf(stTamperDetectionInfo.udwSensitivity));
            NetDemo.textFieldConfigTemperChannelDuration.setText(String.valueOf(stTamperDetectionInfo.udwDuration));
        }
	}
	
	/**
	 * 
	 * @introduction Set temper detection
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setTemperDetection() {
		if(null == NetDemo.lpUserID){
			JOptionPane.showMessageDialog(null, "Please Login device first. error code" +NetDemo.netdevsdk.NETDEV_GetLastError());
			return;
		}
		if(NetDemo.ChannelID == 0){
			JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
			return;
		}
		
		NETDEV_TAMPER_DETECTION_RULE_INFO_S stTamperDetectionInfo = new NETDEV_TAMPER_DETECTION_RULE_INFO_S();
		stTamperDetectionInfo.write();
		IntByReference dwBytesReturned = new IntByReference();

		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_TAMPER_DETECTION_RULE_INFO, stTamperDetectionInfo.getPointer(), stTamperDetectionInfo.size() , dwBytesReturned );
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
        	 stTamperDetectionInfo.read();
        	 String FieldConfigTemperChannelSensitivity=NetDemo.textFieldConfigTemperChannelSensitivity.getText();
             if(FieldConfigTemperChannelSensitivity==null||FieldConfigTemperChannelSensitivity.equals("")) {
             	JOptionPane.showMessageDialog(null, "Sensitivity is null");
             	return;
             }
             int ConfigTemperChannelSensitivity=1;
             try {
             	ConfigTemperChannelSensitivity=Integer.parseInt(FieldConfigTemperChannelSensitivity);
             }catch(Exception o) {
             	JOptionPane.showMessageDialog(null, "Sensitivity transformation Exception");
             	NetDemo.textFieldConfigTemperChannelSensitivity.setText(null);
             	return;
             }
             
             if(ConfigTemperChannelSensitivity<1 || ConfigTemperChannelSensitivity>100) {
             	JOptionPane.showMessageDialog(null, "Sensitivity should between 1 and 100");
             	NetDemo.textFieldConfigTemperChannelSensitivity.setText(null);
             	return;
             }
             
				stTamperDetectionInfo.udwSensitivity = ConfigTemperChannelSensitivity;
				if(NetDemo.chckbxConfigTamperChannelEnable.isSelected() == true) {
					stTamperDetectionInfo.bEnabled = 1;
				}else {
					stTamperDetectionInfo.bEnabled = 0;
				}
				
				String FieldConfigTemperChannelDuration=NetDemo.textFieldConfigTemperChannelDuration.getText();
				if(FieldConfigTemperChannelDuration==null||FieldConfigTemperChannelDuration.equals("")) {
				    JOptionPane.showMessageDialog(null, "Duration is null");
				    return;
				    } 
				int ConfigTemperChannelDuration=1;
				try {
				    ConfigTemperChannelDuration=Integer.parseInt(FieldConfigTemperChannelDuration);
				    }catch(Exception o) {
				        JOptionPane.showMessageDialog(null, "Duration transformation Exception");
				        NetDemo.textFieldConfigTemperChannelDuration.setText(null);
				        return;
				        }
				if(ConfigTemperChannelDuration<1 || ConfigTemperChannelDuration>10) {
	                JOptionPane.showMessageDialog(null, "Duration should between 1 and 10");
	                NetDemo.textFieldConfigTemperChannelDuration.setText(null);
	                return;
	             }        
				stTamperDetectionInfo.udwDuration = ConfigTemperChannelDuration;
				stTamperDetectionInfo.write();
				boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_TAMPER_DETECTION_RULE_INFO, stTamperDetectionInfo.getPointer(), stTamperDetectionInfo.size());
				if(bRet2 != true)
				{
				    JOptionPane.showMessageDialog(null, "Set data Failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
				    System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
				    return;
				    }else {
				        JOptionPane.showMessageDialog(null, "Set Success.");
				        }
				}
        }
	}
