package main.java.com.netdevsdk.demo.config.video;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IRCUT_FILTER_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IR_CUT_FILTER_MODE_E;

/**
 * 
 * @introduction IrCut Filter information
 * @description 
 */
public class IrCutFilterMode {
    
    /**
     * 
     * @introduction Get IrCutFilter Mode
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
    public static void getIrCutFilterMode() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        } 
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_IRCUT_FILTER_INFO_S IrcutMode=new NETDEV_IRCUT_FILTER_INFO_S();
        IrcutMode.write();
        IntByReference dwBytesReturned = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_IRCUTFILTERINFO, IrcutMode.getPointer(), IrcutMode.size(), dwBytesReturned );
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            IrcutMode.read();
            if(IrcutMode.enIrCutFilterMode==0) {
                NetDemo.jComboBoxIRcutMode.setSelectedIndex(0);
            }else if(IrcutMode.enIrCutFilterMode==1) {
                NetDemo.jComboBoxIRcutMode.setSelectedIndex(1);
            }else if(IrcutMode.enIrCutFilterMode==2) {
                NetDemo.jComboBoxIRcutMode.setSelectedIndex(2);
            }
        }
    }

    /**
     * 
     * @introduction Set IrCutFilter Mode
     * @description Calling the interface of NETDEV_SetDevConfig
     *
     */
    public static void setIrCutFilterMode() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        
        NETDEV_IRCUT_FILTER_INFO_S IrcutMode=new NETDEV_IRCUT_FILTER_INFO_S();
        int crutMode=0;
        if(NetDemo.jComboBoxIRcutMode.getItemAt(NetDemo.jComboBoxIRcutMode.getSelectedIndex()).equals("DAY")) {
            crutMode=NETDEV_IR_CUT_FILTER_MODE_E.NETDEV_IR_CUT_FILTER_ON;
        }else if(NetDemo.jComboBoxIRcutMode.getItemAt(NetDemo.jComboBoxIRcutMode.getSelectedIndex()).equals("NIGHT")) {
            crutMode=NETDEV_IR_CUT_FILTER_MODE_E.NETDEV_IR_CUT_FILTER_OFF;
        }else if(NetDemo.jComboBoxIRcutMode.getItemAt(NetDemo.jComboBoxIRcutMode.getSelectedIndex()).equals("AUTO")) {
            crutMode=NETDEV_IR_CUT_FILTER_MODE_E.NETDEV_IR_CUT_FILTER_AUTO;
        }
        IrcutMode.enIrCutFilterMode=crutMode;
        IrcutMode.write();
        boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_IRCUTFILTERINFO, IrcutMode.getPointer(), IrcutMode.size() );
        if(bRet2 != true)
        {
            JOptionPane.showMessageDialog(null, "Set failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }else {
            JOptionPane.showMessageDialog(null, "Set success");
        }
    }
}
