package main.java.com.netdevsdk.demo.config.video;

import java.util.InputMismatchException;

import javax.swing.JOptionPane;

import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CONFIG_COMMAND_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_SNAPSHOT_S;

/**
 * 
 * @introduction SnapShot configure
 * @description Support IPC
 */
public class SnapShot {

    /**
     * 
     * @introduction Get snapshot configure information
     * @description Calling the interface of NETDEV_GetDevConfig
     *
     */
	public static void getSnapShot() {
	    if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return ;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return ;
        }
		NETDEV_VIDEO_SNAPSHOT_S snapshotInfo =new NETDEV_VIDEO_SNAPSHOT_S();
		IntByReference dwBytesReturned = new IntByReference();
		snapshotInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, 
				NETDEV_CONFIG_COMMAND_E.NETDEV_GET_SNAPSHOT_CFG, snapshotInfo.getPointer(),snapshotInfo.size(),dwBytesReturned);
        if(bRet != true) {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
        }
        else {
        	snapshotInfo.read();
        	if(snapshotInfo.bIsEnabled==1) {
        		NetDemo.chckbxEnableGetPicture.setSelected(true);
        	}else {
        		NetDemo.chckbxEnableGetPicture.setSelected(false);
        	}
        	NetDemo.textFieldSnapshotWidth.setText(String.valueOf(snapshotInfo.stResolution.dwWidth));
        	NetDemo.textFieldSnapshotHeight.setText(String.valueOf(snapshotInfo.stResolution.dwHeight));
        	NetDemo.textFieldPictureMaxSize.setText(String.valueOf(snapshotInfo.udwPictureMaxSize));
        	NetDemo.textFieldSnapshotInterval.setText(String.valueOf(snapshotInfo.udwSnapshotInterval));
        	NetDemo.textFieldSnapshotNum.setText(String.valueOf(snapshotInfo.udwSnapshotNum));
        }		
	}

	/**
	 * 
	 * @introduction Set snapshot configure information
	 * @description Calling the interface of NETDEV_SetDevConfig
	 *
	 */
	public static void setSnapShot() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return ;
        }
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return ;
        }
		NETDEV_VIDEO_SNAPSHOT_S snapshotInfo =new NETDEV_VIDEO_SNAPSHOT_S();
		IntByReference dwBytesReturned = new IntByReference();
		snapshotInfo.write();
		boolean bRet = NetDemo.netdevsdk.NETDEV_GetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_GET_SNAPSHOT_CFG, snapshotInfo.getPointer(),snapshotInfo.size(),dwBytesReturned);
        if(bRet != true)
        {
        	JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        	System.out.printf("NETDEV_GetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else {
        	snapshotInfo.read();
        	if(NetDemo.chckbxEnableGetPicture.isSelected()) {
        		snapshotInfo.bIsEnabled=1;
        	}else {
        		snapshotInfo.bIsEnabled=0;
        	}
        	String gettextFieldSnapshotWidth=NetDemo.textFieldSnapshotWidth.getText();
			int SnapshotWidth=0;
			if(gettextFieldSnapshotWidth==null||gettextFieldSnapshotWidth.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input width");
				return;
			}
			try {
				SnapshotWidth=Integer.parseInt(gettextFieldSnapshotWidth);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Width is null or transformation Exception");
				NetDemo.textFieldSnapshotWidth.setText(null);
				System.out.println("Width is null or transformation Exception");
				return;
			}
			if(SnapshotWidth<0) {
				NetDemo.textFieldSnapshotWidth.setText(null);
				JOptionPane.showMessageDialog(null, "Width can not less than 0");
        		return;
    		}
			
        	String gettextFieldSnapshotHeight=NetDemo.textFieldSnapshotHeight.getText();
        	int shotHeight=0;
        	if( gettextFieldSnapshotHeight==null||gettextFieldSnapshotHeight.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input height");
				return;
			}
        	try {
        		shotHeight=Integer.parseInt(gettextFieldSnapshotHeight);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Height is null or transformation Exception");
				NetDemo.textFieldSnapshotHeight.setText(null);
				return;
			}
        	if(shotHeight<0) {
        		NetDemo.textFieldSnapshotHeight.setText(null);
        		JOptionPane.showMessageDialog(null, "Height can not less than 0");
        		return;
    		}
        	
        	String gettextFieldPictureMaxSize=NetDemo.textFieldPictureMaxSize.getText();
        	int PictureMaxSize=0;
        	if(gettextFieldPictureMaxSize==null||gettextFieldPictureMaxSize.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input MaxSize");
				return;
			}
        	try {
        		PictureMaxSize=Integer.parseInt(gettextFieldPictureMaxSize);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "MaxSize is null or transformation Exception");
				NetDemo.textFieldPictureMaxSize.setText(null);
				return;
			}
        	if(PictureMaxSize<0) {
        		NetDemo.textFieldPictureMaxSize.setText(null);
        		JOptionPane.showMessageDialog(null, "MaxSize can not less than 0");
        		return;
    		}
        	
        	String gettextFieldSnapshotInterval=NetDemo.textFieldSnapshotInterval.getText();
        	int shotInterval=1;
        	if(gettextFieldSnapshotInterval==null||gettextFieldSnapshotInterval.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input Interval");
				return;
			}
        	try {
        		shotInterval=Integer.parseInt(gettextFieldSnapshotInterval);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Interval is null or transformation Exception");
				NetDemo.textFieldSnapshotInterval.setText(null);
				return;
			}
        	if(shotInterval<1) {
        		NetDemo.textFieldSnapshotInterval.setText(null);
        		JOptionPane.showMessageDialog(null, "Interval can not less than 1");
        		return;
    		}
        	if(shotInterval>60) {
        		NetDemo.textFieldSnapshotInterval.setText(null);
        		JOptionPane.showMessageDialog(null, "Interval can not more than sixty");
        		return;
    		}
        	
        	String gettextFieldSnapshotNum=NetDemo.textFieldSnapshotNum.getText();
        	int shotNum=1;
        	if(gettextFieldSnapshotNum==null||gettextFieldSnapshotNum.equals("")) {
				JOptionPane.showMessageDialog(null, "Please input num");
				return;
			}
        	try {
        		shotNum=Integer.parseInt(gettextFieldSnapshotNum);
			}catch(NumberFormatException |InputMismatchException e2) {
				JOptionPane.showMessageDialog(null, "Num is null or transformation Exception");
				NetDemo.textFieldSnapshotNum.setText(null);
				return;
			}
        	if(shotNum<1||shotNum>3) {
        		NetDemo.textFieldSnapshotNum.setText(null);
        		JOptionPane.showMessageDialog(null, "Num should between 1 and 3");
        		return;
    		}
        	
        	snapshotInfo.udwPictureMaxSize=PictureMaxSize;
        	snapshotInfo.stResolution.dwWidth=SnapshotWidth;
        	snapshotInfo.stResolution.dwHeight=shotHeight;
        	snapshotInfo.udwSnapshotNum=shotNum;
        	snapshotInfo.udwSnapshotInterval=shotInterval;    	
        	snapshotInfo.write();
        	
        	boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetDevConfig(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_CONFIG_COMMAND_E.NETDEV_SET_SNAPSHOT_CFG, snapshotInfo.getPointer(), snapshotInfo.size());
            if(!bRet2)
            {
            	JOptionPane.showMessageDialog(null, "Set data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            	System.out.printf("NETDEV_SetDevConfig failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
            	JOptionPane.showMessageDialog(null, "Set scuess");
            	NetDemo.jButtonGetSnapshot.doClick();
            }
        }
	}	
}
