package main.java.com.netdevsdk.demo.liveview.live;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FISHEYE_PTZ_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_INSTALL_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MOUSE_MOVE_MODE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_POINT_S;

/**
 * 
 * @introduction Fisheye
 * @description Support special device with fisheye lens
 */
public class EyeFish {
    /**
     * 
     * @introduction Change fisheye install mode
     * @description  Change fisheye install mode to get the fisheye ptzMode 
     *
     */
    public static void changeMount() {
        if(NetDemo.ChannelID == 0){
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        int  EyeShowPtzMode=NetDemo.jComboBoxFishEyeMount.getSelectedIndex();
        String EyeShowname=NetDemo.jComboBoxFishEyeMount.getItemAt(EyeShowPtzMode);
        if(EyeShowname==null) {
            return;
        }
        if(EyeShowname.equals("TOP")) {
            EyeShowPtzMode=NETDEV_INSTALL_MODE_E.NETDEV_INSTALL_MODE_TOP;
            NetDemo.jComboBoxPreviewMode.removeAllItems();
            NetDemo.jComboBoxPreviewMode.addItem("ORIGINAL");
            NetDemo.jComboBoxPreviewMode.addItem("360+1PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("LEFT+4PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("180");
            NetDemo.jComboBoxPreviewMode.addItem("3PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("360+6PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("8PTZ");
            NetDemo.jComboBoxPreviewMode.setSelectedIndex(0);
        }
        else if(EyeShowname.equals("BOTTOM")) {
            EyeShowPtzMode=NETDEV_INSTALL_MODE_E.NETDEV_INSTALL_MODE_BOTTOM ;
            NetDemo.jComboBoxPreviewMode.removeAllItems();     
            NetDemo.jComboBoxPreviewMode.addItem("ORIGINAL");
            NetDemo.jComboBoxPreviewMode.addItem("360+1PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("LEFT+4PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("180");
            NetDemo.jComboBoxPreviewMode.addItem("3PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("360+6PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("8PTZ");
            NetDemo.jComboBoxPreviewMode.setSelectedIndex(0);
        }
        else if(EyeShowname.equals("Side")) {
            EyeShowPtzMode=NETDEV_INSTALL_MODE_E.NETDEV_INSTALL_MODE_SIDE;
            NetDemo.jComboBoxPreviewMode.removeAllItems();
            NetDemo.jComboBoxPreviewMode.addItem("ORIGINAL");
            NetDemo.jComboBoxPreviewMode.addItem("PANORAMA");
            NetDemo.jComboBoxPreviewMode.addItem("PR+3PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("PR+4PTZ");
            NetDemo.jComboBoxPreviewMode.addItem("PR+8PTZ");
            NetDemo.jComboBoxPreviewMode.setSelectedIndex(0);
        }

    
    }

    /**
     * 
     * @introduction Select fisheye ptzMode
     * @description Calling the interface of NETDEV_SetPtzAndFixMode to set fisheye fixmode
     *
     */
    public static void selectPreviewMode() {
        int EyeChoosePtzMode = NetDemo.jComboBoxPreviewMode.getSelectedIndex();
        String PtzModeName=NetDemo.jComboBoxPreviewMode.getItemAt(EyeChoosePtzMode);
        if(PtzModeName==null) {
            return;
        }
        IntByReference pbFishEyeStream=new IntByReference();
        IntByReference udwPtzMode = new IntByReference();
        IntByReference dwInstallMode = new IntByReference();
        int EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_LEFT_4PTZ;       
        switch(PtzModeName) {
        case "ORIGINAL" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_ORIGINAL;
            break;
        case "360+1PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_360_1PTZ;
            break;
        case "LEFT+4PTZ":
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_LEFT_4PTZ;
            break;
        case "180" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_180;
            break;
        case "3PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_3PTZ;
            break;
        case "360+6PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_360_6PTZ;
            break;
        case "8PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_8PTZ;
            break;
        case "PANORAMA" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_PANORAMA;
            break;
        case "PR+3PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_PR_3PTZ;
            break;
        case "PR+4PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_PR_4PTZ;
            break;
        case "PR+8PTZ" :
            EyePtzMode=NETDEV_FISHEYE_PTZ_MODE_E.NETDEV_FISHEYE_MODE_PR_8PTZ;
            break;
        }
        
        boolean bRet=NetDemo.netdevsdk.NETDEV_IsFishEyeStream(NetDemo.lpPlayHandle,pbFishEyeStream);
        if(bRet) {
            boolean bRet1=NetDemo.netdevsdk.NETDEV_GetPtzAndFixMode(NetDemo.lpPlayHandle,udwPtzMode,dwInstallMode);
            if(bRet1) {
                NetDemo.netdevsdk.NETDEV_SetPtzAndFixMode(NetDemo.lpPlayHandle,EyePtzMode,NetDemo.jComboBoxFishEyeMount.getSelectedIndex());
                        IntByReference pudwRadius=new IntByReference();
                        NETDEV_POINT_S pstPoint =new NETDEV_POINT_S();
                        pstPoint.dwPointX=100;
                        pstPoint.dwPointY=200;
                        pstPoint.write();
                        Pointer lpParm=new Memory(128);
                        boolean bRet2=NetDemo.netdevsdk.NETDEV_GetFishEyeParam(NetDemo.lpPlayHandle,pstPoint,pudwRadius,lpParm);
                        if(bRet2) {                          
                            NetDemo.panelPlayLabel.addMouseListener(new MouseAdapter() {
                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    NetDemo.netdevsdk.NETDEV_SetMouseMoveMode(NetDemo.lpPlayHandle, NETDEV_MOUSE_MOVE_MODE_E.NETDEV_MOUSE_MOVE , 0, (short)45,pstPoint);
                                    
                                }
                            });
                        }   
            }else {
                System.out.println("NETDEV_GetPtzAndFixMode failed, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }else {
            System.out.println("NETDEV_IsFishEyeStream, error:" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
    
    }

}
