package main.java.com.netdevsdk.demo.liveview.live;

import main.java.com.netdevsdk.demo.NetDemo;

import javax.swing.*;

/**
 * 
 * @introduction Callback function to register streams (original stream)
 * @description Support IPC/NVR/VMS
 */
public class PlayDataCallBack {

    /**
     * 
     * @introduction Start callback function to register streams (original stream)
     * @description Calling the interface of NETDEV_SetPlayDataCallBack to start callback function to register streams (original stream)
     *
     */
    public static void startCallBack(){
        if(null == NetDemo.lpUserID) {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
            }
        if(null != NetDemo.lpPlayHandle){
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetPlayDataCallBack(NetDemo.lpPlayHandle, NetDemo.fPlayDataCallBack, 1, null);
            if(bRet){
                NetDemo.jButtonStartSourceData.setEnabled(false);
                NetDemo.jButtonStopSourceData.setEnabled(true);
            }
            else{
                JOptionPane.showMessageDialog(null, "Set Play Source Data failed.");
            }
        }else{
            JOptionPane.showMessageDialog(null, "Start live, please.");
        }

    }

    /**
     * 
     * @introduction Stop callback function to register streams (original stream)
     * @description Calling the interface of NETDEV_SetPlayDataCallBack to stop callback function to register streams (original stream)
     *
     */
    public static void stopCallBack() {
        if(null != NetDemo.lpPlayHandle){
            NetDemo.netdevsdk.NETDEV_SetPlayDataCallBack(NetDemo.lpPlayHandle, null, 1, null);
            NetDemo.jButtonStartSourceData.setEnabled(true);
            NetDemo.jButtonStopSourceData.setEnabled(false);
        }
    
    }
}
