package main.java.com.netdevsdk.demo.login;

import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.Common.NETDEMO_DEVICE_INFO_S;
import main.java.com.netdevsdk.demo.util.Common.NETDEMO_DEV_LOGININFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CHN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_BASE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_MAIN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEV_BASIC_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEV_CHN_ENCODE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IPADDR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_USER_SIMPLE_INFO_S;

/**
 * 
 * @introduction Log in and log out
 * @description Support IPC/NVR/VMS, and VMS only support private protocol
 */
public class Login {
    /**
     * 
     * @introduction Log in
     * @description
     *
     */
    public static void loginIn() {
        String strUserName = NetDemo.jTextFieldLoginUserName.getText();
        String strPassword = NetDemo.jPasswordFieldLoginPassword.getText();
        String strPort = NetDemo.jTextFieldLoginPort.getText();
        NetDemo.strIPAddr = NetDemo.jTextFieldLoginIP.getText();
        
        if(strUserName.isEmpty()){
            JOptionPane.showMessageDialog(null, "Enter UserName first.");
            return;
        }
        if(NetDemo.strIPAddr.isEmpty()){
            JOptionPane.showMessageDialog(null, "Enter IP first.");
            return;
        }
        if(strPort.isEmpty()){
            JOptionPane.showMessageDialog(null, "Enter Port first.");
            return;
        }
        
        NetDEVSDKLib.NETDEV_DEVICE_LOGIN_INFO_S stDevLoginInfo = new NetDEVSDKLib.NETDEV_DEVICE_LOGIN_INFO_S();
        NetDEVSDKLib.NETDEV_SELOG_INFO_S stSELogInfo = new NetDEVSDKLib.NETDEV_SELOG_INFO_S();
        System.arraycopy(strUserName.getBytes(), 0, stDevLoginInfo.szUserName, 0, strUserName.getBytes().length);
        System.arraycopy(strPassword.getBytes(), 0, stDevLoginInfo.szPassword, 0, strPassword.getBytes().length);
        System.arraycopy(NetDemo.strIPAddr.getBytes(), 0, stDevLoginInfo.szIPAddr, 0, NetDemo.strIPAddr.getBytes().length);
        
        int getStrPort=0;
        try {
            getStrPort=Integer.parseInt(strPort);
        }catch(Exception m) {
            JOptionPane.showMessageDialog(null, "Port Conversion Exception");
            NetDemo.jTextFieldLoginPort.setText(null);
            return;
        }
        
        if(getStrPort<1 || getStrPort>65535) {
            JOptionPane.showMessageDialog(null, "Port should between 1 and 65535");
            NetDemo.jTextFieldLoginPort.setText(null);
            return;
        }
        stDevLoginInfo.dwPort = getStrPort;
        
        stDevLoginInfo.dwLoginProto = NetDemo.jComboBoxLoginProtocol.getSelectedIndex();
        if((NetDemo.jComboBoxDeviceType.getSelectedIndex()==0)&&(NetDemo.jComboBoxLoginProtocol.getSelectedIndex()==1)) {
            JOptionPane.showMessageDialog(null, "Please right choose equipment corresponding protocol ");
            return;
        }   
        if((NetDemo.jComboBoxDeviceType.getSelectedIndex()==1)&&(NetDemo.jComboBoxLoginProtocol.getSelectedIndex()==0)) {
            JOptionPane.showMessageDialog(null, "Please right choose equipment corresponding protocol ");
            return;
        }   
        
        NetDemo.lpUserID = NetDemo.netdevsdk.NETDEV_Login_V30(stDevLoginInfo, stSELogInfo);
        if(null != NetDemo.lpUserID){
            NetDemo.jComboBoxDeviceType.setEnabled(false);
            NetDemo.jComboBoxLoginProtocol.setEnabled(false);
            NetDemo.singleLoginThread.execute(new Runnable() {
                @Override
                public void run() {
                    if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0){
                        int nMaxChlCount = 256;
                        IntByReference dwChlCount = new IntByReference(nMaxChlCount);
                        NetDEVSDKLib.NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S[] stVideoChlList = (NetDEVSDKLib.NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S[])new NetDEVSDKLib.NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S().toArray(nMaxChlCount);
                        boolean bRet = NetDemo.netdevsdk.NETDEV_QueryVideoChlDetailListEx(NetDemo.lpUserID, dwChlCount, stVideoChlList);
                        NetDemo.DeviceTableModel.setRowCount(0);
                        if(bRet)
                        {
                            for(int i=0; i<dwChlCount.getValue(); i++)
                            {
                                Vector<String> vector = new Vector<String>();
                                vector.add(String.valueOf(stVideoChlList[i].dwChannelID));
                                vector.add(Common.DevideStatusToString(stVideoChlList[i].enStatus));
                                vector.add(Common.utfToString(stVideoChlList[i].szChnName));
                                NetDemo.DeviceTableModel.insertRow(i,vector);
                            }
                        }
                        NetDemo.netdevsdk.NETDEV_SetFaceSnapshotCallBack(NetDemo.lpUserID,  NetDemo.cbFaceSnapshotCallBack, null);
                        NetDemo.netdevsdk.NETDEV_SetCarPlateCallBack( NetDemo.lpUserID,  NetDemo.cbCarPlateCallBack, null);
                        NetDemo.netdevsdk.NETDEV_SetPassengerFlowStatisticCallBack( NetDemo.lpUserID,  NetDemo.cbPassengerFlowStatisticCallBack, null);   
                    }
                    else{
                        NetDemo.gastLoginDeviceInfo = new NETDEMO_DEV_LOGININFO_S();
                        NetDemo.gastLoginDeviceInfo.pHandle = NetDemo.lpUserID;
                        int devIndex= 0;
                        int dwDeviceType = NETDEV_DEVICE_MAIN_TYPE_E.NETDEV_DTYPE_MAIN_ENCODE;
                        for(int i =0; i < 2; i++)
                        {
                            Pointer lpDevFindHandle = NetDemo.netdevsdk.NETDEV_FindDevList(NetDemo.lpUserID, dwDeviceType);
                            if(lpDevFindHandle != null)
                            {
                                while(true)
                                {
                                    NETDEV_DEV_BASIC_INFO_S stDevInfo = new NETDEV_DEV_BASIC_INFO_S();
                                    stDevInfo.stDevAddr = new NETDEV_IPADDR_INFO_S();
                                    stDevInfo.stDevUserInfo = new NETDEV_USER_SIMPLE_INFO_S();
                                    if(true == NetDemo.netdevsdk.NETDEV_FindNextDevInfo(lpDevFindHandle, stDevInfo))
                                    {
                                        NETDEMO_DEVICE_INFO_S stDemoDeviceInfo = new NETDEMO_DEVICE_INFO_S();
                                        stDemoDeviceInfo.stDevBasicInfo = stDevInfo;
                                        stDemoDeviceInfo.dwDevIndex = devIndex;
                                        NetDemo.gastLoginDeviceInfo.stDevLoginInfo.put(devIndex, stDemoDeviceInfo);
                                        NetDemo.gastLoginDeviceInfo.dwDevNum++;

                                        Pointer lpChnFindHandle = NetDemo.netdevsdk.NETDEV_FindDevChnList(NetDemo.gastLoginDeviceInfo.pHandle, stDevInfo.dwDevID, NETDEV_CHN_TYPE_E.NETDEV_CHN_TYPE_ENCODE);
                                        if(null != lpChnFindHandle)
                                        {

                                            while(true)
                                            {
                                                NETDEV_DEV_CHN_ENCODE_INFO_S stDevChnEncodeInfo = new NETDEV_DEV_CHN_ENCODE_INFO_S();
                                                stDevChnEncodeInfo.write();
                                                IntByReference dwBytesReturned = new IntByReference(0);
                                                if(true == NetDemo.netdevsdk.NETDEV_FindNextDevChn(lpChnFindHandle, stDevChnEncodeInfo.getPointer(),stDevChnEncodeInfo.size(), dwBytesReturned))
                                                {
                                                    stDevChnEncodeInfo.read(); //将指针内存中字段写入到结构体中
                                                    Vector<String> vector = new Vector<String>();
                                                    vector.add(String.valueOf(stDevChnEncodeInfo.stChnBaseInfo.dwChannelID));
                                                    vector.add(Common.CHNStatusToString(stDevChnEncodeInfo.stChnBaseInfo.dwChnStatus));
                                                    vector.add(Common.utfToString(stDevChnEncodeInfo.stChnBaseInfo.szChnName));
                                                    NetDemo.DeviceTableModel.addRow(vector);

                                                    NetDemo.gastLoginDeviceInfo.stDevLoginInfo.get(devIndex).vecChanInfo.add(stDevChnEncodeInfo);
                                                    NetDemo.gastLoginDeviceInfo.stDevLoginInfo.get(devIndex).dwChnNum++;
                                                }
                                                else
                                                {
                                                    break;
                                                }
                                            }
                                            NetDemo.netdevsdk.NETDEV_FindCloseDevChn(lpChnFindHandle);
                                        }
                                    }
                                    else
                                    {
                                        break;
                                    }
                                    devIndex++;
                                }
                                NetDemo.netdevsdk.NETDEV_FindCloseDevInfo(lpDevFindHandle);
                            }
                            dwDeviceType = NETDEV_DEVICE_MAIN_TYPE_E.NETDEV_DTYPE_MAIN_BAYONET;
                        }
                    }
                }
            });
            {
                NetDemo.jButtonLogIn.setEnabled(false);
                NetDemo.jButtonLogOut.setEnabled(true);
                NetDemo.jTextFieldConfigImageExposureSlowestShutter.setEnabled(false);
                if(NetDemo.jComboBoxDeviceType.getSelectedIndex()==0) {
                    NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(true);
                    NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(true);
                }else {
                    NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(false);
                    NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
                }
                NetDemo.runflag=true; 
            }
        }
        else
        {
            System.out.print("error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            if(NetDemo.netdevsdk.NETDEV_GetLastError()==11201){
                JOptionPane.showMessageDialog(null, "Login failed, Please check username and password");
            }else {
                JOptionPane.showMessageDialog(null, "Login failed, Please check device information.");
            } 
        }
        NetDemo.pstDeviceInfo = new NETDEV_DEVICE_BASE_INFO_S();
        NetDemo.pstDeviceInfo.write();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetDeviceBaseInfo(NetDemo.lpUserID,NetDemo.pstDeviceInfo);
        if(bRet != true){
            System.out.println("NETDEV_GetDeviceBaseInfo failed:%d\n" + NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.pstDeviceInfo.read();
        
        if((NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)&&(NetDemo.jComboBoxDeviceType.getSelectedIndex()==0)) {
            JOptionPane.showMessageDialog(null, "Please right choose equipment type ");
            NetDemo.jButtonLogOut.doClick();
            return;
        }
        if((NetDemo.pstDeviceInfo.dwDeviceType != NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)&&(NetDemo.jComboBoxDeviceType.getSelectedIndex()==1)) {
            JOptionPane.showMessageDialog(null, "Please right choose equipment type ");
            NetDemo.jButtonLogOut.doClick();
            return;
        }
        
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR ||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR ||
                        NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP ) {   
            NetDemo.comboBoxFontMargin.setEnabled(false);
            NetDemo.comboBoxFontStyle.setEnabled(false);
            NetDemo.comboBoxFontStyleAlign.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign2.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign3.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign4.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign5.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign6.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign7.setEnabled(false);
            NetDemo.jComboBoxFontStyleAlign8.setEnabled(false);   
          }else {
              NetDemo.comboBoxFontMargin.setEnabled(true);
              NetDemo.comboBoxFontStyle.setEnabled(true);
              NetDemo.comboBoxFontStyleAlign.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign2.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign3.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign4.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign5.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign6.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign7.setEnabled(true);
              NetDemo.jComboBoxFontStyleAlign8.setEnabled(true);
          }
        
        Pointer lpUserData=new Memory(128);
        boolean rbet=NetDemo.netdevsdk.NETDEV_SetExceptionCallBack(NetDemo.cbExceptionCallBack,lpUserData);
        if(!rbet) {
            System.out.println("NETDEV_SetExceptionCallBack failed:%d\n" + NetDemo.netdevsdk.NETDEV_GetLastError());
        }
    }

    /**
     * 
     * @introduction Log out
     * @description
     *
     */
    public static void loginOut() {
        NetDemo.runflag=false;
        NetDemo.isTimer=false;
        if(null != NetDemo.lpTalkHandle){
            NetDemo.netdevsdk.NETDEV_StopVoiceCom(NetDemo.lpTalkHandle);
            NetDemo.lpTalkHandle = null;
        }
        if(null != NetDemo.lpPlayHandle){
            NetDemo.netdevsdk.NETDEV_StopRealPlay(NetDemo.lpPlayHandle);
            NetDemo.lpPlayHandle = null;
        }
        NetDemo.panelPlayLabel.repaint();
        
        if(null != NetDemo.lpUserID){
            NetDemo.netdevsdk.NETDEV_SetPassengerFlowStatisticCallBack(NetDemo.lpUserID, null, null);
            NetDemo.VCAPeopleCountingTableModel.setRowCount(0);
            NetDemo.netdevsdk.NETDEV_Logout(NetDemo.lpUserID);
            int numrow=NetDemo.VATable.getRowCount();
            for(int i=0;i<numrow;i++) {
                NetDemo.VATable.setValueAt(false, i, 0);
            }
            /* 清空组件数据 */
            clearData();
        }
        NetDemo.pstDeviceInfo = null;
        NetDemo.DeviceTableModel.setRowCount(0);
        
        {
            NetDemo.jButtonLogIn.setEnabled(true);
            NetDemo.jButtonLogOut.setEnabled(false);
            NetDemo.runflag=false;
            new Timer().schedule(new TimerTask() {
                @Override
                public void run() {
                    NetDemo.textFieldBasicTime.setText(null);
                }   
            }, 1000);
        }
    }

    /**
     * 
     * @introduction Clear component data
     * @description
     *
     */
    private static void clearData() {
        NetDemo.ChannelID=0;
        NetDemo.comboBoxConfigVideoStreamEncodeFormat.setSelectedIndex(0);
        NetDemo.textFieldConfigTemperEquipmentSensitivity.setText(null);
        NetDemo.PTZBasePresetModel.setRowCount(0);
        NetDemo.comboBoxConfigVideoStreamEncodeFormat.setEnabled(true);
        NetDemo.textFieldConfigVideoStreamResolutionWidth.setEnabled(true);
        NetDemo.textFieldConfigVideoStreamResolutionHigth.setEnabled(true);
        NetDemo.lpTalkHandle=null;
        NetDemo.jComboBoxDeviceType.setEnabled(true);
        NetDemo.VehicleTableModle.setRowCount(0);
        NetDemo.jComboBoxLoginProtocol.setEnabled(true);
        NetDemo.chckbxConfigNetWorkNTPEnable.setSelected(false);
        NetDemo.AlarmTableModel.setRowCount(0);
        NetDemo.state=0;
        NetDemo.lpID2=null;
        NetDemo.jSliderLiveSound.setValue(120);
        NetDemo.jSliderLiveMicSound.setValue(120);
        NetDemo.jButtonLiveSoundSilence.setEnabled(true);
        NetDemo.jSliderLiveSound.setEnabled(true);
        NetDemo.textFieldImageInfo3DNoiseReduce.setText(null);
        NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
        NetDemo.comboBoxCardListSzName.removeAllItems();
        NetDemo.comboBoxConfigVideoStreamQuality.setSelectedIndex(0);
        NetDemo.textFieldNetWorkCardMode.setText(null);
        NetDemo.textFieldNetWorkCardName.setText(null);
        NetDemo.jButtonMic.setVisible(true);
        NetDemo.jSliderLiveMicSound.setVisible(true);
        NetDemo.jSliderPlayBack.setValue(0);
        NetDemo.lblPlaybackSpeed.setText("1X");
        NetDemo.lblProgressLabel.setText(null);
        NetDemo.VehicleMonitorTableModel.setRowCount(0);
        NetDemo.textFieldConfigVideoStreamFrameRate.setText(null);
        NetDemo.textFieldConfigVideoStreamResolutionWidth.setText(null);
        NetDemo.textFieldConfigVideoStreamResolutionHigth.setText(null);
        NetDemo.textFieldConfigVideoStreamBitRate.setText(null);
        NetDemo.textFieldConfigVideoStreamIFremeInterval.setText(null);
        NetDemo.comboBoxConfigVideoStreamRate.setSelectedIndex(0);
        NetDemo.textCardListOneMac.setText(null);
        NetDemo.textIPv4Address.setText(null);
        NetDemo.textCardListOneNetMask.setText(null);
        NetDemo.textCardListOneGateWay.setText(null);
        NetDemo.textFieldConfigDeviceName.setText(null);
        NetDemo.textFieldBasicTime.setText(null);
        NetDemo.textListCardOneMtuLength.setText(null);
        NetDemo.jComboBoxIPtypeList.setSelectedIndex(0);
        NetDemo.textPreferredAddress.setText(null);
        NetDemo.textAlternate.setText(null);
        NetDemo.textBasicNetWorkPortHttp.setText(null);
        NetDemo.textBasicNetWorkPortHttps.setText(null);
        NetDemo.textBasicNetWorkPortRtsp.setText(null);
        NetDemo.textVpnAddress.setText(null);
        NetDemo.textVpnPort.setText(null);
        NetDemo.RecordStatusTableModel.setRowCount(0);
        NetDemo.RecordByMonthTableModel.setRowCount(0);
        NetDemo.jLabelLiveViewStreamUrl.setText(null);
        NetDemo.jLabelBitRateParam.setText(null);
        NetDemo.jLabelFrameRate.setText(null);
        NetDemo.jLabelVideoEncodeFmt.setText(null);
        NetDemo.jLabelGetpdwWidth.setText(null);
        NetDemo.jLabelGetpdwHeight.setText(null);
        NetDemo.jLabelGetpulRecvPktNum.setText(null);
        NetDemo.jTextFieldDigitalZoomLeft.setText(null);
        NetDemo.jTextFieldDigitalZoomRight.setText(null);
        NetDemo.jTextFieldDigitalZoomTop.setText(null);
        NetDemo.jTextFieldDigitalZoomBottom.setText(null);
        NetDemo.PeopleCountingVMSNVRStatistalTableModel.setRowCount(0);
        NetDemo.PeopleCountingVMSNVRRealTimeTableModel.setRowCount(0);
        NetDemo.lpUserID = null;
        NetDemo.strIPAddr = null;
        NetDemo.textFieldConfigVideoStreamIFremeInterval.setEnabled(true);
        NetDemo.comboBoxFontMargin.setEnabled(true);
        NetDemo.comboBoxFontStyle.setEnabled(true);
        NetDemo.comboBoxFontStyleAlign.setEnabled(true);
        NetDemo.comboBoxFontStyleAlign.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign2.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign3.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign4.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign5.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign6.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign7.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign8.setSelectedIndex(0);
        NetDemo.jComboBoxFontStyleAlign2.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign3.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign4.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign5.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign6.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign7.setEnabled(true);
        NetDemo.jComboBoxFontStyleAlign8.setEnabled(true);
        NetDemo.jButtonStartRecord.setEnabled(true);
        NetDemo.jButtonStopRecord.setEnabled(false); 
        NetDemo.chckbxConfigTamperChannelEnable.setSelected(false);
        NetDemo.textFieldConfigTemperChannelSensitivity.setText(null);
        NetDemo.textFieldConfigTemperChannelDuration.setText(null);
        NetDemo.jTextFieldCountPageSize.setText(null);
        NetDemo.jButtonACSRecordsPre.setEnabled(false);
        NetDemo.jButtonACSRecordsNext.setEnabled(false);
        NetDemo.jButtonACSRecordsGo.setEnabled(false);
        NetDemo.jButtonVisitorRecordGo.setEnabled(false);
        NetDemo.jButtonVisitorRecordNext.setEnabled(false);
        NetDemo.jButtonVisitorRecordPre.setEnabled(false);
        NetDemo.jTextFieldContrast.setText(null);
        NetDemo.jTextFieldBrightness.setText(null);
        NetDemo.jTextFieldGetSDKVersion.setText(null);
        NetDemo.jTextFieldHue.setText(null);
        NetDemo.jTextFieldSaturation.setText(null);
        NetDemo.jTextFieldGamma.setText(null);
        NetDemo.jTextFieldPlayBackDigitalZoomLeft.setText(null);
        NetDemo.jTextFieldPlayBackDigitalZoomRight.setText(null);
        NetDemo.jTextFieldPlayBackDigitalZoomTop.setText(null);
        NetDemo.jTextFieldPlayBackDigitalZoomBottom.setText(null);
        NetDemo.jComboBoxPlayRecordMonth.setSelectedIndex(0);
        NetDemo.jButtonStopLive.setEnabled(false);
        NetDemo.jButtonStartLive.setEnabled(true);
        NetDemo.jButtonStartDecodeData.setEnabled(true);
        NetDemo.jButtonStopDecodeData.setEnabled(false);
        NetDemo.jButtonStartSourceData.setEnabled(true);
        NetDemo.jButtonStopSourceData.setEnabled(false);
        NetDemo.jButtonStopLocalFile.setEnabled(false);
        NetDemo.jButtonPlayLocalFile.setEnabled(true);
        NetDemo.jTextFieldPlayLocalFile.setText(null);
        NetDemo.RecordTableModel.setRowCount(0);
        NetDemo.ConfigBasicInformationTableModel.setRowCount(0);
        NetDemo.UserListTableModel.setRowCount(0);
        NetDemo.textFieldConfigImageInfoBrightness.setText(null);
        NetDemo.textFieldConfigImageInfoSaturation.setText(null);
        NetDemo.textFieldImageInfo2DNoiseReduce.setText(null);
        NetDemo.textFieldConfigImageInfoContrast.setText(null);
        NetDemo.textFieldConfigImageInfoSharpness.setText(null);
        NetDemo.ConfigPrivacyMaskTableModel.setRowCount(0);
        NetDemo.SmartServertableModel.setRowCount(0);
        NetDemo.DownloadProgress.setValue(0);
        NetDemo.jLabelLiveSound.setText(null);
        NetDemo.ConfigBasicHardDiskTableModel.setRowCount(0);
        NetDemo.chckbxEnableGetPicture.setSelected(false);
        NetDemo.jTextFieldModifyUserUserName.setText(null);
        NetDemo.jTextFieldModifyUserOldPassword.setText(null);
        NetDemo.jTextFieldlblModifyUserNewPasswd.setText(null);
        NetDemo.jTextFieldPTZExtendRoutePatrolsName.setText(null);
        NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText(null);
        NetDemo.jTextFieldExtendPTZStayTime.setText(null);
        NetDemo.jTextFieldPTZExtendPresetPatrolsSpeed.setText(null);
        NetDemo.jComboBoxAlarmOutPutIndex.removeAllItems();
        NetDemo.jRadioButtonOpenSVC.setSelected(true);
        NetDemo.jRadioButtonCloseSVC.setSelected(false);
        NetDemo.textFieldSetBasicSystemTime.setText(null);
        NetDemo.jComboBoxExtendPTZPresetID.removeAllItems();
        NetDemo.textFieldBasicTime.setText(null);
        NetDemo.jComboBoxSmoothLevel.setSelectedIndex(0);
        NetDemo.jComboBoxSmoothLevel.setEnabled(true);
        NetDemo.jRadioButtonOpenSVC.setEnabled(true);
        NetDemo.jRadioButtonCloseSVC.setEnabled(true);
        NetDemo.jComboBoxUcode.setSelectedIndex(0);
        NetDemo.jTextFieldGetVisitorACSRecord.setText(null);
        NetDemo.textFieldSnapshotWidth.setText(null);
        NetDemo.textFieldSnapshotHeight.setText(null);
        NetDemo.textFieldPictureMaxSize.setText(null);
        NetDemo.textFieldSnapshotInterval.setText(null);
        NetDemo.textFieldSnapshotNum.setText(null);
        NetDemo.PersonTableModel.setRowCount(0);
        NetDemo.PersonMonitorTableModel.setRowCount(0);
        NetDemo.textFieldImageInfo2DNoiseReduce.setEnabled(false);
        NetDemo.textFieldImageInfo3DNoiseReduce.setEnabled(false);
        NetDemo.textRedOffSet.setText(null);
        NetDemo.textBlueOffSet.setText(null);
        NetDemo.BlueoffSetslider.setValue(0);
        NetDemo.RedoffSetslider.setValue(0);
        NetDemo.jTextFieldACSRecord.setText(null);
        NetDemo.tablePTZExtendPresetPatrolsModel.setRowCount(0);
        NetDemo.jComboBoxExposureWDR.setSelectedIndex(0);
        NetDemo.jComboBoxExposureMode.setSelectedIndex(0);
        NetDemo.jComboBoxDayNightMode.setSelectedIndex(0);
        NetDemo.jComboBoxMainStreamType.setSelectedIndex(0);
        NetDemo.chckbxEnableSummerTime.setSelected(false);
        NetDemo.comboBoxDstBeginMonth.setSelectedIndex(0);
        NetDemo.comboBoxBeginTimeWeekNum.setSelectedIndex(0);
        NetDemo.comboBoxDSTBeginTimeWeek.setSelectedIndex(0);
        NetDemo.comboBoxDSTBeginTimeHour.setSelectedIndex(0);
        NetDemo.comboBoxDSTENDMonth.setSelectedIndex(0);
        NetDemo.comboBoxDSTEndTimeWeekNum.setSelectedIndex(0);
        NetDemo.comboBoxDSTEndTimeWeek.setSelectedIndex(0);
        NetDemo.comboBoxDSTEndTimeHour.setSelectedIndex(0);
        NetDemo.comboBoxDSTBias.setSelectedIndex(0);
        NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setEnabled(false);
        NetDemo.textFieldlblConfigIOAlarmOutputName.setText(null);
        NetDemo.textFieldConfigIOAlarmOutputChannelID.setText(null);
        NetDemo.textFieldlblConfigIOAlarmOutputDelay.setText(null);
        NetDemo.ConfigIOAlarmInputTableModel.setRowCount(0);
        NetDemo.textFieldConfigEquipmentMotionHistory.setText(null);
        NetDemo.ACSTableModel = new DefaultTableModel(NetDemo.RecordHeaderNames,0);
        NetDemo.jTableACS.setModel(NetDemo.ACSTableModel);
        NetDemo.VisitorACSTableModel = new DefaultTableModel(NetDemo.HeaderNames,0);
        NetDemo.jTableVisitorACS.setModel(NetDemo.VisitorACSTableModel);
        NetDemo.jCheckBoxIsEnableSlowSh.setSelected(false);
        NetDemo.textFieldConfigImageExposureCompensation.setText(null);
        NetDemo.textFieldConfigImageExposureMinGain.setText(null);
        NetDemo.textFieldConfigImageExposureGain.setText(null);
        NetDemo.jTextFieldConfigImageExposureDayNightSwitch.setText(null);
        NetDemo.textFieldConfigImageExposureMaxGain.setText(null);
        NetDemo.jTextFieldConfigImageExposureSlowestShutter.setText(null);
        NetDemo.jTextFieldFieldConfigImageExposureWDRLevel.setText(null);
        NetDemo.jTextFieldConfigImageExposureSlowestShutter.setEnabled(false);
        NetDemo.jTextFieldConfigImageExposureDayNightSence.setText(null);
        NetDemo.jComboBoxExposureMode.setSelectedIndex(0);
        NetDemo.textFieldConfigIOAlarmOutputChannelNo.setText(null);
        NetDemo.textFieldConfigIOAlarmOutputChannelDelay.setText(null);
        NetDemo.comboBoxlblConfigIOAlarmOutputStatus.setSelectedIndex(0);
        NetDemo.jComboBoxDefaultStatus.setSelectedIndex(0);
        NetDemo.jComboBoxShutter.setSelectedIndex(0);
        NetDemo.jComboBoxMinShutter.setSelectedIndex(0);
        NetDemo.jComboBoxMaxShutter.setSelectedIndex(0);
        NetDemo.jComboBoxShutter.setEnabled(false);
        NetDemo.jComboBoxMinShutter.setEnabled(false);
        NetDemo.jComboBoxMaxShutter.setEnabled(false);
        NetDemo.textFieldConfigNetWorkNTPServerIP.setText(null);
        NetDemo.textFieldConfigNetWorkNTPPort.setText(null);
        NetDemo.textFieldConfigNetWorkNTPSynchronizeInterval.setText(null);
        NetDemo.textFieldConfigNetWorkNTPDomainName.setText(null);
        NetDemo.textFieldConfigNetWorkIPAddr.setText(null);
        NetDemo.textFieldConfigNetWorkSubMask.setText(null);
        NetDemo.textFieldConfigNetWorkGateway.setText(null);
        NetDemo.textFieldConfigNetWorkMTU.setText(null);
        NetDemo.jTextFieldNetworkPortHTTP.setText(null);
        NetDemo.jTextFieldNetworkPortHTTPS.setText(null);
        NetDemo.jTextFieldNetworkPortRTSP.setText(null);
        NetDemo.textFieldConfigOSDTimeX.setText(null);
        NetDemo.textFieldConfigOSDTimeY.setText(null);
        NetDemo.textFieldConfigOSDName.setText(null);
        NetDemo.textFieldConfigOSDNameX.setText(null);
        NetDemo.textFieldConfigOSDNameY.setText(null);
        NetDemo.textFieldConfigOSDText1.setText(null);
        NetDemo.textFieldConfigOSDText1X.setText(null);
        NetDemo.textFieldConfigOSDText1Y.setText(null);
        NetDemo.textFieldConfigOSDText2.setText(null);
        NetDemo.textFieldConfigOSDText2X.setText(null);
        NetDemo.textFieldConfigOSDText2Y.setText(null);
        NetDemo.textFieldConfigOSDText3.setText(null);
        NetDemo.textFieldConfigOSDText3X.setText(null);
        NetDemo.textFieldConfigOSDText3Y.setText(null);
        NetDemo.textFieldConfigOSDText4.setText(null);
        NetDemo.textFieldConfigOSDText4X.setText(null);
        NetDemo.textFieldConfigOSDText4Y.setText(null);
        NetDemo.textFieldConfigOSDText5.setText(null);
        NetDemo.textFieldConfigOSDText5X.setText(null);
        NetDemo.textFieldConfigOSDText5Y.setText(null);
        NetDemo.textFieldConfigOSDText6.setText(null);
        NetDemo.textFieldConfigOSDText6X.setText(null);
        NetDemo.textFieldConfigOSDText6Y.setText(null);
        NetDemo.jSliderLiveMicSound.setEnabled(false);
        NetDemo.jButtonStartTalk.setEnabled(true);
        NetDemo.jButtonStopTalk.setEnabled(false);
        NetDemo.jComboBoxPersonLib.removeAllItems();
        NetDemo.jComboBoxVehicleLib.removeAllItems();
    }
}
