package main.java.com.netdevsdk.demo.maintenance;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.*;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.DateChooser;
import main.java.com.netdevsdk.demo.util.Util;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_COND_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_SUBTYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_ALARM_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_ALARM_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_LOG_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_MAIN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_SUB_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_LOGICTYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_INFO_S;

import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import java.awt.Color;


public class MaintenaceAlarmLogWindow extends JDialog{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTable AlarmTable;
	private Pointer lpUserId;
	private int ChannelID;
	JPanel MaintanceAlarmLogPanel = new JPanel();
	
	int nowPage = 1;
	int dwPageRow = 30;
	int totalPage;
	JLabel pagelabel = new JLabel();
	JLabel startTimeLabel = new JLabel("startTime");
	JLabel endTimeLabel = new JLabel("endTime");
	JLabel nowPageLabel = new JLabel();
	JTextField startTimeField;
	JTextField endTimeField;
	JButton NextButton= new JButton("next");
	JButton BackButton= new JButton("back");
	Vector Alarm_HeaderNames;
	JButton Alarm_Search = new JButton("search");
	
	
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	private JTextField textFieldAlarmSource;
	private JTextField textFieldToTalNum;
	
	
	
	
	
	
	public MaintenaceAlarmLogWindow(Pointer lpUserID,int ChannelID) {
		this.lpUserId = lpUserID;
		this.ChannelID = ChannelID;
		this.setSize(1400,800);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Search alarm log");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(MaintanceAlarmLogPanel, BorderLayout.CENTER);
		MaintanceAlarmLogPanel.setLayout(null);
		MaintanceAlarmLogPanel.setVisible(true);
		startTimeLabel.setBounds(590, 48, 65, 35);
		MaintanceAlarmLogPanel.add(startTimeLabel);
		
		textFieldAlarmSource = new JTextField();
		textFieldAlarmSource.setBounds(130, 39, 134, 21);
		MaintanceAlarmLogPanel.add(textFieldAlarmSource);
		textFieldAlarmSource.setColumns(10);
		
		endTimeLabel.setBounds(923, 48, 65, 35);
		MaintanceAlarmLogPanel.add(endTimeLabel);

		String DateFormat = "yyyy-MM-dd HH:mm:ss";

		JPanel j7 = new JPanel();
		MaintanceAlarmLogPanel.add(j7);
		j7.setBounds(680, 53, 196, 30);
		DateChooser BeginAlarmLogdateLog = new DateChooser(j7);
		j7.add(BeginAlarmLogdateLog);
		
		JPanel j8 = new JPanel();
		MaintanceAlarmLogPanel.add(j8);
		j8.setBounds(993, 48, 196, 30);
		DateChooser EndAlarmLogdateLog = new DateChooser(j8);
		j8.add(EndAlarmLogdateLog);

		
		

		JLabel TimeBorderPanel = new JLabel();
		TimeBorderPanel.setBorder(new TitledBorder(null, "", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		TimeBorderPanel.setBounds(580, 35, 656, 55);
		MaintanceAlarmLogPanel.add(TimeBorderPanel);

		BackButton.setBounds(80, 680, 65, 35);
		MaintanceAlarmLogPanel.add(BackButton);
		pagelabel.setBounds(150, 680, 30, 35);
		MaintanceAlarmLogPanel.add(pagelabel);
		NextButton.setBounds(185, 680, 65, 35);
		MaintanceAlarmLogPanel.add(NextButton);

		nowPageLabel.setBounds(260, 680, 90, 35);
		MaintanceAlarmLogPanel.add(nowPageLabel);
		nowPageLabel.setEnabled(false);

		pagelabel.setText(String.valueOf(nowPage));
		pagelabel.setHorizontalAlignment(JTextField.CENTER);
		
		pagelabel.setEnabled(false);
		
		
		
		JLabel lblAlarmSource = new JLabel("Alarm Source");
		lblAlarmSource.setBounds(40, 42, 88, 15);
		MaintanceAlarmLogPanel.add(lblAlarmSource);
		
		JLabel lblVMSLogAlarmLevel = new JLabel("Alarm Level");
		lblVMSLogAlarmLevel.setBounds(40, 69, 84, 21);
		MaintanceAlarmLogPanel.add(lblVMSLogAlarmLevel);
		
		JCheckBox chckbxAlarmLogLevelOne = new JCheckBox("Level 1");
		chckbxAlarmLogLevelOne.setForeground(Color.BLACK);
		chckbxAlarmLogLevelOne.setBounds(177, 68, 73, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelOne);
		
		JCheckBox chckbxAlarmLogLevelTwo = new JCheckBox("Level 2");
		chckbxAlarmLogLevelTwo.setForeground(Color.BLACK);
		chckbxAlarmLogLevelTwo.setBounds(260, 68, 73, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelTwo);
		
		JCheckBox chckbxAlarmLogLevelThree = new JCheckBox("Level 3");
		chckbxAlarmLogLevelThree.setBounds(338, 68, 73, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelThree);
		
		JCheckBox chckbxAlarmLogLevelFour = new JCheckBox("Level 4");
		chckbxAlarmLogLevelFour.setBounds(420, 68, 73, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelFour);
		
		JCheckBox chckbxAlarmLogLevelAll = new JCheckBox("All");
		chckbxAlarmLogLevelAll.setBounds(130, 68, 43, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelAll);
		
		JCheckBox chckbxAlarmLogLevelFive = new JCheckBox("Level 5");
		chckbxAlarmLogLevelFive.setBounds(501, 68, 73, 23);
		MaintanceAlarmLogPanel.add(chckbxAlarmLogLevelFive);
		
		textFieldToTalNum = new JTextField();
		textFieldToTalNum.setBounds(424, 687, 54, 21);
		MaintanceAlarmLogPanel.add(textFieldToTalNum);
		textFieldToTalNum.setColumns(10);
		textFieldToTalNum.setEnabled(false);
		
		chckbxAlarmLogLevelOne.setSelected(false);
		chckbxAlarmLogLevelTwo.setSelected(false);
		chckbxAlarmLogLevelThree.setSelected(false);
		chckbxAlarmLogLevelFour.setSelected(false);
		chckbxAlarmLogLevelFive.setSelected(false);
		
		
		chckbxAlarmLogLevelAll.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelAll.isSelected()) {
					chckbxAlarmLogLevelOne.setSelected(true);
					chckbxAlarmLogLevelTwo.setSelected(true);
					chckbxAlarmLogLevelThree.setSelected(true);
					chckbxAlarmLogLevelFour.setSelected(true);
					chckbxAlarmLogLevelFive.setSelected(true);
				}else {
					chckbxAlarmLogLevelOne.setSelected(false);
					chckbxAlarmLogLevelTwo.setSelected(false);
					chckbxAlarmLogLevelThree.setSelected(false);
					chckbxAlarmLogLevelFour.setSelected(false);
					chckbxAlarmLogLevelFive.setSelected(false);
				}
			}
		});
		
		
		chckbxAlarmLogLevelOne.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelOne.isSelected()==false) {
					chckbxAlarmLogLevelAll.setSelected(false);
				}
			}
		});
		
		chckbxAlarmLogLevelTwo.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelTwo.isSelected()==false) {
					chckbxAlarmLogLevelAll.setSelected(false);
				}
			}
		});
		chckbxAlarmLogLevelThree.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelThree.isSelected()==false) {
					chckbxAlarmLogLevelAll.setSelected(false);
				}
			}
		});
		chckbxAlarmLogLevelFour.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelFour.isSelected()==false) {
					chckbxAlarmLogLevelAll.setSelected(false);
				}
			}
		});
		chckbxAlarmLogLevelFive.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(chckbxAlarmLogLevelFive.isSelected()==false) {
					chckbxAlarmLogLevelAll.setSelected(false);
				}
			}
		});
		
		


		//判断登陆设备类型为IPC/NVR

		AlarmTable = new JTable();
		JScrollPane scrollPaneMaintenanceIPC = new JScrollPane(AlarmTable,
		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPaneMaintenanceIPC.setBounds(46, 100, 1334, 503);
		MaintanceAlarmLogPanel.add(scrollPaneMaintenanceIPC, BorderLayout.CENTER);
		Alarm_HeaderNames = new Vector();
		Alarm_HeaderNames.add("AlarmType");
		Alarm_HeaderNames.add("AlarmSubType");
		Alarm_HeaderNames.add("AlarmLevel");
		Alarm_HeaderNames.add("ChannelID");
		Alarm_HeaderNames.add("AlarmTime");
		Alarm_HeaderNames.add("AlarmSource");
		
		TableModel tableModel = new DefaultTableModel(Alarm_HeaderNames,0);
		AlarmTable.setModel(tableModel);
	
		BackButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(null == lpUserID){
					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
					return;
				}

				if(nowPage > 1){
					nowPage--;
				}else{
					JOptionPane.showMessageDialog(null, "Now page is firstPage");
					return;
				}

				String alarmSource=textFieldAlarmSource.getText();
				
				String BeginTime =BeginAlarmLogdateLog.jTextFieldDate.getText();
				String EndTime = EndAlarmLogdateLog.jTextFieldDate.getText();
				
				if(BeginTime == null || "".equals(BeginTime)){
					JOptionPane.showMessageDialog(null, "Please input startTime.");
				}
				if(EndTime == null || "".equals(EndTime)){
					JOptionPane.showMessageDialog(null, "Please input endTime.");
				}
				
				long getBeginTime=Common.date2TimeStamp(BeginTime,DateFormat);
				long getEndTime=Common.date2TimeStamp(EndTime,DateFormat);
				
				if(getEndTime<getBeginTime) {
					JOptionPane.showMessageDialog(null, "End Time can not less than start time");
				}
					
				NETDEV_ALARM_LOG_COND_LIST_S pstFindCond = new NETDEV_ALARM_LOG_COND_LIST_S();
				pstFindCond.dwPageRow = dwPageRow;
				pstFindCond.dwFirstRow = (nowPage-1)*dwPageRow;
				
				if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(alarmSource.equals("")||alarmSource==null)) {
					pstFindCond.dwCondSize = 5;
					
					StringBuffer level=new StringBuffer();
					
					
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);

					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[4].szConditionData);
					
				}else if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
					pstFindCond.dwCondSize = 6;
					
					StringBuffer level=new StringBuffer();
						
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);
					
					
					
					
					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[5].szConditionData);		
				}
				else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
						pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					
					
				}else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&((alarmSource.equals(""))||(alarmSource==null))){
					pstFindCond.dwCondSize = 4;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[4].szConditionData);
					
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(!
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 6;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[5].szConditionData);
					
					
				}
				
				IntByReference pdwTotalRealRow = new IntByReference();
				pstFindCond.write();
				Pointer logPointer = netdevsdk.NETDEV_FindAlarmLogList(lpUserID,pstFindCond,pdwTotalRealRow);
				if(logPointer == null){
					System.out.printf("NETDEV_FindAlarmLogList failed:%d\n", netdevsdk.NETDEV_GetLastError());
					if(netdevsdk.NETDEV_GetLastError() == 11){
						JOptionPane.showMessageDialog(null, "no results were found");
					}
					return;
				}

				NETDEV_ALARM_LOG_INFO_S pstAlarmLogInfo = new NETDEV_ALARM_LOG_INFO_S();
				pstAlarmLogInfo.write();
				boolean flag = true;
				int i = 0;
				Vector data = new Vector();
				do {
					flag = netdevsdk.NETDEV_FindNextAlarmLog(logPointer,pstAlarmLogInfo);
					if(flag == false){
						System.out.printf("NETDEV_FindNextAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
						break;
					}
					pstAlarmLogInfo.read();
					Vector vtData = new Vector();
					String message=Util.getAlarmType(pstAlarmLogInfo.dwAlarmType);
					vtData.add(message);
					String subType=Util.getSubType(pstAlarmLogInfo.dwAlarmSubType);
    				vtData.add(subType);
					vtData.add(pstAlarmLogInfo.dwAlarmLevel+1);
					vtData.add(pstAlarmLogInfo.dwChannelID);
					
					Long getTime=pstAlarmLogInfo.tAlarmTime;
					String new1=String.valueOf(getTime);
					String getNewDateTime=Common.timeStamp2Date(new1, DateFormat);
					vtData.add(getNewDateTime);
					vtData.add(Common.byteArrayToString(pstAlarmLogInfo.szAlarmSrc));
					data.add(vtData);
					i++;
				} while (flag && i < 30);

				flag = netdevsdk.NETDEV_FindCloseAlarmLog(logPointer);
				if(flag == false){
					System.out.printf("NETDEV_FindCloseAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
					return;
				}

				DefaultTableModel defaultTableModel = (DefaultTableModel) AlarmTable.getModel();
				defaultTableModel.setRowCount(0);
				AlarmTable.setModel(defaultTableModel);

				TableModel tableModel = new DefaultTableModel(data,Alarm_HeaderNames);
				AlarmTable.setModel(tableModel);
				textFieldToTalNum.setText(String .valueOf(pdwTotalRealRow.getValue()));
				pagelabel.setText(String.valueOf(nowPage));
			}
		});


		NextButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				if(null == lpUserID){
					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
					return;
				}

				String alarmSource=textFieldAlarmSource.getText();
				
				String BeginTime =BeginAlarmLogdateLog.jTextFieldDate.getText();
				String EndTime = EndAlarmLogdateLog.jTextFieldDate.getText();
				
				if(BeginTime == null || "".equals(BeginTime)){
					JOptionPane.showMessageDialog(null, "Please input startTime.");
				}
				if(EndTime == null || "".equals(EndTime)){
					JOptionPane.showMessageDialog(null, "Please input endTime.");
				}
				
				long getBeginTime=Common.date2TimeStamp(BeginTime,DateFormat);
				long getEndTime=Common.date2TimeStamp(EndTime,DateFormat);
				
				if(getEndTime<getBeginTime) {
					JOptionPane.showMessageDialog(null, "End Time can not less than start time");
				}

				NETDEV_ALARM_LOG_COND_LIST_S pstFindCond = new NETDEV_ALARM_LOG_COND_LIST_S();
				pstFindCond.dwPageRow = dwPageRow;
				pstFindCond.dwFirstRow = nowPage*30;
				if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(alarmSource.equals("")||alarmSource==null)) {
					pstFindCond.dwCondSize = 5;
					
					StringBuffer level=new StringBuffer();
					
					
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					
					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[4].szConditionData);
					
					
					
				}else if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
					pstFindCond.dwCondSize = 6;
					
					StringBuffer level=new StringBuffer();
					
					
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);
					
					
					
					
					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[5].szConditionData);		
				}
				else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
						pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					
					
				}else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&((alarmSource.equals(""))||(alarmSource==null))){
					pstFindCond.dwCondSize = 4;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[4].szConditionData);
					
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(!
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 6;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[5].szConditionData);
					
					
				}
				

				IntByReference pdwTotalRealRow = new IntByReference();
				pstFindCond.write();
				Pointer logPointer = netdevsdk.NETDEV_FindAlarmLogList(lpUserID,pstFindCond,pdwTotalRealRow);
				if(logPointer == null){
					System.out.printf("NETDEV_FindAlarmLogList failed:%d\n", netdevsdk.NETDEV_GetLastError());
					if(netdevsdk.NETDEV_GetLastError() == 11){
						JOptionPane.showMessageDialog(null, "No results were found");
					}
					return;
				}
				NETDEV_ALARM_LOG_INFO_S pstAlarmLogInfo = new NETDEV_ALARM_LOG_INFO_S();
				pstAlarmLogInfo.write();

				nowPage++;
				boolean flag = true;
				int i = 0;
				Vector data = new Vector();
				do {
					flag = netdevsdk.NETDEV_FindNextAlarmLog(logPointer,pstAlarmLogInfo);
					if(flag == false){
						System.out.printf("NETDEV_FindNextAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
						break;
					}
					pstAlarmLogInfo.read();
					Vector vtData = new Vector();
					String message=Util.getAlarmType(pstAlarmLogInfo.dwAlarmType);
					vtData.add(message);
					String subType=Util.getSubType(pstAlarmLogInfo.dwAlarmSubType);
    				vtData.add(subType);
					vtData.add(pstAlarmLogInfo.dwAlarmLevel+1);
					vtData.add(pstAlarmLogInfo.dwChannelID);
					Long getTime=pstAlarmLogInfo.tAlarmTime;
					String new1=String.valueOf(getTime);
					String getNewDateTime=Common.timeStamp2Date(new1, DateFormat);
					vtData.add(getNewDateTime);
					vtData.add(Common.byteArrayToString(pstAlarmLogInfo.szAlarmSrc));
					data.add(vtData);
					i++;
				} while (flag && i < 30);

				flag = netdevsdk.NETDEV_FindCloseAlarmLog(logPointer);
				if(flag == false){
					System.out.printf("NETDEV_FindCloseAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
					return;
				}

				DefaultTableModel defaultTableModel = (DefaultTableModel) AlarmTable.getModel();
				defaultTableModel.setRowCount(0);
				AlarmTable.setModel(defaultTableModel);

				TableModel tableModel = new DefaultTableModel(data,Alarm_HeaderNames);
				AlarmTable.setModel(tableModel);
				textFieldToTalNum.setText(String .valueOf(pdwTotalRealRow.getValue()));
				pagelabel.setText(String.valueOf(nowPage));
			}
		});


		Alarm_Search.setBounds(1253, 45, 80, 35);
		Alarm_Search.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				if(null == lpUserID){
					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
					return;
				}
				textFieldToTalNum.setText(null);
				DefaultTableModel defaultTableModel = (DefaultTableModel) AlarmTable.getModel();
				defaultTableModel.setRowCount(0);
				AlarmTable.setModel(defaultTableModel);
				nowPageLabel.setText(null);
				nowPage=1;
				
				String alarmSource=textFieldAlarmSource.getText();

				String BeginTime =BeginAlarmLogdateLog.jTextFieldDate.getText();
				String EndTime = EndAlarmLogdateLog.jTextFieldDate.getText();
				
				if(BeginTime == null || "".equals(BeginTime)){
					JOptionPane.showMessageDialog(null, "Please input startTime.");
				}
				if(EndTime == null || "".equals(EndTime)){
					JOptionPane.showMessageDialog(null, "Please input endTime.");
				}
				
				
				long getBeginTime=Common.date2TimeStamp(BeginTime,DateFormat);
				long getEndTime=Common.date2TimeStamp(EndTime,DateFormat);
				
				if(getEndTime<getBeginTime) {
					JOptionPane.showMessageDialog(null, "End Time can not less than start time");
				}

				NETDEV_ALARM_LOG_COND_LIST_S pstFindCond = new NETDEV_ALARM_LOG_COND_LIST_S();
				pstFindCond.dwPageRow = dwPageRow;
				pstFindCond.dwFirstRow = 0;
				if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(alarmSource.equals("")||alarmSource==null)) {
					pstFindCond.dwCondSize = 5;
					
					StringBuffer level=new StringBuffer();
					
					
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					
					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[4].szConditionData);
					
					
				}else if((chckbxAlarmLogLevelOne.isSelected()||chckbxAlarmLogLevelTwo.isSelected()||
						chckbxAlarmLogLevelThree.isSelected()||chckbxAlarmLogLevelFour.isSelected()||chckbxAlarmLogLevelFive.isSelected())&&!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
								chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
					pstFindCond.dwCondSize = 6;
					
					StringBuffer level=new StringBuffer();
					
					
					if(chckbxAlarmLogLevelOne.isSelected()) {
						level.append(0);
					}
					
					if(chckbxAlarmLogLevelTwo.isSelected()) {
						level.append(1);
					}
					
					if(chckbxAlarmLogLevelThree.isSelected()) {
						level.append(2);
					}
					
					if(chckbxAlarmLogLevelFour.isSelected()) {
						level.append(3);
					}
					
					if(chckbxAlarmLogLevelFive.isSelected()) {
						level.append(4);
					}
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);
					
					
					
					
					StringBuffer sb = new StringBuffer(level.toString());
					for(int i =sb.length()-1;i>=1;i-- ){
						sb.insert(i, ",");
					}
					String getLevel=sb.toString();
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray(getLevel, pstFindCond.astCondition[5].szConditionData);		
				}

				else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&(!((alarmSource.equals(""))||(alarmSource==null)))) {
						pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					
					
				}else if((chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected())
						&&((alarmSource.equals(""))||(alarmSource==null))){
					pstFindCond.dwCondSize = 4;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 5;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[4].szConditionData);
					
					
				}else if((!(chckbxAlarmLogLevelOne.isSelected()&&chckbxAlarmLogLevelTwo.isSelected()&&
						chckbxAlarmLogLevelThree.isSelected()&&chckbxAlarmLogLevelFour.isSelected()&&chckbxAlarmLogLevelFive.isSelected()))&&(!
								(alarmSource.equals(""))||(alarmSource==null)
								)) {
					pstFindCond.dwCondSize = 6;
					
					pstFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(BeginTime, DateFormat)), pstFindCond.astCondition[0].szConditionData);
					
					pstFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[1].szConditionData);
					
					
					pstFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_RANGE;
					pstFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
					Common.stringToByteArray("0", pstFindCond.astCondition[2].szConditionData);
					
					pstFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
					pstFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
					Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(EndTime, DateFormat)), pstFindCond.astCondition[3].szConditionData);
					
					
					pstFindCond.astCondition[4] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[4].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMSRCNAME;
					pstFindCond.astCondition[4].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DIM_QUERY;
					Common.stringToByteArray(alarmSource, pstFindCond.astCondition[4].szConditionData);	
					
					pstFindCond.astCondition[5] = new NETDEV_QUERY_INFO_S();
					pstFindCond.astCondition[5].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMLEVEL;
					pstFindCond.astCondition[5].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_CONTAIN;
					Common.stringToByteArray("", pstFindCond.astCondition[5].szConditionData);		
				}
				IntByReference pdwTotalRealRow = new IntByReference();
				pstFindCond.write();
				
				Pointer logPointer = netdevsdk.NETDEV_FindAlarmLogList(lpUserID,pstFindCond,pdwTotalRealRow);
				if(logPointer == null){
					System.out.printf("NETDEV_FindAlarmLogList failed:%d\n", netdevsdk.NETDEV_GetLastError());
					if(netdevsdk.NETDEV_GetLastError() == 11){
						JOptionPane.showMessageDialog(null, "no results were found");
					}
					return;
				}
				
				System.out.println(pdwTotalRealRow.getValue()/30);
				
				if(pdwTotalRealRow.getValue()%30 == 0){
					totalPage = pdwTotalRealRow.getValue()/30;
				}else{
					totalPage = pdwTotalRealRow.getValue()/30+1;
				}
				
				nowPageLabel.setText("当前共"+totalPage+"页");
				NETDEV_ALARM_LOG_INFO_S pstAlarmLogInfo = new NETDEV_ALARM_LOG_INFO_S();
				pstAlarmLogInfo.write();
				boolean flag = true;
				int i = 0;
				Vector data = new Vector();
				do {
					flag = netdevsdk.NETDEV_FindNextAlarmLog(logPointer,pstAlarmLogInfo);
    				if(flag == false){
    					System.out.printf("NETDEV_FindNextAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
						break;
    				}
    				pstAlarmLogInfo.read();
    				Vector vtData = new Vector();
    				String message=Util.getAlarmType(pstAlarmLogInfo.dwAlarmType);
					vtData.add(message);
					String subType=Util.getSubType(pstAlarmLogInfo.dwAlarmSubType);
    				vtData.add(subType);
    				vtData.add(pstAlarmLogInfo.dwAlarmLevel+1);
    				vtData.add(pstAlarmLogInfo.dwChannelID);
    				Long getTime=pstAlarmLogInfo.tAlarmTime;
					String new1=String.valueOf(getTime);
					String getNewDateTime=Common.timeStamp2Date(new1, DateFormat);
					vtData.add(getNewDateTime);
					vtData.add(Common.byteArrayToString(pstAlarmLogInfo.szAlarmSrc));
    				data.add(vtData);
    				i++;
				} while (flag && i < 30);
				
				flag = netdevsdk.NETDEV_FindCloseAlarmLog(logPointer);
				if(flag == false){
					System.out.printf("NETDEV_FindCloseAlarmLog failed:%d\n", netdevsdk.NETDEV_GetLastError());
					return;
				}
				TableModel tableModel = new DefaultTableModel(data,Alarm_HeaderNames);
	    		AlarmTable.setModel(tableModel);
	    		textFieldToTalNum.setText(String .valueOf(pdwTotalRealRow.getValue()));
				pagelabel.setText("1");
			}
		});
		MaintanceAlarmLogPanel.add(Alarm_Search);
		
		JLabel lblTotal = new JLabel("Total：");
		lblTotal.setBounds(364, 690, 54, 15);
		MaintanceAlarmLogPanel.add(lblTotal);
    }
}
