package main.java.com.netdevsdk.demo.maintenance;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.*;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.DateChooser;
import main.java.com.netdevsdk.demo.util.Util;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FIND_LOG_COND_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_MAIN_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LOG_SUB_TYPE_E;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class MaintenaceLogWindow extends JDialog{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTable IPC_NVR_Table;
	private JTable VMSTable;
	private Pointer lpUserId;
	private int ChannelID;
	JPanel MaintanceFindLogPanel = new JPanel();
	JTextField startTimeField;
	JTextField endTimeField;
	int nowPage = 1;
	JTextField pagelabel = new JTextField();
	JLabel startTimeLabel = new JLabel("startTime");
	JLabel endTimeLabel = new JLabel("endTime");
	JButton NextButton= new JButton("next");
	JButton BackButton= new JButton("back");
	//IPC/NVR
	JButton IPC_NVR_Search = new JButton("search");
	Vector IPC_NVR_HeaderNames;
	//VMS
	JButton VMS_Search = new JButton("search");
	Vector VMS_HeaderNames;
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;

	public MaintenaceLogWindow(int deviceType,Pointer lpUserID,int ChannelID) {
		
		this.lpUserId = lpUserID;
		this.ChannelID = ChannelID;
		this.setSize(1500,800);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Find Log");
		this.setVisible(true);
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
        getContentPane().add(MaintanceFindLogPanel, BorderLayout.CENTER);
		MaintanceFindLogPanel.setLayout(null);
		MaintanceFindLogPanel.setVisible(true);
		startTimeLabel.setBounds(52, 31, 65, 35);
		MaintanceFindLogPanel.add(startTimeLabel);
		endTimeLabel.setBounds(318, 31, 58, 35);
		MaintanceFindLogPanel.add(endTimeLabel);

		String DateFormat = "yyyy-MM-dd HH:mm:ss";

		
		

		JLabel TimeBorderPanel = new JLabel();
		TimeBorderPanel.setBorder(new TitledBorder(null, "", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		TimeBorderPanel.setBounds(44, 21, 597, 55);
		MaintanceFindLogPanel.add(TimeBorderPanel);

		BackButton.setBounds(80, 680, 65, 35);
		MaintanceFindLogPanel.add(BackButton);
		pagelabel.setBounds(150, 680, 30, 35);
		MaintanceFindLogPanel.add(pagelabel);
		NextButton.setBounds(185, 680, 65, 35);
		MaintanceFindLogPanel.add(NextButton);

		pagelabel.setText(String.valueOf(nowPage));
		pagelabel.setHorizontalAlignment(JTextField.CENTER);
		pagelabel.setEnabled(false);
		
		JPanel j3 = new JPanel();
		MaintanceFindLogPanel.add(j3);
		j3.setBounds(113, 31, 196, 30);
		DateChooser BegindateLog = new DateChooser(j3);
		j3.add(BegindateLog);
		
		JPanel j4 = new JPanel();
		MaintanceFindLogPanel.add(j4);
		j4.setBounds(367, 31, 196, 30);
		DateChooser EnddateLog = new DateChooser(j4);
		j4.add(EnddateLog);

        if(deviceType == 0){
        	//判断登陆设备类型为IPC/NVR
			MaintanceFindLogPanel.add(IPC_NVR_Search);
			IPC_NVR_Table = new JTable();
			JScrollPane scrollPaneMaintenanceIPC = new JScrollPane(IPC_NVR_Table,
					JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
					JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			scrollPaneMaintenanceIPC.setBounds(60, 100, 1300, 500);
			MaintanceFindLogPanel.add(scrollPaneMaintenanceIPC, BorderLayout.CENTER);
			IPC_NVR_HeaderNames = new Vector();
			IPC_NVR_HeaderNames.add("NO");
			IPC_NVR_HeaderNames.add("UserName");
			IPC_NVR_HeaderNames.add("Time");
			IPC_NVR_HeaderNames.add("IPAddress");
			IPC_NVR_HeaderNames.add("ChannelID");
			IPC_NVR_HeaderNames.add("MasterType");
			IPC_NVR_HeaderNames.add("SubType");
			TableModel tableModel = new DefaultTableModel(IPC_NVR_HeaderNames,0);
			IPC_NVR_Table.setModel(tableModel);

			BackButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
						JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
						return;
					}
					if(ChannelID == 0){
						JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
						return;
					}

					if(nowPage > 1){
						nowPage--;
					}else{
						JOptionPane.showMessageDialog(null, "Now page is firstPage");
						return;
					}

					NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
					pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_ALL;
					pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_ALL_SUB_TYPES;
					
					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
					
					
					long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
					pstLogFindCond.dwLimitNum = 30;
					pstLogFindCond.dwOffset = (nowPage-1)*30;
					pstLogFindCond.write();
					Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
					if(logPointer == null){
						JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}
					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
					pstLogInfo.write();

					boolean flag = true;
					int i = 0;
					Vector data = new Vector();
					do {
						flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
						if(flag == false){
							System.out.printf("NETDEV_FindNextLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
							break;
						}
						pstLogInfo.read();
						Vector vtData = new Vector();
						vtData.add(i+1);
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
						vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
						vtData.add(pstLogInfo.dwChannelID);
						String message=null;
						message=Util.getLogMainType(pstLogInfo.dwMainType);
						vtData.add(message);
						String getLogSubTypeMessage=null;
						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
						vtData.add(getLogSubTypeMessage);
						data.add(vtData);
						i++;
					} while (flag && i < 30);
					
					flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
					if(flag == false){
						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}

					DefaultTableModel defaultTableModel = (DefaultTableModel) IPC_NVR_Table.getModel();
					defaultTableModel.setRowCount(0);
					IPC_NVR_Table.setModel(defaultTableModel);

					TableModel tableModel = new DefaultTableModel(data,IPC_NVR_HeaderNames);
					IPC_NVR_Table.setModel(tableModel);

					pagelabel.setText(String.valueOf(nowPage));
				}
			});

			

			NextButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
						JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
						return;
					}
					if(ChannelID == 0){
						JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
						return;
					}
					NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
					pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_ALL;
					pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_ALL_SUB_TYPES;
					
					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
					
					long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
					pstLogFindCond.dwLimitNum = 30;
					pstLogFindCond.dwOffset = nowPage*30;
					pstLogFindCond.write();
					Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
					if(logPointer == null){
						JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						if(netdevsdk.NETDEV_GetLastError() == 11){
							JOptionPane.showMessageDialog(null, "no results were found");
						}
						JOptionPane.showMessageDialog(null, "This page is lastPage");
			    		return;
					}

					nowPage++;

					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
					pstLogInfo.write();
					boolean flag = true;
					int i = 0;
					Vector data = new Vector();
					do {
						
						
						flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
						
						if(flag == false){
							System.out.printf("NETDEV_FindNextLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
							break;
						}
						pstLogInfo.read();
						Vector vtData = new Vector();
						vtData.add(i+1);
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
						vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
						vtData.add(pstLogInfo.dwChannelID);
						String message=null;
						message=Util.getLogMainType(pstLogInfo.dwMainType);
						vtData.add(message);
						String getLogSubTypeMessage=null;
						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
						vtData.add(getLogSubTypeMessage);
						data.add(vtData);
						i++;
					} while (flag && i < 30);
					
					flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
					if(flag == false){
						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}
					
					DefaultTableModel defaultTableModel = (DefaultTableModel) IPC_NVR_Table.getModel();
					defaultTableModel.setRowCount(0);
					IPC_NVR_Table.setModel(defaultTableModel);

					TableModel tableModel = new DefaultTableModel(data,IPC_NVR_HeaderNames);
					IPC_NVR_Table.setModel(tableModel);

					pagelabel.setText(String.valueOf(nowPage));
				}
			});


    		IPC_NVR_Search.setBounds(800, 20, 80, 35);
    		IPC_NVR_Search.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
    					JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
    					return;
    				}
    				if(ChannelID == 0){
    					JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
    					return;
    				}
    				
    				DefaultTableModel defaultTableModel = (DefaultTableModel) IPC_NVR_Table.getModel();
					defaultTableModel.setRowCount(0);
					IPC_NVR_Table.setModel(defaultTableModel);
					
    				NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
    				pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_ALL;
    				pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_ALL_SUB_TYPES;

					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
    				long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
    				
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				pstLogFindCond.dwLimitNum = 30;
    				pstLogFindCond.dwOffset = 0;
    				pstLogFindCond.write();
    				Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
    				if(logPointer == null){
    					JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						if(netdevsdk.NETDEV_GetLastError() == 11){
							JOptionPane.showMessageDialog(null, "No results were found");
						}
						return;
    				}else {
    					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
        				pstLogInfo.write();
        				boolean flag = true;
        				int i = 0;
        				Vector data = new Vector();
        				do {
        
        					flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
        					
            				if(flag == false){
            					break;
            				}
            				pstLogInfo.read();
            				Vector vtData = new Vector();
            				vtData.add(i+1);
            				vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
            				vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
            				vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
            				vtData.add(pstLogInfo.dwChannelID);
            				String message=null;
    						message=Util.getLogMainType(pstLogInfo.dwMainType);
    						vtData.add(message);
    						String getLogSubTypeMessage=null;
    						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
    						vtData.add(getLogSubTypeMessage);
            				data.add(vtData);
            				i++;
    					} while (flag && i < 30); 
        				
        				flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
    					if(flag == false){
    						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
    						return;
    					}
        				TableModel tableModel = new DefaultTableModel(data,IPC_NVR_HeaderNames);
        	    		IPC_NVR_Table.setModel(tableModel);

    					nowPage = 1;
    					pagelabel.setText(String.valueOf(nowPage));
    				}
    				
				}
			});

        }
        else if(deviceType == 1){
		//判断登陆设备类型为VMS

			VMSTable = new JTable();
			JScrollPane scrollPaneMaintenanceIPC = new JScrollPane(VMSTable,
			JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
			JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			scrollPaneMaintenanceIPC.setBounds(60, 100, 1400, 503);
			MaintanceFindLogPanel.add(scrollPaneMaintenanceIPC, BorderLayout.CENTER);
			VMS_HeaderNames = new Vector();
			VMS_HeaderNames.add("Time");
			VMS_HeaderNames.add("UserName");
			VMS_HeaderNames.add("IpAddress");
			VMS_HeaderNames.add("MasterType");
			VMS_HeaderNames.add("SubType");
			VMS_HeaderNames.add("OperObject");
			VMS_HeaderNames.add("DevName");
			VMS_HeaderNames.add("OrgName");
			VMS_HeaderNames.add("OperResult");

			TableModel tableModel = new DefaultTableModel(VMS_HeaderNames,0);
			VMSTable.setModel(tableModel);

			BackButton.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
						JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
						return;
					}
					if(ChannelID == 0){
						JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
						return;
					}

					if(nowPage > 1){
						nowPage--;
					}else{
						JOptionPane.showMessageDialog(null, "Now page is firstPage");
						return;
					}


					NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
					pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_VMS_ALL;
					pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_VMS_OPRERATE_SUB_ALL;
					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
					long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
					
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
					pstLogFindCond.dwLimitNum = 30;
					pstLogFindCond.dwOffset = (nowPage-1)*30;
					pstLogFindCond.write();
					Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
					if(logPointer == null){
						JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						if(netdevsdk.NETDEV_GetLastError() == 11){
							JOptionPane.showMessageDialog(null, "No results were found");
						}
			    		return;
					}
					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
					pstLogInfo.write();
					boolean flag = true;
					int i = 0;
					Vector data = new Vector();
					do {
						flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
	    				if(flag == false){
	    					System.out.printf("NETDEV_FindNextLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
							break;
	    				}
	    				pstLogInfo.read();
	    				Vector vtData = new Vector();
	    				vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
	    				String message=null;
						message=Util.getLogMainType(pstLogInfo.dwMainType);
						vtData.add(message);
						String getLogSubTypeMessage=null;
						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
						vtData.add(getLogSubTypeMessage);
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szOperObject));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szDevName));
						vtData.add(Common.byteArrayToString(pstLogInfo.szOrgName));
						vtData.add(pstLogInfo.udwOperResult);
	    				data.add(vtData);
	    				i++;
					} while (flag && i < 30);

					flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
					if(flag == false){
						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}
					
					DefaultTableModel defaultTableModel = (DefaultTableModel) VMSTable.getModel();
					defaultTableModel.setRowCount(0);
					VMSTable.setModel(defaultTableModel);

					TableModel tableModel = new DefaultTableModel(data,VMS_HeaderNames);
		    		VMSTable.setModel(tableModel);
		    		VMSTable.getColumnModel().getColumn(4).setPreferredWidth(200);

					pagelabel.setText(String.valueOf(nowPage));
				}
			});


			NextButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
						JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
						return;
					}
					if(ChannelID == 0){
						JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
						return;
					}

					NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
					pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_VMS_ALL;
					pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_VMS_OPRERATE_SUB_ALL;
					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
					long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
					pstLogFindCond.dwLimitNum = 30;
					pstLogFindCond.dwOffset = nowPage*30;
					pstLogFindCond.write();
					Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
					if(logPointer == null){
						JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						if(netdevsdk.NETDEV_GetLastError() == 11){
							JOptionPane.showMessageDialog(null, "no results were found");
						}
						JOptionPane.showMessageDialog(null, "This page is lastPage");
						return;
					}

					nowPage++;

					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
					pstLogInfo.write();
					boolean flag = true;
					int i = 0;
					Vector data = new Vector();
					do {
						flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
						if(flag == false){
							System.out.printf("NETDEV_FindNextLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
							break;
						}
						pstLogInfo.read();
						Vector vtData = new Vector();
						vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
						vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
						String message=null;
						message=Util.getLogMainType(pstLogInfo.dwMainType);
						vtData.add(message);
						String getLogSubTypeMessage=null;
						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
						vtData.add(getLogSubTypeMessage);
						vtData.add(Common.byteArrayToString(pstLogInfo.szOperObject));
						vtData.add(Common.byteArrayToString(pstLogInfo.szDevName));
						vtData.add(Common.byteArrayToString(pstLogInfo.szOrgName));
						vtData.add(pstLogInfo.udwOperResult);
						data.add(vtData);
						i++;
					} while (flag && i < 30);
					
					flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
					if(flag == false){
						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}

					DefaultTableModel defaultTableModel = (DefaultTableModel) VMSTable.getModel();
					defaultTableModel.setRowCount(0);
					VMSTable.setModel(defaultTableModel);

					TableModel tableModel = new DefaultTableModel(data,VMS_HeaderNames);
					VMSTable.setModel(tableModel);
					VMSTable.getColumnModel().getColumn(4).setPreferredWidth(200);
					pagelabel.setText(String.valueOf(nowPage));
				}
			});


			VMS_Search.setBounds(800, 20, 80, 35);
			VMS_Search.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					if(null == lpUserID){
						JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
						return;
					}
					if(ChannelID == 0){
						JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
						return;
					}
					
					DefaultTableModel defaultTableModel = (DefaultTableModel) VMSTable.getModel();
					defaultTableModel.setRowCount(0);
					VMSTable.setModel(defaultTableModel);

					NETDEV_FIND_LOG_COND_S pstLogFindCond = new NETDEV_FIND_LOG_COND_S();
					pstLogFindCond.dwMainType = NETDEV_LOG_MAIN_TYPE_E.NETDEV_LOG_MAIN_TYPE_VMS_ALL;
					pstLogFindCond.dwSubType = NETDEV_LOG_SUB_TYPE_E.NETDEV_LOG_VMS_OPRERATE_SUB_ALL;
					String BeginTime =BegindateLog.jTextFieldDate.getText();
					String EndTime = EnddateLog.jTextFieldDate.getText();
					
					if(BeginTime == null || "".equals(BeginTime)){
						JOptionPane.showMessageDialog(null, "Please input startTime.");
					}
					if(EndTime == null || "".equals(EndTime)){
						JOptionPane.showMessageDialog(null, "Please input endTime.");
					}
					long get1=Common.date2TimeStamp(BeginTime.toString(), DateFormat);
    				
    				
    				long get2=Common.date2TimeStamp(EndTime.toString(), DateFormat);
    				
    				if(get1>get2) {
    					JOptionPane.showMessageDialog(null, "Start time can not more than end time");
    					return;
    				}
    				
					pstLogFindCond.tBeginTime = Common.date2TimeStamp(BeginTime.toString(), DateFormat);
					pstLogFindCond.tEndTime =  Common.date2TimeStamp(EndTime.toString(), DateFormat);
					pstLogFindCond.dwLimitNum = 30;
					pstLogFindCond.dwOffset = 0;
					pstLogFindCond.write();
					Pointer logPointer = netdevsdk.NETDEV_FindLogInfoList(lpUserID,pstLogFindCond);
					if(logPointer == null){
						JOptionPane.showMessageDialog(null, "No result,error code"+netdevsdk.NETDEV_GetLastError());
						System.out.printf("NETDEV_FindLogInfoList failed:%d\n", netdevsdk.NETDEV_GetLastError());
						if(netdevsdk.NETDEV_GetLastError() == 11){
							JOptionPane.showMessageDialog(null, "no results were found");
						}
						return;
					}
					NETDEV_LOG_INFO_S pstLogInfo = new NETDEV_LOG_INFO_S();
					pstLogInfo.write();
					boolean flag = true;
					int i = 0;
					Vector data = new Vector();
					do {
						flag = netdevsdk.NETDEV_FindNextLogInfo(logPointer,pstLogInfo);
	    				if(flag == false){
	    					System.out.printf("NETDEV_FindNextLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
							break;
	    				}
	    				pstLogInfo.read();
	    				Vector vtData = new Vector();
	    				vtData.add(Common.timeStamp2Date(String.valueOf(pstLogInfo.tTime), DateFormat));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szUserName));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szUserAddr));
	    				String message=null;
						message=Util.getLogMainType(pstLogInfo.dwMainType);
						vtData.add(message);
						String getLogSubTypeMessage=null;
						getLogSubTypeMessage=Util.getLogSubType(pstLogInfo.dwSubType);
						vtData.add(getLogSubTypeMessage);
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szOperObject));
	    				vtData.add(Common.byteArrayToString(pstLogInfo.szDevName));
						vtData.add(Common.byteArrayToString(pstLogInfo.szOrgName));
						vtData.add(pstLogInfo.udwOperResult);
	    				data.add(vtData);
	    				i++;
					} while (flag && i < 30);
					
					flag = netdevsdk.NETDEV_FindCloseLogInfo(logPointer);
					if(flag == false){
						System.out.printf("NETDEV_FindCloseLogInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
						return;
					}
					TableModel tableModel = new DefaultTableModel(data,VMS_HeaderNames);
		    		VMSTable.setModel(tableModel);
		    		VMSTable.getColumnModel().getColumn(4).setPreferredWidth(200);
					nowPage = 1;
					pagelabel.setText(String.valueOf(nowPage));
				}
			});
			MaintanceFindLogPanel.add(VMS_Search);
        }
	}
}
