package main.java.com.netdevsdk.demo.ptz.basicptz;

import java.util.Vector;

import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.ptz.ptzextend.Preset;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_ALLPRESETS_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_PRESETCMD_E;

/**
 * 
 * @description Preset operation includes acquiring preset, turning to preset,setting preset and deleting preset
 *
 */
public class PresetPTZ {
    /**
     * @introduction Get PTZ preset location
     */
    public static void getPTZPreset() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        NetDemo.PTZBasePresetModel.setRowCount(0);
        /* Create PTZ preset structure */
        NETDEV_PTZ_ALLPRESETS_S stPtzPresets = new NETDEV_PTZ_ALLPRESETS_S();
        /* Get PTZ preset location list */
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetPTZPresetList(NetDemo.lpUserID, NetDemo.ChannelID, stPtzPresets);
        if(bRet != true)
        {
            JOptionPane.showMessageDialog(null, "Get data failed，maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_GetPTZPresetList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else
        {
            for(int i = 0; i < stPtzPresets.dwSize; i++)
            {
                Vector<String> vector = new Vector<String>();
                vector.add(String.valueOf(stPtzPresets.astPreset[i].dwPresetID));
                vector.add(Common.byteArrayToString(stPtzPresets.astPreset[i].szPresetName));
                NetDemo.PTZBasePresetModel.insertRow(i,vector);
            }
        }
    }
    
    /**
     * @introduction Go to preset location 
     */
    public static void gotoPTZPreset() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        if(0 == NetDemo.PTZBasePresetModel.getRowCount()  || NetDemo.jTablePTZBasePreset.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find Preset or seletc Preset first.");
            return;
        }
        else 
        {
            String strPresetID = (String) NetDemo.jTablePTZBasePreset.getValueAt(NetDemo.jTablePTZBasePreset.getSelectedRow(), 0);
            if(strPresetID==null||strPresetID.equals("")) 
            {
                JOptionPane.showMessageDialog(null, "PresetID is null");
                return;
            }
            int PresetID=0;
            try {
                PresetID=Integer.parseInt(strPresetID);
            }catch(Exception m) {
                JOptionPane.showMessageDialog(null, "PresetID is error");
                return;
            }
            
            String strPresetNameString = "";
            /* PTZ preset operation(Do not need to start preview) */
            boolean bRet = NetDemo.netdevsdk.NETDEV_PTZPreset_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_PRESETCMD_E.NETDEV_PTZ_GOTO_PRESET, strPresetNameString,PresetID);
            if(bRet != true)
            {
                JOptionPane.showMessageDialog(null, " failed，maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_PTZPreset_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
        
    }
    
    /**
     * @introduction Set preset location 
     * @description  It is mainly initialized by the constructor of the Preset class.
     */
    public static void addPTZPreset() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        Preset p = new Preset();
        p.setVisible(true);
    }

    /**
     * @introduction Delete preset location 
     * @description
     */
    public static void deletePTZPreset() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }

        if(0 == NetDemo.PTZBasePresetModel.getRowCount()  || NetDemo.jTablePTZBasePreset.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find Preset or seletc Preset first.");
            return;
        }
        else 
        {
            String strPresetID = (String) NetDemo.jTablePTZBasePreset.getValueAt(NetDemo.jTablePTZBasePreset.getSelectedRow(), 0);
            int PresetID=0;
            try {
                PresetID=Integer.parseInt(strPresetID);
            }catch(Exception m) {
                JOptionPane.showMessageDialog(null, "PresetID is error");
                return;
            }

            String strPresetNameString = "";
            boolean bRet = NetDemo.netdevsdk.NETDEV_PTZPreset_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_PRESETCMD_E.NETDEV_PTZ_CLE_PRESET, strPresetNameString, PresetID);
            if(bRet != true)
            {
                JOptionPane.showMessageDialog(null, " Failed，maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_PTZPreset_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            NetDemo.jButtonGetBasePTZPreset.doClick();
        }

    }
}
