package main.java.com.netdevsdk.demo.ptz.ptzextend;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JOptionPane;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CRUISE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CRUISE_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_CRUISE_POINT_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_ALLPRESETS_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PTZ_CRUISECMD_E;

/**
 * @description Preset patrols includes preset patrols,acquiring preset patrols,starting preset patrols,stopping preset patrols
 *              adding preset location and delete preset location 
 * @introduction Support IPC/NVR/VMS         
 */
public class PresetPatrols {
    /**
     * @introduction To start preset patrols
     * @description Call the methods of presetPatrolsOperation to start preset patrols.
     */
    public static void startPresetPatrols() {
        presetPatrolsOperation(NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_RUN_CRUISE);
    }
    /**
     * @introduction To delete preset patrols
     * @description  Call the methods of presetPatrolsOperation to start preset patrols. 
     */
    public static void deletePresetPatrols() {
        presetPatrolsOperation(NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_DEL_CRUISE);
    }
    /**
     * @introduction To stop preset patrols
     * @description  Call the methods of presetPatrolsOperation to start preset patrols. 
     */
    public static void stopPresetPatrols() {
        presetPatrolsOperation(NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_STOP_CRUISE);
    }
    
    /**
     * @introduction The methods to realize the preset patrols operation.
     * @description  Call the interface of NETDEV_PTZCruise_Other to realize different operations.
     * @param [operation] [It includes NETDEV_PTZ_RUN_CRUISE NETDEV_PTZ_STOP_CRUISE and NETDEV_PTZ_DEL_CRUISE.]
     */
    public static void presetPatrolsOperation(int operation) {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        NETDEV_CRUISE_INFO_S strCruiseInfo = new NETDEV_CRUISE_INFO_S();
        String PresetPatrolsID=null;
        try {
            PresetPatrolsID=(String) NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedItem();
        }catch(Exception m1) {
            return;
        }
        
        if(PresetPatrolsID==null||PresetPatrolsID.equals("")) {
            JOptionPane.showMessageDialog(null, "PresetPatrolsID is null");
            return;
        }
        
        int id=0;
        try {
            id=Integer.valueOf(PresetPatrolsID);
        }catch(Exception k) {
            JOptionPane.showMessageDialog(null, "PresetPatrolsID is null or transformation Exception");
            return;
        }
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR|| NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)       
        {
            strCruiseInfo.dwCuriseID = id-1;
        }
        else 
        {
            strCruiseInfo.dwCuriseID = id;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID,operation,strCruiseInfo);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "Get data failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            switch (operation) {
                case NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_RUN_CRUISE:
                    JOptionPane.showMessageDialog(null, "Start success");
                    break;
                case NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_STOP_CRUISE:
                    JOptionPane.showMessageDialog(null, "Stop success");
                    break;
                case NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_DEL_CRUISE:
                    NetDemo.jButtonPTZExtendPresetPatrolsRefresh.doClick();
                    JOptionPane.showMessageDialog(null, "Delete success");
                    break;
                default:
                    break;
            }  
        } 
    }

    /**
     * @introduction To save preset patrols.
     * @description  Call the interface of NETDEV_PTZGetCruise and  NETDEV_PTZCruise_Other to realize.
     */
    public static void savePresetPatrols() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.ChannelID == 0)
        {
            JOptionPane.showMessageDialog(null, "Please select an online channel after login.");
            return;
        }
        boolean bRet = false;
        /* 获取设备是否有预置位巡航，如果没有就是添加，如果有就是修改 */
        int dwPresetPatrolsTableSize = NetDemo.tablePTZExtendPresetPatrolsModel.getRowCount();
        if(dwPresetPatrolsTableSize < 2)
        {
            JOptionPane.showMessageDialog(null, "Please add more Patrols");
            return;
        }
        /* 获取设备是否有预置位巡航，如果没有就是添加，如果有就是修改 */
        NETDEV_CRUISE_LIST_S stCuriseList = new NETDEV_CRUISE_LIST_S();
        NetDemo.netdevsdk.NETDEV_PTZGetCruise(NetDemo.lpUserID, NetDemo.ChannelID, stCuriseList);
        int PresetPatrolsID=NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()+1;
        if(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText()==null||NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "The name is null,please make sure set name if you wang to use");
            return;
        }
        if(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText().trim().length()>20) 
        {
            JOptionPane.showMessageDialog(null, "The name can not more than 20 length");
            return;
        }
        stCuriseList.read();
        if(stCuriseList.dwSize>0) {  
                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR|| 
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                            NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)  
                    {
                         NETDEV_CRUISE_INFO_S strCruiseInfo = stCuriseList.astCruiseInfo[NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()];
                         strCruiseInfo.dwCuriseID = PresetPatrolsID-1;
                         Common.stringToByteArray(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText(), strCruiseInfo.szCuriseName);
                         for(int i = 0; i <  dwPresetPatrolsTableSize ; i++)
                         {
                            strCruiseInfo.astCruisePoint[i] = new NETDEV_CRUISE_POINT_S();
                            String PresetID=null;
                            try {
                                PresetID=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 0);
                            }catch(Exception h3) {
                                return;
                            }
                            
                            if(PresetID==null||PresetID.equals("")) 
                            {
                                JOptionPane.showMessageDialog(null, "PresetID is null");
                                return;
                            }
                            
                            int getPresetID=0;
                            try {
                                getPresetID=Integer.parseInt(PresetID);
                            }catch(Exception h4) {
                                JOptionPane.showMessageDialog(null, "PresetID is error");
                                return;
                            }

                            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) 
                            {
                                strCruiseInfo.astCruisePoint[i].dwID = i;
                                strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                            }
                            else 
                            {
                                strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                            }        
                            String strStayTime=null;
                            try {
                                strStayTime=(String)NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 1);
                            }catch(Exception h5) {
                                return;
                            }
                            if(strStayTime==null||strStayTime.equals(""))
                            {
                                JOptionPane.showMessageDialog(null, "StayTime is null");
                                return;
                            }
                            
                            int StayTime=0;
                            try {
                                StayTime=Integer.parseInt(strStayTime);
                            }catch(Exception h6) {
                                JOptionPane.showMessageDialog(null, "StayTime is error");
                                return;
                            }
                            strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime*1000;
                            String StrSpeed=null;
                            try {
                                StrSpeed=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 2);
                            }catch(Exception h7) {
                                return;
                            }
                            if(StrSpeed==null||StrSpeed.equals("")) 
                            {
                                JOptionPane.showMessageDialog(null, "Speed is null");
                                return;
                            }
                            int speed=0;
                            try {
                                speed=Integer.parseInt(StrSpeed);
                            }catch(Exception h8) {
                                JOptionPane.showMessageDialog(null, "Speed is error");
                                return;
                            }
                            if(speed<1 || speed>9) {
                                JOptionPane.showMessageDialog(null, "Speed should between 1 and 9");
                                return;
                            }
                            strCruiseInfo.astCruisePoint[i].dwSpeed = speed;
                         }
                         strCruiseInfo.dwSize=dwPresetPatrolsTableSize;
                         strCruiseInfo.write();
                         bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_MODIFY_CRUISE, strCruiseInfo);
                         if(bRet != true)
                         {
                            JOptionPane.showMessageDialog(null, "modify failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                            System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                             return;
                         }
                         else 
                         {
                            JOptionPane.showMessageDialog(null, "Save success");
                            return;
                         }
                     
                   }
                   else 
                   {
                           for(int m=0;m<stCuriseList.dwSize;m++) 
                           {
                                if(stCuriseList.astCruiseInfo[m].dwCuriseID==(NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()+1)) {            
                                    System.out.println("得到修改的是"+stCuriseList.astCruiseInfo[m].dwCuriseID+stCuriseList.astCruiseInfo[m].astCruisePoint[0].dwSpeed);
                                     NETDEV_CRUISE_INFO_S strCruiseInfo = stCuriseList.astCruiseInfo[NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()];
                                    strCruiseInfo.read();
                                    strCruiseInfo.dwCuriseID=NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()+1;
                                    Common.stringToByteArray(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText(), strCruiseInfo.szCuriseName);
                                    for(int i = 0; i <  dwPresetPatrolsTableSize ; i++)
                                   {
                                    strCruiseInfo.astCruisePoint[i] = new NETDEV_CRUISE_POINT_S();
                                    
                                    String PresetID=null;
                                    try {
                                        PresetID=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 0);
                                    }catch(Exception h3) {
                                        return;
                                    }
                                    
                                    if(PresetID==null||PresetID.equals("")) 
                                    {
                                        JOptionPane.showMessageDialog(null, "PresetID is null");
                                        return;
                                    }
                                    
                                    int getPresetID=0;
                                    try {
                                        getPresetID=Integer.parseInt(PresetID);
                                    }catch(Exception h4) {
                                        JOptionPane.showMessageDialog(null, "PresetID is error");
                                        return;
                                    }
                                    
                                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) 
                                    {
                                        strCruiseInfo.astCruisePoint[i].dwID = i;
                                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                                    }
                                    else 
                                    {
                                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                                    }
                                    String strStayTime=null;
                                    try {
                                        strStayTime=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 1);
                                    }catch(Exception h5) {
                                        return;
                                    }
                                    if(strStayTime==null||strStayTime.equals("")) 
                                    {
                                        JOptionPane.showMessageDialog(null, "StayTime is null");
                                        return;
                                    }
                                    
                                    int StayTime=0;
                                    try {
                                        StayTime=Integer.parseInt(strStayTime);
                                    }catch(Exception h6) {
                                        JOptionPane.showMessageDialog(null, "StayTime is error");
                                        return;
                                    }
                                    
                                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) 
                                    {
                                        strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime;
                                    }
                                    else
                                    {
                                        strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime*1000;
                                    }
                                    String StrSpeed=null;
                                    try {
                                        StrSpeed=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 2);
                                    }catch(Exception h7) {
                                        return;
                                    }
                                    if(StrSpeed==null||StrSpeed.equals("")) 
                                    {
                                        JOptionPane.showMessageDialog(null, "Speed is null");
                                        return;
                                    }
                                    int speed=0;
                                    try {
                                        speed=Integer.parseInt(StrSpeed);
                                    }catch(Exception h8) {
                                        JOptionPane.showMessageDialog(null, "Speed is error");
                                        return;
                                    }
                                    strCruiseInfo.astCruisePoint[i].dwSpeed = speed;
                                   }

                                    strCruiseInfo.dwSize=dwPresetPatrolsTableSize;
                                    System.out.println("真正修改的id是"+strCruiseInfo.dwCuriseID);
                                    strCruiseInfo.write();
                                    bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_MODIFY_CRUISE, strCruiseInfo);
                                    if(bRet != true)
                                    {
                                        JOptionPane.showMessageDialog(null, "Modify failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                        System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                        return;
                                    }
                                    else 
                                    {
                                        JOptionPane.showMessageDialog(null, "Save success");
                                        return;
                                    }
                                }
                           }
                          List<Integer> ids=new ArrayList<>();
                          for(int g=0;g<stCuriseList.dwSize;g++) 
                          {
                             ids.add(stCuriseList.astCruiseInfo[g].dwCuriseID);
                          }
                          for(int k=1;k<NetDemo.jComboBoxPTZExtendPresetPatrolsID.getItemCount()+1;k++) {
                             if(!ids.contains(k)) 
                             {
                                NETDEV_CRUISE_INFO_S strCruiseInfo =stCuriseList.astCruiseInfo[NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()];
                                strCruiseInfo.read();
                                strCruiseInfo.dwCuriseID = NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()+1;
                                Common.stringToByteArray(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText(), strCruiseInfo.szCuriseName);
                                for(int i = 0; i <  dwPresetPatrolsTableSize ; i++)
                                {
                                    strCruiseInfo.astCruisePoint[i] = new NETDEV_CRUISE_POINT_S();
                                    String PresetID=null;
                                    try {
                                     PresetID=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 0);
                                        }catch(Exception h3) {
                                            return;
                                        }
                                        
                                        if(PresetID==null||PresetID.equals("")) {
                                            JOptionPane.showMessageDialog(null, "PresetID is null");
                                            return;
                                        }
                                        
                                        int getPresetID=0;
                                        try {
                                            getPresetID=Integer.parseInt(PresetID);
                                        }catch(Exception h4) {
                                            JOptionPane.showMessageDialog(null, "PresetID is error");
                                            return;
                                        }
                                        
                                        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                                            strCruiseInfo.astCruisePoint[i].dwID = i;
                                            strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                                        }else {
                                            strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                                        }
                                       
                                        
                                        String strStayTime=null;
                                        try {
                                            strStayTime=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 1);
                                        }catch(Exception h5) {
                                            return;
                                        }
                                        if(strStayTime==null||strStayTime.equals("")) {
                                            JOptionPane.showMessageDialog(null, "StayTime is null");
                                            return;
                                        }
                                        
                                        int StayTime=0;
                                        try {
                                            StayTime=Integer.parseInt(strStayTime);
                                        }catch(Exception h6) {
                                            JOptionPane.showMessageDialog(null, "StayTime is error");
                                            return;
                                        }
                                        
                                        
                                        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                                            strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime;
                                        }
                                        else{
                                            strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime*1000;
                                       }
                                        
                                        String StrSpeed=null;
                                        try {
                                            StrSpeed=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 2);
                                        }catch(Exception h7) {
                                            return;
                                        }
                                        if(StrSpeed==null||StrSpeed.equals("")) {
                                            JOptionPane.showMessageDialog(null, "Speed is null");
                                            return;
                                        }
                                        int speed=0;
                                        try {
                                            speed=Integer.parseInt(StrSpeed);
                                        }catch(Exception h8) {
                                            JOptionPane.showMessageDialog(null, "Speed is error");
                                            return;
                                        }
                                        strCruiseInfo.astCruisePoint[i].dwSpeed = speed;
                                       }
                                            {
                                                strCruiseInfo.dwSize=dwPresetPatrolsTableSize;
                                                System.out.println("修改的id是"+strCruiseInfo.dwCuriseID);
                                                 strCruiseInfo.write();
                                                 bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_ADD_CRUISE, strCruiseInfo);
                                               if(bRet != true)
                                               {
                                                JOptionPane.showMessageDialog(null, "Add failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                                                System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                                                   return;
                                               }else {
                                                JOptionPane.showMessageDialog(null, "Save success");
                                                return;
                                               }
                                            }
                                   }
                            }
                       }
        }
        else 
        {
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP
                    ){
                NETDEV_CRUISE_INFO_S strCruiseInfo=stCuriseList.astCruiseInfo[NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()];
                strCruiseInfo.dwCuriseID=PresetPatrolsID-1;
                Common.stringToByteArray(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText(), strCruiseInfo.szCuriseName);
                
                for(int i = 0; i <  dwPresetPatrolsTableSize ; i++)
                {
                    strCruiseInfo.astCruisePoint[i] = new NETDEV_CRUISE_POINT_S();
                    
                    String PresetID=null;
                    try {
                        PresetID=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 0);
                    }catch(Exception h3) {
                        return;
                    }
                    
                    if(PresetID==null||PresetID.equals("")) {
                        JOptionPane.showMessageDialog(null, "PresetID is null");
                        return;
                    }
                    
                    int getPresetID=0;
                    try {
                        getPresetID=Integer.parseInt(PresetID);
                    }catch(Exception h4) {
                        JOptionPane.showMessageDialog(null, "PresetID is error");
                        return;
                    }
                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                        strCruiseInfo.astCruisePoint[i].dwID = i;
                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                    }else {
                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                    }
                    
                    String strStayTime=null;
                    try {
                        strStayTime=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 1);
                    }catch(Exception h5) {
                        return;
                    }
                    if(strStayTime==null||strStayTime.equals("")) {
                        JOptionPane.showMessageDialog(null, "StayTime is null");
                        return;
                    }
                    
                    int StayTime=0;
                    try {
                        StayTime=Integer.parseInt(strStayTime);
                    }catch(Exception h6) {
                        JOptionPane.showMessageDialog(null, "StayTime is error");
                        return;
                    }
                    strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime*1000;
                    
                    String StrSpeed=null;
                    try {
                        StrSpeed=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 2);
                    }catch(Exception h7) {
                        return;
                    }
                    if(StrSpeed==null||StrSpeed.equals("")) {
                        JOptionPane.showMessageDialog(null, "Speed is null");
                        return;
                    }
                    int speed=0;
                    try {
                        speed=Integer.parseInt(StrSpeed);
                    }catch(Exception h8) {
                        JOptionPane.showMessageDialog(null, "Speed is error");
                        return;
                    }
                    strCruiseInfo.astCruisePoint[i].dwSpeed = speed;
                    
                    
                }
                        strCruiseInfo.dwSize=dwPresetPatrolsTableSize;
                        
                        strCruiseInfo.write();
                         bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_MODIFY_CRUISE, strCruiseInfo);
                         if(bRet != true)
                         {
                            JOptionPane.showMessageDialog(null, "Add failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                            System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                             return;
                         }else {
                            JOptionPane.showMessageDialog(null, "Save success");
                            return;
                            
                         }
               }else {
                   NETDEV_CRUISE_INFO_S strCruiseInfo =stCuriseList.astCruiseInfo[NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()];
                strCruiseInfo.dwCuriseID=PresetPatrolsID;
                Common.stringToByteArray(NetDemo.jTextFieldPTZExtendPresetPatrolsName.getText(), strCruiseInfo.szCuriseName);
                
                for(int i = 0; i <  dwPresetPatrolsTableSize ; i++)
                {
                    strCruiseInfo.astCruisePoint[i] = new NETDEV_CRUISE_POINT_S();
                    
                    String PresetID=null;
                    try {
                        PresetID=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 0);
                    }catch(Exception h3) {
                        return;
                    }
                    
                    if(PresetID==null||PresetID.equals("")) {
                        JOptionPane.showMessageDialog(null, "PresetID is null");
                        return;
                    }
                    
                    int getPresetID=0;
                    try {
                        getPresetID=Integer.parseInt(PresetID);
                    }catch(Exception h4) {
                        JOptionPane.showMessageDialog(null, "PresetID is error");
                        return;
                    }
                    
                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                        strCruiseInfo.astCruisePoint[i].dwID = i;
                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                    }
                    else {
                        strCruiseInfo.astCruisePoint[i].dwPresetID = getPresetID;
                    }
                    
                    String strStayTime=null;
                    try {
                        strStayTime=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 1);
                    }catch(Exception h5) {
                        return;
                    }
                    if(strStayTime==null||strStayTime.equals("")) {
                        JOptionPane.showMessageDialog(null, "StayTime is null");
                        return;
                    }
                    
                    int StayTime=0;
                    try {
                        StayTime=Integer.parseInt(strStayTime);
                    }catch(Exception h6) {
                        JOptionPane.showMessageDialog(null, "StayTime is error");
                        return;
                    }
                    if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS) {
                        strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime;
                    }
                    else{
                        strCruiseInfo.astCruisePoint[i].dwStayTime = StayTime*1000;
                   }
                    
                    String StrSpeed=null;
                    try {
                        StrSpeed=(String) NetDemo.jTablePTZExtendPresetPatrols.getValueAt(i, 2);
                    }catch(Exception h7) {
                        return;
                    }
                    if(StrSpeed==null||StrSpeed.equals("")) {
                        JOptionPane.showMessageDialog(null, "Speed is null");
                        return;
                    }
                    int speed=0;
                    try {
                        speed=Integer.parseInt(StrSpeed);
                    }catch(Exception h8) {
                        JOptionPane.showMessageDialog(null, "Speed is error");
                        return;
                    }
                    strCruiseInfo.astCruisePoint[i].dwSpeed = speed;
                    
                    
                }
                        strCruiseInfo.dwSize=dwPresetPatrolsTableSize;
                        
                        strCruiseInfo.write();
                         bRet = NetDemo.netdevsdk.NETDEV_PTZCruise_Other(NetDemo.lpUserID, NetDemo.ChannelID, NETDEV_PTZ_CRUISECMD_E.NETDEV_PTZ_ADD_CRUISE, strCruiseInfo);
                         if(bRet != true)
                         {
                            JOptionPane.showMessageDialog(null, "Add failed,maybe not support,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                            System.out.printf("NETDEV_PTZCruise_Other failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                             return;
                         }else {
                            JOptionPane.showMessageDialog(null, "Save success");
                            return;
                         }
               }
        }     
    }
   
    
    /**
     * @introduction To add preset patrols.
     * @description  It mainly uses Vector to add.
     */
    public static void addPresetPatrols() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        Vector<String> PresetPointVector = new Vector<String>();
        String PresetId=null;
        try {
            PresetId=(String)NetDemo.jComboBoxExtendPTZPresetID.getSelectedItem();
        }catch(Exception h) {
            return;
        }

        if(PresetId==null||PresetId.equals("")) 
        {
            JOptionPane.showMessageDialog(null, "PTZPresetID is null");
            return;
        }
        PresetPointVector.add(PresetId);
        String stayTime=NetDemo.jTextFieldExtendPTZStayTime.getText();
        if(stayTime==null||stayTime.equals("")) 
        {
            JOptionPane.showMessageDialog(null, "StayTime is null");
            return;
        }
        
        PresetPointVector.add(stayTime);
        
        String speed = NetDemo.jTextFieldPTZExtendPresetPatrolsSpeed.getText();
        if(speed==null||speed.equals("")) 
        {
            JOptionPane.showMessageDialog(null, "Speed is null");
            return;
        }
        if(Integer.valueOf(speed)<1||Integer.valueOf(speed)>9) 
        {
            JOptionPane.showMessageDialog(null, "Speed should between 1 and 9");
            return;
        }
        PresetPointVector.add(speed);
        NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
    }
    
    /**
     * @introduction To delete preset ID.
     * @description  The methods removeRow of model mainly used to realize the  function.
     */
    public static void deletePresetID() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.tablePTZExtendPresetPatrolsModel.getRowCount()  || NetDemo.jTablePTZExtendPresetPatrols.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "No row to delete");
            return;
        }
        NetDemo.tablePTZExtendPresetPatrolsModel.removeRow(NetDemo.jTablePTZExtendPresetPatrols.getSelectedRow());
    }  
    /**
     * @introduction To refresh the list of preset patrils
     * @description
     */
    public static void refreshPresetPatrols() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText("");

        NETDEV_CRUISE_LIST_S stCuriseList = new NETDEV_CRUISE_LIST_S();
        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZGetCruise(NetDemo.lpUserID, NetDemo.ChannelID, stCuriseList);
        if(bRet == true)
        {
            /* 预置位巡航信息 */
            stCuriseList.read(); 
            List<Integer> ids=new ArrayList();   
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
               NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
               NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)
            {
                if(stCuriseList.astCruiseInfo[0].dwCuriseID == 0) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(0);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 1) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(1);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 2) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(2);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 3) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(3);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 4) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(4);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 5) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(5);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 6) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(6);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 7) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(7);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 8) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(8);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 9) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(9);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 10) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(10);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 11) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(11);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 12) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(12);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 13) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(13);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 14) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(14);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 15) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(15);
            }
        }
        else 
        {
                if(stCuriseList.astCruiseInfo[0].dwCuriseID == 1) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(0);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 2) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(1);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 3) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(2);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 4) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(3);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 5) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(4);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 6) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(5);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 7) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(6);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 8) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(7);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 9) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(8);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 10) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(9);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 11) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(10);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 12) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(11);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 13) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(12);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 14) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(13);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 15) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(14);
                }else if(stCuriseList.astCruiseInfo[0].dwCuriseID == 16) {
                    NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(15);
                }
        }
            NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText(Common.byteArrayToString(stCuriseList.astCruiseInfo[0].szCuriseName));
            NetDemo.tablePTZExtendPresetPatrolsModel.setRowCount(0);

            for(int i=0;i<stCuriseList.astCruiseInfo[0].dwSize;i++)
            {
                 Vector<String> PresetPointVector = new Vector<String>();
                 
                 if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)
                 {  
                    PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwID));
                    PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwStayTime));
                    PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwSpeed)); 
                    NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                 }
                 else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
                         NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
                         NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)
                {
                             PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwPresetID));
                             PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwStayTime/1000));
                             PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwSpeed)); 
                             NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                }
                 else 
                 {
                             PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwPresetID));
                             PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwStayTime/1000));
                             if(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwSpeed<5) {
                                 PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwSpeed)); 
                             }
                             else 
                             {
                                 PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[0].astCruisePoint[i].dwSpeed-1));
                             } 
                             NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                         }
                 
                 }  
        }
        else 
        {
            NetDemo.tablePTZExtendPresetPatrolsModel.setRowCount(0);
            NetDemo.jComboBoxPTZExtendPresetPatrolsID.setSelectedIndex(0);
             JOptionPane.showMessageDialog(null, " No data");
        }

        /* 获取预置位信息，供添加预置位巡航使用  */
        NetDemo.jComboBoxExtendPTZPresetID.removeAllItems();
        NETDEV_PTZ_ALLPRESETS_S stPtzPresets = new NETDEV_PTZ_ALLPRESETS_S();
        bRet = NetDemo.netdevsdk.NETDEV_GetPTZPresetList(NetDemo.lpUserID,NetDemo.ChannelID, stPtzPresets);
        if(bRet != true)
        {
            System.out.printf("NETDEV_GetPTZPresetList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else
        {
            for(int i =0; i < stPtzPresets.dwSize; i++)
            {
                Vector<String> PresetPointVector = new Vector<String>();
                NetDemo.jComboBoxExtendPTZPresetID.addItem(String.valueOf(stPtzPresets.astPreset[i].dwPresetID));
            }
        }

    
    }
    
    /**
     * @introduction The function of jComboxPresetPatrolsID.
     * @description
     */
    public static void jComboxPresetPatrolsID() {

        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        NetDemo.tablePTZExtendPresetPatrolsModel.setRowCount(0);
        NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText("");

        NETDEV_CRUISE_LIST_S stCuriseList = new NETDEV_CRUISE_LIST_S();
        boolean bRet = NetDemo.netdevsdk.NETDEV_PTZGetCruise(NetDemo.lpUserID, NetDemo.ChannelID, stCuriseList);
        System.out.println(bRet);
        if(bRet == true)
        {
            stCuriseList.read();
            List<Integer> ids=new ArrayList();
            for(int k=0;k<stCuriseList.dwSize;k++) 
            {
             ids.add(stCuriseList.astCruiseInfo[k].dwCuriseID);
            }
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
               NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
               NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP)
            {
               for(int i=0;i<stCuriseList.dwSize;i++) 
               {
                   if(NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()==stCuriseList.astCruiseInfo[i].dwCuriseID) 
                   {
                       NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText(Common.byteArrayToString(stCuriseList.astCruiseInfo[i].szCuriseName));
                      for(int j=0;j<stCuriseList.astCruiseInfo[i].dwSize;j++)
                      {
                          Vector<String> PresetPointVector = new Vector<String>();
                          PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwPresetID));
                          PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwStayTime/1000));
                          PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed));
                          NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                      }
                   }
                }
             }
            else 
            {
                for(int i=0;i<stCuriseList.dwSize;i++) 
                {
                    System.out.println("轨迹id"+stCuriseList.astCruiseInfo[i].dwCuriseID);
                    if(NetDemo.jComboBoxPTZExtendPresetPatrolsID.getSelectedIndex()+1==stCuriseList.astCruiseInfo[i].dwCuriseID) 
                    {
                        NetDemo.jTextFieldPTZExtendPresetPatrolsName.setText(Common.byteArrayToString(stCuriseList.astCruiseInfo[i].szCuriseName));
                            for(int j=0;j<stCuriseList.astCruiseInfo[i].dwSize;j++)
                            {
                                Vector<String> PresetPointVector = new Vector<String>();
                                if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS)
                                {
                                     PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwID));
                                     PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwStayTime));
                                     PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed)); 
                                     System.out.println("VMS dwStayTime:"+stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwStayTime);
                                     System.out.println("VMS: dwSpeed"+stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed);
                                     NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                                }
                                else
                                {
                                     PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwPresetID));
                                     PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwStayTime/1000));
                                     if(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed<5) 
                                     {
                                        PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed)); 
                                     }
                                     else 
                                     {
                                        PresetPointVector.add(String.valueOf(stCuriseList.astCruiseInfo[i].astCruisePoint[j].dwSpeed-1));
                                     } 
                                     NetDemo.tablePTZExtendPresetPatrolsModel.addRow(PresetPointVector);
                                }
                           }
                      }    
                 }
             }    
        }
    }
}
