package main.java.com.netdevsdk.demo.util;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
 

public class ComboBoxTable extends JTable {
	 /**
	  * 序列化
	  */
	 private static final long serialVersionUID = 1L;
	 private int myRow = -1, myCol = -1;
	 TableCellEditor myEditor;

	 public void setComboCell(int r, int c, String[]items) {
			 this.myRow = r;
			 this.myCol = c;
			 TableCellEditor ce = new MyComboBoxEditor(items);
			 this.myEditor = ce;
	 }

	 @Override
	 public TableCellEditor getCellEditor(int row, int column) {
			 System.out.println(row + "," + column + ";" + myRow + "," + myCol + "," + myEditor);
			 if (row == myRow && column == myCol && myEditor != null)
					 return myEditor;
			 return super.getCellEditor(row, column);
	 }

	class MyComboBoxEditor extends DefaultCellEditor {
		 /**
		  * 
		  */
		 private static final long serialVersionUID = 1L;

		 public MyComboBoxEditor(String[] items) {
				 super(new JComboBox(items));
		 }
	}
	 
}