package main.java.com.netdevsdk.demo.vca.face;

import java.io.File;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ALARM_LOG_COND_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_ALARM_CMP_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_ALARM_IMAGE_AREA_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_ALARM_SNAP_IMAGE_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_MEMBER_ID_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_MEMBER_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_MEMBER_REGION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FACE_RECORD_SNAPSHOT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_LOGICTYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERYCOND_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_ALARM_LOG_RESULT_INFO_S;

/**
 * @description Alarm record query.
 * @introduction Support IPC/VMS.
 */
public class AlarmRecord {
    /**
     * @introduction Alarm record query.
     * @description It is mainly realized by calling the interface of NETDEV_FindFaceRecordDetailList.
     */
    public static void queryAlarmRecord() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        //数据量较大，建议采用分页形式展示
        String strBeginTime = NetDemo.PeopleAlarmStartTime.getText();
        String strEndTime = NetDemo.PeopleAlarmEndTime.getText();
        if(false == Common.isValidDate(strBeginTime, NetDemo.DateFormat) ||false == Common.isValidDate(strEndTime,NetDemo.DateFormat))
        {
            JOptionPane.showMessageDialog(null, "Please check that the time format is correct.");
            return;
        }
        long get1=Common.date2TimeStamp(strBeginTime,NetDemo.DateFormat);
        long get2=Common.date2TimeStamp(strEndTime, NetDemo.DateFormat);
        if(get1>get2) {
            JOptionPane.showMessageDialog(null, " Start time can not more than end time");
            return;
        }
        NETDEV_ALARM_LOG_COND_LIST_S stFindCond = new NETDEV_ALARM_LOG_COND_LIST_S();
        stFindCond.dwPageRow = 16;
        stFindCond.dwFirstRow = 0;
        stFindCond.dwCondSize = 4;
        stFindCond.astCondition[0] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[1] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[2] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[3] = new NETDEV_QUERY_INFO_S();
        stFindCond.astCondition[0].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_ALARMTYPE;
        stFindCond.astCondition[0].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_EQUAL;
        if(NetDemo.jComboBoxPersonMonitorType.getSelectedIndex() == 0)
        {
            Common.stringToByteArray("1018", stFindCond.astCondition[0].szConditionData);   //NETDEV_ALARM_SMART_FACE_MATCH_LIST
        }
        else if(NetDemo.jComboBoxPersonMonitorType.getSelectedIndex() == 1)
        {
            Common.stringToByteArray("1020", stFindCond.astCondition[0].szConditionData);   //NETDEV_ALARM_SMART_FACE_MISMATCH_LIST
        }
        stFindCond.astCondition[1].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[1].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_LESS;
        Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(strBeginTime, NetDemo.DateFormat)), stFindCond.astCondition[1].szConditionData);

        stFindCond.astCondition[2].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[2].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_NO_GREATER;
        Common.stringToByteArray(String.valueOf(Common.date2TimeStamp(strEndTime, NetDemo.DateFormat)), stFindCond.astCondition[2].szConditionData);

        stFindCond.astCondition[3].dwQueryType = NETDEV_QUERYCOND_TYPE_E.NETDEV_QUERYCOND_TIME;
        stFindCond.astCondition[3].dwLogicFlag = NETDEV_QUERYCOND_LOGICTYPE_E.NETDEV_QUERYCOND_LOGIC_DESC_ORDER;
        Common.stringToByteArray("", stFindCond.astCondition[3].szConditionData);   //NETDEV_ALARM_SMART_FACE_MATCH_LIST

        NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  stResultInfo = new NETDEV_SMART_ALARM_LOG_RESULT_INFO_S();
        boolean bRet = false;
        while(true)
        {
            Pointer lpFindRecordHandlePointer = NetDemo.netdevsdk.NETDEV_FindFaceRecordDetailList(NetDemo.lpUserID, stFindCond, stResultInfo);
            if(lpFindRecordHandlePointer != null)
            {
                while(true)
                {
                    NETDEV_FACE_RECORD_SNAPSHOT_INFO_S stRecordInfo = new NETDEV_FACE_RECORD_SNAPSHOT_INFO_S();
                    stRecordInfo.stCompareInfo = new NETDEV_FACE_ALARM_CMP_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo = new NETDEV_FACE_MEMBER_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberRegionInfo = new NETDEV_FACE_MEMBER_REGION_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberIDInfo = new NETDEV_FACE_MEMBER_ID_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberImageInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                    stRecordInfo.stCompareInfo.stMemberInfo.stMemberSemiInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;

                    stRecordInfo.stCompareInfo.stSnapshotImage = new NETDEV_FACE_ALARM_SNAP_IMAGE_S();
                    stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                    stRecordInfo.stCompareInfo.stSnapshotImage.stBigImage.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage = new NETDEV_FILE_INFO_S();
                    stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                    stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.udwSize = Common.NETDEMO_PICTURE_SIZE;
                    stRecordInfo.stCompareInfo.stSnapshotImage.stArea = new NETDEV_FACE_ALARM_IMAGE_AREA_S();

                    bRet = NetDemo.netdevsdk.NETDEV_FindNextFaceRecordDetail(lpFindRecordHandlePointer, stRecordInfo);
                    if(bRet == true)
                    {
                        String strTime = Common.getDate();
                        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 1)
                        {
                            String strFileNameBig = NetDemo.strPicturePath + strTime +"BigImage.jpg";
                            NETDEV_FILE_INFO_S stFileInfo = new NETDEV_FILE_INFO_S();
                            stFileInfo.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                            stFileInfo.udwSize = Common.NETDEMO_PICTURE_SIZE;
                             bRet = NetDemo.netdevsdk.NETDEV_GetFaceRecordImageInfo(NetDemo.lpUserID, stRecordInfo.udwRecordID, 0, stFileInfo);
                            if(bRet == true)
                            {
                                Common.savePicture(stFileInfo.pcData, stFileInfo.udwSize, strFileNameBig);
                            }else {
                                System.out.printf("Get picture failed failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                            }
                        }
                        String strFileNameSmall = NetDemo.strPicturePath + strTime +"SmallImage.jpg";
                        Common.savePicture(stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.pcData, stRecordInfo.stCompareInfo.stSnapshotImage.stSmallImage.udwSize, strFileNameSmall);
                    }
                    else
                    {
                        break;
                    }
                }
                bRet = NetDemo.netdevsdk.NETDEV_FindCloseFaceRecordDetail(lpFindRecordHandlePointer);
                if(bRet != true)
                {
                    System.out.printf("NETDEV_FindCloseFaceRecordDetail failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
                if(stFindCond.dwFirstRow >= stResultInfo.udwTotal)
                {
                    break;
                }
                stFindCond.dwFirstRow += stFindCond.dwPageRow;
            }
            else
            {   String strPicPath = System.getProperty("user.dir").replaceAll("%20"," ") + File.separator +"Picture";
                JOptionPane.showMessageDialog(null, "Query ended.The path:"+strPicPath);
                break;
            }
        }
    }
}
