package main.java.com.netdevsdk.demo.vca.face;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LAPI_SUB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SUBSCRIBE_SMART_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SUBSCRIBE_SUCC_INFO_S;

/**
 * @description Data report includes registerPersonAlarm,cancelregisterPersonAlarm,registerPersonRecognize and cancelPersonRecognize
 * @introduction Support IPC/VMS.
 */
public class PersonAlarm {
    /**
     * @introduction To register person alarm.
     * @description Calling the interface of NETDEV_SetPersonAlarmCallBack,NETDEV_SubscibeLapiAlarm and NETDEV_SetAlarmCallBack_V30 to realize.
     */
    public static void registerPersonAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetPersonAlarmCallBack(NetDemo.lpUserID, NetDemo.personAlarmMessCB, NetDemo.lpUserID);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "SetPersonAlarmCallBack failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetPersonAlarmCallBack failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 16;
            stSubInfo.udwLibIDNum = 0xffff;
            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.dwPersonRecognizeMointerID = stSubSuccInfo.udwID;
        }
        else
        {
            bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, NetDemo.cbAlarmMessCallBack, null);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 16;
            stSubInfo.udwLibIDNum =  0xffff;
            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.dwPersonRecognizeMointerID = stSubSuccInfo.udwID;
        }
    }
    /**
     * @introduction To cancel register person alarm.
     * @description Calling the interface of NETDEV_UnSubLapiAlarm and NETDEV_SetAlarmCallBack_V30 to realize.
     */
    public static void cancelRegisterPersonAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwPersonRecognizeMointerID);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwPersonRecognizeMointerID = -1;
        }
        else
        { 
            boolean bRet3 = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, null, null);
            if(false == bRet3)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwPersonRecognizeMointerID);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwPersonRecognizeMointerID = -1;
        }
    }
    
    /**
     * @introduction To register person recognize.
     * @description Calling the interface of NETDEV_SetStructAlarmCallBack,NETDEV_SubscibeLapiAlarm to realize.
     */
    public static void registerPersonRecognize() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.ChannelID)
        {
            JOptionPane.showMessageDialog(null, "Please select the device channel.");
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetStructAlarmCallBack(NetDemo.lpUserID, NetDemo.cbStructAlarmCallBack, NetDemo.lpUserID);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "NETDEV_SetStructAlarmCallBack failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetStructAlarmCallBack failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 32;
            stSubInfo.udwLibIDNum = 0xffff;

            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Register success");
            }

            NetDemo.PersonStructMointerID = stSubSuccInfo.udwID;
            
        }
        else
        {
            bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, NetDemo.cbAlarmMessCallBack, null);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            NETDEV_SUBSCRIBE_SMART_INFO_S stSubscribeInfo = new NETDEV_SUBSCRIBE_SMART_INFO_S();
            stSubscribeInfo.udwNum = 1;
            stSubscribeInfo.pudwSmartType = new Memory(4 * stSubscribeInfo.udwNum);
            stSubscribeInfo.pudwSmartType.setInt(0,0);
            NETDEV_SMART_INFO_S stSmartInfo = new NETDEV_SMART_INFO_S();
            stSmartInfo.dwChannelID = NetDemo.ChannelID;
            bRet = NetDemo.netdevsdk.NETDEV_SubscribeSmart(NetDemo.lpUserID, stSubscribeInfo, stSmartInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SubscribeSmart failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscribeSmart failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.PersonStructMointerID = stSmartInfo.udwSubscribeID;
        }
    }
    /**
     * @introduction To cancel register person recognize.
     * @description Calling the interface of NETDEV_UnSubLapiAlarm and NETDEV_SetAlarmCallBack_V30 to realize.
     */
    public static void cancelPersonRecognize() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 ==  NetDemo.ChannelID || 0 ==  NetDemo.PersonStructMointerID)
        {
            JOptionPane.showMessageDialog(null, "Please select the device channel.");
            return;
        }
        
        if( NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.PersonStructMointerID);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.PersonStructMointerID = -1;
        }
        else
        {
            boolean bRet3 = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, null, null);
            if(false == bRet3)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            NETDEV_SMART_INFO_S stSmartInfo = new NETDEV_SMART_INFO_S();
            stSmartInfo.dwChannelID = NetDemo.ChannelID;
            stSmartInfo.udwSubscribeID = NetDemo.PersonStructMointerID;
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnsubscribeSmart(NetDemo.lpUserID, stSmartInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_UnsubscribeSmart failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnsubscribeSmart failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.PersonStructMointerID=-1;
        }  
    }
}
