package main.java.com.netdevsdk.demo.vca.face;

import java.util.Vector;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.vca.face.PersonOperateWindow.PERSON_OPERATE_WINDOW_EFFECT;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATE_BASIC_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATE_MEMBER_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DELETE_DB_FLAG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_GENDER_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_ID_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_IMAGE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LIB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_LIB_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_REGION_INFO_S;
/**
 * @description This section includes managing the person lib and the person in the person lib.
 * @introduction The capacity of person lib only support IPC and other functions support IPC/VMS.
 */
public class PersonLib {
    /**
     * @description To add person in the person lib. 
     * @introduction It is realized mainly by the constructor of PersonOperateWindow.
     */
    public static void addPerson() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.jComboBoxPersonLib.getItemCount())
        {
            JOptionPane.showMessageDialog(null, "Please find person lib first.");
            return;
        }

        JFileChooser fcPictureChooser = new JFileChooser();
        //设置一个文件筛选器
        FileNameExtensionFilter filter=new FileNameExtensionFilter("picture file(jpg)", "jpg");
        fcPictureChooser.setFileFilter(filter);
        //设置不允许多选
        fcPictureChooser.setMultiSelectionEnabled(false);
        int result=fcPictureChooser.showSaveDialog(null);
        if (result==JFileChooser.APPROVE_OPTION)
        {
            NetDemo.strPersonChosePicurePath = fcPictureChooser.getSelectedFile().getAbsolutePath();
            PersonOperateWindow p=  new PersonOperateWindow(PERSON_OPERATE_WINDOW_EFFECT.PERSON_OPERATE_WINDOW_ADDPERSON);
            p.setVisible(true);
        }
        NetDemo.jButtonFindPerson.doClick();
    }
    /**
     * @description To delete person in the person lib.
     * @introduction Call the interface of NETDEV_DeletePersonInfo and NETDEV_DeletePersonInfoList to realize.
     */
    public static void deletePerson() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.PersonTableModel.getRowCount()  || NetDemo.jTablePerson.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find person or select person first.");
            return;
        }
        String strPersonName = (String) NetDemo.jTablePerson.getValueAt(NetDemo.jTablePerson.getSelectedRow(), 0);
        NETDEV_PERSON_INFO_S stPersonInfo = NetDemo.mapPersonInfo.get(strPersonName);
        String strPersonLibString = NetDemo.jComboBoxPersonLib.getItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(strPersonLibString);

        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            int dwLastChange = 0;
            boolean bRet = NetDemo.netdevsdk.NETDEV_DeletePersonInfo(NetDemo.lpUserID, stPersonLibInfo.udwID, stPersonInfo.udwPersonID, dwLastChange);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_DeletePersonInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_DeletePersonInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
        else
        {
            NETDEV_BATCH_OPERATE_MEMBER_LIST_S stIDList = new NETDEV_BATCH_OPERATE_MEMBER_LIST_S();
            stIDList.udwMemberNum = 1;
            stIDList.pstMemberIDList = new Memory(4);
            stIDList.pstMemberIDList.setInt(0, stPersonInfo.udwPersonID);

            NETDEV_BATCH_OPERATOR_LIST_S stResutList = new NETDEV_BATCH_OPERATOR_LIST_S();

            boolean bRet = NetDemo.netdevsdk.NETDEV_DeletePersonInfoList(NetDemo.lpUserID, stPersonLibInfo.udwID, stIDList, stResutList);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_DeletePersonInfoList failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_DeletePersonInfoList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
        NetDemo.jButtonFindPerson.doClick();
    
    }
    /**
     * @description To find person in  the person lib.
     * @introduction Call the interface of NETDEV_FindPersonInfoList to realize.
     */
    public static void findPerson() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.jComboBoxPersonLib.getItemCount())
        {
            JOptionPane.showMessageDialog(null, "Please find person lib first.");
            return;
        }

        NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(NetDemo.jComboBoxPersonLib.getItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex()));
        NETDEV_PERSON_QUERY_INFO_S stQueryInfo = new NETDEV_PERSON_QUERY_INFO_S();
        stQueryInfo.udwNum = 0;
        stQueryInfo.udwOffset =  0;
        stQueryInfo.udwLimit = 16;
        NETDEV_BATCH_OPERATE_BASIC_S stQueryResultInfo = new NETDEV_BATCH_OPERATE_BASIC_S();
        boolean bRet = false;
        NetDemo.PersonTableModel.setRowCount(0);
        NetDemo.mapPersonInfo.clear();
        while(true)
        {
            Pointer lpPersonFindHandle = NetDemo.netdevsdk.NETDEV_FindPersonInfoList(NetDemo.lpUserID, stPersonLibInfo.udwID, stQueryInfo, stQueryResultInfo);
            if(lpPersonFindHandle == null || stQueryResultInfo.udwTotal == 0)
            {
                System.out.printf("NETDEV_FindPersonInfoList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                break;
            }
            else
            {
                stQueryInfo.udwOffset += stQueryInfo.udwLimit;
                while(true)
                {
                    NETDEV_PERSON_INFO_S stPersonInfo = new NETDEV_PERSON_INFO_S();
                    stPersonInfo.stRegionInfo = new NETDEV_REGION_INFO_S();

                    stPersonInfo.stImageInfo[0] = new NETDEV_IMAGE_INFO_S();
                    stPersonInfo.stImageInfo[0].stFileInfo = new NETDEV_FILE_INFO_S();
                    stPersonInfo.stImageInfo[0].stFileInfo.udwSize = 1048576;
                    stPersonInfo.stImageInfo[0].stFileInfo.pcData = new Memory(stPersonInfo.stImageInfo[0].stFileInfo.udwSize);
                    stPersonInfo.write();
                    bRet = NetDemo.netdevsdk.NETDEV_FindNextPersonInfo(lpPersonFindHandle, stPersonInfo);
                    if(bRet != true)
                    {
                        break;
                    }
                    else
                    {
                        NetDemo.mapPersonInfo.put(String.valueOf(stPersonInfo.udwPersonID), stPersonInfo);
                        Vector<String> PersonLibVector = new Vector<String>();
                        PersonLibVector.add(String.valueOf(stPersonInfo.udwPersonID));
                        PersonLibVector.add(Common.byteArrayToString(stPersonInfo.szPersonName));

                        if(stPersonInfo.udwGender == NETDEV_GENDER_TYPE_E.NETDEV_GENDER_TYPE_MAN)
                        {
                            PersonLibVector.add("man");
                        }
                        else if(stPersonInfo.udwGender == NETDEV_GENDER_TYPE_E.NETDEV_GENDER_TYPE_WOMAN)
                        {
                            PersonLibVector.add("woman");
                        }
                        else
                        {
                            PersonLibVector.add("unknow");
                        }

                        PersonLibVector.add(Common.byteArrayToString(stPersonInfo.szBirthday));

                        PersonLibVector.add(Common.byteArrayToString(stPersonInfo.stRegionInfo.szNation));
                        PersonLibVector.add(Common.byteArrayToString(stPersonInfo.stRegionInfo.szProvince));
                        PersonLibVector.add(Common.byteArrayToString(stPersonInfo.stRegionInfo.szCity));

                        if(stPersonInfo.udwIdentificationNum > 0)
                        {
                            if(stPersonInfo.stIdentificationInfo[0].udwType == NETDEV_ID_TYPE_E.NETDEV_CERTIFICATE_TYPE_ID)
                            {
                                PersonLibVector.add("Identity card");
                            }
                            else if(stPersonInfo.stIdentificationInfo[0].udwType == NETDEV_ID_TYPE_E.NETDEV_CERTIFICATE_TYPE_PASSPORT)
                            {
                                PersonLibVector.add("Passport");
                            }
                            else if(stPersonInfo.stIdentificationInfo[0].udwType == NETDEV_ID_TYPE_E.NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE)
                            {
                                PersonLibVector.add("Driving license");
                            }
                            else
                            {
                                PersonLibVector.add("other");
                            }
                            PersonLibVector.add(Common.byteArrayToString(stPersonInfo.stIdentificationInfo[0].szNumber));
                        }
                        else
                        {
                            PersonLibVector.add("-");
                            PersonLibVector.add("-");
                        }

                        NetDemo.PersonTableModel.addRow(PersonLibVector);
                    }
                }
                bRet = NetDemo.netdevsdk.NETDEV_FindClosePersonInfoList(lpPersonFindHandle);
                if(bRet == false)
                {
                    System.out.printf("NETDEV_FindClosePersonInfoList failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
                }
            }
            if(stQueryInfo.udwOffset >= stQueryResultInfo.udwTotal)
            {
                break;
            }
        }
    }
    /**
     * @description To modify the person in the person lib.
     * @introduction It is mainly realized by the constructor of PersonOperateWindow.
     */
    public static void modifyPerson() {
        if(0 == NetDemo.PersonTableModel.getRowCount()  || NetDemo.jTablePerson.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find person or select person first.");
            return;
        }

        new PersonOperateWindow(PERSON_OPERATE_WINDOW_EFFECT.PERSON_OPERATE_WINDOW_MODIFYPERSON);
      }      
    /**
     * @introduction
     * @description
     */
    public static void addPersonLib() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        //弹出界面显示输入需要添加的库名字
        String strPersoLibName= JOptionPane.showInputDialog("Please input person lib name:");
        try {
            if(strPersoLibName==null||strPersoLibName.equals("")) 
            {
                JOptionPane.showMessageDialog(null, "Person lib name can not be null");
                return;
            }
        }catch(Exception n) {
            return;
        }
        //调用sdk接口添加库
        NETDEV_LIB_INFO_S stPersonLibInfo = new NETDEV_LIB_INFO_S();
        Common.stringToByteArray(strPersoLibName, stPersonLibInfo.szName);
        IntByReference dwLibID = new IntByReference();
        boolean bRet = NetDemo.netdevsdk.NETDEV_CreatePersonLibInfo(NetDemo.lpUserID, stPersonLibInfo, dwLibID);
        if(false == bRet)
        {
            System.out.printf("NETDEV_CreatePersonLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            JOptionPane.showMessageDialog(null, "NETDEV_CreatePersonLibInfo failed, error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                try {
                    PersonLibCapacityWindow.btnGet.doClick();
                    }catch(Exception l) {   
                        
                    }
                }
        }
        stPersonLibInfo.udwID = dwLibID.getValue();
        NetDemo.mapPersonLib.put(Common.byteArrayToString(stPersonLibInfo.szName), stPersonLibInfo);
        NetDemo.jComboBoxPersonLib.addItem(Common.byteArrayToString(stPersonLibInfo.szName));  
    }
    /**
     * @introduction
     * @description
     */
    public static void deletePersonLib() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if( NetDemo.jComboBoxPersonLib.getItemCount()<=0)
        {
            JOptionPane.showMessageDialog(null, "Please add person lib first.");
            return;
        }
        String strPersonLibString = NetDemo.jComboBoxPersonLib.getItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(strPersonLibString);
        NETDEV_DELETE_DB_FLAG_INFO_S stFlagInfo = new NETDEV_DELETE_DB_FLAG_INFO_S();
        stFlagInfo.bIsDeleteMember = 1;
        int ID=0;
        try {
            ID=stPersonLibInfo.udwID;
        }catch(Exception n) {
            JOptionPane.showMessageDialog(null, "No choose person lib");
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_DeletePersonLibInfo(NetDemo.lpUserID,ID, stFlagInfo);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "NETDEV_DeletePersonLibInfo failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_DeletePersonLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else {
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                try {
                    PersonLibCapacityWindow.btnGet.doClick();
                    }catch(Exception l) {   
                        
                    }
                }
            }
        NetDemo.jComboBoxPersonLib.removeItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex());
        NetDemo.mapPersonLib.remove(strPersonLibString);
    }
    /**
     * @introduction
     * @description
     */
    public static void modifyPersonLib() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        String strPersoLibName = JOptionPane.showInputDialog("Please input new person lib name:");
        try {
            if(strPersoLibName==null||strPersoLibName.equals("")) {
                JOptionPane.showMessageDialog(null, "Person lib name can not be null");
                return;
            }
        }catch(Exception m) {
            return;
        }
        
        NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(NetDemo.jComboBoxPersonLib.getItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex()));
        if(strPersoLibName==null||strPersoLibName.equals("")) {
            JOptionPane.showMessageDialog(null, "Person lib name can not be null");
            return;
        }
        Common.stringToByteArray(strPersoLibName, stPersonLibInfo.szName);
        stPersonLibInfo.write();
        NETDEV_PERSON_LIB_LIST_S stPersonLibList = new NETDEV_PERSON_LIB_LIST_S();
        stPersonLibList.udwNum = 1;
        stPersonLibList.pstLibInfo = stPersonLibInfo.getPointer();
        boolean bRet = NetDemo.netdevsdk.NETDEV_ModifyPersonLibInfo(NetDemo.lpUserID, stPersonLibList);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "NETDEV_ModifyPersonLibInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_ModifyPersonLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
                    NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS) {
                try {
                    PersonLibCapacityWindow.btnGet.doClick();
                    }catch(Exception l) {   
                        
                    }
                }
        }
        NetDemo.mapPersonLib.remove(NetDemo.jComboBoxPersonLib.getItemAt(NetDemo.jComboBoxPersonLib.getSelectedIndex()));
        NetDemo.mapPersonLib.put(strPersoLibName, stPersonLibInfo);
        int dwCurrentindex = NetDemo.jComboBoxPersonLib.getSelectedIndex();
        NetDemo.jComboBoxPersonLib.removeItemAt(dwCurrentindex);
        NetDemo.jComboBoxPersonLib.insertItemAt(strPersoLibName, dwCurrentindex);
    }
    /**
     * @introduction
     * @description
     */
    public static void findPersonLib() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = false;
        NetDemo.jComboBoxPersonLib.removeAllItems();
        NetDemo.mapPersonLib.clear();
        Pointer pPersonLibHandle = NetDemo.netdevsdk.NETDEV_FindPersonLibList(NetDemo.lpUserID);
        if(null == pPersonLibHandle)
        {
            System.out.printf("NETDEV_FindPersonLibList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else
        {
            while(true)
            {
                NETDEV_LIB_INFO_S stPersonLibInfo = new NETDEV_LIB_INFO_S();
                bRet = NetDemo.netdevsdk.NETDEV_FindNextPersonLibInfo(pPersonLibHandle, stPersonLibInfo);
                if(false == bRet)
                {
                    System.out.printf("NETDEV_FindNextPersonLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    break;
                }
                NetDemo.jComboBoxPersonLib.addItem(Common.byteArrayToString(stPersonLibInfo.szName));
                NetDemo.mapPersonLib.put(Common.byteArrayToString(stPersonLibInfo.szName), stPersonLibInfo);
                
            }
            bRet = NetDemo.netdevsdk.NETDEV_FindClosePersonLibList(pPersonLibHandle);
            if(false == bRet)
            {
                System.out.printf("NETDEV_FindClosePersonLibList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
    }
    /**
     * @introduction
     * @description
     */
    public static void Capacity() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        PersonLibCapacityWindow p=new PersonLibCapacityWindow(NetDemo.lpUserID);
        p.setVisible(true);
    }
    
}
