package main.java.com.netdevsdk.demo.vca.face;

import javax.swing.JDialog;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Map;
import java.util.Vector;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.util.Common.NETDEMO_DEVICE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LIB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LINKAGE_STRATEGY_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_CHL_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_RULE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_RESULT_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_DAY_PLAN_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_TIME_SECTION_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VIDEO_WEEK_PLAN_S;

import javax.swing.JComboBox;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class PersonMonitor extends JDialog{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	JPanel PersonMonitorPanel = new JPanel();
	JLabel lblPersonMonitorTaskName = new JLabel("* Task name");
	JTextField textFieldPersonMonitorTaskName = new JTextField();
	JLabel lblPersonMonitorType = new JLabel("* Monitor type");
	JRadioButton rdbtnPersonMonitorType = new JRadioButton("Match alarm");
	JRadioButton rdbtnPersonMonitorNoMatch = new JRadioButton("No match alarm");
	JLabel lblPersonMonitorDescribe = new JLabel("Describe");
	JTextField textFieldPersonMonitorDescribe = new JTextField();
	JLabel lblPersonAlarmObject = new JLabel("* Monitor object");
	JRadioButton rdbtnPersonAlarmObjectPersonLib = new JRadioButton("Person lib");
//	JRadioButton rdbtnPersonAlarmObjectPersonFace = new JRadioButton("Person face");
	JPanel panelPersonMonitorPersonLib = new JPanel();
	JComboBox<String> comboBoxPersonMonitorPersonLib = new JComboBox<String>();
	JButton btnPersonMonitorComplate = new JButton("Complete");
	JButton btnPersonMonitorCancle = new JButton("Cancel");
	
	JButton btnFindPersonLib;
	JButton btnFindPersonMonitor;
	
	public String strPersonMonitorName;
	
	NetDEVSDKLib netdevsdk = NetDEVSDKLib.NETDEVSDK_INSTANCE;
	private JTextField txtMultiplevalue;
	
	public static class PERSON_MONITOR_OPERATE_WINDOW_EFFECT{
	    public static final int PERSON_MONITOR_OPERATE_WINDOW_ADDPERSONMONITOR             = 1;        /* 添加人脸布控 */
	    public static final int PERSON_MONITOR_OPERATE_WINDOW_MODIFYPERSONMONITOR          = 2;        /* 修改人脸布控 */
	}

	public PersonMonitor(int dwOperateType,JButton btnFindPersonLib,JButton btnFindPersonMonitor,String strPersonMonitorName) {
		this.setSize(689,600);
		setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		this.setTitle("Add Person monitor");
		this.setVisible(true);
		this.btnFindPersonLib=btnFindPersonLib;
		this.btnFindPersonMonitor=btnFindPersonMonitor;
		
		
		this.strPersonMonitorName=strPersonMonitorName;;
		
		btnFindPersonLib.doClick();
		
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        Dimension screenSize =toolkit.getScreenSize();
        int x=(screenSize.width-this.getWidth())/2;
        int y=(screenSize.height-this.getHeight())/2;
        this.setLocation(x,y);
		
		getContentPane().add(PersonMonitorPanel, BorderLayout.CENTER);
		PersonMonitorPanel.setLayout(null);
		
		JLabel lblPersonMonitorTaskName = new JLabel("* Task name");
		lblPersonMonitorTaskName.setBounds(24, 10, 90, 15);
		PersonMonitorPanel.add(lblPersonMonitorTaskName);
		
		
		textFieldPersonMonitorTaskName.setBounds(126, 7, 483, 21);
		PersonMonitorPanel.add(textFieldPersonMonitorTaskName);
		textFieldPersonMonitorTaskName.setColumns(10);
		
		
		lblPersonMonitorType.setBounds(24, 46, 90, 15);
		PersonMonitorPanel.add(lblPersonMonitorType);
		
		
		rdbtnPersonMonitorType.setBounds(126, 42, 121, 23);
		PersonMonitorPanel.add(rdbtnPersonMonitorType);
		
		
		rdbtnPersonMonitorNoMatch.setBounds(312, 42, 121, 23);
		PersonMonitorPanel.add(rdbtnPersonMonitorNoMatch);
		
		ButtonGroup MonitorTypeGroup = new ButtonGroup();
		MonitorTypeGroup.add(rdbtnPersonMonitorType);
		MonitorTypeGroup.add(rdbtnPersonMonitorNoMatch);
		
		
		lblPersonMonitorDescribe.setBounds(37, 83, 54, 15);
		PersonMonitorPanel.add(lblPersonMonitorDescribe);
		
		
		textFieldPersonMonitorDescribe.setBounds(126, 80, 483, 21);
		PersonMonitorPanel.add(textFieldPersonMonitorDescribe);
		textFieldPersonMonitorDescribe.setColumns(10);
		
		
		lblPersonAlarmObject.setBounds(24, 120, 96, 15);
		PersonMonitorPanel.add(lblPersonAlarmObject);
		
		
		rdbtnPersonAlarmObjectPersonLib.setBounds(126, 116, 121, 23);
		PersonMonitorPanel.add(rdbtnPersonAlarmObjectPersonLib);
		
		
	
		ButtonGroup MonitorObjectGroup = new ButtonGroup();
		MonitorObjectGroup.add(rdbtnPersonAlarmObjectPersonLib);
		
		JLabel lblNewMultipleValue = new JLabel("MultipleValue");
		lblNewMultipleValue.setBounds(37, 155, 84, 15);
		PersonMonitorPanel.add(lblNewMultipleValue);
		
		txtMultiplevalue = new JTextField();
		txtMultiplevalue.setBounds(126, 152, 90, 21);
		PersonMonitorPanel.add(txtMultiplevalue);
		txtMultiplevalue.setColumns(10);
		txtMultiplevalue.setEnabled(true);

		
		
		panelPersonMonitorPersonLib.setBorder(new TitledBorder(null, "Person Lib", TitledBorder.LEADING, TitledBorder.TOP, null, null));
		panelPersonMonitorPersonLib.setBounds(24, 187, 618, 174);
		PersonMonitorPanel.add(panelPersonMonitorPersonLib);
		panelPersonMonitorPersonLib.setLayout(null);
		
		
		comboBoxPersonMonitorPersonLib.setBounds(10, 26, 170, 21);
		panelPersonMonitorPersonLib.add(comboBoxPersonMonitorPersonLib);
		
		
		if(dwOperateType ==PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_ADDPERSONMONITOR)
		{
			this.setTitle("Add Person monitor");
			AddPersonMonitorInit();
		}
		else if(dwOperateType ==PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_MODIFYPERSONMONITOR)
		{
			this.setTitle("Modify Person monitor");
			
			
			
//			String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
			NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);
			
			ModifyPesonLibMonitorInit();
			
			textFieldPersonMonitorTaskName.setText(Common.byteArrayToString(stPersonMonitorInfo.stMonitorRuleInfo.szName));
			if(stPersonMonitorInfo.stMonitorRuleInfo.udwMonitorType == 0)
			{
				rdbtnPersonMonitorType.setSelected(true);
			}
			else
			{
				rdbtnPersonMonitorNoMatch.setSelected(true);
			}
			
			textFieldPersonMonitorDescribe.setText(Common.byteArrayToString(stPersonMonitorInfo.stMonitorRuleInfo.szReason));
			
			try {
				txtMultiplevalue.setText(String.valueOf(stPersonMonitorInfo.stMonitorRuleInfo.udwMultipleValue));
			}catch(Exception mt) {
				
			}
		
			
			rdbtnPersonAlarmObjectPersonLib.setSelected(true);
			
			
			rdbtnPersonAlarmObjectPersonLib.setEnabled(false);
			comboBoxPersonMonitorPersonLib.setEnabled(false);
			rdbtnPersonMonitorType.setEnabled(false);
			rdbtnPersonMonitorNoMatch.setEnabled(false);
		}
		
		btnPersonMonitorComplate.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				if(dwOperateType == PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_ADDPERSONMONITOR)
				{
					NETDEV_MONITION_INFO_S stMonitorInfo = new NETDEV_MONITION_INFO_S();
					stMonitorInfo.stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();
					stMonitorInfo.stMonitorRuleInfo.udwMonitorRuleType=1;
					stMonitorInfo.stMonitorRuleInfo.bEnabled = 1;
					Common.stringToByteArray(textFieldPersonMonitorTaskName.getText(), stMonitorInfo.stMonitorRuleInfo.szName);
					Common.stringToByteArray(textFieldPersonMonitorDescribe.getText(), stMonitorInfo.stMonitorRuleInfo.szReason);
					
					int Multiplevalue=0;
					try {
						String getMultiplevalue=txtMultiplevalue.getText();
						Multiplevalue=Integer.parseInt(getMultiplevalue);
					}
					
					catch(Exception tt) {
						
					}
					stMonitorInfo.stMonitorRuleInfo.udwMultipleValue=Multiplevalue;
					
					
					 if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
	 							NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
	 							NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
	 							NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS
	 						){
							 
							 stMonitorInfo.stWeekPlan=new  NETDEV_VIDEO_WEEK_PLAN_S();
							 
							 stMonitorInfo.stWeekPlan.bEnabled=1;
							 
							 stMonitorInfo.stWeekPlan.udwDayNum=7;
								for(int i=0;i<stMonitorInfo.stWeekPlan.udwDayNum;i++) {
									stMonitorInfo.stWeekPlan.astDayPlan[i]=new NETDEV_VIDEO_DAY_PLAN_S();
									
									stMonitorInfo.stWeekPlan.astDayPlan[i].udwIndex=i+1;
									if(stMonitorInfo.stWeekPlan.astDayPlan[i].udwIndex-1==i) {
										stMonitorInfo.stWeekPlan.astDayPlan[i].udwSectionNum=1;
										
										for(int j=0;j<stMonitorInfo.stWeekPlan.astDayPlan[i].udwSectionNum;j++) {
											
											stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j]=new NETDEV_VIDEO_TIME_SECTION_S();
											Common.stringToByteArray("00:00:00", stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j].szBeginTime);
											Common.stringToByteArray("23:59:59", stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j].szEndTime);
										}
									}

								}
						 }else if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR||
								 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
								 NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP){
							 stMonitorInfo.stWeekPlan=new  NETDEV_VIDEO_WEEK_PLAN_S();
							 
							 
							 stMonitorInfo.stWeekPlan.udwDayNum=8;
								for(int i=0;i<stMonitorInfo.stWeekPlan.udwDayNum;i++) {
									stMonitorInfo.stWeekPlan.astDayPlan[i]=new NETDEV_VIDEO_DAY_PLAN_S();
									
									stMonitorInfo.stWeekPlan.astDayPlan[i].udwIndex=i+1;
									if(stMonitorInfo.stWeekPlan.astDayPlan[i].udwIndex-1==i) {
										stMonitorInfo.stWeekPlan.astDayPlan[i].udwSectionNum=1;
										
										for(int j=0;j<stMonitorInfo.stWeekPlan.astDayPlan[i].udwSectionNum;j++) {
											
											stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j]=new NETDEV_VIDEO_TIME_SECTION_S();
											Common.stringToByteArray("00:00:00", stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j].szBeginTime);
											Common.stringToByteArray("24:00:00", stMonitorInfo.stWeekPlan.astDayPlan[i].astTimeSection[j].szEndTime);
										}
									}
								}
						 }
	
					if(rdbtnPersonMonitorType.isSelected() == true)
					{
						stMonitorInfo.stMonitorRuleInfo.udwMonitorType = 0;
					}
					else
					{
						stMonitorInfo.stMonitorRuleInfo.udwMonitorType = 1;
					}
					stMonitorInfo.stMonitorRuleInfo.udwLibNum = 1;		
					
					
					NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(comboBoxPersonMonitorPersonLib.getItemAt(comboBoxPersonMonitorPersonLib.getSelectedIndex()));
					 if(stPersonLibInfo==null) {
                         JOptionPane.showMessageDialog(null, "There are no person libraries to use. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                         return;
                     }
					stMonitorInfo.stMonitorRuleInfo.audwLibList[0] = stPersonLibInfo.udwID;
	                
					
					if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 1)
					{
						stMonitorInfo.stMonitorRuleInfo.udwDevNum = 1;
						//根据通道号查找设备ID
						for(int i =0; i< NetDemo.gastLoginDeviceInfo.dwDevNum; i++)
						{
							NETDEMO_DEVICE_INFO_S stDemoDeviceInfo = NetDemo.gastLoginDeviceInfo.stDevLoginInfo.get(i);
							for(int j = 0; j< stDemoDeviceInfo.vecChanInfo.size(); j++)
							{
								if(NetDemo.ChannelID == stDemoDeviceInfo.vecChanInfo.get(j).stChnBaseInfo.dwChannelID)
								{
									stMonitorInfo.stMonitorRuleInfo.audwMonitorDevIDList[0] = stDemoDeviceInfo.stDevBasicInfo.dwDevID;
									break;
								}
							}
						}
					}
					else if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
					{
						stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 1;
						stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = new Memory(4);
						stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList.setInt(0, NetDemo.ChannelID);
					}

					
					NETDEV_MONITOR_RESULT_INFO_S stMonitorResultInfo = new NETDEV_MONITOR_RESULT_INFO_S();
					stMonitorResultInfo.udwChannelNum = 1;
					NETDEV_MONITION_CHL_INFO_S stMonitorChlInfos = new NETDEV_MONITION_CHL_INFO_S(); 
					stMonitorChlInfos.write();
					stMonitorResultInfo.pstMonitorChlInfos = stMonitorChlInfos.getPointer();
					
					
					
					boolean bRet = netdevsdk.NETDEV_AddPersonMonitorInfo(NetDemo.lpUserID, stMonitorInfo, stMonitorResultInfo);
					if(false == bRet)
					{
			    		System.out.printf("NETDEV_AddPersonMonitorInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
			    		return;
					}
				}
				else if(dwOperateType == PERSON_MONITOR_OPERATE_WINDOW_EFFECT.PERSON_MONITOR_OPERATE_WINDOW_MODIFYPERSONMONITOR) 
				{
					String strPersonMonitorName = (String) NetDemo.PersonMonitorTable.getValueAt(NetDemo.PersonMonitorTable.getSelectedRow(), 0);
					NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);
					
					
					
					boolean bRet = false;
					
					if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 1)
					{
						bRet = netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
						if(false == bRet)
						{
				    		System.out.printf("NETDEV_GetPersonMonitorRuleInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
				    		return;
						}else {
							stPersonMonitorInfo.stMonitorRuleInfo.udwLibNum = 1;		
							NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(comboBoxPersonMonitorPersonLib.getItemAt(comboBoxPersonMonitorPersonLib.getSelectedIndex()));
							stPersonMonitorInfo.stMonitorRuleInfo.audwLibList[0] = stPersonLibInfo.udwID;
						}
					}
					else if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
					{
						stPersonMonitorInfo.udwLinkStrategyNum = 0;
						stPersonMonitorInfo.stMonitorRuleInfo.udwLibNum = 1;		
						NETDEV_LIB_INFO_S stPersonLibInfo = NetDemo.mapPersonLib.get(comboBoxPersonMonitorPersonLib.getItemAt(comboBoxPersonMonitorPersonLib.getSelectedIndex()));
						stPersonMonitorInfo.stMonitorRuleInfo.audwLibList[0] = stPersonLibInfo.udwID;
						
					}
					
					Common.stringToByteArray(textFieldPersonMonitorTaskName.getText(), stPersonMonitorInfo.stMonitorRuleInfo.szName);
					Common.stringToByteArray(textFieldPersonMonitorDescribe.getText(), stPersonMonitorInfo.stMonitorRuleInfo.szReason);
					
					int Multiplevalue=0;
					try {
						String getMultiplevalue=txtMultiplevalue.getText();
						Multiplevalue=Integer.parseInt(getMultiplevalue);
					}
					
					catch(Exception tt) {
						
					}
					stPersonMonitorInfo.stMonitorRuleInfo.udwMultipleValue=Multiplevalue;
					
					
					stPersonMonitorInfo.write();
					
					bRet = netdevsdk.NETDEV_SetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
					if(false == bRet)
					{
			    		System.out.printf("NETDEV_SetPersonMonitorRuleInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
			    		return;
					}
				}
				
				dispose();
				btnFindPersonMonitor.doClick();
			}
		});
		
		
		btnPersonMonitorComplate.setBounds(363, 414, 108, 23);
		PersonMonitorPanel.add(btnPersonMonitorComplate);
		btnPersonMonitorCancle.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		});
		
		
		btnPersonMonitorCancle.setBounds(549, 414, 93, 23);
		PersonMonitorPanel.add(btnPersonMonitorCancle);
		
	
		

	}
	
	void AddPersonMonitorInit()
	{
		
		
			if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS
					){
				for(Map.Entry<String, NETDEV_LIB_INFO_S> entry : NetDemo.mapPersonLib.entrySet())
				{
					String strPersonLibNameString = entry.getKey();
					
					
					NETDEV_LIB_INFO_S stPersonLibInfo =entry.getValue();
					if(stPersonLibInfo.udwID==1) {
						continue;
					}else if(stPersonLibInfo.udwMemberNum==0) {
						continue;
					}
					else {
						comboBoxPersonMonitorPersonLib.addItem(strPersonLibNameString);
					}
				}
			}else 
				if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC ||
						NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_FISHEYE ||
								NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE ||
										NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_IPC_ACS||NetDemo.pstDeviceInfo.dwDeviceType ==NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR||
										NetDemo.pstDeviceInfo.dwDeviceType ==NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_NVR_BACKUP||NetDemo.pstDeviceInfo.dwDeviceType ==NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_HNVR
			){
				for(Map.Entry<String, NETDEV_LIB_INFO_S> entry : NetDemo.mapPersonLib.entrySet())
				{
					String strPersonLibNameString = entry.getKey();
					
					comboBoxPersonMonitorPersonLib.addItem(strPersonLibNameString);
					
				}
			}
			
		
 
	}
	
	
void ModifyPesonLibMonitorInit() {
		
		
	btnFindPersonLib.doClick();
		
	comboBoxPersonMonitorPersonLib.setEnabled(false);
	
	NETDEV_MONITION_INFO_S stPersonMonitorInfo = NetDemo.mapPersonMonitorMap.get(strPersonMonitorName);
	
	 boolean bRet2 = netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
			if(false == bRet2)
			{
				if(netdevsdk.NETDEV_GetLastError()!=130) {
					System.out.printf("GetPersonMonitorRuleInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
		    		return;
				}
				else {
					stPersonMonitorInfo.read();
					stPersonMonitorInfo.write();
					bRet2 = netdevsdk.NETDEV_GetPersonMonitorRuleInfo(NetDemo.lpUserID, stPersonMonitorInfo);
					if(bRet2) {
						stPersonMonitorInfo.read();						
						NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = new NETDEV_MONITOR_QUERY_INFO_S();
						stQueryInfo.udwLimit = 20;
						
						Pointer lpPersonMonitorHandle = netdevsdk.NETDEV_FindPersonMonitorList(NetDemo.lpUserID, NetDemo.ChannelID, stQueryInfo);
				        if(lpPersonMonitorHandle != null)
				        {
							while(true)
							{
								NETDEV_MONITION_INFO_S stMonitorInfo = new NETDEV_MONITION_INFO_S();
								stMonitorInfo.stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();

								stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 1;
								stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = new Memory(4 * stMonitorInfo.stMonitorRuleInfo.udwChannelNum);
								stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList.setInt(0, 0);

								stMonitorInfo.udwLinkStrategyNum = 10;
								NETDEV_LINKAGE_STRATEGY_S stLinkStrategyList = new NETDEV_LINKAGE_STRATEGY_S();

								stMonitorInfo.pstLinkStrategyList = new Memory(stLinkStrategyList.size() * 10);



								stMonitorInfo.stWeekPlan = new NETDEV_VIDEO_WEEK_PLAN_S();
								for(int i =0; i < NetDEVSDKLib.NETDEV_MAX_DAY_NUM; i++)
								{
									stMonitorInfo.stWeekPlan.astDayPlan[i] = new NETDEV_VIDEO_DAY_PLAN_S();
								}
								stMonitorInfo.write();

								boolean bbRet = netdevsdk.NETDEV_FindNextPersonMonitorInfo(lpPersonMonitorHandle, stMonitorInfo);
				                if(bbRet != true)
				                {
				                	System.out.printf("NETDEV_FindNextPersonMonitorInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
				                    break;
				                }
				                else
				                {
				                	comboBoxPersonMonitorPersonLib.removeAllItems();
				                	
									for(Map.Entry<String, NETDEV_LIB_INFO_S> entry : NetDemo.mapPersonLib.entrySet())
									{
										
										NETDEV_LIB_INFO_S lib2=entry.getValue();
										
										
										String strPersonLibNameString = entry.getKey();
										
										comboBoxPersonMonitorPersonLib.addItem(strPersonLibNameString);
										if(lib2.udwID==stPersonMonitorInfo.stMonitorRuleInfo.audwLibList[0]) {
											
											for(int s=0;s<comboBoxPersonMonitorPersonLib.getItemCount();s++) {
												if(comboBoxPersonMonitorPersonLib.getItemAt(s).equals(Common.byteArrayToString(lib2.szName))) {
													comboBoxPersonMonitorPersonLib.setSelectedIndex(s);
												}
											}
//											comboBoxPersonMonitorPersonLib.addItem(Common.byteArrayToString(lib2.szName));
										}
									}
				                	
								}
							}
							boolean bRett = netdevsdk.NETDEV_FindClosePersonMonitorList(lpPersonMonitorHandle);
			                if(bRett != true)
			                {
			                	System.out.printf("NETDEV_FindClosePersonMonitorList failed:%d\n", netdevsdk.NETDEV_GetLastError());
			                    return;
			                }
						}
						
					}
				}
			}
			else 
				{
				stPersonMonitorInfo.read();				
				NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = new NETDEV_MONITOR_QUERY_INFO_S();
				stQueryInfo.udwLimit = 20;
				
				Pointer lpPersonMonitorHandle = netdevsdk.NETDEV_FindPersonMonitorList(NetDemo.lpUserID, NetDemo.ChannelID, stQueryInfo);
		        if(lpPersonMonitorHandle != null)
		        {
					while(true)
					{
						NETDEV_MONITION_INFO_S stMonitorInfo = new NETDEV_MONITION_INFO_S();
						stMonitorInfo.stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();

						stMonitorInfo.stMonitorRuleInfo.udwChannelNum = 1;
						stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList = new Memory(4 * stMonitorInfo.stMonitorRuleInfo.udwChannelNum);
						stMonitorInfo.stMonitorRuleInfo.pudwMonitorChlIDList.setInt(0, 0);

						stMonitorInfo.udwLinkStrategyNum = 10;
						NETDEV_LINKAGE_STRATEGY_S stLinkStrategyList = new NETDEV_LINKAGE_STRATEGY_S();

						stMonitorInfo.pstLinkStrategyList = new Memory(stLinkStrategyList.size() * 10);



						stMonitorInfo.stWeekPlan = new NETDEV_VIDEO_WEEK_PLAN_S();
						for(int i =0; i < NetDEVSDKLib.NETDEV_MAX_DAY_NUM; i++)
						{
							stMonitorInfo.stWeekPlan.astDayPlan[i] = new NETDEV_VIDEO_DAY_PLAN_S();
						}
						stMonitorInfo.write();

						boolean bbRet = netdevsdk.NETDEV_FindNextPersonMonitorInfo(lpPersonMonitorHandle, stMonitorInfo);
		                if(bbRet != true)
		                {
		                	System.out.printf("NETDEV_FindNextPersonMonitorInfo failed:%d\n", netdevsdk.NETDEV_GetLastError());
		                    break;
		                }
		                else
		                {
		                	comboBoxPersonMonitorPersonLib.removeAllItems();
		                	
							for(Map.Entry<String, NETDEV_LIB_INFO_S> entry : NetDemo.mapPersonLib.entrySet())
							{
								
								NETDEV_LIB_INFO_S lib2=entry.getValue();
								
								
								String strPersonLibNameString = entry.getKey();
								
								comboBoxPersonMonitorPersonLib.addItem(strPersonLibNameString);
								if(lib2.udwID==stPersonMonitorInfo.stMonitorRuleInfo.audwLibList[0]) {
									
									for(int s=0;s<comboBoxPersonMonitorPersonLib.getItemCount();s++) {
										if(comboBoxPersonMonitorPersonLib.getItemAt(s).equals(Common.byteArrayToString(lib2.szName))) {
											comboBoxPersonMonitorPersonLib.setSelectedIndex(s);
										}
									}
								}
							}
		                	
						}
					}
					boolean bRett = netdevsdk.NETDEV_FindClosePersonMonitorList(lpPersonMonitorHandle);
	                if(bRett != true)
	                {
	                	System.out.printf("NETDEV_FindClosePersonMonitorList failed:%d\n", netdevsdk.NETDEV_GetLastError());
	                    return;
	                }
				}
				
				
		}
	}
}
