package main.java.com.netdevsdk.demo.vca.vehicle;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.vca.vehicle.VehicleMonitor.VEHICLE_MONITOR_OPERATE_WINDOW_EFFECT;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DEVICE_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITION_RULE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_MONITOR_QUERY_INFO_S;

/**
 * @description VCA/Vehicle Monitor includes add,delete,modify,find  the information of vehicle monitor
 * @introduction Only support VMS.
 */
public class VCAVehicleMonitor {
    /**
     * @introduction To add vehicle monitor information.
     * @description It is mainly realized by the constructor of VehicleMonitor.
     */
    public static void addVehicleMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.pstDeviceInfo.dwDeviceType == NETDEV_DEVICE_TYPE_E.NETDEV_DTYPE_VMS ) 
        {
            VehicleMonitor vm=new VehicleMonitor(VEHICLE_MONITOR_OPERATE_WINDOW_EFFECT.VEHICLE_MONITOR_OPERATE_WINDOW_ADDVEHICLEMONITOR,NetDemo.jButtonVehicleLibFind,NetDemo.jButtonFindVehicleMonitor);
            vm.setVisible(true);
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "only support VMS");
            return;
        }
    }
    /**
     * @introduction To delete vehicle monitor information.
     * @description Calling the interface of NETDEV_DeleteVehicleMonitorInfo to realize.
     */
    public static void deleteVehicleMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.jTableVehicleMonitor.getRowCount() || NetDemo.jTableVehicleMonitor.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor and select monitor first!");
            return;
        }
        String strVehicleMonitorName = (String) NetDemo.jTableVehicleMonitor.getValueAt(NetDemo.jTableVehicleMonitor.getSelectedRow(), 0);
        NETDEV_MONITION_INFO_S stVehicleMonitorInfo = NetDemo.mapVehicleMonitorMap.get(strVehicleMonitorName);
        NETDEV_BATCH_OPERATOR_LIST_S stResultList = new NETDEV_BATCH_OPERATOR_LIST_S();
        stResultList.udwNum = 1;
        NETDEV_BATCH_OPERATOR_INFO_S stBatchList = new NETDEV_BATCH_OPERATOR_INFO_S();
        stBatchList.udwID = stVehicleMonitorInfo.udwID;
        stBatchList.write();
        stResultList.pstBatchList = stBatchList.getPointer();
        boolean bRet = NetDemo.netdevsdk.NETDEV_DeleteVehicleMonitorInfo(NetDemo.lpUserID, stResultList);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "Delete falied,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_DeleteVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else 
        {
            JOptionPane.showMessageDialog(null, "Delete success");
            NetDemo.jButtonFindVehicleMonitor.doClick();
        }
    
    }
    /**
     * @introduction To modify vehicle monitor information.
     * @description It is mainly realized by the constructor of VehicleMonitor.
     */
    public static void modifyVehicleMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.jTableVehicleMonitor.getRowCount() || NetDemo.jTableVehicleMonitor.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor and select monitor first!");
            return;
        }

        VehicleMonitor vvm=new VehicleMonitor(VEHICLE_MONITOR_OPERATE_WINDOW_EFFECT.VEHICLE_MONITOR_OPERATE_WINDOW_MODIFYVEHICLEMONITOR,NetDemo.jButtonVehicleLibFind,NetDemo.jButtonFindVehicleMonitor);
        vvm.setVisible(true);
    }
    /** 
     * @introduction To find vehicle monitor information.
     * @description Calling the interface of NETDEV_FindVehicleMonitorList and NETDEV_FindCloseVehicleMonitorList to realize.
     */
    public static void findVehicleMonitor() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.mapVehicleMonitorMap.clear();
        NetDemo.VehicleMonitorTableModel.setRowCount(0);
        boolean bRet = false;
        NETDEV_MONITOR_QUERY_INFO_S stQueryInfo = new NETDEV_MONITOR_QUERY_INFO_S();
        stQueryInfo.udwLimit = 20;
        Pointer lpVehicleMonitorHandle = NetDemo.netdevsdk.NETDEV_FindVehicleMonitorList(NetDemo.lpUserID);
        if(lpVehicleMonitorHandle == null)
        {
            System.out.printf("NETDEV_FindVehicleMonitorList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        else
        {
            while(true)
            {
                NETDEV_MONITION_INFO_S stMonitorInfo = new NETDEV_MONITION_INFO_S();
                bRet = NetDemo.netdevsdk.NETDEV_FindNextVehicleMonitorInfo(lpVehicleMonitorHandle, stMonitorInfo);
                if(bRet != true)
                {
                    System.out.printf("NETDEV_FindNextVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    break;
                }
                else
                {
                    //显示查询数据
                    Vector<String> VehicleMonitorVector = new Vector<String>();
                    VehicleMonitorVector.add(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szName));
                    VehicleMonitorVector.add(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szReason));
                    if(stMonitorInfo.stMonitorRuleInfo.udwMonitorType == 0)
                    {
                        VehicleMonitorVector.add("match");
                    }
                    else
                    {
                        VehicleMonitorVector.add("not match");
                    }
                    if(stMonitorInfo.stMonitorRuleInfo.bEnabled == 1)
                    {
                        VehicleMonitorVector.add("enable");
                    }
                    else
                    {
                        VehicleMonitorVector.add("disable");
                    }
                    NetDemo.VehicleMonitorTableModel.addRow(VehicleMonitorVector);
                    NetDemo.mapVehicleMonitorMap.put(Common.byteArrayToString(stMonitorInfo.stMonitorRuleInfo.szName), stMonitorInfo);
                }
            }
            bRet = NetDemo.netdevsdk.NETDEV_FindCloseVehicleMonitorList(lpVehicleMonitorHandle);
            if(bRet != true)
            {
                System.out.printf("NETDEV_FindCloseVehicleMonitorList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
    
    }
    /**
     * @introduction To enable vehicle monitor.
     * @description Calling the interface of NETDEV_GetVehicleMonitorInfo and NETDEV_SetVehicleMonitorInfo to realize.
     */
    public static void enableVehicleMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.jTableVehicleMonitor.getRowCount() || NetDemo.jTableVehicleMonitor.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find monitor and select a monitor first.");
            return;
        }

        String strVehiecleMonitorName = (String) NetDemo.jTableVehicleMonitor.getValueAt(NetDemo.jTableVehicleMonitor.getSelectedRow(), 0);
        NETDEV_MONITION_INFO_S stVehicleMonitorInfo = NetDemo.mapVehicleMonitorMap.get(strVehiecleMonitorName);
        NETDEV_MONITION_RULE_INFO_S stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetVehicleMonitorInfo(NetDemo.lpUserID, stVehicleMonitorInfo.udwID, stMonitorRuleInfo);
        if(false == bRet)
        {
            System.out.printf("NETDEV_SetVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        stMonitorRuleInfo.bEnabled = 1;
        bRet = NetDemo.netdevsdk.NETDEV_SetVehicleMonitorInfo(NetDemo.lpUserID, stVehicleMonitorInfo.udwID, stMonitorRuleInfo);
        if(false == bRet)
        {
            System.out.printf("NETDEV_SetVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonFindVehicleMonitor.doClick();
    
    }
    /**
     * @introduction To disable vehicle monitor.
     * @description Calling the interface of NETDEV_GetVehicleMonitorInfo and NETDEV_SetVehicleMonitorInfo.
     */
    public static void disableVehicleMonitor() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.jTableVehicleMonitor.getRowCount() || NetDemo.jTableVehicleMonitor.getSelectedRow() < 0){
            JOptionPane.showMessageDialog(null, "Please find monitor and select a monitor first.");
            return;
        }

        String strVehiecleMonitorName = (String) NetDemo.jTableVehicleMonitor.getValueAt(NetDemo.jTableVehicleMonitor.getSelectedRow(), 0);
        NETDEV_MONITION_INFO_S stVehicleMonitorInfo = NetDemo.mapVehicleMonitorMap.get(strVehiecleMonitorName);

        NETDEV_MONITION_RULE_INFO_S stMonitorRuleInfo = new NETDEV_MONITION_RULE_INFO_S();
        boolean bRet = NetDemo.netdevsdk.NETDEV_GetVehicleMonitorInfo(NetDemo.lpUserID, stVehicleMonitorInfo.udwID, stMonitorRuleInfo);
        if(false == bRet)
        {
            System.out.printf("NETDEV_SetVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        stMonitorRuleInfo.bEnabled = 0;


        bRet = NetDemo.netdevsdk.NETDEV_SetVehicleMonitorInfo(NetDemo.lpUserID, stVehicleMonitorInfo.udwID, stMonitorRuleInfo);
        if(false == bRet)
        {
            System.out.printf("NETDEV_SetVehicleMonitorInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonFindVehicleMonitor.doClick();
    }
}
