package main.java.com.netdevsdk.demo.vca.vehicle;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LAPI_SUB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_ALARM_TYPE_E;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SMART_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SUBSCRIBE_SMART_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_SUBSCRIBE_SUCC_INFO_S;

/**
 * @description Vehicle data information report.
 * @introduction Only support VMS.
 */
public class VehicleAlarm {
    /**
     * @introduction To register vehicle match or not match.
     * @description  Calling the interface of NETDEV_SetVehicleAlarmCallBack and NETDEV_SetAlarmCallBack_V30.
     */
    public static void registerVehicleMatch() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_SetVehicleAlarmCallBack(NetDemo.lpUserID, NetDemo.pfVehicleAlarmMessCB, NetDemo.lpUserID);
        if(false == bRet)
        {
            System.out.printf("NETDEV_SetVehicleAlarmCallBack failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0)
        {
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 64;
            stSubInfo.udwLibIDNum = 0xffff;
            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.dwVehicleRecognizeMointerID = stSubSuccInfo.udwID;
        }
        else
        {
            bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, NetDemo.cbAlarmMessCallBack, null);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 64;
            stSubInfo.udwLibIDNum = 0xffff;
            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet)
            {
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
            else 
            {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.dwVehicleRecognizeMointerID = stSubSuccInfo.udwID;        
        }
    }
    /**
     * @introduction To cancel vehicle match or not match.
     * @description Calling the interface of NETDEV_UnSubLapiAlarm and NETDEV_SetAlarmCallBack_V30.
     */
    public static void cancelVehicleMatch() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0){
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwVehicleRecognizeMointerID);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwVehicleRecognizeMointerID = -1;
        }
        else {
            
            boolean bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, null, null);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            
            
            boolean bRet2 = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwVehicleRecognizeMointerID);
            if(false == bRet2){
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwVehicleRecognizeMointerID = -1;
            
        }
    
    }
    /**
     * @introduction To register vehicle alarm.
     * @description Calling the interface of NETDEV_SetStructAlarmCallBack.
     */
    public static void registerVehicleAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.ChannelID){
            JOptionPane.showMessageDialog(null, "Please select the device channel.");
            return;
        }

        boolean bRet = NetDemo.netdevsdk.NETDEV_SetStructAlarmCallBack(NetDemo.lpUserID, NetDemo.cbStructAlarmCallBack, NetDemo.lpUserID);
        if(false == bRet){
            JOptionPane.showMessageDialog(null, "NETDEV_SetStructAlarmCallBack failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_SetStructAlarmCallBack failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0){
            NETDEV_LAPI_SUB_INFO_S stSubInfo = new NETDEV_LAPI_SUB_INFO_S();
            stSubInfo.udwType = 32;
            stSubInfo.udwLibIDNum = 0xffff;

            NETDEV_SUBSCRIBE_SUCC_INFO_S stSubSuccInfo = new NETDEV_SUBSCRIBE_SUCC_INFO_S();
            bRet = NetDemo.netdevsdk.NETDEV_SubscibeLapiAlarm(NetDemo.lpUserID, stSubInfo, stSubSuccInfo);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SubscibeLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscibeLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Register success");
            }

            NetDemo.dwVehicleStructMointerID = stSubSuccInfo.udwID;
        }
        else
        {
            bRet = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, NetDemo.cbAlarmMessCallBack, null);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            
            NETDEV_SUBSCRIBE_SMART_INFO_S stSubscribeInfo = new NETDEV_SUBSCRIBE_SMART_INFO_S();
            stSubscribeInfo.udwNum = 1;
            stSubscribeInfo.pudwSmartType = new Memory(4 * stSubscribeInfo.udwNum);
            stSubscribeInfo.pudwSmartType.setInt(0, NETDEV_SMART_ALARM_TYPE_E.NETDEV_SMART_ALARM_TYPE_VEHICLE_SNAP);
            
            NETDEV_SMART_INFO_S stSmartInfo = new NETDEV_SMART_INFO_S();
            stSmartInfo.dwChannelID = NetDemo.ChannelID;
            bRet = NetDemo.netdevsdk.NETDEV_SubscribeSmart(NetDemo.lpUserID, stSubscribeInfo, stSmartInfo);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_SubscribeSmart failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SubscribeSmart failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Register success");
            }
            NetDemo.dwVehicleStructMointerID = stSmartInfo.udwSubscribeID;
            System.out.printf("开启订阅识别"+NetDemo.dwVehicleStructMointerID);
        }
    
    }
    /**
     * @introduction To cancel vehicle alarm.
     * @description Calling the interface of  NETDEV_SetStructAlarmCallBack and NETDEV_UnSubLapiAlarm
     */
    public static void cancelVehicleAlarm() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        
        NetDemo.netdevsdk.NETDEV_SetStructAlarmCallBack(NetDemo.lpUserID, null, NetDemo.lpUserID);
        
        if(NetDemo.jComboBoxDeviceType.getSelectedIndex() == 0){
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnSubLapiAlarm(NetDemo.lpUserID, NetDemo.dwVehicleStructMointerID);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_UnSubLapiAlarm failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnSubLapiAlarm failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwVehicleStructMointerID = -1;
        }
        else
        {
            boolean bRet2 = NetDemo.netdevsdk.NETDEV_SetAlarmCallBack_V30(NetDemo.lpUserID, null, null);
            if(false == bRet2){
                JOptionPane.showMessageDialog(null, "NETDEV_SetAlarmCallBack_V30 failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_SetAlarmCallBack_V30 failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
            }
            NETDEV_SMART_INFO_S stSmartInfo = new NETDEV_SMART_INFO_S();
            stSmartInfo.dwChannelID = NetDemo.ChannelID;
            stSmartInfo.udwSubscribeID = NetDemo.dwVehicleStructMointerID;
            boolean bRet = NetDemo.netdevsdk.NETDEV_UnsubscribeSmart(NetDemo.lpUserID, stSmartInfo);
            if(false == bRet){
                JOptionPane.showMessageDialog(null, "NETDEV_UnsubscribeSmart failed,error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
                System.out.printf("NETDEV_UnsubscribeSmart failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }else {
                JOptionPane.showMessageDialog(null, "Cancel success");
            }
            NetDemo.dwVehicleStructMointerID = -1;
        }
    
    }
}
