package main.java.com.netdevsdk.demo.vca.vehicle;

import java.util.Vector;

import javax.swing.JOptionPane;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;

import main.java.com.netdevsdk.demo.NetDemo;
import main.java.com.netdevsdk.demo.util.Common;
import main.java.com.netdevsdk.demo.vca.face.PersonLibCapacityWindow;
import main.java.com.netdevsdk.demo.vca.vehicle.VehicleOperateWindow.VEHICLE_OPERATE_WINDOW_EFFECT;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATE_BASIC_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATE_MEMBER_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_BATCH_OPERATOR_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_DELETE_DB_FLAG_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_FILE_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_LIB_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_LIB_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PERSON_QUERY_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_PLATE_ATTR_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEHICLE_DETAIL_INFO_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEHICLE_INFO_LIST_S;
import main.java.com.netdevsdk.lib.NetDEVSDKLib.NETDEV_VEHICLE_MEMBER_ATTR_S;

/**
 * @description Vehicle lib manage section includes add,delete,modify,find vehicle lib and add,delete,modify,find vehicle in vehicle lib.
 * @introduction Only support VMS.
 */
public class VehicleLib {
    /**
     * @description To add vehicle lib.
     * @introduction Calling the interface of NETDEV_AddVehicleLibInfo to realize.
     */
    public static void addVehicleLib() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first.error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        //弹出界面显示输入需要添加的库名字
        String strVehicleLibName= JOptionPane.showInputDialog("Please input vehicle lib name:");
        try {
            if(strVehicleLibName==null||strVehicleLibName.equals("")) {
                JOptionPane.showMessageDialog(null, "Car lib can not be null");
                return;
            }
        }catch(Exception n) {
            return;
        }
      //调用sdk接口添加库
        NETDEV_LIB_INFO_S stVehicleLibInfo = new NETDEV_LIB_INFO_S();
        Common.stringToByteArray(strVehicleLibName, stVehicleLibInfo.szName);
        boolean bRet = NetDemo.netdevsdk.NETDEV_AddVehicleLibInfo(NetDemo.lpUserID, stVehicleLibInfo);
        if(false == bRet){
            JOptionPane.showMessageDialog(null, "NETDEV_AddVehicleLibInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_AddVehicleLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.mapVehicleLib.put(Common.byteArrayToString(stVehicleLibInfo.szName), stVehicleLibInfo);
        NetDemo.jComboBoxVehicleLib.addItem(Common.byteArrayToString(stVehicleLibInfo.szName));
    }
    /**
     * @description To delete vehicle lib.
     * @introduction Calling the interface of NETDEV_DeletePersonLibInfo to realize.
     */
    public static void deleteVehicleLib() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.jComboBoxVehicleLib.getItemCount())
        {
            JOptionPane.showMessageDialog(null, "Please add vehicle lib first.");
            return;
        }

        String strVehicleLibString = (String) NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(strVehicleLibString);
        NETDEV_DELETE_DB_FLAG_INFO_S stFlagInfo = new NETDEV_DELETE_DB_FLAG_INFO_S();
        stFlagInfo.bIsDeleteMember = 1;
        if(stVehicleLibInfo==null) {
            JOptionPane.showMessageDialog(null, "Please choose an car lib");
        }
        boolean bRet = NetDemo.netdevsdk.NETDEV_DeleteVehicleLibInfo(NetDemo.lpUserID, stVehicleLibInfo.udwID, stFlagInfo);
        if(false == bRet){
            JOptionPane.showMessageDialog(null, "NETDEV_DeleteVehicleLibInfo failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_DeleteVehicleLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        NetDemo.jComboBoxVehicleLib.removeItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex());
        NetDemo.mapVehicleLib.remove(strVehicleLibString);
    }
    /**
     * @description To modify the vehicle lib.
     * @introduction Calling the interface of NETDEV_ModifyVehicleLibInfo to realize.
     */
    public static void modifyVehicleLib() {

        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        String strVehicleLibName = JOptionPane.showInputDialog("Please input new vehicle lib name:");
        try {
            if(strVehicleLibName.equals("")||strVehicleLibName==null) {
                JOptionPane.showInputDialog("Car lib name can not be null");
                return;
            }
        }catch(Exception m) {
            return;
        }

        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex()));
        
        if(stVehicleLibInfo==null) {
            JOptionPane.showMessageDialog(null,"Please choose an car lib");
            return;
        }
        Common.stringToByteArray(strVehicleLibName, stVehicleLibInfo.szName);
        stVehicleLibInfo.write();
        NETDEV_PERSON_LIB_LIST_S stVehicleLibList = new NETDEV_PERSON_LIB_LIST_S();
        stVehicleLibList.udwNum = 1;
        stVehicleLibList.pstLibInfo = stVehicleLibInfo.getPointer();
        boolean bRet = NetDemo.netdevsdk.NETDEV_ModifyVehicleLibInfo(NetDemo.lpUserID, stVehicleLibList);
        if(false == bRet){
            System.out.printf("NETDEV_ModifyVehicleLibInfo failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.mapVehicleLib.remove(NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex()));
        NetDemo.mapVehicleLib.put(strVehicleLibName, stVehicleLibInfo);
        int dwCurrentindex = NetDemo.jComboBoxVehicleLib.getSelectedIndex();
        NetDemo.jComboBoxVehicleLib.removeItemAt(dwCurrentindex);
        NetDemo.jComboBoxVehicleLib.insertItemAt(strVehicleLibName, dwCurrentindex);
    
    }
    /**
     * @description To find vehicle lib. 
     * @introduction Calling the interface of NETDEV_FindNextPersonLibInfo to realize.
     */
    public static void findVehicleLib() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jComboBoxVehicleLib.removeAllItems();
        NetDemo.mapVehicleLib.clear();  
        boolean bRet = false;
        Pointer lpVehiclelibHandle = NetDemo.netdevsdk.NETDEV_FindVehicleLibList(NetDemo.lpUserID);
        if(lpVehiclelibHandle != null)
        {
            while(true)
            {
                NETDEV_LIB_INFO_S stVehicleLibInfo = new NETDEV_LIB_INFO_S();
                bRet = NetDemo.netdevsdk.NETDEV_FindNextVehicleLibInfo(lpVehiclelibHandle, stVehicleLibInfo);
                if(bRet == true)
                {
                    NetDemo.mapVehicleLib.put(Common.byteArrayToString(stVehicleLibInfo.szName), stVehicleLibInfo);
                    NetDemo.jComboBoxVehicleLib.addItem(Common.byteArrayToString(stVehicleLibInfo.szName));
                }
                else
                {
                    break;
                }
            }
            bRet = NetDemo.netdevsdk.NETDEV_FindCloseVehicleLibList(lpVehiclelibHandle);
            if(bRet != true)
            {
                System.out.printf("NETDEV_FindCloseVehicleLibList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                return;
            }
        }
    }
    
    /**
     * @description To add vehicle in the vehicle lib.
     * @introduction It is mainly realized by the constructor of VehicleOperateWindow.
     */
    public static void addVehicle() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.jComboBoxVehicleLib.getItemCount())
        {
            JOptionPane.showMessageDialog(null, "Please find vehicle lib first.");
            return;
        }
        VehicleOperateWindow v=new VehicleOperateWindow(VEHICLE_OPERATE_WINDOW_EFFECT.VEHICLE_OPERATE_WINDOW_ADDVEHICLE,NetDemo.jButtonVehicleFind);
        v.setVisible(true);
    }
    /**
     * @description To delete vehicle in the vehicle lib.
     * @introduction Calling the interface of NETDEV_DelVehicleMemberList to realize.
     */
    public static void deleteVehicle() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.VehicleTableModle.getRowCount()  || NetDemo.VehicleTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find vehicle or select vehicle first.");
            return;
        }

        String strVehiclePlateName = (String) NetDemo.VehicleTable.getValueAt(NetDemo.VehicleTable.getSelectedRow(), 0);
        NETDEV_VEHICLE_DETAIL_INFO_S stVehilceDetailInfo = NetDemo.mapVehicleInfo.get(strVehiclePlateName);
        NETDEV_VEHICLE_INFO_LIST_S stVehicleMemberList = new NETDEV_VEHICLE_INFO_LIST_S();
        stVehicleMemberList.udwVehicleNum = 1;
        stVehicleMemberList.pstMemberInfoList = stVehilceDetailInfo.getPointer();

        NETDEV_BATCH_OPERATOR_LIST_S stResutList = new NETDEV_BATCH_OPERATOR_LIST_S();
        stResutList.udwNum = 1;
        NETDEV_BATCH_OPERATOR_INFO_S stBatchList = new NETDEV_BATCH_OPERATOR_INFO_S();
        stResutList.pstBatchList = stBatchList.getPointer();

        /* 参数2目前默认填0生效 */
        boolean bRet = NetDemo.netdevsdk.NETDEV_DelVehicleMemberList(NetDemo.lpUserID, 0, stVehicleMemberList, stResutList);
        if(false == bRet)
        {
            JOptionPane.showMessageDialog(null, "NETDEV_DelVehicleMemberList failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
            System.out.printf("NETDEV_DelVehicleMemberList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        NetDemo.jButtonVehicleFind.doClick();
        
    
        
    }
    /**
     * @description To modify vehicle in the vehicle lib.
     * @introduction It is mainly realized by the constructor of VehicleOperateWindow.
     */
    public static void modifyVehicle() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }

        if(0 == NetDemo.VehicleTableModle.getRowCount()  || NetDemo.VehicleTable.getSelectedRow() < 0)
        {
            JOptionPane.showMessageDialog(null, "Please find vehicle or select vehicle first.");
            return;
        }
        VehicleOperateWindow v=new VehicleOperateWindow(VEHICLE_OPERATE_WINDOW_EFFECT.VEHICLE_OPERATE_WINDOW_MODIFVEHICLE,NetDemo.jButtonVehicleFind);
        v.setVisible(true);
    
    }
    /**
     * @description To find vehicle in the vehicle lib.
     * @introduction Calling the interface of NETDEV_FindVehicleMemberDetailList and NETDEV_FindCloseVehicleMemberDetail to realize.
     */
    public static void findVehicle() {
        if(null == NetDemo.lpUserID)
        {
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(0 == NetDemo.jComboBoxVehicleLib.getItemCount())
        {
            JOptionPane.showMessageDialog(null, "Please find vehicle lib first.");
            return;
        }
        NetDemo.VehicleTableModle.setRowCount(0);
        NetDemo.mapVehicleInfo.clear();
        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex()));
        NETDEV_PERSON_QUERY_INFO_S stQueryInfo = new NETDEV_PERSON_QUERY_INFO_S();
        stQueryInfo.udwNum = 0;
        stQueryInfo.udwOffset =  0;
        stQueryInfo.udwLimit = 16;
        NETDEV_BATCH_OPERATE_BASIC_S stQueryResultInfo = new NETDEV_BATCH_OPERATE_BASIC_S();
        boolean bRet = false;
        while(true)
        {
            Pointer lpFindVehicleHandle = NetDemo.netdevsdk.NETDEV_FindVehicleMemberDetailList(NetDemo.lpUserID, stVehicleLibInfo.udwID, stQueryInfo, stQueryResultInfo);
            if(lpFindVehicleHandle == null || stQueryResultInfo.udwTotal == 0)
            {
                System.out.printf("NETDEV_FindVehicleMemberDetailList failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                break;
            }
            else
            {
                stQueryInfo.udwOffset += stQueryInfo.udwLimit;
                while(true)
                {
                    NETDEV_VEHICLE_DETAIL_INFO_S stVehicleMemberInfo = new NETDEV_VEHICLE_DETAIL_INFO_S();
                    stVehicleMemberInfo.stPlateAttr = new NETDEV_PLATE_ATTR_INFO_S();
                    stVehicleMemberInfo.stVehicleAttr = new NETDEV_VEHICLE_MEMBER_ATTR_S();
                    stVehicleMemberInfo.stVehicleAttr.stVehicleImage = new NETDEV_FILE_INFO_S();
                    stVehicleMemberInfo.stVehicleAttr.stVehicleImage.pcData = new Memory(Common.NETDEMO_PICTURE_SIZE);
                    stVehicleMemberInfo.stVehicleAttr.stVehicleImage.udwSize = Common.NETDEMO_PICTURE_SIZE;

                    bRet = NetDemo.netdevsdk.NETDEV_FindNextVehicleMemberDetail(lpFindVehicleHandle, stVehicleMemberInfo);
                    if(bRet != true)
                    {
                        break;
                    }
                    else
                    {
                        NetDemo.mapVehicleInfo.put(Common.byteArrayToString(stVehicleMemberInfo.stPlateAttr.szPlateNo), stVehicleMemberInfo);

                        Vector<String> VehicleVector = new Vector<String>();
                        VehicleVector.add(Common.byteArrayToString(stVehicleMemberInfo.stPlateAttr.szPlateNo));

                        VehicleVector.add(Common.EnumNETDEV_PLATE_COLOR_EConventToString(stVehicleMemberInfo.stPlateAttr.udwColor));
                        VehicleVector.add(Common.EnumNETDEV_PLATE_TYPE_EConventToString(stVehicleMemberInfo.stPlateAttr.udwType));
                        VehicleVector.add(Common.EnumNETDEV_PLATE_COLOR_EConventToString(stVehicleMemberInfo.stVehicleAttr.udwColor));

                        if(stVehicleMemberInfo.bIsMonitored == 0)
                        {
                            VehicleVector.add("Disable");
                        }
                        else
                        {
                            VehicleVector.add("Enable");
                        }
                        NetDemo.VehicleTableModle.addRow(VehicleVector);
                    }
                }
                bRet = NetDemo.netdevsdk.NETDEV_FindCloseVehicleMemberDetail(lpFindVehicleHandle);
                if(bRet == false)
                {
                    System.out.printf("NETDEV_FindCloseVehicleMemberDetail failed:%d", NetDemo.netdevsdk.NETDEV_GetLastError());
                }                              
            }
        }
    }
   
    public static void addVechileSendLibMember() {

        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.VehicleTable.getSelectedRow()<0) {
            JOptionPane.showMessageDialog(null, "Please select car first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        }
        String strVehicleLibString = (String) NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(strVehicleLibString);
        int udwVehicleLibID=stVehicleLibInfo.udwID;
        String strVehiclePlateName=null;
        try {
            strVehiclePlateName = (String) NetDemo.VehicleTable.getValueAt(NetDemo.VehicleTable.getSelectedRow(), 0);
            if(strVehiclePlateName==null||strVehiclePlateName.equals("")) {
                JOptionPane.showMessageDialog(null, "Please choose car");
            }else {
                
                NETDEV_VEHICLE_DETAIL_INFO_S stVehilceDetailInfo = NetDemo.mapVehicleInfo.get(strVehiclePlateName);
                stVehilceDetailInfo.stPlateAttr=new NETDEV_PLATE_ATTR_INFO_S();
                stVehilceDetailInfo.write();
                NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstMemberList=new  NETDEV_BATCH_OPERATE_MEMBER_LIST_S();
                
                pstMemberList.pstMemberIDList=new Memory(128);
                pstMemberList.udwMemberNum=2;
                pstMemberList.pstMemberIDList=stVehilceDetailInfo.getPointer();
                
                System.out.println("id list"+stVehilceDetailInfo.udwMemberID);
                NETDEV_BATCH_OPERATOR_LIST_S pstBatchResultList=new NETDEV_BATCH_OPERATOR_LIST_S();
                pstBatchResultList.udwNum=1;
                pstBatchResultList.pstBatchList=new Memory(1000);
                boolean rBet= NetDemo.netdevsdk.NETDEV_AddVehicleLibMember(NetDemo.lpUserID,udwVehicleLibID,pstMemberList,pstBatchResultList);
                if(rBet) {
                    JOptionPane.showMessageDialog(null, "Divide success");
                    NetDemo.jButtonVehicleFind.doClick();
                    NetDemo.jButtonRemoveSameCar.doClick();
                        
                    
                }else {
                    System.out.printf("NETDEV_AddVehicleLibMember failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
            }
            
            
        }catch(Exception t) {
            return;
        }
    }

    public static void removeSameCar() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        String strVehicleLibString = (String) NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(strVehicleLibString);
        int udwVehicleLibID=stVehicleLibInfo.udwID;
        
        String strVehiclePlateName=null;
        try {
            
            for(int i=0;i<NetDemo.VehicleTable.getRowCount();i++) {
                strVehiclePlateName = (String) NetDemo.VehicleTable.getValueAt(i, 0);
                if(strVehiclePlateName==null||strVehiclePlateName.equals("")) {
                    NETDEV_VEHICLE_DETAIL_INFO_S stVehilceDetailInfo = NetDemo.mapVehicleInfo.get(strVehiclePlateName);
                    
                    NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstMemberList=new  NETDEV_BATCH_OPERATE_MEMBER_LIST_S();

                    pstMemberList.pstMemberIDList=new Memory(128);
                    pstMemberList.pstMemberIDList=stVehilceDetailInfo.getPointer();
                    pstMemberList.udwMemberNum=2;
                    pstMemberList.write();
                    
                    NETDEV_BATCH_OPERATOR_LIST_S pstBatchResultList=new NETDEV_BATCH_OPERATOR_LIST_S();
                    pstBatchResultList.pstBatchList=new Memory(1000);
                    pstBatchResultList.write();
                    boolean rBet= NetDemo.netdevsdk.NETDEV_DeleteVehicleLibMember(NetDemo.lpUserID,udwVehicleLibID,pstMemberList,pstBatchResultList);
                    
                    if(rBet) {
                        NetDemo.jButtonVehicleFind.doClick();
                        
                    }else {
                        JOptionPane.showMessageDialog(null, "NETDEV_DeleteVehicleLibMember failed,error code"+ NetDemo.netdevsdk.NETDEV_GetLastError());
                        System.out.printf("NETDEV_DeleteVehicleLibMember failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                        return;
                    }
                }
            }
        }catch(Exception t) {
            return;
        }
        
    
    }

    public static void deleteVehicleListSend() {
        if(null == NetDemo.lpUserID){
            JOptionPane.showMessageDialog(null, "Please Login device first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
            return;
        }
        if(NetDemo.VehicleTable.getSelectedRow()<0) {
            JOptionPane.showMessageDialog(null, "Please select car first. error code"+NetDemo.netdevsdk.NETDEV_GetLastError());
        }
        String strVehicleLibString = (String) NetDemo.jComboBoxVehicleLib.getItemAt(NetDemo.jComboBoxVehicleLib.getSelectedIndex());
        NETDEV_LIB_INFO_S stVehicleLibInfo = NetDemo.mapVehicleLib.get(strVehicleLibString);
        int udwVehicleLibID=stVehicleLibInfo.udwID;
        
        String strVehiclePlateName=null;
        try {
            strVehiclePlateName = (String) NetDemo.VehicleTable.getValueAt(NetDemo.VehicleTable.getSelectedRow(), 0);
            if(strVehiclePlateName==null) {
                JOptionPane.showMessageDialog(null, "Please choose car");
                
            }else {
                NETDEV_VEHICLE_DETAIL_INFO_S stVehilceDetailInfo = NetDemo.mapVehicleInfo.get(strVehiclePlateName);
                
                NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstMemberList=new  NETDEV_BATCH_OPERATE_MEMBER_LIST_S();

                pstMemberList.pstMemberIDList=new Memory(128);
                pstMemberList.pstMemberIDList=stVehilceDetailInfo.getPointer();
                pstMemberList.udwMemberNum=2;
                pstMemberList.write();
                
                NETDEV_BATCH_OPERATOR_LIST_S pstBatchResultList=new NETDEV_BATCH_OPERATOR_LIST_S();
                pstBatchResultList.pstBatchList=new Memory(1000);
                pstBatchResultList.write();
                boolean rBet= NetDemo.netdevsdk.NETDEV_DeleteVehicleLibMember(NetDemo.lpUserID,udwVehicleLibID,pstMemberList,pstBatchResultList);
                
                if(rBet) {
                    JOptionPane.showMessageDialog(null, "Cancel success");
                    NetDemo.jButtonVehicleFind.doClick();
                    
                }else {
                    System.out.printf("NETDEV_DeleteVehicleLibMember failed:%d\n", NetDemo.netdevsdk.NETDEV_GetLastError());
                    return;
                }
            }
        }catch(Exception t) {
            return;
        }
    
    }
}
