package main.java.com.netdevsdk.lib;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.win32.StdCallLibrary.StdCallCallback;

import java.sql.Struct;



public interface NetDEVSDKLib extends Library {
	NetDEVSDKLib NETDEVSDK_INSTANCE = (NetDEVSDKLib)Native.loadLibrary(BaseFun.LoadSDKLibrary(), NetDEVSDKLib.class);

	public static final int  NETDEV_LEN_2   = 2;
	public static final int  NETDEV_LEN_4   = 4;
	public static final int NETDEV_IPSAN_MAX_NUM =4;
	public static final int  NETDEV_LEN_6   = 6;
	public static final int  NETDEV_LEN_8	=8;
	public static final int NETDEV_MAX_LINK_ACTION_NUM   =9;
	public static final int  NETDEV_LEN_16	= 16;
	public static final int  NETDEV_LEN_32 	= 32;
	public static final int  NETDEV_LEN_40  = 40;
	public static final int  NETDEV_LEN_64  = 64;
	public static final int  NETDEV_LEN_128 = 128;
	public static final int  NETDEV_LEN_132 = 132;
	public static final int  NETDEV_LEN_256 = 256;
	public static final int  NETDEV_LEN_260 = 260;
	public static final int   NETDEV_LEN_480 = 480;
	public static final int  NETDEV_LEN_512 = 512;
	public static final int  NETDEV_LEN_1024= 1024;
	public static final int  NETDEV_IPADDR_STR_MAX_LEN = 64;
	public static final int  NETDEV_IPV4_LEN_MAX = 16;

	public static final int NETDEV_ALARM_SOURCE_MAX_LEN = 68;
	public static final int NETDEV_MAX_EVENT_RES_SIZE = 1024;

	public static final int NETDEV_NAME_MAX_LEN = 256;
	public static final int NETDEV_DESCRIBE_MAX_LEN = 516;

	public static final int NETDEV_TMS_FACE_RECORD_ID_LEN        =  32;
	public static final int NETDEV_TMS_CAMER_ID_LEN              =   32;
	public static final int NETDEV_TMS_PASSTIME_LEN               =  32;
	public static final int NETDEV_TMS_FACE_TOLLGATE_ID_LEN      =   32;
	public static final int NETDEV_TMS_HEAT_MAP_DEVID_LEN        =   32;
	public static final int NETDEV_TMS_HEAT_MAP_RECORD_ID_LEN    =   16;
	public static final int NETDEV_TMS_HEAT_MAP_COllECT_TIME_LEN =   18;
	public static final int NETDEV_TMS_PIC_COMMON_NUM            =   10;
	public static final int NETDEV_TMS_CAR_PLATE_CAMID_LEN       =   32;
	public static final int NETDEV_TMS_CAR_PLATE_RECORDID_LEN    =   32;
	public static final int NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN    =   32;
	public static final int NETDEV_TMS_CAR_PLATE_PASSTIME_LEN    =   18;
	public static final int NETDEV_TMS_CAR_PLATE_LANEID_LEN      =   18;
	public static final int NETDEV_TMS_CAR_PLATE_CARPLATE_LEN    =   32;

	public static final int NETDEV_MONTH_DAY_MAX			=31;          /*  Maximum number of days in a month */
	public static final int NETDEV_CODE_STR_MAX_LEN     	=256;
	public static final int NETDEV_VIID_CODE_LEN			=48;
	public static final int NETDEV_USERNAME_LEN				= 132;
	public static final int NETDEV_PASSWORD_LEN				= 128;
	public static final int NETDEV_MAX_URL_LEN              = 512;
	public static final int NETDEV_STREAM_MAX_NUM			= 3;
	public static final int NETDEV_MAX_PRESET_NUM			= 256;
	public static final int NETDEV_MAX_CRUISEPOINT_NUM		= 32;
	public static final int NETDEV_MAX_CRUISEROUTE_NUM		= 16;
	public static final int NETDEV_FILE_NAME_LEN			= 256;

	public static final int NETDEV_NTP_SERVER_LIST_NUM		= 5;
	public static final int NETDEV_OSD_TEXT_MAX_LEN			= 64 + 4;
	public static final int NETDEV_OSD_TEXTOVERLAY_NUM		= 6;
	public static final int NETDEV_OSD_MAX_NUM_EX			= 8;

	public static final int NETDEV_MAX_ALARM_OUT_NUM		= 64;
	public static final int NETDEV_MAX_ALARM_IN_NUM			= 64;

	public static final int NETDEV_FACE_MEMBER_CUSTOM_LEN   = 255;             
	public static final int NETDEV_LOG_QUERY_COND_NUM       = 48;              
	public static final int NETDEV_FACE_MEMBER_NAME_LEN     = 256;             
	public static final int NETDEV_FACE_MEMBER_BIRTHDAY_LEN = 31;              
	public static final int NETDEV_FACE_MEMBER_CUSTOM_NUM   = 5;               
	public static final int NETDEV_FACE_MEMBER_REGION_LEN   = 256;             
	public static final int NETDEV_FACE_IDNUMBER_LEN        = 128;             
	public static final int NETDEV_FACE_MONITOR_RULE_NAME_LEN = 508;             
	public static final int NETDEV_FACE_MONITOR_RULE_REASON_LEN = 508;             
	public static final int NETDEV_CHANNEL_MAX              = 512;             /*  Maximum number of channel */
	public static final int NETDEV_MAX_TIME_SECTION_NUM     = 8;               
	public static final int NETDEV_MAX_DAY_NUM              = 8;               
	public static final int NETDEV_FACE_FEATURE_SIZE        = 512;             /*  512B */

	public static final int NETDEV_TIME_TEMPLATE_NUM = 32; 

	public static final int NETDEV_DOMAIN_LEN 					= 64;         	/*   Maximum length of domain name */
	public static final int NETDEV_PATH_LEN						= 128;			/* :  Maximum length of path, including filename */
	public static final int NETDEV_DNS_LIST_NUM  				= 2;            /* DNS */
	public static final int NETDEV_SCREEN_INFO_ROW 				= 18;           /*   Screen Info Row */
	public static final int NETDEV_SCREEN_INFO_COLUMN   		= 22;          	/*   Screen Info Column */
	public static final int NETDEV_PHOTO_SERVER_MAX_NUM 		= 4;           	/*  Maximum number of Photo Server */

	public static final int NETDEV_SCREEN_VIDEO_INFO_COLUMN     =24;          
	public static final int NETDEV_SCREEN_VIDEO_INFO_Row     =8;          
	public static final int NETDEV_DEV_OTHER_LEN_MAX            = 32;          
	public static final int NETDEV_DEV_NAME_LEN_MAX             = 64;          
	public static final int NETDEV_INTELLIGENT_SERVER_MAX_NUM   = 4;           /*  Maximum number of Intelligent Server */
	public static final int  NETDEV_MANAGER_SERVER_MAX_NUM      = 4;           /*  Maximum number of Manager Server */
	public static final int NETDEV_DISK_SMART_MAX_NUM   		= 128;        /* SMART Maximum number of Disk Smart Info */
	public static final int NETDEV_LOCAL_DISK_MAX_NUM           = 32;          /*  local Maximum number of Disk */
	public static final int NETDEV_SD_CARD_DISK_MAX_NUM       	= 16;          /* SD SD Maximum number of Disk */
	public static final int NETDEV_ARRAY_MAX_NUM            	= 16;          /*  array Maximum number of Disk */
	public static final int NETDEV_EXTEND_CABINET_DISK_MAX_NUM	= 32;          /*  extend cabinet Maximum number of Disk */
	public static final int NETDEV_NAS_MAX_NUM                	= 16;          /* NAS NAS Maximum number of Disk */
	public static final int NETDEV_ESATA_MAX_NUM              	= 4;           /* ESATA eSATA Maximum number of Disk */
	public static final int NETDEV_AUDIO_IN_MAX_NUM             = 16;      	  /*  Maximum number of Audio input count */
	public static final int NETDEV_SERIAL_IN_MAX_NUM        	= 16;              /*  Maximum number of serial input count */
	public static final int NETDEV_DISK_MAX_NUM             	= 256;         /*  Maximum number of Disk */
	public static final int NETDEV_MAX_PRIVACY_MASK_AREA_NUM    = 8;           /*   Maximum number of privacy mask areas allowed */
	public static final int NETDEV_NETWORK_MACNAME_LEN          = 48;             /* MAC */
	public static final int NETDEV_PEOPLE_CNT_MAX_NUM           = 60;          /*  Maximum number of people count */
	public static final int NETDEV_TRACK_CRUISE_MAXNUM          = 1;           /*   Maximum number of patrol routes allowed  */
	public static final int NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX     = 128;             
	public static final int NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM    = 8;          /*  Maximum number of Audio input mode count */
	public static final int NETDEV_AUDIO_SAMPLING_RATE_MAX_NUM  = 8;          /*  Maximum number of Audio sampling rate count */
	public static final int NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM      = 16;  /*  Maximum number of Audio input encode format count
	
	/**
	 * @struct NETDEV_DEVICE_LOGIN_INFO_S
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEVICE_LOGIN_INFO_S extends Structure
	{
		public byte[]  	szIPAddr = new byte[NETDEV_LEN_260];	/* IP/ */
		public int 		dwPort; 								
		public byte[]  	szUserName = new byte[NETDEV_LEN_132];  
		public byte[]  	szPassword = new byte[NETDEV_LEN_128]; 	
		public int 		dwLoginProto; 							/*  0:onvif 1:*/
		public int      dwDeviceType; 							
		public byte[] 	byRes = new byte[256];
	}

	/**
	 * @struct NETDEV_SELOG_INFO_S
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SELOG_INFO_S extends Structure {
		public int 		dwSELogCount; 			
		public int 		dwSELogTime;  			
		public byte[] 	byRes = new byte[64];
	}

	/**
	 * @struct NETDEV_PREVIEWINFO_S
	 * @brief   Live view parameter Structure definition
	 * @attention  None
	 */
	public class NETDEV_PREVIEWINFO_S extends Structure {
		public int   	dwChannelID;                 /* ID  Channel ID */
		public int   	dwStreamType;                /* ,  #NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
		public int   	dwLinkMode;                  /* ,  #NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
		public Pointer  hPlayWnd;                    /*  Play window handle */
		public int   	dwFluency;                   /* ,  #NETDEV_PICTURE_FLUENCY_E */
		public int   	dwStreamMode;                /*    #NETDEV_STREAM_MODE_E  start stream mode see #NETDEV_STREAM_MODE_E*/
		public int   	dwLiveMode;                  /*    #NETDEV_PULL_STREAM_MODE_E */
		public int   	dwDisTributeCloud;           /*    #NETDEV_DISTRIBUTE_CLOUD_SRV_E */
		public int    	dwallowDistribution;         
		public int   	dwTransType;                    /*   #NETDEV_TRANS_TYPE_E */
		public int   	dwStreamProtocol;            /*   # NETDEV_START_STREAM_PROT_E*/
		public byte[]   byRes = new byte[236];                  /*   Reserved */
	}

	/**
	 *@brief 
	 *@attention 
	 */
	public static class NETDEV_PULL_STREAM_MODE_E extends Structure {
		public static final int NETDEV_STREAM_MODE_SERVER_DISTRIBUTE   = 0;            
		public static final int NETDEV_STREAM_MODE_FORCE_CDN    = 1;            
	}

	/**
	 *@brief 
	 *@attention 
	 */
	public static class NETDEV_START_STREAM_PROT_E extends Structure {
		public static final int NETDEV_START_STREAM_PROT_UDP   = 0;
		public static final int NETDEV_START_STREAM_PROT_TCP    = 1;
		public static final int NETDEV_START_STREAM_PROT_RTSP   = 3;
		public static final int NETDEV_START_STREAM_PROT_HTTP    = 4;
		public static final int NETDEV_START_STREAM_PROT_INVALID   = 0xff;
	}

	/**
	 * @struct NETDEV_CHANNEL_STATUS_E
	 * @brief    Structure definition
	 * @attention  None
	 */
	public static class NETDEV_CHANNEL_STATUS_E extends Structure {
		public static final int NETDEV_CHL_STATUS_OFFLINE   = 0;            /*   Channel offline */
		public static final int NETDEV_CHL_STATUS_ONLINE    = 1;            /*   Channel online */
		public static final int NETDEV_CHL_STATUS_UNBIND    = 2;             /*   Channel unbind */
		public static final int NETDEV_CHL_STATUS_INVALID   = 0xff;
	}

	/**
	 * @struct NETDEV_MEDIA_FILE_FORMAT_E
	 * @brief     Media file format Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_MEDIA_FILE_FORMAT_E extends Structure {
		public static final int NETDEV_MEDIA_FILE_MP4                   = 0;    /* MP4(+)  mp4 media file (Audio + Video) */
		public static final int NETDEV_MEDIA_FILE_TS                    = 1;    /* TS(+)   TS media file (Audio + Video) */
		public static final int NETDEV_MEDIA_FILE_MP4_ADD_TIME          = 2;    /* MP4(+) ;  MP4 media file with time in file name (Audio + Video) */
		public static final int NETDEV_MEDIA_FILE_TS_ADD_TIME           = 3;    /* TS(+) ;  TS media file with time in file name (Audio + Video) */
		public static final int NETDEV_MEDIA_FILE_AUDIO_TS              = 4;    /* TS()   TS audio file (Only audio) */
		public static final int NETDEV_MEDIA_FILE_AUDIO_MP4             = 5;    /* MP4()   MP4 audio file (Only audio) */
		public static final int NETDEV_MEDIA_FILE_AUDIO_TS_ADD_TIME     = 6;    /* TS();  TS audio file with time in file name (Only audio) */
		public static final int NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_TIME    = 7;    /* MP4();  MP4 audio file with time in file name (Only audio) */
		public static final int NETDEV_MEDIA_FILE_MP4_ADD_RCD_TIME      = 8;    /* MP4(+)  MP4 media file with start and end times in file name (Audio + Video)*/
		public static final int NETDEV_MEDIA_FILE_TS_ADD_RCD_TIME       = 9;    /* TS(+)  TS media file with start and end times in file name (Audio + Video)*/
		public static final int NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_RCD_TIME= 10;   /* MP4()  MP4 audio file with start and end times in file name (Only audio)*/
		public static final int NETDEV_MEDIA_FILE_AUDIO_TS_ADD_RCD_TIME = 11;   /* TS()  TS audio file with start and end times in file name (Only audio)*/
		public static final int NETDEV_MEDIA_FILE_VIDEO_MP4_ADD_RCD_TIME= 12;   /* MP4()  mp4 media file (Only video) */
		public static final int NETDEV_MEDIA_FILE_VIDEO_TS_ADD_RCD_TIME = 13;   /* TS()  ts media file (Only video) */

		public static final int NETDEV_MEDIA_FILE_AVI                   = 14;   /* AVI(+)   AVI media file (Audio + Video) */
		public static final int NETDEV_MEDIA_FILE_AVI_ADD_TIME          = 15;   /* AVI(+)  AVI media file with start and end times in file name (Audio + Video)*/
		public static final int NETDEV_MEDIA_FILE_AUDIO_AVI             = 16;   /* AVI()   AVI audio file (Only audio) */
		public static final int NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_TIME    = 17;   /* AVI();  AVI audio file with time in file name (Only audio)*/
		public static final int NETDEV_MEDIA_FILE_AVI_ADD_RCD_TIME      = 18;   /* AVI(+)  AVI audio file with start and end times in file name (Audio + Video)*/
		public static final int NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_RCD_TIME= 19;   /* AVI()  AVI audio file with start and end times in file name (Only audio)*/
		public static final int NETDEV_MEDIA_FILE_VIDEO_AVI_ADD_RCD_TIME= 20;   /* AVI()  AVI media file (Only video) */
		public static final int NETDEV_MEDIA_FILE_INVALID   = 0xff;
	}

	/**
	 * @struct NETDEV_CHANNEL_TYPE_E
	 * @brief    Channel type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_CHANNEL_TYPE_E extends Structure {
		public static final int NETDEV_CHL_TYPE_DIGITAL = 0;            /*   Digital Channel */
		public static final int NETDEV_CHL_TYPE_ANALOG = 1;             /*   analog Channel */
		public static final int NETDEV_CHL_TYPE_INVALID   = 0xff;
	}

	/**
	 * @struct NETDEV_LIVE_STREAM_INDEX_E
	 * @brief     Live stream index Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_LIVE_STREAM_INDEX_E extends Structure {
		public static final int NETDEV_LIVE_STREAM_INDEX_MAIN       = 0;    /*   Main stream */
		public static final int NETDEV_LIVE_STREAM_INDEX_AUX        = 1;    /*   Sub stream */
		public static final int NETDEV_LIVE_STREAM_INDEX_THIRD      = 2;    /*   Third stream */
		public static final int NETDEV_LIVE_STREAM_INDEX_ADAPTIVE   = 10;   /*   Adaptive stream */
		public static final int NETDEV_LIVE_STREAM_INDEX_INVALID    = 0xFF;  /*   Invalid value */
	}


	/**
	 *
	 */
	public static class NETDEV_IVA_SHOW_RULE_E extends Structure{
		public static final int NETDEV_IVA_SHOW_RULE                    =0x00000001;    
		public static final int NETDEV_IVA_SHOW_RESULT_TOUTH_RULE       =0x00000002;    
		public static final int NETDEV_IVA_SHOW_RESULT_UNTOUTH_RULE     =0x00000004;     
		public static final int NETDEV_IVA_SHOW_TRACK                   =0x00000008;   
	}

	/**
	 * @struct NETDEV_VIDEO_STANDARD_E
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_VIDEO_STANDARD_E extends Structure {
		public static final int NETDEV_VIDEO_STANDARD_PAL       = 0;        /* PAL */
		public static final int NETDEV_VIDEO_STANDARD_NTSC      = 1;        /* NTSC */
		public static final int NETDEV_VIDEO_STANDARD_INVALID   = 0xFF;      /*   Invalid value */
	}

	/**
	 * @struct NETDEV_PROTOCAL_E
	 * @brief     Media transport protocol Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PROTOCAL_E extends Structure {
		public static final int NETDEV_TRANSPROTOCAL_RTPUDP     = 0;    /* UDP */
		public static final int NETDEV_TRANSPROTOCAL_RTPTCP     = 1;    /* TCP */
	}

	/**
	 * @struct NETDEV_PICTURE_FORMAT_E
	 * @brief    Picture type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PICTURE_FORMAT_E extends Structure {
		public static final int NETDEV_PICTURE_BMP     = 0;    /* bmp  Picture format is bmp */
		public static final int NETDEV_PICTURE_JPG     = 1;    /* jpg  Picture format is jpg */
		public static final int NETDEV_PICTURE_INVALID   = 0xFF;
	}

	/**
	 * @struct NETDEV_RENDER_SCALE_E
	 * @brief     Video display ratio Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_RENDER_SCALE_E extends Structure {
		public static final int NETDEV_RENDER_SCALE_FULL     = 0;    		/*   Stretch */
		public static final int NETDEV_RENDER_SCALE_PROPORTION     = 1;    	/*   Scale */
		public static final int NETDEV_RENDER_SCALE_INVALID = 0xFF;
	}

	/**
	 * @struct NETDEV_HOSTTYPE_E
	 * @brief IP    Protocol type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_HOSTTYPE_E extends Structure {
		public static final int NETDEV_NETWORK_HOSTTYPE_IPV4    = 0;        /* IPv4 */
		public static final int NETDEV_NETWORK_HOSTTYPE_IPV6    = 1;        /* IPv6 */
		public static final int NETDEV_NETWORK_HOSTTYPE_DNS     = 2;         
		public static final int NETDEV_NETWORK_HOSTTYPE_INVALID     = 0xFF;     /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVEncodeChnStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CHN_STATUS_E extends Structure {
		public static final int NETDEV_CHN_STATUS_OFFLINE          = 0;                /*  offline */
		public static final int NETDEV_CHN_STATUS_ONLINE           = 1;                /*  online */
		public static final int NETDEV_CHN_STATUS_VIDEO_LOSE       = 2;                /*  video lose */
		public static final int NETDEV_CHN_STATUS_INVALID       = 0xFF;
	}


	public static class NETDEV_DEVICE_TYPE_E extends Structure {
		public static final int NETDEV_DTYPE_UNKNOWN                        = 0;            /* Unknown type */
		public static final int NETDEV_DTYPE_IPC                            = 1;            /* IPC range */
		public static final int NETDEV_DTYPE_IPC_FISHEYE                    = 2;            /* IPC Certain fisheye camera models*/
		public static final int NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE           = 3;            /* IPC Certain fisheye camera models*/
		public static final int NETDEV_DTYPE_IPC_ACS						= 4;			/* IPC Person verification camera models*/
		public static final int NETDEV_DTYPE_NVR                            = 101;          /* NVR range */
		public static final int NETDEV_DTYPE_NVR_BACKUP                     = 102;          /* NVR  NVR back up */
		public static final int NETDEV_DTYPE_HNVR                           = 103;          /* NVR */
		public static final int NETDEV_DTYPE_DC                             = 201;          /* DC range */
		public static final int NETDEV_DTYPE_DC_ADU                         = 202;          /* ADU range */
		public static final int NETDEV_DTYPE_EC                             = 301;          /* EC range */
		public static final int NETDEV_DTYPE_VMS                            = 501;          /* VMS range */
		public static final int NETDEV_DTYPE_FG                             = 601;          /* FG range */
		public static final int NETDEV_DTYPE_IPM							= 701;			/* IPM range */
		public static final int NETDEV_DTYPE_EDU							= 801;			/* EDU range */
		public static final int NETDEV_DTYPE_INVALID                        = 0xFFFF;        /*   Invalid value */
	}

	public static class NETDEV_PICTURE_FLUENCY_E extends Structure {
		public static final int NETDEV_PICTURE_REAL                 = 0;                /*  Real-time first */
		public static final int NETDEV_PICTURE_FLUENCY              = 1;                /*  Fluency first */
		public static final int NETDEV_PICTURE_BALANCE_NEW          = 3;                /*  Balance */
		public static final int NETDEV_PICTURE_RTMP_FLUENCY         = 4;                /* RTMP RTMP fluency first */
		public static final int NETDEV_PICTURE_USER_DEFINED         = 5;                /* - */
		public static final int NETDEV_PICTURE_NETADJUST            = 6;                

		public static final int NETDEV_PICTURE_FLUENCY_INVALID      = 0xff;              /*  Invalid value */
	}

	public static class NETDEV_TMS_PERSION_IMAGE_FORMAT_E extends Structure {
		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_JPG  = 1;            /* JPEG */
		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_BMP  = 2;            /* BMP */
		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_PNG  = 3;            /* PNG */
		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_GIF  = 4;            /* GIF */
		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_TIFF = 5;            /* TIFF */

		public static final int NETDEV_TMS_PERSION_IMAGE_FORMAT_INVALID = 0xff;
	}

	/**
	 * @enum tagNETDEVReportType
	 * @brief /
	 * @attention  None
	 */
	public static class NETDEV_REPORT_TYPE_E extends Structure {
		public static final int NETDEV_REPORT_TYPE_ALARM  = 0;            /* ： */
		public static final int NETDEV_REPORT_TYPE_EVENT  = 1;            /* ： */
		public static final int NETDEV_REPORT_TYPE_INVALID  = 0xff;       
	}

	/**
	 * @enum tagNETDEVEventActionType
	 * @brief    
	 * @attention  None
	 */
	public static class NETDEV_EVENT_ACTION_TYPE_E extends Structure {
		public static final int NETDEV_EVENT_ACTION_TYPE_ADD            = 0;                /* ： */
		public static final int NETDEV_EVENT_ACTION_TYPE_DELETE         = 1;                /* ： */
		public static final int NETDEV_EVENT_ACTION_TYPE_MODIFY         = 2;                /* ： */
		public static final int NETDEV_EVENT_ACTION_TYPE_ONLINE         = 3;                /* ： */
		public static final int NETDEV_EVENT_ACTION_TYPE_OFFLINE        = 4;                /* ： */
		public static final int NETDEV_EVENT_ACTION_TYPE_EMAP_ALARM     = 5;                /* ： */

		public static final int NETDEV_EVENT_ACTION_TYPE_INVALID        = 0xFF;              
	}

	/**
	 * @brief BIT  
	 * @attention  None
	 */
	public static class NETDEV_SUBSCRIBE_ALARM_TYPE_E extends Structure {
		public static final int NETDEV_SUBSCRIBE_ALARM_TYPE_COM             = 0X01;     
		public static final int NETDEV_SUBSCRIBE_ALARM_TYPE_SMART           = 0X02;    	
		public static final int NETDEV_SUBSCRIBE_ALARM_TYPE_INTELLIGENTIPC  = 0X04; 	/* IPC */
	}

	
	public static class NETDEV_ORG_TYPE_E extends Structure {
		public static final int NETDEV_ORG_TYPE_GENERAL            = 0;            
		public static final int NETDEV_ORG_TYPE_CLOUD              = 1;            
		public static final int NETDEV_ORG_TYPE_VIRTUAL            = 2;            
		public static final int NETDEV_ORG_TYPE_FAVORITES          = 3;            
		public static final int NETDEV_ORG_TYPE_DOMAIN             = 4;            
		public static final int NETDEV_ORG_TYPE_DOORGROUP          = 5;            
		public static final int NETDEV_ORG_TYPE_DEPT               = 6;            
		public static final int NETDEV_ORG_TYPE_APARTMENT          = 7;            

		public static final int NETDEV_ORG_TYPE_INVALID            = 0XFF;          
	}

	/**
	 * @enum tagNETDEVOrgFindMode
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ORG_FIND_MODE_E extends Structure {
		public static final int NETDEV_ORG_FIND_MODE_ID          = 0;            /* ID */
		public static final int NETDEV_ORG_FIND_MODE_TYPE        = 1;            

		public static final int NETDEV_ORG_FIND_MODE_INVALID     = 0XFF;       
	}

	public static class NETDEV_CHN_TYPE_E extends Structure {
		public static final int NETDEV_CHN_TYPE_ENCODE              = 0;                /* ;  NETDEV_CHN_STATUS_E  NETDEV_DEV_CHN_ENCODE_INFO_S*/
		public static final int NETDEV_CHN_TYPE_ALARMIN             = 1;                /* ;  NETDEV_ALARM_RUNMODE_E  NETDEV_DEV_CHN_ALARMIN_INFO_S*/

		public static final int NETDEV_CHN_TYPE_ALARMOUT            = 2;                /* ;  NETDEV_ALARMOUT_CHN_STATUS_E  NETDEV_DEV_CHN_ALARMOUT_INFO_S*/
		public static final int NETDEV_CHN_TYPE_DECODE              = 3;                /*   NETDEV_DEV_CHN_DECODE_INFO_S*/
		public static final int NETDEV_CHN_TYPE_AUDIO               = 4;                /*   NETDEV_DEV_CHN_AUDIO_INFO_S*/
		public static final int NETDEV_CHN_TYPE_NIC                 = 5;                
		public static final int NETDEV_CHN_TYPE_ALARMPOINT          = 6;                /*   NETDEV_DEV_CHN_DA_INFO_S*/
		public static final int NETDEV_CHN_TYPE_DOOR                = 7;                /*   NETDEV_DEV_CHN_DA_INFO_S*/
		public static final int NETDEV_CHN_TYPE_ADU_ENCODE          = 8;                /* ADU;  NETDEV_CHN_STATUS_E #NETDEV_DEV_CHN_XW_ENCODE_INFO_S */
		public static final int NETDEV_CHN_TYPE_EMERGENCY           = 9;                /*   NETDEV_EMERGENCY_BELL_INFO_S*/

		public static final int NETDEV_CHN_TYPE_INVALID             = 0xFF;              
	}

	/**
	 * @enum tagNETDEVAlarmOutChnStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ALARMOUT_CHN_STATUS_E extends Structure
	{
		public static final int NETDEV_ALARMOUT_CHN_ACTIVE      = 0;
		public static final int NETDEV_ALARMOUT_CHN_INACTIVE    = 1;
		public static final int NETDEV_ALARMOUT_CHN_INVALID     = 0xFF;
	}

	/**
	 * @enum tagNETDEVAlarmInChnStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ALARM_RUNMODE_E extends Structure
	{
		public static final int NETDEV_ALARM_RUNMODE_OPEN       = 0;                /*   Always open */
		public static final int NETDEV_ALARM_RUNMODE_CLOSE      = 1;                /*   Always closed */
		public static final int NETDEV_ALARM_RUNMODE_INVALID    = 0xFF;
	}

	/**
	 * @enum tagNETDEVDeviceMainType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_DEVICE_MAIN_TYPE_E extends Structure {
		public static final int NETDEV_DTYPE_MAIN_ENCODE            = 0;                
		public static final int NETDEV_DTYPE_MAIN_DECODE            = 1;                
		public static final int NETDEV_DTYPE_MAIN_VMS               = 2;                
		public static final int NETDEV_DTYPE_MAIN_DA                = 3;                
		public static final int NETDEV_DTYPE_MAIN_CLOUD             = 4;                
		public static final int NETDEV_DTYPE_MAIN_BAYONET           = 5;                
		public static final int NETDEV_DTYPE_MAIN_ACS               = 6;                
		public static final int NETDEV_DTYPE_MAIN_ALARMHOST         = 7;                
		public static final int NETDEV_DTYPE_MAIN_EXITENTRANCE      = 8;                
		public static final int NETDEV_DTYPE_MAIN_LOCK              = 9;                

		public static final int NETDEV_DTYPE_MAIN_PLAYER_MANAGER    = 10;               
		public static final int NETDEV_DTYPE_MAIN_PLAYER            = 11;               
		public static final int NETDEV_DTYPE_MAIN_UNKNOWN           = 0XFF;              
	}

	/**
	 * @enum tagNETDEVEventResType
	 * @brief    
	 * @attention  None
	 */
	public static class NETDEV_EVENT_RES_TYPE_E extends Structure {
		public static final int NETDEV_EVENT_RES_TYPE_USER              = 0;                
		public static final int NETDEV_EVENT_RES_TYPE_DEVICE            = 1;                
		public static final int NETDEV_EVENT_RES_TYPE_CHANNEL           = 2;                
		public static final int NETDEV_EVENT_RES_TYPE_LOGOUT            = 3;                
		public static final int NETDEV_EVENT_RES_TYPE_SEQUENCE          = 4;                /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_EMAP_HOTPOT       = 5;                /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_EMAP_HOTAREA      = 6;                /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_EMAP_ALARM        = 7;                /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_TIMETEMPLATE      = 8;                /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_SYSRIGHT          = 9;                
		public static final int NETDEV_EVENT_RES_TYPE_DEVRIGHT          = 10;               
		public static final int NETDEV_EVENT_RES_TYPE_ORG   = 11;   
		public static final int NETDEV_EVENT_RES_TYPE_ALARM_TASK= 12;   
		public static final int NETDEV_EVENT_RES_TYPE_SLAVE = 13;   
		public static final int NETDEV_EVENT_RES_TYPE_TVWALL= 14;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_TVWALL_SCENE  = 15;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_WND   = 16;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_VIRTUAL_LED   = 17;   /* LEDLED ID */
		public static final int NETDEV_EVENT_RES_TYPE_BROADCAST_CHANGE  = 18;   
		public static final int NETDEV_EVENT_RES_TYPE_LOGIC_ORG = 19;   
		public static final int NETDEV_EVENT_RES_TYPE_USER_ROLE = 20;   
		public static final int NETDEV_EVENT_RES_TYPE_ROLE_ORG  = 21;   
		public static final int NETDEV_EVENT_RES_TYPE_EMAP_PIC  = 22;   
		public static final int NETDEV_EVENT_RES_TYPE_PATROL= 23;   
		public static final int NETDEV_EVENT_RES_TYPE_RECORD= 24;   
		public static final int NETDEV_EVENT_RES_TYPE_ACS_PERSON= 25;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_ACS_PERSON_CARD   = 26;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_TVWALL_LIST   = 27;   
		public static final int NETDEV_EVENT_RES_TYPE_TVWALL_SCENE_SWITCH = 28; 

		public static final int NETDEV_EVENT_RES_TYPE_FACE_LIB  = 29;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_FACE_CUSTOM   = 30;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_FACE_MEMBER   = 31;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_FACE_GUARD= 32;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_SMART_DETECT  = 33;   /* :0 */
		public static final int NETDEV_EVENT_RES_TYPE_MANUAL_STATUS = 34;   
		public static final int NETDEV_EVENT_RES_TYPE_VEHICLE_GUARD = 38;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_CDN_CHANNEL   = 39;   /* CDN */
		public static final int NETDEV_EVENT_RES_TYPE_FACE_MEMBER_SORT  = 40;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_VEHICLE_LIB   = 41;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER_SORT = 42; /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER  = 43; /* ID */

		public static final int NETDEV_EVENT_RES_TYPE_REMAIN_PARK_SPACE = 44;   
		public static final int NETDEV_EVENT_RES_TYPE_ABNORMAL_CHARGE   = 45;   
		public static final int NETDEV_EVENT_RES_TYPE_PARK_RES_CHANGE   = 46;   
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_PERSON   = 47;        
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_CAR      = 48;        
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_BUILDING = 49;        
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_UNIT     = 50;        
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ROOM     = 51;        
		public static final int NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ORG      = 52;        
		public static final int NETDEV_EVENT_RES_TYPE_TEMP_VEHICLE_PAY_CHANGE = 53; 
		public static final int NETDEV_EVENT_RES_TYPE_THIRDPART_PAYMENT       = 54;         
		public static final int NETDEV_EVENT_RES_TYPE_PAYMENT_WAIT            = 55;         
		public static final int NETDEV_EVENT_RES_TYPE_ENTRANCE_LIST = 56;   
		public static final int NETDEV_EVENT_RES_TYPE_VIEWPLAN_RES  = 57;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_SCENESPLAN_RES= 58;   /* ID */
		public static final int NETDEV_EVENT_RES_TYPE_ACS_PERMISSION= 59;   /* ;  */
		public static final int NETDEV_EVENT_RES_TYPE_ACS_GROUP = 60;   
		public static final int NETDEV_EVENT_RES_TYPE_TVWALL_AUDIO  = 61;   
		public static final int NETDEV_EVENT_RES_TYPE_PAYMENT_RRULE     = 62;               
		public static final int NETDEV_EVENT_RES_TYPE_GIS               = 63;          
		public static final int NETDEV_EVENT_RES_TYPE_INVALID   = 0xFF;  
	}

	/**
	 * @brief     Alarm configuration operation Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_ALARM_TYPE_E extends Structure {
		public static final int NETDEV_ALARM_MOVE_DETECT                = 1;        /*   Motion detection alarm */
		public static final int NETDEV_ALARM_MOVE_DETECT_RECOVER        = 2;        /*   Motion detection alarm recover */
		public static final int NETDEV_ALARM_VIDEO_LOST                 = 3;        /*   Video loss alarm */
		public static final int NETDEV_ALARM_VIDEO_LOST_RECOVER         = 4;        /*   Video loss alarm recover */
		public static final int NETDEV_ALARM_VIDEO_TAMPER_DETECT        = 5;        /*   Tampering detection alarm */
		public static final int NETDEV_ALARM_VIDEO_TAMPER_RECOVER       = 6;        /*   Tampering detection alarm recover */
		public static final int NETDEV_ALARM_INPUT_SWITCH               = 7;        /*   boolean input alarm */
		public static final int NETDEV_ALARM_INPUT_SWITCH_RECOVER       = 8;        /*   Boolean input alarm recover */
		public static final int NETDEV_ALARM_TEMPERATURE_HIGH           = 9;        /*   High temperature alarm */
		public static final int NETDEV_ALARM_TEMPERATURE_LOW            = 10;       /*   Low temperature alarm */
		public static final int NETDEV_ALARM_TEMPERATURE_RECOVER        = 11;       /*   Temperature alarm recover */
		public static final int NETDEV_ALARM_AUDIO_DETECT               = 12;       /*   Audio detection alarm */
		public static final int NETDEV_ALARM_AUDIO_DETECT_RECOVER       = 13;       /*   Audio detection alarm recover */
		public static final int NETDEV_ALARM_SERVER_FAULT               = 18;       
		public static final int NETDEV_ALARM_SERVER_NORMAL              = 19;       


		public static final int NETDEV_ALARM_REPORT_DEV_ONLINE          = 201;       
		public static final int NETDEV_ALARM_REPORT_DEV_OFFLINE         = 202;       
		public static final int NETDEV_ALARM_REPORT_DEV_REBOOT          = 203;       /*   Device restart */
		public static final int NETDEV_ALARM_REPORT_DEV_SERVICE_REBOOT  = 204;       /*   Service restart */
		public static final int NETDEV_ALARM_REPORT_DEV_CHL_ONLINE      = 205;       /* :  */
		public static final int NETDEV_ALARM_REPORT_DEV_CHL_OFFLINE     = 206;       /* :  */
		public static final int NETDEV_ALARM_REPORT_DEV_DELETE_CHL      = 207;       /* :  */

		public static final int NETDEV_ALARM_DEVICE_HIGHTEMP            = 246;       /* ： */
		public static final int NETDEV_ALARM_DEVICE_LOWTEMP             = 247;       /* ： */
		public static final int NETDEV_ALARM_FAN_FAULT                  = 248;       /* ： */
		public static final int NETDEV_ALARM_LEDBOX_HIGHTEMP            = 249;       /* ： */
		public static final int NETDEV_ALARM_LEDBOX_SMOKE               = 250;       /* ： */
		public static final int NETDEV_ALARM_DEVICE_HIGHTEMP_RECOVER    = 251;       /* : */
		public static final int NETDEV_ALARM_DEVICE_LOWTEMP_RECOVER     = 252;       /* : */
		public static final int NETDEV_ALARM_FAN_FAULT_RECOVER          = 253;       /* : */
		public static final int NETDEV_ALARM_LEDBOX_HIGHTEMP_RECOVER    = 254;       /* : */
		public static final int NETDEV_ALARM_LEDBOX_SMOKE_RECOVER       = 255;       /* : */

		/* ND  */
		public static final int NETDEV_ALARM_NET_FAILED                 = 401;      /*  Network error */
		public static final int NETDEV_ALARM_NET_TIMEOUT                = 402;      /*  Network timeout */
		public static final int NETDEV_ALARM_SHAKE_FAILED               = 403;      /*  Interaction error */
		public static final int NETDEV_ALARM_STREAMNUM_FULL             = 404;      /*  Stream full */
		public static final int NETDEV_ALARM_STREAM_THIRDSTOP           = 405;      /*  Third party stream stopped */
		public static final int NETDEV_ALARM_FILE_END                   = 406;      /*  File ended */
		public static final int NETDEV_ALARM_RTMP_CONNECT_FAIL          = 407;      /* RTMP */
		public static final int NETDEV_ALARM_RTMP_INIT_FAIL             = 408;      /* RTMP*/
		public static final int NETDEV_ALARM_STREAM_DOWNLOAD_OVER       = 409;      
		public static final int NETDEV_ALARM_PLAYBACK_FINISH            = 410;      
		public static final int NETDEV_ALARM_VIDEO_RECORD_PART          = 411;      
		public static final int NETDEV_ALARM_FISHEYE_STREAM_EXIST       = 412;      /* , */
		public static final int NETDEV_ALARM_FISHEYE_STREAM_NOT_EXIST   = 413;      /* , */
		public static final int NETDEV_ALARM_PTZ_RESOUCE_FAIL           = 414;      /* ptz */
		public static final int NETDEV_ALARM_PTZ_STREAM_EXIST           = 415;      /* ptz */
		public static final int NETDEV_ALARM_STREAM_NOT_EXIST           = 416;      /* ptz */
		public static final int NETDEV_ALARM_INNER_TIMEOUT              = 417;      
		public static final int NETDEV_ALARM_STREAM_NOT_READY           = 418;      
		public static final int NETDEV_ALARM_KEEP_ALIVE_FAILED          = 419;      
		public static final int NETDEV_ALARM_OVER_ABILITY               = 420;      
		public static final int NETDEV_ALARM_UNAUTHORIZED               = 421;      
		public static final int NETDEV_ALARM_FORIBIDDEN                 = 422;      
		public static final int NETDEV_ALARM_METHOD_NOT_ALLOWED         = 423;      
		public static final int NETDEV_ALARM_PRECONDITION_FAILED        = 424;      
		public static final int NETDEV_ALARM_SESSION_NOT_FOUND          = 425;      
		public static final int NETDEV_ALARM_NOT_ENOUGH_BANDWIDTH2      = 426;      /* (RTSP) */
		public static final int NETDEV_ALARM_REALPLAY_ESTABLISHED       = 427;      
		public static final int NETDEV_ALARM_REALPLAY_RES_BUSY          = 428;      
		public static final int NETDEV_ALARM_MULTICAST_DISABLED         = 429;      
		public static final int NETDEV_ALARM_MULTICAST_PORT_OCCUPIED    = 430;      
		public static final int NETDEV_ALARM_MULTICAST_PORT_EXHAUSTED   = 431;      
		public static final int NETDEV_ALARM_MULTICAST_USER_NOT_EXIST   = 432;      
		public static final int NETDEV_ALARM_CHANNEL_NOT_ONLINE         = 433;      
		public static final int NETDEV_ALARM_TALKBACK_ENCODED_INVALID   = 434;      
		public static final int NETDEV_ALARM_VOICE_RES_USED_BY_TALKBACK = 435;      
		public static final int NETDEV_ALARM_TALKBACK_EXISTS            = 436;      
		public static final int NETDEV_ALARM_VOICE_WORK_NOT_EXIST       = 437;      
		public static final int NETDEV_ALARM_TALKBACK_TIMEOUT           = 438;      
		public static final int NETDEV_ALARM_TALKBACK_ERROR             = 439;      

		public static final int NETDEV_ALARM_DISK_ERROR                         = 601;      /*   Disk error */
		public static final int NETDEV_ALARM_SYS_DISK_ERROR                     = 602;      /*   Disk error */
		public static final int NETDEV_ALARM_DISK_ONLINE                        = 603;      /*  Disk online */
		public static final int NETDEV_ALARM_SYS_DISK_ONLINE                    = 604;      /*  Disk online */
		public static final int NETDEV_ALARM_DISK_OFFLINE                       = 605;      
		public static final int NETDEV_ALARM_SYS_DISK_OFFLINE                   = 606;      
		public static final int NETDEV_ALARM_DISK_ABNORMAL                      = 607;      /*  Disk abnormal */
		public static final int NETDEV_ALARM_DISK_ABNORMAL_RECOVER              = 608;      /*  Disk abnormal recover */
		public static final int NETDEV_ALARM_DISK_STORAGE_WILL_FULL             = 609;      /*  Disk StorageGoingfull */
		public static final int NETDEV_ALARM_DISK_STORAGE_WILL_FULL_RECOVER     = 610;      /*  Disk StorageGoingfull recover */
		public static final int NETDEV_ALARM_DISK_STORAGE_IS_FULL               = 611;      /*  StorageIsfull */
		public static final int NETDEV_ALARM_SYS_DISK_STORAGE_IS_FULL           = 612;      /*  StorageIsfull */
		public static final int NETDEV_ALARM_DISK_STORAGE_IS_FULL_RECOVER       = 613;      /*  StorageIsfull recover */
		public static final int NETDEV_ALARM_DISK_RAID_DISABLED_RECOVER         = 614;      /*  RAIDDisabled recover */
		public static final int NETDEV_ALARM_DISK_RAID_DEGRADED                 = 615;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_SYS_DISK_RAID_DEGRADED             = 616;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_DISK_RAID_DISABLED                 = 617;      /*  RAIDDisabled */
		public static final int NETDEV_ALARM_SYS_DISK_RAID_DISABLED             = 618;      /*  RAIDDisabled */
		public static final int NETDEV_ALARM_DISK_RAID_DEGRADED_RECOVER         = 619;      /*  RAIDDegraded recover */
		public static final int NETDEV_ALARM_STOR_GO_FULL                       = 620;      
		public static final int NETDEV_ALARM_SYS_STOR_GO_FULL                   = 621;      
		public static final int NETDEV_ALARM_ARRAY_NORMAL                       = 622;      
		public static final int NETDEV_ALARM_SYS_ARRAY_NORMAL                   = 623;      
		public static final int NETDEV_ALARM_DISK_RAID_RECOVERED                = 624;      /*  RAIDDegraded */
		public static final int NETDEV_ALARM_STOR_ERR                           = 625;      /*   Storage error */
		public static final int NETDEV_ALARM_SYS_STOR_ERR                       = 626;      /*   Storage error */
		public static final int NETDEV_ALARM_STOR_ERR_RECOVER                   = 627;      /*   Storage error recover */
		public static final int NETDEV_ALARM_STOR_DISOBEY_PLAN                  = 628;      /*   Not stored as planned */
		public static final int NETDEV_ALARM_STOR_DISOBEY_PLAN_RECOVER          = 629;      /*   Not stored as planned recover */

		public static final int NETDEV_ALARM_BANDWITH_CHANGE                    = 801;      
		public static final int NETDEV_ALARM_VIDEOENCODER_CHANGE                = 802;      
		public static final int NETDEV_ALARM_IP_CONFLICT                        = 803;      /* IP IP conflict exception alarm*/
		public static final int NETDEV_ALARM_IP_CONFLICT_CLEARED                = 804;      /* IPIP conflict exception alarm recovery */
		public static final int NETDEV_ALARM_NET_OFF                            = 805;      
		public static final int NETDEV_ALARM_NET_RESUME_ON                      = 806;      

		public static final int NETDEV_ALRAM_CONFLAG_DETECT                     = 920;      /*  Conflagration detection alarm */

		public static final int NETDEV_ALARM_ILLEGAL_ACCESS                     = 1001;          /*   Illegal access */
		public static final int NETDEV_ALARM_SYS_ILLEGAL_ACCESS                 = 1002;          /*   Illegal access */
		public static final int NETDEV_ALARM_LINE_CROSS                         = 1003;          /*   Line cross */
		public static final int NETDEV_ALARM_OBJECTS_INSIDE                     = 1004;          /*   Objects inside */
		public static final int NETDEV_ALARM_FACE_RECOGNIZE                     = 1005;          /*   Face recognize */
		public static final int NETDEV_ALARM_IMAGE_BLURRY                       = 1006;          /*   Image blurry */
		public static final int NETDEV_ALARM_SCENE_CHANGE                       = 1007;          /*   Scene change */
		public static final int NETDEV_ALARM_SMART_TRACK                        = 1008;          /*   Smart track */
		public static final int NETDEV_ALARM_LOITERING_DETECTOR                 = 1009;          /*   Loitering Detector */
		public static final int NETDEV_ALARM_BANDWIDTH_CHANGE                   = 1010;          /*   Bandwidth change */
		public static final int NETDEV_ALARM_ALLTIME_FLAG_END                   = 1011;          /*   End marker of alarm without arming schedule */
		public static final int NETDEV_ALARM_MEDIA_CONFIG_CHANGE                = 1012;          /*  media configurationchanged */
		public static final int NETDEV_ALARM_REMAIN_ARTICLE                     = 1013;          /*  Remain article*/
		public static final int NETDEV_ALARM_PEOPLE_GATHER                      = 1014;          /*  People gather alarm*/
		public static final int NETDEV_ALARM_ENTER_AREA                         = 1015;          /*  Enter area*/
		public static final int NETDEV_ALARM_LEAVE_AREA                         = 1016;          /*  Leave area*/
		public static final int NETDEV_ALARM_ARTICLE_MOVE                       = 1017;          /*  Article move*/
		public static final int NETDEV_ALARM_SMART_FACE_MATCH_LIST                  = 1018;       
		public static final int NETDEV_ALARM_SMART_FACE_MATCH_LIST_RECOVER          = 1019;       
		public static final int NETDEV_ALARM_SMART_FACE_MISMATCH_LIST               = 1020;       
		public static final int NETDEV_ALARM_SMART_FACE_MISMATCH_LIST_RECOVER       = 1021;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST               = 1022;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST_RECOVER       = 1023;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST            = 1024;       
		public static final int NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST_RECOVER    = 1025;       
		public static final int NETDEV_ALARM_IMAGE_BLURRY_RECOVER               = 1026;         /*   Image blurry recover */
		public static final int NETDEV_ALARM_SMART_TRACK_RECOVER                = 1027;         /*   Smart track recover */
		public static final int NETDEV_ALARM_SMART_READ_ERROR_RATE              = 1028;         /* Error reding the underlying data */
		public static final int NETDEV_ALARM_SMART_SPIN_UP_TIME                 = 1029;         /*   Rotation time of spindle */
		public static final int NETDEV_ALARM_SMART_START_STOP_COUNT             = 1030;         /*  Rev. Stop counting*/
		public static final int NETDEV_ALARM_SMART_REALLOCATED_SECTOR_COUNT     = 1031;         /*   Remap sector count*/
		public static final int NETDEV_ALARM_SMART_SEEK_ERROR_RATE              = 1032;         /*  Trace error rate*/
		public static final int NETDEV_ALARM_SMART_POWER_ON_HOURS               = 1033;         
		public static final int NETDEV_ALARM_SMART_SPIN_RETRY_COUNT             = 1034;         
		public static final int NETDEV_ALARM_SMART_CALIBRATION_RETRY_COUNT      = 1035;         
		public static final int NETDEV_ALARM_SMART_POWER_CYCLE_COUNT            = 1036;         
		public static final int NETDEV_ALARM_SMART_POWEROFF_RETRACT_COUNT       = 1037;         
		public static final int NETDEV_ALARM_SMART_LOAD_CYCLE_COUNT             = 1038;         
		public static final int NETDEV_ALARM_SMART_TEMPERATURE_CELSIUS          = 1039;         
		public static final int NETDEV_ALARM_SMART_REALLOCATED_EVENT_COUNT      = 1040;         
		public static final int NETDEV_ALARM_SMART_CURRENT_PENDING_SECTOR       = 1041;         
		public static final int NETDEV_ALARM_SMART_OFFLINE_UNCORRECTABLE        = 1042;         
		public static final int NETDEV_ALARM_SMART_UDMA_CRC_ERROR_COUNT         = 1043;         
		public static final int NETDEV_ALARM_SMART_MULTI_ZONE_ERROR_RATE        = 1044;         
		public static final int NETDEV_ALARM_RESOLUTION_CHANGE                  = 1045;         
		public static final int NETDEV_ALARM_MANUAL                             = 1401;         
		public static final int NETDEV_ALARM_ALARMHOST_COMMON                   = 1402;         
		public static final int NETDEV_ALARM_DOORHOST_COMMON                    = 1403;         
		public static final int NETDEV_ALARM_FACE_NOT_MATCH                     = 1411;         
		public static final int NETDEV_ALARM_FACE_MATCH_SUCCEED                 = 1412;         

		public static final int NETDEV_ALARM_VEHICLE_BLACK_LIST                 = 1420;         
		public static final int NETDEV_ALARM_HUMAN_SHAPE_DETECTION              = 1421;         
		public static final int NETDEV_ALARM_HUMAN_SHAPE_DETECTION_RECOVER      = 1422;         

		public static final int NETDEV_ALARM_INVALID                            = 0xFFFF;        /*   Invalid value */
	}

	public static class NETDEV_ALARM_SUBTYPE_E extends Structure {
		public static final int NETDEV_ALARM_SUB_TYPE_NOT_CONFIGURED       = 0;                                         

		public static final int NETDEV_DEV_TYPE_BASE                       = (100000);                                
		public static final int NETDEV_DEV_TROUBLE                         = (NETDEV_DEV_TYPE_BASE + 1);                
		public static final int NETDEV_DEV_ALARM_EMERGENCY                 = (NETDEV_DEV_TYPE_BASE + 2);                

		
		public static final int NETDEV_ALARM_EVENT_BASE                    = (100200);                                
		public static final int NETDEV_ALARM_EVENT_FIRE_ALARM              = (NETDEV_ALARM_EVENT_BASE + 1);             
		public static final int NETDEV_ALARM_EVENT_KEYPADFIRE              = (NETDEV_ALARM_EVENT_BASE + 2);             
		public static final int NETDEV_ALARM_EVENT_KEYPADEMERGENCY         = (NETDEV_ALARM_EVENT_BASE + 3);             
		public static final int NETDEV_ALARM_EVENT_KEYPADMEDICAL           = (NETDEV_ALARM_EVENT_BASE + 4);             
		public static final int NETDEV_ALARM_EVENT_DURESSCODEUSED          = (NETDEV_ALARM_EVENT_BASE + 5);             
		public static final int NETDEV_ALARM_EVENT_UNAUTHORIZEDENTRY       = (NETDEV_ALARM_EVENT_BASE + 6);             
		public static final int NETDEV_ALARM_EVENT_BURGLARPOINTALARM       = (NETDEV_ALARM_EVENT_BASE + 7);             
		public static final int NETDEV_ALARM_EVENT_SUPERVISORY             = (NETDEV_ALARM_EVENT_BASE + 8);             
		public static final int NETDEV_ALARM_EVENT_FIRETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 9);             
		public static final int NETDEV_ALARM_EVENT_FIREPOINTTROUBLE        = (NETDEV_ALARM_EVENT_BASE + 10);            
		public static final int NETDEV_ALARM_EVENT_BURGLARPOINTTROUBLE     = (NETDEV_ALARM_EVENT_BASE + 11);            
		public static final int NETDEV_ALARM_EVENT_CANCELALARM             = (NETDEV_ALARM_EVENT_BASE + 12);            
		public static final int NETDEV_ALARM_EVENT_DISARM                  = (NETDEV_ALARM_EVENT_BASE + 13);            
		public static final int NETDEV_ALARM_EVENT_ARM                     = (NETDEV_ALARM_EVENT_BASE + 14);            
		public static final int NETDEV_ALARM_EVENT_FORCEDBYPASS            = (NETDEV_ALARM_EVENT_BASE + 15);            
		public static final int NETDEV_ALARM_EVENT_BYPASS                  = (NETDEV_ALARM_EVENT_BASE + 16);            
		public static final int NETDEV_ALARM_EVENT_POINTRESTORAL           = (NETDEV_ALARM_EVENT_BASE + 17);            
		public static final int NETDEV_ALARM_EVENT_FAILTOCLOSE             = (NETDEV_ALARM_EVENT_BASE + 18);            
		public static final int NETDEV_ALARM_EVENT_FAILTOOPEN              = (NETDEV_ALARM_EVENT_BASE + 19);            
		public static final int NETDEV_ALARM_EVENT_HISTORYBUFFERDUMP       = (NETDEV_ALARM_EVENT_BASE + 20);            
		public static final int NETDEV_ALARM_EVENT_TESTMSG                 = (NETDEV_ALARM_EVENT_BASE + 21);            
		public static final int NETDEV_ALARM_EVENT_ZONETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 22);            
		public static final int NETDEV_ALARM_EVENT_ZONETROUBLERESTORE      = (NETDEV_ALARM_EVENT_BASE + 23);            
		public static final int NETDEV_ALARM_EVENT_ZONESHORT               = (NETDEV_ALARM_EVENT_BASE + 24);            
		public static final int NETDEV_ALARM_EVENT_ZONEOPEN                = (NETDEV_ALARM_EVENT_BASE + 25);            
		public static final int NETDEV_ALARM_EVENT_ZONENORMAL              = (NETDEV_ALARM_EVENT_BASE + 26);            
		public static final int NETDEV_ALARM_EVENT_MXDEVCLOSE              = (NETDEV_ALARM_EVENT_BASE + 27);            /* MX */
		public static final int NETDEV_ALARM_EVENT_MXDEVOPEN               = (NETDEV_ALARM_EVENT_BASE + 28);            /* MX */
		public static final int NETDEV_ALARM_EVENT_MXDEV1ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 29);            /* MX1 */
		public static final int NETDEV_ALARM_EVENT_MXDEV2ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 30);            /* MX2 */
		public static final int NETDEV_ALARM_EVENT_MXDEV3ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 31);            /* MX3 */
		public static final int NETDEV_ALARM_EVENT_MXDEV1ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 32);            /* MX1 */
		public static final int NETDEV_ALARM_EVENT_MXDEV2ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 33);            /* MX2 */
		public static final int NETDEV_ALARM_EVENT_MXDEV3ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 34);            /* MX3 */
		public static final int NETDEV_ALARM_EVENT_TROUBLE_AC              = (NETDEV_ALARM_EVENT_BASE + 35);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_BATTERY         = (NETDEV_ALARM_EVENT_BASE + 36);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_SNDREPORT       = (NETDEV_ALARM_EVENT_BASE + 37);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_CONTROL         = (NETDEV_ALARM_EVENT_BASE + 38);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_MXBUS           = (NETDEV_ALARM_EVENT_BASE + 39);            /* MPX */
		public static final int NETDEV_ALARM_EVENT_TROUBLE_RADIOSND        = (NETDEV_ALARM_EVENT_BASE + 40);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_ASSISTPOWER     = (NETDEV_ALARM_EVENT_BASE + 41);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_OPTION          = (NETDEV_ALARM_EVENT_BASE + 42);            /* option */
		public static final int NETDEV_ALARM_EVENT_LINK_BREAK              = (NETDEV_ALARM_EVENT_BASE + 43);            
		public static final int NETDEV_ALARM_EVENT_LINK_RESUME             = (NETDEV_ALARM_EVENT_BASE + 44);            
		public static final int NETDEV_ALARM_EVENT_VOLTAGE_ALARM           = (NETDEV_ALARM_EVENT_BASE + 45);            
		public static final int NETDEV_ALARM_EVENT_EXTERNDEV_TROUBLE       = (NETDEV_ALARM_EVENT_BASE + 46);            
		public static final int NETDEV_ALARM_EVENT_EXTERNDEV_RESUME        = (NETDEV_ALARM_EVENT_BASE + 47);            
		public static final int NETDEV_ALARM_EVENT_POINT_DISARM            = (NETDEV_ALARM_EVENT_BASE + 48);            
		public static final int NETDEV_ALARM_EVENT_POINT_ARM               = (NETDEV_ALARM_EVENT_BASE + 49);            
		public static final int NETDEV_ALARM_EVENT_FORCE_OPEN              = (NETDEV_ALARM_EVENT_BASE + 50);            
		public static final int NETDEV_ALARM_EVENT_BYPASS_FAILED           = (NETDEV_ALARM_EVENT_BASE + 51);            
		public static final int NETDEV_ALARM_EVENT_RESET_FAILED            = (NETDEV_ALARM_EVENT_BASE + 52);            
		public static final int NETDEV_ALARM_EVENT_POINT_FIRETROUBLE       = (NETDEV_ALARM_EVENT_BASE + 53);            
		public static final int NETDEV_ALARM_EVENT_POINT_SEPARATE          = (NETDEV_ALARM_EVENT_BASE + 54);            
		public static final int NETDEV_ALARM_EVENT_POINT_ACTION            = (NETDEV_ALARM_EVENT_BASE + 55);            
		public static final int NETDEV_ALARM_EVENT_POINT_RESUME            = (NETDEV_ALARM_EVENT_BASE + 56);            
		public static final int NETDEV_ALARM_EVENT_ROB_ACTION              = (NETDEV_ALARM_EVENT_BASE + 57);            

		
		public static final int NETDEV_ALARM_EVENT_MISSED_ARM              = (NETDEV_ALARM_EVENT_BASE + 60);            
		public static final int NETDEV_ALARM_EVENT_MISSED_DISARM           = (NETDEV_ALARM_EVENT_BASE + 61);            
		public static final int NETDEV_ALARM_EVENT_AUXILARY_RST            = (NETDEV_ALARM_EVENT_BASE + 62);            
		public static final int NETDEV_ALARM_EVENT_AUXILARY                = (NETDEV_ALARM_EVENT_BASE + 63);            
		public static final int NETDEV_ALARM_EVENT_BURGLARY_RST            = (NETDEV_ALARM_EVENT_BASE + 64);            
		public static final int NETDEV_ALARM_EVENT_BURGLARY                = (NETDEV_ALARM_EVENT_BASE + 65);            
		public static final int NETDEV_ALARM_EVENT_BYPASS_RST              = (NETDEV_ALARM_EVENT_BASE + 66);            
		public static final int NETDEV_ALARM_EVENT_CANCEL                  = (NETDEV_ALARM_EVENT_BASE + 67);            
		public static final int NETDEV_ALARM_EVENT_DUPLICATE               = (NETDEV_ALARM_EVENT_BASE + 68);            
		public static final int NETDEV_ALARM_EVENT_DURESS_RST              = (NETDEV_ALARM_EVENT_BASE + 69);            
		public static final int NETDEV_ALARM_EVENT_DURESS                  = (NETDEV_ALARM_EVENT_BASE + 70);            
		public static final int NETDEV_ALARM_EVENT_FIRE_RST                = (NETDEV_ALARM_EVENT_BASE + 71);            
		public static final int NETDEV_ALARM_EVENT_FIRE_TROUBLE            = (NETDEV_ALARM_EVENT_BASE + 72);            
		public static final int NETDEV_ALARM_EVENT_FIRE_TRB_RST            = (NETDEV_ALARM_EVENT_BASE + 73);            
		public static final int NETDEV_ALARM_EVENT_MED_RST                 = (NETDEV_ALARM_EVENT_BASE + 74);            
		public static final int NETDEV_ALARM_EVENT_PANIC                   = (NETDEV_ALARM_EVENT_BASE + 75);            
		public static final int NETDEV_ALARM_EVENT_PANIC_RST               = (NETDEV_ALARM_EVENT_BASE + 76);            
		public static final int NETDEV_ALARM_EVENT_RESET                   = (NETDEV_ALARM_EVENT_BASE + 77);            
		public static final int NETDEV_ALARM_EVENT_RELAY_SHORTED           = (NETDEV_ALARM_EVENT_BASE + 78);            
		public static final int NETDEV_ALARM_EVENT_RELAY_RST               = (NETDEV_ALARM_EVENT_BASE + 79);            
		public static final int NETDEV_ALARM_EVENT_RELAY_TROUBLE           = (NETDEV_ALARM_EVENT_BASE + 80);            
		public static final int NETDEV_ALARM_EVENT_TAMPER                  = (NETDEV_ALARM_EVENT_BASE + 81);            
		public static final int NETDEV_ALARM_EVENT_TAMPER_RST              = (NETDEV_ALARM_EVENT_BASE + 82);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE                 = (NETDEV_ALARM_EVENT_BASE + 83);            
		public static final int NETDEV_ALARM_EVENT_TROUBLE_RST             = (NETDEV_ALARM_EVENT_BASE + 84);            

		/* DF8900 */
		public static final int NETDEV_ALARM_EVENT_DFE_REMOTE_CONTROL      = (NETDEV_ALARM_EVENT_BASE + 90);            
		public static final int NETDEV_ALARM_EVENT_DFE_SYNC                = (NETDEV_ALARM_EVENT_BASE + 91);            
		public static final int NETDEV_ALARM_EVENT_DFE_LIFTING             = (NETDEV_ALARM_EVENT_BASE + 92);            
		public static final int NETDEV_ALARM_EVENT_DFE_SWITCH_NORMAL       = (NETDEV_ALARM_EVENT_BASE + 93);            
		public static final int NETDEV_ALARM_EVENT_DFE_SWITCH_ACCIDENT     = (NETDEV_ALARM_EVENT_BASE + 94);            
		public static final int NETDEV_ALARM_EVENT_DFE_KINFE_GATE          = (NETDEV_ALARM_EVENT_BASE + 95);            

		
		public static final int NETDEV_ALARM_EVENT_ESCAPE                  = (NETDEV_ALARM_EVENT_BASE + 96);            
		public static final int NETDEV_ALARM_EVENT_ESCAPE_END              = (NETDEV_ALARM_EVENT_BASE + 97);            
		public static final int NETDEV_ALARM_EVENT_VIOLENCE                = (NETDEV_ALARM_EVENT_BASE + 98);            
		public static final int NETDEV_ALARM_EVENT_VIOLENCE_END            = (NETDEV_ALARM_EVENT_BASE + 99);            
		public static final int NETDEV_ALARM_EVENT_ATTACKED                = (NETDEV_ALARM_EVENT_BASE + 100);           
		public static final int NETDEV_ALARM_EVENT_ATTACKED_END            = (NETDEV_ALARM_EVENT_BASE + 101);           
		public static final int NETDEV_ALARM_EVENT_NATURAL_DISASTER        = (NETDEV_ALARM_EVENT_BASE + 102);           
		public static final int NETDEV_ALARM_EVENT_NATURAL_DISASTER_END    = (NETDEV_ALARM_EVENT_BASE + 103);           
		public static final int NETDEV_ALARM_EVENT_ONE_KEY_ALARM           = (NETDEV_ALARM_EVENT_BASE + 104);           
		public static final int NETDEV_ALARM_EVENT_ONE_KEY_ALARM_END       = (NETDEV_ALARM_EVENT_BASE + 105);           

		
		public static final int NETDEV_ALARM_EVENT_CERC_NORMAL             = (NETDEV_ALARM_EVENT_BASE + 106);           
		public static final int NETDEV_ALARM_EVENT_CERC_TOUCH              = (NETDEV_ALARM_EVENT_BASE + 107);           
		public static final int NETDEV_ALARM_EVENT_CERC_BREAK              = (NETDEV_ALARM_EVENT_BASE + 108);           
		public static final int NETDEV_ALARM_EVENT_CERC_SHORT              = (NETDEV_ALARM_EVENT_BASE + 109);           
		public static final int NETDEV_ALARM_EVENT_CERC_COMMU_ERR          = (NETDEV_ALARM_EVENT_BASE + 110);           

		
		public static final int NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM      = (NETDEV_ALARM_EVENT_BASE + 111);           
		public static final int NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM_RST  = (NETDEV_ALARM_EVENT_BASE + 112);           
		public static final int NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM       = (NETDEV_ALARM_EVENT_BASE + 113);           
		public static final int NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM_RST   = (NETDEV_ALARM_EVENT_BASE + 114);           

		
		public static final int NETDEV_ALARM_EVENT_UBI_ALARM               = (NETDEV_ALARM_EVENT_BASE + 115);           

		
		public static final int NETDEV_ALARM_EVENT_HXTECH_CABLE_ALARM      = (NETDEV_ALARM_EVENT_BASE + 116);           

		
		public static final int NETDEV_ALARM_EVENT_DEVICE_UNDER_VOLTAGE_RST            = (NETDEV_ALARM_EVENT_BASE + 117);               
		public static final int NETDEV_ALARM_EVENT_ZONE_NOT_READY                      = (NETDEV_ALARM_EVENT_BASE + 118);               
		public static final int NETDEV_ALARM_EVENT_ZONE_NOT_READY_RST                  = (NETDEV_ALARM_EVENT_BASE + 119);               
		public static final int NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT               = (NETDEV_ALARM_EVENT_BASE + 120);               
		public static final int NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT_RST           = (NETDEV_ALARM_EVENT_BASE + 121);               
		public static final int NETDEV_ALARM_EVENT_AC_POWER_FAULT                      = (NETDEV_ALARM_EVENT_BASE + 122);               

		
		public static final int NETDEV_ALARM_EVENT_ZONE_TOUCH                          = (NETDEV_ALARM_EVENT_BASE + 123);    
		public static final int NETDEV_ALARM_EVENT_ZONE_TOUCH_RESTORE                  = (NETDEV_ALARM_EVENT_BASE + 124);    
		public static final int NETDEV_ALARM_EVENT_CAPTIVE                             = (NETDEV_ALARM_EVENT_BASE + 125);    
		public static final int NETDEV_ALARM_EVENT_CAPTIVE_RST                         = (NETDEV_ALARM_EVENT_BASE + 126);    
		public static final int NETDEV_ALARM_EVENT_UNDERVOLTAGE                        = (NETDEV_ALARM_EVENT_BASE + 127);    
		public static final int NETDEV_ALARM_EVENT_UNDERVOLTAGE_RST                    = (NETDEV_ALARM_EVENT_BASE + 128);    
		public static final int NETDEV_ALARM_EVENT_TROUBLE_BATTERY_RST                 = (NETDEV_ALARM_EVENT_BASE + 129);    
		public static final int NETDEV_ALARM_EVENT_DEV_POWER_REBOOT                    = (NETDEV_ALARM_EVENT_BASE + 130);    
		public static final int NETDEV_ALARM_EVENT_TEST_FAILURE                        = (NETDEV_ALARM_EVENT_BASE + 131);    
		public static final int NETDEV_ALARM_EVENT_OPERATOR_TOUCH_LONG                 = (NETDEV_ALARM_EVENT_BASE + 132);    
		public static final int NETDEV_ALARM_EVENT_REMOTE_ARM                          = (NETDEV_ALARM_EVENT_BASE + 133);    
		public static final int NETDEV_ALARM_EVENT_REMOTE_DISARM                       = (NETDEV_ALARM_EVENT_BASE + 134);    
		public static final int NETDEV_ALARM_EVENT_REMOTE_STAY_ARM                     = (NETDEV_ALARM_EVENT_BASE + 135);    
		public static final int NETDEV_ALARM_EVENT_PWD_ARM                             = (NETDEV_ALARM_EVENT_BASE + 136);    
		public static final int NETDEV_ALARM_EVENT_PWD_DISARM                          = (NETDEV_ALARM_EVENT_BASE + 137);    
		public static final int NETDEV_ALARM_EVENT_PWD_STAY_DEV                        = (NETDEV_ALARM_EVENT_BASE + 138);    
		public static final int NETDEV_ALARM_EVENT_PWD_ARM_PART                        = (NETDEV_ALARM_EVENT_BASE + 139);    
		public static final int NETDEV_ALARM_EVENT_PWD_DISARM_PART                     = (NETDEV_ALARM_EVENT_BASE + 140);    
		public static final int NETDEV_ALARM_EVENT_PWD_STAY_PART                       = (NETDEV_ALARM_EVENT_BASE + 141);    
		public static final int NETDEV_ALARM_EVENT_PWD_ARM_ZONE                        = (NETDEV_ALARM_EVENT_BASE + 142);    
		public static final int NETDEV_ALARM_EVENT_PWD_DISARM_ZONE                     = (NETDEV_ALARM_EVENT_BASE + 143);    
		public static final int NETDEV_ALARM_EVENT_USER_ARM                            = (NETDEV_ALARM_EVENT_BASE + 144);    
		public static final int NETDEV_ALARM_EVENT_USER_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 145);    
		public static final int NETDEV_ALARM_EVENT_USER_STAY_DEV                       = (NETDEV_ALARM_EVENT_BASE + 146);    
		public static final int NETDEV_ALARM_EVENT_USER_CLEAN_ALARM                    = (NETDEV_ALARM_EVENT_BASE + 147);    
		public static final int NETDEV_ALARM_EVENT_PWD_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 148);    
		public static final int NETDEV_ALARM_EVENT_KEY_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 149);    
		public static final int NETDEV_ALARM_EVENT_REMOTE_OPEN_DOOR                    = (NETDEV_ALARM_EVENT_BASE + 150);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_ARM                           = (NETDEV_ALARM_EVENT_BASE + 151);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 152);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_LOCK                          = (NETDEV_ALARM_EVENT_BASE + 153);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_UNLOCK                        = (NETDEV_ALARM_EVENT_BASE + 154);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_RECORD                        = (NETDEV_ALARM_EVENT_BASE + 155);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_IN                 = (NETDEV_ALARM_EVENT_BASE + 156);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_OUT                = (NETDEV_ALARM_EVENT_BASE + 157);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_TURNON_LIGHT                  = (NETDEV_ALARM_EVENT_BASE + 158);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_OFF_LIGHT                     = (NETDEV_ALARM_EVENT_BASE + 159);    
		public static final int NETDEV_ALARM_EVENT_SWIPE_CARD_NUM                      = (NETDEV_ALARM_EVENT_BASE + 160);    
		public static final int NETDEV_ALARM_EVENT_MANUAL_OPEN                         = (NETDEV_ALARM_EVENT_BASE + 161);    /* /  */
		public static final int NETDEV_ALARM_EVENT_ZONE_OPEN_DOOR                      = (NETDEV_ALARM_EVENT_BASE + 162);    
		public static final int NETDEV_ALARM_EVENT_ZONE_DOOR_LONGTIME                  = (NETDEV_ALARM_EVENT_BASE + 163);    
		public static final int NETDEV_ALARM_EVENT_ZONE_ARM                            = (NETDEV_ALARM_EVENT_BASE + 164);    
		public static final int NETDEV_ALARM_EVENT_ZONE_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 165);    
		public static final int NETDEV_ALARM_EVENT_TIMER_ARM                           = (NETDEV_ALARM_EVENT_BASE + 166);    
		public static final int NETDEV_ALARM_EVENT_TIMER_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 167);    
		public static final int NETDEV_ALARM_EVENT_CENTRAL_COMM_NORMAL                 = (NETDEV_ALARM_EVENT_BASE + 168);    
		public static final int NETDEV_ALARM_EVENT_CENTRAL_HANDSHAKE_FAILED            = (NETDEV_ALARM_EVENT_BASE + 169);    
		public static final int NETDEV_ALARM_EVENT_CENTRAL_RESPONSE_FAILED             = (NETDEV_ALARM_EVENT_BASE + 170);    
		public static final int NETDEV_ALARM_EVENT_USER_CONFIRMATION                   = (NETDEV_ALARM_EVENT_BASE + 171);    
		public static final int NETDEV_ALARM_EVENT_USER_TIMEOUT                        = (NETDEV_ALARM_EVENT_BASE + 172);    
		public static final int NETDEV_ALARM_EVENT_TELEP_RINGING                       = (NETDEV_ALARM_EVENT_BASE + 173);    
		public static final int NETDEV_ALARM_EVENT_TELEP_ARM                           = (NETDEV_ALARM_EVENT_BASE + 174);    
		public static final int NETDEV_ALARM_EVENT_TELEP_STATUS_OFFLINE                = (NETDEV_ALARM_EVENT_BASE + 175);    
		public static final int NETDEV_ALARM_EVENT_TELEP_STATUS_ONLINE                 = (NETDEV_ALARM_EVENT_BASE + 176);    
		public static final int NETDEV_ALARM_EVENT_MSG_SEND_SUCC                       = (NETDEV_ALARM_EVENT_BASE + 177);    
		public static final int NETDEV_ALARM_EVENT_MSG_SEND_FAILED                     = (NETDEV_ALARM_EVENT_BASE + 178);    
		public static final int NETDEV_ALARM_EVENT_SWITCH_CLOSE                        = (NETDEV_ALARM_EVENT_BASE + 179);    
		public static final int NETDEV_ALARM_EVENT_SWITCH_OFF                          = (NETDEV_ALARM_EVENT_BASE + 180);    
		public static final int NETDEV_ALARM_EVENT_TEMPER_CHANGE                       = (NETDEV_ALARM_EVENT_BASE + 181);    
		public static final int NETDEV_ALARM_EVENT_HUMIDITY_CHANGE                     = (NETDEV_ALARM_EVENT_BASE + 182);    
		public static final int NETDEV_ALARM_EVENT_DEVID_WRONG                         = (NETDEV_ALARM_EVENT_BASE + 183);    /* ID  */
		public static final int NETDEV_ALARM_EVENT_ELEC_HIGH_ARM                       = (NETDEV_ALARM_EVENT_BASE + 184);    
		public static final int NETDEV_ALARM_EVENT_ELEC_LOW_ARM                        = (NETDEV_ALARM_EVENT_BASE + 185);    
		public static final int NETDEV_ALARM_EVENT_ELEC_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE + 186);    
		public static final int NETDEV_ALARM_EVENT_ELEC_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 187);    
		public static final int NETDEV_ALARM_EVENT_ELEC_ARM                            = (NETDEV_ALARM_EVENT_BASE + 188);    
		public static final int NETDEV_ALARM_EVENT_KEY_ALARM_OVER                      = (NETDEV_ALARM_EVENT_BASE + 189);    
		public static final int NETDEV_ALARM_EVENT_KEY_PROL_TYPE                       = (NETDEV_ALARM_EVENT_BASE + 190);    
		public static final int NETDEV_ALARM_EVENT_MOD_DEV_ADDR                        = (NETDEV_ALARM_EVENT_BASE + 191);    
		public static final int NETDEV_ALARM_EVENT_FORWARD_CMD                         = (NETDEV_ALARM_EVENT_BASE + 192) ;   

		public static final int NETDEV_ALARM_EVENT_BASE_VALUE                          = (110000);                                    
		public static final int NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 1);           
		public static final int NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 2);           
		public static final int NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM              = (NETDEV_ALARM_EVENT_BASE_VALUE + 3);           /* 24 */
		public static final int NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM_RST          = (NETDEV_ALARM_EVENT_BASE_VALUE + 4);           /* 24 */
		public static final int NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 5);           /* 24 */
		public static final int NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM_RST             = (NETDEV_ALARM_EVENT_BASE_VALUE + 6);           /* 24 */
		public static final int NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 7);           
		public static final int NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 8);           
		public static final int NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 9);           
		public static final int NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 10);          
		public static final int NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 11);          
		public static final int NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 12);          
		public static final int NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 13);          
		public static final int NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 14);          
		public static final int NETDEV_ALARM_EVENT_OUTER_DISARMED                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 15);          
		public static final int NETDEV_ALARM_EVENT_OUTER_ARMED                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 16);          
		public static final int NETDEV_ALARM_EVENT_KEY_DISARMED                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 17);          
		public static final int NETDEV_ALARM_EVENT_KEY_ARMED                           = (NETDEV_ALARM_EVENT_BASE_VALUE + 18);          
		public static final int NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION         = (NETDEV_ALARM_EVENT_BASE_VALUE + 19);          
		public static final int NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION_RST     = (NETDEV_ALARM_EVENT_BASE_VALUE + 20);          
		public static final int NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 21);          
		public static final int NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK_RST            = (NETDEV_ALARM_EVENT_BASE_VALUE + 22);          
		public static final int NETDEV_ALARM_EVENT_SOFT_DEFEND_URGENCY_ALARM           = (NETDEV_ALARM_EVENT_BASE_VALUE + 23);          
		public static final int NETDEV_ALARM_EVENT_ARMED_STAY                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 24);          
		public static final int NETDEV_ALARM_EVENT_IMMEDIATELY_ARMED                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 25);          

		
		public static final int NETDEV_ALARM_EVENT_SMOKE_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 26);          
		public static final int NETDEV_ALARM_EVENT_SMOKE_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 27);          
		public static final int NETDEV_ALARM_EVENT_WATER_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 28);          
		public static final int NETDEV_ALARM_EVENT_WATER_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 29);          
		public static final int NETDEV_ALARM_EVENT_IO_ON                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 30);          /* . */
		public static final int NETDEV_ALARM_EVENT_IO_OFF                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 31);          /* . */

		
		public static final int NETDEV_ALARM_EVENT_TOUNCH_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 32);          
		public static final int NETDEV_ALARM_EVENT_INVADE_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 33);          
		public static final int NETDEV_ALARM_EVENT_BROKEN_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 34);          
		public static final int NETDEV_ALARM_EVENT_HELP                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 36);          
		public static final int NETDEV_ALARM_EVENT_DESTROY                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 37);          
		public static final int NETDEV_ALARM_EVENT_ACS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 38);          
		public static final int NETDEV_ALARM_EVENT_OTHERS                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 39);          
		public static final int NETDEV_ALARM_EVENT_ZONE_ALARM                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 40);          /* . */
		public static final int NETDEV_ALARM_EVENT_ZONE_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 41);          /* . */
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_FENCE                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 42);          
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_HOST                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 43);          
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_ETCZONE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 44);          
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_OFFLINE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 45);          
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH1                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 46);          /* 1 */
		public static final int NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH2                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 47);          /* 2 */
		public static final int NETDEV_ALARM_EVENT_STEAL                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 48);          
		public static final int NETDEV_ALARM_EVENT_GAS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 49);          
		public static final int NETDEV_ALARM_EVENT_SAVE                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 50);          
		public static final int NETDEV_ALARM_EVENT_INVADE_TROUBLE                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 51);          
		public static final int NETDEV_ALARM_EVENT_SYS_TROUBLE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 52);          
		public static final int NETDEV_ALARM_EVENT_OPTICAL_FIBER_TROUBLE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 53);          

		
		public static final int NETDEV_ALARM_EVENT_MOTION_DETECTION                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 62);          
		public static final int NETDEV_ALARM_EVENT_CALL_REMOVE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 63);          
		public static final int NETDEV_ALARM_EVENT_NOISE                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 64);          
		public static final int NETDEV_ALARM_EVENT_DELAYED                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 65);          
		public static final int NETDEV_ALARM_EVENT_ALARM_INPUT_ONE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 66);          /* 1 */
		public static final int NETDEV_ALARM_EVENT_ALARM_INPUT_TWO                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 67);          /* 2 */
		public static final int NETDEV_ALARM_EVENT_ALARM_CALL_EMERGENCY                = (NETDEV_ALARM_EVENT_BASE_VALUE + 68);          
		public static final int NETDEV_ALARM_EVENT_ALARM_CALL_CONSULTANT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 69);          
		public static final int NETDEV_ALARM_EVENT_DOOR_MAGNET_OPEN                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 70);          
		public static final int NETDEV_ALARM_EVENT_DOOR_MAGNET_CLOSE                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 71);          
		public static final int NETDEV_ALARM_EVENT_DOOR_LOCK_OPEN                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 72);          
		public static final int NETDEV_ALARM_EVENT_DOOR_LOCK_CLOSE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 73);          

		
		public static final int NETDEV_ALARM_EVENT_ALARM_PORT_ONE             = (NETDEV_ALARM_EVENT_BASE_VALUE + 74);          /* 1  Port 1 Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_PORT_TWO             = (NETDEV_ALARM_EVENT_BASE_VALUE + 75);          /* 2  Port 2 Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_PORTEX               = (NETDEV_ALARM_EVENT_BASE_VALUE + 76);          /*   Expansion Port Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_TUMULT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 77);          /*   Tumult Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_110                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 78);          /* 110  110 Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_119                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 79);          /* 119  119 Alarm */
		public static final int NETDEV_ALARM_EVENT_ALARM_120                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 80);          /* 120  120 Alarm */

		
		public static final int NETDEV_ALARM_EVENT_ALARM_FINDERCONNECT_FAILED = (NETDEV_ALARM_EVENT_BASE_VALUE + 81);          
		public static final int NETDEV_ALARM_EVENT_ALARM_OUTAGE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 82);          
		public static final int NETDEV_ALARM_EVENT_ALARM_DISASSEMBLE          = (NETDEV_ALARM_EVENT_BASE_VALUE + 83);          
		public static final int NETDEV_ALARM_EVENT_ALARM_CIRCUIT              = (NETDEV_ALARM_EVENT_BASE_VALUE + 84);          
		public static final int NETDEV_ALARM_EVENT_ALARM_TOUCHNET             = (NETDEV_ALARM_EVENT_BASE_VALUE + 85);          
		public static final int NETDEV_ALARM_EVENT_ALARM_PREVENTCUT           = (NETDEV_ALARM_EVENT_BASE_VALUE + 86);          
		public static final int NETDEV_ALARM_EVENT_ALARM_COCKING              = (NETDEV_ALARM_EVENT_BASE_VALUE + 87);          
		public static final int NETDEV_ALARM_EVENT_ALARM_SLACK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 88);          
		public static final int NETDEV_ALARM_EVENT_ALARM_ZONE_FORBIDDEN       = (NETDEV_ALARM_EVENT_BASE_VALUE + 89);          

		
		public static final int NETDEV_ALARM_EVENT_HIGH_TEMP                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 90);           
		public static final int NETDEV_ALARM_EVENT_LOW_TEMP                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 91);           
		public static final int NETDEV_ALARM_EVENT_HIGH_HUMI                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 92);           
		public static final int NETDEV_ALARM_EVENT_LOW_HUMI                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 93);           
		public static final int NETDEV_ALARM_MONITOR_DEVICE_ONLINE            = (NETDEV_ALARM_EVENT_BASE_VALUE + 94);           
		public static final int NETDEV_ALARM_MONITOR_DEVICE_OFFLINE           = (NETDEV_ALARM_EVENT_BASE_VALUE + 95);           

		
		public static final int NETDEV_DOOR_EVENT_BASE                         = (100400);                          

		public static final int NETDEV_DOOR_EVENT_DISCONNECT                   = (NETDEV_DOOR_EVENT_BASE + 1);        
		public static final int NETDEV_DOOR_EVENT_INFRARED_ALARM               = (NETDEV_DOOR_EVENT_BASE + 2);        
		public static final int NETDEV_DOOR_EVENT_ILLICIT_OPEN_DOOR            = (NETDEV_DOOR_EVENT_BASE + 3);        
		public static final int NETDEV_DOOR_EVENT_COERCE_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 4);        
		public static final int NETDEV_DOOR_EVENT_OPEN_TIMEOUT                 = (NETDEV_DOOR_EVENT_BASE + 5);        
		public static final int NETDEV_DOOR_EVENT_CLOSE_TIMEOUT                = (NETDEV_DOOR_EVENT_BASE + 6);        
		public static final int NETDEV_DOOR_EVENT_ANOMALOUS_CARD               = (NETDEV_DOOR_EVENT_BASE + 7);        
		public static final int NETDEV_DOOR_EVENT_CARD_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 8);        
		public static final int NETDEV_DOOR_EVENT_REMOTE_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 9);        
		public static final int NETDEV_DOOR_EVENT_MANUAL_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 10);       
		public static final int NETDEV_DOOR_EVENT_EMERGENCY_START              = (NETDEV_DOOR_EVENT_BASE + 11);       
		public static final int NETDEV_DOOR_EVENT_EMERGENCY_STOP               = (NETDEV_DOOR_EVENT_BASE + 12);       
		public static final int NETDEV_DOOR_EVENT_OPEN_SUCCESS                 = (NETDEV_DOOR_EVENT_BASE + 13);       
		public static final int NETDEV_DOOR_EVENT_OPEN_FAILED                  = (NETDEV_DOOR_EVENT_BASE + 14);       
		public static final int NETDEV_DOOR_EVENT_CLOSE                        = (NETDEV_DOOR_EVENT_BASE + 15);       
		public static final int NETDEV_DOOR_EVENT_CLOSE_FAILED                 = (NETDEV_DOOR_EVENT_BASE + 16);       
		public static final int NETDEV_DOOR_EVENT_CARD_NO_AUTH                 = (NETDEV_DOOR_EVENT_BASE + 17);       
		public static final int NETDEV_DOOR_EVENT_NO_DATE_LIMIT                = (NETDEV_DOOR_EVENT_BASE + 18);       
		public static final int NETDEV_DOOR_EVENT_CARD_ILLEGAL                 = (NETDEV_DOOR_EVENT_BASE + 19);       
		public static final int NETDEV_DOOR_EVENT_FIREPORTECT_ALRAM            = (NETDEV_DOOR_EVENT_BASE + 20);       
		public static final int NETDEV_DOOR_EVENT_CANCEL_FIREPORTECT           = (NETDEV_DOOR_EVENT_BASE + 21);       
		public static final int NETDEV_DOOR_EVENT_PRYING_RESIST_ALRAM          = (NETDEV_DOOR_EVENT_BASE + 22);       
		public static final int NETDEV_DOOR_EVENT_SUPERPASSWD_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 23);       
		public static final int NETDEV_DOOR_EVENT_COERCECODE_IN                = (NETDEV_DOOR_EVENT_BASE + 24);       
		public static final int NETDEV_DOOR_EVENT_DOOR_STATUS_OPEN             = (NETDEV_DOOR_EVENT_BASE + 25);       
		public static final int NETDEV_DOOR_EVENT_DOOR_STATUS_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 26);       
		public static final int NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN             = (NETDEV_DOOR_EVENT_BASE + 27);       
		public static final int NETDEV_DOOR_EVENT_DOOR_KEEP_OPEN               = (NETDEV_DOOR_EVENT_BASE + 28);       
		public static final int NETDEV_DOOR_EVENT_LOCK_FAILURE                 = (NETDEV_DOOR_EVENT_BASE + 29);       
		public static final int NETDEV_DOOR_EVENT_LOST_STOLEN_CARD             = (NETDEV_DOOR_EVENT_BASE + 30);       

		
		public static final int NETDEV_DOOR_EVENT_PASSWD_WRONG                 = (NETDEV_DOOR_EVENT_BASE + 31);       
		public static final int NETDEV_DOOR_EVENT_ALWAYS_CLOSED                = (NETDEV_DOOR_EVENT_BASE + 32);       
		public static final int NETDEV_DOOR_EVENT_CARD_PASSWD_ENTER            = (NETDEV_DOOR_EVENT_BASE + 33);       
		public static final int NETDEV_DOOR_EVENT_CARD_PASSWD_WRONG            = (NETDEV_DOOR_EVENT_BASE + 34);       
		public static final int NETDEV_DOOR_EVENT_MORE_CARD_OPEN               = (NETDEV_DOOR_EVENT_BASE + 35);       
		public static final int NETDEV_DOOR_EVENT_FIRST_CARD_OPEN              = (NETDEV_DOOR_EVENT_BASE + 36);       
		public static final int NETDEV_DOOR_EVENT_CARD_OUT_DATE                = (NETDEV_DOOR_EVENT_BASE + 37);       
		public static final int NETDEV_DOOR_EVENT_CARD_WATCH                   = (NETDEV_DOOR_EVENT_BASE + 38);       

		
		public static final int NETDEV_DOOR_EVENT_REMOTE_CLOSE_DOOR            = (NETDEV_DOOR_EVENT_BASE + 39);       
		public static final int NETDEV_DOOR_EVENT_REMOTE_ALWAYS_OPEN           = (NETDEV_DOOR_EVENT_BASE + 40);       
		public static final int NETDEV_DOOR_EVENT_REMOTE_ALWAYS_CLOSE          = (NETDEV_DOOR_EVENT_BASE + 41);       
		public static final int NETDEV_DOOR_EVENT_LEGAL_CARD_PASS              = (NETDEV_DOOR_EVENT_BASE + 42);       
		public static final int NETDEV_DOOR_EVENT_CARD_AND_PSW_PASS            = (NETDEV_DOOR_EVENT_BASE + 43);       
		public static final int NETDEV_DOOR_EVENT_CARD_AND_PSW_FAIL            = (NETDEV_DOOR_EVENT_BASE + 44);       
		public static final int NETDEV_DOOR_EVENT_CARD_AND_PSW_TIMEOUT         = (NETDEV_DOOR_EVENT_BASE + 45);       
		public static final int NETDEV_DOOR_EVENT_CARD_AND_PSW_OVER_TIME       = (NETDEV_DOOR_EVENT_BASE + 46);       
		public static final int NETDEV_DOOR_EVENT_INVALID_CARD                 = (NETDEV_DOOR_EVENT_BASE + 47);       
		public static final int NETDEV_DOOR_EVENT_DOOR_BUTTON_PRESS            = (NETDEV_DOOR_EVENT_BASE + 48);       
		public static final int NETDEV_DOOR_EVENT_DOOR_BUTTON_RELEASE          = (NETDEV_DOOR_EVENT_BASE + 49);       
		public static final int NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_ALARM  = (NETDEV_DOOR_EVENT_BASE + 50);       
		public static final int NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_RESUME = (NETDEV_DOOR_EVENT_BASE + 51);       
		public static final int NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN             = (NETDEV_DOOR_EVENT_BASE + 52);       
		public static final int NETDEV_DOOR_EVENT_DOOR_MAGNET_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 53);       
		public static final int NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_ABNORMAL    = (NETDEV_DOOR_EVENT_BASE + 54);       
		public static final int NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_TIMEOUT     = (NETDEV_DOOR_EVENT_BASE + 55);       
		public static final int NETDEV_DOOR_EVENT_ANTI_SNEAK_FAIL              = (NETDEV_DOOR_EVENT_BASE + 56);       
		public static final int NETDEV_DOOR_EVENT_INTERLOCK_DOOR_NOT_CLOSE     = (NETDEV_DOOR_EVENT_BASE + 57);       
		public static final int NETDEV_DOOR_EVENT_MULTI_VERIFY_SUCCESS         = (NETDEV_DOOR_EVENT_BASE + 58);       
		public static final int NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_BEGIN       = (NETDEV_DOOR_EVENT_BASE + 59);       
		public static final int NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_END         = (NETDEV_DOOR_EVENT_BASE + 60);       
		public static final int NETDEV_DOOR_EVENT_ALWAYS_OPEN_BEGIN            = (NETDEV_DOOR_EVENT_BASE + 61);       
		public static final int NETDEV_DOOR_EVENT_ALWAYS_OPEN_END              = (NETDEV_DOOR_EVENT_BASE + 62);       
		public static final int NETDEV_DOOR_EVENT_ALWAYS_CLOSE_BEGIN           = (NETDEV_DOOR_EVENT_BASE + 63);       
		public static final int NETDEV_DOOR_EVENT_ALWAYS_CLOSE_END             = (NETDEV_DOOR_EVENT_BASE + 64);       
		public static final int NETDEV_DOOR_EVENT_KEYPRESS_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 65);       

		
		public static final int NETDEV_DOOR_EVENT_COMMU_INTERRUPT              = (NETDEV_DOOR_EVENT_BASE + 81);       
		public static final int NETDEV_DOOR_EVENT_COMMU_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 82);       
		public static final int NETDEV_DOOR_EVENT_LEGAL_CREDIT_CARD            = (NETDEV_DOOR_EVENT_BASE + 83);       
		public static final int NETDEV_DOOR_EVENT_LEGAL_USER_ID                = (NETDEV_DOOR_EVENT_BASE + 84);       /* ID */
		public static final int NETDEV_DOOR_EVENT_CARD_NO_REG                  = (NETDEV_DOOR_EVENT_BASE + 85);       
		public static final int NETDEV_DOOR_EVENT_CARD_UNAUTH                  = (NETDEV_DOOR_EVENT_BASE + 86);       
		public static final int NETDEV_DOOR_EVENT_CARD_DISABLED                = (NETDEV_DOOR_EVENT_BASE + 87);       
		public static final int NETDEV_DOOR_EVENT_CARD_EXPIRED                 = (NETDEV_DOOR_EVENT_BASE + 88);       
		public static final int NETDEV_DOOR_EVENT_INVALID_TIME                 = (NETDEV_DOOR_EVENT_BASE + 89);       
		public static final int NETDEV_DOOR_EVENT_PSW_ERROR                    = (NETDEV_DOOR_EVENT_BASE + 90);       
		public static final int NETDEV_DOOR_EVENT_PROHIBITED                   = (NETDEV_DOOR_EVENT_BASE + 91);       
		public static final int NETDEV_DOOR_EVENT_REQ_CENTER_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 92);       
		public static final int NETDEV_DOOR_EVENT_LEGAL_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 93);       
		public static final int NETDEV_DOOR_EVENT_SUPER_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 94);       
		public static final int NETDEV_DOOR_EVENT_CENTER_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 96);       
		public static final int NETDEV_DOOR_EVENT_LINK_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 97);       
		public static final int NETDEV_DOOR_EVENT_FORCE_OPEN_DOOR              = (NETDEV_DOOR_EVENT_BASE + 98);       
		public static final int NETDEV_DOOR_EVENT_DOOR_IS_OPEN                 = (NETDEV_DOOR_EVENT_BASE + 99);       
		public static final int NETDEV_DOOR_EVENT_DOOR_IS_CLOSE                = (NETDEV_DOOR_EVENT_BASE + 100);      
		public static final int NETDEV_DOOR_EVENT_STRESS_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 103);      
		public static final int NETDEV_DOOR_EVENT_TRAILING_ALARM               = (NETDEV_DOOR_EVENT_BASE + 105);      
		public static final int NETDEV_DOOR_EVENT_DOOR_LOCK                    = (NETDEV_DOOR_EVENT_BASE + 106);      
		public static final int NETDEV_DOOR_EVENT_LIFT_DOOR_LOCK               = (NETDEV_DOOR_EVENT_BASE + 107);      
		public static final int NETDEV_DOOR_EVENT_DOOR_NOT_CLOSE               = (NETDEV_DOOR_EVENT_BASE + 108);      
		public static final int NETDEV_DOOR_EVENT_NEED_PSW                     = (NETDEV_DOOR_EVENT_BASE + 109);      
		public static final int NETDEV_DOOR_EVENT_NEED_FINGERPRINT             = (NETDEV_DOOR_EVENT_BASE + 110);      
		public static final int NETDEV_DOOR_EVENT_REQ_INTERCOM                 = (NETDEV_DOOR_EVENT_BASE + 111);      
		public static final int NETDEV_DOOR_EVENT_EMERGENCY                    = (NETDEV_DOOR_EVENT_BASE + 112);      
		public static final int NETDEV_DOOR_EVENT_PATROL_LEGAL_CREDIT_CARD     = (NETDEV_DOOR_EVENT_BASE + 113);      
		public static final int NETDEV_DOOR_EVENT_PATROL_LEGAL_FINGERPRINT     = (NETDEV_DOOR_EVENT_BASE + 114);      
		public static final int NETDEV_DOOR_EVENT_PATROL_CARD_NOT_REG          = (NETDEV_DOOR_EVENT_BASE + 115);      
		public static final int NETDEV_DOOR_EVENT_NOT_PATROL_CARD              = (NETDEV_DOOR_EVENT_BASE + 116);      
		public static final int NETDEV_DOOR_EVENT_NORMAL_PATROL                = (NETDEV_DOOR_EVENT_BASE + 117);      
		public static final int NETDEV_DOOR_EVENT_ADVANCE_PATROL               = (NETDEV_DOOR_EVENT_BASE + 118);      
		public static final int NETDEV_DOOR_EVENT_TIMEOUT_PATROL               = (NETDEV_DOOR_EVENT_BASE + 119);      
		public static final int NETDEV_DOOR_EVENT_INVALID_PATROL               = (NETDEV_DOOR_EVENT_BASE + 120);      
		public static final int NETDEV_DOOR_EVENT_NOT_PATROL                   = (NETDEV_DOOR_EVENT_BASE + 121);      
		public static final int NETDEV_DOOR_EVENT_TH_ALARM                     = (NETDEV_DOOR_EVENT_BASE + 122);      
		public static final int NETDEV_DOOR_EVENT_TH_RESTORE                   = (NETDEV_DOOR_EVENT_BASE + 123);      
		public static final int NETDEV_DOOR_EVENT_TH_RECORD                    = (NETDEV_DOOR_EVENT_BASE + 124);      
		public static final int NETDEV_DOOR_EVENT_SMOKE_ALARM                  = (NETDEV_DOOR_EVENT_BASE + 125);      
		public static final int NETDEV_DOOR_EVENT_SMOKE_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 126);      
		public static final int NETDEV_DOOR_EVENT_SMOKE_RECORD                 = (NETDEV_DOOR_EVENT_BASE + 127);      

		
		public static final int NETDEV_DOOR_EVENT_PC_CONTROL                   = (NETDEV_DOOR_EVENT_BASE + 128);      /* ： */
		public static final int NETDEV_DOOR_EVENT_LIMITED_CARD_NUM             = (NETDEV_DOOR_EVENT_BASE + 129);      /* ： */
		public static final int NETDEV_DOOR_EVENT_REASON_UNKNOWN               = (NETDEV_DOOR_EVENT_BASE + 130);      /* ： */
		public static final int NETDEV_DOOR_EVENT_CONTROLLER_ON                = (NETDEV_DOOR_EVENT_BASE + 131);      
		public static final int NETDEV_DOOR_EVENT_CONTROLLER_RESERT            = (NETDEV_DOOR_EVENT_BASE + 132);      
		public static final int NETDEV_DOOR_EVENT_DOOR_FORCE_CLOSE             = (NETDEV_DOOR_EVENT_BASE + 133);      
		public static final int NETDEV_DOOR_EVENT_DOOR_OFFLINE                 = (NETDEV_DOOR_EVENT_BASE + 134);      
		public static final int NETDEV_DOOR_EVENT_FIRE                         = (NETDEV_DOOR_EVENT_BASE + 135);      
		public static final int NETDEV_DOOR_EVENT_CALL_EMERGENCY               = (NETDEV_DOOR_EVENT_BASE + 136);      
		public static final int NETDEV_DOOR_PERSON_FACE_DOOR                   = (NETDEV_DOOR_EVENT_BASE + 137);      
		public static final int NETDEV_DOOR_PERSON_INVALE_DOOR                 = (NETDEV_DOOR_EVENT_BASE + 138);      

		
		public static final int NETDEV_DOOR_EVENT_FINGERPRINT_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 153);      
		public static final int NETDEV_DOOR_EVENT_ANTI_SUBMARINE               = (NETDEV_DOOR_EVENT_BASE + 154);      
		public static final int NETDEV_DOOR_EVENT_PRESS_MISTAKE                = (NETDEV_DOOR_EVENT_BASE + 155);      
		public static final int NETDEV_DOOR_EVENT_PF_PW_RF_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 156);      

		
		public static final int NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN_CLEARED     = (NETDEV_DOOR_EVENT_BASE + 157);      

		
		public static final int NETDEV_DOOR_EVENT_BLACKLIST                    = (NETDEV_DOOR_EVENT_BASE + 158);      
		public static final int NETDEV_DOOR_EVENT_FAILED_SEND_CMD              = (NETDEV_DOOR_EVENT_BASE + 159);      
		public static final int NETDEV_DOOR_EVENT_FAILED_OPEN_DOOE_MU_CARD     = (NETDEV_DOOR_EVENT_BASE + 160);      
		public static final int NETDEV_DOOR_EVENT_CARD_INVALID_PERIOD          = (NETDEV_DOOR_EVENT_BASE + 161);      
		public static final int NETDEV_DOOR_EVENT_CARD_REPORT_LOST             = (NETDEV_DOOR_EVENT_BASE + 162);      
		public static final int NETDEV_DOOR_EVENT_TAMPER_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 163);      
		public static final int NETDEV_DOOR_EVENT_SWIPE_CARD_WHEN_NORMAL_OPEN  = (NETDEV_DOOR_EVENT_BASE + 164);      
		public static final int NETDEV_DOOR_EVENT_OPEN_DOOR_BY_EMERGENCY_PWD   = (NETDEV_DOOR_EVENT_BASE + 165);      
		public static final int NETDEV_DOOR_EVENT_OPEN_DOOR_WHEN_NORMAL_OPEN   = (NETDEV_DOOR_EVENT_BASE + 166);      
		public static final int NETDEV_DOOR_EVENT_EXIT_BUTTON_DURING_ILLEGAL_PERIOD  = (NETDEV_DOOR_EVENT_BASE + 167);
		public static final int NETDEV_DOOR_EVENT_DOOR_ALREADY_OPEN            = (NETDEV_DOOR_EVENT_BASE + 168);      
		public static final int NETDEV_DOOR_EVENT_DOOR_ALREADY_CLOSE           = (NETDEV_DOOR_EVENT_BASE + 169);      
		public static final int NETDEV_DOOR_EVENT_ILLEGAL_PERIOD               = (NETDEV_DOOR_EVENT_BASE + 170);      
		public static final int NETDEV_DOOR_EVENT_OPEN_DOOR_BY_DURESS_PWD      = (NETDEV_DOOR_EVENT_BASE + 171);      
		public static final int NETDEV_DOOR_EVENT_NO_MASK                      = (NETDEV_DOOR_EVENT_BASE + 172);       
		public static final int NETDEV_DOOR_EVENT_BODY_TEMPERATURE             = (NETDEV_DOOR_EVENT_BASE + 173);       
		public static final int NETDEV_DOOR_EVENT_M0NITOR_INPUT_ACTIVATED      = (NETDEV_DOOR_EVENT_BASE + 174);       
		public static final int NETDEV_DOOR_EVENT_M0NITOR_INPUT_CLEAR          = (NETDEV_DOOR_EVENT_BASE + 175);       

		public static final int NETDEV_DOOR_EVENT_END                          = (NETDEV_DOOR_EVENT_BASE + 599);      

		// NETDEV_IS_DOOR_EVENT(x)    (NETDEV_DOOR_EVENT_BASE <= (x) && (x) < NETDEV_DOOR_EVENT_END)

	}

	/**
	 * @brief     Alarm configuration operation Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_ALARM_SRC_TYPE_E extends Structure {
		public static final int	NETDEV_ALARM_SRC_LOCAL_HARD_DISK                            = 0;        
		public static final int	NETDEV_ALARM_SRC_EX_CABINET_1_STORAGE_DISK                  = 1;        /*-1*/
		public static final int	NETDEV_ALARM_SRC_EX_CABINET_2_STORAGE_DISK                  = 2;        /*-2*/
		public static final int	NETDEV_ALARM_SRC_ARRAY_STORAGE_DISK                         = 3;        
		public static final int	NETDEV_ALARM_SRC_NAS_STORAGE_DISK                           = 4;        /*NAS*/
		public static final int	NETDEV_ALARM_SRC_SAN_STORAGE_DISK                           = 5;        /*SAN*/
		public static final int	NETDEV_ALARM_SRC_ESATA_STORAGE_DISK                         = 6;        /*eSATA*/
		public static final int	NETDEV_ALARM_SRC_SD_STORAGE_DISK                            = 7;        /*SD*/
		public static final int	NETDEV_ALARM_SRC_VIDEO_CHANNEL                              = 8;        
		public static final int	NETDEV_ALARM_SRC_ALARM_INPUT_CHANNEL                        = 9;        
		public static final int	NETDEV_ALARM_SRC_SYSTEM                                     = 10;       

		public static final int	NETDEV_ALARM_SRC_AUDIO_CHANNEL                              = 11;       
		public static final int	NETDEV_ALARM_SRC_DECODE_CHANNEL                             = 12;       
		public static final int	NETDEV_ALARM_SRC_ALARM_OUTPUT_CHANNEL                       = 13;       
		public static final int	NETDEV_ALARM_SRC_ACCESS_CONTROL_CHANNEL                     = 14;       
		public static final int	NETDEV_ALARM_SRC_ALARM_POINT_CHANNEL                        = 15;       
		public static final int	NETDEV_ALARM_SRC_EMERGENCY_BELL_CHANNEL                     = 16;       
		public static final int	NETDEV_ALARM_SRC_DEV                                        = 17;       

		public static final int	NETDEV_ALARM_SRC_INVALID                                    = 0xFFFF;    /*   Invalid value */
	}

	/**
	 * @brief    PTZ commands Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PTZ_E extends Structure {
		public static final int	NETDEV_PTZ_IRISCLOSE_STOP       =0x0101;       /*   Iris close stop */
		public static final int	NETDEV_PTZ_IRISCLOSE            =0x0102;       /*   Iris close */
		public static final int	NETDEV_PTZ_IRISOPEN_STOP        =0x0103;       /*   Iris open stop */
		public static final int	NETDEV_PTZ_IRISOPEN             =0x0104;       /*   Iris open */

		public static final int	NETDEV_PTZ_FOCUSNEAR_STOP       =0x0201;       /*   Focus near stop */
		public static final int	NETDEV_PTZ_FOCUSNEAR            =0x0202;       /*   Focus near */
		public static final int	NETDEV_PTZ_FOCUSFAR_STOP        =0x0203;       /*   Focus far stop */
		public static final int	NETDEV_PTZ_FOCUSFAR             =0x0204;       /*   Focus far */

		public static final int	NETDEV_PTZ_ZOOMTELE_STOP        = 0x0301;       /*   Zoom in stop */
		public static final int	NETDEV_PTZ_ZOOMTELE             = 0x0302;       /*   Zoom in */
		public static final int	NETDEV_PTZ_ZOOMWIDE_STOP        = 0x0303;       /*   Zoom out stop */
		public static final int	NETDEV_PTZ_ZOOMWIDE             = 0x0304;       /*   Zoom out */
		public static final int	NETDEV_PTZ_TILTUP               = 0x0402;       /*   Tilt up */
		public static final int	NETDEV_PTZ_TILTDOWN             = 0x0404;       /*   Tilt down */
		public static final int	NETDEV_PTZ_PANRIGHT             = 0x0502;       /*   Pan right */
		public static final int	NETDEV_PTZ_PANLEFT              = 0x0504;       /*   Pan left */
		public static final int	NETDEV_PTZ_LEFTUP               = 0x0702;       /*   Move up left */
		public static final int	NETDEV_PTZ_LEFTDOWN             = 0x0704;       /*   Move down left */
		public static final int	NETDEV_PTZ_RIGHTUP              = 0x0802;       /*   Move up right */
		public static final int	NETDEV_PTZ_RIGHTDOWN            = 0x0804;       /*   Move down right */

		public static final int	NETDEV_PTZ_ALLSTOP              = 0x0901;       /*   All-stop command word */
		public static final int	NETDEV_PTZ_FOCUS_AND_IRIS_STOP  = 0x0907;       /* .  Focus & Iris-stop command word */
		public static final int	NETDEV_PTZ_MOVE_STOP            = 0x0908;       /*   move stop command word */
		public static final int	NETDEV_PTZ_ZOOM_STOP            = 0x0909;       /*   zoom stop command word */
		//NETDEV_PTZ_TRACKCRUISEIPC
		public static final int	NETDEV_PTZ_TRACKCRUISE          = 0x1001;       /*   Start route patrol*/
		//NETDEV_PTZ_TRACKCRUISESTOPIPC
		public static final int	NETDEV_PTZ_TRACKCRUISESTOP      = 0x1002;       /*   Stop route patrol*/
		public static final int	NETDEV_PTZ_TRACKCRUISEREC       = 0x1003;       /*   Start recording route */
		public static final int	NETDEV_PTZ_TRACKCRUISERECSTOP   = 0x1004;       /*   Stop recording route */
		public static final int	NETDEV_PTZ_TRACKCRUISEADD       = 0x1005;       /*   Add patrol route */
		public static final int	NETDEV_PTZ_TRACKCRUISEDEL       = 0x1006;       /*   Delete patrol route */

		public static final int	NETDEV_PTZ_AREAZOOMIN           = 0x1101;       /*   Zoom in area */
		public static final int	NETDEV_PTZ_AREAZOOMOUT          = 0x1102;       /*   Zoom out area */
		public static final int	NETDEV_PTZ_AREAZOOM3D           = 0x1103;       /* 3D  3D positioning */

		public static final int	NETDEV_PTZ_BRUSHON              = 0x0A01;       /*   Wiper on */
		public static final int	NETDEV_PTZ_BRUSHOFF             = 0x0A02;       /*   Wiper off */

		public static final int	NETDEV_PTZ_LIGHTON              = 0x0B01;       /*   Lamp on */
		public static final int	NETDEV_PTZ_LIGHTOFF             = 0x0B02;       /*   Lamp off */

		public static final int	NETDEV_PTZ_HEATON               = 0x0C01;       /*   Heater on */
		public static final int	NETDEV_PTZ_HEATOFF              = 0x0C02;       /*   Heater off */

		public static final int	NETDEV_PTZ_SNOWREMOINGON        = 0x01301;       /*   Snowremoval on */
		public static final int	NETDEV_PTZ_SNOWREMOINGOFF       = 0x01302;       /*   Snowremoval off  */

		public static final int	NETDEV_PTZ_INFRAREDON           = 0x0D01;       /*   IR on */
		public static final int	NETDEV_PTZ_INFRAREDOFF          = 0x0D02;       /*   IR off */

		public static final int	NETDEV_PTZ_SELF_CHECKING        = 0x1801;       /* :dwSpeed1,;0,, */

		public static final int	NETDEV_PTZ_INVALID				= 0XFF;

	}

	/**
	 * @brief    PTZ preset operation commands Enumeration Definition
	 * @attention  None
	 */
	public static class NETDEV_PTZ_PRESETCMD_E extends Structure {
		public static final int NETDEV_PTZ_SET_PRESET   = 0;             /*   Set preset */
		public static final int NETDEV_PTZ_CLE_PRESET   = 1;             /*   Clear preset */
		public static final int NETDEV_PTZ_GOTO_PRESET  = 2;             /*   Go to preset */
	}

	/**
	 * @brief    PTZ patrol operation commands Enumeration Definition
	 * @attention  None
	 */
	public static class NETDEV_PTZ_CRUISECMD_E extends Structure {
		public static final int	NETDEV_PTZ_ADD_CRUISE      = 0;         /*    Add patrol route */
		public static final int	NETDEV_PTZ_MODIFY_CRUISE   = 1;         /*   Edit patrol route */
		public static final int	NETDEV_PTZ_DEL_CRUISE      = 2;         /*   Delete patrol route */
		public static final int	NETDEV_PTZ_RUN_CRUISE      = 3;         /*   Start patrol */
		public static final int	NETDEV_PTZ_STOP_CRUISE     = 4;          /*   Stop patrol */
		public static final int	NETDEV_PTZ_GET_CRUISE      = 5;             /* Get patrol route */
	}

	/**
	 * @enum tagNETDEVPLanStoreType
	 * @brief    Recording storage type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_STORE_TYPE_E extends Structure {
		public static final int	NETDEV_STORE_TYPE_COMMON                        = 0;                
		public static final int	NETDEV_STORE_TYPE_DIGITIALINPUT                 = 1;                
		public static final int	NETDEV_STORE_TYPE_MANUL                         = 2;                
		public static final int	NETDEV_STORE_TYPE_AUDIODETECT                   = 3;                
		public static final int	NETDEV_STORE_TYPE_MOTION                        = 4;                
		public static final int	NETDEV_STORE_TYPE_DIGITALINPUT                  = 5;                /*   Digital input */
		public static final int	NETDEV_STORE_TYPE_FACEDETECT                    = 6;                
		public static final int	NETDEV_STORE_TYPE_VIDEO_LOSS                    = 7;                
		public static final int	NETDEV_STORE_TYPE_LINEDETECT                    = 8;                
		public static final int	NETDEV_STORE_TYPE_FIELDDETECT                   = 9;                
		public static final int	NETDEV_STORE_TYPE_FOCUSDETECT                   = 10;               
		public static final int	NETDEV_STORE_TYPE_SCENECHANGE                   = 11;               
		public static final int	NETDEV_STORE_TYPE_ALARM                         = 12;               
		public static final int	NETDEV_STORE_TYPE_ALARM_AND_MOTION              = 13;               
		public static final int	NETDEV_STORE_TYPE_ALARM_OR_MOTION               = 14;               
		public static final int	NETDEV_STORE_TYPE_CAMERA_DISCONNECT             = 15;               
		public static final int	NETDEV_STORE_TYPE_THIRD_STREAM                  = 16;               
		public static final int	NETDEV_STORE_TYPE_EVENT_ALL_ALARM               = 17;               
		public static final int	NETDEV_STORE_TYPE_EVENT_ALL_TYPE                = 18;               
		public static final int	NETDEV_PLAN_STORE_TYPE_EVENT_WITHOUT_RESUME     = 19;               
		public static final int	NETDEV_STORE_TYPE_SMART_TRACK                   = 20;               
		public static final int	NETDEV_STORE_TYPE_URGENT_BELL                   = 21;               
		public static final int	NETDEV_STORE_TYPE_REMAIN_ARTICLE                = 22;               
		public static final int	NETDEV_STORE_TYPE_MOVE_ARTICLE                  = 23;               
		public static final int	NETDEV_STORE_TYPE_SMART_RECORD                  = 24;               
		public static final int	NETDEV_PLAN_STORE_TYPE_MAX                      = 25;               
		public static final int	NETDEV_STORE_TYPE_HUMAN_DETECT                  = 26;               

		public static final int	NETDEV_STORE_TYPE_INVALID                       = 0xFF;             
	}

	/**
	 * @enum tagNETDEVRecordLocation
	 * @brief    Record location Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_RECORD_LOCATION_E extends Structure {
		public static final int	NETDEV_RECORD_LOCATION_ALL                        = 0;                /* ： */
		public static final int	NETDEV_RECORD_LOCATION_VMS                        = 1;                /* ：VMS */
		public static final int	NETDEV_RECORD_LOCATION_NVR                        = 2;                /* ：NVR */
		public static final int	NETDEV_RECORD_LOCATION_BACKUP                     = 3;                /* ： */

		public static final int	NETDEV_RECORD_LOCATION_INVALID                    = 0xFF;              
	}

	/**
	 * @brief    Playback control commands Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VOD_PLAY_CTRL_E extends Structure {
		public static final int	NETDEV_PLAY_CTRL_PLAY                       = 0;        /*   Play */
		public static final int	NETDEV_PLAY_CTRL_PAUSE                      = 1;        /*   Pause */
		public static final int	NETDEV_PLAY_CTRL_RESUME                     = 2;        /*   Resume */
		public static final int	NETDEV_PLAY_CTRL_GETPLAYTIME                = 3;        /*   Obtain playing time */
		public static final int	NETDEV_PLAY_CTRL_SETPLAYTIME                = 4;        /*   Configure playing time */
		public static final int	NETDEV_PLAY_CTRL_GETPLAYSPEED               = 5;        /*   Obtain playing speed */
		public static final int	NETDEV_PLAY_CTRL_SETPLAYSPEED               = 6;        /*   Configure playing speed */
		public static final int	NETDEV_PLAY_CTRL_SET_SINGLE_FRAME_SPEED     = 7;        /*   Configure single frame playing speed */
		public static final int	NETDEV_PLAY_CTRL_UPDATE_M3U8URL             = 8;        /* M3u8URL  urlUpdate M3u8 url */
	}

	/**
	 * @brief .   Playback and download status Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VOD_PLAY_STATUS_E extends Structure {
		/**   Play status */
		public static final int	NETDEV_PLAY_STATUS_16_BACKWARD          = 0;            /* 16  Backward at 16x speed */
		public static final int	NETDEV_PLAY_STATUS_8_BACKWARD           = 1;            /* 8  Backward at 8x speed */
		public static final int	NETDEV_PLAY_STATUS_4_BACKWARD           = 2;            /* 4  Backward at 4x speed */
		public static final int	NETDEV_PLAY_STATUS_2_BACKWARD           = 3;            /* 2  Backward at 2x speed */
		public static final int	NETDEV_PLAY_STATUS_1_BACKWARD           = 4;            /*   Backward at normal speed */
		public static final int	NETDEV_PLAY_STATUS_HALF_BACKWARD        = 5;            /* 1/2  Backward at 1/2 speed */
		public static final int	NETDEV_PLAY_STATUS_QUARTER_BACKWARD     = 6;            /* 1/4  Backward at 1/4 speed */
		public static final int	NETDEV_PLAY_STATUS_QUARTER_FORWARD      = 7;            /* 1/4  Play at 1/4 speed */
		public static final int	NETDEV_PLAY_STATUS_HALF_FORWARD         = 8;            /* 1/2  Play at 1/2 speed */
		public static final int	NETDEV_PLAY_STATUS_1_FORWARD            = 9;            /*   Forward at normal speed */
		public static final int	NETDEV_PLAY_STATUS_2_FORWARD            = 10;           /* 2  Forward at 2x speed */
		public static final int	NETDEV_PLAY_STATUS_4_FORWARD            = 11;           /* 4  Forward at 4x speed */
		public static final int	NETDEV_PLAY_STATUS_8_FORWARD            = 12;           /* 8  Forward at 8x speed */
		public static final int	NETDEV_PLAY_STATUS_16_FORWARD           = 13;           /* 16  Forward at 16x speed */
		public static final int	NETDEV_PLAY_STATUS_2_FORWARD_IFRAME     = 14;           /* 2(I) Forward at 2x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_4_FORWARD_IFRAME     = 15;           /* 4(I) Forward at 4x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_8_FORWARD_IFRAME     = 16;           /* 8(I) Forward at 8x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_16_FORWARD_IFRAME    = 17;           /* 16(I) Forward at 16x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_2_BACKWARD_IFRAME    = 18;           /* 2(I) Backward at 2x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_4_BACKWARD_IFRAME    = 19;           /* 4(I) Backward at 4x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_8_BACKWARD_IFRAME    = 20;           /* 8(I) Backward at 8x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_16_BACKWARD_IFRAME   = 21;           /* 16(I) Backward at 16x speed(I frame) */
		public static final int	NETDEV_PLAY_STATUS_INTELLIGENT_FORWARD  = 22;           /*  Intelligent forward */
		public static final int	NETDEV_PLAY_STATUS_1_FRAME_FORWD        = 23;           /*   Forward at 1 frame speed */
		public static final int	NETDEV_PLAY_STATUS_1_FRAME_BACK         = 24;           /*  Backward at 1 frame speed */

		public static final int	NETDEV_PLAY_STATUS_40_FORWARD           = 25;           /* 40 Forward at 40x speed*/

		public static final int	NETDEV_PLAY_STATUS_32_FORWARD_IFRAME    = 26;           /* 32 Forward at 32x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_32_BACKWARD_IFRAME   = 27;           /* 32 Backward at 32x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_64_FORWARD_IFRAME    = 28;           /* 64 Forward at 64x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_64_BACKWARD_IFRAME   = 29;           /* 64 Backward at 64x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_128_FORWARD_IFRAME   = 30;           /* 128 Forward at 128x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_128_BACKWARD_IFRAME  = 31;           /* 128 Backward at 128x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_256_FORWARD_IFRAME   = 32;           /* 256 Forward at 256x speed(I frame)*/
		public static final int	NETDEV_PLAY_STATUS_256_BACKWARD_IFRAME  = 33;           /* 256 Backward at 256x speed(I frame)*/

		public static final int	NETDEV_PLAY_STATUS_32_FORWARD           = 34;           /* 32 */
		public static final int	NETDEV_PLAY_STATUS_32_BACKWARD          = 35;           /* 32 */

		public static final int	NETDEV_PLAY_STATUS_INVALID				= 0xFF;

	}

	/**
	 * @brief    Parameter configuration command words Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_CONFIG_COMMAND_E extends Structure {
		//NETDEV_GET_DEVICECFGNVR,IPC
		public static final int	NETDEV_GET_DEVICECFG                = 100;              /* , #NETDEV_DEVICE_BASICINFO_S  Get device information, see #NETDEV_DEVICE_BASICINFO_S */
		public static final int	NETDEV_SET_DEVICECFG                = 101;              /*  Reserved */

		public static final int	NETDEV_GET_NTPCFG                   = 110;              /* NTP, #NETDEV_SYSTEM_NTP_INFO_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */
		public static final int	NETDEV_SET_NTPCFG                   = 111;              /* NTP, #NETDEV_SYSTEM_NTP_INFO_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */

		//NETDEV_GET_NTPCFG_EXNVR,IPC
		public static final int	NETDEV_GET_NTPCFG_EX                = 112;              /* NTP(), #NETDEV_SYSTEM_NTP_INFO_LIST_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */
		//NETDEV_SET_NTPCFG_EXNVR,IPC
		public static final int	NETDEV_SET_NTPCFG_EX                = 113;              /* NTP(), #NETDEV_SYSTEM_NTP_INFO_LIST_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */

		//NETDEV_GET_STREAMCFGNVR,IPC
		public static final int	NETDEV_GET_STREAMCFG                = 120;              /* , #NETDEV_VIDEO_STREAM_INFO_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
		//NETDEV_SET_STREAMCFGNVR,IPC
		public static final int	NETDEV_SET_STREAMCFG                = 121;              /* , #NETDEV_VIDEO_STREAM_INFO_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */

		public static final int	NETDEV_GET_STREAMCFG_EX             = 122;              /* (), #NETDEV_VIDEO_STREAM_INFO_LIST_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
		public static final int	NETDEV_SET_STREAMCFG_EX             = 123;              /* (), #NETDEV_VIDEO_STREAM_INFO_LIST_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
		public static final int	NETDEV_GET_VIDEOMODECFG             = 124;              /*  #NETDEV_VIDEO_MODE_INFO_S */
		public static final int	NETDEV_SET_VIDEOMODECFG             = 125;              /*  #NETDEV_VIDEO_MODE_INFO_S */
		//NETDEV_GET_OSDCFGNVR,IPC
		public static final int	NETDEV_GET_OSDCFG                   = 140;              /* OSD, #NETDEV_VIDEO_OSD_CFG_S  Get OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
		//NETDEV_SET_OSDCFGIPC
		public static final int	NETDEV_SET_OSDCFG                   = 141;              /* OSD, #NETDEV_VIDEO_OSD_CFG_S  Set OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
		public static final int	NETDEV_GET_OSDCFG_EX                = 142;              /* OSD, #NETDEV_CHL_OSD_CFG_LIST_S  Get OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
		public static final int	NETDEV_SET_OSDCFG_EX                = 143;              /* OSD, #NETDEV_CHL_OSD_CFG_LIST_S  Set OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
		public static final int	NETDEV_GET_OSD_CONTENT_CFG          = 144;              /* OSD(), #NETDEV_OSD_CONTENT_S  Get OSD configuration information, see #NETDEV_OSD_CONTENT_S */
		public static final int	NETDEV_SET_OSD_CONTENT_CFG          = 145;              /* OSD(), #NETDEV_OSD_CONTENT_S  Set OSD configuration information, see #NETDEV_OSD_CONTENT_S */
		public static final int	NETDEV_GET_OSD_CONTENT_STYLE_CFG    = 146;              /* OSD, #NETDEV_OSD_CONTENT_STYLE_S  Get OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */
		public static final int	NETDEV_SET_OSD_CONTENT_STYLE_CFG    = 147;              /* OSD, #NETDEV_OSD_CONTENT_STYLE_S  Set OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */

		//NETDEV_GET_ALARM_OUTPUTCFGNVRVMS
		public static final int	NETDEV_GET_ALARM_OUTPUTCFG          = 150;              /* , #NETDEV_ALARM_OUTPUT_LIST_S  Get boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
		//NETDEV_SET_ALARM_OUTPUTCFGNVR
		public static final int	NETDEV_SET_ALARM_OUTPUTCFG          = 151;              /* , #NETDEV_ALARM_OUTPUT_LIST_S  Set boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
		//NETDEV_TRIGGER_ALARM_OUTPUTNVR
		public static final int	NETDEV_TRIGGER_ALARM_OUTPUT         = 152;              /* , #NETDEV_TRIGGER_ALARM_OUTPUT_S        Trigger boolean, see #NETDEV_TRIGGER_ALARM_OUTPUT_S */

		public static final int	NETDEV_GET_ALARM_INPUTCFG           = 153;              /* , #NETDEV_ALARM_INPUT_LIST_S   Get the number of boolean inputs, see #NETDEV_ALARM_INPUT_LIST_S */
		public static final int	NETDEV_GET_MANUAL_ALARM_CFG         = 154;              /*  #NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S  Get manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S*/
		public static final int	NETDEV_SET_MANUAL_ALARM_CFG         = 155;              /*  #NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S  Set manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S */
		//NETDEV_GET_INPUTSWITCH_LIST_CFGNVR,IPC
		public static final int	NETDEV_GET_INPUTSWITCH_LIST_CFG     = 156;              /*  #NETDEV_INPUT_SWITCH_INFO_LIST_S  Get all input switch information, see #NETDEV_INPUT_SWITCH_INFO_LIST_S*/

		//NETDEV_GET_IMAGECFGNVR,IPC
		public static final int	NETDEV_GET_IMAGECFG                 = 160;              /* , #NETDEV_IMAGE_SETTING_S  Get image configuration information, see #NETDEV_IMAGE_SETTING_S */
		//NETDEV_SET_IMAGECFGNVR,IPC
		public static final int	NETDEV_SET_IMAGECFG                 = 161;              /* , #NETDEV_IMAGE_SETTING_S  Set image configuration information, see #NETDEV_IMAGE_SETTING_S */
		//NETDEV_GET_IMAGE_EXPOSUREIPC
		public static final int	NETDEV_GET_IMAGE_EXPOSURE           = 162;              /* , #NETDEV_IMAGE_EXPOSURE_S  get image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
		//NETDEV_SET_IMAGE_EXPOSURENVR,IPC
		public static final int	NETDEV_SET_IMAGE_EXPOSURE           = 163;              /* , #NETDEV_IMAGE_EXPOSURE_S  Set image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
		public static final int	NETDEV_GET_IMAGE_LAMP_CTRLCFG       = 164;              /* , #NETDEV_LAMP_CTRL_INFO_S  get channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
		public static final int	NETDEV_SET_IMAGE_LAMP_CTRLCFG       = 165;              /* , #NETDEV_LAMP_CTRL_INFO_S  set channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
		public static final int	NETDEV_GET_IMAGE_WHITE_BALANCE      = 166;              /* , #NETDEV_LAMP_CTRL_INFO_S  get channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
		public static final int	NETDEV_SET_IMAGE_WHITE_BALANCE      = 167;              /* , #NETDEV_LAMP_CTRL_INFO_S  set channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
		public static final int	NETDEV_SET_IMAGE_PARAM_RESET        = 168;              /* set channel image param reset */
		//NETDEV_GET_NETWORKCFGNVR,IPC
		public static final int	NETDEV_GET_NETWORKCFG               = 170;              /* , #NETDEV_NETWORKCFG_S  Get network configuration information, see #NETDEV_NETWORKCFG_S */
		public static final int	NETDEV_SET_NETWORKCFG               = 171;              /* , #NETDEV_NETWORKCFG_S  Set network configuration information, see #NETDEV_NETWORKCFG_S */

		public static final int	NETDEV_GET_VPN_CFG                  = 172;              /* VPN  #NETDEV_VPN_CLIENT_INFO_S get the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
		public static final int	NETDEV_SET_VPN_CFG                  = 173;              /* VPN  #NETDEV_VPN_CLIENT_INFO_S set the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
		public static final int	NETDEV_SET_DNS_CFG                  = 174;              /*DNS  #NETDEV_DNS_INFO_S Set DNS info see #NETDEV_DNS_INFO_S*/
		public static final int	NETDEV_GET_DNS_CFG                  = 175;              /*DNS  #NETDEV_DNS_INFO_S Get DNS info see #NETDEV_DNS_INFO_S*/
		public static final int	NETDEV_SET_NETWORK_CARDS            = 176;              /*  #NETDEV_NETWORK_CARD_INFO_S set device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/
		public static final int	NETDEV_GET_NETWORK_CARDS            = 177;              /*  #NETDEV_NETWORK_CARD_INFO_S get device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/

		public static final int	NETDEV_SET_NETWORK_PORTS            = 178;              /*  #NETDEV_NETWORK_PORTS_INFO_S set device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/
		public static final int	NETDEV_GET_NETWORK_PORTS            = 179;              /*  #NETDEV_NETWORK_PORTS_INFO_S get device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/

		//NETDEV_GET_PRIVACYMASKCFGNVR,IPC
		public static final int	NETDEV_GET_PRIVACYMASKCFG           = 180;              /* , #NETDEV_PRIVACY_MASK_CFG_S  Get privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
		//NETDEV_SET_PRIVACYMASKCFGNVR,IPC
		public static final int	NETDEV_SET_PRIVACYMASKCFG           = 181;              /* , #NETDEV_PRIVACY_MASK_CFG_S  Set privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
		//NETDEV_DELETE_PRIVACYMASKCFGNVR,IPC
		public static final int	NETDEV_DELETE_PRIVACYMASKCFG        = 182;              /*   Delete privacy mask configuration information */
		//NETDEV_GET_TAMPERALARMNVR,IPC
		public static final int	NETDEV_GET_TAMPERALARM              = 190;              /*    #NETDEV_TAMPER_ALARM_INFO_S  Get tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */
		//NETDEV_SET_TAMPERALARMNVR,IPC
		public static final int	NETDEV_SET_TAMPERALARM              = 191;              /*    #NETDEV_TAMPER_ALARM_INFO_S  Set tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */
		//NETDEV_GET_MOTIONALARMNVR,IPC
		public static final int	NETDEV_GET_MOTIONALARM              = 200;              /*   #NETDEV_MOTION_ALARM_INFO_S  Get motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */
		//NETDEV_SET_MOTIONALARMNVR,IPC
		public static final int	NETDEV_SET_MOTIONALARM              = 201;              /*   #NETDEV_MOTION_ALARM_INFO_S  Set motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */

		public static final int	NETDEV_GET_CROSSLINEALARM           = 202;              /*   NETDEV_CROSS_LINE_ALARM_INFO_S Get Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/
		public static final int	NETDEV_SET_CROSSLINEALARM           = 203;              /*   NETDEV_CROSS_LINE_ALARM_INFO_S Set Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/

		public static final int	NETDEV_GET_INTRUSIONALARM           = 204;              /*   NETDEV_INTRUSION_ALARM_INFO_S Get intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/
		public static final int	NETDEV_SET_INTRUSIONALARM           = 205;              /*   NETDEV_INTRUSION_ALARM_INFO_S Set intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/

		//NETDEV_GET_DISKSINFONVR
		public static final int	NETDEV_GET_DISKSINFO                = 210;              /*   #NETDEV_DISK_INFO_LIST_S  Get disks information, see #NETDEV_DISK_INFO_LIST_S */
		public static final int	NETDEV_SET_DISKSINFO                = 211;              

		public static final int	NETDEV_GET_FOCUSINFO                = 230;              /*   #NETDEV_FOCUS_INFO_S Get focus info, see #NETDEV_FOCUS_INFO_S */
		public static final int	NETDEV_SET_FOCUSINFO                = 231;              /*   #NETDEV_FOCUS_INFO_S Set focus info, see #NETDEV_FOCUS_INFO_S */
		public static final int	NETDEV_GET_IRCUTFILTERINFO          = 232;              /*   #NETDEV_IRCUT_FILTER_INFO_S Get IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
		public static final int	NETDEV_SET_IRCUTFILTERINFO          = 233;              /*   #NETDEV_IRCUT_FILTER_INFO_S Set IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
		public static final int	NETDEV_GET_DEFOGGINGINFO            = 234;              /*   #NETDEV_DEFOGGING_INFO_S Get defogging info, see #NETDEV_DEFOGGING_INFO_S */
		public static final int	NETDEV_SET_DEFOGGINGINFO            = 235;              /*   #NETDEV_DEFOGGING_INFO_S Set defogging info, see #NETDEV_DEFOGGING_INFO_S */
		public static final int	NETDEV_SET_CHL_IMAGE_ENHANCE        = 236;              /* set channel image Enhance */
		public static final int	NETDEV_GET_CHL_IMAGE_ENHANCE        = 237;              /* get channel image Enhance */

		public static final int	NETDEV_GET_AUDIOIN_CFG              = 240;              /*   #NETDEV_AUDIO_INPUT_CFG_INFO_S get audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */
		public static final int	NETDEV_SET_AUDIOIN_CFG              = 241;              /*   #NETDEV_AUDIO_INPUT_CFG_INFO_S set audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */

		public static final int	NETDEV_GET_DST_CFG                  = 260;              /*   #NETDEV_DST_CFG_S Get defogging info, see #NETDEV_DST_CFG_S */
		public static final int	NETDEV_SET_DST_CFG                  = 261;              /*   #NETDEV_DST_CFG_S Set defogging info, see #NETDEV_DST_CFG_S */

		public static final int	NETDEV_GET_RECORDPLANINFO           = 270;              /*  NVR VMS  #NETDEV_RECORD_PLAN_CFG_INFO_S */
		public static final int	NETDEV_SET_RECORDPLANINFO           = 271;              /*  NVR VMS  #NETDEV_RECORD_PLAN_CFG_INFO_S */
		public static final int	NETDEV_SET_SNAPSHOT_CFG             = 272;              /*   #NETDEV_VIDEO_SNAPSHOT_S Set snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */
		public static final int	NETDEV_GET_SNAPSHOT_CFG             = 273;              /*   #NETDEV_VIDEO_SNAPSHOT_S Get snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */

		public static final int	NETDEV_GET_MOTIONDETECTION_WEEKPLAN     = 280;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_MOTIONDETECTION_WEEKPLAN     = 281;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_CROSSLINEDETECTION_WEEKPLAN  = 282;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_CROSSLINEDETECTION_WEEKPLAN  = 283;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_INTRUSIONDETECTION_WEEKPLAN  = 284;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_INTRUSIONDETECTION_WEEKPLAN  = 285;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_AUDIODETECTION_WEEKPLAN      = 286;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_AUDIODETECTION_WEEKPLAN      = 287;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_OBJTRACK_WEEKPLAN            = 288;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_OBJTRACK_WEEKPLAN            = 289;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_VIDEOLOSS_WEEKPLAN           = 290;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_VIDEOLOSS_WEEKPLAN           = 291;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_TAMPERDETECTION_WEEKPLAN     = 292;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_TAMPERDETECTION_WEEKPLAN     = 293;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_INPUTSWITCHES_WEEKPLAN       = 294;              /* , #NETDEV_SWITCH_WEEK_PLAN_INFO_S  Get InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_INPUTSWITCHES_WEEKPLAN       = 295;              /* ,, #NETDEV_SWITCH_WEEK_PLAN_INFO_S  Set InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_OUTPUTSWITCHES_WEEKPLAN      = 296;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get OutputSwitches deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_OUTPUTSWITCHES_WEEKPLAN      = 297;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set OutputSwitches deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_DEFOCUSDETECTION_WEEKPLAN    = 298;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_DEFOCUSDETECTION_WEEKPLAN    = 299;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_SCENECHANGE_WEEKPLAN         = 300;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_SCENECHANGE_WEEKPLAN         = 301;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_GET_FACEDETECTION_WEEKPLAN       = 302;              /* , #NETDEV_WEEK_PLAN_INFO_S  Get FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
		public static final int	NETDEV_SET_FACEDETECTION_WEEKPLAN       = 303;              /* ,, #NETDEV_WEEK_PLAN_INFO_S  Set FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */

		public static final int	NETDEV_GET_RECORD_STATUS                = 320;              /*   #NETDEV_RECORD_STATUS_LIST_S  Get video status information*/

		public static final int	NETDEV_GET_SERIAL_CFG                   = 330;              /*   #NETDEV_SERIAL_PORTS_S Get serail info, see # NETDEV_SERIAL_PORTS_S */
		public static final int	NETDEV_SET_SERIAL_CFG                   = 331;              /*   #NETDEV_SERIAL_PORTS_S Set serail info, see # NETDEV_SERIAL_PORTS_S */


		public static final int	NETDEV_GET_AUDIO_DECODE_STATUS              = 340;          /*   #NETDEV_AUDIO_DECODE_STATUS_LIST_S */
		public static final int	NETDEV_SET_AUDIO_DECODE_STATUS              = 341;          /*   #NETDEV_AUDIO_DECODE_STATUS_LIST_S */

		public static final int	NETDEV_GET_VIDEO_LOSS_RULE_INFO             = 400;          /*   #NETDEV_VIDEO_LOSS_RULE_INFO_S */
		public static final int	NETDEV_SET_VIDEO_LOSS_RULE_INFO             = 401;          /*   #NETDEV_VIDEO_LOSS_RULE_INFO_S */

		public static final int	NETDEV_GET_VIDEO_LOSS_LINKAGE_ACTIONS       = 410;           /*   #NETDEV_LINKAGE_ACTION_LIST_S */
		public static final int	NETDEV_SET_VIDEO_LOSS_LINKAGE_ACTIONS       = 411;          /*   #NETDEV_LINKAGE_ACTION_LIST_S */


		public static final int	NETDEV_GET_TAMPER_DETECTION_RULE_INFO       = 420;          /*   #NETDEV_TAMPER_DETECTION_RULE_INFO_S */
		public static final int	NETDEV_SET_TAMPER_DETECTION_RULE_INFO       = 421;          /*   #NETDEV_TAMPER_DETECTION_RULE_INFO_S */

		public static final int	NETDEV_GET_TAMPER_DETECTION_LINKAGE_ACTIONS = 430;           /*   #NETDEV_LINKAGE_ACTION_LIST_S */
		public static final int	NETDEV_SET_TAMPER_DETECTION_LINKAGE_ACTIONS = 431;          /*   #NETDEV_LINKAGE_ACTION_LIST_S */



		public static final int	NETDEV_GET_MOTION_DETECTION_AREA_TYPE       = 440;          /*   #NETDEV_MOTION_DETECTION_AREA_TYPE_S */
		public static final int	NETDEV_SET_MOTION_DETECTION_AREA_TYPE       = 441;          /*   #NETDEV_MOTION_DETECTION_AREA_TYPE_S */
		public static final int	NETDEV_GET_MOTION_DETECTION_AREA_GRID_INFO  = 442;          /*   #NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
		public static final int	NETDEV_SET_MOTION_DETECTION_AREA_GRID_INFO  = 443;          /*   #NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
		public static final int	NETDEV_GET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 444;    /*   #NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
		public static final int	NETDEV_SET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 445;    /*   #NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
		public static final int	NETDEV_GET_MOTION_DETECTION_LINKAGE_ACTIONS = 450;          /*   #NETDEV_LINKAGE_ACTION_LIST_S */
		public static final int	NETDEV_SET_MOTION_DETECTION_LINKAGE_ACTIONS = 451;          /*   #NETDEV_LINKAGE_ACTION_LIST_S */
		public static final int	NETDEV_GET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 460;          /*   #NETDEV_SWITCH_LINKAGE_ACTION_S */
		public static final int	NETDEV_SET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 461;          /*   #NETDEV_SWITCH_LINKAGE_ACTION_S */

		public static final int	NETDEV_GET_RAID_STATUS                      = 470;          /*   #NETDEV_RAID_STATUS_S */
		public static final int	NETDEV_GET_RAID_STORAGE_CONTAINER_INFO_LIST = 471;          /*  NETDEV_GET_RAID_STATUS   #NETDEV_HDD_INFO_LIST_S */
		public static final int	NETDEV_GET_STORAGE_CONTAINER_INFO_LIST      = 472;          /*  NETDEV_GET_RAID_STATUS   #NETDEV_STORAGE_CONTAINER_INFO_LIST_S */
		public static final int	NETDEV_GET_HDD_SMART_INFO                   = 473;          /* Smart  #NETDEV_HDD_SMART_INFO_S */
		public static final int	NETDEV_SET_HDD_SMART_INFO                   = 474;          /* Smart  #NETDEV_HDD_SMART_CHECK_INFO_S */
		public static final int	NETDEV_GET_RAID_STATUS_V30                  = 475;          /*  VMS/NVR  #NETDEV_RAID_STATUS_S */
		public static final int	NETDEV_SET_RAID_STATUS_V30                  = 476;          /*  VMS/NVR  #NETDEV_RAID_STATUS_S */

		public static final int	NETDEV_GET_PHOTO_SERVER_INFO                = 482;          /*   # NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S */
		public static final int	NETDEV_SET_PHOTO_SERVER_INFO                = 483;          /*   # NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S */

		public static final int	NETDEV_GET_ENHANCED_CONFIG                  = 484;          /* , # NETDEV_ENHANCED_CONFIG_INFO_S */
		public static final int	NETDEV_SET_ENHANCED_CONFIG                  = 485;          /* , # NETDEV_ENHANCED_CONFIG_INFO_S */

		public static final int	NETDEV_GET_INTELLIGENT_SERVER_INFO          = 486;          /*   # NETDEV_DATA_SERVER_LIST */
		public static final int	NETDEV_SET_INTELLIGENT_SERVER_INFO          = 487;          /*   # NETDEV_DATA_SERVER_LIST */

		public static final int	NETDEV_GET_MOTION_INTERVAL_INFO             = 490;               /*    NETDEV_MOTION_INTERVAL_INFO_S */
		public static final int	NETDEV_SET_MOTION_INTERVAL_INFO             = 491;               /*    NETDEV_MOTION_INTERVAL_INFO_S */

		public static final int	NETDEV_GET_MANAGER_SERVER_INFO              = 492;          /*   # NETDEV_MANAGER_SERVER_LIST_S */
		public static final int	NETDEV_SET_MANAGER_SERVER_INFO              = 493;          /*   # NETDEV_MANAGER_SERVER_LIST_S */

		public static final int	NETDEV_GET_VISIBLE_RANGE_INFO               = 494;          /*   # NETDEV_VISIBLE_RANGE_INFO_S */
		public static final int	NETDEV_SET_VISIBLE_RANGE_INFO               = 495;          /*   # NETDEV_VISIBLE_RANGE_INFO_S */

		public static final int	NETDEV_GET_RESET_PWD_VERTIFY_INFO           = 496;          /*  #NETDEV_RESET_PWD_VERTIFY_INFO_S*/
		public static final int	NETDEV_SET_RESET_PWD_VERTIFY_INFO           = 497;          /*   #NETDEV_RESET_PWD_VERTIFY_INFO_S*/

		public static final int	NETDEV_GET_CHL_STORAGE_QUOTA_INFO           = 498;          /*   #NETDEV_STORAGE_QUOTA_INFO_S */
		public static final int	NETDEV_SET_CHL_STORAGE_QUOTA_INFO           = 499;          /*   #NETDEV_STORAGE_QUOTA_INFO_S */

		public static final int	NETDEV_GET_CUSTOM_PROTOCOL_INFO             = 501;          /*   # NETDEV_CUSTON_PROTOCOL_INFO_S */
		public static final int	NETDEV_SET_CUSTOM_PROTOCOL_INFO             = 502;          /*   # NETDEV_CUSTON_PROTOCOL_INFO_S */
		public static final int	NETDEV_GET_CUSTOM_PROTOCOL_INFOLIST         = 503;          /*   # NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S */

		public static final int	NETDEV_GET_CHL_STORAGE_STRATEGY             = 504;          /*   #NETDEV_STORAGE_STRATEGY_S */
		public static final int	NETDEV_SET_CHL_STORAGE_STRATEGY             = 505;          /*   #NETDEV_STORAGE_STRATEGY_S */

		public static final int NETDEV_GET_DEVICE_TIME_SYNCMODE             = 512;          /*  NETDEV_TIME_SYNCMODE_S */
		public static final int NETDEV_SET_DEVICE_TIME_SYNCMODE             = 513;          /*  NETDEV_TIME_SYNCMODE_S */ 
		
		public static final int	NETDEV_CFG_INVALID                          = 0xFFFF;                /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVPicStorageMode
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_PIC_STORAGE_MODE_E extends Structure {
		public static final int	NETDEV_PIC_STORAGE_MODE_NORMAL             = 0;     /* SD */
		public static final int	NETDEV_PIC_STORAGE_MODE_PERMANENT          = 1;     /* SD */
		public static final int	NETDEV_PIC_STORAGE_MODE_RETAIN             = 2;     /* SD */
		public static final int	NETDEV_PIC_STORAGE_MODE_INVALID            = 0xff;   
	}

	/**
	 * @enum tagNETDEVFullStrategyType
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_FULL_STRATEGY_TYPE_E extends Structure {
		public static final int	NETDEV_FULL_STRATEGY_TYPE_FULL_COVERAGE              = 0;       
		public static final int	NETDEV_FULL_STRATEGY_TYPE_FULL_STOP                  = 1;       
		public static final int	NETDEV_FULL_STRATEGY_TYPE_INVALIDP                   = 0xff;     
	}

	/**
	 * @struct tagNETDEVPicStorageStrategyInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_PIC_STORAGE_STRATEGY_INFO_S extends Structure {
		public int     dwStorageMode;        /*   #NETDEV_PIC_STORAGE_MODE_E */
		public int     dwFullStrategy;       /*   #NETDEV_FULL_STRATEGY_TYPE_E */
		public byte[]  byRes = new byte[256];           
	}

	/**
	 * @struct tagNETDEVRecStorageStrategyInfo
	 * @brief  
	 * @attention 
	 */
	public class NETDEV_REC_STORAGE_STRATEGY_INFO_S extends Structure {
		public int      bStoregeEnabled;      /* ,0:,1: */
		public int     dwFullStrategy;       /*   #NETDEV_FULL_STRATEGY_TYPE_E */
		public int     dwPlanStreamType;     /*  #NETDEV_LIVE_STREAM_INDEX_E */
		public int     dwManualStreamType;   /*  #NETDEV_LIVE_STREAM_INDEX_E */
		public int     dwEventStreamType;    /*  #NETDEV_LIVE_STREAM_INDEX_E */
		public byte[]  byRes = new byte[256];           
	}

	/**
	 * @enum tagNETDEVStorageResType
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_STORAGE_RES_TYPE_E extends Structure {
		public static final int	NETDEV_STORAGE_RES_TYPE_SD        = 0;     /* SD */
		public static final int	NETDEV_STORAGE_RES_TYPE_NAS       = 1;     /* NAS */
		public static final int	NETDEV_STORAGE_RES_TYPE_INVALID   = 0xff;   
	}

	/**
	 * @struct tagNETDEVStorageStrategy
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_STORAGE_STRATEGY_S extends Structure {
		public int                                dwStorageRes;               /* , IPC, #NETDEV_STORAGE_RES_TYPE_E */
		public NETDEV_REC_STORAGE_STRATEGY_INFO_S        stRecStoreStrategyInfo;     
		public NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stPicStoreStrategyInfo;     
		public NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stAIPicStoreStrategyInfo;   
		public byte[]                             byRes = new byte[512];                 
	}

	/**
	 * @struct tagNETDEVCustomProSimpleInfoList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S extends Structure {
		public int                                      udwNum;                                         /* , 64 */
		public NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S[]            astCustomProSimpleList = new NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S[NETDEV_LEN_64];          
		public byte[]                                   byRes = new byte[512];                                     
	}

	/*
	 * @struct tagNETDEVCustomStreamInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CUSTON_STREAM_INFO_S extends Structure {
		public int                                          udwEnable;                                      /* 1:; 0: */
		public byte[]                                       szStreamURL = new byte[NETDEV_LEN_128];                      /* URL[0, 128] */
		public byte[]                                       szPlaybackStreamURL = new byte[NETDEV_LEN_128];            /* URL[0, 128] */
		public byte[]                                       byRes = new byte[384];                                     
	}

	/**
	 * @struct tagNETDEVCustomProSimpleInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S extends Structure {
		public int                       udwProID;                                       /* ,  */
		public byte[]                    szProName = new byte[NETDEV_LEN_64];                       /* [0, 64] */
		public byte[]                    byRes = new byte[128];                                     
	}

	/**
	 * @struct tagNETDEVCustomProInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CUSTON_PROTOCOL_INFO_S extends Structure {
		public int                             udwTransport;                                   /* ,    NETDEV_TRANS_PROTOCOL_E */
		public int                             udwPort;                                        
		public NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S            stCustomProSimpleInfo;                          
		public NETDEV_CUSTON_STREAM_INFO_S                     stMainStream;                                   
		public NETDEV_CUSTON_STREAM_INFO_S                     stSubStream;                                    
		public NETDEV_CUSTON_STREAM_INFO_S                     stThirdStream;                                  

		public byte[]                                   byRes = new byte[512];                                     
	}

	/**
	 * @enum tagNETDEVStorageCapUnit
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_STORAGE_CAP_UNIT_E extends Structure {
		public static final int	NETDEV_TYPE_STORAGE_CAP_UNIT_GB               = 0;        /* GB */
		public static final int	NETDEV_TYPE_STORAGE_CAP_UNIT_MB               = 1;        /* MB */
		public static final int	NETDEV_TYPE_STORAGE_CAP_UNIT_INVALID          = 0xff;      
	}

	/**
	 * @struct tagNETDEVStorageQuotaInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_STORAGE_QUOTA_INFO_S extends Structure {
		public int      dwStorageCapUnit;             /* (GB), #NETDEV_STORAGE_CAP_UNIT_E */
		public int      dwRecUsedCap;                 
		public int      dwPicUsedCap;                 
		public int      dwAIPicUsedCap;               /* IPC */
		public int      dwUsedCap;                    /* IPC */
		public int      dwTotalCap;                   
		public int      dwRecQuota;                   
		public int      dwPicQuota;                   
		public int      dwAIPicQuota;                 /* IPC */
		public int      dwGroupID;                    /* ID */
		public int      dwGroupTotalCap;              
		public byte[]       byRes = new byte[256];    
	}

	/**
	 * @struct tagNETDEVVisibleRangeInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VISIBLE_RANGE_INFO_S extends Structure {
		public Double                         dAzimuthHorizontal;                                 /* : :[-1.0000,+1.0000] */
		public Double                          dAzimuthVertical;                                   /* :4 :[-1.0000,+1.0000] */
		public Double                          dInclinationHorizontal;                             /*  :4 :[-1.0000,+1.0000] */
		public Double                          dAngelHorizontal;                                   /*  :4 */
		public Double                          dAngelVertical;                                     /*  :4 */
		public Double                          dDistance;                                          /*  :4 */
		public Double                          dInstallationHeight;                                /*  ：4 */
		public byte[]                            byRes = new byte[248];                                         
	}

	/**
	 * @struct tagNETDEVManagerServerInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_MANAGER_SERVER_INFO_S extends Structure {
		public int                          udwIndex;                                           /*  0 */
		public int                          udwMngProtocol;                                     /*  # NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_E */
		public byte[]                            szDeviceID = new byte[NETDEV_LEN_64];                          /* ID[1, 32] */
		public byte[]                            szServerID = new byte[NETDEV_LEN_64];                          /* ID [1, 32] */
		public byte[]                            szDeviceName = new byte[NETDEV_DEV_NAME_LEN_MAX];              /* [0, 20] */
		public byte[]                            szRegPassword = new byte[NETDEV_LEN_32];                       /* (0, 16] */
		public byte[]                            szVideoChlID = new byte[NETDEV_LEN_64];                        /* ID[0,32] */
		public byte[]                            szAudioChlID = new byte[NETDEV_LEN_64];                        /* ID[0,32] */
		public int                          udwExpire;                                          /* [3600,36000] */
		public byte[]                            szAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];               /* IPv4 */
		public int                          udwPort;                                            
		public byte[]                            byRes = new byte[256];                                         
	}

	/**
	 * @struct tagNETDEVManagerServerList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_MANAGER_SERVER_LIST_S extends Structure {
		public int                          udwNum;                                               /*  2 */
		public NETDEV_MANAGER_SERVER_INFO_S[]    astManagerServerList = new NETDEV_MANAGER_SERVER_INFO_S[NETDEV_MANAGER_SERVER_MAX_NUM];  
		public byte[]                       byRes = new byte[128];                                           
	}

	/**
	 * @struct tagNETDEVMotionIntervalInfo
	 * @brief  Motion Interval Info
	 * @attention  None
	 */
	public class NETDEV_MOTION_INTERVAL_INFO_S extends Structure {
		public int     udwSuppressTime;                                     /* ,:,[5, 3600] */
		public int     udwClearTime;                                        /* ,:,[1,600] */

		public byte[]  byRes = new byte[512];                                            /*   Reserved */
	}

	/**
	 * @struct tagNETDEVServerUserInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SERVER_USER_INFO_S extends Structure {
		public byte[]                            szUserName = new byte[NETDEV_USERNAME_LEN];    /* [1,32] */
		public int                           bModifyPasswd;                      /*  0: 1:*/
		public byte[]                            szPasswd = new byte[NETDEV_PASSWORD_LEN];      /*  [0,32]  */
		public byte[]                            byRes = new byte[256];                         
	}
	
	/**
	 * @struct tagNETDEVViidCfg
	 * @brief 
	 * @attention 
	 */
	public class NETDEV_VIID_CFG_S extends Structure {
	    public int                udwCoordinateType;                      /* 0:([0,9999])1: 2:(0~1) NETDEV_INVALID_PARAM */
	    public byte[]             szViidServerID= new byte [NETDEV_LEN_64];          /* [1,32]IPC */
	    public int                udwConnectMode;                         /* ：0：1：NETDEV_INVALID_PARAM */
	    public int                udwObjectType;                          /* 。BitBit01。Bit0：Bit1：Bit2：Bit3： */
	    public byte[]             byRes = new byte[32];                              
	}

	/**
	 * @struct tagNETDEVDataServerInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DATA_SERVER_INFO extends Structure {
		public int                               udwIndex;                                           /*  0 */
		public int                               bEnable;                                            
		public int                               udwProtocol;                                        /*  ： 1:TCP(V2 TMS) # NETDEV_DATA_SERVER_PROTOCOL_TYPE_E */
		public byte[]                            szCameraID = new byte[NETDEV_LEN_128];              /* (0, 36] 0*/
		public byte[]                            szTollgateID = new byte[NETDEV_LEN_128];            /* (0, 36] 0 */
		public byte[]                            szServerAddr = new byte[NETDEV_LEN_32];             /* IPv4 */
		public int                               udwServerPort;                                      
		public byte[]                            szDrivewayID = new byte[NETDEV_LEN_64];             /*  IPC */
		public byte[]                            szDirectionID = new byte[NETDEV_LEN_64];            /*  IPC */
		public byte[]                            szDeviceID = new byte[NETDEV_LEN_64];               /*  IPC */
		public byte[]                            szAreaId = new byte[NETDEV_LEN_64];                 /*  IPC */
		public NETDEV_SERVER_USER_INFO_S         stServerUserInfo;                                   
		public NETDEV_VIID_CFG_S                 stViidCfg;                                          /* # NETDEV_VIID_CFG_S */
		public byte[]                            byRes = new byte[148];                                                                        
	}

	/**
	 * @enum tagNETDEVDataServerProtocolType
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_DATA_SERVER_PROTOCOL_TYPE_E extends Structure {
		public static final int	NETDEV_DATA_SERVER_PROTOCOL_TYPE_TCP   = 1;   /* TCP: V2tms */

		public static final int	NETDEV_DATA_SERVER_PROTOCOL_TYPE_TFTP_COMMOM = 4;   /* FTP: FTP  */

		public static final int	NETDEV_DATA_SERVER_PROTOCOL_TYPE_HTTP_GA     = 51;   /* HTTP:  */                              
	}

	/**
	 * @struct tagNETDEVDataServerList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DATA_SERVER_LIST extends Structure {
		public int   udwNum;                                               /*  2 */
		public NETDEV_DATA_SERVER_INFO[] astDataServerList = new NETDEV_DATA_SERVER_INFO[NETDEV_INTELLIGENT_SERVER_MAX_NUM]; 
		public byte[]  byRes = new byte[128];                                           
	}

	/**
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_ENHANCED_CONFIG_INFO_S extends Structure {
		public int    bEnabledStorage;        /* UNP/0:1: */
		public byte[]    byRes = new byte[512];                         /*   Reserved */
	}

	/**
	 * @brief           PreRecordTime Enumeration definition
	 * @attention
	 */
	public static class NETDEV_PRE_RECORD_TIME_E extends Structure {
		public static final int	NETDEV_PRE_RECORD_TIME_ZERO =  0;            /* 0 */
		public static final int	NETDEV_PRE_RECORD_TIME_FIVE =  5;            /* 5 */
		public static final int	NETDEV_PRE_RECORD_TIME_TEN =   10;           /* 10 */
		public static final int	NETDEV_PRE_RECORD_TIME_TWENTY =20;           /* 20 */
		public static final int	NETDEV_PRE_RECORD_TIME_THIRTY =30;           /* 30 */
		public static final int	NETDEV_PRE_RECORD_TIME_SIXTY = 60;            /* 60 */
	}

	/**
	 * @brief           PostRecordTime Enumeration definition
	 * @attention
	 */
	public static class NETDEV_POST_RECORD_TIME_E extends Structure {
		public static final int	NETDEV_POST_RECORD_TIME_FIVE =                   5;             /* 5 */
		public static final int	NETDEV_POST_RECORD_TIME_TEN =                    10;            /* 10 */
		public static final int	NETDEV_POST_RECORD_TIME_THIRTY =                 30;            /* 30 */
		public static final int	NETDEV_POST_RECORD_TIME_SIXTY =                  60;            /* 60 */
		public static final int	NETDEV_POST_RECORD_TIME_ONE_HUNDRED_AND_TWENTY = 120;           /* 120 */
		public static final int	NETDEV_POST_RECORD_TIME_THREE_HUNDRED =          300;           /* 300 */
		public static final int	NETDEV_POST_RECORD_TIME_SIX_HUNDRED =            600;            /* 600 */
	}

	/**
	 * @brief      Record Rule Structure definition
	 * @attention  None
	 */
	public class NETDEV_RECORD_RULE_S extends Structure {
		public int  udwPreRecordTime;                                  /* , NETDEV_PRE_RECORD_TIME_E */
		public int  udwPostRecordTime;                                 /* , NETDEV_POST_RECORD_TIME_E */
		public byte[] byRes = new byte[32];                                         
	}

	/**
	 * @brief      Record plan config info Structure definition
	 * @attention  None
	 */
	public class NETDEV_RECORD_PLAN_CFG_INFO_S extends Structure {
		public int 							bPlanEnable;                                        
		public int 							bRedundantStorage;                                  /*  NVR */
		public NETDEV_RECORD_RULE_S       	stRecordRule;                                       /*  NVR */
		public NETDEV_VIDEO_WEEK_PLAN_S   	stWeekPlan;                                         /*  NVR */
		public int                     		udwChlID;                                           /*  / */
		public int                     		udwReqSeq;                                          /*  [1, 50] VMS Post */
		public int                     		udwTamplateID;                                      /* ID VMS */
		public byte[]                       szTamplateName = new byte[NETDEV_NAME_MAX_LEN];                /*  VMS Get */
		public byte[]                       byRes = new byte[116];                                         
	}

	/**
	 * @brief     Video encoding format Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VIDEO_CODE_TYPE_E extends Structure {
		public static final int	NETDEV_VIDEO_CODE_MJPEG     = 0;          /* MJPEG */
		public static final int	NETDEV_VIDEO_CODE_H264      = 1;          /* H.264 */
		public static final int	NETDEV_VIDEO_CODE_H265      = 2;          /* H.265 */
		public static final int	NETDEV_VIDEO_CODE_INVALID	= 0xFF;
	}

	/**
	 * @brief     Video image quality Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VIDEO_QUALITY_E extends Structure {
		public static final int NETDEV_VQ_L0 = 0;                    /*   Highest */
		public static final int NETDEV_VQ_L1 = 1;
		public static final int NETDEV_VQ_L2 = 4;                    /*   Higher */
		public static final int NETDEV_VQ_L3 = 8;
		public static final int NETDEV_VQ_L4 = 12;                   /*   Medium */
		public static final int NETDEV_VQ_L5 = 16;
		public static final int NETDEV_VQ_L6 = 20;                   /*   Low */
		public static final int NETDEV_VQ_L7 = 24;
		public static final int NETDEV_VQ_L8 = 28;                   /*   Lower */
		public static final int NETDEV_VQ_L9 = 31;                   /*   Lowest */

		public static final int NETDEV_VQ_LEVEL_INVALID = -1;         /*   Valid */
	}

	/**
	 * @brief    Enumeration of main stream type
	 * @attention  None
	 */
	public static class NETDEV_MAIN_STREAM_TYPE_E extends Structure {
		public static final int NETDEV_MAIN_STREAM_TYPE_TIME     = 0;       /*  Scheduled main stream*/
		public static final int NETDEV_MAIN_STREAM_TYPE_EVENT    = 1;       /*  Event main stream*/
	}

	/**
	 * @brief    Enumeration of bit rate mode
	 * @attention  None
	 */
	public static class NETDEV_BIT_RATE_TYPE_E extends Structure {
		public static final int NETDEV_BIT_RATE_TYPE_CBR      = 0;          /* CBR CBR mode*/
		public static final int NETDEV_BIT_RATE_TYPE_VBR      = 1;          /* VBR VBR mode*/
	}

	/**
	 * @brief GOP   Enumeration of GOP type
	 * @attention  None
	 */
	public static class NETDEV_GOP_TYPE_E extends Structure {
		public static final int NETDEV_GOP_TYPE_IP       = 0;       /* IP */
		public static final int NETDEV_GOP_TYPE_IBP      = 1;       /* IBP */
		public static final int NETDEV_GOP_TYPE_IBBP     = 2;       /* IBBP */
		public static final int NETDEV_GOP_TYPE_I        = 3;       /* I */
	}

	/**
	 * @brief    OSD date format capabilities enumeration
	 * @attention  None
	 */
	public static class NETDEV_OSD_DATE_FORMAT_CAP_E extends Structure {
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_MD_YYYY          = 0;        /* M/d/yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_MMDD_YYYY        = 1;        /* MM/dd/yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_DDMM_YYYY        = 2;        /* dd/MM/yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_YYYY_MMDD        = 3;        /* yyyy/MM/dd */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_YYYYMMDDB        = 4;        /* yyyy-MM-dd */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_XX_MMDD_YYYY     = 5;        /* dddd, MMMM dd, yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_MMMMDD_YYYY      = 6;        /* MMMM dd, yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CAP_DDMMMM_YYYY      = 7;         /* dd MMMM, yyyy */
	}

	/**
	 * @brief OSD  OSD time format capabilities enumeration
	 * @attention  None
	 */
	public static class NETDEV_OSD_TIME_FORMAT_CAP_E extends Structure {
		public static final int NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS = 0;                       /* HH:mm:ss */
		public static final int NETDEV_OSD_TIME_FORMAT_CAP_HH_MM_SS_PM = 1;                  /* hh:mm:ss tt */
	}

	public static class NETDEV_OSD_TEXT_TYPE_E extends Structure {
		public static final int NETDEV_OSD_TEXT_DATAANDTIME = 0;   /*., yyyy-MM-dd.HH:mm:ss,  #NETDEV_OSD_DATE_FORMAT_CAP_E,  #NETDEV_OSD_TIME_FORMAT_CAP_E */
		public static final int NETDEV_OSD_TEXT_PLAIN = 1;
	}

	/**
	 * @brief OSD   Enumeration of content type
	 * @attention  None
	 */
	public static class NETDEV_OSD_CONTENT_TYPE_E extends Structure {
		public static final int	NETDEV_OSD_CONTENT_TYPE_NOTUSE                      = 0;                    /*  Not used*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_CUSTOM                      = 1;                    /*  Custom*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_DATE_AND_TIME               = 2;                    /*  Time and date*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PTZ_CONTROLLER              = 3;                    /*  PTZ controller*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PTZ_COORDINATES             = 4;                    /*  PTZ Coordinates*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_CRUISE                      = 5;                    /*  Patrol*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_ZOOM                        = 6;                    /*  Zoom*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PRESET                      = 7;                    /*   Preset*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_ALARM_INFO                  = 8;                    /*  Alarm */
		public static final int	NETDEV_OSD_CONTENT_TYPE_ENCODE                      = 9;                    /*  Encoding*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_SERIAL_PORT                 = 10;                   /* OSD Serial Port OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PTZ_ORIENTATION             = 11;                   /*  PZT direction*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_CHN_NAME                    = 12;                   /*  Channel name*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_DEBUG                       = 13;                   /* OSD  Debug OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PEOPLE_COUNTING             = 14;                   /* OSD People counting OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_NETWORK_PORT                = 15;                   /* OSD Network Port OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_TIME                        = 16;                   /*  Time*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_DATE                        = 17;                   /*  Date*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_SMART_CONTENT               = 18;                   /* OSD Sensing OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_BATTERY                     = 19;                   /* OSD Battery OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_SCROLL_OSD                  = 20;                   /* OSD Scroll text OSD*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PICTURE_OVERLAY             = 21;                   /* LOGO OSD */
		public static final int	NETDEV_OSD_CONTENT_TYPE_MOTOR_VEHICLE_NUM           = 22;                   /*  Vehicle flow of LPR*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_NON_MOTOR_VEHICLE_NUM       = 23;                   /*  Non-vehicle flow of LPR*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_PEOPLE_NUM                  = 24;                   /*  Pedestrian flow of LPR*/
		public static final int	NETDEV_OSD_CONTENT_TYPE_INFOOSD_NUM                 = 25;                    /* INFOOSD Number of INFOOSDtype*/
	}

	/**
	 * @brief  Boolean input operation mode
	 * @attention  None
	 */
	public static class NETDEV_BOOLEAN_MODE_E extends Structure {
		public static final int NETDEV_BOOLEAN_MODE_OPEN   = 1;                         /*   Always open */
		public static final int NETDEV_BOOLEAN_MODE_CLOSE  = 2;                         /*   Always closed */
		public static final int NETDEV_BOOLEAN_MODE_INVALID = 0xFF;
	}

	/**
	 * @brief  Boolean input operation mode
	 * @attention  None
	 */
	public static class NETDEV_RELAYOUTPUT_STATE_E extends Structure {
		public static final int NETDEV_BOOLEAN_STATUS_ACTIVE    = 0;                 /*   Triggered */
		public static final int NETDEV_BOOLEAN_STATUS_INACTIVE  = 1;                 /*  Not triggered */
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_MANUAL_ALARM_CMD_E extends Structure {
		public static final int NETDEV_MANUAL_ALARM_CMD_CLOSE    = 0;               /*  close */
		public static final int NETDEV_MANUAL_ALARM_CMD_TRIGGER  = 1;               /*   Triggered */
	}

	/**
	 * @brief 5ePTZ    5ePTZ display mode Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PTZ_DISPLAY_MODE_E extends Structure {
		public static final int NETDEV_PTZ_DISPLAY_ORIGINAL = 0;        
		public static final int NETDEV_PTZ_DISPLAY_5PTZ     = 1;        /*+5ePTZ*/

		public static final int NETDEV_PTZ_DISPLAY_INVALID  = 0xff;     
	}

	/**
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_AUDIO_SAMPLE_FORMAT_E extends Structure {
		public static final int NETDEV_AUDIO_SAMPLE_FMT_NONE = -1;
		public static final int NETDEV_AUDIO_SAMPLE_FMT_U8      = 0;            /* 8 */
		public static final int NETDEV_AUDIO_SAMPLE_FMT_S16     = 1;            /* 16 */
		public static final int NETDEV_AUDIO_SAMPLE_FMT_S32     = 2;            /* 32 */
		public static final int NETDEV_AUDIO_SAMPLE_FMT_FLT     = 3;            
		public static final int NETDEV_AUDIO_SAMPLE_FMT_DBL     = 4;            /* double */
	}

	/**
	 * @brief   Recording download speed
	 * @attention  None
	 */
	public static class NETDEV_E_DOWNLOAD_SPEED_E extends Structure {
		public static final int	NETDEV_DOWNLOAD_SPEED_ONE           = 0;            
		public static final int	NETDEV_DOWNLOAD_SPEED_TWO           = 1;            
		public static final int	NETDEV_DOWNLOAD_SPEED_FOUR          = 2;            
		public static final int	NETDEV_DOWNLOAD_SPEED_EIGHT         = 3;            
		public static final int	NETDEV_DOWNLOAD_SPEED_TWO_IFRAME    = 4;            /* I */
		public static final int	NETDEV_DOWNLOAD_SPEED_FOUR_IFRAME   = 5;            /* I */
		public static final int	NETDEV_DOWNLOAD_SPEED_EIGHT_IFRAME  = 6;            /* I */
		public static final int	NETDEV_DOWNLOAD_SPEED_HALF          = 7;            /* 1/2  1/2x */
		public static final int	NETDEV_DOWNLOAD_SPEED_FORTY         = 8;            /* 40 40x */

		public static final int	NETDEV_DOWNLOAD_SPEED_INVALID       = 0xFF;          
	}

	/**
	 * @enum tagNETDEVGenderType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_GENDER_TYPE_E extends Structure {
		public static final int NETDEV_GENDER_TYPE_UNKNOW       = 0;         /* 0- */
		public static final int NETDEV_GENDER_TYPE_MAN          = 1;         /* 1- */
		public static final int NETDEV_GENDER_TYPE_WOMAN        = 2;         /* 2- */
		public static final int NETDEV_GENDER_TYPE_UNEXPLAINED  = 9;         /* 9- */
		public static final int NETDEV_GENDER_TYPE_INVALID      = 0xFF;      
	}

	/**
	 * @enum tagNETDEVAgeRange
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_AGE_RANGE_E extends Structure {
		public static final int NETDEV_AGE_RANGE_UNKNOW                                = 0;                
		public static final int NETDEV_AGE_RANGE_CHILD                                 = 1;                
		public static final int NETDEV_AGE_RANGE_JUVENILE                              = 2;                
		public static final int NETDEV_AGE_RANGE_Youth                                 = 3;                
		public static final int NETDEV_AGE_RANGE_MIDDLEAGE                             = 4;                
		public static final int NETDEV_AGE_RANGE_OLDAGE                                = 5;                
		public static final int NETDEV_AGE_RANGE_INVALID                               = 0xFF;             
	}

	/**
	 * @enum tagNETDEVGlassFlag
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_GLASS_FLAG_E extends Structure {
		public static final int NETDEV_GLASS_FLAG_UNKNOW                              = 0;                 
		public static final int NETDEV_GLASS_FLAG_NO                                  = 1;                 
		public static final int NETDEV_GLASS_FLAG_YES                                 = 2;                 
		public static final int NETDEV_GLASS_FLAG_INVALID                             = 0xFF;              
	}

	/**
	 * @enum tagNETDEVGlassesStyle
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_GLASSES_STYLE_E extends Structure {
		public static final int NETDEV_GLASSES_STYLE_UNKNOW                            = 0;                 
		public static final int NETDEV_GLASSES_STYLE_GENERAL                           = 1;                 
		public static final int NETDEV_GLASSES_STYLE_SUNLIGHT                          = 2;                 
		public static final int NETDEV_GLASSES_STYLE_OTHER                             = 99;                
		public static final int NETDEV_GLASSES_STYLE_INVALID                           = 0xFF;              
	}
	/**
	 * @enum tagNETDEVMaskFlag
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_MASK_FLAG_E extends Structure {
		public static final int NETDEV_MASK_FLAG_UNKNOW                        = 0;                 
		public static final int NETDEV_MASK_FLAG_NOT_WEAR                      = 1;                 
		public static final int NETDEV_MASK_FLAG_WEAR                          = 2;                 
		public static final int NETDEV_MASK_FLAG_INVALID                       = 0xFF;               
	}
	/**
	 * @enum tagNETDEVSleevesLength
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_SLEEVES_LENGTH_E extends Structure {
		public static final int NETDEV_SLEEVES_LENGTH_UNKNOW                           = 0;                 
		public static final int NETDEV_SLEEVES_LENGTH_SHORT                            = 1;                 
		public static final int NETDEV_SLEEVES_LENGTH_LONG                             = 2;                 
		public static final int NETDEV_SLEEVES_LENGTH_INVALID                          = 0xFF;              
	}

	/**
	 * @enum tagNETDEVClothesColor
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CLOTHES_COLOR_E extends Structure {
		public static final int	NETDEV_CLOTHES_COLOR_BLACK_E           = 0;            
		public static final int	NETDEV_CLOTHES_COLOR_WHITE_E           = 1;           
		public static final int	NETDEV_CLOTHES_COLOR_GRAY_E            = 2;           
		public static final int	NETDEV_CLOTHES_COLOR_RED_E             = 3;           
		public static final int	NETDEV_CLOTHES_COLOR_BLUE_E            = 4;           
		public static final int	NETDEV_CLOTHES_COLOR_YELLOW_E          = 5;           
		public static final int	NETDEV_CLOTHES_COLOR_ORANGE_E          = 6;           
		public static final int	NETDEV_CLOTHES_COLOR_BROWN_E           = 7;           
		public static final int	NETDEV_CLOTHES_COLOR_GREEN_E           = 8;           
		public static final int	NETDEV_CLOTHES_COLOR_PURPLE_E          = 9;           
		public static final int	NETDEV_CLOTHES_COLOR_CYAN_E            = 10;          
		public static final int	NETDEV_CLOTHES_COLOR_PINK_E            = 11;          
		public static final int	NETDEV_CLOTHES_COLOR_TRANSPARENT_E     = 12;          
		public static final int	NETDEV_CLOTHES_COLOR_SILVERYWHITE_E    = 13;          
		public static final int	NETDEV_CLOTHES_COLOR_DARK_E            = 14;          
		public static final int	NETDEV_CLOTHES_COLOR_LIGHT_E           = 15;          
		public static final int	NETDEV_CLOTHES_COLOR_COLOURLESS        = 16;          
		public static final int	NETDEV_CLOTHES_COLOR_YELLOWGREEN       = 17;          
		public static final int	NETDEV_CLOTHES_COLOR_GRADUALGREEN      = 18;          
		public static final int	NETDEV_CLOTHES_COLOR_OTHER_E           = 99;          
		public static final int	NETDEV_CLOTHES_COLOR_UNKNOW_E          = 100;         
		public static final int	NETDEV_CLOTHES_COLOR_INVALID           = 0xFF;         /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVBodyToward
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_BODY_TOWARD_E extends Structure {
		public static final int NETDEV_BODY_TOWARD_UNKNOW                              = 0;                 
		public static final int NETDEV_BODY_TOWARD_POSITIVE                            = 1;                 
		public static final int NETDEV_BODY_TOWARD_SIDE                                = 2;                 
		public static final int NETDEV_BODY_TOWARD_BACK                                = 3;                 
		public static final int NETDEV_BODY_TOWARD_INVALID                             = 0xFF;              
	}

	/**
	 * @enum tagNETDEVShoesTubeLength
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_SHOES_TUBE_LENGTH_E extends Structure {
		public static final int NETDEV_SHOES_TUBE_LENGTH_UNKNOW                       = 0;                  
		public static final int NETDEV_SHOES_TUBE_LENGTH_LONG                         = 1;                  
		public static final int NETDEV_SHOES_TUBE_LENGTH_SHORT                        = 2;                  /* / */
		public static final int NETDEV_SHOES_TUBE_LENGTH_INVALID                      = 0xFF;               
	}

	/**
	 * @enum tagNETDEVHairLength
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_HAIR_LENGTH_E extends Structure {
		public static final int NETDEV_HAIR_LENGTH_UNKNOW                            = 0;                   
		public static final int NETDEV_HAIR_LENGTH_LONG                              = 1;                   
		public static final int NETDEV_HAIR_LENGTH_SHORT                             = 2;                   
		public static final int NETDEV_HAIR_LENGTH_INVALID                           = 0xFF;                
	}

	/**
	 * @enum tagNETDEVBagFlag
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_BAG_FLAG_E extends Structure {
		public static final int NETDEV_BAG_FLAG_NO                                   = 0;                   
		public static final int NETDEV_BAG_FLAG_CARRY                                = 1;                   
		public static final int NETDEV_BAG_FLAG_BACK                                 = 2;                   
		public static final int NETDEV_BAG_FLAG_INVALID                              = 0xFF;                
	}

	/**
	 * @enum tagNETDEVSpeedType
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_SPEED_TYPE_E extends Structure {
		public static final int NETDEV_SPEED_TYPE_UNKNOW                             = 0;                   
		public static final int NETDEV_SPEED_TYPE_STATIC                             = 1;                   
		public static final int NETDEV_SPEED_TYPE_SLOW                               = 2;                   
		public static final int NETDEV_SPEED_TYPE_MEDIUM                             = 3;                   
		public static final int NETDEV_SPEED_TYPE_FAST                               = 4;                   
		public static final int NETDEV_SPEED_TYPE_INVALID                            = 0xFF;                
	}

	/**
	 * @enum tagNETDEVImageDirection
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_IMAGE_DIRECTION_E extends Structure {
		public static final int NETDEV_IMAGE_DIRECTION_UNKNOW                        = 0;                   
		public static final int NETDEV_IMAGE_DIRECTION_STATIC                        = 1;                   
		public static final int NETDEV_IMAGE_DIRECTION_UP                            = 2;                   
		public static final int NETDEV_IMAGE_DIRECTION_DOWN                          = 3;                   
		public static final int NETDEV_IMAGE_DIRECTION_LEFT                          = 4;                   
		public static final int NETDEV_IMAGE_DIRECTION_RIGHT                         = 5;                   
		public static final int NETDEV_IMAGE_DIRECTION_LEFTUP                        = 6;                   
		public static final int NETDEV_IMAGE_DIRECTION_LEFTDOWN                      = 7;                   
		public static final int NETDEV_IMAGE_DIRECTION_RIGHTUP                       = 8;                   
		public static final int NETDEV_IMAGE_DIRECTION_RIGHTDOWN                     = 9;                   
		public static final int NETDEV_IMAGE_DIRECTION_INVALID                       = 0xFF;                
	}

	/**
	 * @enum tagNETDEVNonVehType
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_NON_VEH_TYPE_E extends Structure {
		public static final int NETDEV_NON_VEH_TYPE_UNKNOW                           = 0;                   
		public static final int NETDEV_NON_VEH_TYPE_BICYCLE                          = 1;                   
		public static final int NETDEV_NON_VEH_TYPE_TRIYCLE                          = 2;                   
		public static final int NETDEV_NON_VEH_TYPE_MOTORCYCLE                       = 3;                   
		public static final int NETDEV_NON_VEH_TYPE_ELECTRIC_BICYCLE                 = 4;                   
		public static final int NETDEV_NON_VEH_TYPE_TWOWHEEL_VEHICLE                 = 5;                   /* //) */
		public static final int NETDEV_NON_VEH_TYPE_INVALID                          = 0xFF;                
	}

	/**
	 * @enum tagNETDEVVehicleType
	 * @brief    plate type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VEHICLE_TYPE_E extends Structure {
		public static final int	NETDEV_VEHICLE_TYPE_TRICYCLE_E       = 0;                
		public static final int	NETDEV_VEHICLE_TYPE_MOTOR_BUS_E      = 1;                
		public static final int	NETDEV_VEHICLE_TYPE_MIDDLE_E         = 2;                
		public static final int	NETDEV_VEHICLE_TYPE_SMALL_E          = 3;                
		public static final int	NETDEV_VEHICLE_TYPE_BIG_E            = 4;                
		public static final int	NETDEV_VEHICLE_TYPE_TWOWHEELVEH      = 5;                
		public static final int	NETDEV_VEHICLE_TYPE_MOTORCYCLE_E     = 6;                
		public static final int	NETDEV_VEHICLE_TYPE_TRACTOR_E        = 7;                
		public static final int	NETDEV_VEHICLE_TYPE_AGRICULTURAL_E   = 8;                
		public static final int	NETDEV_VEHICLE_TYPE_SEADAN           = 9;                
		public static final int	NETDEV_VEHICLE_TYPE_SUV_E            = 10;               /* SUV */
		public static final int	NETDEV_VEHICLE_TYPE_VAN_E            = 11;               
		public static final int	NETDEV_VEHICLE_TYPE_SMALLTRUCK_E     = 12;               
		public static final int	NETDEV_VEHICLE_TYPE_MEDIUMCAR_E      = 13;               /* / */
		public static final int	NETDEV_VEHICLE_TYPE_LARGEBUS_E       = 14;               /* / */
		public static final int	NETDEV_VEHICLE_TYPE_LARGETRUCK_E     = 15;               /* / */
		public static final int	NETDEV_VEHICLE_TYPE_PICKUPTRUCK_E    = 16;               
		public static final int	NETDEV_VEHICLE_TYPE_BUSINESSVEH_E    = 17;               /* MPV  */
		public static final int	NETDEV_VEHICLE_TYPE_SPORTSCAR_E      = 18;               
		public static final int	NETDEV_VEHICLE_TYPE_MINICAR_E        = 19;               
		public static final int	NETDEV_VEHICLE_TYPE_HATCHBACKCAR_E   = 20;               
		public static final int	NETDEV_VEHICLE_TYPE_THREEBOX_E       = 21;               
		public static final int	NETDEV_VEHICLE_TYPE_LIGHTBUS_E       = 22;               
		public static final int	NETDEV_VEHICLE_TYPE_MEDIUNTRUCK_E    = 23;               
		public static final int	NETDEV_VEHICLE_TYPE_TRAILER_E        = 24;               
		public static final int	NETDEV_VEHICLE_TYPE_TANK_E           = 25;               
		public static final int	NETDEV_VEHICLE_TYPE_WATERCAR_E       = 26;               
		public static final int	NETDEV_VEHICLE_TYPE_OTHER_E          = 998;              
		public static final int	NETDEV_VEHICLE_TYPE_UNKNOW_E         = 999;              
		public static final int	NETDEV_VEHICLE_TYPE_INDISTINGUISH_E  = 1000;             
		public static final int	NETDEV_VEHICLE_TYPE_INVALID          = 0xFFFF;            /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVVehicleMonitorType
	 * @brief    monitor type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VEHICLE_MONITOR_TYPE_E extends Structure {
		public static final int NETDEV_VEHICLE_MONITOR_TYPE_ROB_E         = 0;           
		public static final int NETDEV_VEHICLE_MONITOR_TYPE_STEAL_E       = 1;           
		public static final int NETDEV_VEHICLE_MONITOR_TYPE_SUSPICION_E   = 2;           
		public static final int NETDEV_VEHICLE_MONITOR_TYPE_ILLEGAL_E     = 3;           
		public static final int NETDEV_VEHICLE_MONITOR_TYPE_SUREILLANCE_E = 4;           

		public static final int NETDEV_VEHICLE_MONITOR_TYPE_ALL_E         = 255;         

		public static final int NETDEV_VEHICLE_MONITOR_TYPE_INVALID = 0xFFFF;            /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVPlateColor
	 * @brief    plate color Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PLATE_COLOR_E extends Structure {
		public static final int NETDEV_PLATE_COLOR_BLACK_E           = 0;           
		public static final int NETDEV_PLATE_COLOR_WHITE_E           = 1;           
		public static final int NETDEV_PLATE_COLOR_GRAY_E            = 2;           
		public static final int NETDEV_PLATE_COLOR_RED_E             = 3;           
		public static final int NETDEV_PLATE_COLOR_BLUE_E            = 4;           
		public static final int NETDEV_PLATE_COLOR_YELLOW_E          = 5;           
		public static final int NETDEV_PLATE_COLOR_ORANGE_E          = 6;           
		public static final int NETDEV_PLATE_COLOR_BROWN_E           = 7;           
		public static final int NETDEV_PLATE_COLOR_GREEN_E           = 8;           
		public static final int NETDEV_PLATE_COLOR_PURPLE_E          = 9;           
		public static final int NETDEV_PLATE_COLOR_CYAN_E            = 10;          
		public static final int NETDEV_PLATE_COLOR_PINK_E            = 11;          
		public static final int NETDEV_PLATE_COLOR_TRANSPARENT_E     = 12;          
		public static final int NETDEV_PLATE_COLOR_SILVERYWHITE_E    = 13;          
		public static final int NETDEV_PLATE_COLOR_DARK_E            = 14;          
		public static final int NETDEV_PLATE_COLOR_LIGHT_E           = 15;          
		public static final int NETDEV_PLATE_COLOR_COLOURLESS        = 16;          
		public static final int NETDEV_PLATE_COLOR_YELLOWGREEN       = 17;          
		public static final int NETDEV_PLATE_COLOR_GRADUALGREEN      = 18;          
		public static final int NETDEV_PLATE_COLOR_OTHER_E           = 99;          
		public static final int NETDEV_PLATE_COLOR_UNKNOW_E          = 100;         
		public static final int NETDEV_PLATE_COLOR_INVALID           = 0xFF;        /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVPlateType
	 * @brief    plate type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PLATE_TYPE_E extends Structure {
		public static final int	NETDEV_PLATE_TYPE_BIG_CAR_E = 0;                     
		public static final int	NETDEV_PLATE_TYPE_MINI_CAR_E = 1;                    
		public static final int	NETDEV_PLATE_TYPE_EMBASSY_CAR_E = 2;                 
		public static final int	NETDEV_PLATE_TYPE_CONSULATE_CAR_E = 3;               
		public static final int	NETDEV_PLATE_TYPE_OVERSEAS_CAR_E = 4;                
		public static final int	NETDEV_PLATE_TYPE_FOREIGN_CAR_E = 5;                 
		public static final int	NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E = 6;            
		public static final int	NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E = 7;         
		public static final int	NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E = 8;           
		public static final int	NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E = 9;         
		public static final int	NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E = 10;         
		public static final int	NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E = 11;          
		public static final int	NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E = 12;              
		public static final int	NETDEV_PLATE_TYPE_TRACTOR_E = 13;                    
		public static final int	NETDEV_PLATE_TYPE_TRAILER_E = 14;                    
		public static final int	NETDEV_PLATE_TYPE_COACH_CAR_E = 15;                  
		public static final int	NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E = 16;            
		public static final int	NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E = 17;        
		public static final int	NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E = 18;  
		public static final int	NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E = 19;          
		public static final int	NETDEV_PLATE_TYPE_POLICE_CAR_E = 20;                 
		public static final int	NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E = 21;           
		public static final int	NETDEV_PLATE_TYPE_AGRICULTURAL_E = 22;               
		public static final int	NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E = 23;        
		public static final int	NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E = 24;           
		public static final int	NETDEV_PLATE_TYPE_ARMED_POLICE_E = 25;               
		public static final int	NETDEV_PLATE_TYPE_ARMY_E = 26;                       

		public static final int	NETDEV_PLATE_TYPE_OTHER_E = 99;                      


		public static final int	NETDEV_PLATE_TYPE_INVALID = 0xFF;                     /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVImageFormat
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_IMAGE_FORMAT_E extends Structure {
		public static final int NETDEV_IMAGE_FORMAT_JPG                              = 0;                   /* JPG */
		public static final int NETDEV_IMAGE_FORMAT_BMP                              = 1;                   /* BMP */
		public static final int NETDEV_IMAGE_FORMAT_PNG                              = 2;                   /* PNG */
		public static final int NETDEV_IMAGE_FORMAT_GIF                              = 3;                   /* GIF */
		public static final int NETDEV_IMAGE_FORMAT_TIFF                             = 4;                   /* TIFF */
		public static final int NETDEV_IMAGE_FORMAT_INVALID                          = 0xFF;                
	}

	/**
	 * @enum tagNETDEVPeopleLibType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_PEOPLE_LIB_TYPE_E extends Structure {
		public static final int NETDEV_PEOPLE_LIB_TYPE_DEFAULT      = 0;        
		public static final int NETDEV_PEOPLE_LIB_TYPE_BLACKLIST    = 1;        
		public static final int NETDEV_PEOPLE_LIB_TYPE_STRANGER     = 2;        /* / */
		public static final int NETDEV_PEOPLE_LIB_TYPE_STAFF        = 3;        
		public static final int NETDEV_PEOPLE_LIB_TYPE_VISITOR      = 4;        
		public static final int NETDEV_PEOPLE_LIB_TYPE_INVALID      = 0xFF;     
	}

	/**
	 * @enum tagNETDEVSearchType
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_SEARCH_TYPE_E extends Structure {
		public static final int	NETDEV_SEARCH_TYPE_FACE        = 0;             
		public static final int	NETDEV_SEARCH_TYPE_FACE_COMPARE_SUCCESS = 1;    
		public static final int	NETDEV_SEARCH_TYPE_FACE_COMPARE_FAIL    = 2;    

		public static final int	NETDEV_SEARCH_TYPE_INVALID              = 0xff;  
	}

	/**
	 * @enum tagNETDEVQueryCondType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_QUERYCOND_TYPE_E extends Structure {
		public static final int	NETDEV_QUERYCOND_USERNAME          = 0;                /* ： */
		public static final int	NETDEV_QUERYCOND_ORGNAME           = 1;                /* ： */
		public static final int	NETDEV_QUERYCOND_DEVNAME           = 2;                /* ： */
		public static final int	NETDEV_QUERYCOND_CHNNAME           = 3;                /* ： */
		public static final int	NETDEV_QUERYCOND_TIME              = 4;                /* ： */
		public static final int	NETDEV_QUERYCOND_BUSINESSTYPE      = 5;                /* ： */
		public static final int	NETDEV_QUERYCOND_OPERATETYPE       = 6;                /* ： */
		public static final int	NETDEV_QUERYCOND_OPEROBJECT        = 7;                /* ： */
		public static final int	NETDEV_QUERYCOND_ALARMTYPE         = 8;                /* ：   NETDEV_ALARM_TYPE_E*/
		public static final int	NETDEV_QUERYCOND_ALARMSRCNAME      = 9;                /* ： */
		public static final int	NETDEV_QUERYCOND_ALARMLEVEL        = 10;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARMCHECKED      = 11;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARMCHECKUSER    = 12;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARMCHECKTIME    = 13;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARM_DEVID       = 14;               /* ：ID */
		public static final int	NETDEV_QUERYCOND_ALARM_CHNID       = 15;               /* ：ID */
		public static final int	NETDEV_QUERYCOND_ALARM_SUBTYPE     = 16;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARM_SERVER      = 17;               /* ： */
		public static final int	NETDEV_QUERYCOND_DOOR_NUM          = 18;               /* ： */
		public static final int	NETDEV_QUERYCOND_CARD_NUM          = 19;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARM_GENDER      = 20;               /* ： */
		public static final int	NETDEV_QUERYCOND_ALARM_BIRTHDAY    = 21;               /* ： */
		public static final int	NETDEV_QUERYCOND_MONITOY_REASON    = 22;               /* ： */
		public static final int	NETDEV_QUERYCOND_PLATE_NUM         = 23;               /* ： */
		public static final int	NETDEV_QUERYCOND_VEHICLE_TYPE      = 24;               /* ： */
		public static final int	NETDEV_QUERYCOND_PLATE_COLOR       = 25;               /* ： */
		public static final int	NETDEV_QUERYCOND_VEHICLE_COLOR     = 26;               /* ： */
		public static final int	NETDEV_QUERYCOND_PERSON_NUMBER     = 27;               /* ：*/
		public static final int	NETDEV_QUERYCOND_PERSON_TYPE       = 28;               /* ：*/
		public static final int	NETDEV_QUERYCOND_DIRECT            = 29;               /* ：*/
		public static final int	NETDEV_QUERYCOND_ORGID             = 30;               /* ID */
		public static final int	NETDEV_QUERYCOND_ORGPID            = 31;               /* PID */
		public static final int	NETDEV_QUERYCOND_DEVICEID          = 32;               /* ID */
		public static final int	NETDEV_QUERYCOND_DEVICE_TYPE       = 33;               
		public static final int	NETDEV_QUERYCOND_DEVICE_SUBTYPE    = 34;               
		public static final int	NETDEV_QUERYCOND_CHANNELID         = 35;               /* ID */
		public static final int	NETDEV_QUERYCOND_CHANNEL_TYPE      = 36;               
		public static final int	NETDEV_QUERYCOND_ONLINE_STATE      = 37;               
		public static final int	NETDEV_DATABASE_ID                 = 38;               /* ：ID */
		public static final int	NETDEV_QUERY_TYPE_PLATECLASS       = 39;               /* ： */
		public static final int	NETDEV_QUERYCOND_RANGE             = 40;               /* ： 01*/
		public static final int	NETDEV_QUERYCOND_BEGIN_TIME          = 41;             /* ：*/
		public static final int	NETDEV_QUERYCOND_END_TIME            = 42;             /* ：*/
		public static final int	NETDEV_QUERYCOND_INTERVIEWEE_NAME    = 43;             /* ：*/
		public static final int	NETDEV_QUERYCOND_INTERVIEWEE_STATUS  = 44;             /* ：*/
		public static final int	NETDEV_QUERYCOND_PARK_NAME         = 45;               /* ： */
		public static final int	NETDEV_QUERYCOND_CONFIDENCE_LEVEL  = 46;               /* ： */
		public static final int	NETDEV_QUERYCOND_PARK_TIME         = 47;               /* ： */
		public static final int	NETDEV_QUERYCOND_CONTRACT_RULE     = 48;               /* ： */
		public static final int	NETDEV_QUERYCOND_PAYMENT_METHOD    = 49;               /* ： */
		public static final int	NETDEV_QUERYCOND_PASSING_DIRECTION = 50;               /* ： */
		public static final int	NETDEV_QUERYCOND_VEHICLE_ATTR      = 51;               /* ： */
		public static final int	NETDEV_QUERYCOND_STATISTICS_UNITS  = 52;               /* ： */
		public static final int	NETDEV_QUERYCOND_EXITENTRANCE_NAME = 53;               /* ： */
		public static final int	NETDEV_QUERYCOND_PICTURE_DATA      = 54;               /* ： */
		public static final int	NETDEV_QUERYCOND_PERSON_NAME       = 55;               /* ： */
		public static final int	NETDEV_QUERYCOND_SIMILARITY        = 56;               /* ： */
		public static final int	NETDEV_QUERYCOND_SEARCH_TYPE       = 57;               /* ：   NETDEV_SEARCH_TYPE_E */
		public static final int	NETDEV_QUERYCOND_ID_NUMBER         = 58;               /* ： */
		public static final int	NETDEV_QUERYCOND_AGERANGE          = 59;               /* ： */
		public static final int	NETDEV_QUERYCOND_GLASSES_STYLE     = 61;               /* ： */
		public static final int	NETDEV_QUERYCOND_SLEEVES_LENGTH    = 62;               /* ： */
		public static final int	NETDEV_QUERYCOND_COAT_COLOR        = 63;               /* ： */
		public static final int	NETDEV_QUERYCOND_TROUSERS_STYLE    = 64;               /* ： */
		public static final int	NETDEV_QUERYCOND_TROUSERS_COLOR    = 65;               /* ： */
		public static final int	NETDEV_QUERYCOND_SNAP_TOWARD       = 66;               /* ： */
		public static final int	NETDEV_QUERYCOND_SHOES_TUBE_LENGTH = 67;               /* ： */
		public static final int	NETDEV_QUERYCOND_HAIR_LENGTH       = 68;               /* ： */
		public static final int	NETDEV_QUERYCOND_BAG_FLAG          = 69;               /* ： */
		public static final int	NETDEV_QUERYCOND_SPEED_TYPE        = 70;               /* ： */
		public static final int	NETDEV_QUERYCOND_NON_VEH_TYPE      = 71;               /* ： */
		public static final int	NETDEV_QUERYCOND_VEH_BRAND         = 72;               /* ： */
		public static final int	NETDEV_QUERYCOND_VEH_DATA_TYPE     = 73;               /* ：0：1： */
		public static final int	NETDEV_QUERYCOND_PROTOCOL_TYPE             = 74;       /* ： */
		public static final int	NETDEV_QUERYCOND_RELEVANT_ROOM             = 75;       /* ： */
		public static final int	NETDEV_QUERYCOND_LOCK_SIGNAL               = 76;       /* ： */
		public static final int	NETDEV_QUERYCOND_BIND_RELATION_DOORLOCK    = 77;       /* ： */
		public static final int	NETDEV_QUERYCOND_BIND_RELATION_PERSON_CARD = 78;       /* ： */
		public static final int	NETDEV_QUERYCOND_PERSONID                  = 79;       /* ：ID */
		public static final int	NETDEV_QUERYCOND_PARKINGLOTID              = 80;       /* ：ID */
		public static final int	NETDEV_QUERYCOND_ENTREXITID                = 81;       /* ：ID */
		public static final int	NETDEV_QUERYCOND_RECORDID                  = 82;       /* ：ID */
		public static final int	NETDEV_QUERYCOND_VEH_GROUPINGID            = 83;       /* ：ID */
		public static final int	NETDEV_QUERYCOND_KEYWORD                   = 84;       /* ： */
		public static final int	NETDEV_QUERYCOND_PUBULISH_TYPE             = 85;       /* ： (0：, 1：) */
		public static final int	NETDEV_QUERYCOND_PROGRAM_NAME              = 86;       /* ： */
		public static final int	NETDEV_QUERYCOND_ORG_TYPE                  = 87;       /* ：  NETDEV_ORG_TYPE_E */
		public static final int	NETDEV_QUERYCOND_VALID_DATE                = 88;       /* ： */
		public static final int	NETDEV_QUERYCOND_VALID_TIME                = 89;       /* ： */
		public static final int	NETDEV_QUERYCOND_VALID_WEEK                = 90;       /* ： */
		public static final int	NETDEV_QUERYCOND_MASK_FLAG                 = 92;       /* ：(0：1：2：) */
		public static final int	NETDEV_QUERYCOND_TEMPERATURE               = 93;       /* ： */
		public static final int NETDEV_QUERYCOND_SKINCOLOR_TYPE            = 95;       /* ：  NETDEV_SKINCOLOR_TYPE_E */
	    public static final int NETDEV_QUERYCOND_BEARD_FLAG                = 96;       /* ：  NETDEV_BEARD_FLAG_E */
	    public static final int NETDEV_QUERYCOND_OBJECT_TYPE               = 97;       /* ：   NETDEV_OBJECT_TYPE_E  */
		public static final int	NETDEV_QUERYCOND_INVALID                   = 0xFF;     
	}
	
	/**
	 * @enum tagNETDEVQueryCondLogic
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_QUERYCOND_LOGICTYPE_E extends Structure {
		public static final int NETDEV_QUERYCOND_LOGIC_EQUAL             = 0;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_GREATER           = 1;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_LESS              = 2;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_NO_LESS           = 3;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_NO_GREATER        = 4;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_NO_EQUAL          = 5;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_DIM_QUERY         = 6;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_CONTAIN           = 7;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_ASC_ORDER         = 8;                /* ： */
		public static final int NETDEV_QUERYCOND_LOGIC_DESC_ORDER        = 9;                /* ： */
	}

	/**
	 * @enum tagNETDEVCertificateType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ID_TYPE_E extends Structure {
		public static final int NETDEV_CERTIFICATE_TYPE_ID                  = 0;        /*0: */
		public static final int NETDEV_CERTIFICATE_TYPE_IC                  = 1;        /* 1:IC */
		public static final int NETDEV_CERTIFICATE_TYPE_PASSPORT            = 2;        /* 2: */
		public static final int NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE     = 3;        /* 3: */
		public static final int NETDEV_CERTIFICATE_TYPE_OTHER               = 99;       /* 99: */
		public static final int NETDEV_CERTIFICATE_TYPE_INVALID             = 0xFF;     
	}

	/**
	 * @enum tagNETDEVFileType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_FILE_TYPE_E extends Structure {
		public static final int NETDEV_TYPE_FOLDER  = 0;     
		public static final int NETDEV_TYPE_FILE    = 1;     
		public static final int NETDEV_TYPE_INVALID = 0xff;  
	}

	/**
	 * @enum tagNETDEVPersonResultCode
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_PERSON_RESULT_CODE_E extends Structure {
		public static final int	NETDEV_PERSON_CODE_SUCCEED                        = 0;               
		public static final int	NETDEV_PERSON_CODE_COMMON_FAIL                    = 1;               
		public static final int	NETDEV_PERSON_CODE_SENDING                        = 2;               
		public static final int	NETDEV_PERSON_CODE_DEV_NOT_SUPPORT                = 4;               
		public static final int	NETDEV_PERSON_CODE_ARGORITHM_INIT_FAIL            = 1000;            
		public static final int	NETDEV_PERSON_CODE_FACE_DETECT_FAIL               = 1001;            
		public static final int	NETDEV_PERSON_CODE_PICTURE_NO_FACE                = 1002;            
		public static final int	NETDEV_PERSON_CODE_JPEG_DECODE_FAIL               = 1003;            /* jpeg */
		public static final int	NETDEV_PERSON_CODE_PICTURE_QUALITY_LOW            = 1004;            
		public static final int	NETDEV_PERSON_CODE_PICTURE_ZOOM_FAIL              = 1005;            
		public static final int	NETDEV_PERSON_CODE_INTELLECT_DISABLE              = 1006;            
		public static final int	NETDEV_PERSON_CODE_PICTURE_TOO_SMALL              = 1007;            
		public static final int	NETDEV_PERSON_CODE_PICTURE_TOO_LARGE              = 1008;            
		public static final int	NETDEV_PERSON_CODE_RESOLUTION_TOO_LARGE           = 1009;            /* 1920*1080 */
		public static final int	NETDEV_PERSON_CODE_PICTURE_NON_EXISTENT           = 1010;            
		public static final int	NETDEV_PERSON_CODE_FACE_ELEMENTS_LIMIT            = 1011;            
		public static final int	NETDEV_PERSON_CODE_INTELLECT_MODULE_MISMATCH      = 1012;            
		public static final int	NETDEV_PERSON_CODE_DOCUMENT_ID_INVLID             = 1013;            
		public static final int	NETDEV_PERSON_CODE_PICTURE_FORMAT_ERROR           = 1014;            
		public static final int	NETDEV_PERSON_CODE_MONITOR_DEVICE_LIMIT           = 1015;            
		public static final int	NETDEV_PERSON_CODE_FACE_LIBRARY_LOCKED            = 1016;            
		public static final int	NETDEV_PERSON_CODE_FACE_LIBRARY_UPDATING          = 1017;            
		public static final int	NETDEV_PERSON_CODE_JSON_DESERIALIZE_FAIL          = 1018;            /* Json */
		public static final int	NETDEV_PERSON_CODE_BASE64_DECODE_FAIL             = 1019;            /* Base64 */
		public static final int	NETDEV_PERSON_CODE_PICTURE_SIZE_MISMATCH          = 1020;            
		public static final int	NETDEV_PERSON_CODE_DEV_PROTOCOL_DIFFER            = 1021;            
		public static final int NETDEV_PERSON_CODE_REACH_LIMIT                    = 1022;            
		public static final int NETDEV_PERSON_CODE_NO_SMART                       = 1023;            
		public static final int NETDEV_PERSON_CODE_DEV_BUSY                       = 1024;            
		public static final int	NETDEV_PERSON_CODE_INVALID                        = 0xff;             
	}

	/**
	 * @enum tagNETDEVFaceMemberIDType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_FACE_MEMBER_ID_TYPE_E extends Structure {
		public static final int NETDEV_FACE_MEMBER_ID_TYPE_ID_CARD                 = 0;               
		public static final int NETDEV_FACE_MEMBER_ID_TYPE_IC_CARD                 = 1;               /* IC */
		public static final int NETDEV_FACE_MEMBER_ID_TYPE_PASSPORT                = 2;               
		public static final int NETDEV_FACE_MEMBER_ID_TYPE_DRIVING                 = 3;               
		public static final int NETDEV_FACE_MEMBER_ID_TYPE_OTHER                   = 99;              

		public static final int NETDEV_FACE_MEMBER_ID_TYPE_INVALID                 = 0xFF;            
	}

	/**
	 * @struct tagNETDEVFacePassRecordType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_FACE_PASS_RECORD_TYPE_E extends Structure {
	    public static final int NETDEV_TYPE_FACE_PASS_SNAPSHOT          = 0;                
		public static final int NETDEV_TYPE_FACE_PASS_COM_SUCCESS       = 1;                
		public static final int NETDEV_TYPE_FACE_PASS_COM_FAIL          = 2;                
		public static final int NETDEV_TYPE_FACE_PASS_INVALID           = 0xff;             
	}

	/**
	 * @enum tagNETDEVAlarmActID
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_ALARM_ACT_ID_E extends Structure {
		public static final int	ALARM_ACTION_TYPE_NVR_PREVIEW                = 0;                    /* NVRActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_BUZZER                     = 1;                    /* IPC,NVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_E_MAIL                     = 2;                    /* E-MailIPCNVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_RECORD                     = 3;                    /* IPCNVR ActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_PRESET                     = 4;                    /* ActParam NETDEV_PRESET_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_OUTPUT_SWITCH              = 5;                    /* ActParam NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_SNAP                       = 6;                    /* IPCActParam NVR ActParam NETDEV_CHANNEL_ACT_PARAM_INFO_S*/
		public static final int	ALARM_ACTION_TYPE_BOX                        = 7;                    /* IPCNVR ActParam NETDEV_ENABLED_ACT_PARAM_INFO_S */
		public static final int	ALARM_ACTION_TYPE_CENTER_RECORD              = 8;                    /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_START_LOCAL_RECORD         = 9;                    /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_STOP_LOCAL_RECORD          = 10;                   /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_SNAP_UP_FTP                = 11;                   /* FTPIPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_SNAP_UP_EMAIL              = 12;                   /* EMailIPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_SNAP_UP_FTP_AND_EMAIL      = 13;                   /* FTPEMailIPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_SMART_SNAP_UP              = 14;                   /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_FACE_PIC_SNAP_UP           = 15;                   /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_ALARM_REPORT               = 16;                   /* IPCActParamNVR */
		public static final int	ALARM_ACTION_TYPE_PTZ_ZOOM                   = 17;                   
		public static final int	ALARM_ACTION_TYPE_INVALID                    = 0xff;                  
	}

	/**
	 * @struct tagLinkageStrategy
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_PERSON_COMPARE_RESULT_TYPE_E extends Structure {
		public static final int NETDEV_TYPE_COMPARE_SUCCESS = 1;
		public static final int NETDEV_TYPE_COMPARE_FAILED = 2;
		public static final int NETDEV_TYPE_COMPARE_INVALID = 0xff;
	}

	/**
	 * @brief            Alarm And Defence Type Enumeration definition
	 * @attention /IPC
	 */
	public static class NETDEV_ARMING_TYPE_E extends Structure {
		public static final int NETDEV_ARMING_TYPE_TIMING                   = 0;        
		public static final int NETDEV_ARMING_TYPE_MOTIONDETEC              = 1;        
		public static final int NETDEV_ARMING_TYPE_ALARM                    = 2;        
		public static final int NETDEV_ARMING_TYPE_MOTIONDETEC_AND_ALARM    = 3;        
		public static final int NETDEV_ARMING_TYPE_MOTIONDETEC_OR_ALARM     = 4;        
		public static final int NETDEV_ARMING_TYPE_NO_PLAN                  = 5;        
		public static final int NETDEV_ARMING_TYPE_EVENT                    = 10;       
	}

	
	public static class NETDEV_LAPI_WEEK_INFO_E extends Structure {
		public static final int NETDEV_LAPI_WEEK_MONDAY                  = 1;                  /*   Monday */
		public static final int NETDEV_LAPI_WEEK_TUESDAY                 = 2;                  /*   Tuesday */
		public static final int NETDEV_LAPI_WEEK_WEDNESDAY               = 3;                  /*   Wednesday */
		public static final int NETDEV_LAPI_WEEK_THURSDAY                = 4;                  /*   Thursday */
		public static final int NETDEV_LAPI_WEEK_FRIDAY                  = 5;                  /*   Friday */
		public static final int NETDEV_LAPI_WEEK_SATURDAY                = 6;                  /*   Saturday */
		public static final int NETDEV_LAPI_WEEK_SUNDAY                  = 7;                  /*   Sunday */
		public static final int NETDEV_LAPI_WEEK_HOLIDAY                 = 8;                  /*  Holiday */
		public static final int NETDEV_LAPI_WEEK_INVALID                 = 0xff;               
	}

	/**
	 * @brief             Defence Plan Enable Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_DEFENCE_PLAN_ENABLE_E extends Structure {
		public static final int NETDEV_DEFENCE_PLAN_DISABLE     = 0;        
		public static final int NETDEV_DEFENCE_PLAN_ENABLE      =  1;       
	}

	/**
	 * @enum tagNETDEVPersonMonitorOptResCode
	 * @brief 
	 * @attention VMS
	 */
	public static class NETDEV_PERSON_MONITOR_OPT_RES_CODE_E extends Structure {
		public static final int	NETDEV_PERSON_MONITOR_CODE_INIT_DETECT_FAIL             = 11702;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_FACE_DETECT_FAIL             = 11703;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_IMAGE_NOT_FIND_FACE          = 11704;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_JPEG_PARSE_FAIL              = 11705;           /* jpeg */
		public static final int	NETDEV_PERSON_MONITOR_CODE_IMAGE_MASS_NOT_ENOUGH        = 11706;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_IMAGE_ZOOM_FAIL              = 11707;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_NOT_START_SMART              = 11708;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_SMALL            = 11709;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_CREATE_FACE_LIB_FAIL         = 11710;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_CREATE_MONITOR_FAIL          = 11711;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_LARGE            = 11714;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_RESOLUTION_TOO_LARGE         = 11715;           /* 1920*1080 */
		public static final int	NETDEV_PERSON_MONITOR_CODE_PICTURE_NON_EXISTENT         = 11716;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_FACE_ELEMENTS_LIMIT          = 11717;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_INTELLECT_MODULE_MISMATCH    = 11718;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_DOCUMENT_ID_INVLID           = 11719;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_PICTURE_FORMAT_ERROR         = 11720;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_MONITOR_DEVICE_LIMIT         = 11721;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_LOCKED          = 11722;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_UPDATING        = 11723;           
		public static final int	NETDEV_PERSON_MONITOR_CODE_JSON_DESERIALIZE_FAIL        = 11724;           /* Json */
		public static final int	NETDEV_PERSON_MONITOR_CODE_BASE64_DECODE_FAIL           = 11725;           /* Base64 */
		public static final int	NETDEV_PERSON_MONITOR_CODE_PICTURE_SIZE_MISMATCH        = 11726;            
	}

	
	public static class NETDEV_MONITOR_ERR_CODE_E extends Structure {
		public static final int NETDEV_E_VIID_DISPOSE_DEV_BUSY                  = 25006;  /*  View library layout control error, equipment busy */
		public static final int NETDEV_E_VIID_DISPOSE_DATABASE_FULL             = 25007;  /* , View database layout control error, face database has reached the upper limit */
		public static final int NETDEV_E_VIID_DISPOSE_MEMBER_FULL               = 25008;  /* , View database layout control error, face members have reached the upper limit */
		public static final int NETDEV_E_VIID_DISPOSE_NO_SMARTBAR               = 25009;  /* , View Library Layout Control Error, Device Smart Bar does not exist */
		public static final int NETDEV_E_VIID_DISPOSE_VIID_OFFLINE              = 25010;  /* , View Library Layout Error, Device View Library Not Connected */
	}

	/**
	 * @enum tagNETDEVSmartAlarmType
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_SMART_ALARM_TYPE_E extends Structure {
		public static final int NETDEV_SMART_ALARM_TYPE_FACE_SNAP         = 0;             
		public static final int NETDEV_SMART_ALARM_TYPE_VEHICLE_SNAP      = 1;             
		public static final int NETDEV_SMART_ALARM_TYPE_VIDEO_STRUCT_SNAP = 3;             
		public static final int NETDEV_SMART_ALARM_TYPE_INVALID           = 0xFF;          
	}

	/**
	 * @enum tagNETDEVNotificationType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_NOTIFICATION_TYPE_E extends Structure {
		public static final int NETDEV_NOTIFICATION_TYPE_REALTIME        = 0;           
		public static final int NETDEV_NOTIFICATION_TYPE_HISTORY         = 1;           
		public static final int NETDEV_NOTIFICATION_TYPE_EARLYWARN       = 2;           
	}

	/**
	 * @enum tagNETDEVVehReleaseType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_VEH_RELEASE_TYPE_E extends Structure {
		public static final int NETDEV_VEH_RELEASE_TYPE_AUTO                 = 0;               
		public static final int NETDEV_VEH_RELEASE_TYPE_MANUAL               = 1;               
		public static final int NETDEV_VEH_RELEASE_TYPE_INVALID              = 0xFF;            
	}

	/**
	 * @enum tagNETDEVVehLaneType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_VEH_LANE_TYPE_E extends Structure {
		public static final int NETDEV_VEH_LANE_TYPE_ENTRANCE                = 0;               
		public static final int NETDEV_VEH_LANE_TYPE_EXIT_NOCHARGE           = 1;               
		public static final int NETDEV_VEH_LANE_TYPE_EXITE_CHARGE            = 2;               
		public static final int NETDEV_VEH_LANE_TYPE_INVALID                 = 0xFF;            
	}

	/**
	 * @enum tagNETDEVChgType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CHG_TYPE_E extends Structure {
		public static final int NETDEV_CHG_TYPE_CASH                             = 0;                
		public static final int NETDEV_CHG_TYPE_ALIPY                            = 1;                
		public static final int NETDEV_CHG_TYPE_WECHAT                           = 2;                
		public static final int NETDEV_CHG_TYPE_UNIONPAY                         = 3;                
		public static final int NETDEV_CHG_TYPE_INVALID                          = 0xFF;             
	}

	/**
	 * @enum tagNETDEVOrderStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ORDER_STATUS_E extends Structure {
		public static final int NETDEV_ORDER_STATUS_FINISH            = 0;        
		public static final int NETDEV_ORDER_STATUS_UNFINISH          = 1;        
		public static final int NETDEV_ORDER_STATUS_PREPAYMENT        = 2;        
		public static final int NETDEV_ORDER_STATUS_INVALID           = 0xff;     /*  Invalid value */
	}

	/**
	 * @enum tagNETDEVPayType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_PAY_TYPE_E extends Structure {
		public static final int NETDEV_PAY_TYPE_CASH              = 0;        
		public static final int NETDEV_PAY_TYPE_ALIPAY            = 1;        
		public static final int NETDEV_PAY_TYPE_WECHAT            = 2;        
		public static final int NETDEV_PAY_TYPE_INVALID           = 0xff;     /*  Invalid value */
	}

	/**
	 * @enum tagNETDEVVehAttrType
	 * @brief ()
	 * @attention  None
	 */
	public static class NETDEV_VEH_ATTR_TYPE_E extends Structure {
		public static final int NETDEV_VEH_ATTR_FIXED                         = 0;                
		public static final int NETDEV_VEH_ATTR_TEMPORARY                     = 1;                
		public static final int NETDEV_VEH_ATTR_FIXEDOVERDUE                  = 2;                
		public static final int NETDEV_VEH_ATTR_INVALID                       = 0xFF;             
	}

	/**
	 * @enum tagNETDEVVehicleColor
	 * @brief    plate color Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_VEHICLE_COLOR_E extends Structure {
		public static final int	NETDEV_VEHICLE_COLOR_BLACK_E          = 0;        
		public static final int	NETDEV_VEHICLE_COLOR_WHITE_E          = 1;        
		public static final int	NETDEV_VEHICLE_COLOR_GRAY_E           = 2;        
		public static final int	NETDEV_VEHICLE_COLOR_RED_E            = 3;        
		public static final int	NETDEV_VEHICLE_COLOR_BLUE_E           = 4;        
		public static final int	NETDEV_VEHICLE_COLOR_YELLOW_E         = 5;        
		public static final int	NETDEV_VEHICLE_COLOR_ORANGE_E         = 6;        
		public static final int	NETDEV_VEHICLE_COLOR_BROWN_E          = 7;        
		public static final int	NETDEV_VEHICLE_COLOR_GREEN_E          = 8;        
		public static final int	NETDEV_VEHICLE_COLOR_PURPLE_E         = 9;        
		public static final int	NETDEV_VEHICLE_COLOR_CYAN_E           = 10;       
		public static final int	NETDEV_VEHICLE_COLOR_PINK_E           = 11;       
		public static final int	NETDEV_VEHICLE_COLOR_TRANSPARENT_E    = 12;       
		public static final int	NETDEV_VEHICLE_COLOR_OTHER_E          = 99;       

		public static final int	NETDEV_VEHICLE_COLOR_INVALID        = 0xFF;      /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVCapSrc
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CAP_SRC_E extends Structure {
		public static final int NETDEV_CAP_SRC_FACE                      = 1;          
		public static final int NETDEV_CAP_SRC_ENTRANCE_GUARDCARD        = 2;          
		public static final int NETDEV_CAP_SRC_ID                        = 3;          
		public static final int NETDEV_CAP_SRC_GATE                      = 4;          
		public static final int NETDEV_CAP_SRC_INVALID                   = 0xff;       /*  Invalid value */
	}

	/**
	 * @enum tagNETDEVMatchStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_MATCH_STATUS_E extends Structure {
		public static final int NETDEV_MATCH_STATUS_SUCCESS               = 1;          
		public static final int NETDEV_MATCH_STATUS_FAIL                  = 2;          /* ) */
		public static final int NETDEV_MATCH_STATUS_NO_MONITOR_TIME       = 3;          
		public static final int NETDEV_MATCH_STATUS_ATTR_ABNORMAL         = 10;         /* ) */
		public static final int NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_SUCC = 41;          
		public static final int NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_FAIL = 42;          
		public static final int NETDEV_MATCH_STATUS_INVALID               = 0xff;       /*  Invalid value */
	}

	/**
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_MEDIA_DATA_FORMAT_E extends Structure {
		public static final int NETDEV_MEDIA_DATA_TS            = 0;            /* TS */
		public static final int NETDEV_MEDIA_DATA_RTP_ES        = 3;            /* RTP + ES */
	}

	/**
	 * @brief    Exception callback message types Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_EXCEPTION_TYPE_E extends Structure {
	    public static final int NETDEV_EXCEPTION_REPORT_REMUXING_FINISH     = 284;          

		/*   Playback exceptions report 300~399 */
		public static final int	NETDEV_EXCEPTION_REPORT_VOD_END             = 300;          /*   Playback ended*/
		public static final int	NETDEV_EXCEPTION_REPORT_VOD_ABEND           = 301;          /*   Playback exception occured */
		public static final int	NETDEV_EXCEPTION_REPORT_BACKUP_END          = 302;          /*   Backup ended */
		public static final int	NETDEV_EXCEPTION_REPORT_BACKUP_DISC_OUT     = 303;          /*   Disk removed */
		public static final int	NETDEV_EXCEPTION_REPORT_BACKUP_DISC_FULL    = 304;          /*   Disk full */
		public static final int	NETDEV_EXCEPTION_REPORT_BACKUP_ABEND        = 305;          /*    Backup failure caused by other reasons */

		public static final int	NETDEV_EXCEPTION_EXCHANGE                   = 0x8000;       /*   Exception occurred during user interaction (keep-alive timeout) */
		public static final int	NETDEV_EXCEPTION_REPORT_ALARM_INTERRUPT     = 0x8001;       /*   Failure to report abnormal termination of life preservation or disconnection of long connection */

		public static final int	NETDEV_EXCEPTION_REPORT_MAX                 = 0x8002;    /*   Maximum value */
		public static final int	NETDEV_EXCEPTION_REPORT_NOT_VALID_PERIOD    = 0x8003;    /*  Not Valid period */
		public static final int	NETDEV_EXCEPTION_REPORT_NOT_VALID_TIME      = 0x8004;    /*  Not Valid Time */

		public static final int	NETDEV_EXCEPTION_REPORT_INVALID             = 0xFFFF;        /*   Invalid value */
	}

	/**
	 * @enum tagNetDEVFishEyePtzMode
	 * @brief  
	 * @attention 
	 */
	public static class NETDEV_FISHEYE_PTZ_MODE_E extends Structure {
		public static final int	NETDEV_FISHEYE_MODE_ORIGINAL            = 0;                
		public static final int	NETDEV_FISHEYE_MODE_180                 = 1;                /* 2*180 */
		public static final int	NETDEV_FISHEYE_MODE_360_1PTZ            = 2;                /* 360+1PTZ */
		public static final int	NETDEV_FISHEYE_MODE_360_6PTZ            = 3;                /* 360+6PTZ */
		public static final int	NETDEV_FISHEYE_MODE_3PTZ                = 4;                /* +3PTZ */
		public static final int	NETDEV_FISHEYE_MODE_MID_ON_4PTZ         = 5;                /* +4PTZ */
		public static final int	NETDEV_FISHEYE_MODE_MID_OFF_4PTZ        = 6;                /* +4PTZ */
		public static final int	NETDEV_FISHEYE_MODE_LEFT_4PTZ           = 7;                /* +4PTZ */
		public static final int	NETDEV_FISHEYE_MODE_8PTZ                = 8;                /* +8PTZ */
		public static final int	NETDEV_FISHEYE_MODE_PANORAMA            = 9;                
		public static final int	NETDEV_FISHEYE_MODE_PR_3PTZ             = 10;               /* +3PTZ */
		public static final int	NETDEV_FISHEYE_MODE_PR_4PTZ             = 11;               /* +4PTZ */
		public static final int	NETDEV_FISHEYE_MODE_PR_8PTZ             = 12;               /* +8PTZ */

		public static final int	NETDEV_FISHEYE_MODE_INVALID             = 0xFF;             
	}

	/**
	 * @enum tagNETDEVfInstallMode
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_INSTALL_MODE_E extends Structure {
		public static final int NETDEV_INSTALL_MODE_TOP             = 0;            
		public static final int NETDEV_INSTALL_MODE_BOTTOM          = 1;            
		public static final int NETDEV_INSTALL_MODE_SIDE            = 2;            

		public static final int NETDEV_INSTALL_MODE_INVALID         = 0xFF;         
	}

	/**
	 * @enum tagNETDEVfMouseMoveMode
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_MOUSE_MOVE_MODE_E extends Structure {
		public static final int NETDEV_MOUSE_MOVE                   = 0;            
		public static final int NETDEV_MOUSE_LEFT_BTN_DOWN          = 1;            
		public static final int NETDEV_MOUSE_LEFT_BTN_UP            = 2;            
		public static final int NETDEV_MOUSE_WHEEL                  = 3;            

		public static final int NETDEV_MOUSE_INVALID                = 0xFF;         
	}

	/**
	 * @enum tagNETDEVACSVisitStaus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ACS_VISIT_STATUS_E extends Structure {
		public static final int NETDEV_ACS_VISIT_STATUS_SCHEDULE                 = 0;               
		public static final int NETDEV_ACS_VISIT_STATUS_VISITING                 = 1;               
		public static final int NETDEV_ACS_VISIT_STATUS_LEAVE                    = 2;               
		public static final int NETDEV_ACS_VISIT_STATUS_SCHEDULE_CANCEL          = 3;               
		public static final int NETDEV_ACS_VISIT_STATUS_TIMEOUT                  = 4;               

		public static final int NETDEV_ACS_VISIT_STATUS_INVALID                  = 0xFF;            
	}

	/**
	 * @enum tagNETDEVACSPersonType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_ACS_PERSON_TYPE_E extends Structure {
		public static final int NETDEV_ACS_PERSON_TYPE_STAFF                      = 0;               
		public static final int NETDEV_ACS_PERSON_TYPE_VISITOR                    = 1;               
		public static final int NETDEV_ACS_PERSON_TYPE_STRANGER                   = 2;               
		public static final int NETDEV_ACS_PERSON_TYPE_BLACKLIST                  = 3;               

		public static final int NETDEV_ACS_PERSON_TYPE_INVALID                    = 0xFF;            
	}

	
	public static class NETDEV_PACS_ECODE_E extends Structure {
		public static final int	NETDEV_E_PACS_PERSON_NO_EXIST               = 17000;    /*  No entrance guards exist */
		public static final int	NETDEV_E_PACS_PERSON_EXIST                  = 17001;    /*  Access guards already exist */
		public static final int	NETDEV_E_PACS_PERSON_CARD_EXIST             = 17002;    /*  Access card already exists */
		public static final int	NETDEV_E_PACS_PERSON_CARD_NO_EXIST          = 17003;    /*  No access card exists*/
		public static final int	NETDEV_E_PACS_PERSON_CARD_REACH_LIMIT       = 17004;    /*  The number of access cards has reached the upper limit. */
		public static final int	NETDEV_E_PACS_ACCESS_RECORD_NO_EXIST        = 17005;    /*  Personnel access records do not exist*/
		public static final int	NETDEV_E_PACS_CHL_NO_EXIST                  = 17006;    /*  Access control channel does not exist*/
		public static final int	NETDEV_E_PACS_PRMISS_ID_EXIST               = 17007;    /*   Personnel with access control authority do not exist*/
		public static final int	NETDEV_E_PACS_PERSON_DEPT_ID_NO_EXIST       = 17008;    /* ID Personnel Departmental ID of Access Control Personnel does not exist*/
		public static final int	NETDEV_E_PACS_PERSON_RECORD_ID_NO_EXIST     = 17009;    /* ID Personnel access record ID does not exist*/
		public static final int	NETDEV_E_PACS_DEPT_ID_PREMISSIONED          = 17010;    /*   Departmental authority already exists*/
		public static final int	NETDEV_E_PACS_PERMISSION_EXIT_PERSON        = 17011;    /*  The permission group has Person and cannot be deleted. */
		public static final int	NETDEV_E_PACS_BLACKLIST_PERSON_EXIST        = 17012;    /*  Existing blacklist Persons . */
		public static final int	NETDEV_E_PACS_BLACKLIST_NOT_ADD             = 17013;    /*  Blacklist visitors cannot be added. */
		public static final int	NETDEV_E_PACS_MAX                           = 17999;     /* PACS Maximum Error Code of PACS Module */
	}

	/**
	 * @enum tagNETDEVACSPersonCommondType
	 * @brief ()
	 * @attention
	 */
	public static class NETDEV_ACS_PERSON_COMMOND_TYPE_E extends Structure {
		public static final int NETDEV_ACS_PERSON_COMMOND_TYPE_GET            = 0;                
		public static final int NETDEV_ACS_PERSON_COMMOND_TYPE_MOD            = 1;                

		public static final int NETDEV_ACS_PERSON_COMMOND_TYPE_INVALID        = 0xFF;             
	}

	/**
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_USER_BASE_PERMISSION_E extends Structure {
		public static final int NETDEV_USER_BASE_PER_CONFIG           = (0x1 << 0);           
		public static final int NETDEV_USER_BASE_PER_UPGRADE          = (0x1 << 1);           
		public static final int NETDEV_USER_BASE_PER_LOG              = (0x1 << 2);           
		public static final int NETDEV_USER_BASE_PER_REBOOT           = (0x1 << 3);           
	}

	/**
	 * @brief 
	 * @attention  3
	 */
	public static class NETDEV_CHN_PERMISSION_TYPE_E extends Structure {
		public static final int NETDEV_CHN_PERMISSION_LIVE                  = (0x1 << 0);                 
		public static final int NETDEV_CHN_PERMISSION_PTZ                   = (0x1 << 1);                 
		public static final int NETDEV_CHN_PERMISSION_PLAYBACK              = (0x1 << 2);                 
		public static final int NETDEV_CHN_PERMISSION_MANU_RECORD           = (0x1 << 3);                 
		public static final int NETDEV_CHN_PERMISSION_LOCAL_BACK            = (0x1 << 4);                 

		public static final int NETDEV_CHN_PERMISSION_INVALID               = 0XFFFFFFFF;        
	}

	/**
	 * @brief ,
	 * @attention 
	 */
	public static class NETDEV_USER_LEVEL_E extends Structure {
		public static final int NETDEV_USER_LEVEL_ADMINISTRATOR  = 0;           
		public static final int NETDEV_USER_LEVEL_OPERATOR       = 1;           
		public static final int NETDEV_USER_LEVEL_USER           = 2;           
		public static final int NETDEV_USER_LEVEL_Default        = 3;           
		public static final int NETDEV_USER_LEVEL_PUBLISH        = 4;           
	}

	/**
	 * @brief  Time Zone
	 * @attention  None
	 */
	public static class NETDEV_TIME_ZONE_E extends Structure {
		public static final int	NETDEV_TIME_ZONE_W1200 = 0;              /* W12 */
		public static final int	NETDEV_TIME_ZONE_W1100 = 1;              /* W11 */
		public static final int	NETDEV_TIME_ZONE_W1000 = 2;              /* W10 */
		public static final int	NETDEV_TIME_ZONE_W0900 = 3;              /* W9 */
		public static final int	NETDEV_TIME_ZONE_W0800 = 4;              /* W8 */
		public static final int	NETDEV_TIME_ZONE_W0700 = 5;              /* W7 */
		public static final int	NETDEV_TIME_ZONE_W0600 = 6;              /* W6 */
		public static final int	NETDEV_TIME_ZONE_W0500 = 7;              /* W5 */
		public static final int	NETDEV_TIME_ZONE_W0430 = 8;              /* W4:30 */
		public static final int	NETDEV_TIME_ZONE_W0400 = 9;              /* W4 */
		public static final int	NETDEV_TIME_ZONE_W0330 = 10;             /* W3:30 */
		public static final int	NETDEV_TIME_ZONE_W0300 = 11;             /* W3 */
		public static final int	NETDEV_TIME_ZONE_W0200 = 12;             /* W2 */
		public static final int	NETDEV_TIME_ZONE_W0100 = 13;             /* W1 */
		public static final int	NETDEV_TIME_ZONE_0000  = 14;             /* W0 */
		public static final int	NETDEV_TIME_ZONE_E0100 = 15;             /* E1 */
		public static final int	NETDEV_TIME_ZONE_E0200 = 16;             /* E2 */
		public static final int	NETDEV_TIME_ZONE_E0300 = 17;             /* E3 */
		public static final int	NETDEV_TIME_ZONE_E0330 = 18;             /* E3:30 */
		public static final int	NETDEV_TIME_ZONE_E0400 = 19;             /* E4 */
		public static final int	NETDEV_TIME_ZONE_E0430 = 20;             /* E4:30 */
		public static final int	NETDEV_TIME_ZONE_E0500 = 21;             /* E5 */
		public static final int	NETDEV_TIME_ZONE_E0530 = 22;             /* E5:30 */
		public static final int	NETDEV_TIME_ZONE_E0545 = 23;             /* E5:45 */
		public static final int	NETDEV_TIME_ZONE_E0600 = 24;             /* E6 */
		public static final int	NETDEV_TIME_ZONE_E0630 = 25;             /* E6:30 */
		public static final int	NETDEV_TIME_ZONE_E0700 = 26;             /* E7 */
		public static final int	NETDEV_TIME_ZONE_E0800 = 27;             /* E8 */
		public static final int	NETDEV_TIME_ZONE_E0900 = 28;             /* E9 */
		public static final int	NETDEV_TIME_ZONE_E0930 = 29;             /* E9:30 */
		public static final int	NETDEV_TIME_ZONE_E1000 = 30;             /* E10 */
		public static final int	NETDEV_TIME_ZONE_E1100 = 31;             /* E11 */
		public static final int	NETDEV_TIME_ZONE_E1200 = 32;             /* E12 */
		public static final int	NETDEV_TIME_ZONE_E1300 = 33;             /* E13 */
		public static final int	NETDEV_TIME_ZONE_W0930 = 34;             /* W9:30 */
		public static final int	NETDEV_TIME_ZONE_E0830 = 35;             /* E8:30 */
		public static final int	NETDEV_TIME_ZONE_E0845 = 36;             /* E8:45 */
		public static final int	NETDEV_TIME_ZONE_E1030 = 37;             /* E10:30 */
		public static final int	NETDEV_TIME_ZONE_E1245 = 38;             /* E12:45 */
		public static final int	NETDEV_TIME_ZONE_E1400 = 39;             /* E14 */

		public static final int	NETDEV_TIME_ZONE_INVALID = 0xFF;          /* Invalid value */
	}

	/**
	 * @brief Week emnu
	 * @attention 
	 */
	public static class NETDEV_DAY_IN_WEEK_E extends Structure
	{
		public static final int NETDEV_WEEK_SUNDAY                  = 0;                  /*   Sunday */
		public static final int NETDEV_WEEK_MONDAY                  = 1;                  /*   Monday */
		public static final int NETDEV_WEEK_TUESDAY                 = 2;                  /*   Tuesday */
		public static final int NETDEV_WEEK_WEDNESDAY               = 3;                  /*   Wednesday */
		public static final int NETDEV_WEEK_THURSDAY                = 4;                  /*   Thursday */
		public static final int NETDEV_WEEK_FRIDAY                  = 5;                  /*   Friday */
		public static final int NETDEV_WEEK_SATURDAY                = 6;                 /*   Saturday */
		public static final int NETDEV_WEEK_INVALID               = 0xff;                  /*  Invalid value */
	}

	public static class NETDEV_DST_OFFSET_TIME extends Structure {
		public static final int NETDEV_DST_OFFSET_TIME_30MIN                 = 30;         /* 30  30Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_60MIN                 = 60;          /* 60  60Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_90MIN                 = 90;          /* 90  90Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_120MIN                = 120;         /* 120  120Minutes */
		public static final int NETDEV_DST_OFFSET_TIME_INVALID               = 0xff;         /*  Invalid value */
	}
	/**
	 * @brief   Disk work status
	 * @attention  None
	 */
	public  class NETDEV_DISK_WORK_STATUS_E extends Structure {
		public static final int NETDEV_DISK_WORK_STATUS_EMPTY       = 0;            /*  Empty */
		public static final int NETDEV_DISK_WORK_STATUS_UNFORMAT    = 1;            /*  Unformat */
		public static final int NETDEV_DISK_WORK_STATUS_FORMATING   = 2;            /*  Formating */
		public static final int NETDEV_DISK_WORK_STATUS_RUNNING     = 3;            /*  Running */
		public static final int NETDEV_DISK_WORK_STATUS_HIBERNATE   = 4;            /*  Hibernate */
		public static final int NETDEV_DISK_WORK_STATUS_ABNORMAL    = 5;            /*  Abnormal */
		public static final int NETDEV_DISK_WORK_STATUS_UNKNOWN     = 6;            /*  Unknown */

		public int NETDEV_DISK_WORK_STATUS_INVALID					= 0xff;            /*  Unknown */
	}

	/**
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_PROTOCOL_TYPE_E extends Structure {
		public static final int NETDEV_PROTOCOL_TYPE_HTTP  = 0;
		public static final int NETDEV_PROTOCOL_TYPE_HTTPS = 1;
		public static final int NETDEV_PROTOCOL_TYPE_RTSP  = 2;
	}

	/**
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_TRAFFIC_STATISTICS_TYPE_E extends Structure {
		public static final int NETDEV_TRAFFIC_STATISTICS_TYPE_IN   = 0;        /* ： Statistics type : Enter */
		public static final int NETDEV_TRAFFIC_STATISTICS_TYPE_OUT  = 1;        /* ： Statistics type : Exit */
		public static final int NETDEV_TRAFFIC_STATISTICS_TYPE_ALL  = 2;        /* ： Statistics type : All */
		public int NETDEV_TRAFFIC_STATISTICS_TYPE_BUTT				= 3;
	}

	/**
	 *@enum tagNETDEVTrafficStatisticsFormType
	 *@brief   
	 *@attention  None
	 */
	public static class NETDEV_TRAFFIC_STATIC_FORM_TYPE_E extends Structure {
		public static final int NETDEV_TRAFFIC_STAT_FORM_BY_MINUTE = 0;                  
		public static final int NETDEV_TRAFFIC_STAT_FORM_BY_HOUR = 1;                    
		public static final int NETDEV_TRAFFIC_STAT_FORM_BY_DAY = 2;                     
		public static final int NETDEV_TRAFFIC_STAT_FORM_BY_MONTH = 3;                   
		public static final int NETDEV_TRAFFIC_STAT_FORM_BY_BUTT  = 4;
	}

	/**
	 * @enum tagNETDEVTimeTemplateType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_TIME_TEMPLATE_TYPE_E extends Structure {
		public static final int NETDEV_TIMETEMPLATE_TYPE_RECORD     = 0;                
		public static final int NETDEV_TIMETEMPLATE_TYPE_ALARM      = 1;                
		/* 23CSweb 2 3 */
		public static final int NETDEV_TIMETEMPLATE_TYPE_SEQUENCE   = 4;                
		public static final int NETDEV_TIMETEMPLATE_TYPE_ACS        = 5;                
		public static final int NETDEV_TIMETEMPLATE_TYPE_INVALID    = 0xFF;             
	}

	/**
	 * @brief  Record Type
	 * @attention 
	 */
	public static class NETDEV_RECORD_TYPE_E extends Structure {
		public static final int NETDEV_RECORD_TYPE_MANUAL  = 0;
		public static final int NETDEV_RECORD_TYPE_NORMAL = 1;
	}

	
	public static class NETDEV_UPGRADE_TYPE_E extends Structure {
		public static final int NETDEV_UPGRADE_TYPE_CLOUD    = 1;               
		public static final int NETDEV_UPGRADE_TYPE_UDISK    = 2;               /* U */
		public static final int NETDEV_UPGRADE_TYPE_LOCAL    = 3;               
		public static final int NETDEV_UPGRADE_TYPE_BUTT					 = 4;               
	}

	
	public static class  NETDEV_UPGRADE_STATUS_E extends Structure {
		public static final int	NETDEV_UPGRADE_STATUS_INITING        = 0;       
		public static final int	NETDEV_UPGRADE_STATUS_QUERYING       = 1;       
		public static final int	NETDEV_UPGRADE_STATUS_DOWNLOADING    = 2;       
		public static final int	NETDEV_UPGRADE_STATUS_TRANSMITTING   = 3;       
		public static final int	NETDEV_UPGRADE_STATUS_UPGRATING      = 4;       
		public static final int	NETDEV_UPGRADE_STATUS_UPGRATEERROR   = 5;       
		public static final int	NETDEV_UPGRADE_STATUS_NEWEST         = 6;       
		public static final int	NETDEV_UPGRADE_STATUS_HAVEHIGHTER    = 7;       
		public static final int	NETDEV_UPGRADE_STATUS_UPGRADEOVER    = 8;       
		public static final int	NETDEV_UPGRADE_STATUS_GETSTATUSFAIL  = 9;       
		public static final int	NETDEV_UPGRADE_STATUS_NOTMATCH       = 10;      
		public static final int	NETDEV_UPGRADE_STATUS_NOTMUTIPROCESS = 11;      
		public static final int	NETDEV_UPGRADE_STATUS_UPGRADETIMEOUT = 12;      
		public static final int	NETDEV_UPGRADE_STATUS_BUTT = 0xff;
	};
	
	/**
	 * @enum tagNETDEVObjectRecordType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_OBJECT_RECORD_TYPE_E extends Structure {
		public int	NETDEV_OBJECT_RECORD_TYPE_CROSSLINE_DETECTION     = 0;                
		public int	NETDEV_OBJECT_RECORD_TYPE_INTRUSION_DETECTION     = 1;                
		public int	NETDEV_OBJECT_RECORD_TYPE_ENTER_ZONE              = 2;                
		public int	NETDEV_OBJECT_RECORD_TYPE_LEAVE_ZONE              = 3;                
		public int	NETDEV_OBJECT_RECORD_TYPE_INVALID                 = 0xffff;           
	}
	
	/**
	 * @enum tagNETDEVObjectType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_OBJECT_TYPE_E extends Structure {
		public int	NETDEV_OBJECT_TYPE_FACE        = 0;                
		public int	NETDEV_OBJECT_TYPE_PERSON      = 1;                
		public int	NETDEV_OBJECT_TYPE_NON_MOTOR   = 2;                
		public int	NETDEV_OBJECT_TYPE_MOTOR       = 3;                
		public int	NETDEV_OBJECT_TYPE_UNKNOWN     = 255;              /* / */
		public int  NETDEV_OBJECT_TYPE_INVALID     = 0xffff;           
	}
	
	
	/**
	 * @enum tagNETDEVEmotionFlag
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_EMOTION_FLAG_E extends Structure {
		public int      NETDEV_EMOTION_FLAG_UNKNOW                        = 0;                 
		public int      NETDEV_EMOTION_FLAG_ANGER                         = 1;                 
		public int	    NETDEV_EMOTION_FLAG_CALM                          = 2;                 
		public int	    NETDEV_EMOTION_FLAG_CONFUSED                      = 3;                 
		public int	    NETDEV_EMOTION_FLAG_ABHORRENT                     = 4;                 
		public int	    NETDEV_EMOTION_FLAG_HAPPY                         = 5;                 
		public int	    NETDEV_EMOTION_FLAG_SAD                           = 6;                 
		public int	    NETDEV_EMOTION_FLAG_AFRAID                        = 7;                 
		public int      NETDEV_EMOTION_FLAG_AMAZED                        = 8;                 
		public int      NETDEV_EMOTION_FLAG_SQUINT                        = 9;                 
		public int      NETDEV_EMOTION_FLAG_SCREAM                        = 10;                
		public int      NETDEV_EMOTION_FLAG_OTHER                         = 11;                
		public int      NETDEV_EMOTION_FLAG_INVALID                       = 0xFF;              
	}
	
	/**
	 * @enum tagNETDEVSmileFlag
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_SMILE_FLAG_E extends Structure {
		public int          NETDEV_SMILE_FLAG_UNKNOW                        = 0;                
		public int  	    NETDEV_SMILE_FLAG_NO                            = 1;                
		public int  	    NETDEV_SMILE_FLAG_YES                           = 2;                
		public int  	    NETDEV_SMILE_FLAG_INVALID                       = 0xFF;             
	}
	
	/**
	 * @enum tagNETDEVSkinColorType
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_SKINCOLOR_TYPE_E extends Structure
	{
		public int NETDEV_SKINCOLOR_TYPE_UNKNOW                           = 0;                    
		public int NETDEV_SKINCOLOR_TYPE_WHITE                            = 2011;                 
		public int NETDEV_SKINCOLOR_TYPE_BLACK                            = 2012;                 
		public int NETDEV_SKINCOLOR_TYPE_YELLOW                           = 2013;                 
		public int NETDEV_SKINCOLOR_TYPE_BROWN                            = 2014;                 
		public int NETDEV_SKINCOLOR_TYPE_INVALID                          = 0xFF;                 
	}
	
	/**
	 * @enum tagNETDEVBeardFlag
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_BEARD_FLAG_E extends Structure
	{
		public int      NETDEV_BEARD_FLAG_UNKNOW                        = 0;                 
		public int	    NETDEV_BEARD_FLAG_UNEXIST                       = 1;                 
		public int      NETDEV_BEARD_FLAG_EXIST                         = 2;                 
		public int      NETDEV_BEARD_FLAG_INVALID                       = 0xFF;              
	}
	
	/**
	 * @enum tagNETDEVRuleType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_RULE_TYPE_E extends Structure
	{
		public int    NETDEV_RULE_TYPE_INTRUSION_DETECTION                    = 0;       
		public int    NETDEV_RULE_TYPE_CROSSLINE_DETECTION                    = 1;       
		public int    NETDEV_RULE_TYPE_LEAVE_ZONE                             = 2;       
		public int    NETDEV_RULE_TYPE_ENTER_ZONE                             = 3;       
		public int    NETDEV_RULE_TYPE_INVALID                                = 0xff;    
	}
	
	/**
	 * @enum tagNETDEVRuleTriggerType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_RULE_TRIGGER_TYPE_E extends Structure
	{
		public int    NETDEV_RULE_TRIGGER_TYPE_NO_TRIGGER                          = 0;       
		public int    NETDEV_RULE_TRIGGER_TYPE_DUPLEX                              = 1;       
		public int    NETDEV_RULE_TRIGGER_TYPE_CLOCKWISE                           = 2;       
		public int    NETDEV_RULE_TRIGGER_TYPE_ANTIC_CLOCKWISE                     = 3;       
		public int    NETDEV_RULE_TRIGGER_TYPE_ACCESS                              = 4;       
		public int    NETDEV_RULE_TRIGGER_TYPE_LEAVE                               = 5;       
		public int    NETDEV_RULE_TRIGGER_TYPE_INVALID                             = 0xff;    
	}
	
	/**
	 * @enum tagNETDEVPersonMaskFlag
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_PERSON_MASK_FLAG_E extends Structure
	{
		public int      NETDEV_PERSON_MASK_FLAG_NOT_WEAR                      = 1;                 
		public int	    NETDEV_PERSON_MASK_FLAG_WEAR                          = 2;                 
		public int	    NETDEV_PERSON_MASK_FLAG_UNKNOW                        = 255;               
		public int	    NETDEV_PERSON_MASK_FLAG_INVALID                       = 0xFFFF;            
	}
	
	/**
	 * @enum tagNETDEVCoatTexture
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CLOTHES_TEXTURE_E extends Structure
	{
		public int      NETDEV_CLOTHES_TEXTURE_NO_PATTERNS                  = 1;         
		public int	    NETDEV_CLOTHES_TEXTURE_EXIST_PATTERNS               = 2;         
		public int	    NETDEV_CLOTHES_TEXTURE_UNKNOW                       = 255;       
		public int	    NETDEV_CLOTHES_TEXTURE_INVALIDP                     = 0xFFFF;    
	}
	
	/**
	 * @enum tagNETDEVMoveDirection
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_MOVE_DIRECTION_E extends Structure
	{
		public int      NETDEV_MOVE_DIRECTION_STATIC                        = 1;                   
		public int	    NETDEV_MOVE_DIRECTION_UP                            = 2;                   
		public int	    NETDEV_MOVE_DIRECTION_DOWN                          = 3;                   
		public int	    NETDEV_MOVE_DIRECTION_LEFT                          = 4;                   
		public int	    NETDEV_MOVE_DIRECTION_RIGHT                         = 5;                   
		public int	    NETDEV_MOVE_DIRECTION_LEFTUP                        = 6;                   
		public int	    NETDEV_MOVE_DIRECTION_LEFTDOWN                      = 7;                   
		public int	    NETDEV_MOVE_DIRECTION_RIGHTUP                       = 8;                   
		public int	    NETDEV_MOVE_DIRECTION_RIGHTDOWN                     = 9;                   
		public int	    NETDEV_MOVE_DIRECTION_UNKNOW                        = 255;                 
		public int	    NETDEV_MOVE_DIRECTION_INVALID                       = 0xFFFF;              
	}

	/**
	 * @struct tagNETDEVUpgradeDevice
	 * @brief   Basic device information Structure definition
	 * @attention  None
	 */
	public static class  NETDEV_UPGRADE_DEVICE_S extends Structure {
		public int dwUpgradeType;                    				/*  #NETDEV_UPGRADE_TYPE_E */
		public int dwSize;                           				/*  ,0NVR */
		public int[] adwChannelID = new int[NETDEV_CHANNEL_MAX]; 	
		public byte[]  szPath = new byte[NETDEV_PATH_LEN];          
		public byte[]  byRes = new byte[256];                       /*   Reserved */
	};

	/**
	 * @struct tagNETDEVDeviceBaseInfo
	 * @brief 
	 * @attention 
	 */
	public static class  NETDEV_DEVICE_BASE_INFO_S extends Structure {
		public int dwChlID;                                              /*   Video input channel ID */
		public int dwDeviceType;                                         /*   Device Type */
		public int dwDevCode;                                            /*   Device code */
		public int dwCurrentLang;                                        /*  #NETDEV_LANG_TYPE_E Current language NETDEV_LANG_TYPE_E*/
		public NETDEV_DATE_INFO_S stBuildDate;                             /*   Release time */
		public byte[] szSerialNum = new byte[NETDEV_LEN_32];                            /*   Device serial number */
		public byte[] szMacAddress = new byte[NETDEV_LEN_64];                           /* IPv4Mac  MAC address of IPv4 */
		public byte[] szDevName = new byte[NETDEV_CODE_STR_MAX_LEN];                    /*   Device name */
		public byte[] szDevModel = new byte[NETDEV_CODE_STR_MAX_LEN];                   /*   Device model */
		public byte[] szVIIDVersion = new byte[NETDEV_CODE_STR_MAX_LEN];                /*   VIIDVersion version */
		public byte[] szSoftwareVersion = new byte[NETDEV_CODE_STR_MAX_LEN];            /*  Internal software version */
		public byte[] szFirmwareVersion = new byte[NETDEV_CODE_STR_MAX_LEN];            /*   Software version */
		public byte[] szHardewareID = new byte[NETDEV_CODE_STR_MAX_LEN];                /*   Hardware ID */
		public byte[] szUbootVersion = new byte[NETDEV_CODE_STR_MAX_LEN];               /* UBOOT  UBOOT version */
		public byte[] szManufacturer = new byte[NETDEV_LEN_64];                         /* [1,64]  Manufacturer */
		public NETDEV_CLIENT_VERSION_INFO_LIST_S stClientVersionsInfo;     /* ：  Client Versions Infos */
		public byte[] szProtoName = new byte[NETDEV_LEN_256];                           

		public byte[] byRes = new byte[216];                                        /*  Reserved */
	};

	/**
	 * @struct tagstNETDEVDateInfo
	 * @brief 
	 * @attention
	 */
	public static class  NETDEV_DATE_INFO_S extends Structure {
		public int     dwYear;                               
		public int     dwMonth;                              
		public int     dwDay;                                
		public int     dwHour;                               
		public int     dwMinute;                             
		public byte[] byRes = new byte[32];                            
	};

	/**
	 * @struct tagstNETDEVClientVersionsInfoList
	 * @brief 
	 * @attention
	 */
	public static class  NETDEV_CLIENT_VERSION_INFO_LIST_S extends Structure {
		public int    		udwNum;                                          
		public Pointer    	pstClientVersionsInfo;                           /*  # */

		public byte[]  		byRes = new byte[32];                                       
	};

	/**
	 * @struct tagstNETDEVClientVersionsInfo
	 * @brief 
	 * @attention
	 */
	public static class  NETDEV_CLIENT_VERSION_INFO_S extends Structure {
		public int     udwType;                                            /*  # NETDEV_CLIENT_TYPE_E */
		public byte[]  szVersion = new byte[NETDEV_LEN_256];                          /*  [0, 255] */

		public byte[]  byRes = new byte[32];                                          
	};

	/**
	 * @struct tagNETDEVUpgradeStatus
	 * @brief   Basic device information Structure definition
	 * @attention  None
	 */
	public static class  NETDEV_UPGRADE_STATUS_S extends Structure {
		public int dwStatus;             /* ,#NETDEV_UPGRADE_STATUS_E */
		public int dwPercent;            
		public int dwChannelID;          
		byte[] byRes = new byte[256];           
	};

	public static class NETDEV_ALARM_SNAPSHOT_TYPE_E extends Structure {
		public static final int	NETDEV_ALARM_SNAPSHOT_MOTION_DETECT                     = 0;            
		public static final int	NETDEV_ALARM_SNAPSHOT_VIDEO_LOST                        = 1;            
		public static final int	NETDEV_ALARM_SNAPSHOT_AUDIO_DETECTION                   = 2;            
		public static final int	NETDEV_ALARM_SNAPSHOT_INPUT_SWITCH                      = 3;            
		public static final int	NETDEV_ALARM_SNAPSHOT_IPC_OFFLINE                       = 4;            /* IPC */
		public static final int	NETDEV_ALARM_SNAPSHOT_TAMPER_DETECT                     = 5;            

		public static final int	NETDEV_ALARM_SNAPSHOT_CROSS_LINE                        = 6;            
		public static final int	NETDEV_ALARM_SNAPSHOT_INTROSION_ZONE                    = 7;            
		public static final int	NETDEV_ALARM_SNAPSHOT_FACE_DETECT                       = 8;            
		public static final int	NETDEV_ALARM_SNAPSHOT_SCENCECHANGE                      = 9;            
		public static final int	NETDEV_ALARM_SNAPSHOT_OUT_FOCUS                         = 10;           
		public static final int	NETDEV_ALARM_SNAPSHOT_FACE_MATCH                        = 11;           
		public static final int	NETDEV_ALARM_SNAPSHOT_FACE_NOT_MATCH                    = 12;           
		public static final int	NETDEV_ALARM_SNAPSHOT_GATHER                            = 13;           
		public static final int	NETDEV_ALARM_SNAPSHOT_REMAIN_ARTICLE                    = 14;           
		public static final int	NETDEV_ALARM_SNAPSHOT_SMART_TRACK                       = 15;           
		public static final int	NETDEV_ALARM_SNAPSHOT_LOITERING_DETECTOR                = 16;           
		public static final int	NETDEV_ALARM_SNAPSHOT_VEHICLE_MATCH                     = 17;           
		public static final int	NETDEV_ALARM_SNAPSHOT_VEHICLE_NOT_MATCH                 = 18;           
		public static final int	NETDEV_ALARM_SNAPSHOT_ENTER_AREA                        = 19;           
		public static final int	NETDEV_ALARM_SNAPSHOT_LEAVE_AREA                        = 20;           
		public static final int	NETDEV_ALARM_SNAPSHOT_ARTICLE_MOVE                      = 21;           
		public static final int	NETDEV_ALARM_SNAPSHOT_DURESS                            = 22;           
		public static final int	NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY                   = 23;           
		public static final int	NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY_RECOVER           = 24;           
		public static final int	NETDEV_ALARM_SNAPSHOT_BYPASS_OPERATION                  = 25;           
		public static final int	NETDEV_ALARM_SNAPSHOT_CF_BJ_EMBNAM_ZONE                 = 26;           /* . */
		public static final int	NETDEV_ALARM_SNAPSHOT_CONFLAGRATION                     = 27;           
		public static final int NETDEV_ALARM_SNAPSHOT_HUMAN_SHAPE_DETECT                = 28;           

		public static final int	NETDEV_ALARM_SNAPSHOT_INVALID                        = 0xFFFF;        /*   Invalid value */
	}

	/**
	 * @brief (2018-07-26 NVR)   Channel device type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_CHANNEL_CAMERA_TYPE_E extends Structure {
		public static final int NETDEV_CHL_CAMERA_TYPE_FIXED        = 0;        /*   fixed camera */
		public static final int NETDEV_CHL_CAMERA_TYPE_PTZ          = 1;        /*   PTZ camera */
		public static final int NETDEV_CHL_CAMERA_TYPE_FISH_EYE     = 2;        /* +fish-eye camera */
		public static final int NETDEV_CHL_CAMERA_TYPE_WIDE_ANGLE   = 3;        /*   wide-Angle camera*/

		public static final int NETDEV_CHL_CAMERA_TYPE_INVALID      = 0xff;
	}

	/**
	 * @enum tagNETDEVCloudDeviceType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CLOUD_DEVICE_TYPE extends Structure {
		public static final int NETDEV_CLOUD_DEV_TYPE_IPC                 = 0;          /* IPC */
		public static final int NETDEV_CLOUD_DEV_TYPE_NVR                 = 1;          /* NVR */
		public static final int NETDEV_CLOUD_DEV_TYPE_VMS                 = 2;          
		public static final int NETDEV_CLOUD_DEV_TYPE_DVR                 = 3;          /* DVR */
		public static final int NETDEV_CLOUD_DEV_TYPE_EC                  = 4;          
		public static final int NETDEV_CLOUD_DEV_TYPE_DC                  = 5;          
		public static final int NETDEV_CLOUD_DEV_TYPE_INVALID            = 0xff;         
	}

	/**
	 *@brief 
	 *@attention 
	 */
	public static class NETDEV_DISTRIBUTE_CLOUD_SRV_E extends Structure {
		public static final int NETDEV_DISTRIBUTE_CLOUD_NONE      = 0;            
		public static final int NETDEV_DISTRIBUTE_CLOUD_KS        = 1;            
		public static final int NETDEV_DISTRIBUTE_CLOUD_UN        = 2;            
		public static final int NETDEV_DISTRIBUTE_CLOUD_TEN       = 3;            
	}

	/**
	 *@enum tagNETDEVCloudStorageType
	 *@brief 
	 *@attention 
	 */
	public static class NETDEV_CLOUD_STORAGE_TYPE_E extends Structure {
		public static final int NETDEV_CLOUD_STORAGE_TYPE_PIC                 = 1;            
		public static final int NETDEV_CLOUD_STORAGE_TYPE_VIDEO               = 2;            
		public static final int NETDEV_CLOUD_STORAGE_TYPE_PIC_AND_VIDEO       = 3;            
		public static final int NETDEV_CLOUD_STORAGE_TYPE_INVALID 						 = 4;
	}

	/**
	 * @enum tagPictureFluency
	 * @brief  
	 * @attention 
	 */
	public static class NETDEV_MEDIA_MODE_E extends Structure {
		public static final int NETDEV_MEDIA_MODE_LOCAL             = 0;                        
		public static final int NETDEV_MEDIA_MODE_REALPLAY          = 1;                        
		public static final int NETDEV_MEDIA_MODE_PLAYBACK          = 2;                        
		public static final int NETDEV_MEDIA_MODE_DOWNLOAD          = 3;                        
		public static final int NETDEV_MEDIA_MODE_VOICECOM          = 4;                        
		public static final int NETDEV_MEDIA_MODE_VOICESRV          = 5;                        
		public static final int NETDEV_MEDIA_MODE_M3U8PLAY          = 6;                        /* M3u8 */

		public static final int NETDEV_MEDIA_MODE_UNKNOWN           = 0xff;                      
	}

	/**
	 * @brief  Video Position
	 * @attention  None
	 */
	public class NETDEV_VIDEO_POSITION_E extends Structure {
		public static final int NETDEV_POSITION_LOCAL       = 1;            
		public static final int NETDEV_POSITION_CHANNEL     = 2;            
		public static final int NETDEV_POSITION_INVALID		= 0xff;
	}

	/**
	 * @brief  Video Status
	 * @attention  None
	 */
	public static class NETDEV_VIDEO_STATUS_E extends Structure {
		public static final int NETDEV_VIDEO_NONE       = 0;        /*  No video */
		public static final int NETDEV_VIDEO_EVENT      = 1;        /*  Event video */
		public static final int NETDEV_VIDEO_NORMAL     = 2;        /*  Normal video */
		public static final int NETDEV_VIDEO_INVALID	= 0xff;
	}


	
	public static class NETDEV_ORG_RESPONSE_STAUTE_E extends Structure {
		public static final int NETDEV_ORG_RESPONSE_SUCCESS           = 0;            
		public static final int NETDEV_ORG_RESPONSE_FAIL              = 1;             
	}


	/**
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_TRANS_PROTOCOL_E extends Structure {
		public static final int NETDEV_TRANS_PROTOCOL_TCP = 0;              /* TCP */
		public static final int NETDEV_TRANS_PROTOCOL_UDP = 1;             /* UDP */
	}

	public static class NETDEV_DEVICE_STATUS_E extends Structure {
		public static final int NETDEV_DEV_STATUS_OFFLINE                   = 0;                
		public static final int NETDEV_DEV_STATUS_ONLINE                    = 1;                
		public static final int NETDEV_DEV_STATUS_CONNECTING                = 2;                
		public static final int NETDEV_DEV_STATUS_PWD_ERROR                 = 3;                
		public static final int NETDEV_DEV_STATUS_NOT_SUPPORT               = 4;                
		public static final int NETDEV_DEV_STATUS_TIMEOUT                   = 5;                
		public static final int NETDEV_DEV_STATUS_WEAK_PWD_ERROR            = 6;                
		public static final int NETDEV_DEV_STATUS_NO_DYNAMIC_PWD            = 7;                

		public static final int NETDEV_DEV_STATUS_INVALID                   = 0XFF;              
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_DEVICE_SUB_TYPE_E extends Structure {
		public static final int	NETDEV_DTYPE_SUB_NVR                    = 0;                /* NVR */
		public static final int	NETDEV_DTYPE_SUB_IPC                    = 1;                /* IPC */
		public static final int	NETDEV_DTYPE_SUB_DC_INNER               = 2;                /* DC */
		public static final int	NETDEV_DTYPE_SUB_DC_EXT                 = 3;                /* DC */
		public static final int	NETDEV_DTYPE_SUB_EC                     = 4;                /* EC */
		public static final int	NETDEV_DTYPE_SUB_VMS                    = 5;                
		public static final int	NETDEV_DTYPE_SUB_DA                     = 6;                
		public static final int	NETDEV_DTYPE_SUB_ADU                    = 7;                /* ADU */
		public static final int	NETDEV_DTYPE_SUB_FISHEYE_IPC            = 8;                
		public static final int	NETDEV_DTYPE_SUB_DECARD                 = 9;                
		public static final int	NETDEV_DTYPE_SUB_FACE_IPC               = 10;               
		public static final int	NETDEV_DTYPE_SUB_ALARMHOST              = 11;               
		public static final int	NETDEV_DTYPE_SUB_ACS                    = 12;               
		public static final int	NETDEV_DTYPE_SUB_FG                     = 13;               
		public static final int	NETDEV_DTYPE_SUB_FACE_ACS               = 14;               
		public static final int	NETDEV_DTYPE_SUB_PRIVATE_GENERAL_ACS    = 15;               
		public static final int	NETDEV_DTYPE_SUB_PRIVATE_ALARMHOST      = 16;               
		public static final int	NETDEV_DTYPE_SUB_LOCK_WIFI              = 17;               /* WIFI*/
		public static final int NETDEV_DTYPE_SUB_LOCK_NBIoT             = 18;               /* NBIoT */
		public static final int NETDEV_DTYPE_SUB_ID_RECOGNIZE           = 19;               

		public static final int	NETDEV_DTYPE_SUB_UNKNOW                 = 0xFF;              
	}

	public static class NETDEV_ACCESS_PROTOCOL_E extends Structure {
		public static final int NETDEV_ACCESS_PROTOCOL_ONVIF                = 1;                /* onvif */
		public static final int NETDEV_ACCESS_PROTOCOL_PRIVATER             = 2;                
		public static final int NETDEV_ACCESS_PROTOCOL_GB                   = 3;                
		public static final int NETDEV_ACCESS_PROTOCOL_RTSP					= 4;				/* RTSP */
		public static final int NETDEV_ACCESS_PROTOCOL_BAOXIN               = 5;                
		public static final int NETDEV_ACCESS_PROTOCOL_INVALID              = 0xFF;              
	}

	public static class NETDEV_DEVICE_ACCESS_MODE_E extends Structure {
		public static final int NETDEV_DEV_ACCESS_MODE_IP_DOMAIN            = 0;                /* IP */
		public static final int NETDEV_DEV_ACCESS_MODE_P2P                  = 1;                /* P2P */
		public static final int NETDEV_DEV_ACCESS_MODE_UNP                  = 2;                /* UNP */

		public static final int NETDEV_DEV_ACCESS_MODE_INVALID              = 0XFF;              
	}

	/**
	 * @enum tagNETDEVProtocal
	 * @brief     Media transport protocol Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_TRANS_PROTOCAL_E extends Structure {
		public static final int NETDEV_TRANS_PROTOCAL_UDP     = 0;            /* UDP */
		public static final int NETDEV_TRANS_PROTOCAL_TCP     = 1;             /* TCP */
	}

	/**
	 * @brief     start stream mode Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_STREAM_MODE_E extends Structure {
		public static final int NETDEV_STREAM_MODE_ALL      = 0x0000;   /*  +  audio & Video */
		public static final int NETDEV_STREAM_MODE_VIDEO    = 0x8000;    /*  only video */
	}

	
	public static class NETDEV_TRANS_TYPE_E extends Structure {
		public static final int NETDEV_TRANS_TYPE_FORWORD     = 0;                        
		public static final int NETDEV_TRANS_TYPE_STRAIGHT    = 1;                         
	}

	/**
	 * @brief    Enumeration of smart image encoding mode
	 * @attention  None
	 */
	public static class NETDEV_SMART_ENCODE_MODE_E extends Structure {
		public static final int NETDEV_SMART_ENCODE_MODE_OFF      = 0;      /*  Off*/
		public static final int NETDEV_SMART_ENCODE_MODE_BASIC    = 1;      /*  Basic mode*/
		public static final int NETDEV_SMART_ENCODE_MODE_ADVANCED = 2;          				/*  Advanced mode*/
	}

	/**
	 * @brief OSD  Enumeration of OSD font style
	 * @attention  None
	 */
	public static class NETDEV_OSD_FONT_STYLE_E extends Structure {
		public static final int NETDEV_OSD_FONT_STYLE_BACKGROUND    = 0;                  /*  Background*/
		public static final int NETDEV_OSD_FONT_STYLE_STROKE        = 1;                  /*  Stroke*/
		public static final int NETDEV_OSD_FONT_STYLE_HOLLOW        = 2;                  /*  Hollow*/
		public static final int NETDEV_OSD_FONT_STYLE_NORMAL        = 3;                   /*  Normal*/
	}

	/**
	 * @brief OSD  Enumeration of OSD font size
	 * @attention  None
	 */
	public static class NETDEV_OSD_FONT_SIZE_E extends Structure {
		public static final int NETDEV_OSD_FONT_SIZE_LARGE      = 0;                  /*  X-large*/
		public static final int NETDEV_OSD_FONT_SIZE_BIG        = 1;                  /*  Large*/
		public static final int NETDEV_OSD_FONT_SIZE_MEDIUM     = 2;                  /*  Medium*/
		public static final int NETDEV_OSD_FONT_SIZE_SMALL      = 3;                   /*  Small*/
	}

	/**
	 * @brief    Enumeration of date format
	 * @attention  None
	 */
	public static class NETDEV_OSD_DATE_FORMAT_E extends Structure {
		public static final int	NETDEV_OSD_DATE_FORMAT_YYYY_MMDD                = 0;           /* yyyy-MM-dd */
		public static final int	NETDEV_OSD_DATE_FORMAT_MMDD_YYYY                = 1;           /* MM-dd-yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD        = 2;           /* yyyyMMdd yyyy/MM/dd*/
		public static final int	NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY        = 3;           /* MMddyyyy MM/dd/yyyy*/
		public static final int	NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X       = 4;           /*  yyyyMMdd X。 dddd yyyy MM dd*/
		public static final int	NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X      = 5;           /* MMddyyyy X。 dddd MM dd yyyy*/
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY        = 100;         /* dd/MM/yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY        = 101;         /* MM/dd/yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY      = 102;         /* dd MMMM, yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY      = 103;         /* MMMM dd, yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY  = 104;         /* dddd, dd MMMM, yyyy  */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY = 105;        /* dddd, MMMM dd, yyyy */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD        = 106;         /*  yyyy/MM/dd */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD      = 107;         /*  yyyy, MMMM dd */
		public static final int	NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD      = 108;         /*  dddd, yy, MM dd */
	}

	/**
	 * @brief OSD  Enumeration of OSD time format
	 * @attention  None
	 */
	public static class NETDEV_OSD_TIME_FORMAT_E extends Structure {
		public static final int NETDEV_OSD_TIME_FORMAT_HHMMSS         = 0;                  /* HH:mm:ss */
		public static final int NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T     = 1;                  /* hh:mm:ss t.t. */
		public static final int NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT    = 2;                  /* hh:mm:ss tt */
		public static final int NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS    = 3;                  /*  tt hh:mm:ss */
		public static final int NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS    = 4;                  /*  hh:mm:ss  P.M. hh:mm:ss*/
		public static final int NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX    = 5;                  /* HH:mm:ss.xxx */
		public static final int NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT = 6;                   /* hh:mm:ss.xxx tt */

	}

	/**
	 * @brief OSD  Enumeration of OSD align
	 * @attention  None
	 */
	public static class NETDEV_OSD_ALIGN_E extends Structure {
		public static final int NETDEV_OSD_ALIGN_LEFT       = 0;               /*  Left*/
		public static final int NETDEV_OSD_ALIGN_RIGHT      = 1;                /*  Right*/
	}

	/**
	 * @brief OSD  Enumeration of OSD font size
	 * @attention  None
	 */
	public static class NETDEV_OSD_MIN_MARGIN_E extends Structure {
		public static final int NETDEV_OSD_MIN_MARGIN_NONE    = 0;               /*  None*/
		public static final int NETDEV_OSD_MIN_MARGIN_SINGLE  = 1;               /*  One char width*/
		public static final int NETDEV_OSD_MIN_MARGIN_DOUBLE  = 2;                /*  Two char width*/
	}

	/**
	 * @brief    Recording storage type Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_PLAN_STORE_TYPE_E extends Structure {
		public static final int NETDEV_TYPE_STORE_TYPE_ALL                  = 0;            /*   All */

		public static final int NETDEV_EVENT_STORE_TYPE_NORMAL              = 1;            /* ,  All */
		public static final int NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION     = 4;            /*   Motion detection */
		public static final int NETDEV_EVENT_STORE_TYPE_DIGITALINPUT        = 5;            /*   Digital input */
		public static final int NETDEV_EVENT_STORE_TYPE_VIDEOLOSS           = 7;            /*   Video loss */

		public static final int NETDEV_TYPE_STORE_TYPE_INVALID              = 0xFF;          /*   Invalid value */
	}

	/**
	 * @enum tagNETDEVShutterTimeRange
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_SHUTTER_TIME_RANGE_E extends Structure {
		public static final int	NETDEV_SHUTTER_TIME_AUTOMATIC   = 0;            
		public static final int	NETDEV_SHUTTER_TIME_1           = 1;            /* 1/1 */
		public static final int	NETDEV_SHUTTER_TIME_1_2         = 2;            /* 1/2 */
		public static final int	NETDEV_SHUTTER_TIME_1_3         = 3;            /* 1/3 */
		public static final int	NETDEV_SHUTTER_TIME_1_4         = 4;            /* 1/4 */
		public static final int	NETDEV_SHUTTER_TIME_1_6         = 6;            /* 1/6 */
		public static final int	NETDEV_SHUTTER_TIME_1_8         = 8;            /* 1/8 */
		public static final int	NETDEV_SHUTTER_TIME_1_10        = 10;           /* 1/10*/
		public static final int	NETDEV_SHUTTER_TIME_1_12        = 12;           /* 1/12*/
		public static final int	NETDEV_SHUTTER_TIME_1_15        = 15;           /* 1/15*/
		public static final int	NETDEV_SHUTTER_TIME_1_20        = 20;           /* 1/20*/
		public static final int	NETDEV_SHUTTER_TIME_1_25        = 25;           /* 1/25*/
		public static final int	NETDEV_SHUTTER_TIME_1_30        = 30;           /* 1/30*/
		public static final int	NETDEV_SHUTTER_TIME_1_50        = 50;           /* 1/50*/
		public static final int	NETDEV_SHUTTER_TIME_1_60        = 60;           /* 1/60*/
		public static final int	NETDEV_SHUTTER_TIME_1_100       = 100;          /* 1/100*/
		public static final int	NETDEV_SHUTTER_TIME_1_120       = 120;          /* 1/120*/
		public static final int	NETDEV_SHUTTER_TIME_1_150       = 150;          /* 1/150*/
		public static final int	NETDEV_SHUTTER_TIME_1_180       = 180;          /* 1/180*/
		public static final int	NETDEV_SHUTTER_TIME_1_200       = 200;          /* 1/200*/
		public static final int	NETDEV_SHUTTER_TIME_1_250       = 250;          /* 1/250*/
		public static final int	NETDEV_SHUTTER_TIME_1_500       = 500;          /* 1/500*/
		public static final int	NETDEV_SHUTTER_TIME_1_1000      = 1000;         /* 1/1000*/
		public static final int	NETDEV_SHUTTER_TIME_1_2000      = 2000;         /* 1/2000*/
		public static final int	NETDEV_SHUTTER_TIME_1_4000      = 4000;         /* 1/4000*/
		public static final int	NETDEV_SHUTTER_TIME_1_8000      = 8000;         /* 1/8000*/
		public static final int	NETDEV_SHUTTER_TIME_1_50000     = 50000;        /* 1/50000*/
		public static final int	NETDEV_SHUTTER_TIME_1_100000    = 100000;       /* 1/100000*/

		public static final int NETDEV_SHUTTER_TIME_INVALID = 0xFF;                  
	}

	/**
	 * @enum tagNETDEVWideDynamicMode
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_WIDE_DYNAMIC_MODE_E extends Structure {
		public static final int NETDEV_WDM_CLOSED   = 0;    
		public static final int NETDEV_WDM_OPEN     = 1;    
		public static final int NETDEV_WDM_AUTO     = 2;    

		public static final int NETDEV_WDM_INVALID  = 0xFF;  
	}

	/**
	 * @enum tagNETDEVLampType
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_DAY_NIGHT_MODE_E extends Structure {
		public static final int NETDEV_DNM_AUTO                     = 0;        
		public static final int NETDEV_DNM_DAY_COLOR                = 1;        /* -- */
		public static final int NETDEV_DNM_NIGHT_BAW                = 2;        /* -- */
		public static final int NETDEV_DNM_LINK_COLOR_TO_BLACK      = 3;        

		public static final int NETDEV_DNM_INVALID                  = 0xFF;      
	}

	/**
	 * @enum tagNETDEVWhiteBalance
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_WHITE_BALANCE_MODE_E extends Structure {
		public static final int NETDEV_WBM_AUTO                         = 0;        
		public static final int NETDEV_WBM_TRIMMING                     = 1;        
		public static final int NETDEV_WBM_INDOOR                       = 2;        
		public static final int NETDEV_WBM_OUTDOOR                      = 3;        
		public static final int NETDEV_WBM_AUTO_MERCURY_LAMP            = 4;        
		public static final int NETDEV_WBM_NIGHT_TRIMMING               = 5;        
		public static final int NETDEV_WBM_AUTO_NA_LAMP                 = 6;        
		public static final int NETDEV_WBM_LOCK                         = 7;        
		public static final int NETDEV_WBM_SELF_ADAPT_NIGHT_TRIMMING    = 8;        
		public static final int NETDEV_WBM_AUTO_SECOND                  = 9;        /*2*/
		public static final int NETDEV_WBM_INVALID                      = 0xFF;      
	}

	/**
	 * @brief   Focus mode
	 * @attention  None
	 */
	public static class NETDEV_FOCUS_MODE_E extends Structure {
		public static final int NETDEV_FOCUS_AUTO           = 1;            /*  Auto */
		public static final int NETDEV_FOCUS_MANUAL         = 2;             /*  Manual */
	}

	/**
	 * @brief  IRCut filter mode
	 * @attention  None
	 */
	public static class NETDEV_IR_CUT_FILTER_MODE_E extends Structure {
		public static final int NETDEV_IR_CUT_FILTER_ON     = 0;            /*  On */
		public static final int NETDEV_IR_CUT_FILTER_OFF    = 1;            /*  Off */
		public static final int NETDEV_IR_CUT_FILTER_AUTO   = 2;             /*  Auto */
	}

	/**
	 * @brief   Defogging mode
	 * @attention  None
	 */
	public static class NETDEV_DEFOGGING_MODE_E extends Structure {
		public static final int NETDEV_DEFOGGING_ON = 0;            /*  On */
		public static final int NETDEV_DEFOGGING_OFF = 1;                /*  Off */
	}

	
	public static class NETDEV_AUDIO_CHL_MODE_E extends Structure {
		public static final int NETDEV_AUDIO_CHL_MODE_LINE              = 0;        /* LINE */
		public static final int NETDEV_AUDIO_CHL_MODE_MIC               = 1;        /*  MIC */
		public static final int NETDEV_AUDIO_CHL_MODE_RS485             = 2;        /* RS485 */
		public static final int NETDEV_AUDIO_CHL_MODE_SPEAKER           = 3;        /* SpeaKer */
		public static final int NETDEV_AUDIO_CHL_MODE_INVALID           = 0xFF;      
	}

	
	public static class NETDEV_AUDIO_COLLECTION_PORT_TYPE_E extends Structure {
		public static final int NETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_IN              = 0;        
		public static final int NETDEV_AUDIO_COLLECTION_PORT_TYPE_SERIAL_IN             = 1;        
		public static final int NETDEV_AUDIO_COLLECTION_PORT_TYPE_INVALID               = 0xFF;      
	}


	
	public static class NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E extends Structure {
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_MPEG1           = 0;       /* MPEG1 */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711A           = 1;       /* G.711A */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711U           = 2;       /* G.711U */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_ADPCM           = 3;       /* ADPCM */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_OGG             = 4;       /* OGG */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_Auto            = 5;       /* Auto */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_AACLC           = 6;       /* AAC-LC */
		public static final int NETDEV_AUDIO_ENCODE_FORMAT_TYPE_INVALID         = 0xFF;     
	}

	
	public static class NETDEV_AUDIO_SAMPLING_RATE_E extends Structure {
		public static final int NETDEV_AUDIO_SAMPLING_RATE_8KHZ             = 0;       /* 8KHz */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_16KHZ            = 1;       /* 16KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_22_05KHZ         = 2;       /* 22.05KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_24KHZ            = 3;       /* 24KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_32KHZ            = 4;       /* 32KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_44_1KHZ          = 5;       /* 44.1KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_48KHZ            = 6;       /* 48KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_96KHZ            = 7;       /* 96KHZ */
		public static final int NETDEV_AUDIO_SAMPLING_RATE_INVALID          = 0xFF;     
	}

	/**
	 * @enum  tagNETDEVMotionDetectAreaType
	 * @brief   motion detection area type emnu
	 * @attention 
	 */
	public static class NETDEV_MOTION_DETECTION_AREA_TYPE_E extends Structure {
		public static final int NETDEV_MOTION_DETECTION_AREA_TYPE_RECTANGLE         = 0;        /*   rectangle */
		public static final int NETDEV_MOTION_DETECTION_AREA_TYPE_MB                = 1;        /*   macro block */
		public static final int NETDEV_MOTION_DETECTION_AREA_TYPE_INVALID           = 0xff;      /*  Invalid value */
	}


	/**
	 * @enum tagNETDEVHDDType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_HDD_TYPE_E extends Structure {
		public static final int NETDEV_HDD_TYPE_LOCAL_HDD       = 0;            /* LocalHDD */
		public static final int NETDEV_HDD_TYPE_NO1_EXTEND_HDD  = 1;            /* No1ExtendCabinetHDD */
		public static final int NETDEV_HDD_TYPE_NO2_EXTEND_HDD  = 2;            /* No2ExtendCabinetHDD */

		public static final int NETDEV_HDD_TYPE_INVALID = 0xFF;                  /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDWorkMode
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_HDD_WORK_MODE_E extends Structure {
		public static final int NETDEV_HDD_WORK_MODE_COMMON     = 0;        
		public static final int NETDEV_HDD_WORK_MODE_RAID       = 1;        
		public static final int NETDEV_HDD_WORK_MODE_HOT_BACKUP = 2;        

		public static final int NETDEV_HDD_WORK_MODE_INVALID    = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_HDD_STATUS_E extends Structure {
		public static final int NETDEV_HDD_STATUS_NO        = 0;            
		public static final int NETDEV_HDD_STATUS_NORMAL    = 1;            
		public static final int NETDEV_HDD_STATUS_ABNORMAL  = 2;            

		public static final int NETDEV_HDD_STATUS_INVALID = 0xFF;            /* Invalid value */
	}

	/**
	 * @brief   
	 * @attention  None
	 */
	public static class NETDEV_ADDR_TYPE_E extends Structure {
		public static final int NETDEV_ADDR_TYPE_IPV4       = 0;             /* IPV4 */
		public static final int NETDEV_ADDR_TYPE_IPV6       = 1;             /* IPV6 */
		public static final int NETDEV_ADDR_TYPE_DOMAIN     = 2;             
		public static final int NETDEV_ADDR_TYPE_IPV4_IPV6  = 3;             /* IPV4IPV6 */
		public static final int NETDEV_ADDR_TYPE_INVALID    = 0XFFFF;         
	}

	/**
	 * @enum tagNETDEVStorageContainerUsageType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E extends Structure {
		public static final int NETDEV_STORAGE_CONTAINER_USAGE_TYPE_RECORD_CAPTURE   = 0;        /* / */
		public static final int NETDEV_STORAGE_CONTAINER_USAGE_TYPE_BACKUP           = 1;        

		public static final int NETDEV_STORAGE_CONTAINER_USAGE_TYPE_INVALID          = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVStorageContainerStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_STORAGE_CONTAINER_STATUS_E extends Structure {
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_NO                      = 0;            /* / */
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_UNFORMATTED             = 1;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_FORMATTING       = 2;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_NORMAL           = 3;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_SLEEP            = 4;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_ABNORMAL                = 5;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_SWITCH           = 6;            
		public static final int NETDEV_STORAGE_CONTAINER_STATUS_UNINSTALLED      = 7;            

		public static final int NETDEV_STORAGE_CONTAINER_STATUS_INVALID                 = 0xFF;          /* Invalid value */
	}

	/**
	 * @enum tagNETDEVStorageContainerProperty
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_STORAGE_CONTAINER_PROPERTY_E extends Structure {
		public static final int NETDEV_STORAGE_CONTAINER_PROPERTY_RW                = 0;            
		public static final int NETDEV_STORAGE_CONTAINER_PROPERTY_R                 = 1;            
		public static final int NETDEV_STORAGE_CONTAINER_PROPERTY_REDUNDANT         = 2;            

		public static final int NETDEV_STORAGE_CONTAINER_PROPERTY_INVALID           = 0xFF;          /* Invalid value */
	}

	/**
	 * @enum tagNETDEVPhotoServerProType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_PHOTO_SERVER_PRO_TYPE_E extends Structure {
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO1          = 0;        /* TCP: V1 */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO2          = 1;        /* TCP: V2tms */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO3          = 2;        /* TCP:  */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO4          = 3;        /* FTP:  */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO5          = 4;        /* FTP: FTP */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO6          = 5;        /* FTP:  */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO7          = 6;        /* webserver:  */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO8          = 7;        /* FTP:  */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO9          = 8;        /* FTP: 2 */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO10          = 9;       /* webserver FTP */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO11          = 10;      /* TCP: */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO12          = 11;      /* TCP FTP */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO31          = 12;      /* TCP: V2tms */
		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_PRO34          = 13;      /* HTTP:  */

		public static final int NETDEV_PHOTO_SERVER_PRO_TYPE_INVALID        = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVPhotoServerSubProtocolType
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_PHOTO_SERVER_SUBPRO_TYPE_E extends Structure {
		public static final int NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2011          = 0;        /* 2011 */
		public static final int NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2025          = 1;        /* 2025 */
		public static final int NETDEV_PHOTO_SERVER_SUBPRO_TYPE_6130          = 2;        /* 6130 */


		public static final int NETDEV_PHOTO_SERVER_SUBPRO_TYPE_INVALID        = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDSmartAssessmentStatus
	 * @brief Smart
	 * @attention  None
	 */
	public static class NETDEV_HDD_SMART_ASSESSMENT_STATUS_E extends Structure {
		public static final int NETDEV_HDD_SMART_ASSESSMENT_STATUS_NORMAL       = 0;        
		public static final int NETDEV_HDD_SMART_ASSESSMENT_STATUS_WARNING      = 1;        
		public static final int NETDEV_HDD_SMART_ASSESSMENT_STATUS_FAULT        = 2;        

		public static final int NETDEV_HDD_SMART_ASSESSMENT_STATUS_INVALID      = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDHealthAssessmentStatus
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E extends Structure {
		public static final int NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_NORMAL           = 0;        
		public static final int NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_PART_DAMAGE      = 1;        
		public static final int NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_FAULT            = 2;        

		public static final int NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_INVALID        = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDSmartCheckStatus
	 * @brief Smart
	 * @attention  None
	 */
	public static class NETDEV_HDD_SMART_CHECK_STATUS_E extends Structure {
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_NOT                = 0;        
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_IN_PORGRESS        = 1;        
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_SUCCESS            = 2;        
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_RECOGNITION_FAIL   = 3;        
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_FAIL               = 4;        /* SMART */
		public static final int NETDEV_HDD_SMART_CHECK_STATUS_NOT_SUPPORT        = 5;        

		public static final int NETDEV_HDD_SMART_CHECK_STATUS_INVALID            = 0xFF;      /* Invalid value */
	}

	/**
	 * @enum tagNETDEVHDDSmartCheckType
	 * @brief Smart
	 * @attention  None
	 */
	public static class NETDEV_HDD_SMART_CHECK_TYPE_E extends Structure {
		public static final int NETDEV_HDD_SMART_CHECK_TYPE_BRIEF          = 0;        
		public static final int NETDEV_HDD_SMART_CHECK_TYPE_EXTEND         = 1;        
		public static final int NETDEV_HDD_SMART_CHECK_TYPE_TRANSMISSION   = 2;        

		public static final int NETDEV_HDD_SMART_CHECK_TYPE_INVALID        = 0xFF;      /* Invalid value */
	}

	/**
	 * @brief     Major types of logs Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_LOG_MAIN_TYPE_E extends Structure {
		/* NVR */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALL                                        = 0;                /*  NVR Logs of all types */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM                                      = 1;                /*   Alarms */
		public static final int	NETDEV_LOG_MAIN_TYPE_EXCEPTION                                  = 2;                /*   Exceptions */
		public static final int	NETDEV_LOG_MAIN_TYPE_OPERATION                                  = 3;                /*   Operations */
		public static final int	NETDEV_LOG_MAIN_TYPE_MESSAGE                                    = 4;                /*   Messages */

		/* VMS*/
		public static final int	NETDEV_LOG_MAIN_TYPE_VMS_ALL                                    =  90;              /*  VMS Logs of all types */
		public static final int	NETDEV_LOG_MAIN_TYPE_LOGIN                                      =  91;              /*  Login */

		public static final int	NETDEV_LOG_MAIN_TYPE_ORGANIZATION_CONFIG                        = 100;              /*  Organization Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_USER_CONFIG                                = 101;              /*  User Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ROLE_CONFIG                                = 102;              /*  Role Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DEVICE_CONFIG                              = 103;              /*  Device Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_CHANNE_LCONFIG                             = 104;              /*  Channel Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SERVER_CONFIG                              = 105;              /*  Server Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_PTZ_CONFIG                                 = 106;              /*  PTZ Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_VIDEOWALL_CONFIG                           = 107;              /*  Video Wall Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_EMAP_CONFIG                                = 108;              /*  EMap Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SYSTEM_CONFIG                              = 109;              /* () System Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SEQUENCE_PLAN_CONFIG                       = 110;              /*  Sequence Plan Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_NETWORK_KEYPAD_CONFIG                      = 111;              /*  Network Keypad Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SEQUENCE_RESOURCE_CONFIG                   = 112;              /*  Sequence Resource Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_HOT_SPOT_AND_ZONE_CONFIG                   = 113;              /*  Hot Spot And Zone Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_USER_TIME_TEMPLATE_CONFIG                  = 114;              /*  User Time Template Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SERVER_WORK_MODE                           = 115;              /*  Server Work Mode */
		public static final int	NETDEV_LOG_MAIN_TYPE_PERMISSION_TIME_TEMPLATE_CONFIG            = 116;              /*  Permission Time Template Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_TIME_CONFIG                                = 117;              /*  Time Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_TIMESYNC_CONFIG                            = 118;              /*  Time Sync Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_HOLIDAY_CONFIG                             = 119;              /*  Holiday Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_NTPTIME_CONFIG                             = 120;              /* NTP NTP Time Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DST_CONFIG                                 = 121;              /*  DST Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_RESRELATION_CONFIG                         = 122;              /*  Resource Relation Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DEVICE_TIME_SYNC                           = 123;              /*  Device Time Sync */
		public static final int	NETDEV_LOG_MAIN_TYPE_TCPIP_CONFIG                               = 124;              /* tcp/ip TCP/IP Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_EZCLOUD_CONFIG                             = 125;              /*  EZCloud Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DDNS_CONFIG                                = 126;              /* DDNS DDNS Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_PORT_CONFIG                                = 127;              /*  Port Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_PORTMAPPING_CONFIG                         = 128;              /*  Port Mapping Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_EMAIL_CONFIG                               = 129;              /*  Email Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_GBSERVER_CONFIG                            = 130;              /*  GB Server Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_GBT28181_LOCAL_CONFIG                      = 131;              /*  GBT28181 Local Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_UNP_CLIENT_CONFIG                          = 132;              /* UNP UNP Client Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_UNP_SERVER_CONFIG                          = 133;              /* UNP UNP Server Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_STATIC_ROUTE_CONFIG                        = 134;              /*  Static Route Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_802DOT1X_CONFIG                            = 135;              /* 8021X 802Dot1x Config" */
		public static final int	NETDEV_LOG_MAIN_TYPE_ARP_CONFIG                                 = 136;              /* ARP ARP Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_HTTPS_CONFIG                               = 137;              /* https HTTPS Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_TELNET_CONFIG                              = 138;              /* telnet Telnet Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SECURITY_PSW_CONFIG                        = 139;              /*  Security Passwd Config */

		public static final int	NETDEV_LOG_MAIN_TYPE_IP_FILTER_RULE_CONFIG                      = 140;              /* IP IP Filter Rule Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_MAINTENANCE_CONFIG                         = 141;              /*  Maintenance Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_SET_MAX_LOG_RETENTION_TIME                 = 142;              /*  Set Max Log Retention Time */
		public static final int	NETDEV_LOG_MAIN_TYPE_STREAM_TRANSMISSION_POLICY_CONFIG          = 143;              /*  Stream Transmission Policy Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_BATCH_CONFIG                               = 144;              /*  Batch Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_RAIDMODE_CONFIG                            = 145;              /* RAID RAID Mode Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ARRAY_CONFIG                               = 146;              /*  Array Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DISK_MANAGEMENT_CONFIG                     = 147;              /*  Disk Management Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_CHANNEL_SPACE_CONFIG                       = 148;              /*  Channel Space Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_OVER_WRITE_POLICY_CONFIG                   = 149;              /*  Overwrite Policy Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DISKTEST_CONFIG                            = 150;              /*  Disk Test Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_NET_DISK_CONFIG                            = 151;              /*  Net Disk Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_RECORDING_SCHEDULE_CONFIG                  = 152;              /*  Recording Schedule Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_RECORDING_TIME_TEMPLATE_CONFIG             = 153;              /*  Recording Time Template Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM_CONFIG                               = 154;              /*  Alarm Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM_TIMETEMPLATE_CONFIG                  = 155;              /*  Alarm Time Template Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_CONTACT_CONFIG                             = 156;              /*  Contact Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL_CONFIG                 = 157;              /*  Alarmto Video Wall Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_SCENE_CONFIG                    = 158;              /*  Video Wall Scene Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_WINDOW_CONFIG                   = 159;              /*  Video Wall Window Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_VIRTUALLED_CONFIG               = 160;              /* LED Video Wall Virtual LED Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_EXTERNAL_ALARM_CONFIG                      = 161;              /*   External Alarm Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_DISK_GROUP_CONFIG                          = 162;              /*  Disk Group Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_BK_PLAN_CONFIG                             = 163;              /*  BK Plan Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_BK_TASK_CONFIG                             = 164;              /*  BK Task Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_LOCAL_BK_TASKCONFIG                        = 165;              /*  Local BK Task Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_TVWALL_AUDIO_CONFIG                        = 166;              /*  Tvwall Audio Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_LIVEVIEW                                   = 167;              /*  Live View */
		public static final int	NETDEV_LOG_MAIN_TYPE_PLAYBACK                                   = 168;              /*  Playback */
		public static final int	NETDEV_LOG_MAIN_TYPE_TWO_WAY_AUDIO                              = 169;              /*  Two Way Audio */
		public static final int	NETDEV_LOG_MAIN_TYPE_PTZ                                        = 170;              /*  PTZ */
		public static final int	NETDEV_LOG_MAIN_TYPE_DOWNLOAD                                   = 171;              /*  Download */
		public static final int	NETDEV_LOG_MAIN_TYPE_LIVEVIEW_ON_VIDEO_WALL                     = 172;              /*  Live Viewon Video Wall */
		public static final int	NETDEV_LOG_MAIN_TYPE_PLAYBACK_ON_VIDEO_WALL                     = 173;              /*  Playback On Video Wall */
		public static final int	NETDEV_LOG_MAIN_TYPE_EMAP_OPERATION                             = 174;              /*  EMap Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_DC_SEQUENCE_OPERATION                      = 175;              /* DC DC Sequence Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_PLAYING_BY_NETWROK_KEYPAD       = 176;              /*  Video Wall Playing by Netwrok Keypad */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL                        = 177;              /*  Alarm to Video Wall */
		public static final int	NETDEV_LOG_MAIN_TYPE_ALARM_SUBSCRIPTION                         = 178;              /*  Alarm Subscription */
		public static final int	NETDEV_LOG_MAIN_TYPE_PRESET_PATROL_CONFIG                       = 179;              /*  Preset Patrol Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_AUTOGUARD_CONFIG                           = 180;              /*  Auto Guard Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_RECORDED_PATROL_CONFIG                     = 181;              /*  Recorded Patrol Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_PERSONNEL_MANAGEMENT        = 182;              /*  Access Control Personnel Management */
		public static final int	NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_CARD_MANAGEMENT             = 183;              /*  Access Control Card Management */
		public static final int	NETDEV_LOG_MAIN_TYPE_ZONE_OPERATION                             = 184;              /*  Zone Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_DOOR                        = 185;              /*  Access Control Door */
		public static final int	NETDEV_LOG_MAIN_TYPE_TRIGGER_ALARMOUTPUT                        = 186;              /*  Trigger Alarm Output */
		public static final int	NETDEV_LOG_MAIN_TYPE_CENTER_RECORD                              = 187;              /*  Center Record */
		public static final int	NETDEV_LOG_MAIN_TYPE_FACE_LIBRARY_OPERATION                     = 188;              /*  Face Library Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_OPERATION                      = 189;              /*  Face Member Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_FACE_CUSTOM_OPERATION                      = 190;              /*  Face Custom Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_SORT_OPERATION                 = 191;              /*  Face Member Sort Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_FACE_MONITORING_TASKO_PERATION             = 192;              /*  Face Monitoring Task Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_VEHICLE_LIBRARY_OPERATION                  = 193;              /*  Vehicle Library Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_SORT_OPERATION              = 194;              /*  Vehicle Member Sort Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_OPERATION                   = 195;              /*  Vehicle Member Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_CAP_PAC_TASK                               = 196;              /*  Cap Pac Task */
		public static final int	NETDEV_LOG_MAIN_TYPE_RECORD_BK_CONFIG                           = 197;              /*  Record BK Config */
		public static final int	NETDEV_LOG_MAIN_TYPE_USB_OPERATION                              = 198;              /* U USB Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_VEHICLE_MONITORING_TASK_OPERATION          = 199;              /*  Vehicle Monitoring Task Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_PERMISSION_ASSIGNMENT_OPERATION            = 200;              /*  Permission Assignment Operation */
		public static final int	NETDEV_LOG_MAIN_TYPE_INVALID                                    = 0xFFFF;            /*   Invalid value */

	}

	/**
	 * @brief ID   Minor type IDs of logs Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_LOG_SUB_TYPE_E extends Structure {
		public static final int	NETDEV_LOG_ALL_SUB_TYPES                     = 0x0101;          /*   All information logs */

		/*   Information logs */
		public static final int	NETDEV_LOG_MSG_HDD_INFO                     = 300;              /*   HDD information */
		public static final int	NETDEV_LOG_MSG_SMART_INFO                   = 301;              /* S.M.A.R.T  S.M.A.R.T information */
		public static final int	NETDEV_LOG_MSG_REC_OVERDUE                  = 302;              /*   Expired recording deletion */
		public static final int	NETDEV_LOG_MSG_PIC_REC_OVERDUE              = 303;              /*   Expired image deletion */

		/*   notification logs */
		public static final int	NETDEV_LOG_NOTICE_IPC_ONLINE                = 310;              /*   Device online */
		public static final int	NETDEV_LOG_NOTICE_IPC_OFFLINE               = 311;              /*   Device offline */
		public static final int	NETDEV_LOG_NOTICE_ARRAY_RECOVER             = 312;              /*   arrayRecover */
		public static final int	NETDEV_LOG_NOTICE_INIT_ARRARY               = 313;              /*   initializeArray */
		public static final int	NETDEV_LOG_NOTICE_REBUILD_ARRARY            = 314;              /*   rebuildArray */
		public static final int	NETDEV_LOG_NOTICE_POE_PORT_STATUS           = 315;              /* PoE  poePortStatus */
		public static final int	NETDEV_LOG_NOTICE_NETWORK_PORT_STATUS       = 316;              /*  networkPortStatus */
		public static final int	NETDEV_LOG_NOTICE_DISK_ONLINE               = 317;              /*   Disk online */

		/* ID  Sub type log ID of alarm logs */
		public static final int	NETDEV_LOG_ALARM_MOTION_DETECT              = 350;              /*   Motion detection alarm */
		public static final int	NETDEV_LOG_ALARM_MOTION_DETECT_RESUME       = 351;              /*   Motion detection alarm recover */
		public static final int	NETDEV_LOG_ALARM_VIDEO_LOST                 = 352;              /*   Video loss alarm */
		public static final int	NETDEV_LOG_ALARM_VIDEO_LOST_RESUME          = 353;              /*   Video loss alarm recover */
		public static final int	NETDEV_LOG_ALARM_VIDEO_TAMPER_DETECT        = 354;              /*   Tampering detection alarm */
		public static final int	NETDEV_LOG_ALARM_VIDEO_TAMPER_RESUME        = 355;              /*   Tampering detection alarm recover */
		public static final int	NETDEV_LOG_ALARM_INPUT_SW                   = 356;              /*   Boolean input alarm */
		public static final int	NETDEV_LOG_ALARM_INPUT_SW_RESUME            = 357;              /*   Boolean input alarm recover */
		public static final int	NETDEV_LOG_ALARM_IPC_ONLINE                 = 358;              /*   Device online */
		public static final int	NETDEV_LOG_ALARM_IPC_OFFLINE                = 359;              /*   Device offline */

		public static final int	NETDEV_LOG_ALARM_AUDIO_DETECTION_START      = 360;              /*   Audio detection start */
		public static final int	NETDEV_LOG_ALARM_AUDIO_DETECTION_END        = 361;              /*   Audio detection end */
		public static final int	NETDEV_LOG_ALARM_CROSS_LINE_DETECT          = 362;              /*   CrossLine detection */
		public static final int	NETDEV_LOG_ALARM_FACE_DETECT                = 363;              /*   Face Detection */
		public static final int	NETDEV_LOG_ALARM_INTRUSION_DETECT           = 364;              /*   Intrusion Detection */
		public static final int	NETDEV_LOG_ALARM_POS                        = 365;              /* POS  POS Alarm */
		public static final int	NETDEV_LOG_ALARM_IMAGETOOBLURRY_ON          = 366;              /*   Defocus detection started*/
		public static final int	NETDEV_LOG_ALARM_IMAGETOOBLURRY_OFF         = 367;              /*   Defocus detection ended*/
		public static final int	NETDEV_LOG_ALARM_GLOBAL_SCENE_CHANGE        = 368;              /*   Scene change detection*/
		public static final int	NETDEV_LOG_ALARM_AUTO_TRACK_ON              = 369;              /*   Auto tracking started*/
		public static final int	NETDEV_LOG_ALARM_AUTO_TRACK_OFF             = 370;              /*   Auto tracking ended*/
		public static final int	NETDEV_LOG_ALARM_CONFLAGRATION_ON           = 371;              
		public static final int	NETDEV_LOG_ALARM_CONFLAGRATION_OFF          = 372;              
		public static final int	NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_ON      = 373;              
		public static final int	NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_OFF     = 374;              
		public static final int NETDEV_LOG_ALARM_ENTERAREA                  = 375;              
		public static final int NETDEV_LOG_ALARM_LEAVEAREA                  = 376;              

		/* ID  Sub type log ID of exception logs */
		public static final int	NETDEV_LOG_EXCEP_DISK_ONLINE                = 400;              /*   Disk online */
		public static final int	NETDEV_LOG_EXCEP_DISK_OFFLINE               = 401;              /*   Disk offline */
		public static final int	NETDEV_LOG_EXCEP_DISK_ERR                   = 402;              /*   Disk exception */
		public static final int	NETDEV_LOG_EXCEP_STOR_ERR                   = 403;              /*   Storage error */
		public static final int	NETDEV_LOG_EXCEP_STOR_ERR_RECOVER           = 404;              /*   Storage error recover */
		public static final int	NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN          = 405;              /*   Not stored as planned */
		public static final int	NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN_RECOVER  = 406;              /*   Not stored as planned recover */
		public static final int	NETDEV_LOG_EXCEP_ILLEGAL_ACCESS             = 407;              /*   Illegal access */
		public static final int	NETDEV_LOG_EXCEP_IP_CONFLICT                = 408;              /* IP  IP address conflict */
		public static final int	NETDEV_LOG_EXCEP_NET_BROKEN                 = 409;              /*   Network disconnection */
		public static final int	NETDEV_LOG_EXCEP_PIC_REC_ERR                = 410;              /* ,  Failed to get captured image */
		public static final int	NETDEV_LOG_EXCEP_VIDEO_EXCEPTION            = 411;              /* ()  Video input exception (for analog channel only) */
		public static final int	NETDEV_LOG_EXCEP_VIDEO_MISMATCH             = 412;              /*    Video standards do not match */
		public static final int	NETDEV_LOG_EXCEP_RESO_MISMATCH              = 413;              /*   Encoding resolution and front-end resolution do not match */
		public static final int	NETDEV_LOG_EXCEP_TEMP_EXCE                  = 414;              /*   Temperature exception */
		public static final int	NETDEV_LOG_EXCEP_RUNOUT_RECORD_SPACE        = 415;              /*   runOutOfRecordSpace */
		public static final int	NETDEV_LOG_EXCEP_RUNOUT_IMAGE_SPACE         = 416;              /*   runOutOfImageSpace */
		public static final int	NETDEV_LOG_EXCEP_OUT_RECORD_SPACE           = 417;              /*   recordSpaceUsedUp */
		public static final int	NETDEV_LOG_EXCEP_OUT_IMAGE_SPACE            = 418;              /*   imageSpaceUsedUp */
		public static final int	NETDEV_LOG_EXCEP_ANRIDISASSEMBLY            = 419;              /*   antiDisassembly Alarm */
		public static final int	NETDEV_LOG_EXCEP_ANRIDISASSEMBLY_RECOVER    = 420;              /*  antiDisassembly AlarmClear*/
		public static final int	NETDEV_LOG_EXCEP_ARRAY_DAMAGE               = 421;              /*   arrayDamage */
		public static final int	NETDEV_LOG_EXCEP_ARRAY_DEGRADE              = 422;              /*   arrayDegrade */
		public static final int	NETDEV_LOG_EXCEP_RECORD_SNAPSHOT_ABNOR      = 423;              /* /  recordSnapshotAbnormal */
		public static final int	NETDEV_LOG_EXCEP_NET_BROKEN_RECOVER         = 424;              /*   networkDisconnectClear */
		public static final int	NETDEV_LOG_EXCEP_IP_CONFLICT_RECOVER        = 425;              /* IP  ipConflictClear */
		public static final int	NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP            = 426;              /*   High Temperature */
		public static final int	NETDEV_LOG_EXCEP_DEVICE_LOWTEMP             = 427;              /*   Low Temperature */
		public static final int	NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP_RECOVER    = 428;              /*   High Temperature Cleared */
		public static final int	NETDEV_LOG_EXCEP_DEVICE_LOWTEMP_RECOVER     = 429;              /*   Low Temperature Cleared */
		public static final int	NETDEV_LOG_EXCEP_FAN_FAULT                  = 430;              /*   Fan Failure */
		public static final int	NETDEV_LOG_EXCEP_FAN_FAULT_RECOVER          = 431;              /*   Fan Failure Cleared */
		public static final int	NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP            = 432;              /*   LED Distribution Box High Temperature */
		public static final int	NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP_RECOVER    = 433;              /*   LED Distribution Box High Temperature Cleared */
		public static final int	NETDEV_LOG_EXCEP_LEDBOX_SMOKE               = 434;              /*   LED Distribution Box Smoke Alarm */
		public static final int	NETDEV_LOG_EXCEP_LEDBOX_SMOKE_RECOVER       = 435;              /*   LED Distribution Box Smoke Alarm Cleared */

		/* ID  Sub type log ID of operation logs */
		/*   Services */
		public static final int	NETDEV_LOG_OPSET_LOGIN                      = 450;              /*   User login */
		public static final int	NETDEV_LOG_OPSET_LOGOUT                     = 451;              /*   Log out */
		public static final int	NETDEV_LOG_OPSET_USER_ADD                   = 452;              /*   Add user */
		public static final int	NETDEV_LOG_OPSET_USER_DEL                   = 453;              /*   Delete user */
		public static final int	NETDEV_LOG_OPSET_USER_MODIFY                = 454;              /*   Modify user */
		public static final int	NETDEV_LOG_OPSET_START_REC                  = 455;              /*   Start recording */
		public static final int	NETDEV_LOG_OPSET_STOP_REC                   = 456;              /*   Stop recording */
		public static final int	NETDEV_LOG_OPSETR_PLAY_DOWNLOAD             = 457;              /* /  Playback and download */
		public static final int	NETDEV_LOG_OPSET_DOWNLOAD                   = 458;              /*   Download */
		public static final int	NETDEV_LOG_OPSET_PTZCTRL                    = 459;              /*   PTZ control */
		public static final int	NETDEV_LOG_OPSET_PREVIEW                    = 460;              /*   Live preview */
		public static final int	NETDEV_LOG_OPSET_REC_TRACK_START            = 461;              /*   Start recording route */
		public static final int	NETDEV_LOG_OPSET_REC_TRACK_STOP             = 462;              /*   Stop recording route */
		public static final int	NETDEV_LOG_OPSET_START_TALKBACK             = 463;              /*   Start two-way audio */
		public static final int	NETDEV_LOG_OPSET_STOP_TALKBACK              = 464;              /*   Stop two-way audio */
		public static final int	NETDEV_LOG_OPSET_IPC_ADD                    = 465;              /* IPC  Add IP camera */
		public static final int	NETDEV_LOG_OPSET_IPC_DEL                    = 466;              /* IPC  Delete IP camera */
		public static final int	NETDEV_LOG_OPSET_IPC_SET                    = 467;              /* IPC  Modify IP camera */
		public static final int	NETDEV_LOG_OPSET_IPC_QUICK_ADD              = 468;              /* IPC  quickAddIpc*/
		public static final int	NETDEV_LOG_OPSET_IPC_ADD_BY_NETWORK         = 469;              /* IPC  addIpcByNetwork */
		public static final int	NETDEV_LOG_OPSET_IPC_MOD_IP                 = 470;              /* IPC  modifyIpcAddr */

		/*   Configurations */
		public static final int	NETDEV_LOG_OPSET_DEV_BAS_CFG                = 500;              /*   Basic device information */
		public static final int	NETDEV_LOG_OPSET_TIME_CFG                   = 501;              /*   Device time */
		public static final int	NETDEV_LOG_OPSET_SERIAL_CFG                 = 502;              /*   Device serial port */
		public static final int	NETDEV_LOG_OPSET_CHL_BAS_CFG                = 503;              /*   Basic channel configuration */
		public static final int	NETDEV_LOG_OPSET_CHL_NAME_CFG               = 504;              /*   Channel name configuration */
		public static final int	NETDEV_LOG_OPSET_CHL_ENC_VIDEO              = 505;              /*   Video encoding configuration */
		public static final int	NETDEV_LOG_OPSET_CHL_DIS_VIDEO              = 506;              /*   Video display configuration */
		public static final int	NETDEV_LOG_OPSET_PTZ_CFG                    = 507;              /*   PTZ configuration */
		public static final int	NETDEV_LOG_OPSET_CRUISE_CFG                 = 508;              /*   Patrol route configuration */
		public static final int	NETDEV_LOG_OPSET_PRESET_CFG                 = 509;              /*   Preset configuration */
		public static final int	NETDEV_LOG_OPSET_VIDPLAN_CFG                = 510;              /*   Recording schedule configuration */
		public static final int	NETDEV_LOG_OPSET_MOTION_CFG                 = 511;              /*   Motion detection configuration */
		public static final int	NETDEV_LOG_OPSET_VIDLOSS_CFG                = 512;              /*   Video loss configuration */
		public static final int	NETDEV_LOG_OPSET_COVER_CFG                  = 513;              /*   Tampering detection configuration */
		public static final int	NETDEV_LOG_OPSET_MASK_CFG                   = 514;              /*   Privacy mask configuration */
		public static final int	NETDEV_LOG_OPSET_SCREEN_OSD_CFG             = 515;              /* OSD  OSD overlay configuration */
		public static final int	NETDEV_LOG_OPSET_ALARMIN_CFG                = 516;              /*   Alarm input configuration */
		public static final int	NETDEV_LOG_OPSET_ALARMOUT_CFG               = 517;              /*   Alarm output configuration */
		public static final int	NETDEV_LOG_OPSET_ALARMOUT_OPEN_MAN          = 518;              /* ,  Manually enable alarm output; GUI */
		public static final int	NETDEV_LOG_OPSET_ALARMOUT_CLOSE_MAN         = 519;              /* ,  Manually disable alarm input; GUI */
		public static final int	NETDEV_LOG_OPSET_ABNORMAL_CFG               = 520;              /*   Exception configuration */
		public static final int	NETDEV_LOG_OPSET_HDD_CFG                    = 521;              /*   HDD configuration */
		public static final int	NETDEV_LOG_OPSET_NET_IP_CFG                 = 522 ;             /* TCP/IP  TCP/IP configuration */
		public static final int	NETDEV_LOG_OPSET_NET_PPPOE_CFG              = 523;              /* PPPOE  PPPOE configuration */
		public static final int	NETDEV_LOG_OPSET_NET_PORT_CFG               = 524;              /*   Port configuration */
		public static final int	NETDEV_LOG_OPSET_NET_DDNS_CFG               = 525;              /* DDNS  DDNS configuration */
		public static final int	NETDEV_LOG_OPSET_AUDIO_DETECT               = 527;              /*   searchExtendDisk */
		public static final int	NETDEV_LOG_OPSET_SEARCH_EX_DISK             = 528;              /*   searchExtendDisk */
		public static final int	NETDEV_LOG_OPSET_ADD_EX_DISK                = 529 ;             /*   addExtendDisk */
		public static final int	NETDEV_LOG_OPSET_DEL_EX_DISK                = 530;              /*   deleteExtendDisk */
		public static final int	NETDEV_LOG_OPSET_SET_EX_DISK                = 531;              /*   setExtendDisk */
		public static final int	NETDEV_LOG_OPSET_LIVE_BY_MULTICAST          = 532;              /*   liveViewByMulticast */
		public static final int	NETDEV_LOG_OPSET_BISC_DEV_INFO              = 533;              /*   setBasicDeviceInfo */
		public static final int	NETDEV_LOG_OPSET_PREVIEW_CFG                = 534;              /*   SetPreviewOnNvr */
		public static final int	NETDEV_LOG_OPSET_SET_EMAIL                  = 535;              /*   setEmail */
		public static final int	NETDEV_LOG_OPSET_TEST_EMAIL                 = 536;              /*   testEmail */
		public static final int	NETDEV_LOG_OPSET_SET_IPCONTROL              = 537;              /* IP  setIPControl */
		public static final int	NETDEV_LOG_OPSET_PORT_MAP                   = 538 ;             /*   setPortMap */
		public static final int	NETDEV_LOG_OPSET_ADD_TAG                    = 539;              /*   addTag */
		public static final int	NETDEV_LOG_OPSET_DEL_TAG                    = 540;              /*   deleteTag */
		public static final int	NETDEV_LOG_OPSET_MOD_TAG                    = 541;              /*   modifyTag */
		public static final int	NETDEV_LOG_OPSET_LOCK_RECORD                = 542;              /*   lockRecord */
		public static final int	NETDEV_LOG_OPSET_UNLOCK_RECORD              = 543;              /*   unlockRecord */
		public static final int	NETDEV_LOG_OPSET_DDNS_UPDATE_SUCCESS        = 545;              /* DDNS  DDNSUpdateSuccess */
		public static final int	NETDEV_LOG_OPSET_DDNS_INCORRECT_ID          = 546;              /* DDNS  DDNSUpdateFailedIncorrectUsernamePassword */
		public static final int	NETDEV_LOG_OPSET_DDNS_DOMAIN_NAME_NOT_EXIST = 547;              /* DDNS  DDNSUpdateFailedDomainNameNotExist */
		public static final int	NETDEV_LOG_OPSET_DDNS_UPDATE_FAIL           = 548;              /* DDNS  DDNSUpdateFailed */
		public static final int	NETDEV_LOG_OPSET_HTTP_CFG                   = 549;              /* HTTPS  setHttps */
		public static final int	NETDEV_LOG_OPSET_IP_OFFLINE_ALARM_CFG       = 550;              /* IPC  testDDNSDomain */
		public static final int	NETDEV_LOG_OPSET_TELNET_CFG                 = 551;              /* Telnet  setTelnet */
		public static final int	NETDEV_LOG_OPSET_TEST_DDNS_DOMAIN           = 552;              /* DDNS  testDDNSDomain */
		public static final int	NETDEV_LOG_OPSET_DDNS_DOMAIN_CONFLICT       = 553;              /* DDNS  DDNSDomainInvalid */
		public static final int	NETDEV_LOG_OPSET_DDNS_DOMAIN_INVALID        = 554;              /* DDNS  setDDNS */
		public static final int	NETDEV_LOG_OPSET_DEL_PRESET                 = 555;              /*   deletePreset */
		public static final int	NETDEV_LOG_OPSET_PTZ_3D_POSITION            = 556;              /* 3D  ptz3DPosition */
		public static final int	NETDEV_LOG_OPSET_SNAPSHOT_SCHEDULE_CFG      = 557;              /*   setSnapshotSchedule */
		public static final int	NETDEV_LOG_OPSET_IMAGE_UPLOAD_SCHEDULE_CFG  = 558;              /*   setImageUploadSchedule */
		public static final int	NETDEV_LOG_OPSET_FTP_CFG                    = 559;              /* FTP  setFtpServer */
		public static final int	NETDEV_LOG_OPSET_TEST_FTP_SERVER            = 560;              /* FTP  testFtpServer */
		public static final int	NETDEV_LOG_OPSET_START_MANUAL_SNAPSHOT      = 561;              /*   startManualSnapshot */
		public static final int	NETDEV_LOG_OPSET_CLOSE_MANUAL_SNAPSHOT      = 562;              /*   endManualSnapshot */
		public static final int	NETDEV_LOG_OPSET_SNAPSHOT_CFG               = 563;              /*   setSnapshot */
		public static final int	NETDEV_LOG_OPSET_ADD_HOLIDAY                = 564;              /*   addHoliday */
		public static final int	NETDEV_LOG_OPSET_DEL_HOLIDAY                = 565;              /*   deleteHoliday */
		public static final int	NETDEV_LOG_OPSET_MOD_HOLIDAY                = 566;              /*   modifyHoliday */
		public static final int	NETDEV_LOG_OPSET_ONOFF_HOLIDAY              = 567;              /* /  enableDisableHoliday */
		public static final int	NETDEV_LOG_OPSET_ALLOCATE_SPACE             = 568;              /*   allocateSpace */
		public static final int	NETDEV_LOG_OPSET_HDD_FULL_POLICY_CFG        = 569;              /*   setHddFullPolicy */
		public static final int	NETDEV_LOG_OPSET_AUDIO_STREAM_CFG           = 570;              /*   setAudioStream */
		public static final int	NETDEV_LOG_OPSET_ARRAY_PROPERTY_CFG         = 571;              /*   setArrayProperty */
		public static final int	NETDEV_LOG_OPSET_HOT_SPACE_DISK_CFG         = 572;              /*   setHotSpaceDisk */
		public static final int	NETDEV_LOG_OPSET_CREAT_ARRAY                = 573;              /*   createArray */
		public static final int	NETDEV_LOG_OPSET_ONE_CLICK_CREAT_ARRAY      = 574;              /*   oneClickCreateArray */
		public static final int	NETDEV_LOG_OPSET_REBUILD_ARRAY              = 575;              /*   rebuildArray */
		public static final int	NETDEV_LOG_OPSET_DEL_ARRAY                  = 576;              /*   deleteArray */
		public static final int	NETDEV_LOG_OPSET_ENABLE_RAID                = 577;              /* RAID  enableRaid */
		public static final int	NETDEV_LOG_OPSET_DISABLE_RAID               = 578;              /* RAID  disableRaid */
		public static final int	NETDEV_LOG_OPSET_TEST_SMART                 = 579;              /* S.M.A.R.T  testSmart */
		public static final int	NETDEV_LOG_OPSET_SMART_CFG                  = 580;              /* S.M.A.R.T  setSmart */
		public static final int	NETDEV_LOG_OPSET_BAD_SECTOR_DETECT          = 581;              /*   badSectorDetect */
		public static final int	NETDEV_LOG_OPSET_AUDIO_ALARM_DURATION       = 582;              /*   setAudioAlarmDuration */
		public static final int	NETDEV_LOG_OPSET_CLR_AUDIO_ALARM            = 583;             /*   clearAudioAlarm */
		public static final int	NETDEV_LOG_OPSET_IPC_TIME_SYNC_CFG          = 584;              /*   setIpcTimeSync */
		public static final int	NETDEV_LOG_OPSET_ENABLE_DISK_GROUP          = 585;              /*   enableDiskGroup */
		public static final int	NETDEV_LOG_OPSET_DISABLE_DISK_GRRUOP        = 586;              /*   disableDiskGroup */
		public static final int	NETDEV_LOG_OPSET_ONVIF_AUTH_CFG             = 587;              /* ONVIF  setOnvifAuth */
		public static final int	NETDEV_LOG_OPSET_8021X_CFG                  = 588;              /* 802.1X  set8021x */
		public static final int	NETDEV_LOG_OPSET_ARP_PROTECTION_CFG         = 589;              /* ARP  setArpProtection */
		public static final int	NETDEV_LOG_OPSET_SMART_BASIC_INFO_CFG       = 590 ;             /*   setSmartBasicInfo */
		public static final int	NETDEV_LOG_OPSET_CROSS_LINE_DETECT_CFG      = 591;              /*   setCrossLineDetection */
		public static final int	NETDEV_LOG_OPSET_INSTRUSION_DETECT_CFG      = 592;              /*   setIntrusionDetection */
		public static final int	NETDEV_LOG_OPSET_PEOPLE_COUNT_CFG           = 593;              /*   setPeopleCount */
		public static final int	NETDEV_LOG_OPSET_FACE_DETECT_CFG            = 594;              /*   setFaceDetection */
		public static final int	NETDEV_LOG_OPSET_FISHEYE_CFG                = 595;              /*   setFisheye */
		public static final int	NETDEV_LOG_OPSET_CUSTOM_PROTOCOL_CFG        = 596;              /*   setCustomProtocol */
		public static final int	NETDEV_LOG_OPSET_BEHAVIOR_SEARCH            = 597;              /*   behaviorSearch */
		public static final int	NETDEV_LOG_OPSET_FACE_SEARCH                = 598;              /*   faceSearch */
		public static final int	NETDEV_LOG_OPSET_PEOPLE_COUNT               = 599;              /*   peopleCount */

		/*  Maintenance */
		public static final int	NETDEV_LOG_OPSET_START_DVR                  = 600;              /*   Start up*/
		public static final int	NETDEV_LOG_OPSET_STOP_DVR                   = 601;              /*   Shut down */
		public static final int	NETDEV_LOG_OPSET_REBOOT_DVR                 = 602;              /*   Restart device */
		public static final int	NETDEV_LOG_OPSET_UPGRADE                    = 603;              /*   Version upgrade */
		public static final int	NETDEV_LOG_OPSET_LOGFILE_EXPORT             = 604;              /*   Export log files */
		public static final int	NETDEV_LOG_OPSET_CFGFILE_EXPORT             = 605;              /*   Export configuration files */
		public static final int	NETDEV_LOG_OPSET_CFGFILE_IMPORT             = 606;              /*   Import configuration files */
		public static final int	NETDEV_LOG_OPSET_CONF_SIMPLE_INIT           = 607;              /*   Export configuration files */
		public static final int	NETDEV_LOG_OPSET_CONF_ALL_INIT              = 608;               /*   Restore to factory settings */

		public static final int	NETDEV_LOG_OPSET_VCA_BACKUP                 = 700;              /*   vcaBackup */
		public static final int	NETDEV_LOG_OPSET_3G4G_CFG                   = 701;              /* 3G/4G  set3g4g */
		public static final int	NETDEV_LOG_OPSET_MOUNT_EXTENDED_DISK        = 702;              /*  Mount extended disk*/
		public static final int	NETDEV_LOG_OPSET_UNMOUNT_EXTENDED_DISK      = 703;              /*  Unmount extended disk*/
		public static final int	NETDEV_LOG_OPSET_FORCE_USER_OFFLINE         = 704;              /*  Force user off line*/

		public static final int	NETDEV_LOG_OPSET_AUTO_FUNCTION              = 709;              /*   autoFunction */
		public static final int	NETDEV_LOG_OPSET_IPC_UPRAGDE                = 710;              /*   ipcUpgrade */
		public static final int	NETDEV_LOG_OPSET_RESTORE_IPC_DEFAULTS       = 711;              /*   restoreIpcDefaults */
		public static final int	NETDEV_LOG_OPSET_ADD_TRANSACTION            = 712;              /*   addTransaction */
		public static final int	NETDEV_LOG_OPSET_MOD_TRANSACTION            = 713;              /*   modifyTransaction */
		public static final int	NETDEV_LOG_OPSET_DEL_TRANSACTION            = 714;              /*   deleteTransaction */
		public static final int	NETDEV_LOG_OPSET_POS_OSD                    = 715;              /* POS  setPosOsd */
		public static final int	NETDEV_LOG_OPSET_ADD_HOT_SPACE_DEV          = 716;              /*   addHotSpaceDevice */
		public static final int	NETDEV_LOG_OPSET_DEL_HOT_SPACE_DEV          = 717;              /*   deleteHotSpaceDevice */
		public static final int	NETDEV_LOG_OPSET_MOD_HOT_SPACE_DEV          = 718;              /*   modifyHotSpaceDevice */
		public static final int	NETDEV_LOG_OPSET_DEL_WORK_DEV               = 719;              /*   deleteWorkDevice */
		public static final int	NETDEV_LOG_OPSET_WORKMODE_TO_NORMAL_CFG     = 720;              /*   SetWorkModeToNormal */
		public static final int	NETDEV_LOG_OPSET_WORKMODE_TO_HOTSPACE_CFG   = 721;              /*   SetWorkModeToHotSpace */
		public static final int	NETDEV_LOG_OPSET_AUTO_GUARD_CFG             = 723;              /*   setAutoGuard */
		public static final int	NETDEV_LOG_OPSET_MULTICAST_CFG              = 724;              /*   SetMulticast */
		public static final int	NETDEV_LOG_OPSET_DEFOCUS_DETECT_CFG         = 725;              /*  Set defocus detection*/
		public static final int	NETDEV_LOG_OPSET_SCENECHANGE_CFG            = 726;              /*  Set scene change detection*/
		public static final int	NETDEV_LOG_OPSET_AUTO_TRCAK_CFG             = 727;              /*  Set auto tracking*/
		public static final int	NETDEV_LOG_OPSET_SORT_CAMERA_CFG            = 728;              /*  Sort camera*/
		public static final int	NETDEV_LOG_OPSET_WATER_MARK_CFG             = 729;              /*  Set watermark*/

		/* VMS */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_ALL                     = 1000;    /*  All Sub Operate Log */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGIN              = 1001;    /*  User Login */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGOUT             = 1002;    /*  User Logout */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USER_START_OPERATION    = 1003;    /*  User Start Operation */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USER_STOP_OPERATION     = 1004;    /*  User Stop Operation */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_NEW_CONFIG              = 1005;    /*  New Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_EDIT_CONFIG             = 1006;    /*  Edit Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CONFIG           = 1007;    /*  Delete Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_ENABLE_CONFIG           = 1008;    /*  Enable Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_DISABLE_CONFIG          = 1009;    /*  Disable Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_TEST_CONFIG             = 1010;    /*  Test Config */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_OPEN_DOOR               = 1011;    /*  Open Door */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_CLOSE_DOOR              = 1012;    /*  Close Door */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_SARM                    = 1013;    /*  Arm */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_DISARM                  = 1014;    /*  Disarm */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_BYPASS                  = 1015;    /*  Bypass */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_UNBYPASS                = 1016;    /*  UnBypass */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_SHARE_DEVICE            = 1017;    /*  Share Device */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_UN_SHARE_DEVICE         = 1018;    /*  Un Share Device */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_START_CAP_PAC_TASK      = 1019;    /*  Start Cap Pac Task */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_STOP_CAP_PAC_TASK       = 1020;    /*  Stop Cap Pac Task */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CAPPAC_TASK      = 1021;    /*  Delete Cap Pac Task */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USB_INSERT              = 1022;    /* USB USB Insert */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USB_PULL_OUT            = 1023;    /* USB USB Pull Out */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_USB_FORMAT              = 1024;    /* USB USB Format */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_SYNC_DEV_CHL_INFO       = 1025;    /*  Sync Dev Chl Info */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_LOCK           = 1026;    /*  Playback Lock */
		public static final int	NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_UNLOCK         = 1027;     /*  Playback Unlock */

	}

	/**
	 * @brief    Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S extends Structure {
		public	int                                      udwIsPoEPort;                                 /* PoE, 0-, 1- */
		public	int                                      udwPoEStatus;                                   /* PoE   NETDEV_POE_STATUS_E */
		public	byte[]                                        szAccessAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];     /* , [0, 63]NVR */
		public	byte[]                                        szMACAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];        /* MAC, [0, 63], NVR */
		public	byte[]                                        szDDNSAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];       /* DDNS[0,64] */
		public	int                                      udwOffReason;                                   /*    NETDEV_CHN_OFF_REASON_E */
		public	int                                      udwRemoteIndex;                                 
		public	byte[]                                        szGBID = new byte[NETDEV_LEN_32];                          /* [0, 31] */
		public	int                                      udwAddType;                                     /* , 0-, 1-*/
		public	int                                      udwOrgID;                                       /* ID, */
		public	int                                      udwDevID;                                       /* ID, */
		public	byte[]                                        szDevName = new byte[NETDEV_LEN_64];                       /* [0, 64] */
		public	int                                      udwChlIndex;                                    /* ID, */
		public	int                                      udwAudioResID;                                  /* ID, */

		public	byte[]                        byRes = new byte[512];                          /*   Reserved field*/
	}

	/**
	 * @enum tagNETDEVChnOffReason
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CHN_OFF_REASON_E extends Structure {
		public int	NETDEV_CHN_OFF_REASON_CONNECTING                = 0;                
		public int	NETDEV_CHN_OFF_REASON_ONLINE                    = 1;                
		public int	NETDEV_CHN_OFF_REASON_WRONG_PWD                 = 2;                
		public int	NETDEV_CHN_OFF_REASON_NETWORK_ERROR             = 3;                
		public int	NETDEV_CHN_OFF_REASON_SET_LIVE_STREAM_ERROR     = 4;                
		public int	NETDEV_CHN_OFF_REASON_START_LIVE_STREAM_ERROR   = 5;                
		public int	NETDEV_CHN_OFF_REASON_STREAM_INTERUP            = 6;                
		public int	NETDEV_CHN_OFF_REASON_TIMEOUT                   = 7;                
		public int	NETDEV_CHN_OFF_REASON_WAIT_REGIST               = 8;                /* IPC */
		public int	NETDEV_CHN_OFF_REASON_MODIFY_LIVE_STREAM_ERROR  = 9;                /* IPC */
		public int	NETDEV_CHN_OFF_REASON_POE_POWER_ERROR           = 10;               /* PoE */
		public int	NETDEV_CHN_OFF_REASON_BW_RECV_NOT_ENOUGH        = 11;               
		public int	NETDEV_CHN_OFF_REASON_WEAK_PWD_ERROR            = 12;               

		public int	NETDEV_CHN_OFF_REASON_INVALID                   = 0xFF;              
	}

	/**
	 * @enum tagNETDEVPoEStatus
	 * @brief POE
	 * @attention  None
	 */
	public static class NETDEV_POE_STATUS_E extends Structure {
		public int	NETDEV_POE_STATUS_NORMAL                = 1;                
		public int	NETDEV_POE_STATUS_POWER_SHORTAGE        = 2;                
		public int	NETDEV_POE_STATUS_POWER_OVERLOAP        = 4;                
		public int	NETDEV_POE_STATUS_NONEED_POWER          = 8;                

		public int	NETDEV_POE_STATUS_INVALID               = 0xFF;              
	}
	/**
	 * @enum  NETDEV_ALARM_SRC_BELONG_TYPE_E
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_ALARM_SRC_BELONG_TYPE_E extends Structure{
		public static final int NETDEV_ALARM_SRC_BELONG_TYPE_OTHER                     = 0;            
		public static final int NETDEV_ALARM_SRC_BELONG_TYPE_CHL                       = 1;            
		public static final int NETDEV_ALARM_SRC_BELONG_TYPE_DEV                       = 2;            
		public static final int NETDEV_ALARM_SRC_BELONG_TYPE_INVALID                   = 0xffff;        
	}
	
	/**
	* @brief  Device capability commond
	* @attention 
	*/
	public class NETDEV_CAPABILITY_COMMOND_E extends Structure {
		public static final int  NETDEV_CAP_VIDEO_ENCODE         = 1;            /*  # NETDEV_VIDEO_STREAM_CAP_S。 Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_S for reference*/
	    public static final int	 NETDEV_CAP_OSD                  = 2;            /* OSD # NETDEV_OSD_CAP_S。 OSD parameter capability. See # NETDEV_OSD_CAP_S for reference*/
	    public static final int	 NETDEV_CAP_SMART                = 3;            /*  # NETDEV_SMART_CAP_S。 Smart capability. See # NETDEV_SMART_CAP_S for reference */
	    public static final int	 NETDEV_CAP_VIDEO_ENCODE_EX      = 4;            /*  # NETDEV_VIDEO_STREAM_CAP_EX_S。 Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_EX_S for reference */
	    public static final int	 NETDEV_CAP_IMAGE                = 5;            /*  #NETDEV_IMAGE_CAP_S。 Image capability See # NETDEV_IMAGE_CAP_S for reference*/
	    public static final int	 NETDEV_CAP_AUDIO                = 6;            /*   NETDEV_AUDIO_CAP_S */
	    public static final int	 NETDEV_CAP_VIDEO_SNAPSHOT       = 7;            /*  #NETDEV_VIDEO_SNAP_CAP_S Video snapshot capability. See # NETDEV_VIDEO_SNAP_CAP_S for reference   IPC*/
		public static final int  NETDEV_CAP_FACE_RECOGNAZE       = 10;           /*  NVR, NETDEV_DEV_FACE_CAP_INFO_S */
		public static final int  NETDEV_CAP_DEV_NIC              = 11;           /* , NETDEV_NIC_CAP_INFO_S */
	    public static final int  NETDEV_CAP_DEV_EXCEPTION_ALARM  = 12;           /* , # NETDEV_EXCP_ALARM_CAP_INFO_S */
		public static final int  NETDEV_CAP_CHANNELS_ALARM       = 13;           /* ,  NETDEV_CHN_ALARM_CAP_INFO_S */
		public static final int  NETDEV_CAP_SYS                  = 14;           /*   NETDEV_SYS_CAPABILITY_S  */
	    public static final int  NETDEV_CAP_INVALID              = 0Xff;        
	}
	
	/**
	 * @enum tagNETDEVLangType
	 * @brief 
	 * @attention
	 */
	public class NETDEV_LANG_TYPE_E extends Structure {
		public static final int         NETDEV_LANG_TYPE_CHINESE             = 0;                           
		public static final int  	    NETDEV_LANG_TYPE_ENGLISH             = 1;                           
		public static final int  	    NETDEV_LANG_TYPE_TRADITIONAL_CHINESE = 2;                           
		public static final int  	    NETDEV_LANG_TYPE_FRENCH              = 3;                           
		public static final int  	    NETDEV_LANG_TYPE_GERMAN              = 4;                           
		public static final int  	    NETDEV_LANG_TYPE_SPANISH             = 5;                           
		public static final int  	    NETDEV_LANG_TYPE_ITALIAN             = 6;                           
		public static final int  	    NETDEV_LANG_TYPE_PORTUGUESE          = 7;                           
		public static final int  	    NETDEV_LANG_TYPE_RUSSIAN             = 8;                           
		public static final int  	    NETDEV_LANG_TYPE_UKRAINIAN           = 9;                           
		public static final int  	    NETDEV_LANG_TYPE_GRUANIAN            = 10;                          
		public static final int  	    NETDEV_LANG_TYPE_DUTCH               = 11;                          
		public static final int  	    NETDEV_LANG_TYPE_DANISH              = 12;                          
		public static final int  	    NETDEV_LANG_TYPE_FINNISH             = 13;                          
		public static final int  	    NETDEV_LANG_TYPE_SWEDISH             = 14;                          
		public static final int  	    NETDEV_LANG_TYPE_NORWEGIAN           = 15;                          
		public static final int  	    NETDEV_LANG_TYPE_LCELANDIC           = 16;                          
		public static final int  	    NETDEV_LANG_TYPE_POLISH              = 17;                          
		public static final int  	    NETDEV_LANG_TYPE_LITHUANIAN          = 18;                          
		public static final int  	    NETDEV_LANG_TYPE_GREEK               = 19;                          
		public static final int  	    NETDEV_LANG_TYPE_CZECH               = 20;                          
		public static final int  	    NETDEV_LANG_TYPE_SLOVAK              = 21;                          
		public static final int  	    NETDEV_LANG_TYPE_HUNGARIAN           = 22;                          
		public static final int  	    NETDEV_LANG_TYPE_ROMAN               = 23;                          
		public static final int  	    NETDEV_LANG_TYPE_SERBIAN             = 24;                          
		public static final int  	    NETDEV_LANG_TYPE_CROATIAN            = 25;                          
		public static final int  	    NETDEV_LANG_TYPE_SLOVENIAN           = 26;                          
		public static final int  	    NETDEV_LANG_TYPE_BULGARIAN           = 27;                          
		public static final int  	    NETDEV_LANG_TYPE_BELARUSIAN          = 28;                          
		public static final int  	    NETDEV_LANG_TYPE_TURKISH             = 29;                          
		public static final int  	    NETDEV_LANG_TYPE_ARABIC              = 30;                          
		public static final int  	    NETDEV_LANG_TYPE_HEBREW              = 31;                          
		public static final int  	    NETDEV_LANG_TYPE_HINDI               = 32;                          
		public static final int  	    NETDEV_LANG_TYPE_BENGALI             = 33;                          
		public static final int  	    NETDEV_LANG_TYPE_PERSIAN             = 34;                          
		public static final int  	    NETDEV_LANG_TYPE_JAPANESE            = 35;                          
		public static final int  	    NETDEV_LANG_TYPE_KOREAN              = 36;                          
		public static final int  	    NETDEV_LANG_TYPE_THAI                = 37;                          
		public static final int  	    NETDEV_LANG_TYPE_MALAYSIAN           = 38;                          
		public static final int  	    NETDEV_LANG_TYPE_INDONESIAN          = 39;                          
		public static final int  	    NETDEV_LANG_TYPE_FILIPINO            = 40;                          
		public static final int  	    NETDEV_LANG_TYPE_LAO                 = 41;                          
		public static final int  	    NETDEV_LANG_TYPE_VIETNAMESE          = 42;                          
		public static final int  	    NETDEV_LANG_TYPE_MONGOLIAN           = 43;                          
		public static final int  	    NETDEV_LANG_TYPE_ALBANIAN            = 44;                          
		public static final int  	    NETDEV_LANG_TYPE_AZERBAIJANI         = 45;                          
		public static final int  	    NETDEV_LANG_TYPE_GAELIC              = 46;                          
		public static final int  	    NETDEV_LANG_TYPE_ESTONIAN            = 47;                          
		public static final int  	    NETDEV_LANG_TYPE_BOSNIAN             = 48;                          
		public static final int  	    NETDEV_LANG_TYPE_LOWLAND_SAXON       = 49;                          
		public static final int  	    NETDEV_LANG_TYPE_PERUVIAN            = 50;                          
		public static final int  	    NETDEV_LANG_TYPE_LATVIAN             = 51;                          
		public static final int  	    NETDEV_LANG_TYPE_INVALID             = 0xFF;                        
	}
	
	/**
	 * @struct NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S
	 * @brief    Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S extends Structure {
		public int                  dwChannelID;                        /* ID  Channel ID */
		public int                  bPtzSupported;                      /*  Whether ptz is supported */
		public int     				enStatus;       /*   Channel status NETDEV_CHANNEL_STATUS_E */
		public int                  dwStreamNum;                        /*   Number of streams enStatus NETDEV_CHL_STATUS_UNBIND */
		public int       			enChannelType;                      /* (note: NVR) NETDEV_CHANNEL_TYPE_E*/
		public int     				enVideoFormat;                      /* NETDEV_CHANNEL_TYPE_EChannelTypeNETDEV_CHL_TYPE_DIGITAL (note: NVR) */
		public int           		enAddressType;                      /* IP , NETDEV_HOSTTYPE_E*/
		public byte[]               szIPAddr =new byte[NETDEV_IPADDR_STR_MAX_LEN];/* IP IP address*/
		public int                  dwPort;                             
		public byte[]				szChnName =new byte[NETDEV_LEN_64];;           /*  Channel Name */
		public int                  allowDistribution;                   
		public int                  dwDeviceType;                       /*   NETDEV_CHANNEL_CAMERA_TYPE_E. Channel device Type see#NETDEV_CHANNEL_CAMERA_TYPE_E */
		public byte[]				szManufacturer =new byte[NETDEV_LEN_32];      /* [0,31] */
		public byte[]               szDeviceModel =new byte[NETDEV_LEN_32];       /* [0,31]  */
		public int                  udwAccessProtocol;                  /*   NETDEV_ACCESS_PROTOCOL_E */
		public Pointer	pstExtendedInformation;            /* ,    NETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S*/
		public byte[]   			byRes = new byte[16];                          /*   Reserved field*/
	}

	/**
	 * @struct NETDEV_PICTURE_DATA_S
	 * @brief   Image data Structure definition
	 *         Storing pointer and length of decoded picture data
	 * @attention  None
	 */
	public class NETDEV_PICTURE_DATA_S extends Structure {
		public Pointer[] pucData =new Pointer[4];                /* pucData[0]:Y ,pucData[1]:U ,pucData[2]:V   pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
		public int[]   dwLineSize = new int[4];              /* ulLineSize[0]:Y, ulLineSize[1]:U, ulLineSize[2]:V  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
		public int   dwPicHeight;                /*   Picture height */
		public int   dwPicWidth;                 /*   Picture width */
		public int   dwRenderTimeType;           /*   Time data type for rendering */
		public long   tRenderTime;                /*   Time data for rendering */
	}

	/**
	 * @struct NETDEV_DISCOVERY_DEVINFO_S
	 * @brief   Info of discovered device
	 * @attention  None
	 */
	public class NETDEV_DISCOVERY_DEVINFO_S extends Structure {
		public byte[] szDevAddr =new byte[NETDEV_LEN_64];                /* pucData[0]:Y ,pucData[1]:U ,pucData[2]:V   pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
		public byte[]     szDevModule =new byte[NETDEV_LEN_64];                          /*   Device model */
		public byte[]     szDevSerailNum =new byte[NETDEV_LEN_64];                       /*   Device serial number */
		public byte[]     szDevMac =new byte[NETDEV_LEN_64];                             /* MAC  Device MAC address */
		public byte[]     szDevName =new byte[NETDEV_LEN_64];                            /*   Device name */
		public byte[]     szDevVersion =new byte[NETDEV_LEN_64];                         /*   Device version */
		public int  	  enDevType;                              /*   Device type  NETDEV_DEVICE_TYPE_E*/
		public int   	  dwDevPort;                                           /*   Device port number */
		public byte[]     szManuFacturer =new byte[NETDEV_LEN_64];                       /*  Device manufacture */
		public byte[]     szActiveCode =new byte[NETDEV_LEN_64];                         /*  activeCode */
		public byte[]     szCloudUserName =new byte[NETDEV_LEN_64];                       /*  cloudUserName */
		public byte[]     byRes =new byte[68];                /*   Time data for rendering */
	}

	/**
	 * @brief   Audio data Structure definition
	 *         Storing pointer and length of decoded picture data
	 * @attention  None
	 */
	public class NETDEV_WAVE_DATA_S extends Structure {
		public Pointer pcData;                      /*   Audio data pointer */
		public int dwDataLen;                    /*   Audio data length */
		public int dwWaveFormat;                 /*   Format of decoded audio*/
	}

	/**
	 * @brief   Live image information Structure definition
	 * @attention 0-10,0-255 Gamma parameter range: 0-10, other parameters: 0-255
	 */
	public class NETDEV_VIDEO_EFFECT_S extends Structure {
		public int  dwContrast;                   /*   Contrast */
		public int  dwBrightness;                 /*   Brightness */
		public int  dwSaturation;                 /*   Saturation */
		public int  dwHue;                        /*   Hue */
		public int  dwGamma;                      /*   Gamma */
		public byte[]  byRes=new byte[16];                    /*   Reserved */
	}

	/**
	 * @brief   Rectangle Area  Structure definition
	 * @attention  None
	 */
	public class NETDEV_RECT_S extends Structure {
		public int   dwLeft;                               /* x[0,10000]  X axis left point value [0,10000] */
		public int   dwTop;                                /* y[0,10000]  Y axis top point value [0,10000] */
		public int   dwRight;                              /* x[0,10000]  X axis right point value [0,10000] */
		public int   dwBottom;                             /* y[0,10000]  Y axis bottom point value [0,10000] */
	}

	/**
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_PAGE_FIND_LOGIC_S extends Structure {
		public int   dwQueryCond;        /* 0：1：。 */
		public int   dwSubQueryCond;     /* ,:01 */
		public int   dwLogicalType;      /* :  #NETDEV_QUERYCOND_LOGICTYPE_E */
		public byte[]    byRes=new byte[128];         
	}

	/**
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_PAGE_FIND_COND_S extends Structure {

		public int   dwLimitNum;                                          /*  dwSuggestSinglePageQuantily*/
		public int   dwStartID;                                           /* id,id+1id。*/
		public int   dwCondNum;                                           
		public NETDEV_PAGE_FIND_LOGIC_S[]  astFindCond = new NETDEV_PAGE_FIND_LOGIC_S[NETDEV_LEN_16];        /* ,16,0, */
		public byte[] byRes=new byte[128];                                          
	}

	/**
	 * @brief   Cloud Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_CLOUD_DEV_BASIC_INFO_S extends Structure {
		public byte[]    szIPAddr=new byte[NETDEV_IPV4_LEN_MAX];              /* IP Device IP */
		public byte[]    szDevUserName=new byte[NETDEV_LEN_260];              /*  Device username */
		public byte[]    szDevName=new byte[NETDEV_LEN_260];                  /*  Device name */
		public byte[]    szDevModel=new byte[NETDEV_LEN_64];                  /*  Device model */
		public byte[]    szDevSerialNum=new byte[NETDEV_LEN_64];              /*  Device serial number */
		public int   dwOrgID;                                    /* ID Home organization ID */
		public int   dwDevPort;                                  /*  Device port */
		public int   dwDevID;                                    /* ID */
		public byte[]    szDevSubName=new byte[NETDEV_LEN_260];               /* ： */
		public int   dwDevType;                                  /* ：  #NETDEV_CLOUD_DEVICE_TYPE  Device type, see enumeration #NETDEV_CLOUD_DEVICE_TYPE */
		public int    bKeepLiveStatus;                            /* ：truefalse */
		public int    bIsShareDev;                                /* truefalse */
		public int   dwValidityShareTime;                        /* 。“3600.00000002014-2-27 9:22-2-27 10:22。true。*/
		public byte[]    szShareDevUserName=new byte[NETDEV_LEN_260];         /* bIsShareDevtrue */
		public int   dwConnectMode;                              /*  Connect Mode*/
		public int   dwDisTributeCloud;                          /*      NETDEV_DISTRIBUTE_CLOUD_SRV_E*/
		public int   dwCloudStorageType;                         /*    NETDEV_CLOUD_STORAGE_TYPE_E*/
		public byte[]    byRes=new byte[120];                                 
	}

	/**
	 *@brief 
	 *@attention 
	 */
	public static class NETDEV_LOGIN_PROTO_E extends Structure {
		public static final int   	NETDEV_LOGIN_PROTO_ONVIF = 0;       	  /* ONVIF */
		public static final int   	NETDEV_LOGIN_PROTO_PRIVATE = 1;       	  
	}

	/**
	 * @brief     Cloud Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_CLOUD_DEV_LOGIN_INFO_S extends Structure {
		public byte[]    szDeviceName=new byte[NETDEV_LEN_260];     /*  Device name */
		public byte[]    szDevicePassword=new byte[NETDEV_LEN_64];  /*  () Device login password (optional) */
		public int   dwT2UTimeout;                       			/* P2P, 15s P2P timeout (default: 15s) */
		public int   dwConnectMode;                      			/*  Connect Mode     NETDEV_CLOUD_CONNECT_MODE_E   NETDEV_CLOUD_CONNECT_MODE_ALL*/
		public int 		dwLoginProto; 			/* ,  NETDEV_LOGIN_PROTO_E */
		public byte[]  byRes=new byte[252];                       	
	}

	/**
	 * @enum tagNETDEVCloudConnectMode
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_CLOUD_CONNECT_MODE_E extends Structure {
	    public static final int	NETDEV_CLOUD_CONNECT_MODE_ALL       = 0;         /* ->->-> */
	    public static final int	NETDEV_CLOUD_CONNECT_MODE_P2P_TURN  = 1;         /* ->->+(500ms) */
	    public static final int	NETDEV_CLOUD_CONNECT_MODE_P2P       = 2;         
	    public static final int	NETDEV_CLOUD_CONNECT_MODE_TURN      = 3;          
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TMS_CAR_PLATE_PIC_INFO_S extends Structure {
		public int   	udwPicSize;       	
		public Pointer 	pcPicData; 			
	}

	/**
	 * @brief XML
	 * @attention
	 */
	public class NETDEV_TMS_CAR_PLATE_XML_INFO_S extends Structure {
		public byte[] szCamID=new byte[NETDEV_TMS_CAR_PLATE_CAMID_LEN];                               
		public byte[] szRecordID=new byte[NETDEV_TMS_CAR_PLATE_RECORDID_LEN];                         /* ID */
		public byte[] szTollgateID=new byte[NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN];                       
		public byte[] szPassTime=new byte[NETDEV_TMS_CAR_PLATE_PASSTIME_LEN];                         
		public byte[] szLaneID=new byte[NETDEV_TMS_CAR_PLATE_LANEID_LEN];                             
		public byte[] szCarPlate=new byte[NETDEV_TMS_CAR_PLATE_CARPLATE_LEN];                         
		public byte[] szIPAddr=new byte[NETDEV_IPV4_LEN_MAX];                                         /* IP */
		public int dwCarPlateColor;                                                      /* NETDEV_TMS_CAR_PLATE_COLOR_E*/
		public byte[] bRes=new byte[492];                                                             /*  Reserved */
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TMS_CAR_PLATE_INFO_S extends Structure {
		public int	udwPicNum;                                   							/*  Picture Number */
		public NETDEV_TMS_CAR_PLATE_XML_INFO_S	stTmsXmlInfo;                                /* XML XML Information */
		public NETDEV_TMS_CAR_PLATE_PIC_INFO_S[]	stTmsPicInfo= new NETDEV_TMS_CAR_PLATE_PIC_INFO_S[NETDEV_TMS_PIC_COMMON_NUM];     /*  Picture Message */
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_FACE_POSITION_INFO_S extends Structure {
		public int   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
		public int   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
		public int   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
		public int   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
		public byte[] bRes=new byte[32];           /*  Reserved */
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public static class NETDEV_TMS_PERSION_IMAGE_TYPE_E extends Structure {
		public static final int   	NETDEV_TMS_PERSION_IMAGE_TYPE_FULL_VIEW = 1;         
		public static final int   	NETDEV_TMS_PERSION_IMAGE_TYPE_FACE = 2;              
		public static final int   	NETDEV_TMS_PERSION_IMAGE_TYPE_INVALID=0xFF;
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S extends Structure {
		public int   udwFaceId;                                                          /* ID */
		public Pointer    pcPicBuff;                                                     
		public int   udwPicBuffLen;                                                      
		public int    enImgType;                                                         /* 1: 2： */
		public int  enImgFormat;                                                         /*  NETDEV_TMS_PERSION_IMAGE_FORMAT_E */
		public NETDEV_FACE_POSITION_INFO_S        stFacePos;                             /* ---：0-10000 ;  ："138,315,282,684" */
		public int   udwImageWidth;                                                      
		public int   udwImageHeight;                                                     
		public byte[]     szCamerID=new byte[NETDEV_TMS_CAMER_ID_LEN];                   
		public byte[]     szRecordID=new byte[NETDEV_TMS_FACE_RECORD_ID_LEN];            /* ID */
		public byte[]     szTollgateID=new byte[NETDEV_TMS_FACE_TOLLGATE_ID_LEN];        
		public byte[]     szPassTime=new byte[NETDEV_TMS_PASSTIME_LEN];                  /* ,YYYYMMDDHHMMSSMMM24。MMMMMMM */
		public int   udwFaceNum;                                                         
		public byte[]     szIPAddr=new byte[NETDEV_IPV4_LEN_MAX];                        /* IP */
		public byte[]     bRes=new byte[76];                                             /*  Reserved */
	}

	/**
	 * @brief    Passenger flow statistic infomation Sturcture definition
	 * @attention  None
	 */
	public class NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S extends Structure {
		public int   dwChannelID;            /*  Channel ID */
		public long   tReportTime;            /* unix Report time */
		public int   tInterval;              /*  Interval time */
		public int   dwEnterNum;             /*  Enter num */
		public int   dwExitNum;              /*  Exit num */
		public int   dwTotalEnterNum;        /*  Total enter num */
		public int   dwTotalExitNum;         /*  Total exit nums*/
	}

	/**
	 * @brief    Timeout structure definition
	 * @attention
	 */
	public class NETDEV_REV_TIMEOUT_S extends Structure {
		public int   dwRevTimeOut;                 /*  Set timeout for receiving */
		public int   dwFileReportTimeOut;          /*  Set timeout for file operation */
		public byte[] byRes=new byte[128];                   /*   Reserved */
	}
	
	/**
	 * @struct tagNETDEVAlarmInfoEx
	 * @brief      Object List
	 * @attention  None
	 */
	public class NETDEV_OBJECT_LIST_S extends Structure {
	    public int                      udwObjectType;                      /*   NETDEV_OBJECT_TYPE_E */
	    public int                      udwObjectID;                        /* ID */
	    public byte[] byRes=new byte[256];                                  
	}

	/**
	 * @struct tagNETDEVAlarmInfo
	 * @brief   Alarm information Structure definition
	 * @attention  None
	 */
	public class NETDEV_ALARM_INFO_V30_S extends Structure {
		public int dwAlarmType;                                            /*   #NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
		public int dwAlarmSubType;                                         /*  NETDEV_ALARM_SUBTYPE_E */
		public int dwAlarmLevel;                                           /* 151 */
		public long tAlarmTimeStamp;                                       /*   Alarm occurrence time */
		public int dwChannelID;                                            /* ID,  Channel ID */
		public int dwAlarmID;                                              /* ID */
		public int dwAlarmSrcID;                                           /* ID   #NETDEV_ALARM_SRC_TYPE_E
	                                                                       note:
                                                                            1. dwAlarmSrcType NETDEV_ALARM_SRC_LOCAL_HARD_DISK  NETDEV_ALARM_SRC_SD_STORAGE_DISK dwAlarmID
                                                                            2. dwAlarmSrcType8dwAlarmID
                                                                            3. dwAlarmSrcType9dwAlarmIDdwInputSwitchID。
                                                                            4. dwAlarmSrcType10,dwAlarmID0,
                                                                           */
		public byte[]  szAlarmSrc=new byte[NETDEV_ALARM_SOURCE_MAX_LEN];   
		public int            IsAlarmSnapExisted;                          /*  0 1  vms*/
		public short          wIndex;                                      /*   Index number, index number */
		public int            dwTotalBandWidth;                            /* ,MBps  Current total bandwidth (in MBps) */
		public int            dwUnusedBandwidth;                           /* ,MBps  Bandwidth left (in MBps)*/
		public int            dwTotalStreamNum;                            /*  Total cameras*/
		public int            dwFreeStreamNum;                             /*  Cameras left */
		public int            dwMediaMode;                                 /* ,  #NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
		public int            dwEventCode;                                 /*   # NETDEV_PLAYER_RUN_INFO_TYPE_E */
		public int            dwReserved;                                  
		public byte[]         szFileName = new byte[NETDEV_LEN_256];       /* ND */
		public byte[]         szDeviceID = new byte[NETDEV_LEN_64];        /* ID。[1,32]。IPCVM */
		public byte[]         szRelatedID = new byte[NETDEV_LEN_32];       /* ID,。15. */
		public int            dwObjectNum;                                 /*   Object Num */
		public NETDEV_OBJECT_LIST_S  pstObjectList;                        /*  Object List dwObjectNum */
		public byte[]         byRes = new byte[144];                       
	}

	/**
	 * @enum tagNETDEVPlayerRunInfoType
	 * @brief 
	 * @attention 
	 */
	public static class NETDEV_PLAYER_RUN_INFO_TYPE_E extends Structure {
		public static final int	NETDEV_PLAYER_RUN_INFO_RECORD_VIDEO        = 1;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_PROCESS       = 2;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_SERIES_SNATCH       = 3;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_VOICE         = 4;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_NOT_IDENTIFY  = 5;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_RECV_PACKET_NUM     = 6;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_RECV_BYTE_NUM       = 7;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_VIDEO_FRAME_NUM     = 8;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_AUDIO_FRAME_NUM     = 9;        /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_LOST_PACKET_RATIO   = 10;       /**< 0.01% */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_PROGRESS = 11;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_END      = 12;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_MEDIA_ABNORMAL      = 13;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_CODEC               = 14;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_STREAM              = 15;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_PLAYBACK_FINISH     = 16;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_SNATCH              = 17;       /**<  */
		public static final int	NETDEV_PLAYER_RUN_INFO_INVALID             = 0xff;
	}

	public class NETDEV_EVENT_RES_S extends Structure {
		public int   dwResType;                          /*   #NETDEV_EVENT_RES_TYPE_E */
		public int   dwResID;                            /* ID */
		public int   dwFirstSubResID;                    /* ID */
		public int   dwSecondSubResID;                   /* ID IDIDIDIDIDID*/

		public byte[] byRes=new byte[16];             	 
	}

	/**
	 * @struct tagNETDEVEventInfo
	 * @brief   Alarm information Structure definition
	 * @attention  NETDEV_MAX_EVENT_RES_SIZEpstEventRes
	 */
	public class NETDEV_EVENT_INFO_S extends Structure {
		public int              		dwSize;                                     
		public NETDEV_EVENT_RES_S[]     astEventRes = new NETDEV_EVENT_RES_S[NETDEV_MAX_EVENT_RES_SIZE];     
		public int              		dwEventActionType;                          /*   #NETDEV_EVENT_ACTION_TYPE_E */
		public Pointer    				pstEventRes;                                /*  NETDEV_MAX_EVENT_RES_SIZE NETDEV_EVENT_RES_S */
		public byte[]           		byRes=new byte[28];                       	
	}

	/**
	 * @struct tagNETDEVReportInfo
	 * @brief / 
	 * @attention  None
	 */
	public class NETDEV_REPORT_INFO_S extends Structure {
		public int                  dwReportType;       /*   #NETDEV_REPORT_TYPE_E */
		public NETDEV_ALARM_INFO_V30_S     stAlarmInfo;        /* dwReportType NETDEV_REPORT_TYPE_ALARM  */
		public NETDEV_EVENT_INFO_S         stEventInfo;        /* dwReportType NETDEV_REPORT_TYPE_EVENT  */

	}

	/**
	 * @struct tagstNETDEVExceptionOutputInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_EXCEPTION_OUTPUT_INFO_S extends Structure {
		public int       dwEventCode;       	/* ND */
		public long      tPlayBackTime;        	/* (ND N+M) */
		public byte[]     szFileName = new byte[NETDEV_LEN_256];                       
		public byte[]    byRes=new byte[128];	

	}

	/**
	 * @brief   get video by Month Structure definition
	 * @attention  None
	 */
	public class NETDEV_MONTH_INFO_S extends Structure {
		public int  udwYear;        /*   year*/
		public int  udwMonth;       /*   month */
		public int  udwPosition;    /*  NETDEV_VIDEO_POSITION_E video query location */
	}

	/**
	 * @brief   video status Structure definition
	 * @attention  None
	 */
	public class NETDEV_MONTH_STATUS_S extends Structure {
		public int  udwDayNumInMonth;       /*  The number of a month's days */
		public int[]  szVideoStatus = new int[NETDEV_MONTH_DAY_MAX];       	/*  video status list, see in NETDEV_VIDEO_STATUS_E */
	}

	/**
	 * @struct tagstNETDEVOrgFindCond
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ORG_FIND_COND_S extends Structure {
		public int udwOrgType;              /*   NETDEV_ORG_TYPE_E */
		public int udwRootOrgID;            /* ID */
		public int udwFindType;             /*  NETDEV_ORG_FIND_MODE_E */
		public byte[]    byRes=new byte[128];	
	}

	/**
	 * @struct tagstNETDEVOrgDetailInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ORG_INFO_S extends Structure {
		public int dwOrgID;                              /* ID */
		public int dwParentID;                           /* ID */
		public int dwType;                               /*    NETDEV_ORG_TYPE_E */
		public byte[] szNodeName=new byte[NETDEV_NAME_MAX_LEN];       
		public byte[] szDesc=new byte[NETDEV_DESCRIBE_MAX_LEN];       
		public int udwTime;                              /* UTC */
		public byte[]  szUserName = new byte[NETDEV_LEN_64];             /*  [1,64] */
		public byte[]  byRes=new byte[60];                           
	}

	/**
	 * @struct tagstNETDEVOrgDetailInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEL_ORG_INFO_S extends Structure
	{
		public int dwOrgNum;     
		public Pointer pdwOrgIDs;   /* IDdwOrgNum (int) */
		public int dwOrgType;    /*   NETDEV_ORG_TYPE_E */
		public byte[]  byRes=new byte[64];    /*   Reserved field*/
	}

	/**
	 * @struct tagstNETDEVOperateInfo
	 * @brief 
	 * @attention dwIDdwReturnCode
	 */
	public class NETDEV_OPERATE_INFO_S extends Structure
	{
		public int  dwID;                   /* ID */
		public int  dwReturnCode;           
		public byte[]  byRes=new byte[64];              /*   Reserved field */
	}

	/**
	 * @struct tagstNETDEVOrgDelDetailInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ORG_BATCH_DEL_INFO_S extends Structure
	{
		public int dwStatus;                             /*    NETDEV_ORG_RESPONSE_STAUTE_E */
		public int dwNum;                                
		public Pointer pstResultInfo;      /*(NETDEV_OPERATE_INFO_S)*/
		public byte[]  byRes=new byte[68];                            /*   Reserved field*/
	}

	/**
	 * @struct tagstNETDEVOrgChnInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ORG_CHN_INFO_S extends Structure {
		public int dwOrgID;                              /* ID */
		public int dwChannelID;                          /* ID */
		public byte[] szChnName=new byte[NETDEV_NAME_MAX_LEN];        
		public int dwChnIndex;                           
		public int dwChnType;                            
		public int dwChnStatus;                          
		public int dwDevID;                              /* ID */
		public byte[] szDevName=new byte[NETDEV_NAME_MAX_LEN];        
		public byte[]  byRes=new byte[128];                           
	}

	/**
	 * @struct tagstNETDEVIPAddrInfo
	 * @brief IP
	 * @attention
	 */
	public class NETDEV_IPADDR_INFO_S extends Structure {
		public int   dwType;                            /*   NETDEV_ADDR_TYPE_E */
		public byte[]    szIPAddr=new byte[NETDEV_MAX_URL_LEN];      /* IP/ */
		public int   dwPort;                            
		public byte[]    byRes=new byte[60];                         
	}



	/**
	 * @struct tagstNETDEVUserSimpleInfo
	 * @brief ＋
	 * @attention
	 */
	public class NETDEV_USER_SIMPLE_INFO_S extends Structure {
		public byte[] szUserName=new byte[NETDEV_USERNAME_LEN];       
		public byte[] szPassword=new byte[NETDEV_PASSWORD_LEN];       
		public byte[] byRes=new byte[64];                             
	}

	/**
	 * @brief Onvif
	 * @attention
	 */
	public class NETDEV_ONVIF_INFO_S extends Structure {
		public int   udwTransportMode;                          /*   NETDEV_TRANS_PROTOCOL_E */

		public byte[]  byRes=new byte[128];                                   /*   Reserved field*/
	}

	/**
	 * @struct tagNETDEVGBInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_GBINFO_S extends Structure {
		public byte[]     szUniCode=new byte[NETDEV_LEN_32];      /* [1, 32]*/
		public int   udwTransport;                  /*  0: TCP 1: UDP*/
		public byte[]   byRes=new byte[128];                      
	}

	/**
	 * @struct tagstNETDEVDeviceBasicInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEV_BASIC_INFO_S extends Structure {
		public NETDEV_IPADDR_INFO_S stDevAddr;                             /* IP */
		public NETDEV_USER_SIMPLE_INFO_S stDevUserInfo;                    
		public byte[] szDevName = new byte[NETDEV_NAME_MAX_LEN];           
		public byte[] szDevDesc = new byte[NETDEV_DESCRIBE_MAX_LEN];       
		public byte[] szDevModel = new byte[NETDEV_CODE_STR_MAX_LEN];      
		public int dwDevID;                                                /* ID */
		public int dwDevStatus;                                            /* , # NETDEV_DEVICE_STATUS_E */
		public int dwDevType;                                              /* # NETDEV_DEVICE_MAIN_TYPE_E */
		public int dwDevSubType;                                           /* # NETDEV_DEVICE_SUB_TYPE_E */
		public int dwOrgID;                                                
		public int dwAccessProtocol;                                       /*  # NETDEV_ACCESS_PROTOCOL_E */
		public int dwAccessMode;                                           /*  # NETDEV_DEVICE_ACCESS_MODE_E*/
		public int dwServerID;                                             /* ID */
		public int dwAudioResID;                                           /* ID */
		public int dwIsPTZNeeded ;                                         /*  0:   1:   255:  */
		public byte[]  szVIIDCode = new byte[NETDEV_VIID_CODE_LEN];        /* , */
		public int dwVIIDStatus;                                           /* 0： 1： */
		public byte[] szSerialNum = new byte[NETDEV_LEN_64];               
		public byte[] szSoftVersion = new byte[NETDEV_LEN_128];            
		public byte[] szMacAddr = new byte[NETDEV_LEN_32];                 /* MAC*/
		public int dwStoreStatus;                                          /* 。0:  1:  2: 3: */
		public NETDEV_ONVIF_INFO_S stOnvifInfo;                            /* onvif */
		public NETDEV_GBINFO_S stGBInfo;                                   /*  AccessProtocol3*/
		public Pointer pstSmartLockInfo;                                   /*   #NETDEV_SMART_LOCK_INFO_S# */
		public byte[] szManufacture = new byte[NETDEV_LEN_64];             
		public byte[] szDeviceCode = new byte[NETDEV_LEN_32];              /*  [1,32]   */
		public Pointer  pstPlayerInfo;                                     /*  #NETDEV_IPM_PLAYER_BASIC_INFO_S# Type11 malloc */
		public int  udwCustomProtocolID;                                   /* IDAccessProtocol4 */
		public int  udwChlMaxNum;                                          /* AccessProtocol4 */
		public int  udwChlIndexNum;                                        /* AccessProtocol4256 */
		public Pointer pudwChlIndexList;                                   /* 256 */
	    public int dwImageProtocol;                                        /* Type5 1: 2: */
	}

	/*
	 * @struct tagNETDEVPlayerBasicInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_IPM_PLAYER_BASIC_INFO_S extends Structure {
		public int                          udwPlayerID;                            /* ID */
		public int                          udwVendor;                              /*    NETDEV_DEVICE_IPM_VENDORS_ID_E */
		public int                          udwModel;                               /*    NETDEV_DEVICE_IPM_MODEL_ID_E */
		public byte[]                       szPlayerName = new byte[NETDEV_LEN_128];           /*  [1,64] */
		public int                          udwOrgID;                               /* ID  */
		public byte[]                       szOrgName = new byte[NETDEV_LEN_128];              /*  [1,64]  */
		public byte[]                       szPlayerMngtServerName = new byte[NETDEV_LEN_128]; /*  [1, 64]  */
		public byte[]                       szPlayerMngtServerIP = new byte[NETDEV_LEN_32];    /* IP  */
		public int        					stResolution;                           /*  #NETDEV_XW_RESOLUTION_S# */
		public byte[]                       byRes = new byte[256];                             
}
	/**
	 * @brief IPM ID
	 * @attention  None
	 */
	public static class NETDEV_DEVICE_IPM_MODEL_ID_E extends Structure {
	    public static final int	NETDEV_DEVICE_IPM_MODEL_EDU_B1XX          = 0;            /* EDU-B1XX */
	    public static final int	NETDEV_DEVICE_IPM_MODEL_C                 = 1;            /* C */
	    public static final int	NETDEV_DEVICE_IPM_MODEL_BX_6QX_YD         = 2;            /* BX-6QX-YD */
	    public static final int	NETDEV_DEVICE_IPM_MODEL_BX_5EX            = 3;            /* BX-5EX */

	    public static final int	NETDEV_DEVICE_IPM_MODEL_PSD_100           = 100;          /* PSD-100 */

	    public static final int	NETDEV_DEVICE_IPM_MODEL_UNKNOW            = 0xFF;          
	}


	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_XW_RESOLUTION_S extends Structure {
		public int   udwWidth;       
		public int   udwHeight;      
	}

	/**
	 * @struct tagNETDEVSmartLockInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_SMART_LOCK_INFO_S extends Structure {
		public int udwType;                         /*  0: WIFI 1: NBIoT */
		public int udwSignal;                       /*   NETDEV_LOCK_SIGNAL_E */
		public int udwStatus;                       /*  0：  1：*/
		public int udwBatteryPercent;               /* [0,100] */
		public byte[]   szSN = new byte[NETDEV_LEN_64];             /* [0,20] */
		public byte[]   szIMEI = new byte[NETDEV_LEN_64];           /*  Type1,[1,16] */
		public byte[]   szVersion = new byte[NETDEV_LEN_256];       /*  [1,64] */
		public byte[]   szRoomName = new byte[NETDEV_LEN_480];      /*  [1, 128]*/
		public byte[]   byRes = new byte[128];                      
	}

	/**
	 * @struct tagstNETDEVDevChnBaseInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEV_CHN_BASE_INFO_S extends Structure {
		public int dwChannelID;                                      /* ID */
		public int dwDevID;                                          /* ID */
		public int dwOrgID;                                          /* ID */
		public int dwChnType;                                        /*   NETDEV_CHN_TYPE_E */
		public int dwChnStatus;                                      /* ,   NETDEV_CHN_STATUS_E */
		public int dwChnIndex;                                       
		public byte[] szChnName=new byte[NETDEV_NAME_MAX_LEN];                    
		public int udwRight;                                        
		public int udwAbnormalReason;                               /*   NETDEV_CHN_OFFLINE_REASON_E */
		public byte[]   byRes=new byte[124];                                      
	}

	/**
	 * @struct tagNETDEVStreamFormatInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_STREAM_FORMAT_INFO_S extends Structure {
		public int		udwStreamIndex;             /*   NETDEV_LIVE_STREAM_INDEX_E */
		public int   	udwEncodeFormat;            /*   NETDEV_VIDEO_CODE_TYPE_E */
		public byte[] 	byRes=new byte[128]; 		
	}

	/**
	 * @struct tagstNETDEVDevChnEncodeInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEV_CHN_ENCODE_INFO_S extends Structure {
		public NETDEV_DEV_CHN_BASE_INFO_S  	stChnBaseInfo;                                  
		public int                       	dwMaxStream;                                    
		public NETDEV_STREAM_FORMAT_INFO_S[] astStreamFormatList=new NETDEV_STREAM_FORMAT_INFO_S[NETDEV_STREAM_MAX_NUM];     
		public int		bSupportPTZ;                              	
		public int   	bScrambleEnable;                         	
		public int   	dwAudioResID;                           	/* ID */
		public byte[]  	szGBResID=new byte[NETDEV_LEN_32];       	/* ID */
		public byte[] 	byRes=new byte[224];                  		
	}

	/**
	 * @brief   PTZ preset information Structure definition
	 * @attention  None
	 */
	public class NETDEV_PTZ_PRESET_S extends Structure {
		public int   dwPresetID;                                 /* ID  Preset ID */
		public byte[]    szPresetName=new byte[NETDEV_LEN_32];                /*   Preset name */
	}

	/**
	 * @brief   All PTZ presets Structure definition
	 * @attention  None
	 */
	public class NETDEV_PTZ_ALLPRESETS_S extends Structure {
		public int               dwSize;                             /*   Total number of presets */
		public NETDEV_PTZ_PRESET_S[] astPreset=new NETDEV_PTZ_PRESET_S[NETDEV_MAX_PRESET_NUM];   /*   Structure of preset information */
	}

	/**
	 * @brief   PTZ preset patrol point information Structure definition
	 * @attention  None
	 */
	public class NETDEV_CRUISE_POINT_S extends Structure {
		public int   dwPresetID;     /* ID  Preset ID */
		public int   dwStayTime;     /*   Stay time */
		public int   dwSpeed;        /* ,[1-10]  Speed [1-10] */
		public int   dwID;           /* ID */
	}


	/**
	 * @brief   PTZ preset patrol route information Structure definition
	 * @attention  None
	 */
	public class NETDEV_CRUISE_INFO_S extends Structure {
		public int  	dwCuriseID;                                     /* ID  Route ID */
		public byte[]	szCuriseName=new byte[NETDEV_LEN_32];                    /*   Route name */
		public int    	dwSize;                                         /*   Number of presets included in the route */
		public NETDEV_CRUISE_POINT_S[] astCruisePoint=new NETDEV_CRUISE_POINT_S[NETDEV_MAX_CRUISEPOINT_NUM];     /*    Information of presets included in the route */

	}

	/**
	 * @brief   PTZ preset patrol route list Structure definition
	 * @attention  None
	 */
	public class NETDEV_CRUISE_LIST_S extends Structure {
		public int                   dwSize;                                         /*   Number of patrol routes */
		public NETDEV_CRUISE_INFO_S[]    astCruiseInfo=new NETDEV_CRUISE_INFO_S[NETDEV_MAX_CRUISEROUTE_NUM];      /*   Information of patrol routes */
	}

	/**
	 * @brief  
	 * @attention 
	 */
	public class NETDEV_CHN_PERMISSION_INFO_S extends Structure {
		public int     dwChannelID;             
		public int     dwPermission;            /* , #NETDEV_CHN_PERMISSION_TYPE_E */
		public byte[]  byRes = new byte[256];   /*   Reserved */
	}

	/**
	 * @brief
	 * @attention
	 */
	public class NETDEV_USER_DETAIL_INFO_S extends Structure {
		public int      udwLevel;                                          /*      NETDEV_USER_LEVEL_E*/
		public byte[]   szUserName=new byte[NETDEV_LEN_64];                /*   1~18*/
		public byte[]	szPassword=new byte[NETDEV_LEN_256];               /*   0~256 */
		public int      udwBasePermission;                                 /*   NETDEV_USER_BASE_PERMISSION_E BITBIT10*/
		public int      udwNum;                                            
		public NETDEV_CHN_PERMISSION_INFO_S[]   astChnPermission = new NETDEV_CHN_PERMISSION_INFO_S[NETDEV_CHANNEL_MAX];              
		public byte[]	byRes= new byte[256];                                        
	}

	/**
	 * @brief
	 * @attention
	 */
	public class NETDEV_USER_MODIFY_DETAIL_INFO_S extends Structure {
		public NETDEV_USER_DETAIL_INFO_S      stUserInfo;
		public int   	bIsModifyPassword;                       	/* ,  */
		public int    	bIsModifyOther;                          	/* ,  */
		public byte[]	szNewPassword=new byte[NETDEV_LEN_256];   	/* ()0~256  */
		public byte[]	szCurrentPassword=new byte[NETDEV_LEN_256];	/*   0~256 */
		public byte[] 	byRes=new byte[256];                        
	}

	/**
	 * @brief
	 * @attention
	 */
	public class NETDEV_USER_DETAIL_LIST_S extends Structure {
		public int                      udwNum;                          
		public NETDEV_USER_DETAIL_INFO_S[]   astUserInfo = new NETDEV_USER_DETAIL_INFO_S[NETDEV_LEN_64];     
		public byte[] byRes = new byte[128];                      
	}

	/**
	 * @brief   Recording query Structure definition
	 *        . Query recording files according to file type and time
	 * @attention  None
	 */
	public class NETDEV_FILECOND_S extends Structure {
		public byte[]    szFileName=new byte[NETDEV_LEN_64];      /*   Recording file name */
		public int   dwChannelID;                    /*   Channel ID */
		public int   dwStreamType;                   /* ,  #NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
		public int   dwFileType;                     /* ,  #NETDEV_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_STORE_TYPE_E */
		public long  tBeginTime;                     /*   Start time */
		public long  tEndTime;                       /*   End time */
		public int   dwRecordLocation;               /*  Record Position,   #NETDEV_RECORD_LOCATION_E */
		public int   udwServerID;                    /* ID Video server ID */
		public byte[]    byRes=new byte[28];                      /*   Reserved */
	}

	/**
	 * @brief   Recording query data Structure definition
	 *         Get the information of found files one by one
	 * @attention  None
	 */
	public class NETDEV_FINDDATA_S extends Structure {
		public byte[]    szFileName=new byte[NETDEV_FILE_NAME_LEN];		/*   Recording file name */
		public long   tBeginTime;                                     	/*   Start time */
		public long   tEndTime;                                       	/*   End time */
		public char    byFileType;                                     	/*     #NETDEV_STORE_TYPE_E Recording storage type #NETDEV_STORE_TYPE_E */
		public int  udwServerID;                                    	/* ID */
		public int  udwFileSize;                                    	/*  Recording file size */
		public int  dwFileType;                                         /* # NETDEV_RECORD_SEARCH_TYPE_E  */
		public byte[]    byRes=new byte[159];                      		/*   Reserved */
	}

	/**
	 * @brief   Parameters of play back by time Structure definition
	 * @attention  None
	 */
	public class NETDEV_PLAYBACKCOND_S extends Structure {
		public int   dwChannelID;                /*   Playback channel */
		public long   tBeginTime;                 /*   Playback start time */
		public long   tEndTime;                   /*   Playback end time */
		public int   dwLinkMode;                 /*   #NETDEV_TRANS_PROTOCAL_E */
		public Pointer  hPlayWnd;                   /*   Play window handle */
		public int   dwFileType;                 /*   #NETDEV_STORE_TYPE_E  */
		public int   dwDownloadSpeed;            /*    #NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
		public int   dwStreamMode;               /*   #NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
		public int   dwStreamIndex;              /* ,   #NETDEV_LIVE_STREAM_INDEX_E */
		public int   dwRecordLocation;           /*  Record Position,   #NETDEV_RECORD_LOCATION_E */
		public int   dwTransType;                /*   #NETDEV_TRANS_TYPE_E */
		public int    bCloudStorage;              
		public int    bOneFrameEnable;            
		public int   dwPlaySpeed;                /*  #NETDEV_VOD_PLAY_STATUS_E  Playback speed, see enumeration #NETDEV_VOD_PLAY_STATUS_E*/
		public NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK;       /*  NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF Decode data callback function */
		public long   tPlayTime;                  /*   Playback time */
		public int  udwServerID;                /* ID Video server ID */
		public byte[]    byRes=new byte[212];                 
	}

	/**
	 * @brief   Basic device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_DEVICE_BASICINFO_S extends Structure {
		public byte[] szDevModel=new byte[NETDEV_LEN_64];                     /*   Device model */
		public byte[] szSerialNum=new byte[NETDEV_LEN_64];                    /*   Hardware serial number */
		public byte[] szFirmwareVersion=new byte[NETDEV_LEN_64];              /*   Software version */
		public byte[] szMacAddress=new byte[NETDEV_LEN_64];                   /* IPv4Mac  MAC address of IPv4 */
		public byte[] szDeviceName=new byte[NETDEV_LEN_64];                   /*   Device name */
		public byte[] szManufacturer=new byte[NETDEV_LEN_64];                 /*   Manufacturer */

		public byte[] byRes=new byte[384];                                    /*   Reserved */
	}

	/**
	 * @brief   Address Structure definition
	 * @attention  None
	 */
	public class NETDEV_SYSTEM_IPADDR_S extends Structure {
		public int   eIPType;                            /*   #NETDEV_HOSTTYPE_E  Protocol type, see enumeration #NETDEV_HOSTTYPE_E */
		public byte[]    szIPAddr=new byte[NETDEV_LEN_132];           /* IP  IP address */
	}

	/**
	 * @brief  NTP NTP parameter
	 * @attention  None
	 */
	public class NETDEV_SYSTEM_NTP_INFO_S extends Structure {
		public int bSupportDHCP;                      /* DHCP  Support DHCP or not */
		public NETDEV_SYSTEM_IPADDR_S stAddr;          /* NTP   NTP information */
	}

	public class NETDEV_SYSTEM_IPADDR_INFO_S extends Structure {
		public int         bEnabled;                      /*NTP 0：  1：  NTP Server enable 0:unable  1:enable */
		public long        ulAddressType;                    /* 0：IPv4  1：IPv6()  2: NVR Address type  0:IPv4  1:IPv6(Temporary does not support)  2:domain name(NVR and AIO support)*/
		public byte[] szIPAddress=new byte[NETDEV_LEN_64];     /* NTPIP[0, 64] AddressType 0
	                                                 The IP address of the NTP server ,character length range [0,64]. When address type is 0,the node must be selected. */
		public byte[]szDomainName=new byte[NETDEV_LEN_64];    /*NTP[ [0 64] AddressType 2
	                                                 The domain name of the NTP server ,character length range [0,64]. When address type is 2,the node must be selected.*/
		public long         ulPort;                        /*NTP[1-65535]  IPC。 NTP Port ,the range of [1-65535]. IPC does not support this configuration. */
		public long         ulSynchronizeInterval;         /* NVRVMS： 5/10/15/301/2/3/6/12h11。IPC：30-3600s。
	                                                 Synchronize Interval: The support range of NVR and VMS is 5/10/15/30 minutes ,1/2/3/6/12 hours ,1 day ,and 1 week.The support range of IPC is 30-3600 seconds.
	                                                 All of the above time periods need to be converted to a time value in seconds.*/
		public byte[] byRes=new byte[128];                    /*  Reserved*/
	}

	public class NETDEV_SYSTEM_NTP_INFO_LIST_S extends Structure {
		public long   ulNum;                                             /*NTP  NTP Server Number*/
		public NETDEV_SYSTEM_IPADDR_INFO_S[] astNTPServerInfoList=new NETDEV_SYSTEM_IPADDR_INFO_S[NETDEV_NTP_SERVER_LIST_NUM];  /*NTPNTP The NTP server list currently supports only one NTP server.*/
		public byte[] byRes=new byte[128];
	}

	/**
	 * @brief   Channel video stream information Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_STREAM_INFO_S extends Structure {
		public int enStreamType;       /*  NETDEV_LIVE_STREAM_INDEX_E, Stream index */
		public int bEnableFlag;        /*   Enable or not */
		public int dwHeight;           /* -Height  Video encoding resolution - Height */
		public int dwWidth;            /* -Width  Video encoding resolution - Width */
		public int dwFrameRate;        /*   Video encoding configuration frame rate */
		public int dwBitRate;          /*   Bit rate */
		public int enCodeType;         /*   NETDEV_VIDEO_CODE_TYPE_E, Video encoding format */
		public int enQuality;          /*  NETDEV_VIDEO_QUALITY_E, Image quality */
		public int dwGop;              /* I  I-frame interval */
		public int bConstantBitRate;   /*  0: 1: Constant Bit Rate or Variable bit rate;0:Variable 1:Constant*/
		public byte[] byRes=new byte[28];          /*   Reserved */
	}

	/**
	 * @brief  Video encoding parameter
	 * @attention
	 */
	public class NETDEV_VIDEO_ENCODE_INFO_S extends Structure {
		public int bEnableSVCMode;                        /* SVC,0：,1： SVC configuration. 0-Off, 1-On*/
		public int udwEncodeFormat;                     /*   NETDEV_VIDEO_CODE_TYPE_E。  Video Compression. For enumeration, seeNETDEV_VIDEO_CODE_TYPE_E*/
		public int udwWidth;                            /*  Image width*/
		public int udwHeight;                           /*  Image height*/
		public int udwBitrate;                          /*  Bit rate*/
		public int udwBitrateType;                      /*  NETDEV_BIT_RATE_TYPE_E。 Bitrate type. See NETDEV_BIT_RATE_TYPE_E for reference */
		public int udwFrameRate;                        /*  Frame rate*/
		public int udwGopType;                          /* Gop, NETDEV_GOP_TYPE_E。 GOP mode. See NETDEV_GOP_TYPE_E for reference */
		public int udwIFrameInterval;                   /* I I Frame Interval. The range depends on capability*/
		public int udwImageQuality;                     /* [1, 9]9 Image quality, ranges from 1 to 9. 9 means the highest quality*/
		public int udwSmoothLevel;                      /* [1,9]1 Smoothing level, ranges from 1 to 9. 1 means the lowest level*/
		public int udwSmartEncodeMode;                  /*  NETDEV_SMART_ENCODE_MODE_E。 Smart encoding mode. See NETDEV_SMART_ENCODE_MODE_E for reference*/
	}

	/**
	 * @brief (LAPI) Video stream info(LAPI)
	 * @attention
	 */
	public class NETDEV_VIDEO_STREAM_INFO_EX_S extends Structure {
		public int bEnabled;                                                                  /*  Enable encoding for video stream or not*/
		public int udwStreamID;                                                             /*   NETDEV_LIVE_STREAM_INDEX_E。 Stream index. For enumeration, seeNETDEV_LIVE_STREAM_INDEX_E*/
		public int udwMainStreamType;                                                       /*  NETDEV_MAIN_STREAM_TYPE_E。 Main stream. See NETDEV_MAIN_STREAM_TYPE_E for reference */
		public NETDEV_VIDEO_ENCODE_INFO_S stVideoEncodeInfo;                                   /*  Video encoding parameter*/
	}

	/**
	 * @brief  Video stream list
	 * @attention
	 */
	public class NETDEV_VIDEO_STREAM_INFO_LIST_S extends Structure {
		public int udwNum;                                                              /*  Number of video stream*/
		public NETDEV_VIDEO_STREAM_INFO_EX_S[] astVideoStreamInfoList = new NETDEV_VIDEO_STREAM_INFO_EX_S[NETDEV_LEN_16];        /*  Video stream list*/
	}

	/**
	 * @brief  Video mode capability
	 * @attention
	 */
	public class NETDEV_VIDEO_MODE_INFO_S extends Structure {
		public int udwWidth;                                      /*  Image width*/
		public int udwHeight;                                     /*  Image height*/
		public int udwFrameRate;                                  /*  Image frame rate*/
	}

	/**
	 * @brief   Area
	 * @attention  None
	 */
	public class NETDEV_AREA_SCOPE_S extends Structure {
		public int  dwLocateX;             /** x[0,10000] * Coordinates of top point x [0,10000] */
		public int  dwLocateY;             /** y[0,10000] * Coordinates of top point y [0,10000] */
	}

	/**
	 * @brief OSD OSD time configuration information
	 * @attention  None
	 */
	public class NETDEV_OSD_TIME_S extends Structure {
		public int                    bEnableFlag;        /** OSD, BOOL_TRUE,BOOL_FALSE * Enable time OSD, BOOL_TRUE means enable and BOOL_FALSE means disable */
		public int                    bWeekEnableFlag;    /** () * Display week or not (reserved) */
		public NETDEV_AREA_SCOPE_S     stAreaScope;        /**  * Area coordinates */
		public int                  udwTimeFormat;      /** OSD, NETDEV_OSD_TIME_FORMAT_CAP_E * Time OSD format, see NETDEV_OSD_TIME_FORMAT_E */
		public int                  udwDateFormat;      /** OSD, NETDEV_OSD_DATE_FORMAT_CAP_E * Date OSD format, see NETDEV_OSD_TIME_FORMAT_E */
	}

	/**
	 * @brief OSD OSD text overlay information
	 * @attention
	 */
	public class NETDEV_OSD_TEXT_OVERLAY_S extends Structure {
		public int  				bEnableFlag;                /** OSD, BOOL_TRUE,BOOL_FALSE * Enable OSD text overlay, BOOL_TRUE means enable and BOOL_FALSE means disable */
		public NETDEV_AREA_SCOPE_S	stAreaScope;                /** OSD * OSD text overlay area coordinates */
		public byte[]            	szOSDText=new byte[NETDEV_OSD_TEXT_MAX_LEN];    /** OSD * OSD text overlay name strings */
		public byte[]            	byRes=new byte[4];                               /*   Reserved */
	}

	/**
	 * @brief OSD Basic channel OSD information
	 * @attention
	 */
	public class NETDEV_VIDEO_OSD_CFG_S extends Structure {
		public NETDEV_OSD_TIME_S         stTimeOSD;        /* OSD  Information of channel time OSD */
		public NETDEV_OSD_TEXT_OVERLAY_S stNameOSD;        /* OSD  Information of channel name OSD */
		public short                     wTextNum;         /* OSD  Text OSD number */
		public NETDEV_OSD_TEXT_OVERLAY_S[] astTextOverlay=new NETDEV_OSD_TEXT_OVERLAY_S[NETDEV_OSD_TEXTOVERLAY_NUM];   /* OSD  Information of channel OSD text overlay */
	}

	/**
	 * @struct tagNETDEVChlOsdCfg
	 * @brief OSD
	 * @attention
	 */
	public class NETDEV_CHL_OSD_CFG_S extends Structure {
		public int dwOsdID;                                      /* OSD ID */
		public int enOsdTextType;               /* OSD,NETDEV_OSD_TEXT_TYPE_E */
		public NETDEV_AREA_SCOPE_S stAreaScope;                    /* OSD */
		public byte[] szTextInfo=new byte[NETDEV_OSD_TEXT_MAX_LEN];           /* OSD */
	}

	/**
	 * @struct tagNETDEVChlOsdCfgList
	 * @brief OSD
	 * @attention
	 */
	public class NETDEV_CHL_OSD_CFG_LIST_S extends Structure {
		public int dwSize;                                               /* OSD */
		public NETDEV_CHL_OSD_CFG_S[] stChlOsdCfg=new NETDEV_CHL_OSD_CFG_S[NETDEV_OSD_MAX_NUM_EX];    /* OSD */
	}

	/**
	 * @brief  Content
	 * @attention
	 */
	public class NETDEV_CONTENT_INFO_S extends Structure {
		public int udwContentType;                        /* OSD,  NETDEV_OSD_CONTENT_TYPE_E OSD content type. For enumeration, see NETDEV_OSD_CONTENT_TYPE_E*/
		public byte[]   szOSDText=new byte[NETDEV_OSD_TEXT_MAX_LEN];    /* OSD OSD text*/
	}

	/**
	 * @brief OSD Channel OSD content
	 * @attention
	 */
	public class NETDEV_OSD_CONTENT_INFO_S extends Structure {
		public int   bEnabled;                                        /* OSD Enable OSD area*/
		public int udwOSDID;                                        /* OSD[0,7] Area No., ranges from 0 to 7.*/
		public int udwAreaOSDNum;                                   /* OSD Number of OSD in current area*/
		public int udwTopLeftX;                                     /* OSD,[0,9999] X-axis of OSD area, ranges from 0 to 999*/
		public int udwTopLeftY;                                     /* OSD,[0,9999] Y-axisof OSD area, ranges from 0 to 999*/
		public NETDEV_CONTENT_INFO_S[] astContentInfo=new NETDEV_CONTENT_INFO_S[NETDEV_LEN_8];     /* OSD OSD content in current area*/
	}

	/**
	 * @brief OSD All contents of channel OSD
	 * @attention
	 */
	public class NETDEV_OSD_CONTENT_S extends Structure {
		public int                    udwNum;                          /* OSD Number of OSD area*/
		public NETDEV_OSD_CONTENT_INFO_S[] astContentList=new NETDEV_OSD_CONTENT_INFO_S[NETDEV_LEN_32];   /* OSD Content list of OSD area*/
	}

	/**
	 * @brief OSD Display Style of channel OSD
	 * @attention
	 */
	public class NETDEV_OSD_CONTENT_STYLE_S extends Structure {
		public int udwFontStyle;                         /*   NETDEV_OSD_FONT_STYLE_E。  Font style. For enumeration, seeNETDEV_OSD_FONT_STYLE_E*/
		public int udwFontSize;                          /*   NETDEV_OSD_FONT_SIZE_E。  Font Size. For enumeration, seeNETDEV_OSD_FONT_SIZE_E*/
		public int udwColor;                             /*  Color*/
		public int udwDateFormat;                        /*   NETDEV_OSD_DATE_FORMAT_E。  Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
		public int udwTimeFormat;                        /*   NETDEV_OSD_TIME_FORMAT_E。  Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
		public int[] audwFontAlignList=new int[NETDEV_LEN_8];      /* 8IPC,  NETDEV_OSD_ALIGN_E。  Font align in area, 8 areasfixed, IPcamera supported. For enumeration, seeNETDEV_OSD_ALIGN_E */
		public int udwMargin;                            /* IPC  NETDEV_OSD_MIN_MARGIN_E。  Number of character with margin, IP camera supported. For enumeration, seeNETDEV_OSD_MIN_MARGIN_E */
	}

	/**
	 * @brief    Alarm boolean outputs info Structure definition
	 * @attention  None
	 */
	public class NETDEV_ALARM_OUTPUT_INFO_S extends Structure {
		public byte[]	szName=new byte[NETDEV_LEN_64];                  /*   Boolean name */
		public int   dwChancelId;                            /*  Channel ID */
		public int   enDefaultStatus;                        /*   #NETDEV_BOOLEAN_MODE_E  Default status of boolean output, see enumeration #NETDEV_BOOLEAN_MODE_E */
		public int   dwDurationSec;                          /*   S  Alarm duration (s) */
		public int   dwOutputNum;                            /*  Alarm output serial number */
	}

	/**
	 * @brief    All Alarm boolean outputs info Structure definition
	 * @attention  None
	 */
	public class NETDEV_ALARM_OUTPUT_LIST_S extends Structure {
		public int                        dwSize;                                                 /*    Number of booleans  */
		public NETDEV_ALARM_OUTPUT_INFO_S[]  astAlarmOutputInfo=new NETDEV_ALARM_OUTPUT_INFO_S[NETDEV_MAX_ALARM_OUT_NUM];           /*   Boolean configuration information */
	}

	/**
	 * @brief    Trigger boolean output alarm Structure definition
	 * @attention  None
	 */
	public class NETDEV_TRIGGER_ALARM_OUTPUT_S extends Structure {
		public byte[]	szName=new byte[NETDEV_LEN_64];        /*   Boolean name */
		public int  enOutputState;      /* , #NETDEV_RELAYOUTPUT_STATE_E  Trigger status, see enumeration #NETDEV_RELAYOUTPUT_STATE_E */
	}

	/**
	 * @struct tagNETDEVStructAlarmInfo
	 * @brief 
	 * @attention  None
	 */
	class NETDEV_STRUCT_ALARM_INFO_S extends Structure
	{
		public byte[]   szReference = new byte[NETDEV_LEN_260];                   
		public int udwTimeStamp;                                  /*  1970110 */
		public int udwSeq;                                        
		public int udwSrcID;                                      /* ID */
		public byte[]   szSrcName = new byte[NETDEV_LEN_260];                     
		public int udwNotificationType;                           /*  0： 1： */
		public byte[]   szDeviceID = new byte[NETDEV_LEN_32];                     /* ID。[1,32] */
		public byte[]   szRelatedID = new byte[NETDEV_LEN_64];                    /* ID。15 */
		public byte[]   byRes = new byte[32];                                    
	}
	
	/**
     * @struct tagNETDEVPointInfo
     * @brief 
     * @attention  None
     */
    class NETDEV_POINT_INFO_S extends Structure
    {
        
        public int udwX;                                /* X[0,10000]  */ 
        public int udwY;                                /* Y[0,10000] */                                                          
        public byte[]   byRes = new byte[32];           
    }
    
    /**
     * @struct tagNETDEVRuleInfo
     * @brief 
     * @attention  None
     */
    class NETDEV_RULE_INFO_S extends Structure
    {
        
        public int udwRuleType;                                /*   NETDEV_RULE_TYPE_E */ 
        public int udwTrigerType;                              /*   NETDEV_RULE_TRIGGER_TYPE_E */                                    
        public int udwPointNum;                                                                 
        public Pointer  pstPointInfo;                          /* ,0  NETDEV_POINT_INFO_S  */                         
        public byte[]   byRes = new byte[64];                  
    }

	/**
	 * @struct tagNETDEVFaceAttr
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_FACE_ATTR_S extends Structure
	{
		public int udwGender;                                     /*   NETDEV_GENDER_TYPE_E */
		public int udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
		public int udwGlassFlag;                                  /*   NETDEV_GLASS_FLAG_E */
		public int udwGlassesStyle;                               /*   NETDEV_GLASSES_STYLE_E */
		public int udwMask;                                       /*   NETDEV_MASK_FLAG_E */
		public float fTemperature;                                /*  ： ：2 */
		public int udwEmotion;                                    /*   NETDEV_EMOTION_FLAG_E */
		public int udwSmile;                                      /*   NETDEV_SMILE_FLAG_E */
		public int udwAttractive;                                 /*  [0~100] */
		public int udwSkinColor;                                  /*   NETDEV_SKINCOLOR_TYPE_E */
		public int udwBeard;                                      /*   NETDEV_BEARD_FLAG_E */
		public byte[]   byRes = new byte[112];                    
	}

	/**
     * @struct tagNETDEVFaceStructInfo
     * @brief 
     * @attention  None
     */
	public class NETDEV_FACE_STRUCT_INFO_S extends Structure
	{
		public int udwFaceID;                                     /* ID */
		public int udwFaceDoforPersonID;                          /* ID */
		public byte[]   szPosition = new byte[64];                     
		public int udwSmallPicAttachIndex;                        
		public int udwLargePicAttachIndex;                        
		public byte[]   szFeaturVersion = new byte[64];                
		public byte[]   szFeature = new byte[1024];                    /*  base64 512 Bytes */
		public NETDEV_FACE_ATTR_S stFaceAttr;                        
		public Pointer  pstRuleInfo;                              /*      NETDEV_RULE_INFO_S */ 
        public byte[]   byRes = new byte[124];                    
	}

	/**
	 * @struct tagNETDEVPersonAttr
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_ATTR_S extends Structure
	{
		public int udwGender;                                     /*   NETDEV_GENDER_TYPE_E */
		public int udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
		public int udwSleevesLength;                              /*   NETDEV_SLEEVES_LENGTH_E */
		public int udwCoatColor;                                  /*   NETDEV_CLOTHES_COLOR_E */
		public int udwTrousersLength;                             /*   NETDEV_TROUSERS_LENGTH_E */
		public int udwTrousersColor;                              /*   NETDEV_CLOTHES_COLOR_E */
		public int udwBodyToward;                                 /*   NETDEV_BODY_TOWARD_E */
		public int udwShoesTubeLength;                            /*   NETDEV_SHOES_TUBE_LENGTH_E */
		public int udwHairLength;                                 /*   NETDEV_HAIR_LENGTH_E */
		public int udwBagFlag;                                    /*   NETDEV_BAG_FLAG_E */
		public float  fTemperature;                               /*  ： ：2 */
		public int udwMask;                                       /*   NETDEV_PERSON_MASK_FLAG_E */
		public int udwCoatTexture;                                /*   NETDEV_CLOTHES_TEXTURE_E */
		public int udwMovingDirection;                            /*   NETDEV_MOVE_DIRECTION_E */
		public byte[]   byRes = new byte[116];                    
	}

     /**
	 * @enum tagNETDEVTrousersLength
	 * @brief 
	 * @attention
	 */
	public static class NETDEV_TROUSERS_LENGTH_E extends Structure
	{
	    public static final int	NETDEV_TROUSERS_LENGTH_UNKNOW                           = 0;                 
	    public static final int	NETDEV_TROUSERS_LENGTH_SHORT                            = 1;                 
	    public static final int	NETDEV_TROUSERS_LENGTH_LONG                             = 2;                 
	    public static final int	NETDEV_TROUSERS_LENGTH_INVALID                          = 0xFF;               
	}

	/**
	 * @struct tagNETDEVPersonStructInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_STRUCT_INFO_S extends Structure
	{
		public int udwPersonID;                                   /* ID */
		public int udwPersonDoforFaceID;                          /* ID */
		public byte[]   szPosition = new byte[64];                     
		public int udwSmallPicAttachIndex;                        
		public int udwLargePicAttachIndex;                        
		public byte[]   szFeaturVersion = new byte[64];                
		public byte[]   szFeature = new byte[1024];                    /*  base64 512 Bytes */
		public NETDEV_PERSON_ATTR_S stPersonAttr;                    
		public Pointer  pstRuleInfo;                              /*     NETDEV_RULE_INFO_S */
		public byte[]   byRes = new byte[124];                                    
	}

	/**
	 * @struct tagNETDEVNonMotorVehicleAttr
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_NO_MOTOR_VEH_ATTR_S extends Structure
	{
		public int udwSpeedType;                                  /*   NETDEV_SPEED_TYPE_E */
		public int udwImageDirection;                             /*   NETDEV_IMAGE_DIRECTION_E */
		public int udwNonVehicleType ;                            /*   NETDEV_NON_VEH_TYPE_E */
	    public byte[]   byRes = new byte[128];                    
	}

	/**
	 * @struct tagNETDEVNonMotorVehInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_NON_MOTOR_VEH_INFO_S extends Structure
	{
		public int udwID;                                         /* ID */
		public byte[]   szPosition = new byte[64];                     
		public int udwSmallPicAttachIndex;                        
		public int udwLargePicAttachIndex;                        
		public NETDEV_NO_MOTOR_VEH_ATTR_S stNoMotorVehAttr;          
		public int udwPersonOnNoVehiNum;                          
		public Pointer pstPersonAttr;                 /*   NETDEV_PERSON_ATTR_S   */
		public Pointer  pstRuleInfo;                              /*     NETDEV_RULE_INFO_S */
		public byte[]   byRes = new byte[124];                                    
	}

	/**
	 * @struct tagNETDEVVehAttr
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_VEH_ATTR_S extends Structure
	{
		public int udwType;                                       /*   NETDEV_VEHICLE_TYPE_E */
		public int udwColor;                                      /*   NETDEV_PLATE_COLOR_E */
		public int udwSpeedUnit;                                  /*  0：/ 1：/ */
		public float  fSpeedValue;                                   
		public int udwSpeedType;                                  /*   NETDEV_SPEED_TYPE_E */
		public byte[]   szVehicleBrand = new byte[64];                 /* ) */
		public int udwImageDirection;                             /*   NETDEV_IMAGE_DIRECTION_E */
		public byte[]   byRes = new byte[128];                                    
	}

	/**
	 * @struct tagNETDEVPlateAttr
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PLATE_ATTR_S extends Structure
	{
		public byte[]   szPlateNo = new byte[64];                      
		public int udwColor;                                      /*   NETDEV_PLATE_COLOR_E */
		public int udwType;                                       /*   NETDEV_PLATE_TYPE_E */
		public byte[]   byRes = new byte[128];                                    
	}

	/**
	 * @struct tagNETDEVVehicleInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_VEH_INFO_S extends Structure
	{
		public int udwID;                                         /* ID */
		public byte[]   szPosition = new byte[64];                     
		public int udwSmallPicAttachIndex ;                       
		public int udwLargePicAttachIndex;                        
		public int udwPlatePicAttachIndex;                        
		public byte[]   szFeatureVersion = new byte[64];               
		public byte[]   szFeature = new byte[1024];                    /*  base64 512 Bytes */
		public NETDEV_VEH_ATTR_S stVehAttr;                          
		public NETDEV_PLATE_ATTR_S stPlateAttr;                      
		public Pointer  pstRuleInfo;                              /*     NETDEV_RULE_INFO_S */
		public byte[]   byRes = new byte[124];                                    
	}

	/**
	 * @struct tagNETDEVObjectInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_OBJECT_INFO_S extends Structure
	{
		public int udwFaceNum;                                    
		public Pointer pstFaceInfo;              /*   NETDEV_FACE_STRUCT_INFO_S   */
		public int udwPersonNum;                                  
		public Pointer pstPersonInfo;          /*    NETDEV_PERSON_STRUCT_INFO_S   */
		public int udwNonMotorVehNum;                             
		public Pointer pstNonMotorVehInfo;     /*   NETDEV_NON_MOTOR_VEH_INFO_S   */
		public int udwVehicleNum;                                 
		public Pointer pstVehInfo;                       /*   NETDEV_VEH_INFO_S   */
		public byte[]   byRes = new byte[128];                                    
	}

	/**
	 * @struct tagNETDEVStructImageInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_STRUCT_IMAGE_INFO_S extends Structure
	{
		public int udwIndex;                                      
		public int udwType;                                       
		public int udwFormat;                                     /*   NETDEV_IMAGE_FORMAT_E*/
		public int udwWidth;                                      
		public int udwHeight;                                     
		public int udwCaptureTime;                                
		public byte[]   szUrl = new byte[260];                         /* URL */
		public int udwSize;                                       /* base64 3M */
		public Pointer  pszData;                                          /* CHAR*base64 */
		public byte[]   byRes = new byte[128];                                    
	}

	/**
	 * @struct tagNETDEVStructDataInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_STRUCT_DATA_INFO_S extends Structure
	{
		public NETDEV_OBJECT_INFO_S stObjectInfo;                    
		public int udwImageNum;                                   
		public Pointer pstImageInfo;            /*   NETDEV_STRUCT_IMAGE_INFO_S   */
		public byte[]   byRes = new byte[128];                                    
	}
	
	/**
     * @struct tagNETDEVAlarmRelatedData
     * @brief  Alarm Related Data
     * @attention  None
     */
    class NETDEV_ALARM_RELATED_DATA_S extends Structure
    {
        public NETDEV_STRUCT_DATA_INFO_S stStructDataInfo;                           
        public byte[]                    byRes = new byte[1024];                     
    }

	/**
	 * @brief     Alarm boolean inputs info Structure definition
	 * @attention  None
	 */
	public class NETDEV_ALARM_INPUT_INFO_S extends Structure {
		public byte[]  szName=new byte[NETDEV_LEN_64];                /*    Name of input alarm */
	}

	/**
	 * @brief     All Alarm boolean inputs info Structure definition
	 * @attention  None
	 */
	public class NETDEV_ALARM_INPUT_LIST_S extends Structure {
		public int dwSize;                                           /*   Number of input alarms */
		public NETDEV_ALARM_INPUT_INFO_S[] astAlarmInputInfo = new NETDEV_ALARM_INPUT_INFO_S[NETDEV_MAX_ALARM_IN_NUM];       /*   Configuration information of input alarms */
	}

	/**
	 * @brief  ()
	 * @attention  None
	 */
	public class NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S extends Structure {
		public int   dwBooleanId;                            /*   Boolean ID */
		public int   dwChannelId;                            /* ID,0 */
		public int   enAlarmStatus;                          /*   #NETDEV_RELAYOUTPUT_STATE_E */
	}

	/**
	 * @brief  ()
	 * @attention  None
	 */
	public class NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S extends Structure {
		public int		dwSize;                                                       /*    Number of booleans  */
		public NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S[]  astOutputAlarmStatusInfo=new NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S[NETDEV_MAX_ALARM_OUT_NUM];           /*  Output switches alarm status list*/
		public byte[]	bRes=new byte[128];                                                    /*  Reserved */
	}

	/**
	 * @brief  ()
	 * @attention  None
	 */
	public class NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S extends Structure {
		public int  	dwSize;                                             /*    Number of booleans  */
		public int[]	dwIDList=new int[NETDEV_MAX_ALARM_OUT_NUM];         /*  booleans ID list */
		public int  	dwAlarmAction;                  /*  NETDEV_MANUAL_ALARM_CMD_E*/
		public byte[]	bRes=new byte[128];                                 /*  Reserved */
	}

	/**
	 * @brief   Parameters of play back recordings by file name Structure definition
	 * @attention  None
	 */
	public class NETDEV_PLAYBACKINFO_S extends Structure {
		public byte[]	szName=new byte[NETDEV_LEN_260];/*   Playback control block name*/
		public long   	tBeginTime;                     /*   Playback start time */
		public long   	tEndTime;                       /*   Playback end time */
		public int   	dwLinkMode;                     /* ,  #NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
		public Pointer  hPlayWnd;                       /*   Play window handle */
		public int   	dwFileType;                     /* ,  #NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
		public int   	dwDownloadSpeed;                /*    #NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
		public int   	dwStreamMode;                   /*    #NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
		public byte[]  	byRes=new byte[252];                     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVPointS
	 * @brief 
	 * @attention
	 */
	public class NETDEV_POINT_S extends Structure {
		public int dwPointX;     /* , */
		public int dwPointY;     /* , */
	}

	/**
	 * @brief 
	 * @attention 
	 */
	public class NETDEV_AUDIO_SAMPLE_PARAM_S extends Structure {
		public int dwChannels;       	/* ,1,2 */
		public int dwSampleRate;   		
		public int enSampleFormat;    	/*    NETDEV_AUDIO_SAMPLE_FORMAT_E*/
	}

	/**
	 * @brief     input switch quantity alert information
	 * @attention  None
	 */
	public class NETDEV_INPUT_SWITCH_INFO_S extends Structure {
		public int 		dwChancelId;                   	/*  Channel ID */
		public int   	dwInputSwitchIndex;            	/*   Input Switch Index*/
		public byte[]	szName=new byte[NETDEV_LEN_64];	/*    Name of input alarm */
		public byte[] 	szGBID=new byte[NETDEV_LEN_32];	/* ,IPC   International Standard Resource Coding, supported by IPC only */
		public int     	dwRunMode;                     	/*  1: 2：  Alarm Type 1: Open 2: Closed*/
		public int    	dwEnabled;                     	/*  0: 1：  Alarm Enabling 0: No Enabling 1: Enabling*/
		public int    	dwVideoResID;                    /* ID,VMS */
		public byte[]  	bRes=new byte[124];       		/*  Reserved */
	}

	/**
	 * @brief     enter switch quantity alert configuration information list
	 * @attention  None
	 */
	public class NETDEV_INPUT_SWITCH_INFO_LIST_S extends Structure {
		public int                        udwNum;                                /*    Number of input switches  */
		public NETDEV_INPUT_SWITCH_INFO_S[] astInputSwitchesInfo=new NETDEV_INPUT_SWITCH_INFO_S[NETDEV_LEN_1024]; /*   input switches configuration information */
	}

	/**
	 * @brief      Device image settings Structure definition
	 * @attention ：0-255     parameter range: 0-255
	 */
	public class NETDEV_IMAGE_SETTING_S extends Structure {
		public int dwContrast;                   /*   Contrast */
		public int dwBrightness;                 /*   Brightness */
		public int dwSaturation;                 /*   Saturation */
		public int dwSharpness;                  /*   Sharpness */
		public byte[]  	bRes = new byte[252];      /*   Reserved */
	};

	/**
	 * @struct tagNETDEVIrisInfo
	 * @brief        IrisInfo
	 * @attention
	 */
	public class NETDEV_IRIS_INFO_S extends Structure{
		public int udwIris;         /* ,。:160 200 240 280 340 400 480 560 680 800 960 11001400,  1600,  2200*/
		public int udwMinIris;      /*    Iris。。*/
		public int udwMaxIris;      /*    Iris。。*/
		public byte[]  	bRes = new byte[128];       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVShutterInfo
	 * @brief        ShutterInfo
	 * @attention
	 */
	public class NETDEV_SHUTTER_INFO_S extends Structure{
		public int udwShutterTime;                  /*   #NETDEV_SHUTTER_TIME_RANGE_E,  0： 1：*/
		public int udwMinShutterTime;               /*  MinShutter  #NETDEV_SHUTTER_TIME_RANGE_E*/
		public int udwMaxShutterTime;               /*  MaxShutter  #NETDEV_SHUTTER_TIME_RANGE_E*/
		public int udwIsEnableSlowShutter;          /* 0：  1：*/
		public int udwSlowestShutter;               /* ,。*/
		public byte[]  	bRes = new byte[128];                      /*   Reserved */
	}

	/**
	 * @struct tagNETDEVGainInfo
	 * @brief        GainInfo
	 * @attention
	 */
	public class NETDEV_GAIN_INFO_S extends Structure{
		public int udwGain;         /* :db。[1,100]*/
		public int udwMinGain;      /*  ,。1*/
		public int udwMaxGain;      /*  , 。100*/
		public byte[]  	bRes = new byte[128];       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVWideDynamicInfo
	 * @brief        WideDynamicInfo
	 * @attention
	 */
	public class NETDEV_WIDE_DYNAMIC_INFO_S extends Structure{
		public int udwWideDynamicMode;              /*  WideDynamicMode  #NETDEV_WIDE_DYNAMIC_MODE_E*/
		public int udwWideDynamicLevel;             /* 50HZ60HZ。[1, 9]。*/
		public int udwOpenSensitivity;              /* 。。[1, 9]。*/
		public int udwCloseSensitivity;             /* 。。[1, 9]。*/
		public int udwAntiFlicker;                    /* ：0： 1：。*/
		public byte[]  	bRes = new byte[128];                      /*   Reserved */
	}

	/**
	 * @struct tagNETDEVAreaTopLeft
	 * @brief        Upper left Area
	 * @attention
	 */
	public class NETDEV_AREA_TOP_LEFT_S extends Structure{
		public int  dwTopLeftX;     /* ()：: [0, 100]。Upper left corner X [0, 100]  */
		public int  dwTopLeftY;     /* ()：: [0, 100]。Upper left corner Y [0, 100]  */
		public byte[]  	bRes = new byte[128];     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVAreaBotRight
	 * @brief        Lower right Area
	 * @attention
	 */
	public class NETDEV_AREA_BOT_RIGHT_S extends Structure{
		public int  dwBottomRightX;     /* ()：: [0, 100]  Lower right corner x [0, 100] */
		public int  dwBottomRightY;     /* ()：: [0, 100]  Lower right corner y [0, 100] */
		public byte[]  	bRes = new byte[128];        /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMeteringArea
	 * @brief       MeteringArea
	 * @attention
	 */
	public class NETDEV_METERING_AREA_S extends Structure{
		public NETDEV_AREA_TOP_LEFT_S    stAreaTopLeft;           /*   #NETDEV_AREA_TOP_LEFT_S*/
		public NETDEV_AREA_BOT_RIGHT_S   stAreaBotRight;          /*   #NETDEV_AREA_BOT_RIGHT_S*/
		public byte[]  	bRes = new byte[128];                               /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMeteringInfo
	 * @brief        MeteringInfo
	 * @attention
	 */
	public class NETDEV_METERING_INFO_S extends Structure{
		public int udwMeteringMode;                 /* ,。 #NETDEV_DAY_NIGHT_MODE_E*/
		public int udwRefBrightness;                /* 。[0, 100]。*/
		public int udwHoldTime;                     /* 。[0, 60]。*/
		public NETDEV_METERING_AREA_S stMeteringArea;  /*  ,*/
		public byte[]  	bRes = new byte[128];                       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVDayNightInfo
	 * @brief        MeteringInfo
	 * @attention
	 */
	public class NETDEV_DAY_NIGHT_INFO_S extends Structure{
		public int udwDayNightMode;                 /*  DayNightMode   #NETDEV_DAY_NIGHT_MODE_E*/
		public int udwDayNightSensitivity;          /*  DayNightSensitivity [0, 9]。。*/
		public int udwDayNightTime;                 /* 。[3, 120]。。。*/
		public byte[]  	bRes = new byte[128];                       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVImagingExposure
	 * @brief      Device image Exposure Structure definition
	 * @attention
	 */
	public class NETDEV_IMAGE_EXPOSURE_S extends Structure{
		public int                      udwMode;                /*   Exposure Mode  #NETDEV_EXPOSURE_MODE_E*/
		public int                       dwCompensationLevel;    /* ,。[-100,100]. */
		public int                      udwHLCSensitivity;      /* ,[1,9]。  */
		public NETDEV_IRIS_INFO_S          stIrisInfo;             /* 。。*/
		public NETDEV_SHUTTER_INFO_S       stShutterInfo;          /* 。。*/
		public NETDEV_GAIN_INFO_S          stGainInfo;             /* 。*/
		public NETDEV_WIDE_DYNAMIC_INFO_S  stWideDynamicInfo;      /* 。。*/
		public NETDEV_METERING_INFO_S      stMeteringInfo;         /* 。。。*/
		public NETDEV_DAY_NIGHT_INFO_S     stDayNightInfo;         /* 。。*/
		public byte[]  	bRes = new byte[256];             /*   Reserved */
	}

	/**
	 * @enum tagNETDEVExposureMode
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_EXPOSURE_MODE_E extends Structure{
		public static final int	NETDEV_EXPOSURE_MODE_AUTOMATIC          = 0;               
		public static final int	NETDEV_EXPOSURE_MODE_CUSTOM             = 1;               
		public static final int	NETDEV_EXPOSURE_MODE_SHUTTER_PRIORITY   = 2;               
		public static final int	NETDEV_EXPOSURE_MODE_APERTURE_PRIORITY  = 3;               
		public static final int	NETDEV_EXPOSURE_MODE_GAIN_PRIORITY      = 4;               
		public static final int	NETDEV_EXPOSURE_MODE_INDOOR_50_HZ       = 5;               /* 50Hz */
		public static final int	NETDEV_EXPOSURE_MODE_INDOOR_60_HZ       = 6;               /* 60Hz */
		public static final int	NETDEV_EXPOSURE_MODE_MANUAL_OPERATION   = 7;               
		public static final int	NETDEV_EXPOSURE_MODE_LOWER_GHOSTING     = 8;               

		public static final int	NETDEV_EXPOSURE_MODE_INVALID            = 0xFF;              
	}

	/**
	 * @struct tagNETDEVLampCtrlInfo
	 * @brief  
	 * @attention
	 */
	public class NETDEV_LAMP_CTRL_INFO_S extends Structure{
		public int udwEnabled;          /* ：0： 1： */
		public int udwType;             /*    #NETDEV_LAMP_TYPE_E*/
		public int udwMode;             /*    #NETDEV_LAMP_CTRL_MODE_E*/
		public int udwNearLevel;        /* ,-,。。[0-1000]。。*/
		public int udwMiddleLevel;      /* ,-。。[0-1000]。。*/
		public int udwFarLevel;         /* ,-。。[0-1000]。。*/
		public int udwSuperFarLevel;    /* ,-。。[0-1000]。。*/
		public int udwLaserAngle;       /* -。。。。*/
		public byte[]  	bRes = new byte[256];           /*   Reserved */
	}

	/**
	 * @enum tagNETDEVLampCtrlMode
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_LAMP_CTRL_MODE_E extends Structure{
		public static final int	NETDEV_LCM_GLOBAL_ATTENTION_AC      = 0;        
		public static final int	NETDEV_LCM_OVEREXPOSE_INHIBIT_AC    = 1;        
		public static final int	NETDEV_LCM_PRESET_ROAD               = 2;        /* - */
		public static final int	NETDEV_LCM_MANUAL_CM                = 3;        
		public static final int	NETDEV_LCM_PRESET_PARK               = 4;        /* -*/
		public static final int	NETDEV_LCM_PHOTOSENS_AM             = 5;        
		public static final int	NETDEV_LCM_INDOOR_AM                = 6;        
		public static final int	NETDEV_LCM_MANUAL_FOM               = 7;        /* -*/
		public static final int	NETDEV_LCM_NIGHT_VIDEO_DET_MODE     = 8;        

		public static final int	NETDEV_LCM_INVALID                  = 0xFF;      
	}

	/**
	 * @enum tagNETDEVLampType
	 * @brief  
	 * @attention  None
	 */
	public static class NETDEV_LAMP_TYPE_E extends Structure{
		public static final int	NETDEV_LAMP_TYPE_WITHOUT            = 0;        
		public static final int	NETDEV_LAMP_TYPE_WHITE              = 1;        
		public static final int	NETDEV_LAMP_TYPE_INFRARED           = 2;        
		public static final int	NETDEV_LAMP_TYPE_LASER_DEVICE       = 3;        
		public static final int	NETDEV_LAMP_TYPE_INFRARED_SHIELD    = 4;        

		public static final int	NETDEV_LAMP_TYPE_INVALID            = 0xFF;      
	}

	/**
	 * @struct tagNETDEVWhiteBalanceInfo
	 * @brief  
	 * @attention
	 */
	public class NETDEV_WHITE_BALANCE_INFO_S extends Structure{
		public int udwMode;             /*    #NETDEV_WHITE_BALANCE_MODE_E*/
		public int dwRedOffset;          /* RedMode[1,5,8]*/
		public int dwBlueOffset;         /* BlueMode[1,5,8]*/
		public byte[]       byRes = new byte[256];           /*   Reserved */
	}

	/**
	 * @brief   Network configuration information
	 * @attention  None
	 */
	public class NETDEV_NETWORKCFG_S extends Structure{
		public int   dwMTU;                              /* MTU  MTU value */
		public int    bIPv4DHCP;                          /* IPv4DHCP  DHCP of IPv4 */
		public byte[]	szIpv4Address = new byte[NETDEV_LEN_32]; /* IPv4IP  IP address of IPv4 */
		public byte[]    szIPv4GateWay = new byte[NETDEV_LEN_32];       /* IPv4  Gateway of IPv4 */
		public byte[]    szIPv4SubnetMask = new byte[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
		public byte[]       byRes = new byte[480];                         /*   Reserved */
	}

	/**
	 * @brief VPN
	 * @attention  None
	 */
	public class NETDEV_VPN_CLIENT_INFO_S extends Structure{
		public int   udwEnabled;                                     /*  0:  1:  Support UNP or nota switch that corresponds to a compatible format, enable 0:unable  1:enable*/
		public int   udwCompatibilityMode;                         /*  0: Unp1.0unp 1: Unp2.0 (softvpn). Corresponds to the set compatibility mode.0: Unp1.0unp 1: Unp2.0 (softvpn) */
		public int   udwAuthEnabled;                                 /* 。Unp2.0。0： 1： Authentication open or close, if is Unp2.0, must authentication and open. 0:close 1:open  */
		public int   udwEncryptEnabled;                              /* , Unp1.0 。0： 1： */
		public int   udwInterface;                                 /* IPC NVRVMS0 ,4G ：1[0,1]*/
		public byte[]     szLoginName = new byte[NETDEV_DOMAIN_LEN];               /* ：AuthEnable。。[0-63]*/
		public byte[]     szPIN = new byte[NETDEV_LEN_256];                        /* ：AuthEnable[0,256],*/
		public int   udwAddressType;
		public byte[]     szAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];         /* AddressType：IP。 0: IPv4 1: IPv6 2: 3: IPv4IPv6.IPv4*/
		public int   udwPort;                                      /* ;NVR VMS[1-65535]Unp1.01701Unp2.0 5555*/
		public int   udwUNPSuccessd;                               /* UNP  (UNPip,,)。1 0 。*/
		public byte[]     szUNPShareIPAddr = new byte[NETDEV_IPADDR_STR_MAX_LEN];  /* UNP  (,) */
		public byte[]     szUNPShareMask = new byte[NETDEV_IPADDR_STR_MAX_LEN];    /* UNP (,) */
		public byte[]     szUNPShareWayAddr = new byte[NETDEV_IPADDR_STR_MAX_LEN]; /* UNP (,) */
		public byte[]       byRes = new byte[256];                                   /*   Reserved*/
	}

	/*
	 * @struct tagDNSAddress
	 * @brief DNS
	 * @attention  None
	 */
	public class NETDEV_DNS_ADDRESS_S extends Structure{
		public int  udwAddressType;                 /*IP 0: IPv4  1: IPv6 3: IPv4IPv6 IPv4 */
		public byte[]   szIPAddress = new byte[NETDEV_LEN_64];      /*IPv4*/
		public byte[]   szIPv6Address = new byte[NETDEV_LEN_64];    /*IPv6*/
		public byte[]       byRes = new byte[128];                      /*   Reserved */
	}

	/*
	 * @struct tagNETDEVDNSInfo
	 * @brief DNS device DNS Info
	 * @attention  None
	 */
	public class NETDEV_DNS_INFO_S extends Structure{
		public int                  udwNum;                             /*DNS*/
		public NETDEV_DNS_ADDRESS_S[]    astDNSList = new NETDEV_DNS_ADDRESS_S[NETDEV_DNS_LIST_NUM];    /*DNS12。2*/
		public byte[]       byRes = new byte[128];                         /*   Reserved */
	}

	/*
	 * @struct tagIpv6Addressinfo
	 * @brief IPV6
	 * @attention  None
	 */
	public class NETDEV_IPV6_ADDRESS_INFO_S extends Structure{
		public int  udwPrefixLenth;             /*[3,127]*/
		public byte[]    szAddress = new byte[NETDEV_LEN_64];   /*IP*/
		public byte[]    szGateway = new byte[NETDEV_LEN_64];   

	}
	/*
	 * @struct tagNetWorkIpv6info
	 * @brief IPV6
	 * @attention  None
	 */
	public class NETDEV_NETWORK_IPV6_INFO_S extends Structure{
		public int                      udwIPGetType;                           /*IP*/
		public int                      udwAddressNum;                          /*IP*/
		public NETDEV_IPV6_ADDRESS_INFO_S[]  astIPv6AddressInfo = new NETDEV_IPV6_ADDRESS_INFO_S[NETDEV_LEN_8];       /*IPv6IPv6*/

	}

	/*
	 * @struct tagIpv4Addressinfo
	 * @brief IPV4
	 * @attention  None
	 */
	public class NETDEV_IPV4_ADDRESS_INFO_S extends Structure{
		public byte[]   szAddress = new byte[NETDEV_LEN_64];                /*IP*/
		public byte[]   szNetmask = new byte[NETDEV_LEN_64];                
		public byte[]   szGateway = new byte[NETDEV_LEN_64];                

	}
	/*
	 * @struct tagIpv4info
	 * @brief IPV4
	 * @attention  None
	 */
	public class NETDEV_NETWORK_IPV4_INFO_S extends Structure{
		public int                      udwIPGetType;                       /*IP 0：for static 1：for PPPOE2：for DHCP*/
		public byte[]                        szLoginName = new byte[NETDEV_LEN_64];         /*PPPoE*/
		public byte[]                        szPIN = new byte[NETDEV_LEN_128];              /*PPPOEMD5*/
		public int                      udwAddressNum;                      /*IP*/
		public NETDEV_IPV4_ADDRESS_INFO_S[]  astIPv4AddressInfo = new NETDEV_IPV4_ADDRESS_INFO_S[NETDEV_LEN_8];   /*IPv4IPv4*/

	}

	/*
	 * @struct tagNETDEVNetworkInterfaceInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_NETWORK_INTERFACE_INFO_S extends Structure{
		public int              udwID;                                             /*VMSIPC1 NVR*/
		public byte[]                szName = new byte[NETDEV_NAME_MAX_LEN];                       /*NVRIPC*/
		public int              udwWorkMode;                                       /* 0： 1：  2：*/
		public int                bIsInnerNIC;                                       
		public byte[]                szInnerNICIPAddress = new byte[NETDEV_IPADDR_STR_MAX_LEN];    /*IP*/
		public byte[]                szInnerNICNetmask = new byte[NETDEV_IPADDR_STR_MAX_LEN];      
		public byte[]                szInnerNICName = new byte[NETDEV_NAME_MAX_LEN];               
		public int              udwMTU;                                            /*MTU[576,1500]*/
		public byte[]                szMAC = new byte[NETDEV_NETWORK_MACNAME_LEN];                 /*MAC[0, 48]*/
		public int              udwNegotiationMode;                                
		public NETDEV_NETWORK_IPV4_INFO_S stIPV4Infos;                                /*IPv4IPv4*/
		public NETDEV_NETWORK_IPV6_INFO_S stIPV6Infos;                                /*IPv6IPv6*/
		public byte[]       byRes = new byte[128];                                        /*   Reserved */
	}

	/*
	 * @struct tagNETDEVNetworkCardsInfo
	 * @brief 。
	 * @attention  None
	 */
	public class NETDEV_NETWORK_CARD_INFO_S extends Structure{
		public int                              udwNum;                                     
		public int                              udwDefaultRouteNIC;                         /*ID*/
		public int                              udwWorkMode;                                /* 0： 1：  2：*/
		public NETDEV_NETWORK_INTERFACE_INFO_S[]     astNetworkInterfaceList = new NETDEV_NETWORK_INTERFACE_INFO_S[NETDEV_LEN_8];      /*Num0*/
		public byte[]       byRes = new byte[128];                                 /*   Reserved */
	}

	/**
	 * @struct tagNETDEVNetworkPortsInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_NETWORK_PORTS_INFO_S extends Structure{
		public int   udwHttpPort;                         /* Http */
		public int   udwHttpsPort;                        /* Https */
		public int   udwRtspPort;                         /* Rtsp */

		public byte[]       byRes = new byte[64];              /*   Reserved field */
	}

	/**
	 * @brief  Definition of area configuration structure
	 * @attention
	 */
	public class NETDEV_PRIVACY_MASK_AREA_INFO_S extends Structure{
		public int   bIsEanbled;           /*   Enable or not. */
		public int   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
		public int   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
		public int   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
		public int   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
		public int   dwIndex;              /*   Index. */
	}

	/**
	 * @brief  Privacy mask configuration information
	 * @attention
	 */
	public class NETDEV_PRIVACY_MASK_CFG_S extends Structure{
		public int                                  dwSize;                                     /*   Mask area number */
		public NETDEV_PRIVACY_MASK_AREA_INFO_S[]        astArea = new NETDEV_PRIVACY_MASK_AREA_INFO_S[NETDEV_MAX_PRIVACY_MASK_AREA_NUM];  /*   Mask area parameters */
	}

	/**
	 * @brief  Tampering detection analysis info
	 * @attention  None
	 */
	public class NETDEV_TAMPER_ALARM_INFO_S extends Structure{
		public int  dwSensitivity;                               /*   Sensitivity */
		public byte[]       byRes = new byte[256];                                  /*   Reserved */
	}

	/**
	 * @brief  Motion detection analysis info
	 * @attention  None
	 */
	public class NETDEV_MOTION_ALARM_INFO_S extends Structure{
		public int  dwSensitivity;                                                     /*   Sensitivity */
		public int  dwObjectSize;                                                      /*   Objection Size */
		public int  dwHistory;                                                         /*   History */
		public short[]  awScreenInfo = new short[NETDEV_SCREEN_INFO_ROW * NETDEV_SCREEN_INFO_COLUMN];                                                  /*   Screen Info  INT16  awScreenInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];*/
		public byte[]       byRes = new byte[64];                                                         /*   Reserved */
	}

	public class NETDEV_CROSS_LINE_POINT_INFO_S extends Structure{
		public int    bEnable;                /*   Supported or not */
		public int   dwSensitivity;        /*   Sensitivity */
		public int   dwDirection;          /*  trigger Direction */
		public int   dwTopLeftX;           /* X [0, 10000]  Upper left corner X [0, 10000]  */
		public int   dwTopLeftY;           /* Y [0, 10000]  Upper left corner Y [0, 10000]  */
		public int   dwBottomRightX;       /* X [0, 10000]  Lower right corner x [0, 10000] */
		public int   dwBottomRightY;       /* Y [0, 10000]  Lower right corner y [0, 10000] */
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CROSS_LINE_ALARM_INFO_S extends Structure{
		public int    bEnable;                                                  /*   Supported or not */
		public NETDEV_CROSS_LINE_POINT_INFO_S[] stAreaInfo = new NETDEV_CROSS_LINE_POINT_INFO_S[4];                       /*  area info */
		public byte[]       byRes = new byte[64];                                                   /*   Reserved */
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_INTRUSION_POINT_INFO_S extends Structure{

		public int   dwPointX;           /* X [0, 10000]*/
		public int   dwPointY;           /* Y [0, 10000]*/
	}


	/**
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_INTRUSION_AREA_INFO_S extends Structure{
		public int    bEnable;                                            /*   Supported or not */
		public int   dwSensitivity;                                      /* 1-100  Sensitivity */
		public int   dwTimeThreshold;                                    /*  1-10*/
		public int   percentage;                                         /*  1-100 */
		public int   dwPointCount;                                       /* 3-6*/
		public NETDEV_INTRUSION_POINT_INFO_S[]   stPointInfo = new NETDEV_INTRUSION_POINT_INFO_S[NETDEV_LEN_6];  
		public byte[]       byRes = new byte[64];                                           /*   Reserved */
	}
	/**
	 * @enum tagNETDEVFindAlarmTypeEn
	 * @brief    Alarm configuration operation Enumeration definition
	 * @attention  None
	 */
	public static class NETDEV_FIND_ALARM_TYPE_E {

		public static final int NETDEV_FIND_ALARM_DISK_STORAGE_IS_FULL               = 1;            
		public static final int NETDEV_FIND_ALARM_DISK_STORAGE_WILL_FULL             = 2;            
		public static final int NETDEV_FIND_ALARM_STOR_ERR                           = 3;            
		public static final int NETDEV_FIND_ALARM_STOR_ERR_RECOVER                   = 4;            
		public static final int NETDEV_FIND_ALARM_MOVE_DETECT                        = 5;            
		public static final int NETDEV_FIND_ALARM_MOVE_DETECT_RECOVER                = 6;            
		public static final int NETDEV_FIND_ALARM_VIDEO_TAMPER_DETECT                = 7;            
		public static final int NETDEV_FIND_ALARM_VIDEO_TAMPER_RECOVER               = 8;            
		public static final int NETDEV_FIND_ALARM_INPUT_SWITCH                       = 9;            
		public static final int NETDEV_FIND_ALARM_INPUT_SWITCH_RECOVER               = 10;           
		public static final int NETDEV_FIND_ALARM_BAND_CHANGE                        = 11;           
		public static final int NETDEV_FIND_ALARM_IMAGE_BLURRY                       = 12;           
		public static final int NETDEV_FIND_ALARM_IMAGE_BLURRY_RECOVER               = 13;           
		public static final int NETDEV_FIND_ALARM_SCENE_CHANGE                       = 14;           
		public static final int NETDEV_FIND_ALARM_ILLEGAL_ACCESS                     = 15;           
		public static final int NETDEV_FIND_ALARM_REPORT_DEV_ONLINE                  = 16;           
		public static final int NETDEV_FIND_ALARM_REPORT_DEV_OFFLINE                 = 17;           
		public static final int NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS              = 18;           
		public static final int NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS_RECOVER      = 19;           
		public static final int NETDEV_FIND_ALARM_COUNT_PEOPLE                       = 20;           
		public static final int NETDEV_FIND_ALARM_HEAT_MAP                           = 21;           
		public static final int NETDEV_FIND_ALARM_LINE_DETECTOR                      = 22;           
		public static final int NETDEV_FIND_ALARM_CELL_MOTION                        = 23;           
		public static final int NETDEV_FIND_ALARM_LINE_CROSS                         = 24;           
		public static final int NETDEV_FIND_ALARM_OBJECTS_INSIDE                     = 25;           
		public static final int NETDEV_FIND_ALARM_ACCESSZONE                         = 26;           
		public static final int NETDEV_FIND_ALARM_LEAVE_ZONE                         = 27;           
		public static final int NETDEV_FIND_ALARM_HOVER_ZONE                         = 28;           
		public static final int NETDEV_FIND_ALARM_OVER_ZONE                          = 29;           
		public static final int NETDEV_FIND_ALARM_CARE_ARTICLE                       = 30;           
		public static final int NETDEV_FIND_ALARM_REMAIN_ARTICLE                     = 31;           
		public static final int NETDEV_FIND_ALARM_FACE_DETECTOR                      = 32;           
		public static final int NETDEV_FIND_ALARM_GATHER                             = 33;           
		public static final int NETDEV_FIND_ALARM_GATHER_RECOVER                     = 34;           
		public static final int NETDEV_FIND_ALARM_FAST_MOVE                          = 35;           
		public static final int NETDEV_FIND_ALARM_ILLEGAL_PARKED                     = 36;           
		public static final int NETDEV_FIND_ALARM_HUMAN_SHAPE_ON                     = 37;           
		public static final int NETDEV_FIND_ALARM_HUMAN_SHAPE_OFF                    = 38;           
		public static final int NETDEV_FIND_ALARM_BODY_TEMPERATURE                   = 39;           
		public static final int NETDEV_FIND_ALARM_NO_MASK                            = 40;           
		public static final int NETDEV_FIND_ALARM_METAL_DETECT_ON                    = 41;           
		public static final int NETDEV_FIND_ALARM_METAL_DETECT_OFF                   = 42;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_MINOR_ON             = 43;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_MINOR_OFF            = 44;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_MAJOR_ON             = 45;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_MAJOR_OFF            = 46;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_CRITICAL_ON          = 47;           
		public static final int NETDEV_FIND_ALARM_CROWD_DENSITY_CRITICAL_OFF         = 48;           

		public static final int NETDEV_FIND_ALARM_INVALID                            = 0xFFFF;        /*   Invalid value */
	}

	/**
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_INTRUSION_ALARM_INFO_S extends Structure{
		public int    bEnable;                                                  /*   Supported or not */
		public NETDEV_INTRUSION_AREA_INFO_S[] stAreaInfo = new NETDEV_INTRUSION_AREA_INFO_S[NETDEV_LEN_4];            /*  4 area info */
		public byte[]       byRes = new byte[64];                                                   /*   Reserved */
	}

	/**
	 * @brief  Disk info
	 * @attention  None
	 */
	public class NETDEV_DISK_INFO_S extends Structure{
		public int dwDiskCabinetIndex;                   
		public int dwSlotIndex;                          /*  Slot Index */
		public int dwTotalCapacity;                      /*  Total Capacity */
		public int dwUsedCapacity;                       /*  Used Capacity */
		public int enStatus;         /*  Status  NETDEV_DISK_WORK_STATUS_E */
		public byte[] szManufacturer = new byte[NETDEV_LEN_32];         /*  Manufacturer */
	}

	/**
	 * @brief  Disk info list
	 * @attention  None
	 */
	public class NETDEV_DISK_INFO_LIST_S extends Structure{
		public int dwSize;                                       /*  Disk number */
		public NETDEV_DISK_INFO_S[] astDisksInfo = new NETDEV_DISK_INFO_S[NETDEV_DISK_MAX_NUM];     /*  Disk info */
	}

	/**
	 * @brief  Focus Info
	 * @attention
	 */
	public class NETDEV_FOCUS_INFO_S extends Structure{
		public int     enFocusMode;                /*  Defogging mode  NETDEV_FOCUS_MODE_E */
		public byte[]       byRes = new byte[16];                   /*  Reserved */
	}

	/**
	 * @brief  IrCut filter info
	 * @attention
	 */
	public class NETDEV_IRCUT_FILTER_INFO_S extends Structure{
		public int enIrCutFilterMode;      /*  IrCut Filter mode NETDEV_IR_CUT_FILTER_MODE_E */
		public byte[]       byRes = new byte[16];               /*  Reserved */
	}

	/**
	 * @brief  Defogging info
	 * @attention
	 */
	public class NETDEV_DEFOGGING_INFO_S extends Structure{
		public int  enDefoggingMode;           /*  Defogging mode NETDEV_DEFOGGING_MODE_E*/
		public float                    fDefoggingLevel;           /*  Defogging level (0.0, 1.0) */
		public byte[]       byRes = new byte[64];                  /*  Reserved */
	}

	/**
	 * @struct tagNETDEVImagingEnhance
	 * @brief      Device image settings Structure definition
	 * @attention udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce ：0-255
	udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce parameter range: 0-255
	 */
	public class NETDEV_IMAGE_ENHANCE_S extends Structure{
		public int udwBrightness;                 /*   Brightness */
		public int udwContrast;                   /*   Contrast */
		public int udwSaturation;                 /*   Saturation */
		public int udwSharpness;                  /*   Sharpness */
		public int udwImageRotation;              
		public int udw2DNoiseReduce;              /* 2D */
		public int udw3DNoiseReduce;              /* 3D */
		public byte[]       byRes = new byte[252];                     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVAudioInputInfo
	 * @brief 
	 * attention None
	 */
	public class NETDEV_AUDIO_INPUT_INFO_S extends Structure{
		public int  dwChannelID;     
		public int udwEnabled;      
		public int udwMode;         /*  #NETDEV_AUDIO_CHL_MODE_E */
		public byte[]       byRes = new byte[128];      
	}

	/**
	 * @struct tagNETDEVAudioInputCfgInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_INPUT_CFG_INFO_S extends Structure{
		public int bIsMute;                                                                   /*  0：1  */
		public int udwType;                                                                 /*  #NETDEV_AUDIO_COLLECTION_PORT_TYPE_E */
		public int udwEncodeFormat;                                                         /*  #NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
		public int udwSampleRate;                                                           /*  #NETDEV_AUDIO_SAMPLING_RATE_E */
		public int udwInputGain;                                                            /* [0,255] */
		public int bNoiseReductionEnabled;                                                    /*  01 */
		public int dwAudioInNum;                                                             
		public NETDEV_AUDIO_INPUT_INFO_S[] astAudioInputInfoList = new NETDEV_AUDIO_INPUT_INFO_S[NETDEV_AUDIO_IN_MAX_NUM];       /* NETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_IN */
		public int dwSerialInNum;                                                            
		public NETDEV_AUDIO_INPUT_INFO_S[] astSerialInputInfoList = new NETDEV_AUDIO_INPUT_INFO_S[NETDEV_SERIAL_IN_MAX_NUM];     
		public byte[]       byRes = new byte[256];                                                               
	}

	/**
	 * @brief   Time configuration structure definition
	 * @attention
	 */
	public class NETDEV_TIME_DST_S extends Structure{
		public int dwMonth;              /* (1~12)  Month(1~12)*/
		public int dwWeekInMonth;        /* N1~5  1 for the first week and 5 for the last week in the month */
		public int dwDayInWeek;          /*  #NETDEV_DAY_IN_WEEK_ENETDEV_DAY_IN_WEEK_E  0 for Sunday and 6 for Saturday see enumeration NETDEV_DAY_IN_WEEK_E */
		public int dwHour;               /*   Hour */
	}

	/**
	 * @brief   Time configuration structure definition
	 * @attention
	 */
	public class NETDEV_TIME_DST_CFG_S extends Structure{
		public NETDEV_TIME_DST_S   stBeginTime;        /*  #NETDEV_TIME_DST_S  DST begin time see enumeration NETDEV_TIME_DST_S */
		public NETDEV_TIME_DST_S   stEndTime;          /*  #NETDEV_TIME_DST_S  DST end time see enumeration NETDEV_TIME_DST_S */
		public int               dwOffsetTime;       /*  # NETDEV_DST_OFFSET_TIME  DST saving time see enumeration NETDEV_DST_OFFSET_TIME */
	}

	/**
	 * @brief   Time parameter Structure definition
	 * @attention  None
	 */
	public class NETDEV_TIME_S extends Structure{
		public int   dwYear;                       /*   Year */
		public int   dwMonth;                      /*   Month */
		public int   dwDay;                        /*   Day */
		public int   dwHour;                       /*   Hour */
		public int   dwMinute;                     /*   Minute */
		public int   dwSecond;                     /*   Second */
	}

	/**
	 * @brief   Time configuration structure definition
	 * @attention
	 */
	public class NETDEV_TIME_CFG_S extends Structure{
		public int     dwTimeZone;             /*  # NETDEV_TIME_ZONE_E  Time zone, see enumeration #NETDEV_TIME_ZONE_E */
		public NETDEV_TIME_S           stTime;                 /*   Time */
		public int                    bEnableDST;             /*  DST enable */
		public NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /*  DST time config*/
		public int                  udwDateFormat;          /*  0：YYYY-MM-DD  1：MM-DD-YYYY  2：DD-MM-YYYY */
		public int                  udwHourFormat;          /*  0 ：12  1:24 */
		public byte[]       byRes = new byte[212];             /*   Reserved */
	}

	/**
	 * @brief   DST configuration structure definition
	 * @attention
	 */
	public class NETDEV_DST_CFG_S extends Structure{
		public int                    bEnableDST;             /*  DST enable */
		public NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /*  DST time config*/
		public byte[]       byRes = new byte[128];             /*   Reserved */
	}

	/**
	 * @brief  Video resolution
	 * @attention 
	 */
	public class NETDEV_VIDEO_RESOLUTION_S extends Structure{
		public int dwWidth;
		public int dwHeight;
	}

	/**
	 * @struct tagNETDEVVideoSnapshotInfo
	 * @brief  Snap parameter info
	 * @attention
	 */
	public class NETDEV_VIDEO_SNAPSHOT_S extends Structure{
		public int bIsEnabled;                                                             /* ,0: , 1:  Support configuration or not. 0-close, 1-open*/
		public int udwPictureMaxSize;                                                    
		public int udwSnapshotInterval;                                                  /* [1, 60],:。SnapshotNum23 */
		public int udwSnapshotNum;                                                       /* [1,3] */
		public NETDEV_VIDEO_RESOLUTION_S stResolution;                                      

		public byte[]       byRes = new byte[255];                                                           
	}

	/**
	 * @brief   Plan (Week) Structure definition
	 * @attention  None
	 */
	public class NETDEV_SWITCH_WEEK_PLAN_INFO_S extends Structure{
		public int                      udwSwitchIndex;                 
		public NETDEV_WEEK_PLAN_INFO_S     astWeekPlanInfo;                
		public byte[]       byRes = new byte[128];                     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVRecordStatus
	 * @brief 
	 * @attention
	 */
	public class NETDEV_RECORD_STATUS extends Structure{
		public int   dwChannelID;                    /*   Channel ID */
		public int   dwRecordType;                   /*  0:1:2:3:4:*/
		public int   dwRecordStatus;                 /*  0:1:2:3:*/
		public byte[]       byRes = new byte[128];                     
	}

	/**
	 * @struct tagNETDEVRecordStatusList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_RECORD_STATUS_LIST_S extends Structure{
		public int                  udwSize;                                 
		public NETDEV_RECORD_STATUS[]    astRecordStatus = new NETDEV_RECORD_STATUS[NETDEV_CHANNEL_MAX];      
	}

	/**
	 * @struct tagNETDEVSeriaParam
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SERIAL_PARAM_S extends Structure{
		public int                                       dwBaudRate;                /* 。：[1200,115200]: bps。 */
		public int                                       dwDataBit;                 /* [5-8] */
		public int                                       dwFlowCtrl;                /* 0： 1： 2： */
		public int                                       dwParity;                  /* 0： 1： 2： */
		public int                                       dwStopBit;                 

		public byte[]       byRes = new byte[512];         
	}

	/**
	 * @struct tagNETDEVSerialPort
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SERIAL_PORT_S extends Structure{
		public int                                       dwChannelID;                
		public int                                       dwMode;                     /* ：1： 2： */
		public NETDEV_SERIAL_PARAM_S                       stSerialParam;              

		public byte[]       byRes = new byte[512];         
	}


	/**
	 * @struct tagNETDEVSerialPorts
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SERIAL_PORTS_S extends Structure{
		public int                         dwSerialPortNum;          
		public Pointer        pstSerialPortList;        /*  dwSerialPortNum0; dwSerialPortNum0 NETDEV_SERIAL_PORT_S */

		public byte[]       byRes = new byte[512];               
	}

	/**
	 * @struct tagNETDEVAudioDecodeStatus
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_DECODE_STATUS_S extends Structure{
		public int dwStreamID;       
		public int  bDecodeAudio;     
	}

	/**
	 * @struct tagNETDEVAudioDecodeStatusList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_DECODE_STATUS_LIST_S extends Structure{
		public int dwSize;   
		public NETDEV_AUDIO_DECODE_STATUS_S[] astAudioDecStatus = new NETDEV_AUDIO_DECODE_STATUS_S[NETDEV_STREAM_MAX_NUM];  
	}

	/**
	 * @struct tagNETDEVVideoLossRuleInfo
	 * @brief
	 * @attention
	 */
	public class NETDEV_VIDEO_LOSS_RULE_INFO_S extends Structure{
		public int         bEnabled;            /* , 0: 1:*/
		public byte[]       byRes = new byte[256];          
	}

	/**
	 * @struct tagNETDEVSwitchLinkageAction
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_SWITCH_LINKAGE_ACTION_S extends Structure{
		public int                          udwSwitchIndex; 
		public NETDEV_LINKAGE_ACTION_LIST_S    stLinkageActionList;
		public byte[]       byRes = new byte[256];
	}

	/**
	 * @struct tagNETDEVTamperDetectionRuleInfo
	 * @brief
	 * @attention
	 */
	public class NETDEV_TAMPER_DETECTION_RULE_INFO_S extends Structure{
		public int         bEnabled;              /* , 0: 1:*/
		public int       udwSensitivity;        /* [1,100] */
		public int       udwDuration;           /* 。[0, 10]IPC */
		public byte[]       byRes = new byte[256];            
	}

	/**
	 * @enum tagNETDEVMotionDetectionAreaType
	 * @brief  motion detection area type
	 * @attention
	 */
	public class NETDEV_MOTION_DETECTION_AREA_TYPE_S extends Structure{
		public int  udwAreaType;                    /*  #NETDEV_MOTION_DETECTION_AREA_TYPE_E */
		public byte[]       byRes = new byte[128];                     
	}

	/**
	 * @struct tagNETDEVMotionDetectionAreaGridInfo
	 * @brief  Motion detection area grid info
	 * @attention  None
	 */
	public class NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S extends Structure{
		public int    bEnabled;                                                        
		public int  udwSensitivity;                                                  /* [1,100]  Sensitivity */
		public short[]   awGridInfo = new short[NETDEV_SCREEN_INFO_ROW*NETDEV_SCREEN_INFO_COLUMN];  /*   Grid Info */
		public byte[]       byRes = new byte[256];                                                         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVRectAreaInfo
	 * @brief   Rectangle Area info  Structure definition
	 * @attention  None
	 */
	public class NETDEV_RECT_AREA_INFO_S extends Structure{
		public int   udwTopLeftX;                       /* x X axis left point value */
		public int   udwTopLeftY;                       /* y Y axis top point value */
		public int   udwBottomRightX;                   /* x X axis right point value */
		public int   udwBottomRightY;                   /* y Y axis bottom point value */
	}

	/**
	 * @struct tagNETDEVMotionDetectionAreaRectangleInfo
	 * @brief  Motion detection area rectangle info
	 * @attention  None
	 */
	public class NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S extends Structure{
		public int  udwID;                              
		public int    bEnabled;                           
		public int  udwSensitivity;                     /* [1,100]  Sensitivity */
		public int  udwDuration;                        /* [1,100] */
		public int  udwTargetSize;                      /* [1,100] */
		public NETDEV_RECT_AREA_INFO_S   stRectAreaInfo;   /* ,[0,9999]  rectangle area Info [0,9999] */
		public byte[]       byRes = new byte[128];                                                         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMotionDetectionAreaRectangleInfoList
	 * @brief  Motion detection area rectangle info
	 * @attention  None
	 */
	public class NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S extends Structure{
		public int                                          udwNum;                                 
		public NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S[]   astRectangleAreaInfoList = new NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S[NETDEV_LEN_8]; 
		public byte[]       byRes = new byte[128];                                                                     /*   Reserved */
	}

	/**
	 * @enum tagNETDEVRAIDStatus
	 * @brief 
	 * @attention
	 */
	public class NETDEV_RAID_STATUS_S extends Structure{
		public int    bEnabled;                   
		public byte[]       byRes = new byte[128];                 
	}

	/**
	 * @struct tagNETDEVHDDInfo
	 * @brief  HDD info
	 * @attention  None
	 */
	public class NETDEV_HDD_INFO_S extends Structure{
		public int  udwID;                          
		public int  udwType;                        /*  #NETDEV_HDD_TYPE_E */
		public int  udwWorkMode;                    /*  #NETDEV_HDD_WORK_MODE_E */
		public int  udwTotalCapacity;               /* (MB) Total Capacity */
		public byte[]    szRAIDName = new byte[NETDEV_LEN_64];      
		public int  udwStatus;                      /*  #NETDEV_HDD_STATUS_E */
		public byte[]    szManufacturer = new byte[NETDEV_LEN_64];  
		public byte[]       byRes = new byte[128];                     
	}

	/**
	 * @struct tagNETDEVHDDInfoList
	 * @brief  Disk info list
	 * @attention  None
	 */
	public class NETDEV_HDD_INFO_LIST_S extends Structure{
		public int               dwSize;                             /*  Disk number */
		public NETDEV_HDD_INFO_S[]   astHDDInfo = new NETDEV_HDD_INFO_S[NETDEV_LEN_32];          /*  Disk info */
		public byte[]       byRes = new byte[128];                         
	}

	/**
	 * @struct tagNETDEVStorageContainerInfo
	 * @brief  Storage Container info
	 * @attention  None
	 */
	public class NETDEV_STORAGE_CONTAINER_INFO_S extends Structure{
		public int  udwID;                              
		public int  udwRemainCapacity;                  /* (MB) */
		public int  udwTotalCapacity;                   /* (MB) */
		public byte[]    szManufacturer = new byte[NETDEV_LEN_64];      
		public int  udwStatus;                          /*  #NETDEV_STORAGE_CONTAINER_STATUS_E */
		public int  udwProperty;                        /* ,udwStatus0 #NETDEV_STORAGE_CONTAINER_PROPERTY_E */
		public int  udwFormatProgress;                  
		public int  udwGroupID;                         
		public int  udwTemperature;                     
		public byte[]       byRes = new byte[124];                         
	}

	/**
	 * @struct tagNETDEVExtendStorageContainerInfo
	 * @brief  extend Storage Container info
	 * @attention  None
	 */
	public class NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S extends Structure{
		public int  udwID;                              
		public int  udwRemainCapacity;                  /* (MB) */
		public int  udwTotalCapacity;                   /* (MB) */
		public int  udwAddressType;                     /* IP,#NETDEV_ADDR_TYPE_E */
		public byte[]    szIPAddress = new byte[NETDEV_LEN_64];         /* IP */
		public byte[]    szPath = new byte[NETDEV_LEN_256];             /* NAS */
		public int  udwUsageType;                       /* ,#NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E */
		public int  udwStatus;                          /*  #NETDEV_STORAGE_CONTAINER_STATUS_E */
		public int  udwProperty;                        /* ,udwStatus0 #NETDEV_STORAGE_CONTAINER_PROPERTY_E */
		public int  udwFormatProgress;                  
		public int  udwGroupID;                         
		public byte[]       byRes = new byte[128];                         
	}

	/**
	 * @struct tagNETDEVStorageContainerInfoList
	 * @brief  Storage Container info List
	 * @attention  None
	 */
	public class NETDEV_STORAGE_CONTAINER_INFO_LIST_S extends Structure{
		public int                                  udwLocalHDDNum;                                                 
		public NETDEV_STORAGE_CONTAINER_INFO_S[]         astLocalHDDList = new NETDEV_STORAGE_CONTAINER_INFO_S[NETDEV_LOCAL_DISK_MAX_NUM];                     
		public int                                  udwSDNum;                                                       /* SD */
		public NETDEV_STORAGE_CONTAINER_INFO_S[]         astSDList = new NETDEV_STORAGE_CONTAINER_INFO_S[NETDEV_SD_CARD_DISK_MAX_NUM];                         /* SD */
		public int                                  udwArrayNum;                                                    
		public NETDEV_STORAGE_CONTAINER_INFO_S[]         astArrayList = new NETDEV_STORAGE_CONTAINER_INFO_S[NETDEV_ARRAY_MAX_NUM];                             
		public int                                  udwExtendCabinet1HDDNum;                                        /* -1 */
		public NETDEV_STORAGE_CONTAINER_INFO_S[]         astExtendCabinet1HDDList = new NETDEV_STORAGE_CONTAINER_INFO_S[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* -1  */
		public int                                  udwExtendCabinet2HDDNum;                                        /* -2 */
		public NETDEV_STORAGE_CONTAINER_INFO_S[]         astExtendCabinet2HDDList = new NETDEV_STORAGE_CONTAINER_INFO_S[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* -2  */
		public int                                  udwNASNum;                                                      /* NAS */
		public NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[]  astNASList = new NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[NETDEV_NAS_MAX_NUM];                                 /* NAS */
		public int                                  udweSATANum;                                                    /* eSATA */
		public NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[]  asteSATAList = new NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[NETDEV_ESATA_MAX_NUM];                             /* eSATA */
		public int                                  udwIPSANNum;                                                    /* IPSAN */
		public NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[]  astIPSANList=new NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S[NETDEV_IPSAN_MAX_NUM];                             /* IPSAN */
		public byte[]       byRes = new byte[256];                                                     
	}

	/**
	 * @struct tagNETDEVPhotoServerCfgInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PHOTO_SERVER_CFG_INFO_S extends Structure{
		public int                          udwProtocol;                                          /*  ：NETDEV_PHOTO_SERVER_PRO_TYPE_E*/
		public int                          udwSubProtocol;                                       /*  ：NETDEV_PHOTO_SERVER_SUBPRO_TYPE_EudwProtocol131*/
		public int                          udwPort;                                              /* TMS [0,65535] */
		public byte[]                            szIPV4Address = new byte[NETDEV_IPADDR_STR_MAX_LEN];             /* TMSIPv4*/
		public byte[]                            szTollgateID = new byte[NETDEV_LEN_64];                          /* (0, 36];  */
		public byte[]                            szCameraID = new byte[NETDEV_LEN_64];                            /* (0, 36];*/

		public byte[]       byRes = new byte[128];                                           
	}

	/**
	 * @struct tagNETDEVPhotoServerCfgInfoList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S extends Structure{
		public int                          udwNum;                                               
		public NETDEV_PHOTO_SERVER_CFG_INFO_S[]    astPhotoServerList = new NETDEV_PHOTO_SERVER_CFG_INFO_S[NETDEV_PHOTO_SERVER_MAX_NUM];      

		public byte[]       byRes = new byte[512];                                           
	}

	/**
	 * @struct tagNETDEVHDDSmartDetailsInfo
	 * @brief Smart
	 * @attention  None
	 */
	public class NETDEV_HDD_SMART_DETAILS_INFO_S extends Structure{
		public int  udwAttributeID;                     /* ID */
		public byte[]    szAttributeName = new byte[NETDEV_LEN_64];     
		public int  udwStatus;                          /*  #NETDEV_HDD_SMART_ASSESSMENT_STATUS_E */
		public int  udwHex;                             
		public int  udwThresh;                          
		public int  udwCurrentValue;                    
		public int  udwWorstValue;                      
		public int  udwActualValue;                     
		public byte[]       byRes = new byte[128];                         
	}

	/**
	 * @struct tagNETDEVHDDSmartInfo
	 * @brief Smart
	 * @attention  None
	 */
	public class NETDEV_HDD_SMART_INFO_S extends Structure{
		public int                          udwID;                                  /* IN  */
		public byte[]                            szManufacturer = new byte[NETDEV_LEN_64];          
		public int                          udwTemperature;                         /* (℃) */
		public byte[]                            szDeviceModel = new byte[NETDEV_LEN_64];           
		public int                          udwUsedDays;                            
		public int                          udwHealthAssessment;                    /*  #NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E */
		public byte[]                            szFirmware = new byte[NETDEV_LEN_64];              
		public int                          udwSmartNum;                            /* Smart */
		public NETDEV_HDD_SMART_DETAILS_INFO_S[] SmartDetailsInfoList = new NETDEV_HDD_SMART_DETAILS_INFO_S[NETDEV_DISK_SMART_MAX_NUM];    /* Smart */
		public int                            bCheckResult;                           /* , TRUE FALSE  */
		public int                          udwCheckPrograss;                       /*  [0,100] */
		public int                          udwCheckStatus;                         /*  #NETDEV_HDD_SMART_CHECK_STATUS_E */
		public int                          udwCheckType;                           /*  #NETDEV_HDD_SMART_CHECK_TYPE_E */
		public byte[]       byRes = new byte[128];                             
	}

	/**
	 * @struct tagNETDEVHDDSmartCheckInfo
	 * @brief Smart
	 * @attention  None
	 */
	public class NETDEV_HDD_SMART_CHECK_INFO_S extends Structure{
		public int                          udwID;                                  
		public int                          udwType;                                /*  # NETDEV_HDD_SMART_CHECK_TYPE_E */
		public byte[]       byRes = new byte[128];                             
	}

	/**
	 * @struct tagNETDEVPersonLibCapInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_LIB_CAP_INFO_S extends Structure
	{
		public int          udwLibID;                /* ID */
		public int          udwCapacity;             /* ： */
		public byte[]       byRes = new byte[128];   
	}

	/**
	 * @struct tagNETDEVPersonLibCapList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_LIB_CAP_LIST_S extends Structure
	{
		public int                      udwMaxPerpleMun;                         /* ：K */
		public int                      udwFreePerpleNum;                        /* ： */
		public int                      udwMaxLibNum;                            
		public int                      udwFreeLibNum;                           
		public int                      udwNum;                                  /*  :[0, 16] */
		public  NETDEV_PERSON_LIB_CAP_INFO_S[]  stLibCapInfoList = new NETDEV_PERSON_LIB_CAP_INFO_S[NETDEV_LEN_16];         
		public byte[]                   byRes = new byte[256];                   
	}

	/**
	 * @struct tagNETDEVLibInfo
	 * @brief 
	 * @attention 
	 */
	public class NETDEV_LIB_INFO_S extends Structure
	{
		public int udwID;                           /* ID */
		public byte[]   szName = new byte[NETDEV_LEN_256];          /*  [1,63] */
		public int udwType;                         /*  NETDEV_PEOPLE_LIB_TYPE_E*/
		public int udwPersonNum;                    
		public int udwFaceNum;                      
		public int udwMemberNum;                    
		public int udwLastChange;                   
		public byte[]   szBelongIndex = new byte[NETDEV_LEN_256];   
		public int   bIsMonitored;                  
		public byte[]   byRes = new byte[128];                      
	}

	/**
	 * @struct tagNETDEVPersonLibList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_LIB_LIST_S extends Structure
	{
		public int               udwNum;                       
		public Pointer pstLibInfo;                 /* , NETDEV_LIB_INFO_S */
		public byte[]                byRes = new byte[128];    
	}

	/**
	 * @struct tagNETDEVDeleteDBFlagInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_DELETE_DB_FLAG_INFO_S extends Structure
	{
		public int        bIsDeleteMember;                  /* ：0: 1: */
		public int        udwDevID;              /* ID(VMS) */
		public byte[]     byRes = new byte[124];            /*   Reserved */

	}

	/**
	 * @struct tagstNETDEVAlarmLogCond
	 * @brief 
	 * @attention  “16。
	 */
	public class NETDEV_QUERY_INFO_S extends Structure
	{
		public int   dwQueryType;                                /* #NETDEV_QUERYCOND_TYPE_E */
		public int   dwLogicFlag;                                /* #NETDEV_QUERYCOND_LOGICTYPE_E */
		public byte[]    szConditionData = new byte[NETDEV_CODE_STR_MAX_LEN];   
	}

	/**
	 * @struct tagNETDEVPersonQueryInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_QUERY_INFO_S extends Structure
	{
		public int                      udwNum;             
		public Pointer    pstQueryInfos;      /* Num0 NETDEV_QUERY_INFO_S */
		public int                      udwLimit;           /* 20 */
		public int                      udwOffset;          /* 0 */
		public byte[]                   byRes = new byte[256];         
	}

	/**
	 * @struct tagNETDEVBatchOperateBasicInfo
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_BATCH_OPERATE_BASIC_S extends Structure
	{
		public int   udwTotal;       
		public int   udwOffset;      
		public int   udwNum;         
		public byte[]     byRes = new byte[128];     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVRegionInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_REGION_INFO_S extends Structure
	{
		public byte[] szNation = new byte[NETDEV_LEN_128];          /* [1-63] */
		public byte[] szProvince = new byte[NETDEV_LEN_128];        /* [1-63] */
		public byte[] szCity = new byte[NETDEV_LEN_128];            /* [1-63] */
		public byte[] byRes = new byte[256];

	}

	/**
	 * @enum tagNETDEVPersonTimeTemplateInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_TIME_TEMPLATE_INFO_S extends Structure
	{
		public int udwBeginTime;    /*  0 */
		public int udwEndTime;      /*  4294967295(0xFFFFFFFF)*/
		public int udwIndex;        
		public byte[]   byRes = new byte[128];      
	}

	/**
	 * @struct tagNETDEVIdentificationInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_IDENTIFICATION_INFO_S extends Structure
	{
		public int udwType;                     /*   NETDEV_ID_TYPE_E*/
		public byte[]   szNumber = new byte[NETDEV_LEN_128];     /* :[1, 127] */
		public byte[]   byRes = new byte[32];                  
	}

	/**
	 * @struct tagNETDEVFileInfo
	 * @brief 
	 * @attention udwSize0pcData,szUrl
	 */
	public class NETDEV_FILE_INFO_S extends Structure
	{
		public byte[]   szName = new byte[NETDEV_LEN_64];   /*  [1, 16]*/
		public int udwSize;                 /* [pcdataszurl] : :[0, 1M(1048576)] */
		public int dwFileType;              /* ：NETDEV_FILE_TYPE_E */
		public int udwLastChange;           /* UTCs */
		public Pointer   pcData;                 /*  Base64 udwSize  byte[] */
		public byte[]   szUrl = new byte[NETDEV_LEN_512];   /* URL[0,256] */
		public byte[]   byRes = new byte[128];              
	}

	/**
	 * @struct tagNETDEVImageInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_IMAGE_INFO_S extends Structure
	{
		public int udwFaceID;                   /* ID */
		public NETDEV_FILE_INFO_S stFileInfo;      
		public byte[]   byRes = new byte[128];                  
	}

	/**
	 * @struct tagNETDEVCustomValue
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CUSTOM_VALUE_S extends Structure
	{
		public int  udwID;                                         /*  0*/
		public byte[]    szValue = new byte[NETDEV_FACE_MEMBER_CUSTOM_LEN];        /*  [1,63]*/
		public int  udwModelStatus;                                /* 。0： 1： 2： */
		public byte[]    byRes = new byte[124];                                    /*   Reserved */
	}

	/**
	 * @struct tagNETDEVStaffInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_STAFF_INFO_S extends Structure
	{
		public byte[]   szNumber = new byte[NETDEV_LEN_32];                       /*  [1, 16] */
		public byte[]   szBirthday = new byte[NETDEV_LEN_32];                     /*  [1,31] */
		public int      udwDeptID;                                                /* ID */
		public byte[]   szDeptName = new byte[NETDEV_LEN_256];                    /*   [1, 64] */
		public byte[]   byRes = new byte[256];                                    /*   Reserved */
	}

	/**
	 * @struct tagNETDEVVisitorInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_VISITOR_INFO_S extends Structure
	{
		public int udwVisitorCount;                               
		public byte[]   szCompany = new byte[NETDEV_LEN_256];                     /*  [1, 64] */
		public int udwIntervieweeID;                              /* ID */
		public byte[]   byRes = new byte[256];                                    /*   Reserved */
	}

	/**
	 * @struct tagNETDEVPersonInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_INFO_S extends Structure
	{
		public int                                  udwPersonID;                         /* ID */
		public int                                  udwLastChange;                       
		public byte[]                               szPersonName = new byte[NETDEV_LEN_256];        /*  :[1, 63] */
		public int                                  udwGender;                           /*  NETDEV_GENDER_TYPE_E*/
		public byte[]                               szBirthday = new byte[NETDEV_LEN_64];           /* YYYYMMDD[1,31] */
		public NETDEV_REGION_INFO_S                    stRegionInfo;                        
		public int                                  udwTimeTemplateNum;                  
		public Pointer                              pstTimeTemplateList;                 /*    NETDEV_PERSON_TIME_TEMPLATE_INFO_S*/
		public int                                  udwIdentificationNum;                /*  :[0, 6]*/
		public NETDEV_IDENTIFICATION_INFO_S[]            stIdentificationInfo = new NETDEV_IDENTIFICATION_INFO_S[NETDEV_LEN_8];  
		public int                                  udwImageNum;                         /*  :[0, 6] */
		public NETDEV_IMAGE_INFO_S[]                     stImageInfo = new NETDEV_IMAGE_INFO_S[NETDEV_LEN_8];           
		public int                                  udwReqSeq;                           
		public int                                    bIsMonitored;                        /* VMS */
		public int                                  udwBelongLibNum;                     /* VMS */
		public Pointer                                 pudwBelongLibList;                   /* IDVMS int[] */
		public int                                  udwCustomNum;                        /* 5VMS */
		public Pointer                 pstCustomValueList;                  /* Num0 NETDEV_CUSTOM_VALUE_S */
		public byte[]                                    szTelephone = new byte[NETDEV_LEN_64];          /*  [1,64] */
		public byte[]                                    szAddress = new byte[NETDEV_LEN_256];           /*  [1, 64] */
		public int                                  udwCardNum;                          /*  [0,6],Get */
		public int                                  udwFingerprintNum;                   /* [0,10] */
		public int                                  udwType;                             /*  0： 1： 2： */
		public NETDEV_STAFF_INFO_S                     stStaff;                             /*  Type */
		public NETDEV_VISITOR_INFO_S                   stVisitor;                           /*  Type */
		public byte[]                                    szDesc = new byte[NETDEV_LEN_480];              /*  [1, 128] */
		public byte[]                                    szPersonCode=new byte[NETDEV_LEN_16];         /* :[1, 15] PTS */
		public byte[]                                    szRemarks=new byte[NETDEV_LEN_64];            /*  :[1-63] PTS */
		public byte[]                                    byRes = new byte[176];                          
	}

	/**
	 * @struct tagNETDEVPersonInfoList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_INFO_LIST_S extends Structure
	{
		public int udwNum;                                          
		public Pointer              pstPersonInfo;   /* , NETDEV_PERSON_INFO_S */
		public byte[]   byRes = new byte[128];                                      
	}

	/**
	 * @struct tagNETDEVFaceInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_FACE_INFO_S extends Structure
	{
		public int udwFaceID;           /* ID */
		public int udwResultCode;       /* #NETDEV_PERSON_RESULT_CODE_E */
		public byte[]   byRes = new byte[128];          
	}

	/**
	 * @struct tagNETDEVPersonList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_LIST_S extends Structure
	{
		public int udwPersonID;                                 /* ID */
		public int udwFaceNum;                                  /*  6 */
		public NETDEV_FACE_INFO_S[] stFaceInfo = new NETDEV_FACE_INFO_S[NETDEV_LEN_8];        
		public int udwReqseq;                                   /* ,VMS */
		public byte[]   byRes = new byte[128];                                  
	}

	/**
	 * @struct tagNETDEVPersonResultList
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_RESULT_LIST_S extends Structure
	{
		public int udwNum;                                          
		public Pointer pstPersonList;                   /* , malloc by caller NETDEV_PERSON_LIST_S */
		public byte[]   byRes = new byte[128];                                      
	}

	/**
	 * @struct tagstNETDEVAlarmLogCondList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ALARM_LOG_COND_LIST_S extends Structure
	{
		public int   dwPageRow;                                                      
		public int   dwFirstRow;                                                     
		public int   dwCondSize;                                                     
		public NETDEV_QUERY_INFO_S[] astCondition = new NETDEV_QUERY_INFO_S[NETDEV_LOG_QUERY_COND_NUM];            
	}

	/**
	 * @struct tagstNETDEVAlarmLogInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ALARM_LOG_INFO_S extends Structure
	{
		public int dwAlarmID;                                                  	  /* ID */
		public int dwAlarmType;                                           		  /*  # NETDEV_ALARM_TYPE_E*/
		public int dwAlarmSubType;                                      		  /* ,#NETDEV_ALARM_SUBTYPE_E */
		public int dwAlarmLevel;                                        		  /*  0： 1： 2： 3： 4： */
		public int dwServerID;                                         		      
		public int dwDevID;                                                       /* ID */
		public int dwChannelID;                                                   /* ID */
		public byte[] szAlarmSrc = new byte[NETDEV_NAME_MAX_LEN];                 
		public long tAlarmTime;                                                   /*  UTC  */
		public int bAlarmChecked;                                                 /*  0： 1：*/
		public byte[] szAlarmCheckUser = new byte[NETDEV_USERNAME_LEN];           
		public long tAlarmCheckTime;                                              
		public byte[] szAlarmCheckDesc = new byte[NETDEV_DESCRIBE_MAX_LEN];       
		public int dwAlarmLinkType;                                               
		public int IsAlarmSnapExisted;                                            /*  0 1*/
		public int dwAlarmSrcBelong;                                     /* #NETDEV_ALARM_SRC_BELONG_TYPE_E */
		public byte[] szAlarmDetail= new byte[NETDEV_DESCRIBE_MAX_LEN];               
		public int dwHasRelatedData;                                     /*  0： 1： */
		public byte[] byRes = new byte[244];                                      
	}

	/**
	 * @struct tagstNETDEVFaceAlarmLogResultInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SMART_ALARM_LOG_RESULT_INFO_S extends Structure
	{
		public int   udwTotal;                     
		public int   udwOffset;                    
		public int   udwNum;                       
		public byte[]     byRes = new byte[128];                   /*   Reserved */
	}

	/**
	 * @struct tagNETDEVFaceMemberRegionInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_FACE_MEMBER_REGION_INFO_S extends Structure
	{
		public byte[]   szNation = new byte[NETDEV_FACE_MEMBER_REGION_LEN];                       
		public byte[]   szProvince = new byte[NETDEV_FACE_MEMBER_REGION_LEN];                     
		public byte[]   szCity = new byte[NETDEV_FACE_MEMBER_REGION_LEN];                         
		public byte[]   byRes = new byte[256];                                                    /*   Reserved */

	}

	/**
	 * @struct tagNETDEVFaceMemberIDInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_FACE_MEMBER_ID_INFO_S extends Structure
	{
		public int   udwType;                                       /*  NETDEV_FACE_MEMBER_ID_TYPE_E */
		public byte[]     szNumber = new byte[NETDEV_FACE_IDNUMBER_LEN];            

		public byte[]    byRes = new byte[128];                                     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVFaceMemberInfo
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_FACE_MEMBER_INFO_S extends Structure
	{
		public int   udwReqSeq;                                                   
		public int   udwMemberID;                                                 /*ID    post*/
		public byte[]     szMemberName = new byte[NETDEV_FACE_MEMBER_NAME_LEN];                   
		public int   udwMemberGender;                                             /*   NETDEV_GENDER_TYPE_E */
		public byte[]     szMemberBirthday = new byte[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           
		public NETDEV_FACE_MEMBER_REGION_INFO_S   stMemberRegionInfo;                
		public NETDEV_FACE_MEMBER_ID_INFO_S       stMemberIDInfo;                    
		public NETDEV_FILE_INFO_S                 stMemberImageInfo;                 
		public NETDEV_FILE_INFO_S                 stMemberSemiInfo;                  
		public int   udwCustomNum;                                                
		public NETDEV_CUSTOM_VALUE_S[]   stCustomValue = new NETDEV_CUSTOM_VALUE_S[NETDEV_FACE_MEMBER_CUSTOM_NUM];        
		public int      bIsMonitored;                                               /*   01 */
		public int    udwDBNum;                                                   
		public int[]    audwDBIDList = new int[NETDEV_LEN_16];                                /* ID */
		public byte[]      byRes = new byte[128];                                                 /*   Reserved */

	}

	/**
	 * @struct tagstNETDEVFaceAlarmImageArea
	 * @brief 
	 * @attention
	 */
	public class NETDEV_FACE_ALARM_IMAGE_AREA_S extends Structure
	{
		public int   udwLeft;          
		public int   udwTop;           
		public int   udwRight;         
		public int   udwButtom;        

		public byte[]     byRes = new byte[128];       /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVFaceAlarmLogSnapImage
	 * @brief 
	 * @attention
	 */
	public class NETDEV_FACE_ALARM_SNAP_IMAGE_S extends Structure
	{
		public NETDEV_FILE_INFO_S   stBigImage;                
		public NETDEV_FILE_INFO_S   stSmallImage;              
		public NETDEV_FACE_ALARM_IMAGE_AREA_S   stArea;        
		public byte[]    byRes = new byte[128];                             /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVFaceAlarmCmpInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_FACE_ALARM_CMP_INFO_S extends Structure
	{
		public int                           udwSimilarity;               
		public NETDEV_FACE_MEMBER_INFO_S        stMemberInfo;                
		public NETDEV_FACE_ALARM_SNAP_IMAGE_S   stSnapshotImage;             
		public Pointer                          pstPersonInfo;               /*(NVR) / (NETDEV_PERSON_INFO_S) */
		public byte[]    byRes = new byte[124];                                           /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVFaceRecordSnapshotInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_FACE_RECORD_SNAPSHOT_INFO_S extends Structure
	{
		public int   udwRecordID;                                       /* ID */
		public int   udwRecordType;                                     /*  # NETDEV_FACE_PASS_RECORD_TYPE_E */
		public int   udwPassTime;                                       /*  UTC */
		public int   udwEventType;                                      /*  BITBIT10。BIT0:BIT1:BIT2:*/
		public int   udwChannelID;                                      /* ID */
		public int   udwMonitorRuleID;                                  /* ID */
		public byte[]     szChannelName = new byte[NETDEV_LEN_260];                     
		public NETDEV_FACE_ALARM_CMP_INFO_S  stCompareInfo;                
		public byte[]     byRes = new byte[124];                                        /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMonitorQueryInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_MONITOR_QUERY_INFO_S extends Structure
	{
		public int                      udwLimit;           /* 20 */
		public int                      udwOffset;          /* 0 */
		public int                        bIsQueryAll;        /* :TRUE,:FALSE */
		public byte[]                        byRes = new byte[128];         
	}

	/**
	 * @struct tagNETDEVMemberInfo
	 * @brief / 
	 * @attention  None
	 */
	public class NETDEV_MEMBER_INFO_S extends Structure
	{
		public int udwMemberID;                                         /* /ID */
		public byte[] szMemberName = new byte[NETDEV_LEN_260];          /* /[1,63] */
        public int udwStatus;                                           /*  :NETDEV_PERSON_RESULT_CODE_E */
		public byte[]     byRes = new byte[124];                         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMonitorRuleInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_MONITION_RULE_INFO_S extends Structure
	{
		public int                    bEnabled;                                              
		public byte[]                    szName = new byte[NETDEV_FACE_MONITOR_RULE_NAME_LEN];             
		public byte[]                    szReason = new byte[NETDEV_FACE_MONITOR_RULE_REASON_LEN];         
		public int                  udwLibNum;                                             /* ,16 */
		public int[]                  audwLibList = new int[NETDEV_LEN_32];                            /* ID */
		public int                  udwMonitorType;                                        /* 0：,1： */
		public int                  udwMultipleValue;                                      /* 1：N */
		public int                  udwMonitorReason;                                      /*  ：0： 1： 2： 3： 4：*/
		public byte[]                    szMatchSucceedMsg = new byte[NETDEV_LEN_512];                     
		public byte[]                    szMatchFailedMsg = new byte[NETDEV_LEN_512];                      
		public int                  udwMemberNum;                                          /*  [0-32] */
		public NETDEV_MEMBER_INFO_S[]    stMemberInfo = new NETDEV_MEMBER_INFO_S[NETDEV_LEN_64];                           
		public int                  udwChannelNum;                                         
		public Pointer                  pudwMonitorChlIDList;                                 /*  udwChannelNum   int[]*/
		public int                  udwDevNum;                                             /*  ,VMS */
		public int[]                  audwMonitorDevIDList = new int[NETDEV_LEN_16];                   /*  DevNum,VMS*/
		public int                  udwMonitorRuleType;                                    /* 0：,1： */
		public byte[]                    byRes = new byte[240];                                            /*   Reserved */
	}

	/**
	 * @struct tagNETDEVEnabledActParamInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ENABLED_ACT_PARAM_INFO_S extends Structure
	{
		public int    bEnabled;       
		public byte[]    byRes = new byte[64];      
	}

	/**
	 * @struct tagNETDEVOutputSwitchActParamInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S extends Structure
	{
		public int udwNum;                                                                                 
		public NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S[] astOutputAlarmStatusInfo = new NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S[NETDEV_MAX_ALARM_OUT_NUM];        
	}

	/**
	 * @struct tagNETDEVChannelActParamInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_CHANNEL_ACT_PARAM_INFO_S extends Structure
	{
		public int udwNum;                                 
		public int[] adwChannelID = new int[NETDEV_CHANNEL_MAX];        /* ID*/
	}

	/**
	 * @struct tagNETDEVChannelPreset
	 * @brief 
	 * @attention
	 */
	public class NETDEV_CHANNEL_PRESET_S extends Structure
	{
		public int dwChannelID;                              
		public int dwPresetID;                               
		public byte[]  byRes = new byte[128];                               
	}

	/**
	 * @struct tagNETDEVPresetActParamInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PRESET_ACT_PARAM_INFO_S extends Structure
	{
		public int udwNum;                                                      
		public NETDEV_CHANNEL_PRESET_S[] stChannelPreset = new NETDEV_CHANNEL_PRESET_S[NETDEV_CHANNEL_MAX];        
	}

	/**
	 * @struct tagNETDEVLinkageActionList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_LINKAGE_ACTION_INFO_S extends Structure
	{
		public int  udwActID;                                                   /* IDNETDEV_ALARM_ACT_ID_E */
		public NETDEV_ENABLED_ACT_PARAM_INFO_S  stEnabledInfo;                     /* EMail */
		public NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S stOutputSwitchActParamInfo;   
		public NETDEV_CHANNEL_ACT_PARAM_INFO_S stChannelActParamInfo;              /* NVR */
		public NETDEV_PRESET_ACT_PARAM_INFO_S  stPresetActParamInfo;               
		public byte[]  byRes = new byte[512];                                                   
	}

	/**
	 * @struct tagNETDEVLinkageActionList
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_LINKAGE_ACTION_LIST_S extends Structure
	{
		public int          udwNum;
		public NETDEV_LINKAGE_ACTION_INFO_S[] stActionInfo = new NETDEV_LINKAGE_ACTION_INFO_S[NETDEV_MAX_LINK_ACTION_NUM];
		public byte[]            byRes = new byte[256];
	}

	/**
	 * @struct tagLinkageStrategy
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_LINKAGE_STRATEGY_S extends Structure
	{
		public int                          udwType;                /* ,NETDEV_PERSON_COMPARE_RESULT_TYPE_E */
		public NETDEV_LINKAGE_ACTION_LIST_S    stLintageActions;       
		public byte[]                            byRes = new byte[512];             
	}

	/**
	 * @brief   Time Sections Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_TIME_SECTION_S extends Structure
	{
		public byte[]    szBeginTime = new byte[NETDEV_LEN_64];              /*   Begin time */
		public byte[]    szEndTime = new byte[NETDEV_LEN_64];                /*   End time */
		public int  udArmingType;                            /*    ArmingType NETDEV_ARMING_TYPE_E */
	}

	/**
	 * @brief   Play (Day) Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_DAY_PLAN_S extends Structure
	{
		public int                         udwIndex;                                                  /* ,：NETDEV_LAPI_WEEK_INFO_E  day index */
		public int                         udwSectionNum;                                             /*   Section Num NVR8,IPC4 */
		public NETDEV_VIDEO_TIME_SECTION_S[]    astTimeSection = new NETDEV_VIDEO_TIME_SECTION_S[NETDEV_MAX_TIME_SECTION_NUM];   /*   Time Sections */
	}

	/**
	 * @brief     Plan (Week) Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_WEEK_PLAN_S extends Structure
	{
		public int                        bEnabled;                                            /* ,IPC;NETDEV_DEFENCE_PLAN_ENABLE_E */
		public int                      udwDayNum;                                           /* ,NVR8();IPC7() */
		public NETDEV_VIDEO_DAY_PLAN_S[]     astDayPlan = new NETDEV_VIDEO_DAY_PLAN_S[NETDEV_MAX_DAY_NUM];                      
		public byte[]                        byRes = new byte[32];                                           
	}

	/**
	 * @struct tagNETDEVMonitorDefenceInfo
	 * @brief  
	 * @attention PTS VMS
	 */
	public class NETDEV_MONITOR_DEFENCE_INFO_S extends Structure
	{
		public long      tBegin;                  /* (unix) */
		public long      tEnd;                    /* (unix) */
		public int     udwTimeTemplateID;       /* 0 */
		public byte[]       byRes = new byte[128];              
	}

	/**
	 * @struct tagNETDEVFaceMonitorInfo
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_MONITION_INFO_S extends Structure
	{
		public int                              udwID;                        
		public NETDEV_MONITION_RULE_INFO_S         stMonitorRuleInfo;            
		public int                              udwLinkStrategyNum;           
		public Pointer                          pstLinkStrategyList;          /*  NETDEV_LINKAGE_STRATEGY_S*/
		public NETDEV_VIDEO_WEEK_PLAN_S            stWeekPlan;                   /* ,NVR IPC */
		public NETDEV_MONITOR_DEFENCE_INFO_S       stMonitorDefenceInfo;         /* PTS VMS */
		public byte[]                                byRes = new byte[250];                   /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMonitorChlInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_MONITION_CHL_INFO_S extends Structure
	{
		public int                          udwChannelID;                       /* ID IPCVMS */
		public int                          udwResultCode;                      /*  NETDEV_PERSON_RESULT_CODE_E */
		public int                          udwMonitorID;                       /* ID */
	}

	/**
	 * @struct tagNETDEVMonitorResultInfo
	 * @brief  Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_MONITOR_RESULT_INFO_S extends Structure
	{
		public int                              udwChannelNum;                  
		public Pointer                          pstMonitorChlInfos;             /*    malloc by caller NETDEV_MONITION_CHL_INFO_S*/
		public byte[]                                byRes = new byte[250];                     /*   Reserved */
	}

	/**
	 * @struct tagNETDEVBatchOperatorInfo
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_BATCH_OPERATOR_INFO_S extends Structure
	{
		public int   udwReqSeq;                          
		public int   udwResultCode;                      /* ,#NETDEV_PERSON_MONITOR_OPT_RES_CODE_ENETDEV_MONITOR_ERR_CODE_E */
		public int   udwID;                              
		public byte[]     szName = new byte[NETDEV_LEN_260];             /* [1,63] */
		public byte[]     byRes = new byte[128];                         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVBatchOperateList
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_BATCH_OPERATOR_LIST_S extends Structure
	{
		public int                          udwNum;         
		public int                          udwStatus;      
		public Pointer                      pstBatchList;   /*  2000, NETDEV_BATCH_OPERATOR_INFO_S */
		public byte[]                            byRes = new byte[128];     /*   Reserved */

	}

	/**
	 * @struct tagNETDEVMonitorDevResultInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_MONITOR_DEV_RESULT_INFO_S extends Structure
	{
		public int                          udwDevID;           /* ID */
		public NETDEV_BATCH_OPERATOR_LIST_S    stMonitorResult;    
		public byte[]                            byRes = new byte[128];         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVDevMonitorInfo
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_DEV_MONITOR_INFO_S extends Structure
	{
		public int  udwDevID;               /* ID */
		public int  udwMonitorStatus;       
		public byte[]    byRes = new byte[64];              
	}

	/**
	 * @struct tagNETDEVMonitorMemberInfo
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_MONITOR_MEMBER_INFO_S extends Structure
	{
		public int                      udwMemberID;                        /* ID */
		public byte[]                     szName = new byte[NETDEV_LEN_260];             
		public int                      udwDevNum;                          
		public int                      udwMonitorStatus;                   /*  0:   1:*/
		public NETDEV_DEV_MONITOR_INFO_S[]   stDevMonitorInfo = new NETDEV_DEV_MONITOR_INFO_S[NETDEV_LEN_16];    /*  5*/
		public byte[]                        byRes = new byte[64];                          /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMonitorCapacityInfo
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_MONITOR_CAPACITY_INFO_S extends Structure
	{
		public int  udwMonitorType;         /*  0：   1： */
		public int  udwNum;                 
		public Pointer pudwDevIDList;         /* ID udwNum int[] */
		public byte[]    byRes = new byte[128];             /*   Reserved */
	}

	/**
	 * @struct tagNETDEVDevCapacityInfo
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_DEV_CAPACITY_INFO_S extends Structure
	{
		public int  udwDevID;               /* ID */
		public int  udwCapacity;            
		public int  udwMonitoredNum;        
		public byte[]    byRes = new byte[128];             /*   Reserved */
	}

	/**
	 * @struct tagNETDEVMonitorCapacityList
	 * @brief 
	 * @attention None
	 */
	public class NETDEV_MONITOR_CAPACITY_LIST_S extends Structure
	{
		public int                          udwDevNum;              
		public Pointer                      pstDevCapacityList;     /*  DevNum NETDEV_DEV_CAPACITY_INFO_S */
		public byte[]                            byRes = new byte[64];              /*   Reserved */
	}

	/**
	 * @struct tagNETDEVFeatureInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_FEATURE_INFO_S extends Structure
	{
		public byte[]    szFeatureVersion = new byte[NETDEV_LEN_32];        /*  [0, 20] */
		public byte[]    szFeature = new byte[NETDEV_FACE_FEATURE_SIZE];    /*  512B */
		public byte[]    byRes = new byte[128];                             
	}

	/**
	 * @struct tagNETDEVPersonCompareInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_PERSON_COMPARE_INFO_S extends Structure
	{
		public int                      udwSimilarity;                                  
		public NETDEV_PERSON_INFO_S        stPersonInfo;                                   
		public NETDEV_FILE_INFO_S          stPanoImage;                                    
		public NETDEV_FILE_INFO_S          stFaceImage;                                    
		public NETDEV_FACE_POSITION_INFO_S stFaceArea;                                     
		public int                      udwCapSrc;                                      
		public int                      udwFeatureNum;                                  /*   PTS */
		public Pointer                  pstFeatureInfo;                                 /*    PTS  NETDEV_FEATURE_INFO_S*/
		public NETDEV_FACE_ATTR_S          stFaceAttr;                                     
		public NETDEV_PERSON_ATTR_S        stPersonAttr;                                   
		public byte[]                        byRes = new byte[248];                                     
	}

	/**
	 * @struct tagNETDEVFacePassRecordInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_FACE_PASS_RECORD_INFO_S extends Structure
	{
		public int                              udwRecordID;                        /* ID */
		public int                              udwType;                            /* NETDEV_FACE_PASS_RECORD_TYPE_E */
		public long                               tPassingTime;                       /* UTC */
		public int                              udwChannelID;                       /* ID */
		public byte[]                                szChlName = new byte[NETDEV_LEN_128];          /* [1,63] */
		public NETDEV_PERSON_COMPARE_INFO_S        stCompareInfo;                      
		public byte[]                                byRes = new byte[256];                         
	}

	/**
	 * @struct tagNETDEVPersonEventInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_EVENT_INFO_S extends Structure
	{
		public int                          udwID;                                   /* ID */
		public int                          udwTimestamp;                            /*  UTC*/
		public int                          udwNotificationType;                     /*  0：1： */
		public int                          udwFaceInfoNum;                          /*  ：[0, 1] */
		public NETDEV_FACE_PASS_RECORD_INFO_S[]  stCtrlFaceInfo = new NETDEV_FACE_PASS_RECORD_INFO_S[NETDEV_LEN_2];            /* FaceInfo */
		public int                          udwFinishFaceNum;                        /*  ：[0, 40] */
		public int[]                          audwFinishFaceList = new int[NETDEV_LEN_40];       
		public byte[]                            byRes = new byte[92];                               
	}

	/**
	 * @struct tagstNETDEVSubscribeSmartInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SUBSCRIBE_SMART_INFO_S extends Structure
	{
		public int   udwNum;                
		public Pointer   pudwSmartType;        /*  NETDEV_SMART_ALARM_TYPE_EudwNum int[] */
		public byte[]     byRes = new byte[128];            /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVSmartInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SMART_INFO_S extends Structure
	{
		public int      dwChannelID;         /* ID */
		public int     udwSubscribeID;      /* ID */
		public int     udwCurrrntTime;      /* UTC */
		public int     udwEndTime;          /* UTC */
		public int     udwSubscribeType;      
		public byte[]       byRes = new byte[124];          /*   Reserved */
	}

	/**
	 * @enum tagNETDEVLapiSubInfo
	 * @brief Lapi
	 * @attention  None
	 */
	public class NETDEV_LAPI_SUB_INFO_S extends Structure
	{
		public int udwType;                          /*  
	                                                Bit0：
	                                                Bit1：
	                                                Bit2：
	                                                Bit3：
	                                                Bit4：
	                                                Bit5： 0
	                                                Bit6：
	                                                Bit7：
	                                                Bit8：
	                                                Bit9：
	                                                Bit10： */
		public int udwLibIDNum;                      /* ID LibIDNum0xffff  */
		public int[] audwLibIDList = new int[NETDEV_LEN_32];     /* ID */
		public byte[]   byRes = new byte[132];                       
	}

	/**
	 * @enum tagNETDEVSubscribeSuccInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_SUBSCRIBE_SUCC_INFO_S extends Structure
	{
		public int udwID;                      /* ID */
		public int udwCurrrntTime;             /* UTC1970110 */
		public int udwTerminationTime;         /* UTC1970110 */
		public int udwSupportAlarmType;        /* 0 */
		public byte[]   szReference = new byte[NETDEV_LEN_260];/*  URL */
		public byte[]   byRes = new byte[124];                 
	}

	/**
	 * @struct tagstNETDEVPlateAttrInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PLATE_ATTR_INFO_S extends Structure
	{
		public byte[]   szPlateNo = new byte[NETDEV_LEN_16];                        
		public int   udwColor;                                        /*  NETDEV_PLATE_COLOR_E */
		public int   udwType;                                         /* NETDEV_PLATE_TYPE_E */
		public byte[]    byRes = new byte[64];                                       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVVehicleMemberAttr
	 * @brief (NETDEV_VEHICLE_DETAIL_INFO_S)
	 * @attention  None
	 */
	public class NETDEV_VEHICLE_MEMBER_ATTR_S extends Structure
	{
		public int udwColor;                                      /*  NETDEV_PLATE_COLOR_E*/
		public NETDEV_FILE_INFO_S stVehicleImage;                    /*  4M */
	}

	/**
	 * @struct tagstNETDEVVehicleDetailInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEHICLE_DETAIL_INFO_S extends Structure
	{
		public int                       udwReqSeq;                         
		public int                       udwMemberID;                       /* ID */
		public NETDEV_PLATE_ATTR_INFO_S     stPlateAttr;                       
		public NETDEV_VEHICLE_MEMBER_ATTR_S stVehicleAttr;                     
		public int                         bIsMonitored;                      /*  0 1 */
		public int                       udwDBNum;                          
		public int[]   audwDBIDList = new int[NETDEV_LEN_16];       /* ID */
		public byte[]    byRes = new byte[124];                        /*   Reserved */
	}

	/**
	 * @struct tagNETDEVVehicleInfoList
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_VEHICLE_INFO_LIST_S extends Structure
	{
		public int       udwVehicleNum;          
		public Pointer   pstMemberInfoList;      /*  udwNum NETDEV_VEHICLE_DETAIL_INFO_S */
		public byte[]    byRes = new byte[132];             /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVMonitorAlarmInfo
	 * @brief (NETDEV_VEHICLE_RECORD_INFO_S)
	 * @attention
	 */
	public class NETDEV_MONITOR_ALARM_INFO_S extends Structure
	{
		public int udwMonitorReason;                          
		public int udwMonitorAlarmType;                       /*  0： 1： */
		public int udwMemberID;                               /* ID */
	}

	/**
	 * @struct tagstNETDEVVehicleRcordInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEHICLE_RECORD_INFO_S extends Structure
	{
		public int   udwRecordID;                                       /* ID */
		public int   udwChannelID;                                      /* ID */
		public int   udwPassingTime;                                    /* UTC*/
		public byte[]     szChannelName = new byte[NETDEV_LEN_260];                     
		public NETDEV_PLATE_ATTR_INFO_S    stPlateAttr;                    
		public NETDEV_VEH_ATTR_S           stVehAttr;                      
		public NETDEV_FILE_INFO_S          stPlateImage;                   /*  1M*/
		public NETDEV_FILE_INFO_S          stVehicleImage;                 /*   1M*/
		public NETDEV_FILE_INFO_S          stPanoImage;                    /*   URLsize/LAPI/V1.0/System/Picture*/
		public NETDEV_MONITOR_ALARM_INFO_S stMonitorAlarmInfo;             
		public byte[]    byRes = new byte[132];                                        /*   Reserved */
	}

    /**
 	* @struct tagNETDEVNonMotorVehRecord
 	* @brief 
 	* @attention  None
 	*/
	public class NETDEV_NON_MOTOR_VEH_RECORD_S extends Structure
	{
		public int udwRecordID;                                   /* ID */
		public int udwPassingTime;                                /*  UTC  */
		public byte[]   szChannelName = new byte[NETDEV_LEN_260];                 /*  [1,63] */
		public NETDEV_NON_MOTOR_VEH_INFO_S stNonMotorVehInfo;        
		public NETDEV_FILE_INFO_S stNoMotorVehImage;                 /*  500K */
		public NETDEV_FILE_INFO_S stPanoImage;                       /*  URLsize /LAPI/V1.0/System/Picture*/
		public byte[]    byRes = new byte[256];                                    
	}

	/**
	 * @struct tagNETDEVBatchOperateMemberList
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_BATCH_OPERATE_MEMBER_LIST_S extends Structure
	{
		public int  udwTaskNo;             /* NVR */
		public int  udwMemberNum;          
		public Pointer pstMemberIDList;       /*  udwNum int[] */
		public byte[]    byRes = new byte[128];             /*   Reserved */

	}

	/**
	 * @struct tagstVehicleEventInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEHICLE_EVENT_INFO_S extends Structure
	{
		public int udwID;                                              /* ID */
		public int udwTimestamp;                                       /* UTC */
		public int udwNotificationType;                                /*   NETDEV_NOTIFICATION_TYPE_E*/
		public int udwVehicleInfoNum;                                  /*  [0, 1] */
		public Pointer pstVehicleRecordInfo;                           /* , NETDEV_VEHICLE_RECORD_INFO_S NETDEV_VEHICLE_RECORD_INFO_S */
		public byte[]    byRes = new byte[256];                                       /*   Reserved */
	}

	/**
	 * @struct tagstNETDEVVehRecognitionEvent
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEH_RECOGNITION_EVENT_S extends Structure
	{
		public byte[]   szReference = new byte[NETDEV_LEN_480];                        
		public int udwSrcID;                                           /* ID */
		public NETDEV_VEHICLE_EVENT_INFO_S stVehicleEventInfo;            
		public byte[]    byRes = new byte[256];                                       /*   Reserved */
	}

	/**
	 * @struct tagNETDEVEntrInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ENTR_INFO_S extends Structure
	{
		public int udwEnterTime;                                                             /* UTC */
		public NETDEV_FILE_INFO_S stPlateImage;                                                 
		public NETDEV_FILE_INFO_S stVehImage;                                                   
		public byte[]   byRes = new byte[256];                                                               
	}

	/**
	 * @brief   Time Sections Structure definition
	 * @attention  None
	 */
	public class NETDEV_TIME_SECTION_INFO_S extends Structure
	{
		public byte[]    szBeginTime = new byte[NETDEV_LEN_32];              /*   Begin time */
		public byte[]    szEndTime = new byte[NETDEV_LEN_32];                /*   End time */
		public int  udwArmingType;                           /* 0:  1:  2:  3:  4: 5: 10:   Distribution Type 0: Timing 1: Motive Inspection 2: Alarm 3: Motive Inspection and Alarm 4: Motive Inspection or Alarm 5: Unplanned 10: Event*/
	}

	/**
	 * @struct tagstNETDEVExitInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_EXIT_INFO_S extends Structure
	{
		public int udwExitTime;                                                              /* (UTC) */
		public int udwTotalAmount;                                                           
		public int udwIsAlreadyPaid;                                                         /*  0: 1:*/
		public int udwChargeRecordID;                                                        /* ID */
		public NETDEV_FILE_INFO_S stPlateImage;                                                 
		public NETDEV_FILE_INFO_S stVehImage;                                                   
		public byte[]   szOperatorName = new byte[NETDEV_LEN_128];                                           
		public byte   byRes[] = new byte[256];                                                               
	}

	/**
	 * @struct tagstNETDEVParkEventInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PARK_EVENT_INFO_S extends Structure
	{
		public int udwID;                                                                    /* ID */
		public int udwParkID;                                                                /* ID */
		public byte[]   szPlateNo = new byte[NETDEV_LEN_32];                                                 
		public NETDEV_VEH_ATTR_S stVehAttr;                                                     
		public int udwVehRemainNum;                                                          
		public int udwIsWhiteList;                                                           /*  0： 1： */
		public int udwIsBlackList;                                                           /*  0： 1： */
		public byte[]   szEntranceName = new byte[NETDEV_LEN_128];                                           
		public byte[]   szLaneName = new byte[NETDEV_LEN_128];                                               
		public int udwCrossDirection;                                                        /*  0： 1： */
		public Pointer pstEnterInfo;                                               /*   NETDEV_ENTR_INFO_S*/
		public Pointer pstExitInfo;                                                /*  NETDEV_EXIT_INFO_S */
		public byte[]   byRes = new byte[256];                                                               
	}

	/**
	 * @struct tagstNETDEVTmSectInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TM_SECT_INFO_S extends Structure
	{
		public byte[]   szBegin = new byte[NETDEV_LEN_64];                                                  /* , hh:mm:ss [0,31] */
		public byte[]   szEnd = new byte[NETDEV_LEN_64];                                                    /* hh:mm:ss [0,31] */
		public byte[]   byRes = new byte[128];                                                              
	}

	/**
	 * @struct tagstNETDEVVehThroughInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEH_THROUGH_INFO_S extends Structure
	{
		public int udwType;                                                                 /*  NETDEV_VEH_RELEASE_TYPE_E */
		public int udwNum;                                                                  /*  4*/
		public NETDEV_TM_SECT_INFO_S[] astTmSectInfo = new NETDEV_TM_SECT_INFO_S[NETDEV_LEN_4];                              
		public byte[]   byRes = new byte[128];                                                              
	}

	/**
	 * @struct tagstNETDEVVehLaneInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEH_LANE_INFO_S extends Structure
	{
		public int udwVehLaneID;                                                            /* ID */
		public byte[]   szName = new byte[NETDEV_LEN_128];                                                  
		public int udwType;                                                                 /*  NETDEV_VEH_LANE_TYPE_E */
		public int udwNum;                                                                  /* 4 */
		public NETDEV_TM_SECT_INFO_S[] astEnTmSectInfo = new NETDEV_TM_SECT_INFO_S[NETDEV_LEN_4];                            
		public NETDEV_VEH_THROUGH_INFO_S stTmpVehThrough;                                      
		public NETDEV_VEH_THROUGH_INFO_S stRegVehThrough;                                      
		public int udwDevNum;                                                               /*  4*/
		public int[] audwDevID = new int[NETDEV_LEN_4];                                                 /* ID */
		public byte[]   byRes = new byte[128];                                                              
	}

	/**
	 * @struct tagstNETDEVVehLaneInfoList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VEH_LANE_INFO_LIST_S extends Structure
	{
		public int udwNum;                                                                   /* 2 */
		public NETDEV_VEH_LANE_INFO_S[] astVehLaneInfo = new NETDEV_VEH_LANE_INFO_S[NETDEV_LEN_4];                             
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @struct tagstNETDEVParkEntrLaneInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PARK_ENTR_LANE_INFO_S extends Structure
	{
		public int udwParkingLotID;                                                          /* ID */
		public int udwEntranceID;                                                            /* ID */
		public NETDEV_VEH_LANE_INFO_LIST_S stVehLaneInfoList;                                   
		public byte[]   byRes = new byte[128];                                                               
	}


	/**
	 * @struct tagstNETDEVAbnChgRuleInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ABN_CHG_RULE_INFO_S extends Structure
	{
		public int udwID;                                                                    /* ID */
		public byte[]   szName = new byte[NETDEV_LEN_128];                                                   
		public int udwChgAmount;                                                             
		public byte[]   szDescription = new byte[NETDEV_LEN_512];                                            /* [1,128] */
		public int udwIsDefaultRule;                                                         /*  0: 1:*/
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @struct tagstNETDEVTmpVehChgAmount
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TMP_VEH_CHG_AMOUNT_S extends Structure
	{
		public int udwAmount;                                                                
		public int udwManualPayment;                                                         
		public int udwSelfhelpPayment;                                                       
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @struct tagstNETDEVTmpVehChgRecord
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TMP_VEH_CHG_RECORD_S extends Structure
	{
		public int udwRecordID;                                                              /* ID */
		public byte[]   szPlateNo = new byte[NETDEV_LEN_16];                                                 /* [1,16] */
		public int udwVehicleType;                                                           /*  NETDEV_VEHICLE_TYPE_E */
		public int udwChargeTime;                                                            /* UTC */
		public long    tParkTime;                                                              
		public int udwAmount;                                                                
		public byte[]   szAbnRuleName = new byte[NETDEV_LEN_128];                                            /* [1,32] */
		public int udwChgType;                                                               /*  NETDEV_CHG_TYPE_E */
		public byte[]   szParkName = new byte[NETDEV_LEN_260];                                               /* [1,64] */
		public byte[]   szOperatorName = new byte[NETDEV_LEN_260];                                           /* [1,64] */
		public int udwFree;                                                                  /*  0： 1： */
		public byte[]   byRes = new byte[124];                                                               
	}

	/**
	 * @struct tagstNETDEVParkPayOrderInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PARK_PAY_ORDER_INFO_S extends Structure
	{
		public byte[]   szOrderNo = new byte[NETDEV_LEN_128];                                               
		public int udwOrderStatus;                                                          /*   NETDEV_ORDER_STATUS_E*/
		public byte[]   szPlateNo = new byte[NETDEV_LEN_128];                                               
		public int udwPayType;                                                              /*    NETDEV_PAY_TYPE_E*/
		public byte[]   szPayTradeNo = new byte[NETDEV_LEN_128];                                            
		public int udwTotalAmount;                                                          
		public int udwDiscountAmount;                                                       
		public byte[]   byRes = new byte[256];                                                              
	}

	/**
	 * @struct tagstNETDEVParkCost
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PARK_COST_S extends Structure
	{
		public int udwTotalAmount;                                                          
		public int udwEnterTime;                                                            /* UTC */
		public int udwExitLimitTime;                                                        
		public byte[]   byRes = new byte[256];                                                              
	}

	/**
	 * @struct tagstNETDEVChgInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_CHG_INFO_S extends Structure
	{
		public byte[]   szPlateNo = new byte[NETDEV_LEN_16];                                                 /*  [1,16] */
		public int udwAmount;                                                                
		public int udwAbnRuleID;                                                             /* ID */
		public int udwIsFree;                                                                /*  0:1:*/
		public long  tParkingTime;                                                             
		public byte[]   byRes = new byte[128];                                                               
	}


	/**
	 * @struct tagNETDEVEntrVehSnapInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ENTR_VEH_SNAP_INFO_S extends Structure
	{
		public int udwID;                                                                    /* ID */
		public int udwChannelID;                                                             /* ID */
		public byte[]   szPlateNo = new byte[NETDEV_LEN_16];                                                 /* [1,16] */
		public int udwVehType;                                                               /*   NETDEV_VEHICLE_TYPE_E */
		public int udwVehColor;                                                              /*   NETDEV_VEHICLE_COLOR_E*/
		public int udwVehAttr;                                                               /*   NETDEV_VEH_ATTR_TYPE_E */
		public int udwIsBlackList;                                                           /*  0: 1: */
		public int udwEnterTime;                                                             /* UTC */
		public int udwIsAutoOpenGate;                                                        /*  0: 1: */
		public NETDEV_FILE_INFO_S stPlateImage;                                                 
		public NETDEV_FILE_INFO_S stVehImage;                                                   
		public byte[]   byRes = new byte[128];                                                               
	}



	/**
	 * @struct tagstNETDEVShiftInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_SHIFT_INFO_S extends Structure
	{
		public byte[]   szName = new byte[NETDEV_LEN_260];                                                   
		public int udwAmount;                                                                
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @struct tagstNETDEVPassRecordInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_PASS_RECORD_INFO_S extends Structure
	{
		public int udwRecordID;                                                              /* ID */
		public NETDEV_FILE_INFO_S stPlateImage;                                                 
		public byte[]   szPlateNo = new byte[NETDEV_LEN_16];                                                 /* [1,16] */
		public byte[]   szName = new byte[NETDEV_LEN_128];                                                   /* [1,32] */
		public int udwVehType;                                                               /*  NETDEV_VEHICLE_TYPE_E */
		public int udwVehColor;                                                              /*   NETDEV_VEHICLE_COLOR_E */
		public int udwIsBlackList;                                                           /*  0: 1: */
		public int udwIsWhiteList;                                                           /*  0： 1： */
		public byte[]   szParkName = new byte[NETDEV_LEN_260];                                               /* [1,64] */
		public int udwCrossDirection;                                                        /*  0: 1: */
		public int udwPassTime;                                                              /* UTC */
		public byte[]   szEntrName = new byte[NETDEV_LEN_260];                                               /* [1,64] */
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @struct tagstNETDEVEntrExitSnapRecordID
	 * @brief ID
	 * @attention
	 */
	public class NETDEV_ENTR_EXIT_SNAP_RECORDID_S extends Structure
	{
		public int udwEnterID;                                                               /* ID */
		public int udwExitID;                                                               /* ID */
		public byte[]   byRes = new byte[128];                                                               
	}

	/**
	 * @brief   Play (Day) Structure definition
	 * @attention  None
	 */
	public class NETDEV_DAY_PLAN_INFO_S extends Structure
	{
		public int                      udwID;                                           /*1：;2：3：4：5：6：7：8：  Weekly Index 1: Monday; 2: Tuesday; 3: Wednesday; 4: Thursday; 5: Friday; 6: Saturday; 7: Sunday; 8: Holidays;*/
		public int                      udwNum;                                          /* NVR8IPC4  The maximum number of NVRs per day is 8; IPC maximum 4 paragraphs*/
		public NETDEV_TIME_SECTION_INFO_S[]  astTimeSection = new NETDEV_TIME_SECTION_INFO_S[NETDEV_MAX_TIME_SECTION_NUM];     /*   Time Sections */
	}

	/**
	 * @brief   Play (Week) Structure definition
	 * @attention  None
	 */
	public class NETDEV_WEEK_PLAN_INFO_S extends Structure
	{
		public int                        bEnabled;                                           /* ,IPC  Enabling,IPC only*/
		public int                      udwNum;                                             /* NVR8()IPC7()  Planned days, NVR up to 8(7 days a week and holidays) IPC up to 7(7 days a week)*/
		public NETDEV_DAY_PLAN_INFO_S[]      astDayPlanInfo = new NETDEV_DAY_PLAN_INFO_S[NETDEV_MAX_DAY_NUM];                 /*   List of deployment plans for each day of the week*/
		public byte[]    byRes = new byte[512];                                         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVExceptionDayInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_EXCEPTION_DAY_INFO_S extends Structure
	{
		public int udwID;                                                            
		public int   bEnabled;                                                         
		public byte[]   szDate = new byte[NETDEV_LEN_16];                                            /*  year-month-day */
		public int udwNum;                                                           /*  NVR8 IPC/PTS4*/
		public NETDEV_TIME_SECTION_INFO_S[] stTimeSectionInfo = new NETDEV_TIME_SECTION_INFO_S[NETDEV_LEN_16];             
		public byte[]    byRes = new byte[128];                                                       
	}

	/**
	 * @struct tagNETDEVExceptionInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_EXCEPTION_INFO_S extends Structure
	{
		public int   bEnabled;                                                         /*  0: 1： */
		public int udwNum;                                                           /*  [0, 16] */
		public NETDEV_EXCEPTION_DAY_INFO_S[] stExceptionDayInfo = new NETDEV_EXCEPTION_DAY_INFO_S[NETDEV_LEN_32];           
		public byte[]    byRes = new byte[128];                                                       
	}

	/**
	 * @struct tagNETDEVTimeTemplateInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_TIME_TEMPLATE_INFO_S extends Structure
	{
		public int udwID;                                   
		public byte[]   szName = new byte[NETDEV_LEN_256]; 	/*  [1, 63] */
		public int udwLastChange;                           
		NETDEV_WEEK_PLAN_INFO_S stWeekPlanInfo;         
		NETDEV_EXCEPTION_INFO_S stExceptionInfo;        
		public byte[]    byRes = new byte[128];                              
	}

	/**
	 * @struct tagNETDEVUpdateInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_UPDATE_INFO_S extends Structure
	{
		public int udwID;               /* ID */
		public int udwLastChange;       
		public byte[]    byRes = new byte[128];          
	}

	/**
	 * @struct tagNETDEVTimeTemplateUdateInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_TIME_TEMPLATE_UPDATE_INFO_S extends Structure
	{
		public int udwNum;                                          /*  [0, 32] */
		public NETDEV_UPDATE_INFO_S[] stUpdateInfo = new NETDEV_UPDATE_INFO_S[NETDEV_LEN_64];       
		public byte[]    byRes = new byte[128];                                      
	}

	/**
	 * @struct tagNETDEVCtrlFaceInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CTRL_FACE_INFO_S extends Structure
	{
		public int udwID;                                           /* ID */
		public int udwTimestamp;                                    /*  UTC */
		public int udwCapSrc;                                       /*   NETDEV_CAP_SRC_E FaceInfo1 */
		public int udwFeatureNum;                                   /*  ：[0, 2] */
		public Pointer pstFeatureInfo;                          /*  (NETDEV_FEATURE_INFO_S) */
		public NETDEV_FILE_INFO_S stPanoImage;                         
		public NETDEV_FILE_INFO_S stFaceImage;                         
		public NETDEV_FACE_POSITION_INFO_S stFaceArea;                 
		public float  fTemperature;                                    /*  ：：1 */
		public int udwMaskFlag;                                     /* 0：1：2： */
		public byte[]    byRes = new byte[120];                                      
	}

	/**
	 * @struct tafNETDEVCtrlCardInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CTRL_CARD_INFO_S extends Structure
	{
		public int 		udwID;                                       /* ID */
		public int 		udwTimestamp;                                /*  UTC */
		public int 		udwCapSrc;                                   /*   NETDEV_CAP_SRC_E CardInfo23*/
		public int 		udwCardType;                                 /* 0：1：*/
		public byte[]   szCardID = new byte[NETDEV_LEN_32];                     /* ： 18*/
		public int 		udwCardStatus;                               /* ： */
		public byte[]   szName = new byte[NETDEV_LEN_256];                      /* ： [1,63] */
		public int 		udwGender;                                   /* ： NETDEV_GENDER_TYPE_E*/
		public byte[]   szBirthday = new byte[NETDEV_LEN_16];                   /* ： YYYYMMDD */
		public byte[]   szResidentialAddress = new byte[NETDEV_LEN_128];        /* ： */
		public byte[]   szIdentityNo = new byte[NETDEV_LEN_32];                 /* ： */
		public byte[]   szIssuingAuthority = new byte[NETDEV_LEN_128];          /* ： */
		public byte[]   szIssuingDate = new byte[NETDEV_LEN_16];                /* ： YYYYMMDD */
		public byte[]   szValidDateStart = new byte[NETDEV_LEN_16];             /* ： */
		public byte[]   szValidDateEnd = new byte[NETDEV_LEN_16];               /* ： */
		public NETDEV_FILE_INFO_S stIDImage;                       
		public byte[]    byRes = new byte[132];                                  
	}

	/**
	 * @enum tagNETDEVCtrlGateInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CTRL_GATE_INFO_S extends Structure
	{
		public int udwID;               /* ID */
		public int udwTimestamp;        
		public int udwCapSrc;           /*   NETDEV_CAP_SRC_E GateInfo4 */
		public int udwInPersonCnt;      
		public int udwOutPersonCnt;     
		public byte[]    byRes = new byte[128];          
	}

	/**
	 * @struct tagNETDEVMatchPersonInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_MATCH_PERSON_INFO_S extends Structure
	{
		public byte[]   szPersonName = new byte[NETDEV_LEN_256];        /*  [1,63] */
		public int udwGender;                           /*  NETDEV_GENDER_TYPE_E */
		public byte[]   szCardID = new byte[NETDEV_LEN_32];             
		public byte[]   szIdentityNo = new byte[NETDEV_LEN_32];         
		public byte[]   szPersonCode=new byte[NETDEV_LEN_64];         /*   :[1, 15] */
		public byte[]    byRes = new byte[64];                          
	}

	/**
	 * @struct tagNETDEVCtrlLibMatchInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_CTRL_LIB_MATCH_INFO_S extends Structure
	{
		public int udwID;                                   /* ID */
		public int udwLibID;                                /* ID */
		public int udwLibType;                              
		public int udwMatchStatus;                          /*  NETDEV_MATCH_STATUS_E */
		public int udwMatchPersonID;                        /* ID */
		public int udwMatchFaceID;                          /* ID */
		public NETDEV_MATCH_PERSON_INFO_S stMatchPersonInfo;   
		public byte[]    byRes = new byte[128];                              
	}

	/**
	 * @struct tagNETDEVPersonVerification
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PERSON_VERIFICATION_S extends Structure
	{
		public byte[]   szReference = new byte[NETDEV_LEN_128];                                      /* url */
		public int udwSeq;                                                           
		public int udwChannelID;                                                     /* ID VMS*/
		public byte[]   szChannelName = new byte[NETDEV_LEN_256];                    /*  [1,64]VMS */
		public int udwTimestamp;                                                     /*  UTC*/
		public int udwNotificationType;                                              /*  0：1： */
		public int udwFaceInfoNum;                                                   /*  ：[0, 1] */
		public Pointer pstCtrlFaceInfo;                               /*  (NETDEV_CTRL_FACE_INFO_S)*/
		public int udwCardInfoNum;                                                   /*  ：[0, 1] */
		public Pointer pstCtrlCardInfo;                               /*  (NETDEV_CTRL_CARD_INFO_S)*/
		public int udwGateInfoNum;                                                   /*  ：[0, 1] */
		public Pointer pstCtrlGateInfo;                               /*  (NETDEV_CTRL_GATE_INFO_S)*/
		public int udwLibMatInfoNum;                                                 /*  ：[0, 16] */
		public Pointer pstLibMatchInfo;                          /*  (NETDEV_CTRL_LIB_MATCH_INFO_S)*/
		public byte[]    byRes = new byte[128];                                                       
	}

	/**
	 * @struct tagACSTimeSection
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_TIME_SECTION_S extends Structure
	{
		public long   tStartTime;                                      /*  UTC s */
		public long   tEndTime;                                        /*  UTC s */

		public byte[]    byRes = new byte[32];                                       
	}

	/**
	 * @struct tagNETDEVACSPermissionInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERMISSION_INFO_S extends Structure
	{
		public int                       udwPermissionID;                   /* ID 	*/
		public byte[]                         szPermissionName = new byte[NETDEV_LEN_260];  
		public int                       udwPermissionType;                 /* ：01 */
		public NETDEV_OPERATE_LIST_S        stPersonList;                      /* IDdwSize*/
		public int                       udwTemplateID;                     /* ID */
		public NETDEV_ACS_TIME_SECTION_S    stValidTime;                       
		public NETDEV_OPERATE_LIST_S        stDoorList;                        /* , dwSize*/

		public byte[]    byRes = new byte[256];                      
	}


	/**
	 * @struct tagstNETDEVOperateList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_OPERATE_LIST_S extends Structure
	{
		public int   dwSize;                                 
		public Pointer   pstOperateInfo;       /* NETDEV_OPERATE_INFO_S */
	}

	/**
	 * @struct tagstNETDEVTimeTemplate
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TIME_TEMPLATE_S extends Structure
	{
		public byte[]    szTamplateName = new byte[NETDEV_NAME_MAX_LEN];        
		public byte[]    szTamplateDesc = new byte[NETDEV_DESCRIBE_MAX_LEN];    
		public int   dwTamplateID;                               /* ID */
	}

	/**
	 * @struct tagstNETDEVTimeTemplateList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_TIME_TEMPLATE_LIST_S extends Structure
	{
		public int   dwSize;                                                         
		public NETDEV_TIME_TEMPLATE_S[] astTimeTemplate = new NETDEV_TIME_TEMPLATE_S[NETDEV_TIME_TEMPLATE_NUM];       
	}

	/**
	 * @struct tagNETDEVACSFaceImage
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_FACE_IMAGE_S extends Structure
	{
		public int               udwNum;                            
		public NETDEV_FILE_INFO_S[] stImageList = new NETDEV_FILE_INFO_S[NETDEV_LEN_16];        
		public int               udwMajorImageIndex;                

		public byte[]    byRes = new byte[128];                        
	}

	/**
	 * @struct tagNETDEVACSStaffInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_STAFF_INFO_S extends Structure
	{
		public byte[]     szNumber = new byte[NETDEV_LEN_16];                               
		public byte[]     szBirthday = new byte[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           
		public byte[]     szDeptName = new byte[NETDEV_LEN_260];                            
		public int   udwDeptID;                                             /* ID */

		public byte[]    byRes = new byte[128];                                            
	}

	/**
	 * @struct tagNETDEVACSVisitorInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_VISITOR_INFO_S extends Structure
	{
		public byte[]   szVisitorCompany = new byte[NETDEV_LEN_260];       /*  [1,64] */
		public int udwVisitorCount;                        
		public int udwIntervieweeID;                       /* ID */
		public byte[]   szIntervieweeName = new byte[NETDEV_LEN_260];      /*  [1,64] */
		public byte[]   szIntervieweeDept = new byte[NETDEV_LEN_260];      /*  [1,64] */
		public NETDEV_ACS_TIME_SECTION_S   tScheduleTime;     
		public NETDEV_ACS_TIME_SECTION_S   tRealTime;         
		public int udwStatus;                              /*  NETDEV_ACS_VISIT_STATUS_E */

		public byte[]    byRes = new byte[128];                             
	}

	/**
	 * @struct tagNETDEVACSPersonInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERSON_INFO_S extends Structure
	{
		public int                          udwReqSeq;                          
		public int                          udwPersonID;                        
		public byte[]                            szName = new byte[NETDEV_LEN_260];             
		public int                          udwGender;                          /*   NETDEV_GENDER_TYPE_E*/
		public NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                     
		public byte[]                            szTelephone = new byte[NETDEV_LEN_64];         
		public byte[]                            szAddress = new byte[NETDEV_LEN_260];          
		public byte[]                            szDesc = new byte[NETDEV_LEN_480];             

		public int                          udwCardNum;                         /* [1,6] */
		public NETDEV_ACS_PERSON_CARD_INFO_S[]  stACSPersonCardList = new NETDEV_ACS_PERSON_CARD_INFO_S[NETDEV_LEN_6];    
		public NETDEV_ACS_FACE_IMAGE_S         stFaceImage;                        
		public int                          udwType;                            /*   NETDEV_ACS_PERSON_TYPE_E*/
		public NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                        
		public NETDEV_ACS_VISITOR_INFO_S       stVisitor;                          
		public byte[]    byRes = new byte[256];                         
	}

	/**
	 * @struct tagNETDEVACSPersonList
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERSON_LIST_S extends Structure
	{
		public int                      udwNum;                 
		public Pointer  pstPersonInfoList;      /*  udwNumNETDEV_ACS_PERSON_INFO_S*/
		public byte[]    byRes = new byte[128];             
	}

	/**
	 * @struct tagNETDEVFaceBatchInfo
	 * @brief   Device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_FACE_BATCH_INFO_S extends Structure
	{
		public int   udwReqSeq;         
		public int   udwResultCode;     
		public int   udwID;             
		public byte[]    byRes = new byte[128];         /*   Reserved */
	}

	/**
	 * @struct tagNETDEVFaceBatchList
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_FACE_BATCH_LIST_S extends Structure
	{
		public int                      udwNum;         
		public Pointer  pstBatchList;   /*  udwNumNETDEV_FACE_BATCH_INFO_S*/
		public byte[]    byRes = new byte[128];     /*   Reserved */
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_XW_BATCH_RESULT_WND_S extends Structure
	{
		public int  udwReqSeq;      
		public int  udwResuleCode;  
		public int  udwWinID;       /* ID */
	}

	/**
	 * @brief 
	 * @attention
	 */
	public class NETDEV_XW_BATCH_RESULT_LIST_S extends Structure
	{
		public int                              udwSize;            
		public int                              udwLastChange;      
		public Pointer      pstResultInfo;      /* , NETDEV_XW_BATCH_RESULT_WND_S*/
		public byte[]    byRes = new byte[32];          
	}

	/**
	 * @struct tagNETDEVCompareInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_COMPARE_INFO_S extends Structure
	{
		public NETDEV_FILE_INFO_S  stPersonImage;                    
		public NETDEV_FILE_INFO_S  stSnapshotImage;                  
		public byte[]    byRes = new byte[128];                       
	}

	/**
	 * @struct tagNETDEVACSAttendanceLogInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_ATTENDANCE_LOG_INFO_S extends Structure
	{
		public int udwAlarmType;                    
		public long  tTimeStamp;                      
		public byte[]   szDoorName = new byte[NETDEV_LEN_260];      
		public byte[]   szDoorNo = new byte[NETDEV_LEN_64];         
		public int udwDoorDirect;                   /*  0:,1: */
		public byte[]   szCardNo = new byte[NETDEV_LEN_64];         
		public byte[]   szPersonName = new byte[NETDEV_LEN_260];    
		public int udwPersonType;                   /*   NETDEV_ACS_PERSON_TYPE_E*/
		public byte[]   szPersonPhone = new byte[NETDEV_LEN_64];    
		public byte[]   szPersonDept = new byte[NETDEV_LEN_260];    
		public NETDEV_COMPARE_INFO_S stCompareInfo;    
		public NETDEV_FACE_ATTR_S    stFaceAttr;       
		public int udwCardStatus;                           /*  0： 1： */
		public NETDEV_CTRL_LIB_MATCH_INFO_S stLibMatchInfo;    
		public byte[]    byRes = new byte[256];                      
	}

	/**
	 * @struct tagNETDEVACSPersonBaseInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERSON_BASE_INFO_S extends Structure
	{
		public int                          udwPersonID;                    
		public byte[]                            szName = new byte[NETDEV_LEN_260];         
		public int                          udwGender;                      /*   NETDEV_GENDER_TYPE_E*/
		public NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                 
		public byte[]                            szTelephone = new byte[NETDEV_LEN_64];     
		public int                          udwCardID;                      
		public byte[]                            szCardNo = new byte[NETDEV_LEN_16];        
		public int                          udwType;                        /*   0  1*/
		public NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                    
		public NETDEV_ACS_VISITOR_INFO_S       stVisitor;                      
		public byte[]    byRes = new byte[256];                     
	}

	/**
	 * @struct tagACSPersonCard
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERSON_CARD_INFO_S extends Structure
	{
		public int                      udwCardID;                      /* ID */
		public int                      udwCardType;                    
		public int                      udwCardStatus;                  /*   # NETDEV_ACS_CARD_STATUS_E   */
		public byte[]                        szCardNo = new byte[NETDEV_LEN_64];        
		public int                      udwReqSeq;                      
		public NETDEV_ACS_TIME_SECTION_S   stValidTime;                    


		public byte[]    byRes = new byte[256];                     
	}

	/**
	 * @struct tagACSVisitLogInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_VISIT_LOG_INFO_S extends Structure
	{
		public int udwLogID;                                /* ID */
		public int udwVisitorID;                            /* ID */
		public byte[]   szVisitorName = new byte[NETDEV_LEN_260];           /*  [1,64] */
		public byte[]   szVisitorCompany = new byte[NETDEV_LEN_260];        /*  [1,64] */
		public byte[]   szVisitorPhone = new byte[NETDEV_LEN_64];           
		public byte[]   szCardNo = new byte[NETDEV_LEN_16];                 
		public int udwIntervieweeID;                        /* ID */
		public byte[]   szIntervieweeName = new byte[NETDEV_LEN_260];       /*  [1,64] */
		public byte[]   szIntervieweeDept = new byte[NETDEV_LEN_260];       /*  [1,64] */
		public long  tScheduleStartTime;                      /*  UTC s */
		public long  tRealStartTime;                          /*  UTC s */
		public int udwStatus;                               /*  NETDEV_ACS_VISIT_STATUS_E */
		public byte[]    byRes = new byte[256];                              
	}

	/**
	 * @struct tagNETDEVACSPersonBlacklistInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERSON_BLACKLIST_INFO_S extends Structure
	{
		public int                               udwBlackListID;                    /* ID */
		public NETDEV_FACE_MEMBER_ID_INFO_S         stIdentificationInfo;               

		public byte[]    byRes = new byte[256];                        
	}

	/**
	 * @struct tagNETDEVPagedQueryInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_PAGED_QUERY_INFO_S extends Structure
	{
		public int udwLimit;        
		public int udwOffset;       
		public byte[]    byRes = new byte[128];      
	}

	/**
	 * @struct tagNETDEVACSPermissionGroupInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_PERMISSION_GROUP_INFO_S extends Structure
	{
		public int                       udwPermissionGroupID ;                  /* ID */
		public byte[]                         szPermissionGroupName = new byte[NETDEV_LEN_260];  

		public byte[]    byRes = new byte[256];                             
	}

	/**
	 * @struct tagNETDEVACSDoorPermissionInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_ACS_DOOR_PERMISSION_INFO_S extends Structure
	{
		public int                                  udwPermissionNum;                  
		public NETDEV_ACS_TIME_SECTION_S               stValidTime;                       
		public Pointer    pstPermissionGroupList;            /* .Num0,NETDEV_ACS_PERMISSION_GROUP_INFO_S */
		public byte[]    byRes = new byte[256];                         
	}

	/**
	 * @brief   Protocol info
	 * @attention  None
	 */
	public class NETDEV_UPNP_PORT_STATE_S extends Structure
	{
		public int                    eType;                            /* # NETDEV_PROTOCOL_TYPE_E  Protocol type, see enumeration #NETDEV_PROTOCOL_TYPE_E */
		public int                    bEnbale;                          /*   Supported or not */
		public int                    dwPort;                           /*   Port number */
		public byte[]                 byRes = new byte[128];                       /*   Reserved */
	}

	/**
	 * @brief   Protocol info list
	 * @attention  None
	 */
	public class NETDEV_UPNP_NAT_STATE_S extends Structure
	{
		public int   dwSize;                                            /*   Number of protocols */
		public NETDEV_UPNP_PORT_STATE_S[]  astUpnpPort = new NETDEV_UPNP_PORT_STATE_S[NETDEV_LEN_16];      /*   Protocol info */
	}

	/**
	 * @struct tagstNETDEVDevChnAlarmOutInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_DEV_CHN_ALARMOUT_INFO_S extends Structure
	{
		public NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;    
		public int                       dwRunMode;        /* /#NETDEV_BOOLEAN_MODE_E */
		public int                       dwDuration;       /* ：(ms) */
		public int                      udwRelayMode;       /*  1： 2： */
		public int                      udwAlarmOutputNum;
		public byte[]                   byRes = new byte[252];       
	}

	/**
	 * @struct tagNETDEVTrafficStatisticsCondEx
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S extends Structure
	{
		public NETDEV_OPERATE_LIST_S   stChannelIDs;               /* ID */
		public int                  udwStatisticsType;             /*  NETDEV_TRAFFIC_STATISTICS_TYPE_E */
		public int                  udwFormType;                   /*  NETDEV_TRAFFIC_STATIC_FORM_TYPE_E */
		public long                   tBeginTime;                  
		public long                   tEndTime;                    
		public byte[]                    byRes = new byte[256];
	}

	/**
	 * @struct tagNETDEVTrafficStatisticsInfo
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_TRAFFIC_STATISTICS_INFO_S extends Structure
	{
		public int  bIsSuccess;                                    
		public int  dwChannelID;                                   
		public int  udwSize;                                       
		public int  audwEnterCount[] = new int[NETDEV_PEOPLE_CNT_MAX_NUM];     
		public int  audwExitCount[] = new int[NETDEV_PEOPLE_CNT_MAX_NUM];      
		public byte[]    byRes = new byte[6];                                      
	}

	/**
	 * @brief   Manual Record structure definition
	 * @attention
	 */
	public class NETDEV_MANUAL_RECORD_CFG_S extends Structure
	{
		public int                   dwChannelID;        /*   ChannelID */
		public int                   enRecordType;       /*  Record type #NETDEV_RECORD_TYPE_E */
		public byte[]                byRes = new byte[64];          /*   Reserved */
	}

	/**
	 * @brief   Route information of PTZ route patrol Structure definition
	 * @attention  None
	 */
	public class NETDEV_PTZ_TRACK_INFO_S extends Structure
	{
		public int dwTrackNum;                                               /*   Number of existing patrol routes */
		public byte[]  aszTrackName = new byte[NETDEV_TRACK_CRUISE_MAXNUM*NETDEV_LEN_64];  /*   Route name */
	}

	/**
	 * @brief  
	 * @attention  None
	 */
	public class NETDEV_DEV_ADDR_INFO_S extends Structure
	{
		public byte[]    szUserName = new byte[NETDEV_LEN_64];          /*  User Name */
		public byte[]    szPassword = new byte[NETDEV_LEN_64];          /*  Password */
		public byte[]    szIPv4Address = new byte[NETDEV_LEN_32];       /* IPv4IP  IP address of IPv4 */
		public byte[]    szIPv4GateWay = new byte[NETDEV_LEN_32];       /* IPv4  Gateway of IPv4 */
		public byte[]    szIPv4SubnetMask = new byte[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
		public byte[]    szDevSerailNum = new byte[NETDEV_LEN_64];      /*   Device serial number */
		public byte[]    szDevMac = new byte[NETDEV_LEN_64];            /* MAC  Device MAC address */
		public byte[]    byRes = new byte[512];                         /*   Reserved */
	}

	/**
	 * @brief    Structure definition
	 * @attention  None
	 */
	public class NETDEV_VIDEO_CHL_DETAIL_INFO_S extends Structure
	{
		public int                        dwChannelID;                        /* ID  Channel ID */
		public int                        bPtzSupported;                      /*  Whether ptz is supported */
		public int                        enStatus;                           /*   Channel status NETDEV_CHANNEL_STATUS_E*/
		public int                        dwStreamNum;                        /*   Number of streams enStatusNETDEV_CHL_STATUS_UNBIND*/
		public byte[]                     szChnName = new byte[NETDEV_LEN_64];           /*  Channel Name */
		public byte[]                     byRes = new byte[4];                           /*   Reserved field*/
	};

	/**
	 * @struct tagNETDEVChlDeviceInfo
	 * @brief   Basic device information Structure definition
	 * @attention  None
	 */
	public class NETDEV_DEVICE_CHL_INFO_S extends Structure
	{
		public int dwChannelID;                                  
		public byte[] szDevModel = new byte[NETDEV_LEN_64];                     /*   Device model */
		public byte[] szSerialNum = new byte[NETDEV_LEN_64];                    /*   Hardware serial number */
		public byte[] szFirmwareVersion = new byte[NETDEV_LEN_64];              /*   Software version */
		public byte[] szHardewareID = new byte[NETDEV_LEN_64];                  
		public byte[] szUbootVersion = new byte[NETDEV_LEN_64];                 /* UBOOT */
		public byte[] byRes = new byte[512];                                    /*   Reserved */
	}

	/**
	 * @struct tagstNETDEV_VoiceBroadcastChlInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VOICE_BROADCAST_CHL_INFO_S extends Structure
	{
		public int  dwChannelID;               /* ID */
		public int  dwResultCode;              
		public int  dwStatus;                  
	}

	/**
	 * @struct tagstNETDEV_VoiceBroadcastGroupInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VOICE_BROADCAST_GROUP_INFO_S extends Structure
	{
		public int                                  dwSize;                                                        
		public NETDEV_VOICE_BROADCAST_CHL_INFO_S[]      astChlInfoList = new NETDEV_VOICE_BROADCAST_CHL_INFO_S[NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX];        
	}

	/**
	 * @struct tagstNETDEV_ModifyVoiceBroadcastInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_MODIFY_VOICE_BROADCAST_INFO_S extends Structure
	{
		public Pointer     pstAddChannelList;      /*   NETDEV_OPERATE_LIST_S*/
		public Pointer     pstDelChannelList;      /*   NETDEV_OPERATE_LIST_S*/
	}

	/**
	 * @struct tagstNETDEV_VoiceBroadcastCtrlInfo
	 * @brief 
	 * @attention
	 */
	public class NETDEV_VOICE_BROADCAST_CTRL_INFO_S extends Structure
	{
		public int   dwChannelID;             /* ID */
		public int   udwStatus;               /* ,(1),(0) */
	}

	/**
	 * @brief   Log query condition Structure definition
	 * @attention  None
	 */
	public class NETDEV_FIND_LOG_COND_S extends Structure
	{
		public int      dwMainType;         /* , #NETDEV_LOG_MAIN_TYPE_E。 Log type. See #NETDEV_LOG_MAIN_TYPE_E for reference */
		public int      dwSubType;          /* , #NETDEV_LOG_SUB_TYPE_E。 Sub type. See #NETDEV_LOG_SUB_TYPE_E for reference */
		public long      tBeginTime;         /*   Start time */
		public long      tEndTime;           /*   End time */
		public int      dwLimitNum;         /*  Number of each query*/
		public int      dwOffset;           /* 0 Start search from No. X. X starts from 0*/
	}

	/**
	 * @brief   Definition of log info structure
	 * @attention 
	 */
	public class NETDEV_LOG_INFO_S extends Structure
	{
		public long       tTime;                                  /*  Log time*/
		public int       dwMainType;                             /* ,  #NETDEV_LOG_MAIN_TYPE_E。 Main Type.See #NETDEV_LOG_MAIN_TYPE_E for reference*/
		public int       dwSubType;                              /* ,  #NETDEV_LOG_SUB_TYPE_E。 Sub Type.See #NETDEV_LOG_SUB_TYPE_E for reference*/
		public int       dwChannelID;                            /*  Log source*/
		public byte[]        szUserName = new byte[NETDEV_NAME_MAX_LEN];        /*  Username*/
		public byte[]        szUserAddr = new byte[NETDEV_IPADDR_STR_MAX_LEN];  /* IP User IP address*/
		public byte[]        szDetailInfo = new byte[NETDEV_LEN_256];           /* [1,64] NVR Detail info[1,64] NVR Only */
		public byte[]        szOperObject = new byte[NETDEV_LEN_256];           /* [1,64] VMS Opera object[1,64] VMS Only */
		public int      udwOperResult;                          /*  VMS Opera result VMS Only */
		public byte[]        szDevName = new byte[NETDEV_LEN_256];              /* [1,64] Device name of operation[1,64] VMS Only*/
		public byte[]        szOrgName = new byte[NETDEV_LEN_256];              /* [1,64] Org Name of operation[1,64] VMS Only */
		public byte[]        bRes = new byte[256];                              /*  Reserved */
	}

	/**
	 * @struct tagNETDEVAlarmFindConds
	 * @brief  
	 * @attention 
	 */
	public class NETDEV_FIND_ALARM_COND_S extends Structure
	{
		public int   dwChannelID;      /* ID */
		public long   tBeginTime;       
		public long   tEndTime;         
		public byte[]   byRes = new byte[128];       /*   Reserved */
	}
	/**
	 * @struct tagNETDEVFindAlarmInfo
	 * @brief  
	 * @attention 
	 */
	public class NETDEV_FIND_ALARM_INFO_S extends Structure
	{
		public long    tAlarmTime;        
		public int    dwAlarmType;       /* , #NETDEV_FIND_ALARM_TYPE_E */
		public byte[]     byRes = new byte[256];        /*   Reserved */
	}

	public class NETDEV_ALARM_SNAPSHOT_COND_S extends Structure
	{
		public int                           dwChannelID;                                /*   Channel number  *100+0*/
		public long                          tAlarmTime;                                 
		public int                          enAlarmType;                                /*  NETDEV_ALARM_SNAPSHOT_TYPE_E */
		public byte[]                       byRes = new byte[244];                                 /*   Reserved */
	}

	public class NETDEV_ALARM_SNAPSHOT_PIC_S extends Structure
	{
		public byte[]    szURL = new byte[NETDEV_MAX_URL_LEN];  /* URL */
		public byte[]    szName = new byte[NETDEV_LEN_64];      
		public int   dwSize;                     
		public byte[]    byRes = new byte[256];                 /*   Reserved */
	}

	public class NETDEV_PIC_FILE_INFO_S extends Structure
	{
		public byte[]    szURL = new byte[NETDEV_MAX_URL_LEN];         /* URL */
		public int    bSaveLocal;                        /* TUREFALSE */
		public byte[]    szFileName = new byte[NETDEV_LEN_260];        
		public Pointer   pcBuffer;                          /* ,dwSize CHAR* */
		public int   dwSize;                            
		public int   dwCaptureMode;                     /* ,#NETDEV_PICTURE_FORMAT_E*/
		public byte[]    byRes = new byte[252];                        /*   Reserved */
	}

	/**
	 * @struct tagQueryCondition
	 * @brief 
	 * @attention
	 */
	public class NETDEV_QUERY_CHN_CONDITION_S extends Structure
	{
		public int         dwLimit;                   /* 200  */
		public int         dwOffset;                  /* 0 */
		public int         dwQryInfoNum;              
		public Pointer     pstQueryInfo;              /*   NETDEV_QUERY_INFO_S*/
		public int         dwRecursion;               /*      0： 1： 2： */
		public byte[]      byRes = new byte[260];     /*   Reserved */
	}
	
	/*
	* @struct tagNETDEVPicQueryCond
	* @brief 
	* @attention  None
	*/
	public class NETDEV_PIC_QUERY_COND_S extends Structure
	{
		public int         udwSearchID;                   
		public int         udwLimit;                      
		public int         udwOffset;                     /* 0 */
		public byte[]      byRes = new byte[128];         /*   Reserved */
	}
	
	/*
	* @struct tagNETDEVPicQueryResult
	* @brief 
	* @attention  None
	*/
	public class NETDEV_PIC_QUERY_RESULT_S extends Structure
	{
		public int         udwTotal;                      
		public int         udwNum;                        
		public byte[]      byRes = new byte[128];         /*   Reserved */
	}
	
	/**
	 * @struct tagNETDEVSingleObjectInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_SINGLE_OBJECT_INFO_S extends Structure
	{
		public int                               udwObjectType;                 /*  #  NETDEV_OBJECT_TYPE_E */                    
		public NETDEV_FACE_STRUCT_INFO_S         stFaceInfo;                    
		public NETDEV_PERSON_STRUCT_INFO_S       stPersonInfo;                  
		public NETDEV_NON_MOTOR_VEH_INFO_S       stNonMotorVehInfo;             
		public NETDEV_VEH_INFO_S                 stVehInfo;                     
		public byte[]                            byRes = new byte[256];         /*   Reserved */
	}
	
	/*
	* @struct tagNETDEVObjectInfoList
	* @brief 
	* @attention  None
	*/
	public class NETDEV_OBJECT_INFO_LIST_S extends Structure
	{
		public int                                 udwObjectID;                    /* ID */                  
		public NETDEV_FILE_INFO_S                  stSmallImageInfo;               /*   1 */
		public NETDEV_SINGLE_OBJECT_INFO_S         stObjectInfo;                   
		public byte[]                              byRes = new byte[1024];         /*   Reserved */
	}
	
	/*
	* @struct tagNETDEVObjectResultInfo
	* @brief 
	* @attention  None
	*/
	public class NETDEV_OBJECT_RESULT_INFO_S extends Structure
	{
		public int                    udwRecordID;                                  /* ID */
		public int                    udwType;                                      /*   NETDEV_OBJECT_RECORD_TYPE_E  */
		public int                    udwTime;                                      /* UTC  */
		public byte[]                 szChannelName = new byte[NETDEV_LEN_256];     /* [1,63] */
		public int                    udwChannelID;                                 /* ID */
		public NETDEV_FILE_INFO_S     stBigImageInfo;                               /*  1M  */
		public int                    udwObjectInfoNum;                             
		public Pointer                pstObjectInfoList;                            /*  NETDEV_OBJECT_INFO_LIST_S   */
		public byte[]                 byRes = new byte[512];                        /*   Reserved */
	}
	
	/**
	 * @struct tagNETDEVAudioFileCapability
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_FILE_CAPABILITY_S extends Structure
	{
		public int udwMaxNum;                                                     
		public int udwMaxSize;                                                    /* KB */
		public int udwFormatNum;                                                  
		public byte[]    szFormatList = new byte[NETDEV_LEN_256];                 /*  xx;xx;xx;…FormatNum0,pcmg711a */
		public byte[]    byRes = new byte[256];                                   
	}
	
	/**
	 * @struct tagNETDEVLanguageCapability
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_LANGUAGE_CAPABILITY_S extends Structure
	{
		public int       udwNum;                                                
		public int       audwLanguage[] = new int[NETDEV_LEN_256];              /* [1-16]  NETDEV_LANG_TYPE_E */
		public byte[]    byRes = new byte[256];                                 
	}
	
	/**
	 * @struct tagNETDEVSysCapability
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_SYS_CAPABILITY_S extends Structure
	{
		public  NETDEV_AUDIO_FILE_CAPABILITY_S   stAudioFileCapability;        
		public  NETDEV_LANGUAGE_CAPABILITY_S     stLanguageCapability;         
		public  byte[]                           byRes = new byte[256];        
	}
	
	/**
	 * @struct tagNETDEVAudioOutputCfg
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_OUTPUT_CFG_S extends Structure
	{
		public int       udwType;                                              /*   NETDEV_AUDIO_CHL_MODE_E */
		public int       udwGain;                                              /*  [0,255] AudioOutTypeNum0 */
		public byte[]    byRes = new byte[256];                                
	}
	
	/**
	* @struct tagNETDEVAudioInputModeInfo
	* @brief 
	* attention None
	*/
	public class NETDEV_AUDIO_IN_MODE_INFO_S extends Structure
	{
		public int       dwChannelID;                                                   
		public int       udwModeNum;                                                    
		public int       audwModeList[] = new int[NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM];    /*  #NETDEV_AUDIO_CHL_MODE_E */
		public byte[]    byRes = new byte[128];                                         
		
	}
	
	/**
	* @struct tagNETDEVAudioInputEncodeFormatInfo
	* @brief 
	* attention None
	*/
	public class NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S extends Structure
	{
		public int       udwType;                                                               /* # NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
		public int       udwSamplingRateNum;                                                    
		public int       audwSamplingRateList[] = new int[NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM];    /*  # NETDEV_AUDIO_SAMPLING_RATE_E */
		public byte[]    byRes = new byte[128];                                                 
	}
	
	/**
	 * @struct tagNETDEVAudioCapInfo
	 * @brief 
	 * @attention  None
	 */
	public class NETDEV_AUDIO_CAP_S extends Structure
	{
		public int       dwAudioInNum;                                                                                                                               
		public NETDEV_AUDIO_IN_MODE_INFO_S[]               astChlInfoList = new NETDEV_AUDIO_IN_MODE_INFO_S[NETDEV_AUDIO_IN_MAX_NUM];                                
		public int       dwAudioInEncFmtNum;                                                                                                                         
		public NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S[]      astAudioInEncFmtList = new NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S[NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM];   
		public int       dwSerialInNum;                                                                                                                              
		public NETDEV_AUDIO_IN_MODE_INFO_S[]               astSerialInModeList = new NETDEV_AUDIO_IN_MODE_INFO_S[NETDEV_AUDIO_IN_MAX_NUM];                           
		public int       dwSerialInEncFmtNum;                                                                                                                        
		public NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S[]      astSerialInEncFmtList = new NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S[NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM];  
		public int       dwAudioOutTypeNum;	                                                                                                                         
		public int                                         audwAudioOutTypeList[] = new int[NETDEV_LEN_4];                                                           /*   NETDEV_AUDIO_CHL_MODE_E */
		public int       dwBoolSupportAudioOutGain;                                                                                                                  /*  0： 1： */
		public byte[]    byRes = new byte[232];                                                                                                                                           	
	}
	
	/***********************************************************************
	 ** 
	 ***********************************************************************/
	//JNA StdCallCallback,

	/**
	 *   Type of pointer to media stream data callback function before being framed
	 * @param [IN] lpPlayHandle       Current live playing handle
	 * @param [IN] pucBuffer          Pointer to buffer that stores stream data that is not framed
	 * @param [IN] dwBufSize          Buffer size
	 * @param [IN] dwMediaDataType   ,#NETDEV_MEDIA_DATA_FORMAT_E Media data type, see definitions of enumeration #NETDEV_MEDIA_DATA_TYPE_E
	 * @param [IN] lpUserParam       ,#NDPlayer_SetSourceMediaDataCB User-set parameters, specified by users when they call the #NDPlayer_SetSourceMediaDataCB function
	 * @return . None.
	 * @note  ,,. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
	 */
	public interface NETDEV_SOURCE_DATA_CALLBACK_PF extends StdCallCallback {
		public void invoke(Pointer lpPlayHandle, Pointer pucBuffer, int dwBufSize, int dwMediaDataType, Pointer lpUserParam);
	}

	/**
	 *   Type of pointer to callback function for decoded video stream data
	 * @param [IN] lpPlayHandle       Current live playing handle
	 * @param [IN] pstPictureData     Pointer to buffer that stores decoded video stream data
	 * @param [IN] lpUserParam       ,#NDPlayer_SetDecodeVideoDataCB User-set parameters, specified by users when they call the #NDPlayer_SetDecodeVideoDataCB function
	 * @return . None.
	 * @note
	 * -     1.,,.
	 * -     1. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
	 * -     2.yv12.“Y0-Y1-......,“U0-U1-......,“V0-V1-......
	 * -     2. Video data is in yv12 format in sequence of Y0-Y1-......, U0-U1-......, V0-V1-......
	 */
	public interface NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF extends StdCallCallback {
		public void invoke(Pointer lpPlayHandle, NETDEV_PICTURE_DATA_S pstPictureData, Pointer lpUserParam);
	}

	/**
	 *  Device discovery callback function
	 * @param [IN] pstDevInfo                 Device info
	 * @param [IN] lpUserData                 User data
	 * @note
	 */
	public interface NETDEV_DISCOVERY_CALLBACK_PF extends StdCallCallback {
		public void invoke(NETDEV_DISCOVERY_DEVINFO_S pstDevInfo, Pointer lpUserData);
	}

	/**
	 *   Type of pointer to callback function for decoded audio stream data
	 * @param [IN] lpPlayHandle    Current live playing handle
	 * @param [IN] pstWaveData     Pointer to buffer that stores decoded audio stream data
	 * @param [IN] lpUserParam    ,#NDPlayer_SetDecodeAudioDataCB User-set parameters, specified by users when they call the #NDPlayer_SetDecodeAudioDataCB function
	 * @return . None.
	 * @note
	 * -     ,,.
	 * -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
	 */
	public interface NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF extends StdCallCallback {
		public void invoke(Pointer lpPlayHandle, NETDEV_WAVE_DATA_S pstWaveData, Pointer lpUserParam);
	}

	/**
	 * 
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstFaceSnapShotData     
	 * @param [IN] lpUserData                 User data
	 * @note  None
	 */
	public interface NETDEV_FaceSnapshotCallBack_PF extends StdCallCallback {
		public void invoke(Pointer lpUserID, NETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S pstFaceSnapShotData, Pointer lpUserData);
	}

	/**
	 * 
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstHeatMapData          
	 * @param [IN] lpUserData                 User data
	 * @note  None
	 */
	public interface NETDEV_CarPlateCallBack_PF extends StdCallCallback {
		public void invoke(Pointer lpUserID, NETDEV_TMS_CAR_PLATE_INFO_S pstCarPlateData, Pointer lpUserParam);
	}

	/**
	 *   Callback function for passenger flow statistic message
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstPassengerFlowData     Passenger flow data
	 * @param [IN] lpUserData                 User data
	 * @note  None
	 */
	public interface NETDEV_PassengerFlowStatisticCallBack_PF extends StdCallCallback {
		public void invoke(Pointer lpUserID, NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S pstPassengerFlowData, Pointer lpUserData);
	}

	/**
	 *  Callback function to receive alarm information
	 * @param [IN] lpUserID              ID
	 * @param [IN] pstReportInfo          Alarm information
	 * @param [IN] lpBuf                  Pointer to buffer
	 * @param [IN] dwBufLen               Length of structure for alarm information
	 * @param [IN] dwBufLen               User data
	 * @note
	 */
	public interface NETDEV_AlarmMessCallBack_PF_V30 extends StdCallCallback {
		public void invoke(Pointer lpUserID, NETDEV_REPORT_INFO_S  pstReportInfo, Pointer lpBuf, int dwBufLen, Pointer lpUserData);
	}

	/**
	 * .  Callback function to receive exception and reconnection messages
	 * @param [IN] lpUserID      User login ID
	 * @param [IN] dwType       :NETDEV_EXCEPTION_TYPE_E Type of exception or reconnection message: NETDEV_EXCEPTION_TYPE_E
	 * @param [IN] lpExpHandle   Exception type handle
	 * @param [IN] lpUserData    User data
	 * @param [OUT] pstExceptionOutputInfo    Exception output information
	 * @note
	 */
	public interface NETDEV_ExceptionCallBack_PF extends StdCallCallback {
		public void invoke(Pointer lpUserID, int dwType, Pointer lpExpHandle, Pointer lpUserData, NETDEV_EXCEPTION_OUTPUT_INFO_S pstExceptionOutputInfo);
	}

	/**
	 *         Callback function to receive alarm information
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstAlarmInfo             Alarm information
	 * @param [IN] pstAlarmData             Alarm data
	 * @param [IN] lpUserData               User data
	 * @note
	 */
	public interface NETDEV_StructAlarmMessCallBack_PF extends StdCallCallback {
		public void invoke(Pointer lpUserID,NETDEV_STRUCT_ALARM_INFO_S pstAlarmInfo,NETDEV_STRUCT_DATA_INFO_S pstAlarmData,Pointer    lpUserData);
	}

	/**
	 *   Callback function to receive alarm information
	 * @param [IN] lpUserID               User login ID
	 * @param [IN] pstAlarmPersonData     Data of Person Alarm
	 * @param [IN] lpUserData             User data
	 * @note
	 */
	public interface NETDEV_PersonAlarmMessCallBack_PF extends StdCallCallback{
		public void invoke(Pointer lpUserID, NETDEV_PERSON_EVENT_INFO_S pstAlarmData, Pointer lpUserData);
	}

	/**
	 *  Callback function to receive alarm information
	 * @param [IN] lpUserID                ID
	 * @param [IN] pstVehicleAlarmInfo      Alarm information
	 * @param [IN] lpBuf                    Pointer to buffer
	 * @param [IN] dwBufLen                 Length of structure for alarm information
	 * @param [IN] dwBufLen                 User data
	 * @note   
	 */
	public interface NETDEV_VehicleAlarmMessCallBack_PF extends StdCallCallback{
		public void invoke (Pointer lpUserID, NETDEV_VEH_RECOGNITION_EVENT_S pstVehicleAlarmInfo, Pointer lpBuf, int dwBufLen, Pointer lpUserData);
	}

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] stParkAlarmInfo         
	 * @param [IN] lpUserData              
	 * @note
	 */
	public interface  NETDEV_ParkEventMessCallBack_PF extends StdCallCallback{
		public void invoke(Pointer lpUserID, NETDEV_PARK_EVENT_INFO_S stParkAlarmInfo, Pointer lpUserData);
	}

	/**
	 *               Callback function to receive alarm information
	 * @param [IN] lpUserID                 User login ID
	 * @param [IN] pstAlarmData             Alarm information
	 * @param [IN] lpUserData               User data
	 * @note
	 */
	public interface NETDEV_AlarmMessFGCallBack_PF extends StdCallCallback{
		public void invoke (Pointer lpUserID, NETDEV_PERSON_VERIFICATION_S pstAlarmData, Pointer lpUserData);
	}

	/**
	 * SDK   SDK initialization
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note  Thread not safe
	 */
	public boolean NETDEV_Init();

	/**
	 *  Registered device discovery callback function
	 * @param [IN] cbDiscoveryCallBack    NETDEV_DISCOVERY_CALLBACK_PF
	 * @param [IN] lpUserData             User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_SetDiscoveryCallBack(NETDEV_DISCOVERY_CALLBACK_PF cbDiscoveryCallBack, Pointer lpUserData);

	/**
	 *  ,,
	 * This interface is used for device discovery. Please first register callback functions related to device discovery and use this interface for device discovery. Discovered device info will be included in the callback function.
	 * @param [IN]   pszBeginIP                 IP
	 * @param [IN]   pszEndIP                   IP
	 * @return TRUE,
	 * @note pszBeginIPpszEndIP"0.0.0.0",
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_Discovery(String pszBeginIP,String pszEndIP);

	/**
	 * 
	 * @param [IN]  pstDevLoginInfo  
	 * @param [OUT] pstSELogInfo     
	 * @return ID。
	 * @note LAPI
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public Pointer NETDEV_Login_V30(NETDEV_DEVICE_LOGIN_INFO_S pstDevLoginInfo, NETDEV_SELOG_INFO_S pstSELogInfo);

	/**
	 *   Query channel info list
	 * @param [IN]    lpUserID            User login ID
	 * @param [INOUT] pdwChlCount         Number of channels
	 * @param [OUT]   pstVideoChlList     List of channel info list
	 * @return TRUE, TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_QueryVideoChlDetailListEx(Pointer lpUserID, IntByReference pdwChlCount, NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S[] pstVideoChlList);

	/**
	 *   Start live preview
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  pstPreviewInfo       ,：NETDEV_PROTOCAL_E,NETDEV_LIVE_STREAM_INDEX_E. Preview parameter, see enumeration: NETDEV_PROTOCAL_E, NETDEV_LIVE_STREAM_INDEX_E.
	 * @param [IN]  cbPlayDataCallBack   NETDEV_SOURCE_DATA_CALLBACK_PF
	 * @param [IN]  lpUserData            User data
	 * @return , 0 ,. Returned user login ID. 0 indicates failure, and other values indicate the user ID.
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public Pointer NETDEV_RealPlay(Pointer lpUserID, NETDEV_PREVIEWINFO_S stPreviewInfo, NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack, Pointer lpUserData);

	/**
	 * :  Callback function to register streams (original stream)
	 * @param [IN]  lpPlayHandle                Live preview handle
	 * @param [IN]  cbSourceDataCallBack       NETDEV_SOURCE_DATA_CALLBACK_PF
	 * @param [IN]  bContinue                  . Whether to continue to following framing, decoding and displaying operations.
	 * @param [IN]  lpUser                      User data
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_SetPlayDataCallBack(Pointer lpPlayHandle, NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack, int bContinue, Pointer lpUser);

	/**
	 * ：  Callback function to register live stream (decoded media stream data)
	 * @param [IN]  lpPlayHandle                 \ Preview\playback handle
	 * @param [IN]  cbPlayDecodeVideoCALLBACK     NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF
	 * @param [IN]  bContinue                     Whether to continue to following displaying operations.
	 * @param [IN]  lpUserData                    User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * - ,NULL.
	 * - To shut the callback function, set the second parameter as NULL.
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_SetPlayDecodeVideoCB(Pointer lpPlayHandle, NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK, int bContinue, Pointer lpUserData);

	/**
	 *   Local recording
	 * @param [IN]  lpPlayHandle          Preview handle
	 * @param [IN]  pszSaveFileName       Name of saved file
	 * @param [IN]  dwFormat             Format of saved file, see #NETDEV_MEDIA_FILE_FORMAT_E
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_SaveRealData(Pointer lpPlayHandle, String pszSaveFileName, int dwFormat);

	/**
	 *  Stop local recording
	 * @param [IN]  lpPlayHandle      Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_StopSaveRealData(Pointer lpPlayHandle);

	/**
	 *   Stop live preview
	 * @param [IN]  lpPlayHandle      Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note NETDEV_RealPlay Stop the live view started by NETDEV_RealPlay
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_StopRealPlay(Pointer lpPlayHandle);

	/**
	 *   User logout
	 * @param [IN] lpUserID     User login ID
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_Logout(Pointer lpUserID);

	/**
	 * SDK   SDK cleaning
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_Cleanup();

	/**
	 *  Set log path
	 * @param [IN]   pszLogPath  ()  Log path (file name not included)
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 * @note win32 VMS
	 */
	public boolean NETDEV_SetLogPath(String pszLogPath);

	/**
	 *  Set log file size and number
	 * @param [IN] dwLogFileSize     () The size of single log file //30M
	 * @param [IN] dwLogFileNum        Log file number
	 * @return TRUE, TRUE means success, any other value indicates failure.
	 * @note
	 */
	public boolean NETDEV_ConfigLogFile(int dwLogFileSize, int dwLogFileNum);

	/**
	 *  Set write log flag
	 * @param [IN]   bWriteLogFlag    1:,0：
	 * @return VOID
	 * @note
	 */
	public boolean NETDEV_SetWriteLogFlag(int bWriteLogFlag);

	/**
	 *  Set timeout
	 * @param [IN]  pstRevTimeout          Pointer to timeout
	 * @return TRUE,    TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetRevTimeOut(NETDEV_REV_TIMEOUT_S pstRevTimeout);

	/**
	 *  Set keep-alive parameters
	 * @param [IN]  dwWaitTime              Waiting time
	 * @param [IN]  dwTrytimes              Connecting attempts
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetConnectTime(int dwWaitTime, int dwTrytimes);

	/**
	 *  Start two-way audio
	 * @param [IN]  lpUserID                   User ID
	 * @param [IN]  dwChannelID                Channel ID
	 * @param [IN]  cbRealDataCallBack        NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF
	 * @param [IN]  lpUserData                  User data
	 * @return , 0 , Returned user ID. 0 means failure, and any other value is a user ID.
	 * @note win64 NVR IPC
	 * @note Win32 VMS
	 */
	public Pointer NETDEV_StartVoiceCom(Pointer lpUserID, int dwChannelID, NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF cbPlayDataCallBack,  Pointer lpUserData);

	/**
	 *  Stop two-way audio
	 * @param [IN]  lpPlayHandle    Two-way audio handle
	 * @return TRUE, TRUE means success, any other value indicates failure.
	 * @note win64 NVR IPC
	 * @note Win32 VMS
	 */
	public boolean NETDEV_StopVoiceCom(Pointer lpPlayHandle);

	/**
	 *  Start voice broadcast
	 * @param [IN]  lpUserID          User login ID
	 * @param [IN]  dwChannelID        Channel ID
	 * @return , 0 , Returned user ID. 0 means failure, and any other value is a user ID.
	 * @note , Voice broadcast and two-way audio for one channel are available.
	 */
	public Pointer NETDEV_StartVoiceBroadcast(Pointer lpUserID, int dwChannelID);

	/**
	 *  Stop voice broadcast
	 * @param [IN]  lpPlayHandle    voice broadcast handle
	 * @return TRUE, TRUE means success, any other value indicates failure.
	 * @note
	 */
	public boolean NETDEV_StopVoiceBroadcast(Pointer lpPlayHandle);

	/**
	 * 
	 * @param [IN]  lpUserID                 ID
	 * @param [IN]  dwChannelID              
	 * @return , 0 
	 * @note
	 */
	public Pointer NETDEV_StartInputVoiceSrv(Pointer lpUserID, int dwChannelID);

	/**
	 * 
	 * @param [IN]  lpVoiceComHandle   
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_StopInputVoiceSrv(Pointer lpVoiceComHandle);

	/**
	 * 
	 * @param [IN]  lpVoiceComHandle         
	 * @param [IN] lpDataBuf                 
	 * @param [IN] dwDataLen                 
	 * @param [IN] pstVoiceParam             
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_InputVoiceData(Pointer lpVoiceComHandle, byte[] lpDataBuf, int dwDataLen,NETDEV_AUDIO_SAMPLE_PARAM_S pstVoiceParam);

	/**
	 *  Turn on microphone
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_OpenMic(Pointer lpPlayHandle);

	/**
	 *  Turn off microphone
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_CloseMic(Pointer lpPlayHandle);

	/**
	 *   Adjust sound volume of microphone
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [IN]  dwVolume              Sound volume
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_MicVolumeControl(Pointer lpPlayHandle, int dwVolume);

	/**
	 *  Get mic volume
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [OUT]  dwVolume              Sound volume
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetMicVolume(Pointer lpPlayHandle, IntByReference pdwVolume);

	/**
	 *  Get mute status
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [OUT]  pbMute            Mute status
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetMuteStatus(Pointer lpPlayHandle, IntByReference pbMute);

	/**
	 *  Set mute status
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [IN]  pbMute            Mute status
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetMuteStatus(Pointer lpPlayHandle, int pbMute);

	/**
	 *   Enable sound
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_OpenSound(Pointer lpPlayHandle);

	/**
	 *  Control sound volume
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [IN]  dwVolume        Volume
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SoundVolumeControl(Pointer lpPlayHandle, int dwVolume);

	/**
	 *  Get sound volume
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @param [OUT]  pdwVolume         Volume
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetSoundVolume(Pointer lpPlayHandle, IntByReference pdwVolume);

	/**
	 *  Mute
	 * @param [IN]  lpPlayHandle   / Preview handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_CloseSound(Pointer lpPlayHandle);

	/**
	 *   Get window bit rate
	 * @param [IN]  lpPlayHandle     \ Preview\playback handle
	 * @param [OUT] pdwBitRate        Pointer to obtained bit rate
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetBitRate(Pointer lpPlayHandle, IntByReference pdwBitRate);

	/**
	 *   Get window frame rate
	 * @param [IN]  lpPlayHandle     \ Preview\playback handle
	 * @param [OUT] pdwFrameRate      Pointer to obtained frame rate
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetFrameRate(Pointer lpPlayHandle, IntByReference pdwFrameRate);

	/**
	 *   Get window encoding format
	 * @param [IN]  lpPlayHandle         \ Preview\playback handle
	 * @param [OUT] pdwVideoEncFmt       ,NETDEV_VIDEO_CODE_TYPE_E  Pointer to obtained encoding format, see NETDEV_VIDEO_CODE_TYPE_E
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetVideoEncodeFmt(Pointer lpPlayHandle, IntByReference pdwVideoEncFmt);

	/**
	 *   Get video resolution
	 * @param [IN]  lpPlayHandle     \ Preview\playback handle
	 * @param [OUT] pdwWidth         - Pointer to obtained resolution – width
	 * @param [OUT] pdwHeight        - Pointer to obtained resolution – height
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetResolution(Pointer lpPlayHandle, IntByReference pdwWidth, IntByReference pdwHeight);

	/**
	 *   Get window packet loss rate
	 * @param [IN]  lpPlayHandle     \ Preview\playback handle
	 * @param [OUT] pulRecvPktNum     Pointer to number of received packets
	 * @param [OUT] pulLostPktNum     Pointer to number of lost packets
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetLostPacketRate(Pointer lpPlayHandle, IntByReference pulRecvPktNum, IntByReference pulLostPktNum);

	/**
	 *   Reset window packet loss rate
	 * @param [IN]  lpPlayHandle   \ Preview\playback handle
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_ResetLostPacketRate(Pointer lpPlayHandle);

	/**
	 *   Live view snapshot
	 * @param [IN]  lpPlayHandle     \ Preview\playback handle
	 * @param [IN]  pszFileName       File path to save images (including file name)
	 * @param [IN]  dwCaptureMode    ,#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note  File format suffix is not required in the file name
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_CapturePicture(Pointer lpPlayHandle, String pszFileName, int dwCaptureMode);

	/**
	 *   Modify image display ratio
	 * @param [IN]  lpPlayHandle   \ Preview\playback handle
	 * @param [IN]  enRenderScale   Image display ratio
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetRenderScale(Pointer lpPlayHandle, int enRenderScale);

	/**
	 * ,  Get the current image info
	 * @param [IN]  lpPlayHandle   \ Preview\playback handle
	 * @param [IN]  pstImageInfo    Image information list
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetVideoEffect(Pointer lpPlayHandle, NETDEV_VIDEO_EFFECT_S pstImageInfo);

	/**
	 * ,  Adjust the current image
	 * @param [IN]  lpPlayHandle   \ Preview\playback handle
	 * @param [IN]  pstImageInfo    Image information list
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetVideoEffect(Pointer lpPlayHandle, NETDEV_VIDEO_EFFECT_S pstImageInfo);

	/**
	 *   Set Digital zoom
	 * @param [IN] lpPlayHandle   \ Preview\playback handle
	 * @param [IN] hWnd             window handle
	 * @param [IN] pstRect         Rectangle Area
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note pstRect,, All images will be displayed with digital zoom disabled when pstRect is null
	 */
	public boolean NETDEV_SetDigitalZoom(Pointer lpPlayHandle, Pointer hWnd, NETDEV_RECT_S pstRect);

	/**
	 *  Dynamically create an I frame
	 * @param [IN] lpUserID         User login ID
	 * @param [IN] dwChannelID      Channel ID
	 * @param [IN] dwStreamType   NETDEV_LIVE_STREAM_INDEX_E  See enumeration NETDEV_LIVE_STREAM_INDEX_E
	 * @return NETDEV_E_SUCCEED   ,  NETDEV_E_SUCCEED means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_MakeKeyFrame(Pointer lpUserID, int dwChannelID, int dwStreamType);

	/**
	 * 
	 * @param [IN] lpPlayHandle              
	 * @param [IN] bEnableIVA                
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_SetIVAEnable(Pointer lpPlayHandle, int bEnableIVA);

	/**
	 * 
	 * @param [IN] dwShowParam                 NETDEV_IVA_SHOW_RULE
	 * @return TRUE,
	 * @note
	 * -    1.Windows.
	 * -    2.,,ulShowParam = NETDEV_IVA_SHOW_RULE|NETDEV_IVA_SHOW_RESULT_TOUTH_RULE
	 * -    3.,
	 */
	public boolean NETDEV_SetIVAShowParam(int dwShowParam);

	/**
	 * 
	 * @param [IN] lpPlayHandle              
	 * @param [OUT] pbFishEyeStream          
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_IsFishEyeStream(Pointer lpPlayHandle, IntByReference pbFishEyeStream);

	/**
	 * 
	 * @param [IN] lpPlayHandle                  
	 * @param [INOUT] pstCenterPoint             
	 * @param [INOUT] pudwRadius                 
	 * @param [INOUT] lpParm                     
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetFishEyeParam(Pointer lpPlayHandle, NETDEV_POINT_S pstCenterPoint, IntByReference pudwRadius, Pointer lpParm);

	/**
	 * 5ePTZ
	 * @param [IN] lpPlayHandle                  
	 * @param [IN] udwPtzMode                    5ePTZ  # NETDEV_PTZ_DISPLAY_MODE_E
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_SetPtzDisplayMode(Pointer lpPlayHandle, int udwPtzMode);

	/**
	 * 
	 * @param [IN] lpPlayHandle                  
	 * @param [IN] dwPtzMode                     PTZ,# NETDEV_FISHEYE_PTZ_MODE_E
	 * @param [IN] dwInstallMode                 ,# NETDEV_INSTALL_MODE_E
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_SetPtzAndFixMode(Pointer lpPlayHandle, int udwPtzMode, int dwInstallMode);

	/**
	 * 
	 * @param [IN] lpPlayHandle                   
	 * @param [OUT] pdwPtzMode                    PTZ,# NETDEV_FISHEYE_PTZ_MODE_E
	 * @param [OUT] pdwInstallMode                ,# NETDEV_INSTALL_MODE_E
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetPtzAndFixMode(Pointer lpPlayHandle, IntByReference pdwPtzMode, IntByReference pdwInstallMode);

	/**
	 * 
	 * @param [IN] lpPlayHandle          
	 * @param [IN] dwOperateMode         ,#NETDEV_MOUSE_MOVE_MODE_E
	 * @param [IN] udwFlag               ,
	 * @param [IN] wDelta                ()
	 * @param [IN] pstPoint              
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_SetMouseMoveMode(Pointer lpPlayHandle, int dwOperateMode, int udwFlag, short wDelta, NETDEV_POINT_S pstPoint);

	/**
	 *   Snapshot without preview
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  dwChannelID           Channel ID
	 * @param [IN]  dwStreamType;        ,#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E
	 * @param [IN]  pszFileName           File path to save images (including file name)
	 * @param [IN]  dwCaptureMode        ,#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
	 * @return  TRUE, TRUE means success, and any other value means failure.
	 * @note
	JPG.
	Only JPG format is supported.
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_CaptureNoPreview(Pointer lpUserID, int dwChannelID, int dwStreamType, String pszFileName, int dwCaptureMode);

	/**
	 * 
	 * @param [IN] lpUserID          ID
	 * @param [IN] dwAlarmType    NETDEV_SUBSCRIBE_ALARM_TYPE_E
	 * @return TRUE
	 * @note   NETDEV_SetAlarmCallBack_V30
	 * -
	 */
	public boolean NETDEV_Subscribe(Pointer lpUserID, int dwAlarmType);

	/**
	 * 
	 * @param [IN] lpUserID          ID
	 * @return TRUE
	 * @note
	 * -
	 */
	public boolean NETDEV_Unsubscribe(Pointer lpUserID);

	/**
	 * ()  PTZ control operation (preview not required)
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  dwChannelID           Channel ID
	 * @param [IN]  dwPTZCommand         ,#NETDEV_PTZ_E
	PTZ control commands, see #NETDEV_PTZ_E
	 * @param [IN]  dwSpeed              ,.[1,9] Speed of PTZ control, which is configured according to the speed control value of different decoders. Value ranges from 1 to 9.
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_PTZControl_Other(Pointer lpUserID, int dwChannelID, int dwPTZCommand, int dwSpeed);

	/**
	 * ()  PTZ control operation (preview required)
	 * @param [IN]  lpPlayHandle          Live preview handle
	 * @param [IN]  dwPTZCommand         ,#NETDEV_PTZ_E PTZ control commands, see #NETDEV_PTZ_E
	 * @param [IN]  dwSpeed              ,.[1,9] Speed of PTZ control, which is configured according to the speed control value of different decoders. Value ranges from 1 to 9.
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_PTZControl(Pointer lpPlayHandle, int dwPTZCommand, int dwSpeed);

	/**
	 * 
	 * @param [IN]  lpUserID             ID User login ID
	 * @param [IN]  dwChannelID           Channel number
	 * @param [IN]  pstPresetList        
	 * @return TRUE
     * @note Win32 VMS  
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_GetPTZPresetList(Pointer lpUserID, int  dwChannelID, NETDEV_PTZ_ALLPRESETS_S pstPresetList);

	/**
	 * ()  PTZ preset operation (preview not required)
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  dwChannelID           Channel ID
	 * @param [IN]  dwPTZPresetCmd       ,NETDEV_PTZ_PRESETCMD_E PTZ preset operation commands, see NETDEV_PTZ_PRESETCMD_E
	 * @param [IN]  pszPresetName         Preset name
	 * @param [IN]  dwPresetID           1,255. Preset number (starting from 1). Up to 255 presets are supported.
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_PTZPreset_Other(Pointer lpUserID, int dwChannelID, int dwPTZPresetCmd, String pszPresetName, int dwPresetID);

	/**
	 *   Get PTZ preset patrol route
	 * @param [IN]   lpUserID             User login ID
	 * @param [IN]   dwChannelID          Channel ID
	 * @param [OUT]  pstCruiseList         Patrol route list
	 * @return  TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_PTZGetCruise(Pointer lpUserID, int dwChannelID, NETDEV_CRUISE_LIST_S pstCruiseList);

	/**
	 * ()  PTZ preset patrol operation (preview not required)
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  dwChannelID           Channel ID
	 * @param [IN]  dwPTZCruiseCmd       ,#NETDEV_PTZ_CRUISECMD_E  PTZ patrol operation commands, see #NETDEV_PTZ_CRUISECMD_E
	 * @param [IN]  pstCruiseInfo         ,#LPNETDEV_CRUISE_INFO_S  PTZ patrol route information, see #LPNETDEV_CRUISE_INFO_S
	 * @return  TRUE, TRUE means success, and any other value means failure.
	 * @note
	 * - 1.,161 Patrol route. Up to 16 routes are supported (starting from 1).
	 * - 2.,321 Patrol point. Up to 32 points are supported (starting from 1).
	 * - 3.(255).(255).(40)  Preset (max 255), time (max 255) and speed (max 40).
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_PTZCruise_Other(Pointer lpUserID, int dwChannelID,int dwPTZCruiseCmd, NETDEV_CRUISE_INFO_S pstCruiseInfo);

	/**
	 *   Get PTZ patrol route
	 * @param [IN]   lpUserID             User login ID
	 * @param [IN]   dwChannelID          Channel ID
	 * @param [OUT]  pstTrackCruiseInfo        ,#LPNETDEV_PTZ_TRACK_INFO_S  Patrol route list, see #LPNETDEV_PTZ_TRACK_INFO_S
	 * @return  TRUE, TRUE means success, and any other value means failure.
	 * @note win64 IPC
	 */
	public boolean NETDEV_PTZGetTrackCruise(Pointer lpUserID, int dwChannelID, NETDEV_PTZ_TRACK_INFO_S pstTrackCruiseInfo);

	/**
	 * ()   PTZ route patrol operation (preview not required)
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  dwChannelID           Channel ID
	 * @param [IN]  dwPTZCruiseCmd       ,#NETDEV_PTZ_TRACKCMD_E  PTZ route patrol operation commands, see #NETDEV_PTZ_TRACKCMD_E
	 * @param [INOUT]  pszTrackCruiseName         ,#NETDEV_LEN_64  Route patrol name, suggested length #NETDEV_LEN_64
	 * @return  TRUE, TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_PTZTrackCruise(Pointer lpUserID, int dwChannelID, int dwPTZTrackCruiseCmd, String pszTrackCruiseName);

	/**
	 *  Query video distribution information by month
	 * @param [IN]   lpUserID             User login ID
	 * @param [IN]   dwChannelID           Channel ID
	 * @param [IN]   pstMonthInfo          Month information
	 * @param [OUT]   pstMonthStatus       Video status in the month
	 * @return TRUE, TRUE means success, any other value indicates failure.
	 * @note
	 */
	public boolean NETDEV_QuickSearch(Pointer lpUserID, int dwChannelID, NETDEV_MONTH_INFO_S pstMonthInfo, NETDEV_MONTH_STATUS_S pstMonthStatus);

	/**
	 *  Set pictuer fluency
	 * @param [IN] lpPlayHandle         \ Preview\playback handle
	 * @param [IN] dwFluency           ,#NETDEV_PICTURE_FLUENCY_E
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetPictureFluency(Pointer lpPlayHandle, int dwFluency);

	/**
	 * .  Query recording files according to file type and time
	 * @param [IN]  lpUserID      User login ID
	 * @param [IN]  pstFindCond     Search condition
	 * @return ,0,NETDEV_FindClose.
	Recording search service number. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_FindClose.
	 * @note ,0,：
	 *         .NETDEV_FindNextFilelpFindHandle,NETDEV_FindNextFile,.
	 *         .,NETDEV_FindCloselpFindHandle,NETDEV_FindClose,,.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public Pointer NETDEV_FindFile(Pointer lpUserID, NETDEV_FILECOND_S pstFindCond);

	/**
	 *   Obtain the information of found files one by one.
	 * @param [IN]  lpFindHandle      File search handle
	 * @param [OUT] pstFindData        Pointer to save file information
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_FindNextFile(Pointer lpFindHandle, NETDEV_FINDDATA_S pstFindData);

	/**
	 * ,  Close file search and release resources
	 * @param [IN] lpFindHandle   File search handle
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_FindClose(Pointer lpFindHandle);

	/**
	 *   Play back recording files by name
	 * @param [IN] lpUserID           User login ID
	 * @param [IN] pstPlayBackInfo   , LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public Pointer NETDEV_PlayBackByName(Pointer lpUserID, NETDEV_PLAYBACKINFO_S pstPlayBackInfo);

	/**
	 *   Play back recording by time.
	 * @param [IN] lpUserID           User login ID
	 * @param [IN] pstPlayBackCond      LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note Win32 VMS
	 * @note NetDemo btnRecordPlay	pstPlayBackInfo.dwLinkMode = NETDEV_TRANS_PROTOCAL_E.NETDEV_TRANS_PROTOCAL_TCP;
	 * @note win64 NVR
	 */
	public Pointer NETDEV_PlayBackByTime(Pointer lpUserID, NETDEV_PLAYBACKCOND_S pstPlayBackInfo);

	/**
	 * URL
	 * @param [IN]  lpUserID             
	 * @param [IN]  pszUrl               URL
	 * @param [IN]  pstPlayBackCond      , LPNETDEV_PLAYBACKCOND_S
	 * @return 0,NETDEV_StopPlayBack
	 * @note
	 */
	public Pointer NETDEV_PlayBackByUrl(Pointer lpUserID, String pszUrl, NETDEV_PLAYBACKCOND_S pstPlayBackCond);

	/**
	 *   Control recording playback status.
	 * @param [IN]  lpPlayHandle      Playback or download handle
	 * @param [IN]  dwControlCode     ：NETDEV_VOD_PLAY_CTRL_E Command for controlling recording playback status, see NETDEV_VOD_PLAY_CTRL_E
	 * @param [INOUT]  lpBuffer     /, ：NETDEV_VOD_PLAY_STATUS_E,：INT64 Pointer to input/output parameters. For playing speed, see NETDEV_VOD_PLAY_STATUS_E. The type of playing time: INT64.
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note ..,lpBufferNULL When playing, pause or resume videos, set IpBuffer as NULL.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_PlayBackControl(Pointer lpPlayHandle, int dwControlCode, LongByReference lpBuffer);

	/**
	 *   Stop playback service
	 * @param [IN] lpPlayHandle   Playback handle
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_StopPlayBack(Pointer lpPlayHandle);

	/**
	 *  Download recordings by file name
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  pstPlayBackInfo      , LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
	 * @param [IN]  *pszSaveFileName     PC, Downloaded file save path on PC, must be an absolute path (including file name)
	 * @param [IN]  dwFormat              Recording file saving format
	 * @return , 0,NETDEV_StopGetFile. Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
	 * @note
	 */
	public Pointer NETDEV_GetFileByName(Pointer lpUserID, NETDEV_PLAYBACKINFO_S pstPlayBackInfo, String pszSaveFileName, int dwFormat);

	/**
	 *  Download recordings by time
	 * @param [IN]  lpUserID                 User login ID
	 * @param [IN]  pstPlayBackCond   , LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
	 * @param [IN]  *pszSaveFileName        PC, Downloaded file save path on PC, must be an absolute path (including file name)
	 * @param [IN]  dwFormat                ,NETDEV_MEDIA_FILE_FORMAT_E, Recording file saving format
	 * @return , 0,NETDEV_StopGetFile. Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public Pointer NETDEV_GetFileByTime(Pointer lpUserID, NETDEV_PLAYBACKCOND_S pstPlayBackCond, String pszSaveFileName, int dwFormat);

	/**
	 *  Stop downloading recording files
	 * @param [IN]  lpPlayHandle   Playback handle
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR
	 */
	public boolean NETDEV_StopGetFile(Pointer lpPlayHandle);

	/**
	 * 
	 * @param [IN] pszFilename           
	 * @return 0,NETDEV_PlayMediaFile.NETDEV_StopPlayMediaFile
	 * @note
	 */
	public Pointer NETDEV_OpenMediaFile(String pszFilename);

	/**
	 * 
	 * @param [IN] lpPlayHandle       ,NETDEV_OpenMediaFile
	 * @param [IN] dwPlayWnd          
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_StartPlayMediaFile(Pointer lpPlayHandle, Pointer lpPlayWnd);

	/**
	 * 
	 * @param [IN] lpPlayHandle  
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_StopPlayMediaFile(Pointer lpPlayHandle);

	/**
	 * 
	 * @param [IN] lpPlayHandle  
	 * @param [IN] pdwTotalTime  s
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetMediaFileTime(Pointer lpPlayHandle, IntByReference pdwTotalTime);

	/**
	 * 
	 * @param [IN] lpUserID          ID
	 * @param [IN] pstFindCond       
	 * @return ,0NETDEV_FindNextOrgInfoNETDEV_FindCloseOrgInfo。
	 * @note
	 */
	public Pointer NETDEV_FindOrgInfoList(Pointer lpUserID, NETDEV_ORG_FIND_COND_S pstFindCond);

	/**
	 * 
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstOrgInfo                   
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextOrgInfo(Pointer lpFindHandle, NETDEV_ORG_INFO_S pstOrgInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseOrgInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID              ID
	 * @param [IN] pstOrgInfo            
	 * @param [OUT] dwOrgID             ID
	 * @return TRUE            TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_AddOrgInfo(Pointer lpUserID, NETDEV_ORG_INFO_S pstOrgInfo, IntByReference dwOrgID);
	/**
	 * 
	 * @param [IN] lpUserID              ID
	 * @param [IN] dwOrgID              ID
	 * @param [IN] pstOrgInfo            
	 * @return TRUE            TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_ModifyOrgInfo(Pointer lpUserID, NETDEV_ORG_INFO_S pstOrgInfo);

	/**
	 * 
	 * @param [IN] lpUserID             ID
	 * @param [IN] pstOrgDelInfo       
	 * @param [OUT] pstOrgDelResultInfo  
	 * @return TRUE            TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_BatchDeleteOrgInfo(Pointer lpUserID, NETDEV_DEL_ORG_INFO_S pstOrgDelInfo, NETDEV_ORG_BATCH_DEL_INFO_S pstOrgDelResultInfo);

	/**
	 * ID
	 * @param [IN] lpUserID          ID
	 * @param [IN] dwOrgID           ID
	 * @param [IN] dwChnType         #NETDEV_CHN_TYPE_E
	 * @return ,0NETDEV_FindNextOrgChnNETDEV_FindCloseOrgChn。
	 * @note
	 */
	public Pointer NETDEV_FindOrgChnList(Pointer lpUserID, int dwOrgID,int dwChnType);

	/**
	 *   
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstOrgChnInfo                  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextOrgChn(Pointer lpFindHandle, NETDEV_ORG_CHN_INFO_S pstOrgChnInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseOrgChn(Pointer lpFindHandle);

	/**
	 * ID 
	 * @param [IN] lpUserID          ID
	 * @param [IN] dwDevID           ID
	 * @param [IN] dwChnType         # NETDEV_CHN_TYPE_E
	 * @return ,0NETDEV_FindNextDevChnNETDEV_FindCloseDevChn。
	 * @note     1ID0.
	 */
	public Pointer NETDEV_FindDevChnList(Pointer lpUserID, int dwDevID,int dwChnType);

	/**
	 *   
	 * @param [IN]  lpFindHandle         
	 * @param [OUT] lpOutBuffer          ,NETDEV_CHN_TYPE_ENCODENETDEV_DEV_CHN_ENCODE_INFO_S
	 * @param [IN] dwOutBufferSize       ()0
	 * @param [OUT] pdwBytesReturned     NUL
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextDevChn(Pointer lpFindHandle, Pointer lpOutBuffer, int  dwOutBufferSize, IntByReference pdwBytesReturned);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_FindCloseDevChn(Pointer lpFindHandle);

	/**
	 *    
	 * @param [IN] lpUserID              ID
	 * @param [IN] dwDevType              #NETDEV_DEVICE_MAIN_TYPE_E
	 * @return ,0NETDEV_FindNextOrgInfoNETDEV_FindCloseOrgInfo。
	 */
	public Pointer NETDEV_FindDevList(Pointer lpUserID, int dwDevType);

	/**
	 *  
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstDevBasicInfo               
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextDevInfo(Pointer lpFindHandle,NETDEV_DEV_BASIC_INFO_S pstDevBasicInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_FindCloseDevInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]   lpUserID                    ID User login ID
	 * @param [OUT]   pstUserDetailList              #LPNETDEV_USER_DETAIL_LIST_S
	 * @return TRUE,
	 * @note win64 NVR
	 */
	public boolean NETDEV_GetUserDetailList(Pointer lpUserID, NETDEV_USER_DETAIL_LIST_S pstUserDetailList);

	/**
	 * 
	 * @param [IN]   lpUserID                    ID User login ID
	 * @param [INOUT]   pstUserDetailInfo              #NETDEV_USER_DETAIL_INFO_S
	 * @return TRUE,
	 * @note   pstUserDetailInfoszUsername
	 */
	public boolean NETDEV_GetUserDetailInfo(Pointer lpUserID,NETDEV_USER_DETAIL_INFO_S pstUserDetailInfo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   pstUserDetailInfo             #NETDEV_USER_DETAIL_INFO_S
	 * @return TRUE,
	 * @note win64 NVR
	 */
	public boolean NETDEV_CreateUser(Pointer lpUserID, NETDEV_USER_DETAIL_INFO_S pstUserDetailInfo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   pstUserInfo             #NETDEV_USER_INFO_S
	 * @return TRUE,
	 *1
	 *2
	 * @note win64 NVR
	 */
	public boolean NETDEV_ModifyUser(Pointer lpUserID, NETDEV_USER_MODIFY_DETAIL_INFO_S pstUserInfo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   pszUserName             
	 * @return TRUE,
	 * @note win64 NVR
	 * @note 
	 */
	public boolean NETDEV_DeleteUser(Pointer lpUserID, String pszUserName);

	/**
	 * 
	 * Restart device
	 * @param [IN]  lpUserID      User login ID
	 * @return TRUE, TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 *
	 * */
	public boolean NETDEV_Reboot(Pointer lpUserID);

	/**
	 *   Restore to factory default settings
	 * @param [IN]  lpUserID      User login ID
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note ,. Restore all parameters to factory settings, except network settings and user settings.
	 */
	public boolean NETDEV_RestoreConfig(Pointer lpUserID);

	/**
	 *  Start manual record
	 * @param [IN]   lpUserID                 User login ID
	 * @param [IN]   pstManualRecordCfg       Manual record config
	 * @return TRUE, TRUE means success, any other value indicates failure.

     * @note Win32 VMS
	*/
	public boolean NETDEV_StartManualRecord(Pointer lpUserID, NETDEV_MANUAL_RECORD_CFG_S stManualRecordCfg);

	/**
	 *  Stop manual record
	 * @param [IN]   lpUserID                 User login ID
	 * @param [IN]   pstManualRecordCfg       Manual record config
	 * @return TRUE, TRUE means success, any other value indicates failure.
     * @note Win32 VMS
	 *
	 * */
	public boolean NETDEV_StopManualRecord(Pointer lpUserID, NETDEV_MANUAL_RECORD_CFG_S stManualRecordCfg);

	/**
	 *  Set device name
	 * @param [IN] lpUserID          User login ID
	 * @param [IN] pszDeviceName      Device name
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_ModifyDeviceName(Pointer lpUserID, String pszDeviceName);

	/**
	 *   Get configuration information of device
	 * @param [IN]   lpUserID                 User login ID
	 * @param [IN]   dwChannelID              Channel ID
	 * @param [IN]   dwCommand               ,# NETDEV_CONFIG_COMMAND_E  Device configuration commands, see #NETDEV_CONFIG_COMMAND_E
	 * @param [INOUT]  lpOutBuffer            Pointer to buffer that receives data
	 * @param [OUT]  dwOutBufferSize         (),0 Length (in byte) of buffer that receives data, cannot be 0.
	 * @param [OUT]  pdwBytesReturned        ,NULL  Pointer to length of received data, cannot be NULL.
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 * - 1.ID.  Route ID cannot be modified.
	 * - 2.,.  New routes are added one after another.
	 * - 3...,pstCruiseInfoID.  When deleting, starting or stoping a patrol route, enter route ID in pstCruiseInfo.
	 */
	public boolean NETDEV_GetDevConfig(Pointer  lpUserID,int dwChannelID,int dwCommand,Pointer lpOutBuffer,int dwOutBufferSize, IntByReference pdwBytesReturned);


	/**
	 *   Modify device configuration information
	 * @param [IN]   lpUserID             User login ID
	 * @param [IN]   dwChannelID          Channel ID
	 * @param [IN]   dwCommand           ,#NETDEV_CONFIG_COMMAND_E  Device configuration commands, see #NETDEV_CONFIG_COMMAND_E
	 * @param [IN]   lpInBuffer           Pointer to buffer of input data
	 * @param [IN]   dwInBufferSize      () Length of input data buffer (byte)
	 * @return TRUE, TRUE means success, and any other value means failure
	 */
	public boolean NETDEV_SetDevConfig(Pointer  lpUserID,int dwChannelID,int dwCommand,Pointer lpInBuffer,int dwInBufferSize);

	/**
	 *  Register callback function that used for count passenger flow
	 * @param [IN] lpUserID                   User login ID
	 * @param [IN] cbPassengerFlowStatisticCallBack      NETDEV_PassengerFlowStatisticCallBack_PF
	 * @param [IN] lpUserData                  User data
	 */
	public boolean NETDEV_SetPassengerFlowStatisticCallBack(Pointer lpUserID, NETDEV_PassengerFlowStatisticCallBack_PF cbPassengerFlowStatisticCallBack, Pointer lpUserData);

	/**
	 * 
	 * @param [IN] lpUserID                    User login ID
	 * @param [IN] cbCarPlateCallBack          NETDEV_CarPlateCallBack_PF
	 * @param [IN] lpUserData                  User data
	 */
	public boolean NETDEV_SetCarPlateCallBack(Pointer lpUserID, NETDEV_CarPlateCallBack_PF cbCarPlateCallBack, Pointer lpUserData);

	/**
	 * 
	 * @param [IN] lpUserID                   User login ID
	 * @param [IN] cbFaceSnapshotCallBack    NETDEV_FaceSnapshotCallBack_PF
	 * @param [IN] lpUserData                  User data
	 */
	public boolean NETDEV_SetFaceSnapshotCallBack(Pointer lpUserID, NETDEV_FaceSnapshotCallBack_PF cbFaceSnapshotCallBack, Pointer lpUserData);

	/**
	 * 
	 * Register callback function and receive alarm information, etc.
	 * @param [IN] lpUserID              ID User login ID
	 * @param [IN] cbAlarmMessCallBack   NETDEV_AlarmMessCallBack_PF_V30
	 * @param [IN] lpUserData             User data
	 * @return TRUE TRUE means success, and any other value means failure.
     * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_SetAlarmCallBack_V30(Pointer lpUserID, NETDEV_AlarmMessCallBack_PF_V30 cbAlarmMessCallBack, Pointer lpUserData);

	/**
	 * sdk.  Callback function to register SDK, receive exception and reconnection messages, etc.
	 * @param [IN] cbExceptionCallBack       ,NETDEV_ExceptionCallBack_PF
	 * @param [IN] lpUserData                 User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetExceptionCallBack(NETDEV_ExceptionCallBack_PF cbExceptionCallBack, Pointer lpUserData);

	/**
	 * ID, Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)
	 * @param  lpUserID [IN]                   User login ID
	 * @param  cbAlarmMessCallBack  [IN]       Callback function
	 * @param  lpUserData   [IN]               User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	boolean NETDEV_SetStructAlarmCallBack(Pointer lpUserID,NETDEV_StructAlarmMessCallBack_PF cbAlarmMessCallBack,Pointer lpUserData);

	/**
	 *   Get error codes
	 * @return  Error codes
	 * @note Win32 VMS
	 * @note win64 NVR IPC
	 */
	public int NETDEV_GetLastError();

	/**
	 * 
	 * @param [IN]  lpUserID      User login ID
	 * @param [IN]   dwTimeOut              
	 * @param [OUT]  pstCapacityList   
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetPersonLibCapacity(Pointer lpUserID, int dwTimeOut, NETDEV_PERSON_LIB_CAP_LIST_S pstCapacityList);

	/**
	 *                                 Create Person libraries information
	 * @param [IN]  lpUserID                          User login ID
	 * @param [IN]  pstLibraryList                    Person library information
	 * @param [OUT]  *pudwID                         ID create library generated libry ID
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_CreatePersonLibInfo(Pointer lpUserID, NETDEV_LIB_INFO_S pstPersonLibInfo, IntByReference pudwID);

	/**
	 *  Get all Person libraries information
	 * @param [IN]  lpUserID          User login ID
	 * @return ,0NETDEV_FindNextPersonLibInfoNETDEV_FindClosePersonLibList。
	 * @note
	 */
	public Pointer NETDEV_FindPersonLibList(Pointer lpUserID);

	/**
	 *   
	 * @param [IN]  lpFindHandle           
	 * @param [OUT] pstPersonLibInfo         
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextPersonLibInfo(Pointer lpFindHandle, NETDEV_LIB_INFO_S pstPersonLibInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindClosePersonLibList(Pointer lpFindHandle);


	/**
	 *   Modify Person libraries information
	 * @param [IN]  lpUserID          User login ID
	 * @param [IN]  pstLibraryList    Person library information
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_ModifyPersonLibInfo(Pointer lpUserID, NETDEV_PERSON_LIB_LIST_S pstPersonLibList);

	/**
	 *     Delete designated Person libraries information
	 * @param [IN]  lpUserID      User login ID
	 * @param [IN]  udwPersonLibID   ID Person library ID
	 * @param [IN]  pstFlagInfo   
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_DeletePersonLibInfo(Pointer lpUserID, int udwPersonLibID, NETDEV_DELETE_DB_FLAG_INFO_S pstFlagInfo);

	/**
	 * 
	 * @param [IN] lpUserID 
	 * @param [IN] udwPersonLibID ID
	 * @param [IN] pstQueryInfo 
	 * @param [OUT] pstQueryResultInfo 
	 * @return ,0NETDEV_FindNextPersonInfoNETDEV_FindClosePersonInfoList
	 * @note
	 */
	public Pointer NETDEV_FindPersonInfoList(Pointer lpUserID, int udwPersonLibID, NETDEV_PERSON_QUERY_INFO_S pstQueryInfo,  NETDEV_BATCH_OPERATE_BASIC_S pstQueryResultInfo);

	/**
	 *   
	 * @param [IN]  lpFindHandle            
	 * @param [OUT] pstPersonInfo           
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextPersonInfo(Pointer lpFindHandle, NETDEV_PERSON_INFO_S pstPersonInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindClosePersonInfoList(Pointer lpFindHandle);


	/**
	 *  Add designated Person information
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  udwPersonLibID       ID Person library ID
	 * @param [IN]  pstPersonInfoList     Person information list
	 * @param [OUT]  pstPersonResultList  Person information result list
	 * @return TRUE,
	 * @note pstPersonResultList->pstPersonList need malloc by caller
	keep pstPersonResultList->udwNum == pstPersonInfoList->udwNum
	 */
	public boolean NETDEV_AddPersonInfo(Pointer lpUserID, int udwPersonLibID, NETDEV_PERSON_INFO_LIST_S pstPersonInfoList, NETDEV_PERSON_RESULT_LIST_S pstPersonResultList);

	/**
	 *  Modify designated Person information
	 * @param [IN]  lpUserID              User login ID
	 * @param [IN]  udwPersonLibID       ID Person library ID
	 * @param [IN]  pstPersonInfoList     Person information list
	 * @param [OUT]  pstPersonResultList  Person information result list
	 * @return TRUE,
	 * @note pstPersonResultList->pstPersonList need malloc by caller
	keep pstPersonResultList->udwNum == pstPersonInfoList->udwNum
	 */
	public boolean NETDEV_ModifyPersonInfo(Pointer lpUserID, int udwPersonLibID, NETDEV_PERSON_INFO_LIST_S pstPersonInfoList, NETDEV_PERSON_RESULT_LIST_S pstPersonResultList);

	/**
	 *  Delete designated Person information
	 * @param [IN]  lpUserID          User login ID
	 * @param [IN]  udwPersonLibID   ID Person library ID
	 * @param [IN]  udwPersonID      ID Person ID
	 * @param [IN]  udwLastChange     Last modify time
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_DeletePersonInfo(Pointer lpUserID, int udwPersonLibID, int udwPersonID, int udwLastChange);

	/**
	 * 
	 * @param [IN] lpUserID             ID
	 * @param [IN] udwPersonLibID       ID
	 * @param [IN] pstIDList            
	 * @param [OUT] pstBatchList        
	 * @return ,0
	 * @note VMS
	 */
	public boolean NETDEV_DeletePersonInfoList(Pointer lpUserID, int udwPersonLibID, NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstIDList, NETDEV_BATCH_OPERATOR_LIST_S pstResutList);

	/**
	 * 
	 * @param [IN]  lpUserID                   ID
	 * @param [IN]  pstFindCond                
	 * @param [OUT] pstResultInfo              
	 * @return ,0NETDEV_FindFaceNextRecordDetailNETDEV_FindFaceCloseRecordDetail。
	 * @note     NETDEV_FindFaceNextRecordDetail
	 */
	public Pointer NETDEV_FindFaceRecordDetailList(Pointer lpUserID, NETDEV_ALARM_LOG_COND_LIST_S pstFindCond, NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  pstResultInfo);

	/**
	 *  
	 * @param [IN]  lpFindHandle                    
	 * @param [OUT] pstRecordInfo                     
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextFaceRecordDetail(Pointer lpFindHandle, NETDEV_FACE_RECORD_SNAPSHOT_INFO_S pstRecordInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseFaceRecordDetail(Pointer lpFindHandle);



	/**
	 * 
	 * @param [IN]  lpUserID              ID
	 * @param [IN]  udwChannelID          IDNVR
	 * @param [IN]  pstQueryInfo          NVR
	 * @return ,0NETDEV_FindNextPersonMonitorInfoNETDEV_FindClosePersonMonitorList
	 * @note
	 */
	public Pointer NETDEV_FindPersonMonitorList(Pointer lpUserID, int udwChannelID, NETDEV_MONITOR_QUERY_INFO_S pstQueryInfo);

	/**
	 *   
	 * @param [IN]  lpFindHandle            
	 * @param [OUT] pstMonitorInfo            
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 *.      NETDEV_E_NEED_MORE_MEMORY：pstMonitorInfo->udwLinkStrategyNum
	pstMonitorInfo->stMonitorRuleInfo.udwChannelNum
	 */
	public boolean NETDEV_FindNextPersonMonitorInfo(Pointer lpFindHandle, NETDEV_MONITION_INFO_S pstMonitorInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindClosePersonMonitorList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]    lpUserID                      ID
	 * @param [INOUT]    pstMonitorInfo                    
	 * @param [INOUT] pstMonitorResultInfo          
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  pstMonitorResultInfo->udwChannelNumpstMonitorInfo stMonitorRuleInfo.udwChannelNum
	pstMonitorResultInfo->udwChannelNum must be Greater thanpstMonitorInfo stMonitorRuleInfo.udwChannelNum
	 */
	public boolean NETDEV_AddPersonMonitorInfo(Pointer lpUserID, NETDEV_MONITION_INFO_S pstMonitorInfo, NETDEV_MONITOR_RESULT_INFO_S pstMonitorResultInfo);

	/**
	 * 
	 * @param [IN]  lpUserID                      ID
	 * @param [IN]  udwID                          ID
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_DeletePersonMonitorInfo(Pointer lpUserID, int udwID);

	/**
	 * 
	 * @param [IN]  lpUserID                      ID
	 * @param [INOUT] pstResultList                 ID
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_BatchDeletePersonMonitorInfo(Pointer lpUserID,  NETDEV_BATCH_OPERATOR_LIST_S pstResultList);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [INOUT] pstMonitorInfo              ID
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note pudwMonitorChlIDList(NETDEV_E_NEED_MORE_MEMORY)udwChannelNum
	 */
	public boolean NETDEV_GetPersonMonitorRuleInfo(Pointer lpUserID, NETDEV_MONITION_INFO_S pstMonitorInfo);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN] pstMonitorInfo                 
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetPersonMonitorRuleInfo(Pointer lpUserID, NETDEV_MONITION_INFO_S pstMonitorInfo);


	/**
	 * ID, Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)
	 * @param [IN] lpUserID                    User login ID
	 * @param [IN] cbAlarmMessCallBack         Callback function
	 * @param [IN] lpUserData                  User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean  NETDEV_SetPersonAlarmCallBack(Pointer lpUserID, NETDEV_PersonAlarmMessCallBack_PF cbAlarmMessCallBack, Pointer lpUserData);

	/**
	 * 
	 * @param [IN] lpUserID              ID
	 * @param [IN] pstSubscribeInfo      
	 * @param [INOUT] pstSmartInfo       ID
	 * @return TRUE
	 * @note   NETDEV_SetAlarmCallBack_V30
	 * -
	 */
	public boolean NETDEV_SubscribeSmart(Pointer lpUserID,  NETDEV_SUBSCRIBE_SMART_INFO_S pstSubscribeInfo, NETDEV_SMART_INFO_S pstSmartInfo);

	/**
	 * 
	 * @param [IN] lpUserID            ID
	 * @param [IN] pstSmartInfo         
	 * @return TRUE
	 * @note
	 * -
	 */
	public boolean NETDEV_UnsubscribeSmart(Pointer lpUserID, NETDEV_SMART_INFO_S pstSmartInfo);

	/**
	 * LAPI
	 * @param [IN] lpUserID                                      
	 * @param [IN] pstSubInfo           
	 * @param [OUT] pstSubSuccInfo  
	 * @return TRUE,
	 * @note Type
	 */
	public boolean NETDEV_SubscibeLapiAlarm(Pointer lpUserID, NETDEV_LAPI_SUB_INFO_S pstSubInfo, NETDEV_SUBSCRIBE_SUCC_INFO_S pstSubSuccInfo);

	/**
	 * LAPI
	 * @param [IN] lpUserID               
	 * @param [IN] udwID           ID
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_UnSubLapiAlarm(Pointer lpUserID, int udwID);

	/**
	 * 
	 * @param [IN]   lpUserID                     ID User login ID
	 * @param [IN]   pszURL                       URL picture url
	 * @param [IN]   udwSize                      
	 * @param [OUT]   pszdata                     () picture data
	 * @return TRUE
	 * @note
	 */
	public boolean NETDEV_GetSystemPicture(Pointer lpUserID, Pointer pszURL, int udwSize, Pointer pszdata);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN] udwRecordID                  ID
	 * @param [IN] udwFaceImageType              
	 * @param [OUT] pstFileInfo                 
	 * @return ,0NETDEV_FindNextFaceRecordDetailNETDEV_FindCloseFaceRecordDetail。
	 * @note     NETDEV_FindNextFaceRecordDetail
	 */
	public boolean NETDEV_GetFaceRecordImageInfo(Pointer lpUserID, int udwRecordID, int udwFaceImageType, NETDEV_FILE_INFO_S pstFileInfo);

	/**
	 * 
	 * @param [IN] lpUserID          ID
	 * @return ,0NETDEV_FindNextVehicleLibInfoNETDEV_FindCloseVehicleLibList。
	 * @note
	 */
	public Pointer NETDEV_FindVehicleLibList(Pointer lpUserID);

	/**
	 *   
	 * @param [IN]  lpFindHandle           
	 * @param [OUT] pstVehicleLibInfo        
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextVehicleLibInfo(Pointer lpFindHandle, NETDEV_LIB_INFO_S pstVehicleLibInfo);

	/**
	 *  
	 close finding vehicleDB Release resources
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseVehicleLibList(Pointer lpFindHandle);

	/**
	 * 
	 * add vehicleDB information
	 * @param [IN] lpUserID                   ID User login ID
	 * @param [INOUT] pstVehicleLibInfo       VehicleDB info
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_AddVehicleLibInfo(Pointer lpUserID, NETDEV_LIB_INFO_S pstVehicleLibInfo );



	/**
	 * 
	 * Modify the specified vehicleDB information
	 * @param [IN] lpUserID                  ID User login ID
	 * @param [IN] pstVehicleLibList          Vehicle Lib List
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_ModifyVehicleLibInfo(Pointer lpUserID, NETDEV_PERSON_LIB_LIST_S pstVehicleLibList);

	/**
	 * 
	 * delete the specified vehicleDB information
	 * @param [IN] lpUserID                   ID User login ID
	 * @param [IN] udwVehicleLibID            ID Vehicle DB ID
	 * @param [IN] pstDelLibFlag              
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_DeleteVehicleLibInfo(Pointer lpUserID, int udwVehicleLibID, NETDEV_DELETE_DB_FLAG_INFO_S pstDelLibFlag);

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] udwLibID                ID
	 * @param [IN] pstVehicleMemberList    
	 * @param [OUT] pstResultList          
	 * @return ,0
	 * @note
	 */
	public boolean NETDEV_AddVehicleMemberList(Pointer lpUserID, int udwLibID, NETDEV_VEHICLE_INFO_LIST_S pstVehicleMemberList,
											   NETDEV_BATCH_OPERATOR_LIST_S pstResultList);

	/**
	 * 
	 * get vehicleDB information
	 * @param [IN] lpUserID                        ID User login ID
	 * @param [IN] udwVehicleID                    IDVehicle ID
	 * @param [OUT] pstVehicleDetailInfo            Vehicle Detail info
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetVehicleMemberInfo(Pointer lpUserID, int udwVehicleID, NETDEV_VEHICLE_DETAIL_INFO_S pstVehicleDetailInfo);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] udwLibID                  ID
	 * @param [IN] udwVehicleID              ID
	 * @return ,0
	 * @note
	 */
	public boolean NETDEV_DelVehicleInfo(Pointer lpUserID, int udwLibID, int udwVehicleID);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] udwLib                    
	 * @param [IN] pstVehicleMemberList      
	 * @param [OUT] pstBatchList             
	 * @return ,0
	 * @note
	 */
	public boolean NETDEV_DelVehicleMemberList(Pointer lpUserID, int udwLib,
											   NETDEV_VEHICLE_INFO_LIST_S pstVehicleMemberList,
											   NETDEV_BATCH_OPERATOR_LIST_S pstBatchList);

	/**
	 * 
	 * modify vehicleDB information
	 * @param [IN] lpUserID                        ID User login ID
	 * @param [IN] udwVehicleLibID                 IDVehicle ID
	 * @param [IN] pstVehicleDetailInfo             Vehicle Detail info
	 * @param [OUT] pstResultList                   Batch operate result info
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_ModifyVehicleMemberInfo(Pointer lpUserID, int udwVehicleLibID,
												  NETDEV_VEHICLE_INFO_LIST_S pstVehicleMemberList,
												  NETDEV_BATCH_OPERATOR_LIST_S pstResultList);

	/**
	 * 
	 * @param [IN]  lpUserID         ID
	 * @param [IN]  udwVehicleLibID  
	 * @param [IN]  pstFindCond      
	 * @param [OUT] pstFaceDBList    
	 * @return ,0NETDEV_FindNextVehicleMemberDetailNETDEV_FindCloseVehicleMemberDetail。
	 * @note    1NETDEV_FindNextVehicleMemberDetailpstFaceDBList
	 *@           2NETDEV_FindNextVehicleMemberDetail
	 */
	public Pointer NETDEV_FindVehicleMemberDetailList(Pointer lpUserID,  int udwVehicleLibID,
													  NETDEV_PERSON_QUERY_INFO_S pstFindCond,
													  NETDEV_BATCH_OPERATE_BASIC_S pstDBMemberList);

	/**
	 *   
	 * @param [IN]  lpFindHandle           
	 * @param [OUT] pstFaceMemberInfo        
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextVehicleMemberDetail(Pointer lpFindHandle, NETDEV_VEHICLE_DETAIL_INFO_S pstVehicleMemberInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseVehicleMemberDetail(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN] pstFindCond                  
	 * @param [OUT] pstResultInfo               
	 * @return ,0NETDEV_FindVehicleNextRecordInfoNETDEV_FindVehicleCloseRecordInfo。
	 * @note
	 */
	public Pointer NETDEV_FindVehicleRecordInfoList(Pointer lpUserID, NETDEV_ALARM_LOG_COND_LIST_S pstFindCond,
													NETDEV_SMART_ALARM_LOG_RESULT_INFO_S  pstResultInfo);

	/**
	 * 
	 * @param [IN]  lpFindHandle                    
	 * @param [OUT] pstRecordInfo                   
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	NETDEV_FindVehicleCloseRecordInfo
	 */
	public boolean NETDEV_FindNextVehicleRecordInfo(Pointer lpFindHandle, NETDEV_VEHICLE_RECORD_INFO_S pstRecordInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseVehicleRecordList(Pointer lpFindHandle);

    /**
	* 
	* @param [IN]  lpUserID                     ID
	* @param [IN]  pstFindCond                  
	* @param [OUT] pstResultInfo                
	* @return                                   ,0NETDEV_FindNextNonVehRecordInfoNETDEV_FindCloseNonVehRecordList。
	* @note
	*/
	public Pointer NETDEV_FindNonVehRecordList(Pointer lpUserID, NETDEV_ALARM_LOG_COND_LIST_S pstFindCond, NETDEV_BATCH_OPERATE_BASIC_S  pstResultInfo);

	/**
	* 
	* @param [IN]  lpFindHandle                    
	* @param [OUT] pstRecordInfo                   
	* @return                                      TRUE TRUE means success, and any other value means failure.
	* @note                                         A returned failure indicates the end of search.
	                                               NETDEV_FindCloseNonVehRecordList
	*/
	public boolean NETDEV_FindNextNonVehRecordInfo(Pointer lpFindHandle, NETDEV_NON_MOTOR_VEH_RECORD_S pstRecordInfo);

	/**
	* 
	* @param [IN] lpFindHandle                     
	* @return                                      TRUE TRUE means success, and any other value means failure.
	* @note
	*/
	public boolean NETDEV_FindCloseNonVehRecordList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN] udwRecordID                  ID
	 * @param [INOUT] pstFileInfo                 
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  pstFileInfoudwSizeudwSize
	：NETDEV_E_NEED_MORE_MEMORY   
	 */
	public boolean NETDEV_GetVehicleRecordImageInfo(Pointer lpUserID, int udwRecordID, NETDEV_FILE_INFO_S pstFileInfo);

	/**
	 * 
	 * .Batch assigned to the vehicle member in the specified database
	 * @param [IN] lpUserID                  ID User login ID
	 * @param [IN] udwVehicleLibID           ID CaVehicleLibID
	 * @param [IN] pstMemberList             ID Batch assigned vehicle member ID information
	 * @param [OUT] pstBatchResultList                Batch assigned vehicle member ID result
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_AddVehicleLibMember(Pointer lpUserID, int udwVehicleLibID,
											  NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstMemberList,
											  NETDEV_BATCH_OPERATOR_LIST_S pstBatchResultList);

	/**
	 * 
	 * .Batch cancellation to the vehicle member in the specified database
	 * @param [IN] lpUserID                  ID User login ID
	 * @param [IN] udwVehicleLibID           ID VehicleLibID
	 * @param [IN] pstMemberList             ID Batch cancellation vehicle member ID information
	 * @param [OUT] pstBatchResultList                Batch cancellation vehicle member ID result
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_DeleteVehicleLibMember(Pointer lpUserID, int udwVehicleLibID,
												 NETDEV_BATCH_OPERATE_MEMBER_LIST_S pstMemberList,
												 NETDEV_BATCH_OPERATOR_LIST_S pstBatchResultList);

	/**
	 * 
	 * @param [IN]  lpUserID                      ID
	 * @param [INOUT]  pstMonitorInfo                
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note 2M,
	udwMonitorID 
	 */
	public boolean NETDEV_AddVehicleMonitorInfo(Pointer lpUserID, NETDEV_MONITION_INFO_S pstMonitorInfo);

	/**
	 * 
	 * @param [IN]  lpUserIDID
	 * @param [INOUT] pstBatchList              
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_DeleteVehicleMonitorInfo(Pointer lpUserID, NETDEV_BATCH_OPERATOR_LIST_S pstBatchList);

	/**
	 * 
	 * @param [IN]  lpUserID              ID
	 * @return ,0NETDEV_FindNextVehicleMonitorInfoNETDEV_FindCloseVehicleMonitorInfo。
	 * @note
	 */
	public Pointer NETDEV_FindVehicleMonitorList(Pointer lpUserID);

	/**
	 * 
	 * @param [IN]  lpFindHandle            
	 * @param [OUT] pstMonitorInfo            
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  
	0;
	NETDEV_FindVehicleCloseRecordInfo;
	 */
	public boolean NETDEV_FindNextVehicleMonitorInfo(Pointer lpFindHandle, NETDEV_MONITION_INFO_S pstVehicleMonitorInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseVehicleMonitorList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN]  udwID                       ID
	 * @param [INOUT] pstMonitorInfo             ID,
	udwMonitorID  IN
	stMonitorRuleInfo  OUT
	stMonitorRuleInfo.stVehicleImage.udwSize  INOUT
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note 
	：NETDEV_E_NEED_MORE_MEMORY   
	0;
	 */
	public boolean NETDEV_GetVehicleMonitorInfo(Pointer lpUserID, int udwID, NETDEV_MONITION_RULE_INFO_S pstMonitorInfo);

	/**
	 * 
	 * @param [IN]  lpUserID                    ID
	 * @param [IN]  udwID                       ID
	 * @param [IN] pstMonitorInfo            
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note 2M,
	 */
	public boolean NETDEV_SetVehicleMonitorInfo(Pointer lpUserID, int udwID, NETDEV_MONITION_RULE_INFO_S pstMonitorInfo);

	/**
	 * 
	 * Register callback function and receive alarm information, etc.
	 * @param [IN] lpUserID                     ID User login ID
	 * @param [IN] cbVehicleAlarmMessCallBack    Callback function
	 * @param [IN] lpUserData                    User data
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetVehicleAlarmCallBack(Pointer lpUserID, NETDEV_VehicleAlarmMessCallBack_PF cbVehicleAlarmMessCallBack, Pointer lpUserData);

	/**
	 * 
	 * @param [IN] lpUserID                     ID
	 * @param [IN] cbParkAlarmMessCallBack      
	 * @param [IN] lpUserData                   
	 * @return TRUE
	 * @note
	 */
	public boolean NETDEV_SetParkEventCallBack(Pointer lpUserID, NETDEV_ParkEventMessCallBack_PF cbParkAlarmMessCallBack, Pointer lpUserData);





	/**
	 * 
	 * @param [IN]   lpUserID                     ID User login ID
	 * @param [IN]   pstPayOrder                     Order information
	 * @param [OUT]  pstCost                       Parking cost information
	 * @return TRUE
	 * @note
	 */
	public boolean NETDEV_IssuePayOrder(Pointer lpUserID, NETDEV_PARK_PAY_ORDER_INFO_S pstPayOrder, NETDEV_PARK_COST_S pstCost);


	/**
	 * ID, Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)
	 * @param [IN] lpUserID                    User login ID
	 * @param [IN] cbAlarmMessCallBack         Callback function
	 * @param [IN] lpUserData                  User data
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetAlarmFGCallBack(Pointer lpUserID, NETDEV_AlarmMessFGCallBack_PF cbAlarmMessCallBack, Pointer lpUserData);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] pstFindCond                                   
	 * @param [OUT] pstResultInfo                                
	 * @return NULLNETDEV_FindNextACSPermissionGroupInfo,NETDEV_FindCloseACSPermissionGroupInfo
	 * @note NETDEV_FindNextACSPermissionGroupInfoNETDEV_FindCloseACSPermissionGroupInfo
	 */
	public Pointer NETDEV_FindACSPermissionGroupList(Pointer lpUserID, NETDEV_PERSON_QUERY_INFO_S pstQueryCond, NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo);
	/**
	 * 
	 * @param [IN] lpFindHandle                              
	 * @param [OUT] pstACSPermissionInfo                     
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextACSPermissionGroupInfo( Pointer lpFindHandle,NETDEV_ACS_PERMISSION_INFO_S pstACSPermissionInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                                  
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseACSPermissionGroupList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                 ID
	 * @param [IN] pstPermissionGroupInfo        
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_AddACSPersonPermissionGroup(Pointer lpUserID, NETDEV_ACS_PERMISSION_INFO_S pstPermissionGroupInfo,IntByReference pUdwGroupID);
	/**
	 * 
	 * @param [IN] lpUserID                 ID
	 * @param [IN] pstPermissionInfo        
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_ModifyACSPersonPermissionGroup(Pointer lpUserID, NETDEV_ACS_PERMISSION_INFO_S pstPermissionInfo);
	/**
	 * 
	 * @param [IN] lpUserID                 ID
	 * @param [IN] pstPermissionIDList      ID
	 * @param [INOUT]
	 * @param [OUT]
	 * @return
	 */
	public boolean NETDEV_DeleteACSPersonPermissionGroup(Pointer lpUserID, NETDEV_OPERATE_LIST_S pstPermissionIDList,NETDEV_BATCH_OPERATOR_LIST_S pstResutList);

	/**
	 * 
	 * @param [IN] lpUserID                                              ID
	 * @param [IN] udwPermissionGroupID                                  id
	 * @param [INOUT] pstAcsPerssionInfo                                 
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetSinglePermGroupInfo(Pointer lpUserID,int udwPermissionGroupID,NETDEV_ACS_PERMISSION_INFO_S pstAcsPerssionInfo);


	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] dwCommand                                     #NETDEV_ACS_PERSON_COMMOND_TYPE_E
	 * @param [INOUT] pstACSPersonInfo                           
	 * @return TRUE
	 */
	public boolean NETDEV_ACSPersonCtrl(Pointer lpUserID,int dwCommand,NETDEV_ACS_PERSON_INFO_S pstACSPersonInfo);

	/**
	 * 
	 * @param [IN] lpUserID                 ID
	 * @param [IN] pstACSPersonList            2M
	 * @param [OUT] pstResultList           
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_AddACSPersonList(Pointer lpUserID, NETDEV_ACS_PERSON_LIST_S pstACSPersonList,NETDEV_XW_BATCH_RESULT_LIST_S  pstResultList);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [INOUT] pstBatchCtrlInfo                           
	 * @return TRUE
	 */
	public boolean NETDEV_DeleteACSPersonList(Pointer lpUserID,NETDEV_FACE_BATCH_LIST_S pstBatchCtrlInfo);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] pstQueryCond                                  
	 * @param [OUT] pstResultInfo                                
	 * @return NULLNETDEV_FindNextACSPersonInfo,NETDEV_FindCloseACSPersonInfo
	 */
	public Pointer NETDEV_FindACSPersonList(Pointer lpUserID, NETDEV_PERSON_QUERY_INFO_S pstQueryCond, NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                                  
	 * @param [OUT] pstACSPersonInfo                             
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextACSPersonInfo(Pointer lpFindHandle,NETDEV_ACS_PERSON_BASE_INFO_S pstACSPersonInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                                      
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseACSPersonInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] pstFindCond                                   
	 * @param [OUT] pstResultInfo                                
	 * @return NULLNETDEV_FindNextACSAttendanceLog,NETDEV_FindCloseACSAttendanceLogList
	 * @note NETDEV_FindNextACSAttendanceLogNETDEV_FindCloseACSAttendanceLogList
	 */
	public Pointer NETDEV_FindACSAttendanceLogList(Pointer lpUserID,NETDEV_ALARM_LOG_COND_LIST_S pstFindCond,NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                              
	 * @param [OUT] pstACSLogInfo                            
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextACSAttendanceLog(Pointer lpFindHandle,NETDEV_ACS_ATTENDANCE_LOG_INFO_S pstACSLogInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                                  
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseACSAttendanceLogList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] udwACSPersonID                                
	 * @param [OUT] pstACSPersonCardInfo                                
	 * @return TRUE
	 */
	public boolean NETDEV_GetACSPersonCardInfo(Pointer lpUserID,int udwACSPersonID,NETDEV_ACS_PERSON_CARD_INFO_S pstACSPersonCardInfo);


	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] udwACSPersonID                                
	 * @param [INOUT] pstACSPersonCardInfo                           udwCardID
	 * @return TRUE
	 */
	public boolean NETDEV_AddACSPersonCardInfo(Pointer lpUserID,int udwACSPersonID,NETDEV_ACS_PERSON_CARD_INFO_S pstACSPersonCardInfo);

	/**
	 * ()
	 * @param [IN] lpUserID                                       ID
	 * @param [IN] udwACSPersonID                                      
	 * @return TRUE
	 */
	public boolean NETDEV_DeleteACSPersonCardInfo(Pointer lpUserID,int udwACSPersonID);

	/**
	 * 
	 * @param [IN] lpUserID              ID
	 * @param [IN] udwPersonID           
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_ACSPersonSignout(Pointer lpUserID, int udwPersonID);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] pstFindCond                                   
	 * @param [OUT] pstResultInfo                                
	 * @return NULLNETDEV_FindNextACSVisitLog,NETDEV_FindCloseACSVisitLog
	 */
	public Pointer NETDEV_FindACSVisitLogList(Pointer lpUserID,NETDEV_ALARM_LOG_COND_LIST_S pstFindCond,NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                              
	 * @param [OUT] pstACSLogInfo                            
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextACSVisitLog(Pointer lpFindHandle,NETDEV_ACS_VISIT_LOG_INFO_S pstACSLogInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                                  
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseACSVisitLog(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] pstBlackListInfo          
	 *@param [OUT] pUdwBlackListID          ID
	 * @return
	 */
	public boolean NETDEV_AddACSPersonBlackList(Pointer lpUserID, NETDEV_ACS_PERSON_BLACKLIST_INFO_S pstBlackListInfo, IntByReference pUdwBlackListID);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] pstBlackList               
	 * @return
	 */
	public boolean NETDEV_DeleteACSPersonBlackList(Pointer lpUserID, NETDEV_OPERATE_LIST_S pstBlackList);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] pstBlackListInfo          
	 * @return
	 */
	public boolean NETDEV_ModifyACSPersonBlackList(Pointer lpUserID, NETDEV_ACS_PERSON_BLACKLIST_INFO_S pstBlackListInfo);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] pstBlackListInfo          udwBlackListID
	 * @return
	 */
	public boolean NETDEV_GetACSPersonBlackList(Pointer lpUserID,NETDEV_ACS_PERSON_BLACKLIST_INFO_S pstBlackListInfo);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] pstFindCond                                   
	 * @param [OUT] pstResultInfo                                
	 * @return NULLNETDEV_FindNextACSPersonBlackList,NETDEV_FindCloseACSPersonBlackList
	 * @note NETDEV_FindNextACSPersonBlackListNETDEV_FindCloseACSPersonBlackList
	 */
	public Pointer NETDEV_FindACSPersonBlackList(Pointer lpUserID, NETDEV_PAGED_QUERY_INFO_S pstQueryCond, NETDEV_BATCH_OPERATE_BASIC_S pstResultInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle                              
	 * @param [OUT] pstACSPermissionInfo                     
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextACSPersonBlackListInfo( Pointer lpFindHandle,NETDEV_ACS_PERSON_BLACKLIST_INFO_S pstBlackListInfo);
	/**
	 * 
	 * @param [IN] lpFindHandle                                 
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseACSPersonBlackList(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                       ID
	 * @param [IN] udwPersonID                    ID
	 * @param [INOUT] pstPermissionInfo           
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetACSPersonPermission(Pointer lpUserID,int udwPersonID,NETDEV_ACS_DOOR_PERMISSION_INFO_S pstPermissionInfo);

	/**
	 * 
	 * @param [IN] lpUserID                       ID
	 * @param [IN] udwPersonID                      ID
	 * @param [IN] pstPermissionInfo              
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_SetACSPersonPermission(Pointer lpUserID, int udwPersonID, NETDEV_ACS_DOOR_PERMISSION_INFO_S pstPermissionInfo);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] dwChannelID                                   
	 * @param [IN] dwCommand                                     #NETDEV_DOORCTRL_ACTION_TYPE_E
	 * @return TRUE
	 */
	public boolean NETDEV_DoorCtrl(Pointer lpUserID,int dwChannelID,int dwCommand);

	/**
	 * 
	 * @param [IN] lpUserID                                      ID
	 * @param [IN] dwCommand                                     #NETDEV_DOORCTRL_ACTION_TYPE_E
	 * @param [IN] pstBatchCtrlInfo                              
	 * @return TRUE
	 */
	public boolean NETDEV_DoorBatchCtrl(Pointer lpUserID,int dwCommand,NETDEV_OPERATE_LIST_S pstBatchCtrlInfo);

	/**
	 *  Get device System time configuration
	 * @param [IN]  lpUserID    id
	 * @param [OUT]  pstSystemTimeInfo      Pointer to time configuration structure
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 * @note win32 VMS
	 */
	public boolean  NETDEV_GetSystemTimeCfg(Pointer lpUserID, NETDEV_TIME_CFG_S stSystemTimeInfo);

	/**
	 *  Set device system time configuration
	 * @param [IN]  lpUserID    id
	 * @param [IN]  pstSystemTimeInfo      Pointer to time configuration structure
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 * @note win32 VMS
	 */
	public boolean NETDEV_SetSystemTimeCfg(Pointer lpUserID, NETDEV_TIME_CFG_S pstSystemTimeInfo);

	/**
	 *  Get UPnP net state info
	 * @param [IN]   lpUserID      User login ID
	 * @param [IN]   pstNatState   UPnP nat state info
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 NVR IPC
	 */
	public boolean NETDEV_GetUpnpNatState(Pointer lpUserID, NETDEV_UPNP_NAT_STATE_S pstNatState);

	/**
	 *  Set UPnP net state info
	 * @param [IN]   lpUserID                   User login ID
	 * @param [IN]   pstNatState                UPnP nat state info
	 * @return TRUE,  TRUE means success, and any other value means failure.
	 * @note win64 IPC
	 */
	public boolean NETDEV_SetUpnpNatState(Pointer lpUserID, NETDEV_UPNP_NAT_STATE_S pstNatState);

	/**
	 * /Telnet
	 * @param [IN]   lpUserID                    ID User login ID
	 * @param [IN]   bEnable                     telnet
	 * @return TRUE
	 * @note win64 NVR
	 */
	public boolean NETDEV_EnableTelnet(Pointer lpUserID, int bEnable);

	/**
	 * ID
	 * @param [IN] lpUserID              ID
	 * @param [IN] dwChnID               ID
	 * @param [IN] dwChnType             ,# NETDEV_CHN_TYPE_E
	 * @param [INOUT] lpOutBuffer        
	 * @param [IN] dwOutBufferSize       ()0
	 * @param [OUT] pdwBytesReturned     NULL
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_GetChnDetailByChnType(Pointer lpUserID, int dwChnID, int dwChnType, Pointer lpOutBuffer, int dwOutBufferSize, IntByReference pdwBytesReturned);

	/**
	 * ID
	 * @param [IN] lpUserID              ID
	 * @param [IN] dwChnID               ID
	 * @param [IN] dwChnType             ,# NETDEV_CHN_TYPE_E
	 * @param [IN] lpOutBuffer          
	 * @param [IN] dwOutBufferSize       ()0
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_SetChnDetailByChnType(Pointer lpUserID, int dwChnID, int dwChnType, Pointer lpOutBuffer, int dwOutBufferSize);

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] pstStatisticCond        
	 * @param [OUT] pudwSearchID           ID
	 * @return TRUE
	 */
	public boolean NETDEV_StartMultiTrafficStatistic(Pointer lpUserID, NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S pstStatisticCond, IntByReference pudwSearchID);

	/**
	 * 
	 * @param [IN]  lpUserID               ID
	 * @param [IN]  udwSearchID            ID
	 * @param [OUT] pudwProgress           
	 * @return TRUE
	 */
	public boolean NETDEV_GetTrafficStatisticProgress(Pointer lpUserID, int udwSearchID, IntByReference pudwProgress);

	/**
	 * 
	 * @param [IN] lpUserID                        ID
	 * @param [IN] udwSearchID                     ID
	 * @return TRUE
	 */
	public boolean NETDEV_StopTrafficStatistic(Pointer lpUserID, int udwSearchID);

	/**
	 * 
	 * @param [IN] lpUserID                ID
	 * @param [IN] udwSearchID             ID
	 * @return (NETDEV_FindNextTrafficStatisticInfo, NETDEV_FindCloseTrafficStatisticInfo)NULL
	 */
	public Pointer NETDEV_FindTrafficStatisticInfoList(Pointer lpUserID, int udwSearchID);

	/**
	 * 
	 * @param [IN] lpFindHandle                
	 * @param [OUT] pstStatisticInfo           
	 * @return TRUE
	 */
	public boolean NETDEV_FindNextTrafficStatisticInfo(Pointer lpFindHandle, NETDEV_TRAFFIC_STATISTICS_INFO_S pstStatisticInfo);

	/**
	 * 
	 * @param [IN] lpFindHandle
	 * @return TRUE
	 */
	public boolean NETDEV_FindCloseTrafficStatisticInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]   lpUserID                  ID User login ID
	 * @param [IN]   pszConfigPath             ,tgz
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetConfigFile(Pointer lpUserID, String pszConfigPath);

	/**
	 * 
	 * @param [IN]   lpUserID                  ID User login ID
	 * @param [IN]   pszConfigPath             ,：_IP_config.tgz, ：HIC5621E-L-U_192.168.3.112_config.tgz
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_SetConfigFile(Pointer lpUserID, String pszConfigPath);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   dwUpgradeType           #NETDEV_UPGRADE_TYPE_E
	 * @param [INOUT]  pszTaskNo             ,#NETDEV_LEN_64
	 * @return TRUE,
	 * @note IPC,IPC10s
	 * @note 10s NETDEV_UploadFirmware
	 */
	public boolean NETDEV_UpgradeDevice(Pointer lpUserID, int dwUpgradeType, String pszTaskNo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   pszPath                 
	 * @param [IN]  pszTaskNo                
	 * @return TRUE,
	 * @note IPC
	 */
	public boolean NETDEV_UploadDeviceFirmware(Pointer lpUserID, String pszPath, String pszTaskNo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   dwChannelID             ID
	 * @param [OUT]  pstUpgradeStatus        
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_GetUpgradeStatus(Pointer lpUserID, int dwChannelID, NETDEV_UPGRADE_STATUS_S pstUpgradeStatus);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @param [IN]   pstUpgradeInfo          
	 * @param [INOUT]  pszTaskNo            ,#NETDEV_LEN_64
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_UpgradeDeviceChl(Pointer lpUserID, NETDEV_UPGRADE_DEVICE_S pstUpgradeInfo, String pszTaskNo);

	/**
	 * 
	 * @param [IN] lpUserID                 ID
	 * @param [OUT] pstDeviceInfo         
	 * @return TRUE
	 * @note
	 */
	public boolean NETDEV_GetDeviceBaseInfo(Pointer lpUserID, NETDEV_DEVICE_BASE_INFO_S pstDeviceInfo);

	/**
	 * SDK Get SDK version information
	 * @return int SDK SDK version information
	 * @note
	 * - 8,.0x01080000：1.8.0.0.
	 * - The two high bytes,The high-8-bit indicate the major version, and the low-8-bytes indicate the minor version.Two low bytes for additional version numbers For example, 0x01080000 means version 1.8.0.0
	 */
	public int NETDEV_GetSDKVersion();

	/**
	 * IP
	 * @param [IN]   pstDevAddrInfo         
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_ModifyDeviceAddr(NETDEV_DEV_ADDR_INFO_S pstDevAddrInfo);

	/**
	 *   Query video channel info
	 * @param [IN]   lpUserID            User login ID
	 * @param [IN]   dwChannelID         Channel ID
	 * @param [OUT]  pstVideoChlInfo     video channel info
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_QueryVideoChlInfo(Pointer lpUserID, int dwChannelID, NETDEV_VIDEO_CHL_DETAIL_INFO_S pstVideoChlInfo);

	/**
	 * 
	 * @param [IN]   lpUserID                ID User login ID
	 * @return ,0,NETDEV_FindNextChlDeviceInfo.
	 * @note ,0,：
	 *         .NETDEV_FindNextDeviceChlInfolpFindHandle,NETDEV_FindNextDeviceChlInfo,.
	 *         .,NETDEV_FindCloseDeviceChlListlpFindHandle,NETDEV_FindCloseDeviceChlList,,.
	 */
	public Pointer NETDEV_FindDevChlBasicInfoList(Pointer lpUserID);

	/**
	 * 
	 * @param [IN]   lpFindHandle                Handle
	 * @param [OUT]  pstDeviceInfo               
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_FindNextDevChlBasicInfo(Pointer lpFindHandle, NETDEV_DEVICE_CHL_INFO_S pstDeviceInfo);

	/**
	 * 
	 * @param [IN]   lpFindHandle                Handle
	 * @return TRUE,
	 * @note
	 */
	public boolean NETDEV_FindCloseDevChlBasicInfo(Pointer lpFindHandle);

	/**
	 * URL Obtain Live view stream url
	 * @param [IN]  lpUserID             ID User login ID
	 * @param [IN]  dwChannelID           Channel number
	 * @param [IN]  dwStreamType          #NETDEV_LIVE_STREAM_INDEX_E   Stream type see enumeration#NETDEV_LIVE_STREAM_INDEX_E
	 * @param [OUT] pszStreamUrl         URL Stream URL,NETDEV_LEN_260 The length must exceed NETDEV_LEN_260
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetStreamUrl(Pointer lpUserID, int dwChannelID, int dwStreamType, Pointer pszStreamUrl);

	/**
	 * URL Obtain replay url
	 * @param [IN]  lpUserID             ID User login ID
	 * @param [IN]  dwChannelID           Channel number
	 * @param [IN]  dwStreamType          #NETDEV_LIVE_STREAM_INDEX_E   Stream type see enumeration#NETDEV_LIVE_STREAM_INDEX_E
	 * @param [OUT] pszReplayUrl  URL,NETDEV_LEN_260 The length must exceed NETDEV_LEN_260
	 * @return TRUE, TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_GetReplayUrl(Pointer lpUserID, int dwChannelID, int dwStreamType, Pointer pszReplayUrl);

	/**
	 * 
	 * @param [IN] lpPlayHandle           
	 * @param [OUT] pstGroupInfo          
	 * @return TRUE
	 */
	public boolean NETDEV_GetVoiceBroadcastChlStatus(Pointer lpPlayHandle, NETDEV_VOICE_BROADCAST_GROUP_INFO_S pstGroupInfo);

	/**
	 * 
	 * @parma [IN] lpUserID              ID
	 * @param [IN] pstChnList            
	 * @return NULL
	 */
	public Pointer NETDEV_CreateVoiceBroadcastGroup(Pointer lpUserID, NETDEV_OPERATE_LIST_S pstChnList);

	/**
	 * 
	 * @param [IN] lpPlayHandle          
	 * @param [IN] pstModifyInfo         
	 * @return TRUE
	 */
	public boolean NETDEV_ModifyVoiceBroadcastGroup(Pointer lpPlayHandle, NETDEV_MODIFY_VOICE_BROADCAST_INFO_S pstModifyInfo);

	/**
	 * /
	 * @param [IN] lpPlayHandle          
	 * @param [IN] pstCtrlInfo           
	 * @return TRUE
	 */
	public boolean NETDEV_ModifyVoiceBroadcastStatus(Pointer lpPlayHandle, NETDEV_VOICE_BROADCAST_CTRL_INFO_S pstCtrlInfo);

	/**
	 * T2U
	 * @param [IN]   dwT2UPayload         T2U,MTU:101-1500 1500。
	 * @return TRUE TRUE means success, and any other value means failure.
	 */
	public boolean NETDEV_SetT2UPayLoad(int dwT2UPayload);

	/**
	 *  Search NVR log by log type and time
	 * @param [IN]  lpUserID               ID User login ID
	 * @param [IN]  pstLogFindCond         Log search condition
	 * @return ,NETDEV_E_FAILEDNETDEV_CloseFindLog。
	Log search service number. NETDEV_E_FAILED means failure, and any other value is used as the parameter of functions like NETDEV_CloseFindLog.
	 * @note VMSNVR
	 */
	public Pointer NETDEV_FindLogInfoList(Pointer lpUserID, NETDEV_FIND_LOG_COND_S pstLogFindCond);

	/**
	 *  Obtain logone by one
	 * @param [IN]  lFindHandle            Log search handle
	 * @param [OUT] pstFindData            Pointer to saved log info
	 * @return NETDEV_E_SUCCEED NETDEV_E_SUCCEED means success, and any other value means failure
	 * @note
	 */
	public boolean NETDEV_FindNextLogInfo(Pointer lpFindHandle, NETDEV_LOG_INFO_S pstLogInfo);

	/**
	 *  Close log search and release resource
	 * @param [IN]  lFindHandle            File search handle
	 * @return NETDEV_E_SUCCEED NETDEV_E_SUCCEED means success, and any other value means failure
	 * @note
	 */
	public boolean NETDEV_FindCloseLogInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]  lpUserID             ID
	 * @param [IN]  pstAlarmFindCond     
	 * @return ,NETDEV_E_FAILEDNETDEV_CloseFindAlarm。
	 * @note
	 */
	public Pointer NETDEV_FindAlarmInfoList(Pointer lpUserID,  NETDEV_FIND_ALARM_COND_S pstAlarmFindCond);

	/**
	 * 
	 * @param [IN]  lFindHandle    
	 * @param [OUT] pstAlarmInfo   
	 * @return NETDEV_E_SUCCEED
	 * @note
	 */
	public boolean NETDEV_FindNextAlarmInfo(Pointer lpFindHandle, NETDEV_FIND_ALARM_INFO_S pstAlarmInfo);

	/**
	 * 
	 * @param [IN]  lFindHandle  
	 * @return NETDEV_E_SUCCEED
	 * @note
	 */
	public boolean NETDEV_FindCloseAlarmInfo(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN] lpUserID                  ID
	 * @param [IN] pstFindCond               
	 * @param [OUT] pdwTotalRealRow          
	 * @return ,0NETDEV_FindNextAlarmLogNETDEV_FindCloseAlarmLog。
	 * @note 1
	 */
	public Pointer NETDEV_FindAlarmLogList(Pointer lpUserID,  NETDEV_ALARM_LOG_COND_LIST_S pstFindCond, IntByReference pdwTotalRealRow);

	/**
	 * 
	 * @param [IN]  lpFindHandle                 
	 * @param [OUT] pstAlarmLogInfo              
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note  A returned failure indicates the end of search.
	 */
	public boolean NETDEV_FindNextAlarmLog(Pointer lpFindHandle, NETDEV_ALARM_LOG_INFO_S pstAlarmLogInfo);

	/**
	 *  
	 * @param [IN] lpFindHandle  
	 * @return TRUE TRUE means success, and any other value means failure.
	 * @note
	 */
	public boolean NETDEV_FindCloseAlarmLog(Pointer lpFindHandle);

	/**
	 * URL
	 * @param [IN]  lpUserID                     
	 * @param [IN]  pstAlarmSnapShotCond         
	 * @return  ,NULLNETDEV_GetNextAlarmSnapShotURLNETDEV_CloseGetAlarmSnapShotURL。
	 * @note
	 */
	public Pointer NETDEV_FindAlarmSnapShotURL(Pointer lpUserID, NETDEV_ALARM_SNAPSHOT_COND_S pstAlarmSnapShotCond);

	/**
	 * 
	 * @param [IN]  lpFindHandle                     
	 * @param [OUT]  pstAlarmPicInfo         
	 * @return  TRUE
	 * @note
	 */
	public boolean NETDEV_FindNextAlarmSnapShotURL(Pointer lpFindHandle, NETDEV_ALARM_SNAPSHOT_PIC_S pstAlarmPicInfo);

	/**
	 * FindHandle
	 * @param [IN]  lpFindHandle                     
	 * @return  TRUE
	 * @note
	 */
	public boolean NETDEV_FindCloseAlarmSnapShotURL(Pointer lpFindHandle);

	/**
	 * 
	 * @param [IN]  lpUserID                     
	 * @param [IN]  pstPicFileInfo           
	 * @return  TRUE
	 * @note
	 */
	public boolean NETDEV_SaveSnapShotFile(Pointer lpUserID, NETDEV_PIC_FILE_INFO_S pstPicFileInfo);

	/**
	* 
	* @param [IN]   lpUserID                     User login ID
	* @param [IN]   pstStartInfo                 Query start information
	* @param [OUT]  pudwSearchID                 Search ID
	* @return TRUE,
	* @note
	*/
	public boolean NETDEV_StartObjectSearch(Pointer lpUserID, NETDEV_QUERY_CHN_CONDITION_S pstStartInfo, IntByReference pudwSearchID);
	
	/**
	* 
	* @param [IN]   lpUserID                     User login ID
	* @param [IN]   udwSearchID                  Search ID
	* @param [OUT]  pudwPercent                  Query Percent
	* @return TRUE,
	* @note
	*/
	public boolean NETDEV_GetObjectSearchProg(Pointer lpUserID, int udwSearchID, IntByReference pudwPercent);

	/**
	* 
	* @param [IN]   lpUserID                     User login ID
	* @param [IN]   pstQueryCond                 Query Condition
	* @param [OUT]  pstQueryResult               Query Result
	* @return ,0,：
	*         .NETDEV_FindNextObjectSearchInfolpFindHandle,NETDEV_FindNextObjectSearchInfo,.
	*         .,NETDEV_FindCloseObjectSearchListlpFindHandle,NETDEV_FindCloseObjectSearchList,,.
	* @note
	*/
	public Pointer NETDEV_FindObjectSearchList(Pointer lpUserID, NETDEV_PIC_QUERY_COND_S pstQueryCond, NETDEV_PIC_QUERY_RESULT_S pstQueryResult);
	
	/**
	* 
	* @param [IN]   lpFindHandle                     Query handle
	* @param [INOUT]  pstObjectResultInfo              Object Result information
	* @return TRUE,
	* @note
	*/
	public boolean NETDEV_FindNextObjectSearchInfo(Pointer lpFindHandle, NETDEV_OBJECT_RESULT_INFO_S pstObjectResultInfo);
	
	/**
	* ,
	* @param [IN]   lpFindHandle                     Qearch handle
	* @return TRUE,
	* @note
	*/
	public boolean NETDEV_FindCloseObjectSearchList(Pointer lpFindHandle);
	
	/**
	* 
	* @param [IN]   lpUserID                         User login ID
	* @param [IN]   udwSearchID                      Search ID
	* @return TRUE,
	* @note
	*/
	public boolean NETDEV_StopObjectSearch(Pointer lpUserID, int udwSearchID);
	
	/**
	*   
	* @param [IN]  lpUserID                          ID User login ID
    * @param [IN]  dwAlarmID                          ID Alarm ID
    * @return 0,,NETDEV_FindNextAlarmRelatedDataInfoNETDEV_FindCloseAlarmRelatedDataList
    * @note VMS
	*/
	public Pointer NETDEV_FindAlarmRelatedDataList(Pointer lpUserID, int dwAlarmID);
	
	/**
	*   
	* @param [IN]  lpFindHandle                
	* @param [OUT] pstAlarmRelatedData         
	* @return TRUE
	* @note VMSNVR
	*/
	public boolean NETDEV_FindNextAlarmRelatedDataInfo(Pointer lpFindHandle, NETDEV_ALARM_RELATED_DATA_S pstAlarmRelatedData);
	
	/**
	*   
	* @param [IN]  lpFindHandle                
	* @return TRUE
	* @note VMSNVR
	*/
	public boolean NETDEV_FindCloseAlarmRelatedDataList(Pointer lpFindHandle);
	
	/**
	*  Obtain device capability
	* @param [IN]   lpUserID                 User login ID
	* @param [IN]  dwChannelID               Channel ID
	* @param [IN]   dwCommand                NETDEV_CAPABILITY_COMMOND_E
	* @param [OUT]  lpOutBuffer              Pointer to buffer that receives data
	* @param [OUT]  dwOutBufferSize         ()0 Length (in byte) of buffer that receives data, cannot be 0.
	* @param [OUT]  pdwBytesReturned        NULL  Pointer to length of received data, cannot be NULL.
	* @return TRUE      TRUE means success, and any other value means failure.
	* @note
	*/
	public boolean NETDEV_GetDeviceCapability(Pointer lpUserID, int dwChannelID, int dwCommand, Pointer lpOutBuffer, int  dwOutBufferSize, IntByReference pdwBytesReturned);

	
	/**
	* 
	* @param [IN]  lpUserID                        ID User login ID
	* @param [IN]  pszFilePath                      PCM100K
	* @return TRUE
	* @note 
	*/
	public boolean NETDEV_ImportAudioFile(Pointer lpUserID, String  pszFilePath);
	
	/**
	* 
	* @param [IN]  lpUserID                        ID User login ID
	* @param [IN]  udwChannelID                    ID Channel ID
	* @param [OUT] pstAudioOutputCfg                Audio OutPut Config
	* @return TRUE
	* @note 
	*/
	public boolean NETDEV_GetAudioOutputCfg(Pointer lpUserID,  int udwChannelID,  NETDEV_AUDIO_OUTPUT_CFG_S pstAudioOutputCfg);
	
	/**
	* 
	* @param [IN]  lpUserID                        ID User login ID
	* @param [IN]  udwChannelID                    ID Channel ID
	* @param [IN]  pstAudioOutputCfg                Audio OutPut Config
	* @return TRUE
	* @note 
	*/
	public boolean NETDEV_SetAudioOutputCfg(Pointer lpUserID, int udwChannelID, NETDEV_AUDIO_OUTPUT_CFG_S pstAudioOutputCfg);

}